/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.web;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IDriverWS;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IMonitoraggioRisorsa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.CredenzialiSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzioneFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloContesto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.web.XMLLib;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.slf4j.Logger;

public class DriverRegistroServiziWEB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public DriverRegistroServiziWEB(String urlPrefix, Logger alog) {
        this(urlPrefix, null, alog);
    }

    public DriverRegistroServiziWEB(String urlPrefix, String pathPrefix, Logger alog) {
        try {
            this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverRegistroServiziWEB.class) : alog;
            this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
            try {
                this.validatoreRegistro = new ValidatoreXSD(this.log, DriverRegistroServiziWEB.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (pathPrefix != null) {
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = true;
        }
        catch (Exception e) {
            this.log.error("Inizializzazione fallita: " + e.getMessage());
            this.create = false;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo cooperazione non fornito");
        }
        AccordoCooperazione accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordo);
        String urlXMLAccordoCooperazione = this.urlPrefix + "accordi_cooperazione/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoCooperazione] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoCooperazione[] acList = this.generatoreXML.getAccordiCooperazione();
            if (acList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < acList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName_accordoCooperazione(this.idAccordoCooperazioneFactory.getUriFromAccordo(acList[i]));
                String acUrlXML = this.urlPrefix + "accordi_cooperazione/" + fileName + ".xml";
                String acURI = this.idAccordoCooperazioneFactory.getUriFromAccordo(acList[i]);
                try {
                    this.validatoreRegistro.valida(acUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + acUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (acList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di servizio [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (acList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !acList[i].getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !acList[i].getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (acList[i].getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !acList[i].getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !acList[i].getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromValues(acList[i].getNome(), acList[i].getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Nome accordo servizio non fornito");
        }
        AccordoServizioParteComune accRichiesto = null;
        String fileName = this.generatoreXML.mappingIDAccordoToFileName(idAccordo);
        String urlXMLAccordoServizio = this.urlPrefix + "accordi/" + fileName + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[AccordoServizioParteComune] Accordo richiesto non esiste: " + fileName);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[AccordoServizioParteComune] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoServizioParteComuneList() > 0) {
                accRichiesto = rs.getAccordoServizioParteComune(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[AccordoServizioParteComune] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[AccordoServizioParteComune] Accordo di Servizio non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizioParteComune[] asList = this.generatoreXML.getAccordiServizioParteComune();
            if (asList == null) {
                throw new DriverRegistroServiziNotFound("Accordi non esistenti nel repository WEB");
            }
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < asList.length; ++i) {
                String fileName = this.generatoreXML.mappingUriToFileName(this.idAccordoFactory.getUriFromAccordo(asList[i]));
                String asUrlXML = this.urlPrefix + "accordi/" + fileName + ".xml";
                String asURI = this.idAccordoFactory.getUriFromAccordo(asList[i]);
                try {
                    this.validatoreRegistro.valida(asUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] Riscontrato errore durante la validazione XSD (" + asUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiServizio](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (asList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiServizio](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (asList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !asList[i].getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !asList[i].getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (asList[i].getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !asList[i].getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !asList[i].getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                    if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                        if (asList[i].getServizioComposto() == null) continue;
                        IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(asList[i].getServizioComposto().getAccordoCooperazione());
                        if (filtroRicerca.getIdAccordoCooperazione().getNome() != null && !idAC.getNome().equals(filtroRicerca.getIdAccordoCooperazione().getNome()) || filtroRicerca.getIdAccordoCooperazione().getVersione() != null && !idAC.getVersione().equals(filtroRicerca.getIdAccordoCooperazione().getVersione())) {
                            continue;
                        }
                    } else if (filtroRicerca.isServizioComposto() != null && (filtroRicerca.isServizioComposto() != false ? asList[i].getServizioComposto() == null : asList[i].getServizioComposto() != null)) continue;
                }
                idAccordi.add(this.idAccordoFactory.getIDAccordoFromValues(asList[i].getNome(), BeanUtilities.getSoggettoReferenteID(asList[i].getSoggettoReferente()), asList[i].getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteComune error", e);
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.urlPrefix + "porte_di_dominio/" + nomePdD + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata.");
        }
        return pddRichiesta;
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdPorteDominio] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            PortaDominio[] pddList = this.generatoreXML.getPorteDominio();
            if (pddList == null) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non esistenti nel repository WEB");
            }
            Vector<String> nomiPdd = new Vector<String>();
            for (int i = 0; i < pddList.length; ++i) {
                String pdUrlXML = this.urlPrefix + "porte_di_dominio/" + pddList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(pdUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + pdUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pddList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pddList[i].getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pddList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pddList[i].getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pddList[i].getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return nomiPdd;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idRuolo == null || idRuolo.getNome() == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro Non Valido");
        }
        Ruolo ruoloRichiesto = null;
        String urlXMLPortaDominio = this.urlPrefix + "ruoli/" + idRuolo.getNome() + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste: " + idRuolo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getRuolo] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeRuoloList() > 0) {
                ruoloRichiesto = rs.getRuolo(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getRuolo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (ruoloRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo non trovato.");
        }
        return ruoloRichiesto;
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdRuoli] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Ruolo[] ruoloList = this.generatoreXML.getRuoli();
            if (ruoloList == null) {
                throw new DriverRegistroServiziNotFound("Ruoli non esistenti nel repository WEB");
            }
            ArrayList<IDRuolo> idRuoli = new ArrayList<IDRuolo>();
            for (int i = 0; i < ruoloList.length; ++i) {
                String ruoloUrlXML = this.urlPrefix + "ruoli/" + ruoloList[i].getNome() + ".xml";
                try {
                    this.validatoreRegistro.valida(ruoloUrlXML);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Riscontrato errore durante la validazione XSD (" + ruoloUrlXML + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ruoloList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMinDate) Ruolo [" + ruoloList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruoloList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ruoloList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMaxDate) Ruolo [" + ruoloList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruoloList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !ruoloList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia()) && (ruoloList[i].getTipologia() == null || !RuoloTipologia.QUALSIASI.equals(ruoloList[i].getTipologia()) && !ruoloList[i].getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (ruoloList[i].getContestoUtilizzo() == null || !RuoloContesto.QUALSIASI.equals(ruoloList[i].getContestoUtilizzo()) && !ruoloList[i].getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDRuolo id = new IDRuolo(ruoloList[i].getNome());
                idRuoli.add(id);
            }
            if (idRuoli.size() == 0) {
                throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idRuoli;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipo = idSoggetto.getTipo();
        String nome = idSoggetto.getNome();
        if (tipo == null || nome == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        Soggetto soggRichiesto = null;
        String idSoggettoXML = tipo + nome;
        String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoList() > 0) {
                soggRichiesto = rs.getSoggetto(0);
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato.");
        }
        return soggRichiesto;
    }

    @Override
    public Soggetto getSoggettoAutenticatoBasic(String user, String password) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoSsl(String subject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, principal);
    }

    private Soggetto _getSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String subject, String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case SSL: {
                if (subject != null && !"".equalsIgnoreCase(subject)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        IDSoggetto idSoggetto = null;
        try {
            FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
            CredenzialiSoggetto credenzialiSoggetto = new CredenzialiSoggetto();
            credenzialiSoggetto.setTipo(tipoCredenziale);
            switch (tipoCredenziale) {
                case BASIC: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    break;
                }
                case SSL: {
                    credenzialiSoggetto.setSubject(subject);
                    break;
                }
                case PRINCIPAL: {
                    credenzialiSoggetto.setUser(principal);
                }
            }
            filtroRicerca.setCredenzialiSoggetto(credenzialiSoggetto);
            List<IDSoggetto> l = this.getAllIdSoggetti(filtroRicerca);
            if (l.size() > 1) {
                throw new DriverRegistroServiziException("Trovato pi\u00f9 di un soggetto che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
            }
            if (l.size() == 1) {
                idSoggetto = l.get(0);
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
        }
        return this.getSoggetto(idSoggetto);
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            Soggetto[] ssList = this.generatoreXML.getSoggetti();
            if (ssList == null) {
                throw new DriverRegistroServiziNotFound("Soggetti non esistenti nel repository WEB");
            }
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < ssList.length; ++i) {
                String idSoggettoXML = ssList[i].getTipo() + ssList[i].getNome();
                String urlXMLSoggetto = this.urlPrefix + idSoggettoXML + "/" + idSoggettoXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetto);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetto + "): " + e.getMessage(), e);
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ssList[i].getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ssList[i].getTipo() + "/" + ssList[i].getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ssList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ssList[i].getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ssList[i].getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ssList[i].getPortaDominio().equals(filtroRicerca.getNomePdd())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (ssList[i].getRuoli() == null) continue;
                        boolean contains = false;
                        for (int j = 0; j < ssList[i].getRuoli().sizeRuoloList(); ++j) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(ssList[i].getRuoli().getRuolo(j).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto() != null) {
                        CredenzialiSoggetto credenziali = ssList[i].getCredenziali();
                        if (credenziali == null || filtroRicerca.getCredenzialiSoggetto().getTipo() != null && (credenziali.getTipo() != null ? !filtroRicerca.getCredenzialiSoggetto().getTipo().equals(credenziali.getTipo()) : !filtroRicerca.getCredenzialiSoggetto().getTipo().equals(CredenzialeTipo.SSL))) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getUser() != null && !filtroRicerca.getCredenzialiSoggetto().getUser().equals(credenziali.getUser()) || filtroRicerca.getCredenzialiSoggetto().getPassword() != null && !filtroRicerca.getCredenzialiSoggetto().getPassword().equals(credenziali.getPassword())) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                            try {
                                if (credenziali.getSubject() == null || !Utilities.sslVerify(credenziali.getSubject(), filtroRicerca.getCredenzialiSoggetto().getSubject(), this.log)) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverRegistroServiziException(e.getMessage(), e);
                            }
                        }
                    }
                }
                IDSoggetto idS = new IDSoggetto(ssList[i].getTipo(), ssList[i].getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idSoggetti;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Soggetto) Non Validi");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String idSoggettoXML = tipoSogg + nomeSogg;
        String idServizioXML = tipoServizio + servizio;
        String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + idServizioXML + ".xml";
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizio] Il servizio [" + idService.getTipoServizio() + "/" + idService.getServizio() + "] erogato dal soggetto [" + idService.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.getServizio().setNomeSoggettoErogatore(idService.getSoggettoErogatore().getNome());
                servRichiesto.getServizio().setTipoSoggettoErogatore(idService.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizio] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String nomeSoggetto = idSoggetto.getNome();
        String tipoSoggetto = idSoggetto.getTipo();
        if (nomeSoggetto == null || tipoSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri (Soggetto) Non Validi");
        }
        if (idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri (Accordo) Non Valido");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String idSoggettoXML = tipoSoggetto + nomeSoggetto;
        String urlXMLIndexServizi = this.urlPrefix + idSoggettoXML + "/servizi/servizi.index";
        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        IDServizio[] lista = null;
        try {
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLIndexServizi);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede un index dei servizi erogati");
                }
                throw e;
            }
            lista = XMLLib.mappingIndexServizi(new String(fileXML));
            if (lista == null) {
                throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede una lista di servizi erogati");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante la get Servizi List Index: " + e.getMessage(), e);
        }
        String urlXMLServizio = null;
        String tipoServizio = null;
        String nomeServizio = null;
        try {
            for (int i = 0; i < lista.length; ++i) {
                if (!uriAccordo.equals(lista[i].getUriAccordo()) || !TipologiaServizio.CORRELATO.toString().equals(lista[i].getTipologiaServizio()) || !idSoggetto.getTipo().equals(lista[i].getSoggettoErogatore().getTipo()) || !idSoggetto.getNome().equals(lista[i].getSoggettoErogatore().getNome())) continue;
                urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + lista[i].getTipoServizio() + lista[i].getServizio() + ".xml";
                tipoServizio = lista[i].getTipoServizio();
                nomeServizio = lista[i].getServizio();
                break;
            }
            if (urlXMLServizio == null) {
                throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il soggetto [" + idSoggetto + "] non possiede un servizio correlato che implementa l'accordo con uri [" + uriAccordo + "]");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante la ricerca: " + e.getMessage(), e);
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Il servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + idSoggetto + "] non risulta gia' registrato nel registro");
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.getServizio().setNomeSoggettoErogatore(idSoggetto.getNome());
                servRichiesto.getServizio().setTipoSoggettoErogatore(idSoggetto.getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante il parsing xml: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizioParteSpecifica[] servList = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (servList == null) {
                throw new DriverRegistroServiziNotFound("Servizi non esistenti nel repository WEB");
            }
            Vector<IDAccordo> idServizi = new Vector<IDAccordo>();
            for (int i = 0; i < servList.length; ++i) {
                String idSoggettoXML = servList[i].getServizio().getTipoSoggettoErogatore() + servList[i].getServizio().getNomeSoggettoErogatore();
                String idServizioXML = servList[i].getServizio().getTipo() + servList[i].getServizio().getNome();
                String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + idServizioXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLServizio);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizio + "): " + e.getMessage(), e);
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !servList[i].getServizio().getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !servList[i].getServizio().getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServiziParteSpecifica](FiltroByMinDate) Servizio[" + servList[i].getServizio().getTipo() + "/" + servList[i].getServizio().getNome() + "] SoggettoErogatore[" + servList[i].getServizio().getTipoSoggettoErogatore() + "/" + servList[i].getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServiziParteSpecifica](FiltroByMaxDate) Servizio[" + servList[i].getServizio().getTipo() + "/" + servList[i].getServizio().getNome() + "] SoggettoErogatore[" + servList[i].getServizio().getTipoSoggettoErogatore() + "/" + servList[i].getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !servList[i].getServizio().getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !servList[i].getServizio().getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!servList[i].getAccordoServizioParteComune().equals(uriAccordo)) continue;
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                    if (servList[i].sizeFruitoreList() <= 0) continue;
                    boolean found = false;
                    for (int k = 0; k < servList[i].sizeFruitoreList(); ++k) {
                        Fruitore fruitore = servList[i].getFruitore(k);
                        if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(servList[i]);
                idServizi.add(idAccordo);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idServizi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] error", e);
        }
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.generatoreXML == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] Gestore repository XML non istanziato. Necessario per l'implementazione di questo metodo.");
            }
            AccordoServizioParteSpecifica[] servList = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (servList == null) {
                throw new DriverRegistroServiziNotFound("Servizi non esistenti nel repository WEB");
            }
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < servList.length; ++i) {
                String idSoggettoXML = servList[i].getServizio().getTipoSoggettoErogatore() + servList[i].getServizio().getNomeSoggettoErogatore();
                String idServizioXML = servList[i].getServizio().getTipo() + servList[i].getServizio().getNome();
                String urlXMLServizio = this.urlPrefix + idSoggettoXML + "/servizi/" + idServizioXML + ".xml";
                try {
                    this.validatoreRegistro.valida(urlXMLServizio);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizio + "): " + e.getMessage(), e);
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !servList[i].getServizio().getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !servList[i].getServizio().getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServiziParteSpecifica](FiltroByMinDate) Servizio[" + servList[i].getServizio().getTipo() + "/" + servList[i].getServizio().getNome() + "] SoggettoErogatore[" + servList[i].getServizio().getTipoSoggettoErogatore() + "/" + servList[i].getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (servList[i].getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServiziParteSpecifica](FiltroByMaxDate) Servizio[" + servList[i].getServizio().getTipo() + "/" + servList[i].getServizio().getNome() + "] SoggettoErogatore[" + servList[i].getServizio().getTipoSoggettoErogatore() + "/" + servList[i].getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (servList[i].getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !servList[i].getServizio().getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !servList[i].getServizio().getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!servList[i].getAccordoServizioParteComune().equals(uriAccordo)) continue;
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                    if (servList[i].sizeFruitoreList() <= 0) continue;
                    boolean found = false;
                    for (int k = 0; k < servList[i].sizeFruitoreList(); ++k) {
                        Fruitore fruitore = servList[i].getFruitore(k);
                        if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                IDServizio idServ = new IDServizio(servList[i].getServizio().getTipoSoggettoErogatore(), servList[i].getServizio().getNomeSoggettoErogatore(), servList[i].getServizio().getTipo(), servList[i].getServizio().getNome());
                idServ.setUriAccordo(servList[i].getAccordoServizioParteComune());
                idServ.setTipologiaServizio(servList[i].getServizio().getTipologiaServizio().toString());
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idServizi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAllIdAccordiServiziParteSpecifica] error", e);
        }
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune non completamente definito nei parametri obbligatori");
            }
            if (this.generatoreXML.existsAccordoServizioParteComune(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo.toString() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordo, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsAccordoServizioParteComune(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteComune] Accordo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da modificare non definito");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsAccordoServizioParteComune(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.generatoreXML.existsAccordoServizioParteComune(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordoOLD, accordoServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da eliminare non definito");
            }
            if (!this.generatoreXML.existsAccordoServizioParteComune(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizioParteComune(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        pddOLD = pdd.getNome();
        try {
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definita");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.generatoreXML.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e, e);
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definita");
            }
            if (!this.generatoreXML.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[createRuolo] Parametro Non Valido");
        }
        try {
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo non completamente definita nei parametri obbligatori");
            }
            if (this.generatoreXML.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(ruolo.getNome(), ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createRuolo] Errore generatosi durante la creazione di un nuovo ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        if (idRuolo == null || idRuolo.getNome() == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsRuolo(idRuolo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsRuolo] Ruolo non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[updateRuolo] Parametro Non Valido");
        }
        IDRuolo idRuoloOLD = null;
        idRuoloOLD = new IDRuolo(ruolo.getNome());
        try {
            if (idRuoloOLD == null || idRuoloOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da modificare non definito");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.generatoreXML.existsRuolo(idRuoloOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDRuolo idRuoloNEW = new IDRuolo(ruolo.getNome());
            if (!idRuoloOLD.equals(idRuoloNEW) && this.generatoreXML.existsRuolo(idRuoloNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(idRuoloOLD.getNome(), ruolo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateRuolo] Errore generatosi durante la modifica della porta di dominio [" + idRuoloOLD + "]: " + e, e);
        }
    }

    @Override
    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[deleteRuolo] Parametro Non Valido");
        }
        try {
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da eliminare non definito");
            }
            if (!this.generatoreXML.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteRuolo(ruolo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteRuolo] Errore generatosi durante l'eliminazione del ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                // empty if block
            }
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            if (this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.generatoreXML.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = soggetto.getOldTipoForUpdate();
        String nomeOLD = soggetto.getOldNomeForUpdate();
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto modificato non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                // empty if block
            }
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        try {
            int i;
            if (servizio.getNomeSoggettoErogatore() == null || servizio.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Specifica, non definito");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.generatoreXML.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            for (i = 0; i < servizio.sizeParametriAzioneList(); ++i) {
                ServizioAzione checkAz = servizio.getParametriAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeParametriFruitoreList(); ++j) {
                    ServizioAzioneFruitore checkAzFr = checkAz.getParametriFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getTipo() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            if (!this.generatoreXML.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = servizio.getTipo() + servizio.getNome();
            IDServizio idServizio = new IDServizio(idSoggettoErogatore, servizio.getTipo(), servizio.getNome());
            if (this.generatoreXML.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggettoErogatore_string + "] risulta gia' registrato nel registro");
            }
            this.generatoreXML.createAccordoServizioParteSpecifica(idServizio, asps);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Errore generatosi durante la creazione del nuovo Servizio [" + servizio.getTipo() + servizio.getNome() + "] erogato dal soggetto [" + servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idServizio);
            return true;
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idAccordo);
            return true;
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        String tipoServizioOLD = servizio.getOldTipoForUpdate();
        String nomeServizioOLD = servizio.getOldNomeForUpdate();
        if (tipoServizioOLD == null || nomeServizioOLD == null) {
            tipoServizioOLD = servizio.getTipo();
            nomeServizioOLD = servizio.getNome();
        }
        String tipoSoggettoOLD = servizio.getOldTipoSoggettoErogatoreForUpdate();
        String nomeSoggettoOLD = servizio.getOldNomeSoggettoErogatoreForUpdate();
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = servizio.getTipoSoggettoErogatore();
            nomeSoggettoOLD = servizio.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD;
        IDServizio idServizioOLD = new IDServizio(idSoggettoOLD, tipoServizioOLD, nomeServizioOLD);
        try {
            int i;
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare, erogatore del servizio, non definito");
            }
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio, non definiti");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() != null && checkFr.getTipo() != null) continue;
                throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
            }
            for (i = 0; i < servizio.sizeParametriAzioneList(); ++i) {
                ServizioAzione checkAz = servizio.getParametriAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeParametriFruitoreList(); ++j) {
                    ServizioAzioneFruitore checkAzFr = checkAz.getParametriFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getNome() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome/tipo o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            if (!this.generatoreXML.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.generatoreXML.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.generatoreXML.existsAccordoServizioParteSpecifica(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = new IDServizio(idSoggettoNEW, servizio.getTipo(), servizio.getNome());
            String idServizioNEW_string = servizio.getTipo() + servizio.getNome();
            if (!(idServizioOLD_string.equals(idServizioNEW_string) && idSoggettoOLD_string.equals(idSoggettoNEW_string) || !this.generatoreXML.existsAccordoServizioParteSpecifica(idServizioNEW))) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioOLD, asps);
            } else {
                this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizioOLD);
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioNEW, asps);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        String idSoggetto_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
        String idServizio_string = servizio.getTipo() + servizio.getNome();
        try {
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (servizio.getTipo() == null || servizio.getNome() == null) {
                throw new DriverRegistroServiziException("Servizio da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!this.generatoreXML.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
            if (!this.generatoreXML.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        int i;
        try {
            AccordoServizioParteComune[] accordiRegistrati = this.generatoreXML.getAccordiServizioParteComune();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    this.log.info("eliminazione accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordiRegistrati[i]) + "] in corso...");
                    this.deleteAccordoServizioParteComune(accordiRegistrati[i]);
                    this.log.info("eliminazione accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordiRegistrati[i]) + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    this.log.info("eliminazione accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] in corso...");
                    this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    this.log.info("eliminazione accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordiCooperazioneRegistrati[i]) + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi di cooperazione registrati: " + e.getMessage(), e);
        }
        try {
            AccordoServizioParteSpecifica[] serviziRegistrati = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    this.log.info("eliminazione servizio [" + serviziRegistrati[i].getServizio().getTipo() + "/" + serviziRegistrati[i].getServizio().getNome() + "] erogato da [" + serviziRegistrati[i].getServizio().getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getServizio().getNomeSoggettoErogatore() + "] in corso...");
                    this.deleteAccordoServizioParteSpecifica(serviziRegistrati[i]);
                    this.log.info("eliminazione servizio [" + serviziRegistrati[i].getServizio().getTipo() + "/" + serviziRegistrati[i].getServizio().getNome() + "] erogato da [" + serviziRegistrati[i].getServizio().getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getServizio().getNomeSoggettoErogatore() + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati: " + e.getMessage(), e);
        }
        try {
            Soggetto[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    this.log.info("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] in corso...");
                    this.deleteSoggetto(soggettiRegistrati[i]);
                    this.log.info("eliminazione soggetto [" + soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome() + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    this.log.info("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] in corso...");
                    this.deletePortaDominio(pddRegistrate[i]);
                    this.log.info("eliminazione porta di dominio [" + pddRegistrate[i].getNome() + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate: " + e.getMessage(), e);
        }
    }

    public void resetCtrlstat() throws DriverRegistroServiziException {
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        String urlVerifica = this.urlPrefix + "/";
        try {
            byte[] dir = HttpUtilities.requestHTTPFile(urlVerifica);
            if (dir == null) {
                throw new Exception("Directory accordi richiesta non ritornata");
            }
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile [" + urlVerifica + "]: " + e.getMessage(), e);
        }
    }
}

