/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistroRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CostantiConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.PddTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProprietariDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoliDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatiAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.uddi.DriverRegistroServiziUDDI;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils.PdDConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.web.DriverRegistroServiziWEB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.xml.DriverRegistroServiziXML;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.slf4j.Logger;

public class XMLDataConverter {
    private IDriverRegistroServiziCRUD gestoreCRUD = null;
    private RegistroServizi sorgenteRegistro;
    private Logger log = null;
    private Logger logDriver = null;
    private String superUser = null;
    private String tipoBEDestinazione;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private File parentFile = null;

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, destinazione, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, AccessoRegistroRegistro destinazione, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block36: {
            block35: {
                this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
                this.logDriver = logDriver;
                if (destinazione == null) {
                    throw new DriverRegistroServiziException("GestoreCRUD non definito");
                }
                this.tipoBEDestinazione = destinazione.getTipo().toString();
                this.superUser = superUser;
                try {
                    File f2;
                    if (sorgente instanceof String) {
                        this.createSorgente((String)sorgente);
                        try {
                            f2 = new File((String)sorgente);
                            if (f2.getParentFile() != null) {
                                this.parentFile = f2.getParentFile();
                            }
                            break block35;
                        }
                        catch (Exception f2) {}
                        break block35;
                    }
                    if (sorgente instanceof byte[]) {
                        this.createSorgente((byte[])sorgente);
                        break block35;
                    }
                    if (sorgente instanceof InputStream) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        InputStream is = (InputStream)sorgente;
                        int letti = 0;
                        byte[] reads = new byte[65536];
                        while ((letti = is.read(reads)) != -1) {
                            bout.write(reads, 0, letti);
                        }
                        bout.flush();
                        bout.close();
                        this.createSorgente(bout.toByteArray());
                        break block35;
                    }
                    if (!(sorgente instanceof File)) break block35;
                    this.createSorgente(((File)sorgente).getAbsolutePath());
                    try {
                        f2 = (File)sorgente;
                        if (f2.getParentFile() != null) {
                            this.parentFile = f2.getParentFile();
                        }
                    }
                    catch (Exception f3) {}
                }
                catch (DriverRegistroServiziException d) {
                    throw d;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
                }
            }
            try {
                if (CostantiConfigurazione.REGISTRO_DB.equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (DataSource) non definita");
                    }
                    if (destinazione.getTipoDatabase() == null) {
                        throw new Exception("TipoDatabase (DataSource) non definita");
                    }
                    if (destinazione.getGenericPropertiesMap() == null) {
                        throw new Exception("Contesto di localizzazione del datasource non definito in GenericProperties");
                    }
                    Properties properties = new Properties();
                    properties.putAll((Map<?, ?>)destinazione.getGenericPropertiesMap());
                    this.gestoreCRUD = new DriverRegistroServiziDB(destinazione.getLocation(), properties, this.logDriver, destinazione.getTipoDatabase());
                    if (((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                        this.log.info("Inizializzato Registro dei Servizi DB");
                        break block36;
                    }
                    throw new Exception("RegistroServizi DB non inizializzato");
                }
                if (CostantiConfigurazione.REGISTRO_UDDI.equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (InquiryURL) non definita");
                    }
                    if (destinazione.getGenericPropertiesMap() == null) {
                        throw new Exception("PublishURL/UrlPrefix/PathPrefix non definita in GenericProperties");
                    }
                    if (destinazione.getGenericPropertiesMap().size() != 3) {
                        throw new Exception("PublishURL/UrlPrefix/PathPrefix non definita in GenericProperties (size:" + destinazione.getGenericPropertiesMap().size() + ")");
                    }
                    if (!(destinazione.getGenericPropertiesMap().get("publishUrl") instanceof String)) {
                        throw new Exception("PublishURL definita in GenericProperties non e' un oggetto String");
                    }
                    if (!(destinazione.getGenericPropertiesMap().get("urlPrefix") instanceof String)) {
                        throw new Exception("UrlPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    if (!(destinazione.getGenericPropertiesMap().get("pathPrefix") instanceof String)) {
                        throw new Exception("PathPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    this.gestoreCRUD = new DriverRegistroServiziUDDI(destinazione.getLocation(), destinazione.getGenericPropertiesMap().get("publishUrl"), destinazione.getUser(), destinazione.getPassword(), destinazione.getGenericPropertiesMap().get("urlPrefix"), destinazione.getGenericPropertiesMap().get("pathPrefix"), this.logDriver);
                    if (((DriverRegistroServiziUDDI)this.gestoreCRUD).create) {
                        this.log.info("Inizializzato Registro dei Servizi UDDI");
                        break block36;
                    }
                    throw new Exception("RegistroServizi UDDI non inizializzato");
                }
                if (CostantiConfigurazione.REGISTRO_WEB.equals(destinazione.getTipo())) {
                    if (destinazione.getLocation() == null) {
                        throw new Exception("Location (UrlPrefix) non definita");
                    }
                    if (destinazione.getGenericPropertiesMap() == null) {
                        throw new Exception("PathPrefix non definita in GenericProperties");
                    }
                    if (destinazione.getGenericPropertiesMap().size() != 1) {
                        throw new Exception("PathPrefix non definita in GenericProperties (size:" + destinazione.getGenericPropertiesMap().size() + ")");
                    }
                    if (!(destinazione.getGenericPropertiesMap().get("pathPrefix") instanceof String)) {
                        throw new Exception("PathPrefix definita in GenericProperties non e' un oggetto String");
                    }
                    this.gestoreCRUD = new DriverRegistroServiziWEB(destinazione.getLocation(), destinazione.getGenericPropertiesMap().get("pathPrefix"), this.logDriver);
                    this.log.info("Inizializzato Registro dei Servizi WEB");
                    if (((DriverRegistroServiziWEB)this.gestoreCRUD).create) {
                        this.log.info("Inizializzato Registro dei Servizi WEB");
                        break block36;
                    }
                    throw new Exception("RegistroServizi WEB non inizializzato");
                }
                throw new Exception("Tipo di registro CRUD non gestito: " + destinazione.getTipo());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
            }
        }
        this.initializeProtocolManager(protocolloDefault);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(String sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(byte[] sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(InputStream sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, null, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, null);
    }

    public XMLDataConverter(File sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        this.XMLDataConverterSetup(sorgente, connection, tipoDatabase, superUser, protocolloDefault, log, logDriver);
    }

    private void XMLDataConverterSetup(Object sorgente, Connection connection, String tipoDatabase, String superUser, String protocolloDefault, Logger log, Logger logDriver) throws DriverRegistroServiziException {
        block16: {
            this.log = log == null ? LoggerWrapperFactory.getLogger(XMLDataConverter.class) : log;
            this.logDriver = logDriver;
            this.superUser = superUser;
            this.tipoBEDestinazione = CostantiConfigurazione.REGISTRO_DB.toString();
            try {
                File f2;
                if (sorgente instanceof String) {
                    this.createSorgente((String)sorgente);
                    try {
                        f2 = new File((String)sorgente);
                        if (f2.getParentFile() != null) {
                            this.parentFile = f2.getParentFile();
                        }
                        break block16;
                    }
                    catch (Exception f2) {}
                    break block16;
                }
                if (sorgente instanceof byte[]) {
                    this.createSorgente((byte[])sorgente);
                    break block16;
                }
                if (sorgente instanceof InputStream) {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream is = (InputStream)sorgente;
                    int letti = 0;
                    byte[] reads = new byte[65536];
                    while ((letti = is.read(reads)) != -1) {
                        bout.write(reads, 0, letti);
                    }
                    bout.flush();
                    bout.close();
                    this.createSorgente(bout.toByteArray());
                    break block16;
                }
                if (!(sorgente instanceof File)) break block16;
                this.createSorgente(((File)sorgente).getAbsolutePath());
                try {
                    f2 = (File)sorgente;
                    if (f2.getParentFile() != null) {
                        this.parentFile = f2.getParentFile();
                    }
                }
                catch (Exception f3) {}
            }
            catch (DriverRegistroServiziException d) {
                throw d;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Creazione sorgente [" + sorgente.getClass().getName() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            this.gestoreCRUD = new DriverRegistroServiziDB(connection, this.logDriver, tipoDatabase);
            if (!((DriverRegistroServiziDB)this.gestoreCRUD).create) {
                throw new Exception("Configurazione DB non inizializzato");
            }
            this.log.info("Inizializzato Configurazione DB");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
        this.initializeProtocolManager(protocolloDefault);
    }

    private void initializeProtocolManager(String protocolloDefault) throws DriverRegistroServiziException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = null;
            try {
                protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (protocolFactoryManager == null) {
                Class<?> cConfigurazionePdD = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ConfigurazionePdD");
                Object configurazionePdD = cConfigurazionePdD.getConstructor(new Class[0]).newInstance(new Object[0]);
                Object confDir = null;
                cConfigurazionePdD.getMethod("setConfigurationDir", String.class).invoke(configurazionePdD, confDir);
                cConfigurazionePdD.getMethod("setAttesaAttivaJDBC", Long.TYPE).invoke(configurazionePdD, 60);
                cConfigurazionePdD.getMethod("setCheckIntervalJDBC", Integer.TYPE).invoke(configurazionePdD, 100);
                cConfigurazionePdD.getMethod("setLoader", Loader.class).invoke(configurazionePdD, new Loader());
                cConfigurazionePdD.getMethod("setLog", Logger.class).invoke(configurazionePdD, this.log);
                cProtocolFactoryManager.getMethod("initialize", Logger.class, cConfigurazionePdD, String.class).invoke(null, this.log, configurazionePdD, protocolloDefault);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private void createSorgente(String sorgente) throws DriverRegistroServiziException {
        if (sorgente == null) {
            throw new DriverRegistroServiziException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
        }
        FileInputStream fXML = null;
        try {
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                validatoreRegistro.valida(sorgente);
            } else {
                fXML = new FileInputStream(sorgente);
                validatoreRegistro.valida(fXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        finally {
            if (fXML != null) {
                try {
                    fXML.close();
                }
                catch (Exception exception) {}
            }
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            HttpURLConnection httpConn = null;
            if (sorgente.startsWith("http://") || sorgente.startsWith("file://")) {
                try {
                    URL url = new URL(sorgente);
                    URLConnection connection = url.openConnection();
                    httpConn = (HttpURLConnection)connection;
                    httpConn.setRequestMethod("GET");
                    httpConn.setDoOutput(true);
                    httpConn.setDoInput(true);
                    iStream = new InputStreamReader(httpConn.getInputStream());
                }
                catch (Exception e) {
                    try {
                        if (iStream != null) {
                            iStream.close();
                        }
                        if (httpConn != null) {
                            httpConn.disconnect();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                }
            }
            try {
                iStream = new InputStreamReader(new FileInputStream(sorgente));
            }
            catch (FileNotFoundException e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteRegistro = (RegistroServizi)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    private void createSorgente(byte[] sorgente) throws DriverRegistroServiziException {
        if (sorgente == null) {
            throw new DriverRegistroServiziException("Sorgente non definita");
        }
        ValidatoreXSD validatoreRegistro = null;
        try {
            validatoreRegistro = new ValidatoreXSD(this.log, DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage());
        }
        try {
            validatoreRegistro.valida(new ByteArrayInputStream(sorgente));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            InputStreamReader iStream = null;
            try {
                iStream = new InputStreamReader(new ByteArrayInputStream(sorgente));
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStreamReader del registro dei servizi : \n\n" + e.getMessage());
            }
            try {
                this.sorgenteRegistro = (RegistroServizi)uctx.unmarshalDocument((Reader)iStream, null);
            }
            catch (JiBXException e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
            }
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'istanziazione del registro: " + e.getMessage(), e);
        }
    }

    public void convertXML(boolean reset, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        this.convertXML(reset, new PdDConfig(), mantieniFruitoriEsistenti, aggiornamentoSoggetti, statoAccordo);
    }

    public void convertXML(boolean reset, PdDConfig pddConfig, boolean mantieniFruitoriEsistenti, boolean aggiornamentoSoggetti, StatiAccordo statoAccordo) throws DriverRegistroServiziException {
        Soggetto soggetto;
        int i;
        if (reset) {
            try {
                this.log.info("RegistroServizi, reset in corso...");
                this.gestoreCRUD.reset();
                this.log.info("RegistroServizi, reset effettuato.");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Reset del RegistroServizi non riuscita: " + e.getMessage(), e);
            }
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                pdd.setSuperUser(this.superUser);
                XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio(pdd);
                if (!reset && this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                    this.log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento in corso...");
                    this.gestoreCRUD.updatePortaDominio(pdd);
                    this.log.info("Porta di Dominio " + pdd.getNome() + " aggiornata.");
                } else {
                    this.log.info("Porta di Dominio " + pdd.getNome() + " creazione in corso...");
                    this.gestoreCRUD.createPortaDominio(pdd);
                    this.log.info("Porta di Dominio " + pdd.getNome() + " creata.");
                }
                if (!CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione) || pddConfig.getPddOperativaCtrlstatSinglePdd() == null) continue;
                XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio_update(pdd, pddConfig.getPddOperativaCtrlstatSinglePdd(), this.log, (DriverRegistroServiziDB)this.gestoreCRUD, pddConfig.getTipoPdd());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML delle porte di dominio: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeSoggettoList(); ++i) {
                Soggetto soggetto2 = this.sorgenteRegistro.getSoggetto(i);
                this.gestioneSoggetto(soggetto2, reset, aggiornamentoSoggetti, pddConfig.getPddOperativaCtrlstatSinglePdd());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei soggetti: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                    ac.setStatoPackage(statoAccordo.toString());
                }
                this.gestioneAccordoCooperazione(ac, reset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di cooperazione: " + e.getMessage(), e);
        }
        Vector<AccordoServizioParteComune> accordiServizioComposti = new Vector<AccordoServizioParteComune>();
        Vector<String> accordiServizioCompostiID = new Vector<String>();
        try {
            for (int i2 = 0; i2 < this.sorgenteRegistro.sizeAccordoServizioParteComuneList(); ++i2) {
                AccordoServizioParteComune as = this.sorgenteRegistro.getAccordoServizioParteComune(i2);
                if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                    as.setStatoPackage(statoAccordo.toString());
                }
                if (as.getServizioComposto() == null) {
                    this.gestioneAccordoServizioParteComune(as, reset);
                    continue;
                }
                String idAccordoServizioComposto = this.idAccordoFactory.getUriFromAccordo(as);
                this.log.debug("AccordoServizio [" + idAccordoServizioComposto + "] e' un accordo di servizio composto, verra posticipata la gestione dopo la creazione dei servizi");
                accordiServizioComposti.add(as);
                accordiServizioCompostiID.add(idAccordoServizioComposto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi: " + e.getMessage(), e);
        }
        Vector<AccordoServizioParteSpecifica> servizioComposti = new Vector<AccordoServizioParteSpecifica>();
        Vector<Soggetto> servizioComposti_Soggetti = new Vector<Soggetto>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeSoggettoList(); ++i3) {
                soggetto = this.sorgenteRegistro.getSoggetto(i3);
                for (int j = 0; j < soggetto.sizeAccordoServizioParteSpecificaList(); ++j) {
                    boolean servizioComposto;
                    AccordoServizioParteSpecifica servizio = soggetto.getAccordoServizioParteSpecifica(j);
                    if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                        servizio.setStatoPackage(statoAccordo.toString());
                    }
                    if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                        if (servizio.getNome() == null) {
                            servizio.setNome(servizio.getServizio().getNome());
                        }
                        if (servizio.getVersione() == null) {
                            servizio.setVersione("1");
                        }
                    }
                    if (!(servizioComposto = accordiServizioCompostiID.contains(servizio.getAccordoServizioParteComune()))) {
                        this.gestioneServizio(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo);
                        continue;
                    }
                    this.log.debug("Servizio [" + soggetto.getTipo() + "/" + soggetto.getNome() + "_" + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + "] e' un servizio composto, verra posticipata la gestione dopo la creazione degli accordi di servizio composti");
                    servizioComposti.add(servizio);
                    servizioComposti_Soggetti.add(soggetto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi: " + e.getMessage(), e);
        }
        try {
            while (accordiServizioComposti.size() > 0) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)accordiServizioComposti.remove(0);
                this.gestioneAccordoServizioParteComune(as, reset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML degli accordi di servizio composti: " + e.getMessage(), e);
        }
        try {
            while (servizioComposti.size() > 0) {
                AccordoServizioParteSpecifica servizio = (AccordoServizioParteSpecifica)servizioComposti.remove(0);
                soggetto = (Soggetto)servizioComposti_Soggetti.remove(0);
                this.gestioneServizio(servizio, soggetto, reset, mantieniFruitoriEsistenti, statoAccordo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante la conversione XML dei servizi degli accordi di servizio composti: " + e.getMessage(), e);
        }
    }

    public static void impostaInformazioniRegistroDB_PortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd.getImplementazione() == null) {
            pdd.setImplementazione("standard");
        }
    }

    public static void impostaInformazioniRegistroDB_PortaDominio_update(PortaDominio pdd, String nomePddOperativaCtrlstatSinglePdD, Logger log, DriverRegistroServiziDB driverRegistroServiziDB, String tipoPdd) throws DriverRegistroServiziException {
        if (pdd.getNome().equals(nomePddOperativaCtrlstatSinglePdD)) {
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[" + PddTipologia.OPERATIVO.toString() + "] in corso...");
            driverRegistroServiziDB.updateTipoPortaDominio(pdd.getNome(), PddTipologia.OPERATIVO.toString());
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo " + PddTipologia.OPERATIVO.toString() + ".");
        } else {
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornamento tipo[" + PddTipologia.ESTERNO.toString() + "] in corso...");
            driverRegistroServiziDB.updateTipoPortaDominio(pdd.getNome(), tipoPdd);
            log.info("Porta di Dominio " + pdd.getNome() + " aggiornata con tipo " + PddTipologia.ESTERNO.toString() + ".");
        }
    }

    public static void impostaInformazioniRegistroDB_Ruolo(Ruolo ruolo) throws DriverRegistroServiziException {
    }

    private static String getCodiceIPADefault(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolBySubjectType", String.class).invoke(protocolFactoryManager, idSoggetto.getTipo());
            Class<?> cProtocolFactory = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolTraduttore = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore");
            Object protocolTraduttore = cProtocolFactory.getMethod("createTraduttore", new Class[0]).invoke(protocolFactory, new Object[0]);
            return (String)cProtocolTraduttore.getMethod("getIdentificativoCodiceIPADefault", IDSoggetto.class, Boolean.TYPE).invoke(protocolTraduttore, idSoggetto, false);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private static String getIdentificativoPortaDefault(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        try {
            Class<?> cProtocolFactoryManager = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager");
            Object protocolFactoryManager = cProtocolFactoryManager.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            String protocollo = (String)cProtocolFactoryManager.getMethod("getProtocolBySubjectType", String.class).invoke(protocolFactoryManager, idSoggetto.getTipo());
            Class<?> cProtocolFactory = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory");
            Object protocolFactory = cProtocolFactoryManager.getMethod("getProtocolFactoryByName", String.class).invoke(protocolFactoryManager, protocollo);
            Class<?> cProtocolTraduttore = Class.forName("it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore");
            Object protocolTraduttore = cProtocolFactory.getMethod("createTraduttore", new Class[0]).invoke(protocolFactory, new Object[0]);
            return (String)cProtocolTraduttore.getMethod("getIdentificativoPortaDefault", IDSoggetto.class).invoke(protocolTraduttore, idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'istanziazione del driver di CRUD: " + e.getMessage(), e);
        }
    }

    private static void mantieniFruitori(AccordoServizioParteSpecifica old, AccordoServizioParteSpecifica servizio) {
        for (int fr = 0; fr < old.sizeFruitoreList(); ++fr) {
            boolean find = false;
            for (int frNew = 0; frNew < servizio.sizeFruitoreList(); ++frNew) {
                if (!servizio.getFruitore(frNew).getTipo().equals(old.getFruitore(fr).getTipo()) || !servizio.getFruitore(frNew).getNome().equals(old.getFruitore(fr).getNome())) continue;
                find = true;
                break;
            }
            if (find) continue;
            servizio.addFruitore(old.getFruitore(fr));
        }
    }

    public static void aggiornatoStatoFruitori(AccordoServizioParteSpecifica servizio, StatiAccordo statoAccordo) {
        for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
            servizio.getFruitore(i).setStatoPackage(statoAccordo.toString());
        }
    }

    public void delete(boolean deleteSoggetti) throws DriverRegistroServiziException {
        int i;
        try {
            for (int i2 = 0; i2 < this.sorgenteRegistro.sizeSoggettoList(); ++i2) {
                Soggetto soggetto = this.sorgenteRegistro.getSoggetto(i2);
                for (int j = 0; j < soggetto.sizeAccordoServizioParteSpecificaList(); ++j) {
                    AccordoServizioParteSpecifica servizio = soggetto.getAccordoServizioParteSpecifica(j);
                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    IDServizio idServizio = new IDServizio(idSoggetto, servizio.getServizio().getTipo(), servizio.getServizio().getNome());
                    this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsAccordoServizioParteSpecifica(idServizio)) {
                        this.gestoreCRUD.deleteAccordoServizioParteSpecifica(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteSpecifica(idServizio));
                    }
                    this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato.");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione dei servizi: " + e.getMessage(), e);
        }
        Vector<AccordoServizioParteComune> asServiziNonComposti = new Vector<AccordoServizioParteComune>();
        try {
            for (int i3 = 0; i3 < this.sorgenteRegistro.sizeAccordoServizioParteComuneList(); ++i3) {
                AccordoServizioParteComune as = this.sorgenteRegistro.getAccordoServizioParteComune(i3);
                if (as.getServizioComposto() == null) {
                    asServiziNonComposti.add(as);
                    continue;
                }
                this.log.info("Accordo di Servizio Composto " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizioParteComune(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as)));
                }
                this.log.info("Accordo di Servizio Composto " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminato");
            }
            while (asServiziNonComposti.size() > 0) {
                AccordoServizioParteComune as = (AccordoServizioParteComune)asServiziNonComposti.remove(0);
                this.log.info("Accordo di Servizio " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as))) {
                    this.gestoreCRUD.deleteAccordoServizioParteComune(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromAccordo(as)));
                }
                this.log.info("Accordo di Servizio " + this.idAccordoFactory.getUriFromAccordo(as) + " eliminato");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi: " + e.getMessage(), e);
        }
        try {
            for (i = 0; i < this.sorgenteRegistro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.sorgenteRegistro.getAccordoCooperazione(i);
                this.log.info("Accordo di Cooperazione " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + " eliminazione in corso...");
                if (this.gestoreCRUD.existsAccordoCooperazione(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac))) {
                    this.gestoreCRUD.deleteAccordoCooperazione(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoCooperazione(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac)));
                }
                this.log.info("Accordo di Cooperazione " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + " eliminato");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DriverRegistroServiziException("Errore durante l'eliminazione degli accordi di cooperazione: " + e.getMessage(), e);
        }
        if (deleteSoggetti) {
            try {
                for (i = 0; i < this.sorgenteRegistro.sizeSoggettoList(); ++i) {
                    Soggetto soggetto = this.sorgenteRegistro.getSoggetto(i);
                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsSoggetto(idSoggetto)) {
                        this.gestoreCRUD.deleteSoggetto(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto));
                    }
                    this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " eliminato.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Errore durante l'eliminazione dei soggetti: " + e.getMessage(), e);
            }
            try {
                for (i = 0; i < this.sorgenteRegistro.sizePortaDominioList(); ++i) {
                    PortaDominio pdd = this.sorgenteRegistro.getPortaDominio(i);
                    this.log.info("Porta di Dominio " + pdd.getNome() + " eliminazione in corso...");
                    if (this.gestoreCRUD.existsPortaDominio(pdd.getNome())) {
                        this.gestoreCRUD.deletePortaDominio(((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getPortaDominio(pdd.getNome()));
                    }
                    this.log.info("Porta di Dominio " + pdd.getNome() + " eliminata.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DriverRegistroServiziException("Errore durante l'eliminazione delle porte di dominio: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gestioneBytesDocumenti_Wsdl_Wsbl(String documento) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (documento != null && !documento.equals("http://undefined")) {
            if (documento.startsWith("http://") || documento.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile(documento);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(documento);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        byte[] reads = new byte[65536];
                        int letti = 0;
                        while ((letti = file.read(reads)) >= 0) {
                            bout.write(reads, 0, letti);
                        }
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception reads) {}
                    }
                }
                if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, documento);
                    if (fWithParent.exists()) {
                        FileInputStream file = null;
                        try {
                            file = new FileInputStream(fWithParent);
                            byte[] reads = new byte[65536];
                            int letti = 0;
                            while ((letti = file.read(reads)) >= 0) {
                                bout.write(reads, 0, letti);
                            }
                        }
                        finally {
                            try {
                                if (file != null) {
                                    file.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    throw new Exception("File [" + documento + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        return null;
    }

    private void initializeWSDLBytes(AccordoServizioParteComune as) throws DriverRegistroServiziException {
        String uriAS = this.idAccordoFactory.getUriFromAccordo(as);
        if (as.getWsdlDefinitorio() != null) {
            try {
                as.setByteWsdlDefinitorio(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlDefinitorio()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl definitorio [" + as.getWsdlDefinitorio() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                as.setByteWsdlConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlConcettuale()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl concettuale [" + as.getWsdlConcettuale() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                as.setByteWsdlLogicoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoErogatore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl logico erogatore [" + as.getWsdlLogicoErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                as.setByteWsdlLogicoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getWsdlLogicoFruitore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura wsdl logico fruitore [" + as.getWsdlLogicoFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneConcettuale() != null) {
            try {
                as.setByteSpecificaConversazioneConcettuale(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneConcettuale()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione concettuale [" + as.getSpecificaConversazioneConcettuale() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneErogatore() != null) {
            try {
                as.setByteSpecificaConversazioneErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneErogatore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione erogatore [" + as.getSpecificaConversazioneErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (as.getSpecificaConversazioneFruitore() != null) {
            try {
                as.setByteSpecificaConversazioneFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(as.getSpecificaConversazioneFruitore()));
            }
            catch (Exception e) {
                this.log.warn("Accordo di Servizio " + uriAS + ", lettura specifica conversazione fruitore [" + as.getSpecificaConversazioneFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
    }

    private void initializeWSDLBytes(AccordoServizioParteSpecifica s) {
        if (s.getWsdlImplementativoErogatore() != null) {
            try {
                s.setByteWsdlImplementativoErogatore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoErogatore()));
            }
            catch (Exception e) {
                this.log.warn("Servizio " + s.getServizio().getTipo() + s.getServizio().getNome() + ", lettura wsdl implementativo erogatore [" + s.getWsdlImplementativoErogatore() + "] non riuscita:", (Throwable)e);
            }
        }
        if (s.getWsdlImplementativoFruitore() != null) {
            try {
                s.setByteWsdlImplementativoFruitore(this.gestioneBytesDocumenti_Wsdl_Wsbl(s.getWsdlImplementativoFruitore()));
            }
            catch (Exception e) {
                this.log.warn("Servizio " + s.getServizio().getTipo() + s.getServizio().getNome() + ", lettura wsdl implementativo fruitore [" + s.getWsdlImplementativoFruitore() + "] non riuscita:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readDocumento(String fileName) throws DriverRegistroServiziException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (fileName.startsWith("http://") || fileName.startsWith("file://")) {
                byte[] file = HttpUtilities.requestHTTPFile(fileName);
                if (file == null) {
                    throw new Exception("byte[] is null");
                }
                bout.write(file);
            } else {
                File f = new File(fileName);
                if (f.exists()) {
                    FileInputStream file = null;
                    try {
                        file = new FileInputStream(f);
                        byte[] reads = new byte[65536];
                        int letti = 0;
                        while ((letti = file.read(reads)) >= 0) {
                            bout.write(reads, 0, letti);
                        }
                    }
                    finally {
                        try {
                            if (file != null) {
                                file.close();
                            }
                        }
                        catch (Exception reads) {}
                    }
                }
                if (this.parentFile != null) {
                    File fWithParent = new File(this.parentFile, fileName);
                    if (fWithParent.exists()) {
                        FileInputStream file = null;
                        try {
                            file = new FileInputStream(fWithParent);
                            byte[] reads = new byte[65536];
                            int letti = 0;
                            while ((letti = file.read(reads)) >= 0) {
                                bout.write(reads, 0, letti);
                            }
                        }
                        finally {
                            try {
                                if (file != null) {
                                    file.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    throw new Exception("File [" + fileName + "] non esistente");
                }
            }
            bout.flush();
            bout.close();
            if (bout.size() > 0) {
                return bout.toByteArray();
            }
        }
        catch (Exception e) {
            this.log.warn("File " + fileName + ", lettura documento non riuscita:", (Throwable)e);
        }
        throw new DriverRegistroServiziException("Contenuto non letto?? File [" + fileName + "]");
    }

    private String getNomeFile(String fileName) {
        String name = null;
        if (fileName.startsWith("http://")) {
            int index = fileName.lastIndexOf("/");
            name = fileName.substring(index + 1, fileName.length());
        } else {
            File f = new File(fileName);
            name = f.getName();
        }
        return name;
    }

    private static void gestioneDefaultConnettoreHTTP(Connettore connettore) {
        if (connettore.getProperties() != null) {
            Property cp;
            if (!connettore.getProperties().containsKey("trustStoreType")) {
                cp = new Property();
                cp.setNome("trustStoreType");
                cp.setValore("jks");
                connettore.addProperty(cp);
            }
            if (!connettore.getProperties().containsKey("trustManagementAlgorithm")) {
                cp = new Property();
                cp.setNome("trustManagementAlgorithm");
                cp.setValore(TrustManagerFactory.getDefaultAlgorithm());
                connettore.addProperty(cp);
            }
            if (connettore.getProperties().containsKey("keyStoreLocation")) {
                if (!connettore.getProperties().containsKey("keyStoreType")) {
                    cp = new Property();
                    cp.setNome("keyStoreType");
                    cp.setValore("jks");
                    connettore.addProperty(cp);
                }
                if (!connettore.getProperties().containsKey("keyManagementAlgorithm")) {
                    cp = new Property();
                    cp.setNome("keyManagementAlgorithm");
                    cp.setValore(KeyManagerFactory.getDefaultAlgorithm());
                    connettore.addProperty(cp);
                }
            }
        }
    }

    public static void impostaInformazioniRegistroDB_Soggetto(Soggetto soggetto, String pddOperativaCtrlstatSinglePdd) throws DriverRegistroServiziException {
        if (soggetto.getConnettore() != null) {
            soggetto.getConnettore().setNome(null);
            String tipoConnettore = soggetto.getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                soggetto.getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(soggetto.getConnettore());
            }
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
            soggetto.setIdentificativoPorta(XMLDataConverter.getIdentificativoPortaDefault(idSoggetto));
        }
        if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
            soggetto.setCodiceIpa(XMLDataConverter.getCodiceIPADefault(idSoggetto));
        }
        if (pddOperativaCtrlstatSinglePdd != null && soggetto.getPortaDominio() == null) {
            soggetto.setPortaDominio(pddOperativaCtrlstatSinglePdd);
        }
    }

    public static void impostaInformazioniRegistroDB_Soggetto_update(Soggetto soggetto, Soggetto old) {
        soggetto.setId(old.getId());
        if (soggetto.getConnettore() == null) {
            soggetto.setConnettore(old.getConnettore());
        } else {
            soggetto.getConnettore().setId(old.getConnettore().getId());
            soggetto.getConnettore().setNome(old.getConnettore().getNome());
        }
    }

    private void gestioneSoggetto(Soggetto soggetto, boolean reset, boolean aggiornamentoSoggetti, String pddOperativaCtrlstatSinglePdd) throws Exception {
        soggetto.setSuperUser(this.superUser);
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_Soggetto(soggetto, pddOperativaCtrlstatSinglePdd);
        }
        if (!reset && this.gestoreCRUD.existsSoggetto(idSoggetto)) {
            if (aggiornamentoSoggetti) {
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
                Soggetto old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getSoggetto(idSoggetto);
                XMLDataConverter.impostaInformazioniRegistroDB_Soggetto_update(soggetto, old);
                this.gestoreCRUD.updateSoggetto(soggetto);
                this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
            }
        } else {
            this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
            this.gestoreCRUD.createSoggetto(soggetto);
            this.log.info("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
        }
    }

    private void gestioneAccordoCooperazione(AccordoCooperazione ac, boolean reset) throws Exception {
        String name;
        String fileName;
        int k;
        ac.setSuperUser(this.superUser);
        for (k = 0; k < ac.sizeAllegatoList(); ++k) {
            fileName = ac.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            ac.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            ac.getAllegato(k).setFile(name);
            ac.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            ac.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        for (k = 0; k < ac.sizeSpecificaSemiformaleList(); ++k) {
            fileName = ac.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            ac.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            ac.getSpecificaSemiformale(k).setFile(name);
            ac.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            ac.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
        }
        IDAccordoCooperazione idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(ac.getNome(), ac.getVersione());
        String uriAC = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoCooperazione(idAccordo)) {
            this.log.info("Accordo di Cooperazione " + uriAC + " aggiornamento in corso...");
            this.gestoreCRUD.updateAccordoCooperazione(ac);
            this.log.info("Accordo di Cooperazione " + uriAC + " aggiornato");
        } else {
            this.log.info("Accordo di Cooperazione " + uriAC + " creazione in corso...");
            this.gestoreCRUD.createAccordoCooperazione(ac);
            this.log.info("Accordo di Cooperazione " + uriAC + " creato.");
        }
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteComune(AccordoServizioParteComune as) {
        int k;
        ProfiloCollaborazione profiloCollaborazione = as.getProfiloCollaborazione();
        for (k = 0; k < as.sizeAzioneList(); ++k) {
            if (as.getAzione(k).getConfermaRicezione() != null || as.getAzione(k).getConsegnaInOrdine() != null || as.getAzione(k).getFiltroDuplicati() != null || as.getAzione(k).getIdCollaborazione() != null || as.getAzione(k).getProfiloCollaborazione() != null || as.getAzione(k).getScadenza() != null) {
                as.getAzione(k).setProfAzione("ridefinito");
            } else {
                as.getAzione(k).setProfAzione("default");
            }
            if (as.getAzione(k).getProfiloCollaborazione() != null) continue;
            as.getAzione(k).setProfiloCollaborazione(profiloCollaborazione);
        }
        for (k = 0; k < as.sizePortTypeList(); ++k) {
            PortType pt = as.getPortType(k);
            if (pt.getConfermaRicezione() != null || pt.getConsegnaInOrdine() != null || pt.getFiltroDuplicati() != null || pt.getIdCollaborazione() != null || pt.getProfiloCollaborazione() != null || pt.getScadenza() != null) {
                pt.setProfiloPT("ridefinito");
            } else {
                pt.setProfiloPT("default");
            }
            if (pt.getProfiloCollaborazione() == null) {
                pt.setProfiloCollaborazione(profiloCollaborazione);
            }
            for (int l = 0; l < pt.sizeAzioneList(); ++l) {
                Operation op = pt.getAzione(l);
                if (op.getConfermaRicezione() != null || op.getConsegnaInOrdine() != null || op.getFiltroDuplicati() != null || op.getIdCollaborazione() != null || op.getProfiloCollaborazione() != null || op.getScadenza() != null) {
                    op.setProfAzione("ridefinito");
                } else {
                    op.setProfAzione("default");
                }
                if (op.getProfiloCollaborazione() != null) continue;
                op.setProfiloCollaborazione(pt.getProfiloCollaborazione());
            }
        }
    }

    private void gestioneAccordoServizioParteComune(AccordoServizioParteComune as, boolean reset) throws Exception {
        String name;
        String fileName;
        int k;
        as.setSuperUser(this.superUser);
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune(as);
        }
        this.initializeWSDLBytes(as);
        for (k = 0; k < as.sizeAllegatoList(); ++k) {
            fileName = as.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            as.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            as.getAllegato(k).setFile(name);
            as.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            as.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        for (k = 0; k < as.sizeSpecificaSemiformaleList(); ++k) {
            fileName = as.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            as.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            as.getSpecificaSemiformale(k).setFile(name);
            as.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            as.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
        }
        if (as.getServizioComposto() != null) {
            for (k = 0; k < as.getServizioComposto().sizeSpecificaCoordinamentoList(); ++k) {
                fileName = as.getServizioComposto().getSpecificaCoordinamento(k).getFile();
                name = this.getNomeFile(fileName);
                as.getServizioComposto().getSpecificaCoordinamento(k).setByteContenuto(this.readDocumento(fileName));
                as.getServizioComposto().getSpecificaCoordinamento(k).setFile(name);
                as.getServizioComposto().getSpecificaCoordinamento(k).setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                as.getServizioComposto().getSpecificaCoordinamento(k).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
        }
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione());
        String uriAS = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        if (!reset && this.gestoreCRUD.existsAccordoServizioParteComune(idAccordo)) {
            this.log.info("Accordo di Servizio " + uriAS + " aggiornamento in corso...");
            this.gestoreCRUD.updateAccordoServizioParteComune(as);
            this.log.info("Accordo di Servizio " + uriAS + " aggiornato");
        } else {
            this.log.info("Accordo di Servizio " + uriAS + " creazione in corso...");
            this.gestoreCRUD.createAccordoServizioParteComune(as);
            this.log.info("Accordo di Servizio " + uriAS + " creato.");
        }
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore(Fruitore fruitore) {
        if (fruitore.getConnettore() != null) {
            fruitore.getConnettore().setNome(null);
            String tipoConnettore = fruitore.getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                fruitore.getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(fruitore.getConnettore());
            }
        }
    }

    public static void impostaInformazioniRegistroDB_AccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) {
        int k;
        if (servizio.getServizio().getConnettore() != null) {
            servizio.getServizio().getConnettore().setNome(null);
            String tipoConnettore = servizio.getServizio().getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                servizio.getServizio().getConnettore().setCustom(true);
            }
            if (TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) {
                XMLDataConverter.gestioneDefaultConnettoreHTTP(servizio.getServizio().getConnettore());
            }
        }
        for (k = 0; k < servizio.sizeFruitoreList(); ++k) {
            if (servizio.getFruitore(k).getConnettore() == null) continue;
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore(servizio.getFruitore(k));
        }
        for (k = 0; k < servizio.getServizio().sizeParametriAzioneList(); ++k) {
            if (servizio.getServizio().getParametriAzione(k).getConnettore() == null) continue;
            servizio.getServizio().getParametriAzione(k).getConnettore().setNome(null);
            String tipoConnettore = servizio.getServizio().getParametriAzione(k).getConnettore().getTipo();
            if (!(TipiConnettore.JMS.getNome().equals(tipoConnettore) || TipiConnettore.HTTP.getNome().equals(tipoConnettore) || TipiConnettore.DISABILITATO.getNome().equals(tipoConnettore) || TipiConnettore.NULL.getNome().equals(tipoConnettore) || TipiConnettore.NULLECHO.getNome().equals(tipoConnettore))) {
                servizio.getServizio().getParametriAzione(k).getConnettore().setCustom(true);
            }
            if (!TipiConnettore.HTTPS.getNome().equals(tipoConnettore)) continue;
            XMLDataConverter.gestioneDefaultConnettoreHTTP(servizio.getServizio().getParametriAzione(k).getConnettore());
        }
    }

    public static void impostaInformazioniRegistro_AccordoServizioParteSpecifica_update(AccordoServizioParteSpecifica servizio, AccordoServizioParteSpecifica old, boolean mantieniFruitoriEsistenti) {
        if (servizio.getServizio().getConnettore() == null) {
            servizio.getServizio().setConnettore(old.getServizio().getConnettore());
        } else {
            servizio.getServizio().getConnettore().setId(old.getServizio().getConnettore().getId());
            servizio.getServizio().getConnettore().setNome(old.getServizio().getConnettore().getNome());
        }
        if (mantieniFruitoriEsistenti) {
            XMLDataConverter.mantieniFruitori(old, servizio);
        }
        if (servizio.sizeFruitoreList() > 0) {
            for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore fruitore = servizio.getFruitore(i);
                for (int j = 0; j < old.sizeFruitoreList(); ++j) {
                    Fruitore oldFruitore = old.getFruitore(j);
                    if (!oldFruitore.getTipo().equals(fruitore.getTipo()) || !oldFruitore.getNome().equals(fruitore.getNome())) continue;
                    if (fruitore.getConnettore() == null) {
                        fruitore.setConnettore(oldFruitore.getConnettore());
                        continue;
                    }
                    fruitore.getConnettore().setId(oldFruitore.getConnettore().getId());
                    fruitore.getConnettore().setNome(oldFruitore.getConnettore().getNome());
                }
            }
        }
    }

    private void gestioneServizio(AccordoServizioParteSpecifica servizio, Soggetto soggetto, boolean reset, boolean mantieniFruitoriEsistenti, StatiAccordo statoAccordo) throws Exception {
        String name;
        String fileName;
        int k;
        servizio.setSuperUser(this.superUser);
        servizio.getServizio().setTipoSoggettoErogatore(soggetto.getTipo());
        servizio.getServizio().setNomeSoggettoErogatore(soggetto.getNome());
        if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica(servizio);
        }
        this.initializeWSDLBytes(servizio);
        for (k = 0; k < servizio.sizeAllegatoList(); ++k) {
            fileName = servizio.getAllegato(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getAllegato(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getAllegato(k).setFile(name);
            servizio.getAllegato(k).setRuolo(RuoliDocumento.allegato.toString());
            servizio.getAllegato(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSemiformaleList(); ++k) {
            fileName = servizio.getSpecificaSemiformale(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaSemiformale(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSemiformale(k).setFile(name);
            servizio.getSpecificaSemiformale(k).setRuolo(RuoliDocumento.specificaSemiformale.toString());
            servizio.getSpecificaSemiformale(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaLivelloServizioList(); ++k) {
            fileName = servizio.getSpecificaLivelloServizio(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaLivelloServizio(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaLivelloServizio(k).setFile(name);
            servizio.getSpecificaLivelloServizio(k).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
            servizio.getSpecificaLivelloServizio(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        for (k = 0; k < servizio.sizeSpecificaSicurezzaList(); ++k) {
            fileName = servizio.getSpecificaSicurezza(k).getFile();
            name = this.getNomeFile(fileName);
            servizio.getSpecificaSicurezza(k).setByteContenuto(this.readDocumento(fileName));
            servizio.getSpecificaSicurezza(k).setFile(name);
            servizio.getSpecificaSicurezza(k).setRuolo(RuoliDocumento.specificaSicurezza.toString());
            servizio.getSpecificaSicurezza(k).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
        }
        IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
        IDServizio idServizio = new IDServizio(idSoggetto, servizio.getServizio().getTipo(), servizio.getServizio().getNome());
        if (!reset && this.gestoreCRUD.existsAccordoServizioParteSpecifica(idServizio)) {
            this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornamento in corso...");
            AccordoServizioParteSpecifica old = ((IDriverRegistroServiziGet)((Object)this.gestoreCRUD)).getAccordoServizioParteSpecifica(idServizio);
            XMLDataConverter.impostaInformazioniRegistro_AccordoServizioParteSpecifica_update(servizio, old, mantieniFruitoriEsistenti);
            if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                XMLDataConverter.aggiornatoStatoFruitori(servizio, statoAccordo);
            }
            this.gestoreCRUD.updateAccordoServizioParteSpecifica(servizio);
            this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " aggiornato.");
        } else {
            this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creazione in corso...");
            if (CostantiConfigurazione.REGISTRO_DB.equals(this.tipoBEDestinazione)) {
                XMLDataConverter.aggiornatoStatoFruitori(servizio, statoAccordo);
            }
            this.gestoreCRUD.createAccordoServizioParteSpecifica(servizio);
            this.log.info("Servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome() + " erogato da " + soggetto.getTipo() + "/" + soggetto.getNome() + " creato.");
        }
    }
}

