/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistroRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.RegistroTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatiAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils.PdDConfig;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils.XMLDataConverter;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class TestXMLDataConverter {
    private static Boolean resetEffettuata = false;

    public static void main(String[] argoments) throws Exception {
        if (argoments.length < 9) {
            String errorMsg = "ERROR, Usage:  java TestXMLDataConverter sorgenteXML tipoRegistroCRUD proprietaRegistroCRUD reset tipoConversione gestioneSoggetti mantieniFruitori statoAccordiImportati protocolloDefault [[logger] [nomePddOperativa logger]]";
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        String args_sorgenteXML = argoments[0].trim();
        String args_tipoRegistroCRUD = argoments[1].trim();
        String args_proprietaRegistroCRUD = argoments[2].trim();
        String args_reset = argoments[3].trim();
        String args_tipoConversione = argoments[4].trim();
        String args_gestioneSoggetti = argoments[5].trim();
        String args_mantieniFruitori = argoments[6].trim();
        String args_statoAccordiImportati = argoments[7].trim();
        String args_protocolloDefault = argoments[8].trim();
        String args_nomePddOperativa = null;
        String args_logger = null;
        if (argoments.length == 10) {
            args_logger = argoments[9].trim();
        } else {
            args_nomePddOperativa = argoments[9].trim();
            args_logger = argoments[10].trim();
        }
        String loggerValue = null;
        try {
            if (args_logger != null) {
                LoggerWrapperFactory.setLogConfiguration(args_logger);
            } else {
                URL url = TestXMLDataConverter.class.getResource("/xml2backend.log4j2.properties");
                if (url != null) {
                    LoggerWrapperFactory.setLogConfiguration(url);
                } else {
                    File logFile = File.createTempFile("testXMLDataConverterRegistro_", ".log");
                    System.out.println("LogMessages write in " + logFile.getAbsolutePath());
                    LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%p <%d{dd-MM-yyyy HH:mm:ss}> %C.%M(%L): %m %n %n");
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante il caricamento del file di log loggerValue[" + loggerValue + "] : " + e.getMessage();
            System.err.println(errorMsg);
            System.out.println("Args.length: " + argoments.length);
            for (int i = 0; i < argoments.length; ++i) {
                System.out.println("Arg[" + i + "]=[" + argoments[i] + "]");
            }
            throw new Exception(errorMsg, e);
        }
        Logger log = LoggerWrapperFactory.getLogger("gestoreDatiRegistro");
        String statoAccordo = args_statoAccordiImportati;
        if (!(StatiAccordo.bozza.toString().equals(statoAccordo) || StatiAccordo.operativo.toString().equals(statoAccordo) || StatiAccordo.finale.toString().equals(statoAccordo))) {
            String errorMsg = "Opzione 'statoAccordiImportati' non valida (" + statoAccordo + "), valori possibili sono: " + StatiAccordo.bozza.toString() + "," + StatiAccordo.operativo.toString() + "," + StatiAccordo.finale.toString();
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        StatiAccordo statoAccordoObject = StatiAccordo.valueOf(statoAccordo);
        String protocolloDefault = args_protocolloDefault;
        boolean reset = Boolean.parseBoolean(args_reset);
        boolean gestioneSoggetti = Boolean.parseBoolean(args_gestioneSoggetti);
        boolean mantieniFruitori = Boolean.parseBoolean(args_mantieniFruitori);
        Properties reader = new Properties();
        try {
            reader.load(new FileInputStream(args_proprietaRegistroCRUD));
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args_proprietaRegistroCRUD + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        AccessoRegistroRegistro acCRUD = new AccessoRegistroRegistro();
        String superUser = null;
        boolean connectionDB = false;
        String connection = null;
        String username = null;
        String password = null;
        String driver = null;
        String tipoDatabase = null;
        try {
            acCRUD.setTipo(RegistroTipo.toEnumConstant(args_tipoRegistroCRUD));
            superUser = reader.getProperty("openspcoop2.superuser");
            if (superUser != null) {
                superUser.trim();
            }
            if ("db".equals(args_tipoRegistroCRUD)) {
                tipoDatabase = reader.getProperty("openspcoop2.registroServizi.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String dataSource = reader.getProperty("openspcoop2.registroServizi.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties("openspcoop2.registroServizi.db.context.", reader);
                    acCRUD.setLocation(dataSource);
                    acCRUD.setTipoDatabase(tipoDatabase);
                    Enumeration<Object> keys = context.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = context.getProperty(key);
                        acCRUD.putGenericProperties(key, value);
                    }
                } else {
                    connectionDB = true;
                    connection = reader.getProperty("openspcoop2.registroServizi.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    driver = reader.getProperty("openspcoop2.registroServizi.db.driver");
                    if (driver == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driver = driver.trim();
                    username = reader.getProperty("openspcoop2.registroServizi.db.user");
                    password = reader.getProperty("openspcoop2.registroServizi.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                }
            } else if ("uddi".equals(args_tipoRegistroCRUD)) {
                String pathPrefix;
                String urlPrefix;
                String passwordUDDI;
                String usernameUDDI;
                String publishUrl;
                String inquiryUrl = reader.getProperty("openspcoop2.registroServizi.uddi.inquiryUrl");
                if (inquiryUrl != null) {
                    inquiryUrl = inquiryUrl.trim();
                }
                if ((publishUrl = reader.getProperty("openspcoop2.registroServizi.uddi.publishUrl")) != null) {
                    publishUrl = publishUrl.trim();
                }
                if ((usernameUDDI = reader.getProperty("openspcoop2.registroServizi.uddi.username")) != null) {
                    usernameUDDI = usernameUDDI.trim();
                }
                if ((passwordUDDI = reader.getProperty("openspcoop2.registroServizi.uddi.password")) != null) {
                    passwordUDDI = passwordUDDI.trim();
                }
                if ((urlPrefix = reader.getProperty("openspcoop2.registroServizi.uddi.urlPrefix")) != null) {
                    urlPrefix = urlPrefix.trim();
                }
                if ((pathPrefix = reader.getProperty("openspcoop2.registroServizi.uddi.pathPrefix")) != null) {
                    pathPrefix = pathPrefix.trim();
                }
                acCRUD.setLocation(inquiryUrl);
                acCRUD.setUser(usernameUDDI);
                acCRUD.setPassword(passwordUDDI);
                acCRUD.putGenericProperties("publishUrl", publishUrl);
                acCRUD.putGenericProperties("urlPrefix", urlPrefix);
                acCRUD.putGenericProperties("pathPrefix", pathPrefix);
            } else if ("web".equals(args_tipoRegistroCRUD)) {
                String pathPrefix;
                String urlPrefix = reader.getProperty("openspcoop2.registroServizi.web.urlPrefix");
                if (urlPrefix != null) {
                    urlPrefix = urlPrefix.trim();
                }
                if ((pathPrefix = reader.getProperty("openspcoop2.registroServizi.web.pathPrefix")) != null) {
                    pathPrefix = pathPrefix.trim();
                }
                acCRUD.setLocation(urlPrefix);
                acCRUD.putGenericProperties("pathPrefix", pathPrefix);
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la lettura del file di properties [" + args_proprietaRegistroCRUD + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Connection connectionSQL = null;
        try {
            File fSorgente = new File(args_sorgenteXML);
            if (connectionDB) {
                Loader.getInstance().newInstance(driver);
                connectionSQL = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
            }
            TestXMLDataConverter.letturaSorgenti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, args_tipoConversione, args_nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la conversione XML dei dati: " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            try {
                if (connectionSQL != null) {
                    connectionSQL.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean reset(boolean b) {
        if (b) {
            Boolean bl = resetEffettuata;
            synchronized (bl) {
                if (!resetEffettuata.booleanValue()) {
                    resetEffettuata = true;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private static void letturaSorgenti(File fSorgente, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, StatiAccordo statoAccordoObject, String protocolloDefault, String tipoConversione, String nomePddOperativa, boolean gestioneSoggetti, boolean reset, boolean mantieniFruitori) throws Exception {
        if (fSorgente.isFile()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Sorgente XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            if (fSorgente.getName().endsWith(".xml")) {
                TestXMLDataConverter.converti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, tipoConversione, nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori);
            } else {
                log.debug("File [" + fSorgente.getAbsolutePath() + "] ignorato. Non possiede l'estensione .xml");
            }
        } else if (fSorgente.isDirectory()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Directory contenente gli XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            File[] f = fSorgente.listFiles();
            if (f == null || f.length <= 0) {
                throw new Exception("Directory [" + fSorgente.getAbsolutePath() + "] non contiene XML");
            }
            for (int i = 0; i < f.length; ++i) {
                TestXMLDataConverter.letturaSorgenti(f[i], connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, tipoConversione, nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori);
            }
        }
    }

    private static void converti(File f, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, StatiAccordo statoAccordoObject, String protocolloDefault, String tipoConversione, String nomePddOperativa, boolean gestioneSoggetti, boolean reset, boolean mantieniFruitori) throws Exception {
        Logger logDriver = null;
        if ("uddi".equals(acCRUD.getTipo()) || "web".equals(acCRUD.getTipo())) {
            logDriver = log;
        }
        XMLDataConverter dataConverter = null;
        dataConverter = connectionDB ? new XMLDataConverter(f.getAbsolutePath(), connectionSQL, tipoDatabase, superUser, protocolloDefault, log, logDriver) : new XMLDataConverter(f.getAbsolutePath(), acCRUD, superUser, protocolloDefault, log, logDriver);
        if ("insertUpdate".equals(tipoConversione)) {
            log.info("Inizio conversione...");
            if (nomePddOperativa != null) {
                PdDConfig pddConfig = new PdDConfig();
                String pddOperativa = nomePddOperativa;
                pddConfig.setPddOperativaCtrlstatSinglePdd(pddOperativa);
                dataConverter.convertXML(TestXMLDataConverter.reset(reset), pddConfig, mantieniFruitori, gestioneSoggetti, statoAccordoObject);
            } else {
                dataConverter.convertXML(TestXMLDataConverter.reset(reset), mantieniFruitori, gestioneSoggetti, statoAccordoObject);
            }
            log.info("Conversione terminata.");
        } else if ("delete".equals(tipoConversione)) {
            log.info("Inizio conversione...");
            dataConverter.delete(gestioneSoggetti);
            log.info("Conversione terminata.");
        } else {
            throw new Exception("Valore opzione 'tipoConversioneRegistroServizi' non gestito (valori possibili insertUpdate/delete): " + tipoConversione);
        }
    }
}

