/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.uddi;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IDriverWS;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IMonitoraggioRisorsa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.CredenzialiSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzioneFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloContesto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.uddi.UDDILib;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.web.XMLLib;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.slf4j.Logger;

public class DriverRegistroServiziUDDI
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private UDDILib uddiLib = null;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public DriverRegistroServiziUDDI(String inquiry, Logger alog) {
        this(inquiry, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String user, String password, Logger alog) {
        this(inquiry, null, user, password, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String urlPrefix, String pathPrefix, Logger alog) {
        this(inquiry, publish, null, null, urlPrefix, pathPrefix, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String user, String password, String urlPrefix, String pathPrefix, Logger alog) {
        try {
            this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverRegistroServiziUDDI.class) : alog;
            this.uddiLib = publish != null ? new UDDILib(inquiry, publish, user, password) : (user != null && password != null ? new UDDILib(inquiry, user, password) : new UDDILib(inquiry));
            try {
                this.validatoreRegistro = new ValidatoreXSD(this.log, DriverRegistroServiziUDDI.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (urlPrefix != null) {
                this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
            }
            if (urlPrefix != null && pathPrefix != null) {
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = this.uddiLib.create;
        }
        catch (Exception e) {
            this.log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            this.create = false;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoCooperazione accRichiesto = null;
        String urlXMLAccordoCooperazione = this.uddiLib.getUrlXmlAccordoCooperazione(idAccordo);
        if (urlXMLAccordoCooperazione == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[AccordoCooperazione] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[AccordoCooperazione] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo di Cooperazione [" + idAccordo + "] non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordoCooperazione idAccordoFiltro = null;
            if (filtroRicerca != null && filtroRicerca.getNomeAccordo() != null) {
                idAccordoFiltro = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(filtroRicerca.getNomeAccordo(), filtroRicerca.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiCooperazione(idAccordoFiltro, this.urlPrefix);
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoCooperazione ac = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeAccordoCooperazioneList() > 0) {
                        ac = rs.getAccordoCooperazione(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (ac == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String acURI = this.idAccordoCooperazioneFactory.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(this.idAccordoCooperazioneFactory.getIDAccordoFromValues(ac.getNome(), ac.getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoServizioParteComune accRichiesto = null;
        String urlXMLAccordoServizio = this.uddiLib.getUrlXmlAccordoServizio(idAccordo);
        if (urlXMLAccordoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoServizioParteComuneList() > 0) {
                accRichiesto = rs.getAccordoServizioParteComune(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteComune] Accordo di Servizio [" + idAccordo + "] non trovato.");
        }
        return accRichiesto;
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordo idAccordoFiltro = null;
            if (filtroRicerca != null && filtroRicerca.getNomeAccordo() != null) {
                IDSoggetto soggettoReferente = null;
                if (filtroRicerca.getTipoSoggettoReferente() != null && filtroRicerca.getNomeSoggettoReferente() != null) {
                    soggettoReferente = new IDSoggetto(filtroRicerca.getTipoSoggettoReferente(), filtroRicerca.getNomeSoggettoReferente());
                }
                idAccordoFiltro = this.idAccordoFactory.getIDAccordoFromValues(filtroRicerca.getNomeAccordo(), soggettoReferente, filtroRicerca.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiServizio(idAccordoFiltro, this.urlPrefix);
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoServizioParteComune as = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeAccordoServizioParteComuneList() > 0) {
                        as = rs.getAccordoServizioParteComune(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (as == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteComune] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String asURI = this.idAccordoFactory.getUriFromAccordo(as);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiServizioParteComune](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (as.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdAccordiServizioParteComune](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (as.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !as.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !as.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (as.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !as.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                    if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                        if (as.getServizioComposto() == null) continue;
                        IDAccordoCooperazione idAC = this.idAccordoCooperazioneFactory.getIDAccordoFromUri(as.getServizioComposto().getAccordoCooperazione());
                        if (filtroRicerca.getIdAccordoCooperazione().getNome() != null && !idAC.getNome().equals(filtroRicerca.getIdAccordoCooperazione().getNome()) || filtroRicerca.getIdAccordoCooperazione().getVersione() != null && !idAC.getVersione().equals(filtroRicerca.getIdAccordoCooperazione().getVersione())) {
                            continue;
                        }
                    } else if (filtroRicerca.isServizioComposto() != null && (filtroRicerca.isServizioComposto() != false ? as.getServizioComposto() == null : as.getServizioComposto() != null)) continue;
                }
                idAccordi.add(this.idAccordoFactory.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idAccordi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteComune error", e);
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getPortaDominio] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsPortaDominio(nomePdD)) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.uddiLib.getUrlXmlPortaDominio(nomePdD);
        if (urlXMLPortaDominio == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste nel repository http: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non trovata.");
        }
        return pddRichiesta;
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLPdd = this.uddiLib.getUrlXmlPortaDominio(nomeFiltro, this.urlPrefix);
            Vector<String> nomiPdd = new Vector<String>();
            for (int i = 0; i < urlXMLPdd.length; ++i) {
                PortaDominio pd = null;
                try {
                    this.validatoreRegistro.valida(urlXMLPdd[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLPdd[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizePortaDominioList() > 0) {
                        pd = rs.getPortaDominio(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Errore durante il parsing xml (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                if (pd == null) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] porta di dominio non definita per la url [" + urlXMLPdd[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMinDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDominio](FiltroByMaxDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pd.getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return nomiPdd;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idRuolo == null || idRuolo.getNome() == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getRuolo] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsRuolo(idRuolo.getNome())) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste: " + idRuolo.getNome());
        }
        Ruolo ruoloRichiesto = null;
        String urlXMLRuolo = this.uddiLib.getUrlXmlRuolo(idRuolo.getNome());
        if (urlXMLRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLRuolo);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo richiesto non esiste nel repository http: " + idRuolo.getNome());
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLRuolo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getRuolo] Riscontrato errore durante la validazione XSD del Ruolo (" + idRuolo.getNome() + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeRuoloList() > 0) {
                ruoloRichiesto = rs.getRuolo(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getRuolo] Errore durante il parsing xml del Ruolo (" + idRuolo.getNome() + "): " + e.getMessage(), e);
        }
        if (ruoloRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo [" + idRuolo.getNome() + "] non trovato.");
        }
        return ruoloRichiesto;
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLRuoli = this.uddiLib.getUrlXmlRuolo(nomeFiltro, this.urlPrefix);
            ArrayList<IDRuolo> idRuoli = new ArrayList<IDRuolo>();
            for (int i = 0; i < urlXMLRuoli.length; ++i) {
                Ruolo ruolo = null;
                try {
                    this.validatoreRegistro.valida(urlXMLRuoli[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Riscontrato errore durante la validazione XSD (" + urlXMLRuoli[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLRuoli[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeRuoloList() > 0) {
                        ruolo = rs.getRuolo(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Errore durante il parsing xml (" + urlXMLRuoli[i] + "): " + e.getMessage(), e);
                }
                if (ruolo == null) {
                    throw new DriverRegistroServiziException("[getAllIdRuoli] Ruolo non definito per la url [" + urlXMLRuoli[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMinDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ruolo.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdRuoli](FiltroByMaxDate) Ruolo [" + ruolo.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ruolo.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !ruolo.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia()) && (ruolo.getTipologia() == null || !RuoloTipologia.QUALSIASI.equals(ruolo.getTipologia()) && !ruolo.getTipologia().equals(filtroRicerca.getTipologia())) || filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto()) && (ruolo.getContestoUtilizzo() == null || !RuoloContesto.QUALSIASI.equals(ruolo.getContestoUtilizzo()) && !ruolo.getContestoUtilizzo().equals(filtroRicerca.getContesto()))) continue;
                }
                IDRuolo id = new IDRuolo(ruolo.getNome());
                idRuoli.add(id);
            }
            if (idRuoli.size() == 0) {
                throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idRuoli;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getSoggetto] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        Soggetto soggRichiesto = null;
        String urlXMLSoggetto = this.uddiLib.getUrlXmlSoggetto(idSoggetto);
        if (urlXMLSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Definizione xml non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto richiesto non esiste nel repository http: " + idSoggetto);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoList() > 0) {
                soggRichiesto = rs.getSoggetto(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto [" + idSoggetto + "] non trovato.");
        }
        return soggRichiesto;
    }

    @Override
    public Soggetto getSoggettoAutenticatoBasic(String user, String password) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoSsl(String subject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, principal);
    }

    private Soggetto _getSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String subject, String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case SSL: {
                if (subject != null && !"".equalsIgnoreCase(subject)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        IDSoggetto idSoggetto = null;
        try {
            FiltroRicercaSoggetti filtroRicerca = new FiltroRicercaSoggetti();
            CredenzialiSoggetto credenzialiSoggetto = new CredenzialiSoggetto();
            credenzialiSoggetto.setTipo(tipoCredenziale);
            switch (tipoCredenziale) {
                case BASIC: {
                    credenzialiSoggetto.setUser(user);
                    credenzialiSoggetto.setPassword(password);
                    break;
                }
                case SSL: {
                    credenzialiSoggetto.setSubject(subject);
                    break;
                }
                case PRINCIPAL: {
                    credenzialiSoggetto.setUser(principal);
                }
            }
            filtroRicerca.setCredenzialiSoggetto(credenzialiSoggetto);
            List<IDSoggetto> l = this.getAllIdSoggetti(filtroRicerca);
            if (l.size() > 1) {
                throw new DriverRegistroServiziException("Trovato pi\u00f9 di un soggetto che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
            }
            if (l.size() == 1) {
                idSoggetto = l.get(0);
            }
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
        }
        return this.getSoggetto(idSoggetto);
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String[] urlXMLSoggetti = this.uddiLib.getUrlXmlSoggetti();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < urlXMLSoggetti.length; ++i) {
                Soggetto ss = null;
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetti[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLSoggetti[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeSoggettoList() > 0) {
                        ss = rs.getSoggetto(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Errore durante il parsing xml (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                if (ss == null) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] soggetto non definito per la url [" + urlXMLSoggetti[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome()) || filtroRicerca.getNomePdd() != null && !ss.getPortaDominio().equals(filtroRicerca.getNomePdd())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (ss.getRuoli() == null) continue;
                        boolean contains = false;
                        for (int j = 0; j < ss.getRuoli().sizeRuoloList(); ++j) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(ss.getRuoli().getRuolo(j).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto() != null) {
                        CredenzialiSoggetto credenziali = ss.getCredenziali();
                        if (credenziali == null || filtroRicerca.getCredenzialiSoggetto().getTipo() != null && (credenziali.getTipo() != null ? !filtroRicerca.getCredenzialiSoggetto().getTipo().equals(credenziali.getTipo()) : !filtroRicerca.getCredenzialiSoggetto().getTipo().equals(CredenzialeTipo.SSL))) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getUser() != null && !filtroRicerca.getCredenzialiSoggetto().getUser().equals(credenziali.getUser()) || filtroRicerca.getCredenzialiSoggetto().getPassword() != null && !filtroRicerca.getCredenzialiSoggetto().getPassword().equals(credenziali.getPassword())) continue;
                        if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                            try {
                                if (credenziali.getSubject() == null || !Utilities.sslVerify(credenziali.getSubject(), filtroRicerca.getCredenzialiSoggetto().getSubject(), this.log)) {
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                throw new DriverRegistroServiziException(e.getMessage(), e);
                            }
                        }
                    }
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idSoggetti;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio == null || idServizio.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idServizio.getSoggettoErogatore())) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Il soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        if (!this.uddiLib.existsServizio(idServizio)) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Il servizio [" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + "] erogato dal soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
        }
        AccordoServizioParteSpecifica servRichiesto = null;
        String urlXMLServizio = this.uddiLib.getUrlXmlServizio(idServizio);
        if (urlXMLServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Definizione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = HttpUtilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio richiesto non esiste nel repository http: " + idServizio);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Riscontrato errore durante la validazione XSD del servizio(" + idServizio + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                servRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                servRichiesto.getServizio().setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                servRichiesto.getServizio().setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Errore durante il parsing xml del servizio(" + idServizio + "): " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio non trovato.");
        }
        return servRichiesto;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        throw new DriverRegistroServiziException("Not Implemented");
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null || idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
        }
        String[] url = this.uddiLib.getUrlXmlServizi(idSoggetto, idAccordo);
        if (url == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizi correlati che rispettano il parametri di ricerca, non esistenti.");
        }
        AccordoServizioParteSpecifica servCorrelatoRichiesto = null;
        for (int i = 0; i < url.length; ++i) {
            ByteArrayInputStream bin = null;
            InputStreamReader istr = null;
            try {
                IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                byte[] fileXML = null;
                try {
                    fileXML = HttpUtilities.requestHTTPFile(url[i]);
                }
                catch (UtilsException e) {
                    if ("404".equals(e.getMessage())) {
                        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio richiesto non esiste nel repository http, accordo:" + idAccordo + " e soggetto:" + idSoggetto);
                    }
                    throw e;
                }
                try {
                    this.validatoreRegistro.valida(url[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Riscontrato errore durante la validazione XSD del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
                }
                bin = new ByteArrayInputStream(fileXML);
                istr = new InputStreamReader(bin);
                RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                    servCorrelatoRichiesto = rs.getSoggetto(0).getAccordoServizioParteSpecifica(0);
                    servCorrelatoRichiesto.getServizio().setNomeSoggettoErogatore(idSoggetto.getNome());
                    servCorrelatoRichiesto.getServizio().setTipoSoggettoErogatore(idSoggetto.getTipo());
                }
                istr.close();
                bin.close();
                if (servCorrelatoRichiesto == null) continue;
                break;
            }
            catch (Exception e) {
                try {
                    if (istr != null) {
                        istr.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (e instanceof DriverRegistroServiziNotFound) {
                    throw (DriverRegistroServiziNotFound)e;
                }
                throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Errore durante il parsing xml del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
            }
        }
        if (servCorrelatoRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] Servizio non trovato.");
        }
        return servCorrelatoRichiesto;
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordo idAccordo = null;
            IDSoggetto soggettoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (filtroRicerca != null) {
                idAccordo = filtroRicerca.getIdAccordo();
                if (filtroRicerca.getTipoSoggettoErogatore() != null && filtroRicerca.getNomeSoggettoErogatore() != null) {
                    soggettoErogatore = new IDSoggetto(filtroRicerca.getTipoSoggettoErogatore(), filtroRicerca.getNomeSoggettoErogatore());
                }
                tipoServizio = filtroRicerca.getTipo();
                nomeServizio = filtroRicerca.getNome();
            }
            String[] urlXMLServizi = this.uddiLib.getUrlXMLServiziBySearch(idAccordo, soggettoErogatore, tipoServizio, nomeServizio);
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < urlXMLServizi.length; ++i) {
                AccordoServizioParteSpecifica serv = null;
                try {
                    this.validatoreRegistro.valida(urlXMLServizi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdServizi] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLServizi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                        Soggetto s = rs.getSoggetto(0);
                        if (s.sizeAccordoServizioParteSpecificaList() <= 0) continue;
                        serv = s.getAccordoServizioParteSpecifica(0);
                        serv.getServizio().setNomeSoggettoErogatore(s.getNome());
                        serv.getServizio().setTipoSoggettoErogatore(s.getTipo());
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdServizi] Errore durante il parsing xml del servizio(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                if (serv == null) {
                    throw new DriverRegistroServiziException("[getAllIdServizi] servizio non definito per la url [" + urlXMLServizi[i] + "]");
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !serv.getServizio().getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !serv.getServizio().getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdServizi](FiltroByMinDate) Servizio[" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] SoggettoErogatore[" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdServizi](FiltroByMaxDate) Servizio[" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] SoggettoErogatore[" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !serv.getServizio().getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getServizio().getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!serv.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                    if (serv.sizeFruitoreList() <= 0) continue;
                    boolean found = false;
                    for (int k = 0; k < serv.sizeFruitoreList(); ++k) {
                        Fruitore fruitore = serv.getFruitore(k);
                        if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                IDServizio idServ = new IDServizio(serv.getServizio().getTipoSoggettoErogatore(), serv.getServizio().getNomeSoggettoErogatore(), serv.getServizio().getTipo(), serv.getServizio().getNome());
                idServ.setUriAccordo(serv.getAccordoServizioParteComune());
                idServ.setTipologiaServizio(serv.getServizio().getTipologiaServizio().toString());
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idServizi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            IDAccordo idAccordo = null;
            IDSoggetto soggettoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (filtroRicerca != null) {
                idAccordo = filtroRicerca.getIdAccordo();
                if (filtroRicerca.getTipoSoggettoErogatore() != null && filtroRicerca.getNomeSoggettoErogatore() != null) {
                    soggettoErogatore = new IDSoggetto(filtroRicerca.getTipoSoggettoErogatore(), filtroRicerca.getNomeSoggettoErogatore());
                }
                tipoServizio = filtroRicerca.getTipo();
                nomeServizio = filtroRicerca.getNome();
            }
            String[] urlXMLServizi = this.uddiLib.getUrlXMLServiziBySearch(idAccordo, soggettoErogatore, tipoServizio, nomeServizio);
            Vector<IDAccordo> idServizi = new Vector<IDAccordo>();
            for (int i = 0; i < urlXMLServizi.length; ++i) {
                AccordoServizioParteSpecifica serv = null;
                try {
                    this.validatoreRegistro.valida(urlXMLServizi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteSpecifica] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = HttpUtilities.requestHTTPFile(urlXMLServizi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeSoggettoList() > 0 && rs.getSoggetto(0).sizeAccordoServizioParteSpecificaList() > 0) {
                        Soggetto s = rs.getSoggetto(0);
                        if (s.sizeAccordoServizioParteSpecificaList() <= 0) continue;
                        serv = s.getAccordoServizioParteSpecifica(0);
                        serv.getServizio().setNomeSoggettoErogatore(s.getNome());
                        serv.getServizio().setTipoSoggettoErogatore(s.getTipo());
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception uctx) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteSpecifica] Errore durante il parsing xml del servizio(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                if (serv == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizioParteSpecifica] servizio non definito per la url [" + urlXMLServizi[i] + "]");
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !serv.getServizio().getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !serv.getServizio().getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServizioParteSpecifica](FiltroByMinDate) Servizio[" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] SoggettoErogatore[" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdAccordiServizioParteSpecifica](FiltroByMaxDate) Servizio[" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] SoggettoErogatore[" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !serv.getServizio().getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getServizio().getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!serv.getAccordoServizioParteComune().equals(uriAccordo)) continue;
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null) {
                    if (serv.sizeFruitoreList() <= 0) continue;
                    boolean found = false;
                    for (int k = 0; k < serv.sizeFruitoreList(); ++k) {
                        Fruitore fruitore = serv.getFruitore(k);
                        if (filtroRicerca.getTipoSoggettoFruitore() != null && !fruitore.getTipo().equals(filtroRicerca.getTipoSoggettoFruitore()) || filtroRicerca.getNomeSoggettoFruitore() != null && !fruitore.getNome().equals(filtroRicerca.getNomeSoggettoFruitore())) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                idServizi.add(this.idAccordoFactory.getIDAccordoFromAccordo(serv));
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            return idServizi;
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteSpecifica error", e);
        }
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
            String urlXML = this.urlPrefix + "accordi_cooperazione/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione)) + ".xml";
            this.uddiLib.createAccordoCooperazione(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi_cooperazione/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoCooperazione(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e);
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
            this.uddiLib.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(accordoCooperazione) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordo, accordoServizio);
            String urlXML = this.urlPrefix + "accordi/" + this.generatoreXML.mappingIDAccordoToFileName(this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio)) + ".xml";
            this.uddiLib.createAccordoServizio(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteComune] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteComune] Accordo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoServizio(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizioParteComune(idAccordoOLD, accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi/" + this.generatoreXML.mappingIDAccordoToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoServizio(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteComune] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e);
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Servizio Parte Comune da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizioParteComune(idAccordo);
            this.uddiLib.deleteAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteComune] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(accordoServizio) + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
            String urlXML = this.urlPrefix + "porte_di_dominio/" + pdd.getNome() + ".xml";
            this.uddiLib.createPortaDominio(pdd.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.uddiLib.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        if (pddOLD == null) {
            pddOLD = pdd.getNome();
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definito");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.uddiLib.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
            if (!pddOLD.equals(pddNEW)) {
                String urlXML = this.urlPrefix + "porte_di_dominio/" + pddNEW + ".xml";
                this.uddiLib.updatePortaDominio(pddOLD, pddNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e);
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definito");
            }
            if (!this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
            this.uddiLib.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[createRuolo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il ruolo [" + ruolo.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(ruolo.getNome(), ruolo);
            String urlXML = this.urlPrefix + "ruoli/" + ruolo.getNome() + ".xml";
            this.uddiLib.createRuolo(ruolo.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createRuolo] Errore generatosi durante la creazione di un nuovo ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        if (idRuolo == null || idRuolo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsRuolo(idRuolo.getNome());
        }
        catch (Exception e) {
            this.log.error("[existsRuolo] Ruolo non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[updateRuolo] Parametro Non Valido");
        }
        IDRuolo idRuoloOLD = null;
        idRuoloOLD = new IDRuolo(ruolo.getNome());
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idRuoloOLD == null || idRuoloOLD.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da modificare non definito");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo modificato non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsRuolo(idRuoloOLD.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            IDRuolo idRuoloNEW = new IDRuolo(ruolo.getNome());
            if (!idRuoloOLD.equals(idRuoloNEW) && this.uddiLib.existsRuolo(idRuoloNEW.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + idRuoloNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createRuolo(idRuoloOLD.getNome(), ruolo);
            if (!idRuoloOLD.equals(idRuoloNEW)) {
                String urlXML = this.urlPrefix + "ruoli/" + idRuoloNEW + ".xml";
                this.uddiLib.updateRuolo(idRuoloOLD.getNome(), idRuoloNEW.getNome(), urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateRuolo] Errore generatosi durante la modifica del ruolo [" + idRuoloOLD + "]: " + e);
        }
    }

    @Override
    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[deleteRuolo] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (ruolo.getNome() == null) {
                throw new DriverRegistroServiziException("Ruolo da eliminare non definito");
            }
            if (!this.uddiLib.existsRuolo(ruolo.getNome())) {
                throw new DriverRegistroServiziException("Il Ruolo [" + ruolo.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deleteRuolo(ruolo.getNome());
            this.uddiLib.deleteRuolo(ruolo.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteRuolo] Errore generatosi durante l'eliminazione del ruolo [" + ruolo.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                // empty if block
            }
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            if (this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggetto_string + "/" + idSoggetto_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
            this.uddiLib.createSoggetto(idSoggetto, soggetto.getDescrizione(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.uddiLib.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = soggetto.getOldTipoForUpdate();
        String nomeOLD = soggetto.getOldNomeForUpdate();
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto modificato non definito");
            }
            if (soggetto.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (soggetto.getCodiceIpa() == null || "".equals(soggetto.getCodiceIpa())) {
                // empty if block
            }
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/" + idSoggettoNEW_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
            this.uddiLib.updateIdentificativoPortaSoggetto(idSoggettoOLD, soggetto.getIdentificativoPorta());
            this.uddiLib.updateDescrizioneSoggetto(idSoggettoOLD, soggetto.getDescrizione());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.uddiLib.updateUrlXmlSoggetto(idSoggettoOLD, urlXML);
                this.uddiLib.updateIdSoggetto(idSoggettoOLD, idSoggettoNEW);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
            this.uddiLib.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (servizio.getNomeSoggettoErogatore() == null || servizio.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Servizio, non definito");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.uddiLib.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            for (i = 0; i < servizio.sizeParametriAzioneList(); ++i) {
                ServizioAzione checkAz = servizio.getParametriAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeParametriFruitoreList(); ++j) {
                    ServizioAzioneFruitore checkAzFr = checkAz.getParametriFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getTipo() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            if (!this.uddiLib.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = servizio.getTipo() + servizio.getNome();
            IDServizio idServizio = new IDServizio(idSoggettoErogatore, servizio.getTipo(), servizio.getNome());
            if (this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggettoErogatore_string + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoErogatore_string + "/servizi/" + idServizio_string + ".xml";
            this.generatoreXML.createAccordoServizioParteSpecifica(idServizio, asps);
            this.uddiLib.createServizio(idServizio, urlXML, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizioParteSpecifica] Errore generatosi durante la creazione del nuovo Servizio [" + servizio.getTipo() + servizio.getNome() + "] erogato dal soggetto [" + servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore() + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idServizio);
            return true;
        }
        catch (DriverRegistroServiziNotFound de) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        try {
            this.getAccordoServizioParteSpecifica(idAccordo);
            return true;
        }
        catch (DriverRegistroServiziNotFound de) {
            return false;
        }
        catch (Exception e) {
            this.log.error("[existsAccordoServizioParteSpecifica] Servizio non trovato: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        String tipoServizioOLD = servizio.getOldTipoForUpdate();
        String nomeServizioOLD = servizio.getOldNomeForUpdate();
        if (tipoServizioOLD == null || nomeServizioOLD == null) {
            tipoServizioOLD = servizio.getTipo();
            nomeServizioOLD = servizio.getNome();
        }
        String tipoSoggettoOLD = servizio.getOldTipoSoggettoErogatoreForUpdate();
        String nomeSoggettoOLD = servizio.getOldNomeSoggettoErogatoreForUpdate();
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = servizio.getTipoSoggettoErogatore();
            nomeSoggettoOLD = servizio.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD;
        IDServizio idServizioOLD = new IDServizio(idSoggettoOLD, tipoServizioOLD, nomeServizioOLD);
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto da modificare, erogatore del servizio, non definito");
            }
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio, non definiti");
            }
            if (asps.getAccordoServizioParteComune() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < asps.sizeFruitoreList(); ++i) {
                Fruitore checkFr = asps.getFruitore(i);
                if (checkFr.getNome() != null && checkFr.getTipo() != null) continue;
                throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
            }
            for (i = 0; i < servizio.sizeParametriAzioneList(); ++i) {
                ServizioAzione checkAz = servizio.getParametriAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !CostantiRegistroServizi.DISABILITATO.equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeParametriFruitoreList(); ++j) {
                    ServizioAzioneFruitore checkAzFr = checkAz.getParametriFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getNome() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome/tipo o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.uddiLib.existsServizio(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = new IDServizio(idSoggettoNEW, servizio.getTipo(), servizio.getNome());
            String idServizioNEW_string = servizio.getTipo() + servizio.getNome();
            if (!idServizioOLD_string.equals(idServizioNEW_string) && this.uddiLib.existsServizio(idServizioNEW)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/servizi/" + idServizioNEW_string + ".xml";
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioOLD, asps);
                this.uddiLib.updateAccordoServizio(idServizioOLD, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                this.uddiLib.updateUrlXmlServizio(idServizioOLD, urlXML);
                this.uddiLib.updateIdServizio(idServizioOLD, idServizioNEW);
            } else {
                this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizioOLD);
                this.uddiLib.deleteServizio(idServizioOLD);
                this.generatoreXML.createAccordoServizioParteSpecifica(idServizioNEW, asps);
                this.uddiLib.createServizio(idServizioNEW, urlXML, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizioParteSpecifica] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps) throws DriverRegistroServiziException {
        if (asps == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        Servizio servizio = asps.getServizio();
        String idSoggetto_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
        String idServizio_string = servizio.getTipo() + servizio.getNome();
        try {
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto non definito");
            }
            if (servizio.getTipo() == null || servizio.getNome() == null) {
                throw new DriverRegistroServiziException("Servizio da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
            if (!this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteAccordoServizioParteSpecifica(idServizio);
            this.uddiLib.deleteServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizioParteSpecifica] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        Serializable idS;
        Serializable idInEliminazione;
        int i;
        Object inEliminazione = null;
        try {
            AccordoServizioParteComune[] accordiRegistrati = this.generatoreXML.getAccordiServizioParteComune();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    idInEliminazione = this.idAccordoFactory.getIDAccordoFromAccordo(accordiRegistrati[i]);
                    this.log.info("eliminazione accordo di servizio [" + idInEliminazione + "] in corso...");
                    if (this.existsAccordoServizioParteComune((IDAccordo)idInEliminazione)) {
                        this.deleteAccordoServizioParteComune(accordiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoServizioParteComune((IDAccordo)idInEliminazione);
                    }
                    this.log.info("eliminazione accordo di servizio [" + idInEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    idInEliminazione = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(accordiCooperazioneRegistrati[i]);
                    this.log.info("eliminazione accordo di cooperazione [" + (IDAccordoCooperazione)idInEliminazione + "] in corso...");
                    if (this.existsAccordoCooperazione((IDAccordoCooperazione)idInEliminazione)) {
                        this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoCooperazione((IDAccordoCooperazione)idInEliminazione);
                    }
                    this.log.info("eliminazione accordo di cooperazione [" + (IDAccordoCooperazione)idInEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            AccordoServizioParteSpecifica[] serviziRegistrati = this.generatoreXML.getAccordiServiziParteSpecifica();
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    inEliminazione = serviziRegistrati[i].getServizio().getTipo() + "/" + serviziRegistrati[i].getServizio().getNome() + " erogato da [" + serviziRegistrati[i].getServizio().getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getServizio().getNomeSoggettoErogatore();
                    this.log.info("eliminazione servizio [" + (String)inEliminazione + "] in corso...");
                    idS = new IDServizio(serviziRegistrati[i].getServizio().getTipoSoggettoErogatore(), serviziRegistrati[i].getServizio().getNomeSoggettoErogatore(), serviziRegistrati[i].getServizio().getTipo(), serviziRegistrati[i].getServizio().getNome());
                    if (this.existsAccordoServizioParteSpecifica((IDServizio)idS)) {
                        this.deleteAccordoServizioParteSpecifica(serviziRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoServizioParteSpecifica((IDServizio)idS);
                    }
                    this.log.info("eliminazione servizio [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            Soggetto[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    inEliminazione = soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome();
                    this.log.info("eliminazione soggetto [" + (String)inEliminazione + "] in corso...");
                    idS = new IDSoggetto(soggettiRegistrati[i].getTipo(), soggettiRegistrati[i].getNome());
                    if (this.existsSoggetto((IDSoggetto)idS)) {
                        this.deleteSoggetto(soggettiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteSoggetto((IDSoggetto)idS);
                    }
                    this.log.info("eliminazione soggetto [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    inEliminazione = pddRegistrate[i].getNome();
                    this.log.info("eliminazione porta di dominio [" + (String)inEliminazione + "] in corso...");
                    if (this.existsPortaDominio((String)inEliminazione)) {
                        this.deletePortaDominio(pddRegistrate[i]);
                    } else {
                        this.generatoreXML.deletePortaDominio((String)inEliminazione);
                    }
                    this.log.info("eliminazione porta di dominio [" + (String)inEliminazione + "] effettuata.");
                }
            }
        }
        catch (Exception e) {
            this.log.info("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate [" + (String)inEliminazione + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            if (this.uddiLib.getTModel("isAliveTest", "OpenSPCoop:SPCoopIdentifier") == null) {
                throw new Exception("TModel [OpenSPCoop:SPCoopIdentifier] non trovata");
            }
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }
}

