/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db;

import it.link.pdd.tools.migrazione_govway.generic_project.dao.jdbc.utils.JDBCObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBOggettiInUsoUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ErrorsHandlerCostant;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IDriverWS;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IMonitoraggioRisorsa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ISearch;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.Costanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.CostantiDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazioneWithSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazionePartecipanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Azione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.CredenzialiSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RuoliSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RuoloSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.PddTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProprietariDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoliDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloContesto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoloTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatiAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.ConnettorePropertiesUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziCRUD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.ValidazioneStatoPackageException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB_LIB;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.UtilsAlreadyExistsException;
import it.link.pdd.tools.migrazione_govway.utils.beans.BaseBean;
import it.link.pdd.tools.migrazione_govway.utils.datasource.DataSourceFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.GestoreJNDI;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class DriverRegistroServiziDB
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    public DataSource datasource = null;
    private Connection globalConnection = null;
    private boolean atomica = true;
    String tabellaSoggetti = "soggetti";
    private Logger log = null;
    private String tipoDB = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public String getTipoDB() {
        return this.tipoDB;
    }

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, String tipoDB) {
        this(nomeDataSource, prop, null, tipoDB, false, false);
    }

    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, Logger alog, String tipoDB) {
        this(nomeDataSource, prop, alog, tipoDB, false, false);
    }

    /*
     * Unable to fully structure code
     */
    public DriverRegistroServiziDB(String nomeDataSource, Properties prop, Logger alog, String tipoDB, boolean useOp2UtilsDatasource, boolean bindJMX) {
        super();
        try {
            if (alog == null) {
                this.log = LoggerWrapperFactory.getLogger("DRIVER_DB_REGISTRO");
            } else {
                this.log = alog;
                DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
            }
            this.log.info("Inizializzo DriverRegistroServiziDB..");
            if (useOp2UtilsDatasource) {
                dsParams = Costanti.getDataSourceParamsPdD(bindJMX, tipoDB);
                try {
                    this.datasource = DataSourceFactory.newInstance(nomeDataSource, prop, dsParams);
                }
                catch (UtilsAlreadyExistsException exists) {
                    this.datasource = DataSourceFactory.getInstance(nomeDataSource);
                    if (this.datasource != null) ** GOTO lbl29
                    throw new Exception("Lookup datasource non riuscita (" + exists.getMessage() + ")", exists);
                }
            } else {
                gestoreJNDI = new GestoreJNDI(prop);
                this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            }
lbl29:
            // 3 sources

            if (this.datasource != null) {
                this.create = true;
            }
        }
        catch (Exception ne) {
            this.log.error("Eccezione acquisendo il datasource: " + ne.getMessage(), (Throwable)ne);
            this.create = false;
        }
        if (tipoDB == null) {
            this.log.error("Il tipoDatabase non puo essere null.");
            this.create = false;
        }
        this.atomica = true;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, String tipoDB) throws DriverRegistroServiziException {
        this(connection, null, tipoDB);
    }

    public DriverRegistroServiziDB(Connection connection, Logger alog, String tipoDB) throws DriverRegistroServiziException {
        if (alog == null) {
            this.log = LoggerWrapperFactory.getLogger("DRIVER_DB_REGISTRO");
        } else {
            this.log = alog;
            DriverRegistroServiziDB_LIB.initStaticLogger(this.log);
        }
        if (connection == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::DriverRegistroServiziDB(Connection ) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        DriverRegistroServiziDB_LIB.setTipoDB(tipoDB);
    }

    public Connection getConnection(String methodName) throws DriverRegistroServiziException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource(methodName);
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnection] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return con;
    }

    public void releaseConnection(Connection con) {
        if (this.atomica) {
            try {
                con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection getConnectionFromDatasource(String methodName) throws Exception {
        if (this.datasource instanceof it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource) {
            return ((it.link.pdd.tools.migrazione_govway.utils.datasource.DataSource)this.datasource).getWrappedConnection(null, "DriverRegistroServizi." + methodName);
        }
        return this.datasource.getConnection();
    }

    public List<List<Object>> readCustom(ISQLQueryObject sqlQueryObject, List<Class<?>> returnTypes, List<JDBCObject> paramTypes) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("readCustom") : this.globalConnection;
            List<List<Object>> list = DBUtils.readCustom(this.log, con, this.tipoDB, sqlQueryObject, returnTypes, paramTypes);
            return list;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readCustom]: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(idAccordo, false);
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug("richiesto getAccordoCooperazione: " + idAccordo.toString());
        AccordoCooperazione accordoCooperazione = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm2 = null;
        ResultSet rs2 = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAccordoCooperazione(idAccordo)") : this.globalConnection;
            long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, con, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] Accordo non trovato (id:" + idAccordoLong + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            if (rs.next()) {
                accordoCooperazione = new AccordoCooperazione();
                accordoCooperazione.setId(rs.getLong("id"));
                String tmp = rs.getString("nome");
                accordoCooperazione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                accordoCooperazione.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(rs.getInt("id_referente"), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    accordoCooperazione.setSoggettoReferente(assr);
                }
                if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                    accordoCooperazione.setVersione(rs.getString("versione"));
                }
                accordoCooperazione.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    accordoCooperazione.setPrivato(true);
                } else {
                    accordoCooperazione.setPrivato(false);
                }
                tmp = rs.getString("superuser");
                accordoCooperazione.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoCooperazione.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
                rs = stm.executeQuery();
                while (rs.next()) {
                    IDSoggetto soggettoReferente;
                    long idAccServizioComposto = rs.getLong("id_accordo");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addSelectField("versione");
                    sqlQueryObject.addSelectField("id_referente");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm2 = con.prepareStatement(sqlQuery);
                    stm2.setLong(1, idAccServizioComposto);
                    rs2 = stm2.executeQuery();
                    if (rs2.next()) {
                        soggettoReferente = null;
                        if (rs2.getLong("id_referente") > 0L) {
                            Soggetto s = this.getSoggetto(rs2.getLong("id_referente"));
                            soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                        }
                    } else {
                        throw new DriverRegistroServiziException("IDAccordo con id [" + rs.getLong("id_accordo_servizio") + "] non presente");
                    }
                    String uriAccordo = this.idAccordoFactory.getUriFromValues(rs2.getString("nome"), soggettoReferente, rs2.getString("versione"));
                    accordoCooperazione.addUriServiziComposti(uriAccordo);
                    rs2.close();
                    stm2.close();
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_accordo_cooperazione = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
                rs = stm.executeQuery();
                IdSoggetto accCompPartecipante = null;
                AccordoCooperazionePartecipanti accCopPartecipanti = null;
                while (rs.next()) {
                    accCompPartecipante = new IdSoggetto();
                    accCompPartecipante.setIdSoggetto(rs.getLong("id_soggetto"));
                    Soggetto s = this.getSoggetto(rs.getLong("id_soggetto"), con);
                    accCompPartecipante.setTipo(s.getTipo());
                    accCompPartecipante.setNome(s.getNome());
                    if (accCopPartecipanti == null) {
                        accCopPartecipanti = new AccordoCooperazionePartecipanti();
                        accordoCooperazione.setElencoPartecipanti(accCopPartecipanti);
                    }
                    accordoCooperazione.getElencoPartecipanti().addSoggettoPartecipante(accCompPartecipante);
                }
                rs.close();
                stm.close();
                try {
                    List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.tipoDB);
                    for (int i = 0; i < allegati.size(); ++i) {
                        accordoCooperazione.addAllegato(allegati.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound allegati) {
                    // empty catch block
                }
                try {
                    List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoCooperazione, readContenutoAllegati, con, this.tipoDB);
                    for (int i = 0; i < specificheSemiformali.size(); ++i) {
                        accordoCooperazione.addSpecificaSemiformale(specificheSemiformali.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {}
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            AccordoCooperazione accordoCooperazione2 = accordoCooperazione;
            return accordoCooperazione2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDAccordoCooperazioneWithSoggetto getIdAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoCooperazione(id, null);
    }

    public IDAccordoCooperazioneWithSoggetto getIdAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getIdAccordoCooperazione: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazioneWithSoggetto idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("getIdAccordoCooperazione(longId)") : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L && (referente = this.getIdSoggetto(idReferente, con)) == null) {
                    throw new Exception("Soggetto referente non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDAccordoCooperazione idAccordoCoop = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            idAccordo = new IDAccordoCooperazioneWithSoggetto(idAccordoCoop);
            idAccordo.setSoggettoReferente(referente);
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoCooperazione] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordo;
    }

    public AccordoCooperazione getAccordoCooperazione(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(id, null);
    }

    public AccordoCooperazione getAccordoCooperazione(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getAccordoCooperazione: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordoCooperazione idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("getAccordoCooperazione(longId)") : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoCooperazione] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoCooperazione] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getAccordoCooperazione(idAccordo);
    }

    @Override
    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdAccordiCooperazione...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdAccordiCooperazione") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
            }
            sqlQueryObject.addSelectField("accordi_cooperazione", "nome");
            sqlQueryObject.addSelectField("accordi_cooperazione", "versione");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.ora_registrazione < ?");
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.nome = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.versione = ?");
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi_cooperazione.id_referente=" + this.tabellaSoggetti + ".id");
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    this.log.debug("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.log.debug("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        this.log.debug("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        this.log.debug("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            while (rs.next()) {
                IDAccordoCooperazione idAccordo = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(rs.getString("nome"), rs.getString("versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordoCooperazione> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizio tupe=1");
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(1, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoCooperazione] Errore durante la creazione dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoCooperazione");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            long idAccordoLong = DBUtils.getIdAccordoCooperazione(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(2, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoCooperazione] Errore durante l'update dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccordoCooperazione");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizio type = 3");
            DriverRegistroServiziDB_LIB.CRUDAccordoCooperazione(3, accordoCooperazione, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoCooperazione] Errore durante la delete dell'accordo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(idAccordo, false);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome non e' definito");
        }
        this.log.debug("richiesto getAccordoServizioParteComune: " + idAccordo.toString());
        AccordoServizioParteComune accordoServizio = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAccordoServizioParteComune(idAccordo)") : this.globalConnection;
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] Accordo non trovato (id:" + idAccordo + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            if (rs.next()) {
                int i;
                accordoServizio = new AccordoServizioParteComune();
                accordoServizio.setId(rs.getLong("id"));
                String tmp = rs.getString("nome");
                accordoServizio.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                accordoServizio.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                accordoServizio.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                if (accordoServizio.getProfiloCollaborazione() == null) {
                    accordoServizio.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
                }
                accordoServizio.setByteWsdlDefinitorio((tmp = rs.getString("wsdl_definitorio")) == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_concettuale");
                accordoServizio.setByteWsdlConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_logico_erogatore");
                accordoServizio.setByteWsdlLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("wsdl_logico_fruitore");
                accordoServizio.setByteWsdlLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_concettuale");
                accordoServizio.setByteSpecificaConversazioneConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_erogatore");
                accordoServizio.setByteSpecificaConversazioneErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                tmp = rs.getString("spec_conv_fruitore");
                accordoServizio.setByteSpecificaConversazioneFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
                accordoServizio.setUtilizzoSenzaAzione(rs.getInt("utilizzo_senza_azione") == 1);
                tmp = rs.getString("filtro_duplicati");
                accordoServizio.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                accordoServizio.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                accordoServizio.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                accordoServizio.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                accordoServizio.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("superuser");
                accordoServizio.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    accordoServizio.setPrivato(true);
                } else {
                    accordoServizio.setPrivato(false);
                }
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoServizio.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if (rs.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(rs.getInt("id_referente"), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    assr.setId(soggRef.getId());
                    accordoServizio.setSoggettoReferente(assr);
                }
                if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                    accordoServizio.setVersione(rs.getString("versione"));
                }
                accordoServizio.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idAccordoLong);
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
                rs = stm.executeQuery();
                Azione azione = null;
                while (rs.next()) {
                    azione = new Azione();
                    tmp = rs.getString("conferma_ricezione");
                    azione.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("consegna_in_ordine");
                    azione.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("filtro_duplicati");
                    azione.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("identificativo_collaborazione");
                    azione.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("nome");
                    azione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("scadenza");
                    azione.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("profilo_collaborazione");
                    azione.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                    tmp = rs.getString("correlata");
                    azione.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                    tmp = rs.getString("profilo_azione");
                    if (tmp == null || tmp.equals("")) {
                        azione.setProfAzione("default");
                    } else {
                        azione.setProfAzione(tmp);
                    }
                    long idAzione = rs.getLong("id");
                    azione.setId(idAzione);
                    accordoServizio.addAzione(azione);
                }
                rs.close();
                stm.close();
                this.readPortTypes(accordoServizio, con);
                this.readAccordoServizioComposto(accordoServizio, con);
                try {
                    List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                    for (i = 0; i < allegati.size(); ++i) {
                        accordoServizio.addAllegato(allegati.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound allegati) {
                    // empty catch block
                }
                try {
                    List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                    for (i = 0; i < specificheSemiformali.size(); ++i) {
                        accordoServizio.addSpecificaSemiformale(specificheSemiformali.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound specificheSemiformali) {
                    // empty catch block
                }
                if (accordoServizio.getServizioComposto() != null) {
                    try {
                        List<Documento> specificheCoordinamento = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaCoordinamento.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.tipoDB);
                        for (i = 0; i < specificheCoordinamento.size(); ++i) {
                            accordoServizio.getServizioComposto().addSpecificaCoordinamento(specificheCoordinamento.get(i));
                        }
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {}
                }
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            AccordoServizioParteComune accordoServizioParteComune = accordoServizio;
            return accordoServizioParteComune;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComune] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readPortTypes(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("readPortTypes") : this.globalConnection);
            if (as.getId() == null || as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortType pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(as.getId());
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                as.addPortType(pt);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readAzioniPortTypes(PortType pt, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("readAzioniPortTypes") : this.globalConnection);
            if (pt.getId() == null || pt.getId() <= 0L) {
                throw new Exception("Port Type id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, pt.getId());
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, pt.getId()));
            rs = stm.executeQuery();
            Operation azionePT = null;
            while (rs.next()) {
                azionePT = new Operation();
                String tmp = rs.getString("conferma_ricezione");
                azionePT.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                azionePT.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                azionePT.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                azionePT.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("nome");
                azionePT.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azionePT.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azionePT.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("correlata_servizio");
                azionePT.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata");
                azionePT.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    azionePT.setProfAzione("default");
                } else {
                    azionePT.setProfAzione(tmp);
                }
                tmp = rs.getString("soap_style");
                azionePT.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("soap_action");
                azionePT.setSoapAction(tmp == null || tmp.equals("") ? null : tmp);
                azionePT.setIdPortType(pt.getId());
                long idAzionePortType = rs.getLong("id");
                azionePT.setId(idAzionePortType);
                this.readMessagesAzioniPortTypes(azionePT, con);
                String msgInput = rs.getString("soap_use_msg_input");
                if (azionePT.getMessageInput() != null || msgInput != null) {
                    if (azionePT.getMessageInput() == null) {
                        azionePT.setMessageInput(new Message());
                    }
                    azionePT.getMessageInput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgInput == null || msgInput.equals("") ? null : msgInput));
                    tmp = rs.getString("soap_namespace_msg_input");
                    azionePT.getMessageInput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                String msgOutput = rs.getString("soap_use_msg_output");
                if (azionePT.getMessageOutput() != null || msgOutput != null) {
                    if (azionePT.getMessageOutput() == null) {
                        azionePT.setMessageOutput(new Message());
                    }
                    azionePT.getMessageOutput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgOutput == null || msgOutput.equals("") ? null : msgOutput));
                    tmp = rs.getString("soap_namespace_msg_output");
                    azionePT.getMessageOutput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                pt.addAzione(azionePT);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readAzioniPortTypes] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readMessagesAzioniPortTypes(Operation azionePT, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("readMessagesAzioniPortTypes") : this.globalConnection);
            if (azionePT.getId() == null || azionePT.getId() <= 0L) {
                throw new Exception("Port Type azione id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("operation_messages");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, azionePT.getId());
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, azionePT.getId()));
            rs = stm.executeQuery();
            Message messageInputPart = null;
            Message messageOutputPart = null;
            while (rs.next()) {
                boolean isInputMessage = false;
                if (rs.getInt("input_message") == 1) {
                    isInputMessage = true;
                }
                MessagePart part = new MessagePart();
                String name = rs.getString("name");
                name = name == null || name.equals("") ? null : name;
                part.setName(name);
                String elementName = rs.getString("element_name");
                elementName = elementName == null || elementName.equals("") ? null : elementName;
                part.setElementName(elementName);
                String elementNamespace = rs.getString("element_namespace");
                elementNamespace = elementNamespace == null || elementNamespace.equals("") ? null : elementNamespace;
                part.setElementNamespace(elementNamespace);
                String typeName = rs.getString("type_name");
                typeName = typeName == null || typeName.equals("") ? null : typeName;
                part.setTypeName(typeName);
                String typeNamespace = rs.getString("type_namespace");
                typeNamespace = typeNamespace == null || typeNamespace.equals("") ? null : typeNamespace;
                part.setTypeNamespace(typeNamespace);
                long idMessage = rs.getLong("id");
                part.setId(idMessage);
                if (isInputMessage) {
                    if (messageInputPart == null) {
                        messageInputPart = new Message();
                    }
                    messageInputPart.addPart(part);
                    continue;
                }
                if (messageOutputPart == null) {
                    messageOutputPart = new Message();
                }
                messageOutputPart.addPart(part);
            }
            if (messageInputPart != null) {
                azionePT.setMessageInput(messageInputPart);
            }
            if (messageOutputPart != null) {
                azionePT.setMessageOutput(messageOutputPart);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readMessagesAzioniPortTypes] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void readAccordoServizioComposto(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm2 = null;
        ResultSet rs2 = null;
        String sqlQuery = null;
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("readAccordoServizioComposto") : this.globalConnection);
            if (as.getId() == null || as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            AccordoServizioParteComuneServizioComposto asComposto = null;
            if (rs.next()) {
                asComposto = new AccordoServizioParteComuneServizioComposto();
                asComposto.setId(rs.getLong("id"));
                asComposto.setIdAccordoCooperazione(rs.getLong("id_accordo_cooperazione"));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("versione");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm2 = con.prepareStatement(sqlQuery);
                stm2.setLong(1, rs.getLong("id_accordo_cooperazione"));
                rs2 = stm2.executeQuery();
                if (!rs2.next()) {
                    throw new DriverRegistroServiziException("IDAccordoCooperazione con id [" + rs.getLong("id_accordo_cooperazione") + "] non presente");
                }
                String uriAccordo = this.idAccordoCooperazioneFactory.getUriFromValues(rs2.getString("nome"), rs2.getString("versione"));
                asComposto.setAccordoCooperazione(uriAccordo);
                rs2.close();
                stm2.close();
            }
            rs.close();
            stm.close();
            if (asComposto != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_servizio_composto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, asComposto.getId());
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, asComposto.getId()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                    asComponente.setIdServizioComponente(rs.getLong("id_servizio_componente"));
                    asComponente.setAzione(rs.getString("azione"));
                    AccordoServizioParteSpecifica aspsServizioComponente = this.getAccordoServizioParteSpecifica((long)asComponente.getIdServizioComponente(), con);
                    Servizio servizioComponente = aspsServizioComponente.getServizio();
                    asComponente.setTipo(servizioComponente.getTipo());
                    asComponente.setNome(servizioComponente.getNome());
                    asComponente.setTipoSoggetto(servizioComponente.getTipoSoggettoErogatore());
                    asComponente.setNomeSoggetto(servizioComponente.getNomeSoggettoErogatore());
                    asComposto.addServizioComponente(asComponente);
                }
                rs.close();
                stm.close();
                as.setServizioComposto(asComposto);
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs2 != null) {
                    rs2.close();
                }
                if (stm2 != null) {
                    stm2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdAccordiServizioParteComune...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdAccordiServizioParteComune") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null)) {
                sqlQueryObject.addFromTable(this.tabellaSoggetti);
            }
            sqlQueryObject.addSelectField("accordi", "nome");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("accordi", "id_referente");
            if (filtroRicerca != null) {
                ISQLQueryObject sqlQueryObjectASComposti;
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("accordi.ora_registrazione < ?");
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    sqlQueryObject.addWhereCondition("accordi.nome = ?");
                }
                if (filtroRicerca.getVersione() != null) {
                    sqlQueryObject.addWhereCondition("accordi.versione = ?");
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    sqlQueryObject.addWhereCondition("accordi.id_referente=" + this.tabellaSoggetti + ".id");
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".tipo_soggetto=?");
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition(this.tabellaSoggetti + ".nome_soggetto=?");
                    }
                }
                if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addFromTable("accordi_cooperazione");
                    sqlQueryObjectASComposti.addSelectField("acc_serv_composti.id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.id=acc_serv_composti.id_accordo_cooperazione");
                    if (filtroRicerca.getIdAccordoCooperazione().getNome() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.nome=?");
                    }
                    if (filtroRicerca.getIdAccordoCooperazione().getVersione() != null) {
                        sqlQueryObjectASComposti.addWhereCondition("accordi_cooperazione.versione=?");
                    }
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectASComposti);
                } else if (filtroRicerca.isServizioComposto() != null) {
                    sqlQueryObjectASComposti = sqlQueryObject.newSQLQueryObject();
                    sqlQueryObjectASComposti.addFromTable("acc_serv_composti");
                    sqlQueryObjectASComposti.addSelectField("id");
                    sqlQueryObjectASComposti.setANDLogicOperator(true);
                    sqlQueryObjectASComposti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
                    sqlQueryObject.addWhereExistsCondition(filtroRicerca.isServizioComposto() == false, sqlQueryObjectASComposti);
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeAccordo() != null) {
                    this.log.debug("nomeAccordo stmt.setString(" + filtroRicerca.getNomeAccordo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeAccordo());
                    ++indexStmt;
                }
                if (filtroRicerca.getVersione() != null) {
                    this.log.debug("versioneAccordo stmt.setString(" + filtroRicerca.getVersione() + ")");
                    stm.setString(indexStmt, filtroRicerca.getVersione());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) {
                    if (filtroRicerca.getTipoSoggettoReferente() != null) {
                        this.log.debug("tipoSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getTipoSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicerca.getTipoSoggettoReferente());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getNomeSoggettoReferente() != null) {
                        this.log.debug("nomeSoggettoReferenteAccordo stmt.setString(" + filtroRicerca.getNomeSoggettoReferente() + ")");
                        stm.setString(indexStmt, filtroRicerca.getNomeSoggettoReferente());
                        ++indexStmt;
                    }
                }
                if (filtroRicerca.getIdAccordoCooperazione() != null && (filtroRicerca.getIdAccordoCooperazione().getNome() != null || filtroRicerca.getIdAccordoCooperazione().getVersione() != null)) {
                    if (filtroRicerca.getIdAccordoCooperazione().getNome() != null) {
                        this.log.debug("nomeAccordoCooperazione stmt.setString(" + filtroRicerca.getIdAccordoCooperazione().getNome() + ")");
                        stm.setString(indexStmt, filtroRicerca.getIdAccordoCooperazione().getNome());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getIdAccordoCooperazione().getVersione() != null) {
                        this.log.debug("versioneAccordoCooperazione stmt.setString(" + filtroRicerca.getIdAccordoCooperazione().getVersione() + ")");
                        stm.setString(indexStmt, filtroRicerca.getIdAccordoCooperazione().getVersione());
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            while (rs.next()) {
                long idReferente = rs.getLong("id_referente");
                IDSoggetto idSoggettoReferente = null;
                if (idReferente > 0L) {
                    Soggetto soggettoReferente = this.getSoggetto(idReferente, con);
                    if (soggettoReferente == null) {
                        try {
                            throw new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("nome") + "] (versione [" + rs.getString("versione") + "]) non presente?");
                        }
                        catch (Throwable throwable) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (stm != null) {
                                    stm.close();
                                    stm = null;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    idSoggettoReferente = new IDSoggetto(soggettoReferente.getTipo(), soggettoReferente.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), idSoggettoReferente, rs.getString("versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordo> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiServizioParteComune error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replaceAll("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replaceAll("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replaceAll("\n", "")) ? conversazioneFruitore : null;
        String sqlQuery = "";
        Connection connection = null;
        Statement stm = null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("createAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            Documento doc;
            int i;
            IDAccordo idAccordoObject;
            long idAccordo;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addInsertTable("accordi");
            sqlQueryObject.addInsertField("conferma_ricezione", "?");
            sqlQueryObject.addInsertField("consegna_in_ordine", "?");
            sqlQueryObject.addInsertField("descrizione", "?");
            sqlQueryObject.addInsertField("filtro_duplicati", "?");
            sqlQueryObject.addInsertField("identificativo_collaborazione", "?");
            sqlQueryObject.addInsertField("nome", "?");
            sqlQueryObject.addInsertField("profilo_collaborazione", "?");
            sqlQueryObject.addInsertField("scadenza", "?");
            sqlQueryObject.addInsertField("wsdl_concettuale", "?");
            sqlQueryObject.addInsertField("wsdl_definitorio", "?");
            sqlQueryObject.addInsertField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addInsertField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addInsertField("spec_conv_concettuale", "?");
            sqlQueryObject.addInsertField("spec_conv_erogatore", "?");
            sqlQueryObject.addInsertField("spec_conv_fruitore", "?");
            sqlQueryObject.addInsertField("superuser", "?");
            sqlQueryObject.addInsertField("utilizzo_senza_azione", "?");
            sqlQueryObject.addInsertField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addInsertField("stato", "?");
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                sqlQueryObject.addInsertField("id_referente", "?");
            }
            sqlQueryObject.addInsertField("versione", "?");
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addInsertField("ora_registrazione", "?");
            }
            sqlQuery = sqlQueryObject.createSQLInsert();
            stm = connection.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, wsdlConcettuale != null && !wsdlConcettuale.trim().equals("") ? wsdlConcettuale : null);
            stm.setString(index++, wsdlDefinitorio != null && !wsdlDefinitorio.trim().equals("") ? wsdlDefinitorio : null);
            stm.setString(index++, wsdlLogicoErogatore != null && !wsdlLogicoErogatore.trim().equals("") ? wsdlLogicoErogatore : null);
            stm.setString(index++, wsdlLogicoFruitore != null && !wsdlLogicoFruitore.trim().equals("") ? wsdlLogicoFruitore : null);
            stm.setString(index++, conversazioneConcettuale != null && !conversazioneConcettuale.trim().equals("") ? conversazioneConcettuale : null);
            stm.setString(index++, conversazioneErogatore != null && !conversazioneErogatore.trim().equals("") ? conversazioneErogatore : null);
            stm.setString(index++, conversazioneFruitore != null && !conversazioneFruitore.trim().equals("") ? conversazioneFruitore : null);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index, accordoServizio.getStatoPackage());
                ++index;
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idReferente = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                if (idReferente <= 0L) {
                    throw new DriverRegistroServiziException("Soggetto Referente [" + accordoServizio.getSoggettoReferente().getTipo() + "/" + accordoServizio.getSoggettoReferente().getNome() + "] non trovato");
                }
                stm.setLong(index, idReferente);
                ++index;
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(index, accordoServizio.getVersione());
            } else {
                stm.setString(index, "");
            }
            ++index;
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
                ++index;
            }
            this.log.debug("inserisco accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, accordoServizio.getUtilizzoSenzaAzione(), accordoServizio.getPrivato() != null && accordoServizio.getPrivato() != false));
            stm.executeUpdate();
            stm.close();
            IDSoggetto soggettoReferente = null;
            if (accordoServizio.getSoggettoReferente() != null) {
                soggettoReferente = new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome());
            }
            if ((idAccordo = DBUtils.getIdAccordoServizioParteComune(idAccordoObject = this.idAccordoFactory.getIDAccordoFromValues(accordoServizio.getNome(), soggettoReferente, accordoServizio.getVersione()), connection, this.tipoDB)) <= 0L) {
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizio] non riesco a trovare l'id del'Accordo inserito");
            }
            accordoServizio.setId(idAccordo);
            Azione azione = null;
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                azione = accordoServizio.getAzione(i2);
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordo);
            }
            this.log.debug("inserite " + accordoServizio.sizeAzioneList() + " azioni relative all'accordo :" + nome + " id :" + idAccordo);
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordo);
            }
            this.log.debug("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordo);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordo);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(1, documenti, idAccordo, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
        }
        catch (SQLException se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] SQLException [" + se.getMessage() + "].", se);
        }
        catch (DriverRegistroServiziException e) {
            error = true;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        catch (Exception e) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] Exception [" + e.getMessage() + "].", e);
        }
        finally {
            try {
                stm.close();
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComune(idAccordo)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            if (idAccordo.getSoggettoReferente() != null && !this.existsSoggetto(idAccordo.getSoggettoReferente())) {
                boolean e = false;
                return e;
            }
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComune(long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComune(longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            rs = stm.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneAzione(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(nome,idAccordo)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComuneAzione(nome, DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneAzione(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(nome,longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComuneAzione(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComuneAzione(longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneAzione] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttype(String nome, IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComunePorttype(nome,idAccordo)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            boolean e = this.existsAccordoServizioParteComunePorttype(nome, DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB));
            return e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComuneOperation(long idAzione) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComuneOperation(longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComuneOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAzione);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttype(String nome, long idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComunePorttype(nome,longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttype] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordo);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    public boolean existsAccordoServizioParteComunePorttypeOperation(String nome, IDPortType idPortType) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComunePorttypeOperation(nome,idPortType)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        try {
            long idAccordo = DBUtils.getIdAccordoServizioParteComune(idPortType.getIdAccordo(), connection, this.tipoDB);
            boolean bl = this.existsAccordoServizioParteComunePorttypeOperation(nome, DBUtils.getIdPortType(idAccordo, idPortType.getNome(), connection));
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean existsAccordoServizioParteComunePorttypeOperation(String nome, long idPortType) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteComunePorttypeOperation(nome,longId)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteComunePorttypeOperation] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idPortType);
            stm.setString(2, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    @Override
    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        StatoFunzionalita confermaRicezione = accordoServizio.getConfermaRicezione();
        StatoFunzionalita conegnaInOrdine = accordoServizio.getConsegnaInOrdine();
        String descrizione = accordoServizio.getDescrizione();
        StatoFunzionalita filtroDuplicati = accordoServizio.getFiltroDuplicati();
        StatoFunzionalita identificativoCollaborazione = accordoServizio.getIdCollaborazione();
        ProfiloCollaborazione profiloCollaborazione = accordoServizio.getProfiloCollaborazione();
        String scadenza = accordoServizio.getScadenza();
        boolean utilizzioSenzaAzione = accordoServizio.getUtilizzoSenzaAzione();
        String wsdlConcettuale = accordoServizio.getByteWsdlConcettuale() != null ? new String(accordoServizio.getByteWsdlConcettuale()) : null;
        String wsdlDefinitorio = accordoServizio.getByteWsdlDefinitorio() != null ? new String(accordoServizio.getByteWsdlDefinitorio()) : null;
        String wsdlLogicoErogatore = accordoServizio.getByteWsdlLogicoErogatore() != null ? new String(accordoServizio.getByteWsdlLogicoErogatore()) : null;
        String wsdlLogicoFruitore = accordoServizio.getByteWsdlLogicoFruitore() != null ? new String(accordoServizio.getByteWsdlLogicoFruitore()) : null;
        String conversazioneConcettuale = accordoServizio.getByteSpecificaConversazioneConcettuale() != null ? new String(accordoServizio.getByteSpecificaConversazioneConcettuale()) : null;
        String conversazioneErogatore = accordoServizio.getByteSpecificaConversazioneErogatore() != null ? new String(accordoServizio.getByteSpecificaConversazioneErogatore()) : null;
        String conversazioneFruitore = accordoServizio.getByteSpecificaConversazioneFruitore() != null ? new String(accordoServizio.getByteSpecificaConversazioneFruitore()) : null;
        String superUser = accordoServizio.getSuperUser();
        wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
        wsdlDefinitorio = wsdlDefinitorio != null && !"".equals(wsdlDefinitorio.trim().replaceAll("\n", "")) ? wsdlDefinitorio : null;
        wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
        wsdlLogicoFruitore = wsdlLogicoFruitore != null && !"".equals(wsdlLogicoFruitore.trim().replaceAll("\n", "")) ? wsdlLogicoFruitore : null;
        conversazioneConcettuale = conversazioneConcettuale != null && !"".equals(conversazioneConcettuale.trim().replaceAll("\n", "")) ? conversazioneConcettuale : null;
        conversazioneErogatore = conversazioneErogatore != null && !"".equals(conversazioneErogatore.trim().replaceAll("\n", "")) ? conversazioneErogatore : null;
        conversazioneFruitore = conversazioneFruitore != null && !"".equals(conversazioneFruitore.trim().replaceAll("\n", "")) ? conversazioneFruitore : null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("updateAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            Documento doc;
            int i;
            IDAccordo idAccordoAttualeInseritoDB = null;
            idAccordoAttualeInseritoDB = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : this.idAccordoFactory.getIDAccordoFromAccordo(accordoServizio);
            long idAccordoLong = -1L;
            try {
                idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, connection, this.tipoDB);
            }
            catch (Exception e) {
                if (accordoServizio.getOldIDAccordoForUpdate() != null) {
                    idAccordoAttualeInseritoDB = accordoServizio.getSoggettoReferente() != null ? this.idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), new IDSoggetto(accordoServizio.getSoggettoReferente().getTipo(), accordoServizio.getSoggettoReferente().getNome()), idAccordoAttualeInseritoDB.getVersione()) : this.idAccordoFactory.getIDAccordoFromValues(idAccordoAttualeInseritoDB.getNome(), null, idAccordoAttualeInseritoDB.getVersione());
                    idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordoAttualeInseritoDB, connection, this.tipoDB);
                }
                throw e;
            }
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("accordi");
            sqlQueryObject.addUpdateField("conferma_ricezione", "?");
            sqlQueryObject.addUpdateField("consegna_in_ordine", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addUpdateField("filtro_duplicati", "?");
            sqlQueryObject.addUpdateField("identificativo_collaborazione", "?");
            sqlQueryObject.addUpdateField("nome", "?");
            sqlQueryObject.addUpdateField("profilo_collaborazione", "?");
            sqlQueryObject.addUpdateField("scadenza", "?");
            sqlQueryObject.addUpdateField("wsdl_concettuale", "?");
            sqlQueryObject.addUpdateField("wsdl_definitorio", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_erogatore", "?");
            sqlQueryObject.addUpdateField("wsdl_logico_fruitore", "?");
            sqlQueryObject.addUpdateField("spec_conv_concettuale", "?");
            sqlQueryObject.addUpdateField("spec_conv_erogatore", "?");
            sqlQueryObject.addUpdateField("spec_conv_fruitore", "?");
            sqlQueryObject.addUpdateField("superuser", "?");
            sqlQueryObject.addUpdateField("utilizzo_senza_azione", "?");
            sqlQueryObject.addUpdateField("privato", "?");
            if (accordoServizio.getStatoPackage() != null) {
                sqlQueryObject.addUpdateField("stato", "?");
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                sqlQueryObject.addUpdateField("ora_registrazione", "?");
            }
            sqlQueryObject.addUpdateField("id_referente", "?");
            sqlQueryObject.addUpdateField("versione", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = connection.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(confermaRicezione));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(conegnaInOrdine));
            stm.setString(index++, descrizione);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(filtroDuplicati));
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(identificativoCollaborazione));
            stm.setString(index++, nome);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(profiloCollaborazione));
            stm.setString(index++, scadenza);
            stm.setString(index++, wsdlConcettuale);
            stm.setString(index++, wsdlDefinitorio);
            stm.setString(index++, wsdlLogicoErogatore);
            stm.setString(index++, wsdlLogicoFruitore);
            stm.setString(index++, conversazioneConcettuale);
            stm.setString(index++, conversazioneErogatore);
            stm.setString(index++, conversazioneFruitore);
            stm.setString(index++, superUser);
            stm.setInt(index++, utilizzioSenzaAzione ? 1 : 0);
            if (accordoServizio.getPrivato() != null && accordoServizio.getPrivato().booleanValue()) {
                stm.setInt(index++, 1);
            } else {
                stm.setInt(index++, 0);
            }
            if (accordoServizio.getStatoPackage() != null) {
                stm.setString(index++, accordoServizio.getStatoPackage());
            }
            if (accordoServizio.getOraRegistrazione() != null) {
                stm.setTimestamp(index++, new Timestamp(accordoServizio.getOraRegistrazione().getTime()));
            }
            if (accordoServizio.getSoggettoReferente() != null) {
                long idSRef = DBUtils.getIdSoggetto(accordoServizio.getSoggettoReferente().getNome(), accordoServizio.getSoggettoReferente().getTipo(), connection, this.tipoDB, this.tabellaSoggetti);
                stm.setLong(index++, idSRef);
            } else {
                stm.setLong(index++, 0L);
            }
            if (accordoServizio.getVersione() != null && !"".equals(accordoServizio.getVersione())) {
                stm.setString(index++, accordoServizio.getVersione());
            } else {
                stm.setString(index++, "");
            }
            stm.setLong(index++, idAccordoLong);
            this.log.debug("update accordoServizio : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, confermaRicezione, conegnaInOrdine, descrizione, filtroDuplicati, identificativoCollaborazione, nome, profiloCollaborazione, scadenza, wsdlConcettuale, wsdlDefinitorio, wsdlLogicoErogatore, wsdlLogicoFruitore, conversazioneConcettuale, conversazioneErogatore, conversazioneFruitore, superUser, utilizzioSenzaAzione, idAccordoLong));
            stm.executeUpdate();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug("Cancellate " + n + " azioni associate all'accordo " + idAccordoLong);
            for (int i2 = 0; i2 < accordoServizio.sizeAzioneList(); ++i2) {
                Azione azione = accordoServizio.getAzione(i2);
                String profiloAzione = azione.getProfAzione();
                if (profiloAzione != null && profiloAzione.equals("default")) {
                    azione.setProfiloCollaborazione(profiloCollaborazione);
                }
                DriverRegistroServiziDB_LIB.CRUDAzione(1, accordoServizio, azione, connection, idAccordoLong);
            }
            this.log.debug("Inserite " + accordoServizio.sizeAzioneList() + " azioni associate all'accordo " + idAccordoLong);
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            this.log.debug("Trovati " + idPT.size() + " port type...");
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                Vector<Long> idPTAzione = new Vector<Long>();
                while (rs.next()) {
                    idPTAzione.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                this.log.debug("Trovati " + idPTAzione.size() + " port type azioni...");
                while (idPTAzione.size() > 0) {
                    Long idPortTypeAzione = (Long)idPTAzione.remove(0);
                    this.log.debug("Eliminazione message con id[" + idPortTypeAzione + "]...");
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, idPortTypeAzione);
                    n = stm.executeUpdate();
                    stm.close();
                    this.log.debug("Cancellate " + n + " messages di un'azione con id[" + idPortTypeAzione + "] del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
                }
                this.log.debug("Elimino port type azione del port types [" + idPortType + "]...");
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug("Cancellate " + n + " port type associate all'accordo " + idAccordoLong);
            PortType pt = null;
            for (int i3 = 0; i3 < accordoServizio.sizePortTypeList(); ++i3) {
                pt = accordoServizio.getPortType(i3);
                DriverRegistroServiziDB_LIB.CRUDPortType(1, accordoServizio, pt, connection, idAccordoLong);
            }
            this.log.debug("inserite " + accordoServizio.sizePortTypeList() + " porttype relative all'accordo :" + nome + " id :" + idAccordoLong);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(1, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
            }
            ArrayList<Documento> documenti = new ArrayList<Documento>();
            for (i = 0; i < accordoServizio.sizeAllegatoList(); ++i) {
                doc = accordoServizio.getAllegato(i);
                doc.setRuolo(RuoliDocumento.allegato.toString());
                documenti.add(doc);
            }
            for (i = 0; i < accordoServizio.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizio.getSpecificaSemiformale(i);
                doc.setRuolo(RuoliDocumento.specificaSemiformale.toString());
                documenti.add(doc);
            }
            if (accordoServizio.getServizioComposto() != null) {
                for (i = 0; i < accordoServizio.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                    doc = accordoServizio.getServizioComposto().getSpecificaCoordinamento(i);
                    doc.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                    documenti.add(doc);
                }
            }
            DriverRegistroServiziDB_LIB.CRUDDocumento(2, documenti, idAccordoLong, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
        }
        catch (SQLException se) {
            this.log.error(se.getMessage(), (Throwable)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            this.log.error(se.getMessage(), (Throwable)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updatePortType(PortType portType) throws DriverRegistroServiziException {
        if (portType == null) {
            throw new DriverRegistroServiziException("Il port-type non puo' essere null.");
        }
        String nome = portType.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome del port-type non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        Statement updateStmt = null;
        ResultSet rs = null;
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("updatePortType");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::updatePortType] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            AccordoServizioParteComune as = this.getAccordoServizioParteComune((long)portType.getIdAccordo(), connection);
            if (portType.getId() == null || portType.getId() <= 0L) {
                for (PortType ptCheck : as.getPortTypeList()) {
                    if (!ptCheck.getNome().equals(portType.getNome())) continue;
                    portType.setId(ptCheck.getId());
                }
            }
            if (portType.getId() == null || portType.getId() <= 0L) {
                throw new Exception("Id PortType undefined");
            }
            ArrayList<Long> idsOperation = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addWhereCondition("id_port_type=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(queryString);
            stm.setLong(1, portType.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                idsOperation.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            if (idsOperation != null && idsOperation.size() > 0) {
                for (Long id : idsOperation) {
                    ISQLQueryObject sqlQueryObjectMessages = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObjectMessages.addDeleteTable("operation_messages");
                    sqlQueryObjectMessages.addWhereCondition("id_port_type_azione=?");
                    String updateString = sqlQueryObjectMessages.createSQLDelete();
                    stm = connection.prepareStatement(updateString);
                    stm.setLong(1, id);
                    int n = stm.executeUpdate();
                    stm.close();
                    this.log.debug("Cancellate " + n + " operation messages associate all'azione con id " + id + " del port type " + portType.getNome() + " dell'accordo: " + as.getNome());
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            sqlQueryObject.addWhereCondition("id_port_type=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, portType.getId());
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug("Cancellate " + n + " azioni associate al portType " + portType.getNome() + " dell'accordo: " + as.getNome());
            for (int i = 0; i < portType.sizeAzioneList(); ++i) {
                Operation azione = portType.getAzione(i);
                DriverRegistroServiziDB_LIB.CRUDAzionePortType(1, as, portType, azione, connection, portType.getId());
            }
            DriverRegistroServiziDB_LIB.log.debug("inserite " + portType.sizeAzioneList() + " azioni relative al port type[" + portType.getNome() + "] id-porttype[" + portType.getId() + "]");
        }
        catch (Exception se) {
            this.log.error(se.getMessage(), (Throwable)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortType] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                }
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("L'AccordoServizio non puo' essere null.");
        }
        String nome = accordoServizio.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome dell'AccordoServizio non e' valido.");
        }
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        boolean error = false;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("deleteAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::deleteAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(nome, BeanUtilities.getSoggettoReferenteID(accordoServizio.getSoggettoReferente()), accordoServizio.getVersione());
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziException("Impossibile recuperare l'id dell'Accordo di Servizio : " + nome);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug("delete azioni :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            int n = stm.executeUpdate();
            stm.close();
            this.log.debug("cancellate " + n + " azioni.");
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            rs = stm.executeQuery();
            Vector<Long> idPT = new Vector<Long>();
            while (rs.next()) {
                idPT.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            while (idPT.size() > 0) {
                Long idPortType = (Long)idPT.remove(0);
                Vector<Long> idPortTypeAzioni = new Vector<Long>();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idPortTypeAzioni.add(rs.getLong("id"));
                }
                rs.close();
                stm.close();
                while (idPortTypeAzioni.size() > 0) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addDeleteTable("operation_messages");
                    sqlQueryObject.addWhereCondition("id_port_type_azione=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLDelete();
                    stm = connection.prepareStatement(sqlQuery);
                    stm.setLong(1, (Long)idPortTypeAzioni.remove(0));
                    n = stm.executeUpdate();
                    stm.close();
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addDeleteTable("port_type_azioni");
                sqlQueryObject.addWhereCondition("id_port_type=?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLDelete();
                stm = connection.prepareStatement(sqlQuery);
                stm.setLong(1, idPortType);
                n = stm.executeUpdate();
                stm.close();
                this.log.debug("Cancellate " + n + " azioni del port type [" + idPortType + "] associate all'accordo " + idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            n = stm.executeUpdate();
            stm.close();
            this.log.debug("Cancellate " + n + " port type associate all'accordo " + idAccordoLong);
            DriverRegistroServiziDB_LIB.CRUDDocumento(3, null, idAccordoLong, ProprietariDocumento.accordoServizio, connection, this.tipoDB);
            if (accordoServizio.getServizioComposto() != null) {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, accordoServizio.getServizioComposto(), connection, idAccordoLong);
            } else {
                DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteComuneServizioComposto(3, null, connection, idAccordoLong);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            sqlQueryObject.addWhereCondition("id=?");
            updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, idAccordoLong);
            this.log.debug("delete accordoServizio :" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            stm.executeUpdate();
            stm.close();
        }
        catch (SQLException se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    connection.rollback();
                    connection.setAutoCommit(true);
                    connection.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    connection.commit();
                    connection.setAutoCommit(true);
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getPortaDominio: " + nomePdD);
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD is null");
        }
        if (nomePdD.trim().equals("")) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro nomePdD non e' definito");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortaDominio(nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getPortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, nomePdD);
            rs = stm.executeQuery();
            PortaDominio pdd = null;
            if (rs.next()) {
                pdd = new PortaDominio();
                pdd.setId(rs.getLong("id"));
                pdd.setNome(rs.getString("nome"));
                pdd.setDescrizione(rs.getString("descrizione"));
                pdd.setImplementazione(rs.getString("implementazione"));
                pdd.setSubject(rs.getString("subject"));
                pdd.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
                pdd.setSuperUser(rs.getString("superuser"));
                if (rs.getTimestamp("ora_registrazione") != null) {
                    pdd.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getPortaDominio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, nomePdD));
            }
            PortaDominio portaDominio = pdd;
            return portaDominio;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPortaDominio] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stm.close();
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdPorteDominio...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdPorteDominio") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome = ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug("tipoPdd stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<String> nomiPdd = new Vector<String>();
            while (rs.next()) {
                nomiPdd.add(rs.getString("nome"));
            }
            if (nomiPdd.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
            }
            Vector<String> vector = nomiPdd;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createPortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDominio type = 1");
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(1, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createPortaDominio] Errore durante la creazione della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (nome == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (nome.equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsPortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsPortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza porta di dominio :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    @Override
    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updatePortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDominio type = 2");
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(2, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateTipoPortaDominio(String nomePdd, String tipo) throws DriverRegistroServiziException {
        if (nomePdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro non valido.");
        }
        if (tipo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateTipoPortaDominio] Parametro.tipo non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateTipoPortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addUpdateTable("pdd");
            sqlQueryObject.addUpdateField("tipo", "?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLUpdate();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo);
            stm.setString(2, nomePdd);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipo, nomePdd));
            stm.executeUpdate();
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortaDominio] Errore durante l'aggiornamento della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getTipoPortaDominio(String nome) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (nome == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (nome.equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getTipoPortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getTipoPortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("tipo");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome);
            rs = stm.executeQuery();
            if (rs.next()) {
                String string = rs.getString("tipo");
                return string;
            }
            try {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("Porta di Dominio [" + nome + "] non esistente");
            }
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("Errore durante verifica esistenza porta di dominio :", (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deletePortaDominio");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDPortaDominio type = 3");
            DriverRegistroServiziDB_LIB.CRUDPortaDominio(3, pdd, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deletePortaDominio] Errore durante l'eliminazione della porta di dominio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getRuolo: " + idRuolo);
        if (idRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo is null");
        }
        if (idRuolo.getNome() == null || idRuolo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo.nome non e' definito");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getRuolo(nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(queryString);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            Ruolo ruolo = null;
            if (rs.next()) {
                ruolo = new Ruolo();
                ruolo.setId(rs.getLong("id"));
                ruolo.setNome(rs.getString("nome"));
                ruolo.setDescrizione(rs.getString("descrizione"));
                String tipologia = rs.getString("tipologia");
                if (tipologia != null) {
                    ruolo.setTipologia(RuoloTipologia.toEnumConstant(tipologia));
                }
                ruolo.setNomeEsterno(rs.getString("nome_esterno"));
                String contesto_utilizzo = rs.getString("contesto_utilizzo");
                if (contesto_utilizzo != null) {
                    ruolo.setContestoUtilizzo(RuoloContesto.toEnumConstant(contesto_utilizzo));
                }
                ruolo.setSuperUser(rs.getString("superuser"));
                if (rs.getTimestamp("ora_registrazione") != null) {
                    ruolo.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
            } else {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getRuolo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idRuolo.getNome()));
            }
            Ruolo ruolo2 = ruolo;
            return ruolo2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stm.close();
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Ruolo getRuolo(long idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDRuolo idRuoloObject;
        block26: {
            this.log.debug("richiesto getRuolo: " + idRuolo);
            if (idRuolo <= 0L) {
                throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo non valido");
            }
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (this.atomica) {
                try {
                    con = this.getConnectionFromDatasource("getRuolo(id)");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug("operazione atomica = " + this.atomica);
            idRuoloObject = null;
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id = ?");
                String queryString = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(queryString);
                stm.setLong(1, idRuolo);
                rs = stm.executeQuery();
                if (rs.next()) {
                    idRuoloObject = new IDRuolo(rs.getString("nome"));
                    break block26;
                }
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getRuolo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idRuolo));
            }
            catch (DriverRegistroServiziNotFound e) {
                throw e;
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] SqlException: " + se.getMessage(), se);
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
                try {
                    stm.close();
                }
                catch (Exception exception) {}
                try {
                    if (this.atomica) {
                        this.log.debug("rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return this.getRuolo(idRuoloObject);
    }

    @Override
    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        boolean filtroRicercaTipo = false;
        if (filtroRicerca != null) {
            filtroRicercaTipo = filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia());
        }
        ArrayList<String> listTipologia = null;
        if (filtroRicercaTipo) {
            listTipologia = new ArrayList<String>();
            listTipologia.add(RuoloTipologia.QUALSIASI.getValue());
            listTipologia.add(filtroRicerca.getTipologia().getValue());
        }
        boolean filtroRicercaContesto = false;
        if (filtroRicerca != null) {
            filtroRicercaContesto = filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto());
        }
        ArrayList<String> listContesto = null;
        if (filtroRicercaContesto) {
            listContesto = new ArrayList<String>();
            listContesto.add(RuoloContesto.QUALSIASI.getValue());
            listContesto.add(filtroRicerca.getContesto().getValue());
        }
        this.log.debug("getAllIdRuoli...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdRuoli") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("nome");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome = ?");
                }
                if (filtroRicercaTipo) {
                    sqlQueryObject.addWhereCondition(false, "tipologia = ?", "tipologia = ?");
                }
                if (filtroRicercaContesto) {
                    sqlQueryObject.addWhereCondition(false, "contesto_utilizzo = ?", "contesto_utilizzo = ?");
                }
                sqlQueryObject.addOrderBy("nome");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                int i;
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicercaTipo) {
                    for (i = 0; i < listTipologia.size(); ++i) {
                        this.log.debug("tipo stmt.setString(" + (String)listTipologia.get(i) + ")");
                        stm.setString(indexStmt, (String)listTipologia.get(i));
                        ++indexStmt;
                    }
                }
                if (filtroRicercaContesto) {
                    for (i = 0; i < listContesto.size(); ++i) {
                        this.log.debug("contesto stmt.setString(" + (String)listContesto.get(i) + ")");
                        stm.setString(indexStmt, (String)listContesto.get(i));
                        ++indexStmt;
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDRuolo> nomiRuoli = new Vector<IDRuolo>();
            while (rs.next()) {
                nomiRuoli.add(new IDRuolo(rs.getString("nome")));
            }
            if (nomiRuoli.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Ruoli non trovati");
            }
            Vector<IDRuolo> vector = nomiRuoli;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdRuoli error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRuolo type = 1");
            DriverRegistroServiziDB_LIB.CRUDRuolo(1, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Errore durante la creazione del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (idRuolo == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idRuolo.getNome() == null || idRuolo.getNome().equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza ruolo: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    @Override
    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRuolo type = 2");
            DriverRegistroServiziDB_LIB.CRUDRuolo(2, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Errore durante l'aggiornamento del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDRuolo type = 3");
            DriverRegistroServiziDB_LIB.CRUDRuolo(3, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Errore durante l'eliminazione del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Ruolo> ruoliList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "ruoliList";
        int idLista = 47;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Ruolo> lista = new ArrayList<Ruolo>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("ruoliList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<IDRuolo> listIdRuoli = null;
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("ruoli");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                sqlQueryObject2.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("ruoli");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<IDRuolo>();
            while (risultato.next()) {
                listIdRuoli.add(new IDRuolo(risultato.getString("nome")));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (listIdRuoli != null) {
            for (IDRuolo idRuolo : listIdRuoli) {
                try {
                    lista.add(this.getRuolo(idRuolo));
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new DriverRegistroServiziException(notFound.getMessage(), notFound);
                }
            }
        }
        return lista;
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro idSoggetto is null");
        }
        String nomeSogg = idSoggetto.getNome();
        String tipoSogg = idSoggetto.getTipo();
        if (nomeSogg == null || nomeSogg.trim().equals("") || tipoSogg == null || tipoSogg.trim().equals("")) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] : soggetto non specificato.");
        }
        Soggetto soggetto = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggetto(idSoggetto)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nomeSogg);
            stm.setString(2, tipoSogg);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
            rs = stm.executeQuery();
            if (rs.next()) {
                String tipoAuth;
                soggetto = new Soggetto();
                soggetto.setId(rs.getLong("id"));
                soggetto.setNome(nomeSogg);
                soggetto.setTipo(tipoSogg);
                String tmp = rs.getString("descrizione");
                soggetto.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("identificativo_porta");
                soggetto.setIdentificativoPorta(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("server");
                soggetto.setPortaDominio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("superuser");
                soggetto.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getInt("privato") == 1) {
                    soggetto.setPrivato(true);
                } else {
                    soggetto.setPrivato(false);
                }
                tmp = rs.getString("codice_ipa");
                soggetto.setCodiceIpa(tmp == null || tmp.equals("") ? null : tmp);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    soggetto.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                long idConnettore = rs.getLong("id_connettore");
                Connettore connettore = this.getConnettore(idConnettore, con);
                String profilo = rs.getString("profilo");
                if (profilo != null) {
                    profilo = profilo.trim();
                    soggetto.setVersioneProtocollo(profilo);
                }
                if ((tipoAuth = rs.getString("tipoauth")) != null && !tipoAuth.equals("")) {
                    CredenzialiSoggetto credenziali = new CredenzialiSoggetto();
                    credenziali.setTipo(DriverRegistroServiziDB_LIB.getEnumCredenzialeTipo(tipoAuth));
                    credenziali.setPassword(rs.getString("password"));
                    credenziali.setSubject(rs.getString("subject"));
                    credenziali.setUser(rs.getString("utente"));
                    soggetto.setCredenziali(credenziali);
                }
                soggetto.setConnettore(connettore);
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, soggetto.getId());
                this.log.debug("eseguo query ruoli: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, soggetto.getId()));
                rs = stm.executeQuery();
                while (rs.next()) {
                    if (soggetto.getRuoli() == null) {
                        soggetto.setRuoli(new RuoliSoggetto());
                    }
                    RuoloSoggetto ruolo = new RuoloSoggetto();
                    ruolo.setId(rs.getLong("id_ruolo"));
                    soggetto.getRuoli().addRuolo(ruolo);
                }
                rs.close();
                stm.close();
                if (soggetto.getRuoli() != null && soggetto.getRuoli().sizeRuoloList() > 0) {
                    for (int i = 0; i < soggetto.getRuoli().sizeRuoloList(); ++i) {
                        Ruolo ruolo = this.getRuolo(soggetto.getRuoli().getRuolo(i).getId());
                        soggetto.getRuoli().getRuolo(i).setNome(ruolo.getNome());
                    }
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun soggetto trovato eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSogg, tipoSogg));
            }
            Soggetto soggetto2 = soggetto;
            return soggetto2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stm.close();
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Soggetto getSoggettoAutenticatoBasic(String user, String password) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoSsl(String subject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, null);
    }

    @Override
    public Soggetto getSoggettoAutenticatoPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, principal);
    }

    private Soggetto _getSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String subject, String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (tipoCredenziale == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
        }
        switch (tipoCredenziale) {
            case BASIC: {
                if (user == null || "".equalsIgnoreCase(user)) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                }
                if (password != null && !"".equalsIgnoreCase(password)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
            }
            case SSL: {
                if (subject != null && !"".equalsIgnoreCase(subject)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject is null (required for ssl auth)");
            }
            case PRINCIPAL: {
                if (principal != null && !"".equalsIgnoreCase(principal)) break;
                throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
            }
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggettoAutenticato");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        IDSoggetto idSoggetto = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            switch (tipoCredenziale) {
                case BASIC: {
                    sqlQueryObject.addWhereCondition("utente = ?");
                    sqlQueryObject.addWhereCondition("password = ?");
                    break;
                }
                case SSL: {
                    Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
                    Enumeration<String> keys = hashSubject.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        String value = hashSubject.get(key);
                        sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, true, false);
                    }
                    break;
                }
                case PRINCIPAL: {
                    sqlQueryObject.addWhereCondition("utente = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setString(index++, tipoCredenziale.toString());
            switch (tipoCredenziale) {
                case BASIC: {
                    stm.setString(index++, user);
                    stm.setString(index++, password);
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), user, password));
                    break;
                }
                case SSL: {
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString()));
                    break;
                }
                case PRINCIPAL: {
                    stm.setString(index++, principal);
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), principal));
                }
            }
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(rs.getString("tipo_soggetto"));
                idSoggetto.setNome(rs.getString("nome_soggetto"));
            }
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettoAutenticato] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettoAutenticato] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception exception) {}
            try {
                stm.close();
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        if (idSoggetto != null) {
            return this.getSoggetto(idSoggetto);
        }
        throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdSoggettiRegistro...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdSoggetti") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getNomePdd() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.server = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("soggetti_ruoli.id_soggetto=soggetti.id");
                    sqlQueryObject.addWhereCondition("soggetti_ruoli.id_ruolo=ruoli.id");
                    sqlQueryObject.addWhereCondition("ruoli.nome = ?");
                }
                if (filtroRicerca.getCredenzialiSoggetto() != null) {
                    if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getUser() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.utente = ?");
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                        sqlQueryObject.addWhereCondition("soggetti.password = ?");
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                        Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(filtroRicerca.getCredenzialiSoggetto().getSubject());
                        Enumeration<String> keys = hashSubject.keys();
                        while (keys.hasMoreElements()) {
                            String key = keys.nextElement();
                            String value = hashSubject.get(key);
                            sqlQueryObject.addWhereLikeCondition("soggetti.subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, true, false);
                        }
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nomeSoggetto stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomePdd() != null) {
                    this.log.debug("nomePdD stmt.setString(" + filtroRicerca.getNomePdd() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomePdd());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.log.debug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getCredenzialiSoggetto() != null) {
                    if (filtroRicerca.getCredenzialiSoggetto().getTipo() != null) {
                        this.log.debug("credenziali.tipo stmt.setString(" + filtroRicerca.getCredenzialiSoggetto().getTipo().getValue() + ")");
                        stm.setString(indexStmt, filtroRicerca.getCredenzialiSoggetto().getTipo().getValue());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getUser() != null) {
                        this.log.debug("credenziali.user stmt.setString(" + filtroRicerca.getCredenzialiSoggetto().getUser() + ")");
                        stm.setString(indexStmt, filtroRicerca.getCredenzialiSoggetto().getUser());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getPassword() != null) {
                        this.log.debug("credenziali.password stmt.setString(" + filtroRicerca.getCredenzialiSoggetto().getPassword() + ")");
                        stm.setString(indexStmt, filtroRicerca.getCredenzialiSoggetto().getPassword());
                        ++indexStmt;
                    }
                    if (filtroRicerca.getCredenzialiSoggetto().getSubject() != null) {
                        // empty if block
                    }
                }
            }
            rs = stm.executeQuery();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            Vector<IDSoggetto> vector = idSoggetti;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDSoggetto type = 1");
            DriverRegistroServiziDB_LIB.CRUDSoggetto(1, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createSoggetto] Errore durante la creazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsSoggetto(idSoggetto)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, nome_soggetto);
            stm.setString(2, tipo_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSoggetto(long idSoggetto) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsSoggetto(longId)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsSoggetto(String codiceIPA) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsSoggetto(codiceIPA)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Soggetto getSoggetto(String codiceIPA) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        long idSoggetto = -1L;
        if (codiceIPA == null || codiceIPA.equals("")) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggetto(codiceIPA)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("codice_ipa = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, codiceIPA);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggetto = rs.getLong("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziNotFound("Soggetto con Codice IPA [" + codiceIPA + "] non trovato");
        }
        return this.getSoggetto(idSoggetto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodiceIPA(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String codiceIPA = null;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        String nome_soggetto = idSoggetto.getNome();
        String tipo_soggetto = idSoggetto.getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getCodiceIPA(idSoggetto)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                codiceIPA = rs.getString("codice_ipa");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        if (codiceIPA == null) {
            throw new DriverRegistroServiziNotFound("Soggetto [" + tipo_soggetto + "/" + nome_soggetto + "] non trovato");
        }
        return codiceIPA;
    }

    @Override
    public void updateSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            String oldNomeSoggetto = soggetto.getOldNomeForUpdate();
            String oldTipoSoggetto = soggetto.getOldTipoForUpdate();
            String nomeSoggetto = soggetto.getNome();
            String tipoSoggetto = soggetto.getTipo();
            if (tipoSoggetto == null || tipoSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Tipo Soggetto non valido.");
            }
            if (nomeSoggetto == null || nomeSoggetto.equals("")) {
                throw new DriverRegistroServiziException("Parametro Nome Soggetto non valido.");
            }
            if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                oldNomeSoggetto = nomeSoggetto;
            }
            if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                oldTipoSoggetto = tipoSoggetto;
            }
            if (!tipoSoggetto.equals(oldTipoSoggetto) || !nomeSoggetto.equals(oldNomeSoggetto)) {
                String newNomeConnettore;
                String[] val;
                String oldNomeConnettore;
                Connettore connettore;
                long idConnettore;
                String regex = "CNT_SF_(.*)\\/(.*)_(.*)\\/(.*)_(.*)\\/(.*)";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]...");
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + val[2] + tipoSoggetto + "/" + nomeSoggetto + val[4];
                    this.log.debug("nuovo nome connettore [" + newNomeConnettore + "]");
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, oldTipoSoggetto);
                stm.setString(2, oldNomeSoggetto);
                rs = stm.executeQuery();
                while (rs.next()) {
                    idConnettore = rs.getLong("id_connettore");
                    connettore = this.getConnettore(idConnettore, con);
                    oldNomeConnettore = connettore.getNome();
                    if (!oldNomeConnettore.matches(regex)) continue;
                    this.log.debug("Tento aggiornamento connettore id: [" + idConnettore + "] oldNome: [" + oldNomeConnettore + "]...");
                    val = oldNomeConnettore.split("_");
                    newNomeConnettore = "CNT_SF_" + tipoSoggetto + "/" + nomeSoggetto + val[3] + val[4];
                    this.log.debug("nuovo nome connettore [" + newNomeConnettore + "]");
                    connettore.setNome(newNomeConnettore);
                    DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
                }
                rs.close();
                stm.close();
            }
            DriverRegistroServiziDB_LIB.CRUDSoggetto(2, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateSoggetto] Errore durante l'aggiornamento del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteSoggetto(Soggetto soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteSoggetto");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDSoggetto type = 3");
            DriverRegistroServiziDB_LIB.CRUDSoggetto(3, soggetto, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteSoggetto] Errore durante l'eliminazione del soggetto : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDSoggetto[] getSoggettiWithSuperuser(String user) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto[] idSoggetti = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggettiWithSuperuser");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            Vector<IDSoggetto> idTrovati = new Vector<IDSoggetto>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("superuser = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, user);
            this.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, CostantiRegistroServizi.ABILITATO));
            rs = stm.executeQuery();
            while (rs.next()) {
                IDSoggetto id = new IDSoggetto();
                id.setTipo(rs.getString("tipo_soggetto"));
                id.setNome(rs.getString("nome_soggetto"));
                idTrovati.add(id);
            }
            if (idTrovati.size() > 0) {
                idSoggetti = new IDSoggetto[1];
                idSoggetti = idTrovati.toArray(idSoggetti);
            }
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] SqlException: " + se.getMessage(), se);
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::getSoggettiWithSuperuser] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idSoggetti;
    }

    public List<String> soggettiRuoliList(long idSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiRuoliList";
        int idLista = 3;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiRuoliList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.addWhereLikeCondition("ruoli.nome", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("ruoli.nome");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.addWhereLikeCondition("ruoli.nome", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("ruoli.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("soggetti_ruoli");
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("ruoli.nome");
                sqlQueryObject.addWhereCondition("soggetti.id=?");
                sqlQueryObject.addWhereCondition("soggetti.id=soggetti_ruoli.id_soggetto");
                sqlQueryObject.addWhereCondition("ruoli.id=soggetti_ruoli.id_ruolo");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("ruoli.nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return listIdRuoli;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(1, idServizio, null, null, null, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(2, null, idAccordoServizioParteSpecifica, null, null, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, false, con);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection con) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(3, null, null, idSoggetto, idAccordoServizioParteComune, readContenutoAllegati, con);
        return servizio;
    }

    @Override
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdServizi ...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdServizi") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            String aliasFruitore = "fruitore";
            String aliasErogatore = "erogatore";
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti", aliasErogatore);
            sqlQueryObject.addFromTable("accordi");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null)) {
                sqlQueryObject.addFromTable("soggetti", aliasFruitore);
                sqlQueryObject.addFromTable("servizi_fruitori");
            }
            String aliasTipoSoggettoErogatore = "tipo_soggetto_erogatore";
            String aliasNomeSoggettoErogatore = "nome_soggetto_erogatore";
            sqlQueryObject.addSelectAliasField(aliasErogatore, "tipo_soggetto", aliasTipoSoggettoErogatore);
            sqlQueryObject.addSelectAliasField(aliasErogatore, "nome_soggetto", aliasNomeSoggettoErogatore);
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = " + aliasErogatore + ".id");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null)) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = " + aliasFruitore + ".id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".nome_soggetto = ?");
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                    }
                    if (idAccordo.getVersione() != null) {
                        sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".nome_soggetto = ?");
                }
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    String value = filtroRicerca.getTipologiaServizio();
                    value = CostantiRegistroServizi.ABILITATO.toString().equalsIgnoreCase(value) || TipologiaServizio.CORRELATO.getValue().equalsIgnoreCase(value) ? CostantiRegistroServizi.ABILITATO.toString() : CostantiRegistroServizi.DISABILITATO.toString();
                    this.log.debug("tipologiaServizio stmt.setString(" + value + ") original:[" + filtroRicerca.getTipologiaServizio() + "]");
                    stm.setString(indexStmt, value);
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.log.debug("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.log.debug("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        this.log.debug("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")");
                        stm.setString(indexStmt, idAccordo.getNome());
                        ++indexStmt;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                        if (idSoggettoReferente <= 0L) {
                            throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                        }
                        this.log.debug("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")");
                        stm.setLong(indexStmt, idSoggettoReferente);
                        ++indexStmt;
                    }
                    if (idAccordo.getVersione() != null) {
                        this.log.debug("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")");
                        stm.setString(indexStmt, idAccordo.getVersione());
                        ++indexStmt;
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    this.log.debug("tipoSoggettoFruitore stmt.setString(" + filtroRicerca.getTipoSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoFruitore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    this.log.debug("nomeSoggettoFruitore stmt.setString(" + filtroRicerca.getNomeSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoFruitore());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            while (rs.next()) {
                IDServizio idServ = new IDServizio(rs.getString(aliasTipoSoggettoErogatore), rs.getString(aliasNomeSoggettoErogatore), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                IDSoggetto soggettoReferente = null;
                long idSoggettoReferente = rs.getLong("id_referente");
                if (idSoggettoReferente > 0L) {
                    Soggetto s = this.getSoggetto(idSoggettoReferente, con);
                    soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), soggettoReferente, rs.getString("versione"));
                idServ.setUriAccordo(this.idAccordoFactory.getUriFromIDAccordo(idAccordo));
                String servizioCorrelato = rs.getString("servizio_correlato");
                if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                    idServ.setTipologiaServizio(TipologiaServizio.CORRELATO.toString());
                } else {
                    idServ.setTipologiaServizio(TipologiaServizio.NORMALE.toString());
                }
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi non trovati");
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdServizi ...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdAccordiServizioParteSpecifica") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            String aliasFruitore = "fruitore";
            String aliasErogatore = "erogatore";
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti", aliasErogatore);
            sqlQueryObject.addFromTable("accordi");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null)) {
                sqlQueryObject.addFromTable("soggetti", aliasFruitore);
                sqlQueryObject.addFromTable("servizi_fruitori");
            }
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = " + aliasErogatore + ".id");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = accordi.id");
            if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoFruitore() != null || filtroRicerca.getNomeSoggettoFruitore() != null)) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = " + aliasFruitore + ".id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    sqlQueryObject.addWhereCondition("servizi.servizio_correlato = ?");
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    sqlQueryObject.addWhereCondition(aliasErogatore + ".nome_soggetto = ?");
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        sqlQueryObject.addWhereCondition("accordi.nome = ?");
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        sqlQueryObject.addWhereCondition("accordi.id_referente = ?");
                    }
                    if (idAccordo.getVersione() != null) {
                        sqlQueryObject.addWhereCondition("accordi.versione = ?");
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    sqlQueryObject.addWhereCondition(aliasFruitore + ".nome_soggetto = ?");
                }
            }
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.log.debug("minDate stmt.setTimestamp(" + filtroRicerca.getMinDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.log.debug("maxDate stmt.setTimestamp(" + filtroRicerca.getMaxDate() + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.log.debug("tipoServizio stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.log.debug("nomeServizio stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipologiaServizio() != null) {
                    String value = filtroRicerca.getTipologiaServizio();
                    value = CostantiRegistroServizi.ABILITATO.toString().equalsIgnoreCase(value) || TipologiaServizio.CORRELATO.getValue().equalsIgnoreCase(value) ? CostantiRegistroServizi.ABILITATO.toString() : CostantiRegistroServizi.DISABILITATO.toString();
                    this.log.debug("tipologiaServizio stmt.setString(" + value + ") original:[" + filtroRicerca.getTipologiaServizio() + "]");
                    stm.setString(indexStmt, value);
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggettoErogatore() != null) {
                    this.log.debug("tipoSoggettoErogatore stmt.setString(" + filtroRicerca.getTipoSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoErogatore() != null) {
                    this.log.debug("nomeSoggettoErogatore stmt.setString(" + filtroRicerca.getNomeSoggettoErogatore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoErogatore());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdAccordo() != null) {
                    IDAccordo idAccordo = filtroRicerca.getIdAccordo();
                    if (idAccordo.getNome() != null) {
                        this.log.debug("nomeAccordo stmt.setString(" + idAccordo.getNome() + ")");
                        stm.setString(indexStmt, idAccordo.getNome());
                        ++indexStmt;
                    }
                    if (idAccordo.getSoggettoReferente() != null) {
                        long idSoggettoReferente = DBUtils.getIdSoggetto(idAccordo.getSoggettoReferente().getNome(), idAccordo.getSoggettoReferente().getTipo(), con, this.tipoDB, this.tabellaSoggetti);
                        if (idSoggettoReferente <= 0L) {
                            throw new Exception("Soggetto referente [" + idAccordo.getSoggettoReferente().toString() + "] non trovato");
                        }
                        this.log.debug("idReferenteAccordi stmt.setLong(" + idSoggettoReferente + ")");
                        stm.setLong(indexStmt, idSoggettoReferente);
                        ++indexStmt;
                    }
                    if (idAccordo.getVersione() != null) {
                        this.log.debug("versioneAccordo stmt.setString(" + idAccordo.getVersione() + ")");
                        stm.setString(indexStmt, idAccordo.getVersione());
                        ++indexStmt;
                    }
                }
                if (filtroRicerca.getTipoSoggettoFruitore() != null) {
                    this.log.debug("tipoSoggettoFruitore stmt.setString(" + filtroRicerca.getTipoSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggettoFruitore());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggettoFruitore() != null) {
                    this.log.debug("nomeSoggettoFruitore stmt.setString(" + filtroRicerca.getNomeSoggettoFruitore() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggettoFruitore());
                    ++indexStmt;
                }
            }
            rs = stm.executeQuery();
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            while (rs.next()) {
                long idReferente = rs.getLong("id_soggetto");
                IDSoggetto idSoggettoReferente = null;
                if (idReferente > 0L) {
                    Soggetto soggettoReferente = this.getSoggetto(idReferente, con);
                    if (soggettoReferente == null) {
                        try {
                            throw new Exception("Soggetto referente [" + idReferente + "] presente nell'accordo [" + rs.getString("aps_nome") + "] (versione [" + rs.getString("aps_versione") + "]) non presente?");
                        }
                        catch (Throwable throwable) {
                            try {
                                if (rs != null) {
                                    rs.close();
                                    rs = null;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (stm != null) {
                                    stm.close();
                                    stm = null;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    idSoggettoReferente = new IDSoggetto(soggettoReferente.getTipo(), soggettoReferente.getNome());
                }
                IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), idSoggettoReferente, rs.getString("aps_versione"));
                idAccordi.add(idAccordo);
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            Vector<IDAccordo> vector = idAccordi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDServizio[] getAllIdServiziWithSoggettoErogatore(Long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = "getAllIdServiziWithSoggettoErogatore";
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug(operazione + "...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdServiziWithSoggettoErogatore") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            rs = stm.executeQuery();
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            while (rs.next()) {
                IDServizio idServ = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati per il soggetto con id: " + idSoggetto);
            }
            IDServizio[] res = new IDServizio[1];
            IDServizio[] iDServizioArray = idServizi.toArray(res);
            return iDServizioArray;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(operazione + " error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        if (accordoServizioParteSpecifica == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizio tupe=1");
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(1, accordoServizioParteSpecifica, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteSpecifica] Errore durante la creazione del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        if (idServizio == null) {
            throw new DriverRegistroServiziException("IDServizio non valido.");
        }
        IDSoggetto erogatore = idServizio.getSoggettoErogatore();
        if (erogatore == null) {
            throw new DriverRegistroServiziException("Soggetto Erogatore non valido.");
        }
        String nomeServizio = idServizio.getServizio();
        String tipoServizio = idServizio.getTipoServizio();
        String nomeProprietario = erogatore.getNome();
        String tipoProprietario = erogatore.getTipo();
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            long idS = DBUtils.getIdServizio(nomeServizio, tipoServizio, nomeProprietario, tipoProprietario, con, false, this.tipoDB);
            boolean bl = idS > 0L;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsAccordoServizioParteSpecifica : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsServizioWithTipoAndNome(String tipoServizio, String nomeServizio) throws DriverRegistroServiziException {
        if (tipoServizio == null) {
            throw new DriverRegistroServiziException("TipoServizio non valido.");
        }
        if (nomeServizio == null) {
            throw new DriverRegistroServiziException("NomeServizio non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsServizioWithTipoAndNome");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            int idServ = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            PreparedStatement stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            ResultSet rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            boolean bl = idServ > 0;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsServizioWithTipoAndNome : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsAccordoServizioParteSpecifica(longId)");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            this.log.error("Errore durante verifica esistenza servizio :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection connection;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsAccordoServizioParteSpecifica(idAccordo)");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            if (!this.existsSoggetto(idAccordo.getSoggettoReferente())) {
                boolean e = false;
                return e;
            }
            long idAccordoLong = DBUtils.getIdAccordoServizioParteSpecifica(idAccordo, connection, this.tipoDB);
            if (idAccordoLong <= 0L) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDAccordo getIDAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        if (idServizio == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("Parametro non valido (soggetto erogatore)");
        }
        String nome_soggetto = idServizio.getSoggettoErogatore().getNome();
        String tipo_soggetto = idServizio.getSoggettoErogatore().getTipo();
        if (nome_soggetto == null || nome_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome soggetto non valido");
        }
        if (tipo_soggetto == null || tipo_soggetto.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo soggetto non valido");
        }
        String nome_servizio = idServizio.getServizio();
        String tipo_servizio = idServizio.getTipoServizio();
        if (nome_servizio == null || nome_servizio.equals("")) {
            throw new DriverRegistroServiziException("Parametro Nome servizio non valido");
        }
        if (tipo_servizio == null || tipo_servizio.equals("")) {
            throw new DriverRegistroServiziException("Parametro Tipo servizio non valido");
        }
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIDAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, tipo_soggetto);
            stm.setString(2, nome_soggetto);
            stm.setString(3, tipo_servizio);
            stm.setString(4, nome_servizio);
            rs = stm.executeQuery();
            if (rs.next()) {
                idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), idServizio.getSoggettoErogatore(), rs.getString("aps_versione"));
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            this.log.error("Errore durante verifica esistenza soggetto :", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        if (idAccordo == null) {
            throw new DriverRegistroServiziNotFound("Servizio [" + idServizio.toString() + "] non trovato");
        }
        return idAccordo;
    }

    public int getServizioWithSoggettoAccordoServCorr(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, null);
    }

    private int _getServizioWithSoggettoAccordoServCorrPT(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        Connection connection;
        int idServ = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("_getServizioWithSoggettoAccordoServCorrPT");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.addWhereCondition(false, "nome_servizio != ?", "tipo_servizio != ?");
            if (portType != null) {
                sqlQueryObject.addWhereCondition("port_type = ?");
            } else {
                sqlQueryObject.addWhereCondition("port_type is null");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setLong(2, idAccordo);
            stm.setString(3, servizioCorrelato);
            stm.setString(4, idServizio.getServizio());
            stm.setString(5, idServizio.getTipoServizio());
            if (portType != null) {
                stm.setString(6, portType);
            }
            if ((rs = stm.executeQuery()).next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return idServ;
    }

    public int getServizioWithSoggettoAccordoServCorrPt(long idSoggetto, long idAccordo, IDServizio idServizio, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        return this._getServizioWithSoggettoAccordoServCorrPT(idSoggetto, idAccordo, idServizio, servizioCorrelato, portType);
    }

    public int getServizioFruitore(IDServizio idServizio, long idSogg) throws DriverRegistroServiziException {
        Connection connection;
        int idFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("getServizioFruitore");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            int idServ = 0;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, idServizio.getServizio());
            stm.setString(2, idServizio.getTipoServizio());
            stm.setString(3, idServizio.getSoggettoErogatore().getNome());
            stm.setString(4, idServizio.getSoggettoErogatore().getTipo());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServ);
            stm.setLong(2, idSogg);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return idFru;
    }

    public int getServizioFruitoreSoggettoFruitoreID(int idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        int idSoggFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("getServizioFruitoreSoggettoFruitoreID");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreSoggettoFruitoreID] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggFru = rs.getInt("id_soggetto");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return idSoggFru;
    }

    public int getServizioFruitoreServizioID(int idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        int idServ = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("getServizioFruitoreServizioID");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreServizioID] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getInt("id_servizio");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return idServ;
    }

    @Override
    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Statement stm = null;
        ResultSet rs = null;
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(2, servizio, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizioParteSpecifica] Errore durante l'update del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAccordoServizioParteSpecifica");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            this.log.debug("CRUDServizio type = 3");
            DriverRegistroServiziDB_LIB.CRUDAccordoServizioParteSpecifica(3, servizio, con, this.tipoDB);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizioParteSpecifica] Errore durante la delete del servizio : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsSoggettoServiziWithoutConnettore(long idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existsSoggettoServiziWithoutConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi.id_connettore = connettori.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            stm.setString(2, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            rs.close();
            stm.close();
            boolean bl = trovatoServ;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existsSoggettoServiziWithoutConnettore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existFruizioniServiziSoggettoWithoutConnettore(long idSoggetto, boolean escludiSoggettiEsterni) throws DriverRegistroServiziException {
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existFruizioniWithoutConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori", "cservizio");
            sqlQueryObject.addFromTable("connettori", "cfruizione");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizi.id_connettore = cservizio.id");
            sqlQueryObject.addWhereCondition("cservizio.endpointtype = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, "pdd.tipo = ?", "pdd.tipo = ?");
            }
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_connettore = cfruizione.id");
            sqlQueryObject.addWhereCondition("cfruizione.endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idSoggetto);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            if (escludiSoggettiEsterni) {
                stm.setString(index++, PddTipologia.OPERATIVO.toString());
                stm.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            rs.close();
            stm.close();
            boolean bl = trovatoServ;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existFruizioniWithoutConnettore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existFruizioniServizioWithoutConnettore(long idServizio, boolean escludiSoggettiEsterni) throws DriverRegistroServiziException {
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("idServizio non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("existFruizioniServizioWithoutConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori", "cfruizione");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, "pdd.tipo = ?", "pdd.tipo = ?");
            }
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_connettore = cfruizione.id");
            sqlQueryObject.addWhereCondition("cfruizione.endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idServizio);
            if (escludiSoggettiEsterni) {
                stm.setString(index++, PddTipologia.OPERATIVO.toString());
                stm.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            rs.close();
            stm.close();
            boolean bl = trovatoServ;
            return bl;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("Errore durante existFruizioniServizioWithoutConnettore: " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Connettore getConnettore(long idConnettore, Connection connection) throws DriverRegistroServiziException {
        Connettore connettore = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("connettori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            if (rs.next()) {
                String endpoint = rs.getString("endpointtype");
                if (endpoint == null || endpoint.equals("") || endpoint.equals(TipiConnettore.DISABILITATO.getNome())) {
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(TipiConnettore.DISABILITATO.getNome());
                    connettore.setId(idConnettore);
                } else {
                    String redirectMode;
                    String transferMode;
                    Property prop = null;
                    connettore = new Connettore();
                    connettore.setNome(rs.getString("nome_connettore"));
                    connettore.setTipo(endpoint);
                    connettore.setId(idConnettore);
                    if (rs.getInt("debug") == 1) {
                        prop = new Property();
                        prop.setNome("debug");
                        prop.setValore("true");
                        connettore.addProperty(prop);
                    }
                    if (rs.getInt("proxy") == 1) {
                        String tmp = rs.getString("proxy_type");
                        if (tmp != null && !"".equals(tmp)) {
                            prop = new Property();
                            prop.setNome("proxyType");
                            prop.setValore(tmp.trim());
                            connettore.addProperty(prop);
                        }
                        if ((tmp = rs.getString("proxy_hostname")) != null && !"".equals(tmp)) {
                            prop = new Property();
                            prop.setNome("proxyHostname");
                            prop.setValore(tmp.trim());
                            connettore.addProperty(prop);
                        }
                        if ((tmp = rs.getString("proxy_port")) != null && !"".equals(tmp)) {
                            prop = new Property();
                            prop.setNome("proxyPort");
                            prop.setValore(tmp.trim());
                            connettore.addProperty(prop);
                        }
                        if ((tmp = rs.getString("proxy_username")) != null && !"".equals(tmp)) {
                            prop = new Property();
                            prop.setNome("proxyUsername");
                            prop.setValore(tmp.trim());
                            connettore.addProperty(prop);
                        }
                        if ((tmp = rs.getString("proxy_password")) != null && !"".equals(tmp)) {
                            prop = new Property();
                            prop.setNome("proxyPassword");
                            prop.setValore(tmp.trim());
                            connettore.addProperty(prop);
                        }
                    }
                    if ((transferMode = rs.getString("transfer_mode")) != null && !"".equals(transferMode)) {
                        prop = new Property();
                        prop.setNome("dataTransferMode");
                        prop.setValore(transferMode.trim());
                        connettore.addProperty(prop);
                        transferMode = rs.getString("transfer_mode_chunk_size");
                        if (transferMode != null && !"".equals(transferMode)) {
                            prop = new Property();
                            prop.setNome("transferChunkSize");
                            prop.setValore(transferMode.trim());
                            connettore.addProperty(prop);
                        }
                    }
                    if ((redirectMode = rs.getString("redirect_mode")) != null && !"".equals(redirectMode)) {
                        prop = new Property();
                        prop.setNome("followRedirects");
                        prop.setValore(redirectMode.trim());
                        connettore.addProperty(prop);
                        redirectMode = rs.getString("redirect_max_hop");
                        if (redirectMode != null && !"".equals(redirectMode)) {
                            prop = new Property();
                            prop.setNome("maxHopRedirect");
                            prop.setValore(redirectMode.trim());
                            connettore.addProperty(prop);
                        }
                    }
                    if (endpoint.equals(CostantiDB.CONNETTORE_TIPO_HTTP)) {
                        String pwd;
                        String value = rs.getString("url");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo http possiede una url non definita");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        String usr = rs.getString("utente");
                        if (usr != null && !usr.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("user");
                            prop.setValore(usr);
                            connettore.addProperty(prop);
                        }
                        if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("password");
                            prop.setValore(pwd);
                            connettore.addProperty(prop);
                        }
                    } else if (endpoint.equals(TipiConnettore.JMS.getNome())) {
                        String provurl;
                        String urlpkg;
                        String initcont;
                        String pwd;
                        String value = rs.getString("nome");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il nome della coda/topic non definito");
                        }
                        prop = new Property();
                        prop.setNome("location");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("tipo");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo della coda non definito");
                        }
                        prop = new Property();
                        prop.setNome("tipo");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("connection_factory");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms non possiede la definizione di una Connection Factory");
                        }
                        prop = new Property();
                        prop.setNome("connection-factory");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        value = rs.getString("send_as");
                        if (value != null) {
                            value = value.trim();
                        }
                        if (value == null || "".equals(value) || " ".equals(value)) {
                            throw new DriverRegistroServiziException("Connettore di tipo jms possiede il tipo dell'oggetto JMS non definito");
                        }
                        prop = new Property();
                        prop.setNome("send-as");
                        prop.setValore(value);
                        connettore.addProperty(prop);
                        String usr = rs.getString("utente");
                        if (usr != null && !usr.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("user");
                            prop.setValore(usr);
                            connettore.addProperty(prop);
                        }
                        if ((pwd = rs.getString("password")) != null && !pwd.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("password");
                            prop.setValore(pwd);
                            connettore.addProperty(prop);
                        }
                        if ((initcont = rs.getString("initcont")) != null && !initcont.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.initial");
                            prop.setValore(initcont);
                            connettore.addProperty(prop);
                        }
                        if ((urlpkg = rs.getString("urlpkg")) != null && !urlpkg.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.factory.url.pkgs");
                            prop.setValore(urlpkg);
                            connettore.addProperty(prop);
                        }
                        if ((provurl = rs.getString("provurl")) != null && !provurl.trim().equals("")) {
                            prop = new Property();
                            prop.setNome("context-java.naming.provider.url");
                            prop.setValore(provurl);
                            connettore.addProperty(prop);
                        }
                    } else if (!(endpoint.equals(TipiConnettore.NULL.getNome()) || endpoint.equals(TipiConnettore.NULLECHO.getNome()) || endpoint.equals(TipiConnettore.DISABILITATO.getNome()))) {
                        if (rs.getLong("custom") == 1L) {
                            this.readPropertiesConnettoreCustom(idConnettore, connettore, connection);
                            connettore.setCustom(true);
                        } else {
                            Property[] ps = ConnettorePropertiesUtilities.getPropertiesConnettore(endpoint, connection, this.tipoDB);
                            ArrayList<Property> listCP = new ArrayList<Property>();
                            if (ps != null) {
                                for (int i = 0; i < ps.length; ++i) {
                                    listCP.add(ps[i]);
                                }
                            }
                            connettore.setPropertyList(listCP);
                        }
                    }
                }
            }
            this.readPropertiesConnettoreExtendedInfo(idConnettore, connettore, connection);
            Connettore connettore2 = connettore;
            return connettore2;
        }
        catch (SQLException sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] CoreException : " + e.getMessage(), e);
        }
        catch (Exception sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getConnettore] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                rs.close();
                stm.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void readPropertiesConnettoreCustom(long idConnettore, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverRegistroServiziDB_LIB.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("name");
                String valore = rs.getString("value");
                if ("debug".equals(nome)) {
                    boolean found = false;
                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                        if (!"debug".equals(connettore.getProperty(i).getNome())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Property prop = new Property();
                prop.setNome(nome);
                prop.setValore(valore);
                connettore.addProperty(prop);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (Exception sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreCustom] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void readPropertiesConnettoreExtendedInfo(long idConnettore, Connettore connettore, Connection connection) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("connettori_custom");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_connettore = ?");
            sqlQueryObject.addWhereLikeCondition("name", "-#ext#-%");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idConnettore);
            DriverRegistroServiziDB_LIB.log.debug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idConnettore));
            rs = stm.executeQuery();
            while (rs.next()) {
                String nome = rs.getString("name");
                String valore = rs.getString("value");
                boolean found = false;
                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                    if (!nome.equals(connettore.getProperty(i).getNome())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Property prop = new Property();
                prop.setNome(nome);
                prop.setValore(valore);
                connettore.addProperty(prop);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreExtendedInfo] SQLException : " + sqle.getMessage(), sqle);
        }
        catch (Exception sqle) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPropertiesConnettoreExtendedInfo] Exception : " + sqle.getMessage(), sqle);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Property[] getPropertiesConnettore(String nomeConnettore) throws DriverRegistroServiziException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPropertiesConnettore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        return this.getPropertiesConnettore(nomeConnettore, con);
    }

    public Property[] getPropertiesConnettore(String nomeConnettore, Connection connection) throws DriverRegistroServiziException {
        try {
            return ConnettorePropertiesUtilities.getPropertiesConnettore(nomeConnettore, connection, this.tipoDB);
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getPropertiesConnettore] CoreException : " + e.getMessage(), e);
        }
    }

    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(int type, IDServizio idServizio, IDAccordo idAccordoServizioParteSpecifica, IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        Statement stm1 = null;
        ResultSet rs1 = null;
        this.log.debug("chiamato getAccordoServizioParteSpecifica type = " + type);
        switch (type) {
            case 1: {
                if (idServizio != null && idServizio.getServizio() != null && !idServizio.getServizio().trim().equals("") && idServizio.getTipoServizio() != null && !idServizio.getTipoServizio().trim().equals("") && idServizio.getSoggettoErogatore() != null && idServizio.getSoggettoErogatore().getNome() != null && !idServizio.getSoggettoErogatore().getNome().trim().equals("") && idServizio.getSoggettoErogatore().getTipo() != null && !idServizio.getSoggettoErogatore().getTipo().trim().equals("")) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            case 2: {
                if (idAccordoServizioParteSpecifica != null && idAccordoServizioParteSpecifica.getNome() != null && idAccordoServizioParteSpecifica.getSoggettoReferente() != null && idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo() != null && idAccordoServizioParteSpecifica.getSoggettoReferente().getNome() != null) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            case 3: {
                if (idAccordoServizioParteComune != null && idAccordoServizioParteComune.getNome() != null && !idAccordoServizioParteComune.getNome().trim().equals("") && idSoggetto != null && idSoggetto.getNome() != null && !idSoggetto.getNome().trim().equals("") && idSoggetto.getTipo() != null && !idSoggetto.getTipo().trim().equals("")) break;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] : errore nei parametri d'ingresso, type :" + type);
            }
            default: {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] tipo operazione incorretto. parametro type passato: " + type);
            }
        }
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccordoServizioParteSpecifica");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nomeservizio = ?");
            sqlQueryObject.addWhereCondition("tiposervizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            accordoServizioParteSpecifica = new AccordoServizioParteSpecifica();
            Servizio servizio = new Servizio();
            accordoServizioParteSpecifica.setServizio(servizio);
            String nomeSoggEr = null;
            String tipoSoggEr = null;
            long longIdAccordoServizioParteComune = 0L;
            String nomeServizio = null;
            String tipoServizio = null;
            String superUser = null;
            long idSoggErogatore = 0L;
            long longIdAccordoServizioParteSpecifica = 0L;
            switch (type) {
                case 1: {
                    nomeServizio = idServizio.getServizio();
                    tipoServizio = idServizio.getTipoServizio();
                    nomeSoggEr = idServizio.getSoggettoErogatore().getNome();
                    tipoSoggEr = idServizio.getSoggettoErogatore().getTipo();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nomeSoggEr);
                    stm.setString(2, tipoSoggEr);
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        idSoggErogatore = rs.getLong("id");
                    }
                    rs.close();
                    stm.close();
                    break;
                }
                case 2: {
                    if (!this.existsSoggetto(idAccordoServizioParteSpecifica.getSoggettoReferente())) {
                        throw new DriverRegistroServiziNotFound("Soggetto erogatore [" + idAccordoServizioParteSpecifica.getSoggettoReferente() + "] non esistente");
                    }
                    Soggetto sogErogatore = this.getSoggetto(idAccordoServizioParteSpecifica.getSoggettoReferente());
                    nomeSoggEr = sogErogatore.getNome();
                    tipoSoggEr = sogErogatore.getTipo();
                    longIdAccordoServizioParteSpecifica = DBUtils.getIdAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, con, this.tipoDB);
                    if (longIdAccordoServizioParteSpecifica > 0L) break;
                    throw new DriverRegistroServiziNotFound("Accordo di Servizio Parte Specifica [" + idAccordoServizioParteSpecifica.toString() + "] non esistente");
                }
                case 3: {
                    nomeSoggEr = idSoggetto.getNome();
                    tipoSoggEr = idSoggetto.getTipo();
                    longIdAccordoServizioParteComune = DBUtils.getIdAccordoServizioParteComune(idAccordoServizioParteComune, con, this.tipoDB);
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nomeSoggEr);
                    stm.setString(2, tipoSoggEr);
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeSoggEr, tipoSoggEr));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        idSoggErogatore = rs.getLong("id");
                    }
                    rs.close();
                    stm.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("id_accordo = ?");
                    sqlQueryObject.addWhereCondition("servizio_correlato = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idSoggErogatore);
                    stm.setLong(2, longIdAccordoServizioParteComune);
                    stm.setString(3, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.ABILITATO));
                    this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggErogatore, longIdAccordoServizioParteComune, CostantiRegistroServizi.ABILITATO));
                    rs = stm.executeQuery();
                    if (rs.next()) {
                        nomeServizio = rs.getString("nome_servizio");
                        tipoServizio = rs.getString("tipo_servizio");
                        superUser = rs.getString("superuser");
                    }
                    rs.close();
                    stm.close();
                }
            }
            long idConnettore = 0L;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            switch (type) {
                case 1: {
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    break;
                }
                case 2: {
                    sqlQueryObject.addWhereCondition("id = ?");
                    break;
                }
                case 3: {
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            switch (type) {
                case 1: {
                    stm.setString(1, nomeServizio);
                    stm.setString(2, tipoServizio);
                    stm.setLong(3, idSoggErogatore);
                    break;
                }
                case 2: {
                    stm.setLong(1, longIdAccordoServizioParteSpecifica);
                    break;
                }
                case 3: {
                    stm.setString(1, nomeServizio);
                    stm.setString(2, tipoServizio);
                    stm.setLong(3, idSoggErogatore);
                }
            }
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, nomeServizio, tipoServizio, idSoggErogatore));
            rs = stm.executeQuery();
            if (rs.next()) {
                String profilo;
                String tmp;
                longIdAccordoServizioParteSpecifica = rs.getLong("id");
                idConnettore = rs.getLong("id_connettore");
                longIdAccordoServizioParteComune = rs.getLong("id_accordo");
                superUser = rs.getString("superuser");
                accordoServizioParteSpecifica.setId(longIdAccordoServizioParteSpecifica);
                servizio.setId(longIdAccordoServizioParteSpecifica);
                accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
                servizio.setNome(rs.getString("nome_servizio"));
                servizio.setTipo(rs.getString("tipo_servizio"));
                servizio.setConnettore(this.getConnettore(idConnettore, con));
                String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
                accordoServizioParteSpecifica.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.trim().getBytes() : null);
                String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
                accordoServizioParteSpecifica.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.trim().getBytes() : null);
                String servizioCorrelato = rs.getString("servizio_correlato");
                if (CostantiRegistroServizi.ABILITATO.toString().equals(servizioCorrelato) || TipologiaServizio.CORRELATO.toString().equals(servizioCorrelato)) {
                    servizio.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    servizio.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                servizio.setTipoSoggettoErogatore(tipoSoggEr);
                servizio.setNomeSoggettoErogatore(nomeSoggEr);
                accordoServizioParteSpecifica.setIdSoggetto(idSoggErogatore);
                if (rs.getInt("privato") == 1) {
                    accordoServizioParteSpecifica.setPrivato(true);
                } else {
                    accordoServizioParteSpecifica.setPrivato(false);
                }
                if (rs.getTimestamp("ora_registrazione") != null) {
                    accordoServizioParteSpecifica.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if ((tmp = rs.getString("port_type")) != null && !"".equals(tmp)) {
                    accordoServizioParteSpecifica.setPortType(tmp);
                }
                if ((profilo = rs.getString("profilo")) != null) {
                    profilo = profilo.trim();
                    accordoServizioParteSpecifica.setVersioneProtocollo(profilo);
                }
                accordoServizioParteSpecifica.setSuperUser(superUser);
                accordoServizioParteSpecifica.setDescrizione(rs.getString("descrizione"));
                accordoServizioParteSpecifica.setStatoPackage(rs.getString("stato"));
                accordoServizioParteSpecifica.setNome(rs.getString("aps_nome"));
                accordoServizioParteSpecifica.setVersione(rs.getString("aps_versione"));
            } else {
                switch (type) {
                    case 1: {
                        throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
                    }
                    case 2: {
                        throw new DriverRegistroServiziNotFound("Accordo di Servizio Parte Specifica [" + idAccordoServizioParteSpecifica.toString() + "] non esiste");
                    }
                    case 3: {
                        throw new DriverRegistroServiziNotFound("Servizio [" + tipoServizio + "/" + nomeServizio + "] erogato dal soggetto [" + tipoSoggEr + "/" + nomeSoggEr + "] non esiste");
                    }
                }
            }
            rs.close();
            stm.close();
            long idSoggFruitore = 0L;
            Fruitore fruitore = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteSpecifica);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica));
            rs = stm.executeQuery();
            while (rs.next()) {
                String profilo;
                fruitore = new Fruitore();
                idSoggFruitore = rs.getLong("id_soggetto");
                idConnettore = rs.getLong("id_connettore");
                fruitore.setConnettore(this.getConnettore(idConnettore, con));
                String wsdlimpler = rs.getString("wsdl_implementativo_erogatore");
                fruitore.setByteWsdlImplementativoErogatore(wsdlimpler != null && !wsdlimpler.trim().equals("") ? wsdlimpler.getBytes() : null);
                String wsdlimplfru = rs.getString("wsdl_implementativo_fruitore");
                fruitore.setByteWsdlImplementativoFruitore(wsdlimplfru != null && !wsdlimplfru.trim().equals("") ? wsdlimplfru.getBytes() : null);
                if (rs.getTimestamp("ora_registrazione") != null) {
                    fruitore.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
                }
                if ((profilo = rs.getString("profilo")) != null) {
                    profilo = profilo.trim();
                    fruitore.setVersioneProtocollo(profilo);
                }
                fruitore.setStatoPackage(rs.getString("stato"));
                fruitore.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm1 = con.prepareStatement(sqlQuery);
                stm1.setLong(1, idSoggFruitore);
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
                rs1 = stm1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Non ho trovato i dati del soggetto fruitore necessario eseguendo: \n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggFruitore));
                }
                fruitore.setNome(rs1.getString("nome_soggetto"));
                fruitore.setTipo(rs1.getString("tipo_soggetto"));
                rs1.close();
                stm1.close();
                fruitore.setId(rs.getLong("id"));
                accordoServizioParteSpecifica.addFruitore(fruitore);
            }
            rs.close();
            stm.close();
            ServizioAzione azione = null;
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteSpecifica);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteSpecifica));
            rs = stm.executeQuery();
            while (rs.next()) {
                azione = new ServizioAzione();
                azione.setNome(rs.getString("nome_azione"));
                idConnettore = rs.getLong("id_connettore");
                azione.setConnettore(this.getConnettore(idConnettore, con));
                azione.setId(rs.getLong("id"));
                servizio.addParametriAzione(azione);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, longIdAccordoServizioParteComune);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, longIdAccordoServizioParteComune));
            rs = stm.executeQuery();
            if (rs.next()) {
                accordoServizioParteSpecifica.setIdAccordo(longIdAccordoServizioParteComune);
                String tmp = rs.getString("nome");
                String tmpVersione = rs.getString("versione");
                long id_referente = rs.getLong("id_referente");
                IDSoggetto soggettoReferente = null;
                if (id_referente > 0L) {
                    Soggetto s = this.getSoggetto(id_referente, con);
                    if (s == null) {
                        throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                    }
                    soggettoReferente = new IDSoggetto(s.getTipo(), s.getNome());
                }
                accordoServizioParteSpecifica.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromValues(tmp, soggettoReferente, tmpVersione));
            }
            rs.close();
            stm.close();
            try {
                List<Documento> allegati = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.allegato.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < allegati.size(); ++i) {
                    accordoServizioParteSpecifica.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound allegati) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound specificheSemiformali) {
                // empty catch block
            }
            try {
                List<Documento> specificheLivelloServizio = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaLivelloServizio.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheLivelloServizio.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaLivelloServizio(specificheLivelloServizio.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound specificheLivelloServizio) {
                // empty catch block
            }
            try {
                List<Documento> specificheSicurezza = DriverRegistroServiziDB_LIB.getListaDocumenti(RuoliDocumento.specificaSicurezza.toString(), longIdAccordoServizioParteSpecifica, ProprietariDocumento.servizio, readContenutoAllegati, con, this.tipoDB);
                for (int i = 0; i < specificheSicurezza.size(); ++i) {
                    accordoServizioParteSpecifica.addSpecificaSicurezza(specificheSicurezza.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            AccordoServizioParteSpecifica accordoServizioParteSpecifica2 = accordoServizioParteSpecifica;
            return accordoServizioParteSpecifica2;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            this.log.debug("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception:" + se.getMessage(), (Throwable)se);
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteSpecifica] Exception:" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (stm != null) {
                    stm.close();
                }
                if (stm1 != null) {
                    stm1.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio le connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Azione> accordiAzioniList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAzioniList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiAzioniList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setId(risultato.getLong("idAzione"));
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                lista.add(az);
            }
            ArrayList<Azione> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Azione> accordiAzioniList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAzioniList";
        int idLista = 31;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiAzioniList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("accordi_azioni.id", "cont");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, "accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("accordi_azioni", "nome");
            sqlQueryObject.addSelectField("accordi_azioni", "conferma_ricezione");
            sqlQueryObject.addSelectField("accordi_azioni", "consegna_in_ordine");
            sqlQueryObject.addSelectField("accordi_azioni", "filtro_duplicati");
            sqlQueryObject.addSelectField("accordi_azioni", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "scadenza");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_azione");
            sqlQueryObject.addSelectField("accordi_azioni", "id_accordo");
            sqlQueryObject.addSelectField("accordi_azioni", "correlata");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, "accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.addOrderBy("accordi_azioni.nome");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                az.setCorrelata(risultato.getString("correlata"));
                lista.add(az);
            }
            ArrayList<Azione> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziList";
        int idLista = 42;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug("search : " + search);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.setANDLogicOperator(true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.setANDLogicOperator(true);
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug("query : " + queryString);
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                Servizio serv = new Servizio();
                asps.setServizio(serv);
                asps.setId(risultato.getLong("id"));
                serv.setNome(risultato.getString("nome_servizio"));
                serv.setTipo(risultato.getString("tipo_servizio"));
                asps.setIdSoggetto(risultato.getLong("id_soggetto"));
                asps.setIdAccordo(risultato.getLong("id_accordo"));
                String servizio_correlato = risultato.getString("servizio_correlato");
                if (servizio_correlato != null && (servizio_correlato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizio_correlato))) {
                    serv.setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                Soggetto sog = this.getSoggetto(asps.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                serv.setNomeSoggettoErogatore(nomeErogatore);
                serv.setTipoSoggettoErogatore(tipoErogatore);
                AccordoServizioParteComune as = this.getAccordoServizioParteComune((long)asps.getIdAccordo(), con);
                asps.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromAccordo(as));
                asps.setStatoPackage(risultato.getString("stato"));
                lista.add(asps);
            }
            this.log.debug("size lista :" + (lista == null ? null : Integer.valueOf(lista.size())));
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> servizioWithSoggettoFruitore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "servizioWithSoggettoFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> idServizi = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("servizioWithSoggettoFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("servizi_fruitori");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.setSelectDistinct(true);
            sqlQueryObjectSoggetti.addSelectAliasField("servizi", "id", "idServizio");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioLong = risultato.getLong("idServizio");
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(idServizioLong);
                Soggetto s = this.getSoggetto(serv.getIdSoggetto());
                serv.getServizio().setTipoSoggettoErogatore(s.getTipo());
                serv.getServizio().setNomeSoggettoErogatore(s.getNome());
                idServizi.add(serv);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idServizi;
    }

    public List<AccordoServizioParteComune> accordiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, false);
    }

    public List<AccordoServizioParteComune> accordiServizioParteComuneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, false, true);
    }

    public List<AccordoServizioParteComune> accordiServizioCompostiList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.accordiListEngine(superuser, ricerca, true, false);
    }

    private List<AccordoServizioParteComune> accordiListEngine(String superuser, ISearch ricerca, boolean excludeASParteComune, boolean excludeASComposti) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug("search : " + search);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> lista = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiListEngine");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (excludeASComposti && excludeASParteComune) {
                throw new Exception("Non e' possibile invocare il metodo accordiListEngine con entrambi i parametri excludeASParteComune,excludeASComposti impostati al valore true");
            }
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addWhereCondition("accordi.id_referente=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition(false, sqlQueryObjectSoggetti.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true));
            }
            ISQLQueryObject sqlQueryObjectExclude = null;
            if (excludeASComposti || excludeASParteComune) {
                sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("accordi", "id");
                sqlQueryObject.addSelectField("accordi", "nome");
                sqlQueryObject.addSelectField("accordi", "versione");
                sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("accordi", "id");
                sqlQueryObject.addSelectField("accordi", "nome");
                sqlQueryObject.addSelectField("accordi", "versione");
                sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("accordi.superuser = ?");
                }
                if (excludeASParteComune) {
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
                }
                if (excludeASComposti) {
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            AccordoServizioParteComune accordo = null;
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                accordo = this.getAccordoServizioParteComune((long)id, con);
                lista.add(accordo);
            }
            this.log.debug("size lista :" + (lista == null ? null : Integer.valueOf(lista.size())));
            ArrayList<AccordoServizioParteComune> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoCooperazione> accordiCooperazioneList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCooperazioneList";
        int idLista = 38;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug("search : " + search);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDAccordoCooperazione> idAccordi = new ArrayList<IDAccordoCooperazione>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiCooperazioneList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true));
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome", search, true, true), sqlQueryObject.getWhereLikeCondition("versione", search, true, true));
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.setANDLogicOperator(true);
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_cooperazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("versione");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.addOrderBy("versione");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String nomeAcc = risultato.getString("nome");
                String versioneAcc = risultato.getString("versione");
                IDAccordoCooperazione id = this.idAccordoCooperazioneFactory.getIDAccordoFromValues(nomeAcc, versioneAcc);
                idAccordi.add(id);
            }
            this.log.debug("size lista :" + (idAccordi == null ? null : Integer.valueOf(idAccordi.size())));
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        ArrayList<AccordoCooperazione> lista = new ArrayList<AccordoCooperazione>();
        for (int i = 0; i < idAccordi.size(); ++i) {
            try {
                lista.add(this.getAccordoCooperazione((IDAccordoCooperazione)idAccordi.get(i)));
                continue;
            }
            catch (DriverRegistroServiziNotFound dNot) {
                throw new DriverRegistroServiziException("Accordo non trovato con id?: " + dNot.getMessage(), dNot);
            }
        }
        return lista;
    }

    public List<IDSoggetto> accordiCoopPartecipantiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopPartecipantiList";
        int idLista = 39;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug("search : " + search);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDSoggetto> idSoggetti = new ArrayList<IDSoggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiCoopPartecipantiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectSoggetti;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectCountField("*", "cont");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("accordi_coop_partecipanti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), "accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            } else {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "id");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_soggetto");
                sqlQueryObjectSoggetti.addSelectField("accordi_coop_partecipanti", "id_accordo_cooperazione");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=?");
                sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addOrderBy("tipo_soggetto");
                sqlQueryObjectSoggetti.addOrderBy("nome_soggetto");
                sqlQueryObjectSoggetti.setSortType(true);
                sqlQueryObjectSoggetti.setLimit(limit);
                sqlQueryObjectSoggetti.setOffset(offset);
                queryString = sqlQueryObjectSoggetti.createSQLQuery();
            }
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("tipo_soggetto");
                String nome = risultato.getString("nome_soggetto");
                IDSoggetto idSogg = new IDSoggetto(tipo, nome);
                idSoggetti.add(idSogg);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idSoggetti;
    }

    public List<AccordoCooperazione> accordiCoopWithSoggettoPartecipante(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopWithSoggettoPartecipante";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoCooperazione> idAccordoCooperazione = new ArrayList<AccordoCooperazione>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiCoopWithSoggettoPartecipante");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi_coop_partecipanti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi_cooperazione", "id", "idAccordoCooperazione");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_coop_partecipanti.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoCooperazioneLong = risultato.getLong("idAccordoCooperazione");
                idAccordoCooperazione.add(this.getAccordoCooperazione(idAccordoCooperazioneLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordoCooperazione;
    }

    public List<AccordoServizioParteComune> accordiServizio_serviziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponentiConSoggettoErogatore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiServizio_serviziComponentiConSoggettoErogatore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordoServizio;
    }

    public List<AccordoServizioParteComune> accordiServizio_serviziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizio_serviziComponenti";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiServizio_serviziComponenti");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_componenti");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id=acc_serv_componenti.id_servizio_composto");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.tipo_servizio=?");
            sqlQueryObjectSoggetti.addWhereCondition("servizi.nome_servizio=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idServizio.getSoggettoErogatore().getTipo());
            stmt.setString(2, idServizio.getSoggettoErogatore().getNome());
            stmt.setString(3, idServizio.getTipoServizio());
            stmt.setString(4, idServizio.getServizio());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordoServizio;
    }

    public List<AccordoServizioParteComune> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiServizioWithAccordoCooperazione";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> idAccordoServizio = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiServizioWithAccordoCooperazione");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("accordi");
            sqlQueryObjectSoggetti.addFromTable("acc_serv_composti");
            sqlQueryObjectSoggetti.addFromTable("accordi_cooperazione");
            sqlQueryObjectSoggetti.addSelectAliasField("accordi", "id", "idAccordoServizio");
            sqlQueryObjectSoggetti.addWhereCondition("accordi.id=acc_serv_composti.id_accordo");
            sqlQueryObjectSoggetti.addWhereCondition("acc_serv_composti.id_accordo_cooperazione=accordi_cooperazione.id");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.nome=?");
            sqlQueryObjectSoggetti.addWhereCondition("accordi_cooperazione.versione=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idAccordoCooperazione.getNome());
            stmt.setString(2, idAccordoCooperazione.getVersione());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idAccordoServizioLong = risultato.getLong("idAccordoServizio");
                idAccordoServizio.add(this.getAccordoServizioParteComune(idAccordoServizioLong));
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordoServizio;
    }

    public List<Soggetto> accordiErogatoriList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiErogatoriList";
        int idLista = 32;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        Statement stmt2 = null;
        ResultSet risultato2 = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiErogatoriList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addSelectField("soggetti.descrizione");
                sqlQueryObject.addSelectField("soggetti.identificativo_porta");
                sqlQueryObject.addSelectField("soggetti.codice_ipa");
                sqlQueryObject.addSelectAliasField("servizi.id", "servid");
                sqlQueryObject.addSelectField("servizi.nome_servizio");
                sqlQueryObject.addSelectField("servizi.tipo_servizio");
                sqlQueryObject.addSelectField("servizi.servizio_correlato");
                sqlQueryObject.addSelectField("servizi.id_accordo");
                sqlQueryObject.addSelectField("servizi.id_soggetto");
                sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
                sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            Soggetto sog = null;
            String oldNome = "";
            String oldTipo = "";
            while (risultato.next()) {
                String newNome = risultato.getString("nome_soggetto");
                String newTipo = risultato.getString("tipo_soggetto");
                if (sog == null || !oldTipo.equals(newTipo) || !oldNome.equals(newNome)) {
                    oldTipo = newTipo;
                    oldNome = newNome;
                    if (sog != null) {
                        lista.add(sog);
                    }
                    sog = new Soggetto();
                    sog.setId(risultato.getLong("id"));
                    sog.setNome(risultato.getString("nome_soggetto"));
                    sog.setTipo(risultato.getString("tipo_soggetto"));
                    sog.setDescrizione(risultato.getString("descrizione"));
                    sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                    sog.setCodiceIpa(risultato.getString("codice_ipa"));
                }
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setId(risultato.getLong("servid"));
                serv.setServizio(new Servizio());
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                if (risultato.getString("servizio_correlato").equals(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(risultato.getString("servizio_correlato"))) {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                ISQLQueryObject sqlQueryObjectFruitori = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectFruitori.addFromTable("servizi");
                sqlQueryObjectFruitori.addFromTable("servizi_fruitori");
                sqlQueryObjectFruitori.addFromTable("soggetti");
                sqlQueryObjectFruitori.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectFruitori.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectFruitori.addWhereCondition("servizi.id = ?");
                sqlQueryObjectFruitori.addWhereCondition("servizi.id = servizi_fruitori.id_servizio");
                sqlQueryObjectFruitori.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
                sqlQueryObjectFruitori.setANDLogicOperator(true);
                sqlQueryObjectFruitori.setSelectDistinct(true);
                String queryStringFruitori = sqlQueryObjectFruitori.createSQLQuery();
                stmt2 = con.prepareStatement(queryStringFruitori);
                stmt2.setLong(1, serv.getId());
                risultato2 = stmt2.executeQuery();
                while (risultato2.next()) {
                    String nome = risultato2.getString("nome_soggetto");
                    String tipo = risultato2.getString("tipo_soggetto");
                    Fruitore fruitore = new Fruitore();
                    fruitore.setTipo(tipo);
                    fruitore.setNome(nome);
                    serv.addFruitore(fruitore);
                }
                risultato2.close();
                stmt2.close();
                sog.addAccordoServizioParteSpecifica(serv);
            }
            if (sog != null) {
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (risultato2 != null) {
                    risultato2.close();
                }
                if (stmt2 != null) {
                    stmt2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Fruitore getAccordoErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getAccordoErogatoreFruitore: " + id);
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAccordoErogatoreFruitore") : this.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore = new Fruitore();
            fruitore.setId(id);
            fruitore.setTipo(rs.getString("soggetti.tipo_soggetto"));
            fruitore.setNome(rs.getString("soggetti.nome_soggetto"));
            long idConnettore = rs.getLong("soggettiid_connettore");
            fruitore.setConnettore(this.getConnettore(idConnettore, con));
            Fruitore fruitore2 = fruitore;
            return fruitore2;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Fruitore getErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getErogatoreFruitore: " + id);
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
            sqlQueryObject.addSelectField("servizi_fruitori.profilo");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getErogatoreFruitore") : this.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore = new Fruitore();
            fruitore.setId(id);
            fruitore.setTipo(rs.getString("tipo_soggetto"));
            fruitore.setNome(rs.getString("nome_soggetto"));
            fruitore.setStatoPackage(rs.getString("stato"));
            fruitore.setVersioneProtocollo(rs.getString("profilo"));
            fruitore.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(rs.getString("client_auth")));
            long idConnettore = rs.getLong("id_connettore");
            fruitore.setConnettore(this.getConnettore(idConnettore, con));
            Fruitore fruitore2 = fruitore;
            return fruitore2;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public AccordoServizioParteComune[] getAllIdAccordiWithSoggettoReferente(IDSoggetto idsoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        this.log.debug("getAllIdAccordiWithSoggettoReferente...");
        try {
            this.log.debug("operazione atomica = " + this.atomica);
            con = this.atomica ? this.getConnectionFromDatasource("getAllIdAccordiWithSoggettoReferente") : this.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idsoggetto.getTipo());
            stm.setString(2, idsoggetto.getNome());
            rs = stm.executeQuery();
            Vector<AccordoServizioParteComune> accordi = new Vector<AccordoServizioParteComune>();
            while (rs.next()) {
                accordi.add(this.getAccordoServizioParteComune(rs.getLong("idAccordo")));
            }
            if (accordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati con soggetto referente [" + idsoggetto + "]");
            }
            AccordoServizioParteComune[] res = new AccordoServizioParteComune[1];
            AccordoServizioParteComune[] accordoServizioParteComuneArray = accordi.toArray(res);
            return accordoServizioParteComuneArray;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw de;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiWithSoggettoReferente error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Fruitore> serviziFruitoriList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 43;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziFruitoriList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_fruitori.id");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi_fruitori.id");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            while (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Fruitore getServizioFruitore(int idServFru) throws DriverRegistroServiziException {
        String nomeMetodo = "getServizioFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServizioFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_erogatore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_fruitore");
            sqlQueryObject.addSelectField("servizi_fruitori.profilo");
            sqlQueryObject.addSelectField("servizi_fruitori.client_auth");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServFru);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            if (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                long idConnettore = risultato.getLong("id_connettore");
                f.setConnettore(this.getConnettore(idConnettore, con));
                f.setByteWsdlImplementativoErogatore(risultato.getString("wsdl_implementativo_erogatore") != null && !risultato.getString("wsdl_implementativo_erogatore").trim().equals("") ? risultato.getString("wsdl_implementativo_erogatore").trim().getBytes() : null);
                f.setByteWsdlImplementativoFruitore(risultato.getString("wsdl_implementativo_fruitore") != null && !risultato.getString("wsdl_implementativo_fruitore").trim().equals("") ? risultato.getString("wsdl_implementativo_fruitore").trim().getBytes() : null);
                f.setVersioneProtocollo(risultato.getString("profilo"));
                f.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("client_auth")));
                f.setStatoPackage(risultato.getString("stato"));
            }
            Fruitore fruitore = f;
            return fruitore;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isAccordoInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isAccordoInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso(con, this.tipoDB, this.idAccordoFactory.getIDAccordoFromAccordo(as), whereIsInUso);
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isInUso(accordoParteComune)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean isInUso = false;
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            ArrayList<IDPortaDelegata> idPorteDelegate = new ArrayList<IDPortaDelegata>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, as.getId());
            risultato = stmt.executeQuery();
            String uri = this.idAccordoFactory.getUriFromAccordo(as);
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteSpecifica ss = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                IDServizio idSE = new IDServizio();
                idSE.setServizio(ss.getServizio().getNome());
                idSE.setTipoServizio(ss.getServizio().getTipo());
                idSE.setSoggettoErogatore(ss.getServizio().getTipoSoggettoErogatore(), ss.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(ss.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(uri);
                idServizi.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, as.getId());
            risultato = stmt.executeQuery();
            uri = this.idAccordoFactory.getUriFromAccordo(as);
            while (risultato.next()) {
                isInUso = true;
                IDPortaDelegata idPD = new IDPortaDelegata();
                idPD.setLocationPD(risultato.getString("nome_porta"));
                Soggetto fruitore = this.getSoggetto(risultato.getLong("id_soggetto"));
                IDSoggetto idSO = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                idPD.setSoggettoFruitore(idSO);
                idPorteDelegate.add(idPD);
            }
            risultato.close();
            stmt.close();
            if (idPorteDelegate.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, idPorteDelegate);
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isServizioInUso(AccordoServizioParteSpecifica ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isServizioInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isServizioInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean isInUso = false;
            Vector<String> nomiAccordi = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectField("acc_serv_composti", "id_accordo");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_componente = ?");
            sqlQueryObject.addWhereCondition("acc_serv_componenti.id_servizio_composto = acc_serv_composti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(risultato.getLong("id_accordo"), con);
                nomiAccordi.add(this.idAccordoFactory.getUriFromAccordo(as));
            }
            risultato.close();
            stmt.close();
            if (nomiAccordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_SERVIZIO_COMPONENTE_IN_ACCORDI, nomiAccordi.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isAccordoCooperazioneInUso(AccordoCooperazione ac, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "isAccordoCooperazioneInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isAccordoCooperazioneInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = DBOggettiInUsoUtils.isAccordoCooperazioneInUso(con, this.tipoDB, this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac), whereIsInUso);
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isSoggettoInUsoInPackageFinali(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, true, false);
    }

    public boolean isSoggettoInUsoInPackagePubblici(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, true);
    }

    public boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverRegistroServiziException {
        return this.isSoggettoInUso(ss, whereIsInUso, false, false);
    }

    private boolean isSoggettoInUso(Soggetto ss, Map<ErrorsHandlerCostant, String> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isSoggettoInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            BaseBean accordo;
            boolean isInUso = false;
            Vector<CallSite> nomiServizi = new Vector<CallSite>();
            Vector<CallSite> serviziFruitori = new Vector<CallSite>();
            Vector<String> accordi = new Vector<String>();
            Vector<String> accordi_cooperazione = new Vector<String>();
            Vector<String> partecipanti = new Vector<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            int index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                String nomeServizio = risultato.getString("tipo_servizio") + "/" + risultato.getString("nome_servizio");
                nomiServizi.add((CallSite)((Object)nomeServizio));
            }
            risultato.close();
            stmt.close();
            if (nomiServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, nomiServizi.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            if (checkOnlyStatiFinali) {
                stmt.setString(2, StatiAccordo.finale.toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                if (checkOnlyStatiPubblici) {
                    if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) continue;
                    serviziFruitori.add((CallSite)((Object)(servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome())));
                    continue;
                }
                serviziFruitori.add((CallSite)((Object)(servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome())));
            }
            risultato.close();
            stmt.close();
            if (serviziFruitori.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, serviziFruitori.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.getAccordoServizioParteComune(risultato.getLong("id"));
                accordi.add(this.idAccordoFactory.getUriFromAccordo((AccordoServizioParteComune)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, accordi.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_cooperazione");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                accordo = this.getAccordoCooperazione(risultato.getLong("id"));
                accordi_cooperazione.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (accordi_cooperazione.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE_COOPERAZIONE, accordi_cooperazione.toString());
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_coop_partecipanti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                accordo = this.getAccordoCooperazione(risultato.getLong("id_accordo_cooperazione"));
                if (checkOnlyStatiFinali) {
                    if (!StatiAccordo.finale.toString().equals(((AccordoCooperazione)accordo).getStatoPackage())) continue;
                    isInUso = true;
                    partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                if (checkOnlyStatiPubblici) {
                    if (((AccordoCooperazione)accordo).getPrivato() != null && ((AccordoCooperazione)accordo).getPrivato().booleanValue()) continue;
                    isInUso = true;
                    partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
                    continue;
                }
                isInUso = true;
                partecipanti.add(this.idAccordoCooperazioneFactory.getUriFromAccordo((AccordoCooperazione)accordo));
            }
            risultato.close();
            stmt.close();
            if (partecipanti.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_PARTECIPANTE_COOPERAZIONE, partecipanti.toString());
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isInUso(Soggetto ss, Map<ErrorsHandlerCostant, ArrayList<?>> whereIsInUso, boolean checkOnlyStatiFinali, boolean checkOnlyStatiPubblici) throws DriverRegistroServiziException {
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isInUso(soggetto)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            IDServizio idSE;
            AccordoServizioParteSpecifica servizio;
            boolean isInUso = false;
            ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
            ArrayList<IDServizio> idServiziFruitori = new ArrayList<IDServizio>();
            ArrayList<IDAccordo> idAccordi = new ArrayList<IDAccordo>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            int index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                idSE = new IDServizio();
                idSE.setServizio(servizio.getServizio().getNome());
                idSE.setTipoServizio(servizio.getServizio().getTipo());
                idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                idServizi.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServizi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, idServizi);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            if (checkOnlyStatiFinali) {
                stmt.setString(2, StatiAccordo.finale.toString());
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                if (checkOnlyStatiPubblici) {
                    if (servizio.getPrivato() != null && servizio.getPrivato().booleanValue()) continue;
                    idSE = new IDServizio();
                    idSE.setServizio(servizio.getServizio().getNome());
                    idSE.setTipoServizio(servizio.getServizio().getTipo());
                    idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                    idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                    idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                    idServiziFruitori.add(idSE);
                    continue;
                }
                idSE = new IDServizio();
                idSE.setServizio(servizio.getServizio().getNome());
                idSE.setTipoServizio(servizio.getServizio().getTipo());
                idSE.setSoggettoErogatore(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                idSE.setTipologiaServizio(servizio.getServizio().getTipologiaServizio().toString());
                idSE.setUriAccordo(servizio.getAccordoServizioParteComune());
                idServiziFruitori.add(idSE);
            }
            risultato.close();
            stmt.close();
            if (idServiziFruitori.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.POSSIEDE_FRUITORI, idServiziFruitori);
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_referente = ?");
            if (checkOnlyStatiFinali) {
                sqlQueryObject.addWhereCondition("stato = ?");
            }
            if (checkOnlyStatiPubblici) {
                sqlQueryObject.addWhereCondition("privato = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, ss.getId());
            index = 2;
            if (checkOnlyStatiFinali) {
                stmt.setString(index, StatiAccordo.finale.toString());
                ++index;
            }
            if (checkOnlyStatiPubblici) {
                stmt.setInt(index, 0);
                ++index;
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                AccordoServizioParteComune accordo = this.getAccordoServizioParteComune(risultato.getLong("id"));
                idAccordi.add(this.idAccordoFactory.getIDAccordoFromAccordo(accordo));
            }
            risultato.close();
            stmt.close();
            if (idAccordi.size() > 0) {
                whereIsInUso.put(ErrorsHandlerCostant.IS_REFERENTE, idAccordi);
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAzioneInUso(String nomeAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "isAzioneInUso";
        Connection con = null;
        Statement stmtPD = null;
        Statement stmtPA = null;
        ResultSet risultatoPD = null;
        ResultSet risultatoPA = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isAzioneInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("azione = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmtPA = con.prepareStatement(queryString);
            stmtPA.setString(1, nomeAzione);
            risultatoPA = stmtPA.executeQuery();
            if (risultatoPA.next()) {
                boolean bl = true;
                return bl;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome_azione = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmtPD = con.prepareStatement(queryString);
            stmtPD.setString(1, nomeAzione);
            risultatoPD = stmtPD.executeQuery();
            if (risultatoPD.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultatoPA != null) {
                    risultatoPA.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (risultatoPD != null) {
                    risultatoPD.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtPA != null) {
                    stmtPA.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmtPD != null) {
                    stmtPD.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteAzione(int idAccordo, String nomeAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "deleteAzione";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteAzione");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDAccordo getIdAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoServizioParteComune(id, null);
    }

    public IDAccordo getIdAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getIdAccordoServizioParteComune: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("getIdAccordoServizioParteComune(longId)") : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L && (referente = this.getIdSoggetto(idReferente, con)) == null) {
                    throw new Exception("Soggetto referente non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordo;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, null, false);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id, boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, null, readContenutiAllegati);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, conParam, false);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(long id, Connection conParam, boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getAccordoServizio: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto referente;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("getAccordoServizioParteComune(longId)") : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (rs.next()) {
                referente = null;
                long idReferente = rs.getLong("id_referente");
                if (idReferente > 0L) {
                    Soggetto s = this.getSoggetto(idReferente, con);
                    if (s == null) {
                        throw new Exception("Soggetto referente non presente?");
                    }
                    referente = new IDSoggetto(s.getTipo(), s.getNome());
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getString("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getAccordoServizioParteComune(idAccordo, readContenutiAllegati);
    }

    public List<Soggetto> soggettiRegistroListByTipo(String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList("", tipoSoggetto, ricerca);
    }

    public List<Soggetto> soggettiRegistroList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.soggettiRegistroList(superuser, null, ricerca);
    }

    private List<Soggetto> soggettiRegistroList(String superuser, String tipoSoggetto, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiRegistroList";
        int idLista = 2;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiRegistroList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject2.addWhereCondition(false, sqlQueryObject2.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject2.getWhereLikeCondition("nome_soggetto", search, true, true));
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("soggetti");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject.addWhereLikeCondition("nome_soggetto", search, true, true);
                } else {
                    sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id_connettore");
                sqlQueryObject.addSelectField("codice_ipa");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipoSoggetto != null) {
                    sqlQueryObject.addWhereCondition("tipo_soggetto=?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (!search.equals("")) {
                if (tipoSoggetto != null) {
                    stmt.setString(index++, tipoSoggetto);
                }
            } else if (tipoSoggetto != null) {
                stmt.setString(index++, tipoSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto sog = new Soggetto();
                sog.setId(risultato.getLong("id"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                sog.setPortaDominio(risultato.getString("server"));
                sog.setCodiceIpa(risultato.getString("codice_ipa"));
                long idConnettore = risultato.getLong("id_connettore");
                sog.setConnettore(this.getConnettore(idConnettore, con));
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public IDSoggetto getIdSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdSoggetto(idSoggetto, null);
    }

    public IDSoggetto getIdSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto <= 0L) {
            return null;
        }
        IDSoggetto idSoggettoObject = null;
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIdSoggetto(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("Nessun risultato trovat eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            idSoggettoObject = new IDSoggetto();
            idSoggettoObject.setNome(rs.getString("nome_soggetto"));
            idSoggettoObject.setTipo(rs.getString("tipo_soggetto"));
            IDSoggetto iDSoggetto = idSoggettoObject;
            return iDSoggetto;
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] SqlException: " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound se) {
            throw se;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdSoggetto] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Soggetto getSoggetto(long idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getSoggetto(idSoggetto, null);
    }

    public Soggetto getSoggetto(long idSoggetto, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto idSoggettoObject;
        block26: {
            if (idSoggetto <= 0L) {
                return null;
            }
            Connection con = null;
            Statement stm = null;
            ResultSet rs = null;
            if (conParam != null) {
                con = conParam;
            } else if (this.atomica) {
                try {
                    con = this.getConnectionFromDatasource("getSoggetto(longId)");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.globalConnection;
            }
            this.log.debug("operazione atomica = " + this.atomica);
            idSoggettoObject = null;
            try {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id = ?");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, idSoggetto);
                this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSoggettoObject = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                    break block26;
                }
                throw new DriverRegistroServiziNotFound("Nessun risultato trovat eseguendo: " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idSoggetto));
            }
            catch (SQLException se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] SqlException: " + se.getMessage(), se);
            }
            catch (DriverRegistroServiziNotFound se) {
                throw se;
            }
            catch (Exception se) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggetto] Exception: " + se.getMessage(), se);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stm != null) {
                        stm.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (conParam == null && this.atomica) {
                        this.log.debug("rilascio connessioni al db...");
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return this.getSoggetto(idSoggettoObject);
    }

    public IDAccordo getIdAccordoServizioParteSpecifica(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoServizioParteSpecifica(id, null);
    }

    public IDAccordo getIdAccordoServizioParteSpecifica(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.log.debug("richiesto getIdAccordoServizioParteSpecifica: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            IDSoggetto erogatore;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("aps_nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addSelectField("aps_versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.log.debug("operazione atomica = " + this.atomica);
            con = conParam != null ? conParam : (this.atomica ? this.getConnectionFromDatasource("getIdAccordoServizioParteSpecifica(longId)") : this.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (rs.next()) {
                erogatore = null;
                long idErogatore = rs.getLong("id_soggetto");
                if (idErogatore > 0L && (erogatore = this.getIdSoggetto(idErogatore, con)) == null) {
                    throw new Exception("Soggetto erogatore non presente?");
                }
            } else {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            idAccordo = this.idAccordoFactory.getIDAccordoFromValues(rs.getString("aps_nome"), erogatore, rs.getString("aps_versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] SQLException :" + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteSpecifica] Exception :" + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessione al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return idAccordo;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, null, readContenutoAllegati);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(idServizio, conParam, false);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, Connection conParam, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] L'id del servizio deve essere > 0.");
        }
        Connection con = null;
        Statement stm = null;
        ResultSet rs = null;
        if (conParam != null) {
            con = conParam;
        } else if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAccordoServizioParteSpecifica(longId)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        IDServizio idServizioObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("servizio_correlato");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idServizio));
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizioObject = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                if (CostantiRegistroServizi.ABILITATO.toString().equals(rs.getString("servizio_correlato")) || TipologiaServizio.CORRELATO.toString().equals(rs.getString("servizio_correlato"))) {
                    idServizioObject.setTipologiaServizio(TipologiaServizio.CORRELATO.toString());
                } else {
                    idServizioObject.setTipologiaServizio(TipologiaServizio.NORMALE.toString());
                }
            } else {
                throw new DriverRegistroServiziNotFound("Nessun Servizio trovato con id=" + idServizio);
            }
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] SqlException: " + se.getMessage(), se);
        }
        catch (DriverRegistroServiziNotFound nf) {
            throw nf;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getServizio] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conParam == null && this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return this.getAccordoServizioParteSpecifica(idServizioObject, readContenutoAllegati, conParam);
    }

    @Override
    public void reset() throws DriverRegistroServiziException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("reset");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_fruitori");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("operation_messages");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("port_type");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_coop_partecipanti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_componenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("acc_serv_composti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_cooperazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("soggetti_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("soggetti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori_custom");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("connettori");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("documenti");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pdd");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::reset] Errore durante il reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void resetCtrlstat() throws DriverRegistroServiziException {
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("resetCtrlstat");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("mapping_erogazione_pa");
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("mapping_fruizione_pd");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("sa_ruoli");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative_sa");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("servizi_applicativi");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_properties");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pa_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_applicative");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_request");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_ws_response");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("pd_correlazione_risposta");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addDeleteTable("porte_delegate");
            updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::resetCtrlstat] Errore durante la reset : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public long getIdServizioCorrelato(String nomeServizio, String tipoServizio, String nomeProprietario, String tipoProprietario, Connection con) throws DriverRegistroServiziException {
        Statement stm = null;
        ResultSet rs = null;
        long idServizio = 0L;
        try {
            long idSoggetto = DBUtils.getIdSoggetto(nomeProprietario, tipoProprietario, con, this.tipoDB, this.tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizio_correlato = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String query = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(query);
            stm.setString(1, tipoServizio);
            stm.setString(2, nomeServizio);
            stm.setLong(3, idSoggetto);
            stm.setString(4, CostantiRegistroServizi.ABILITATO.toString());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServizio = rs.getLong("id");
            }
            long l = idServizio;
            return l;
        }
        catch (CoreException e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> getTipi() throws DriverRegistroServiziException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getTipi");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ArrayList<String> lista = new ArrayList<String>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("tipi");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(sqlQuery);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo = risultato.getString("nome");
                lista.add(tipo);
            }
            risultato.close();
            stmt.close();
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException(se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getTipoById(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getTipoById");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("tipi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(sqlQuery);
            stmt.setLong(1, id);
            risultato = stmt.executeQuery();
            String tipo = "";
            if (!risultato.next()) {
                throw new DriverRegistroServiziNotFound("Impossibile trovare un tipo Soggetto con id=" + id);
            }
            tipo = risultato.getString("nome");
            risultato.close();
            stmt.close();
            String string = tipo;
            return string;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziNotFound(se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Fruitore> serviziFruitoriList(int idServizi, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziFruitoriList";
        int idLista = 43;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziFruitoriList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizi);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("soggetti.tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizi);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("idFruitore"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setStatoPackage(risultato.getString("statoFruitore"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziSoggettoList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziSoggettoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziSoggettoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addSelectField("servizi.tipo_servizio");
            sqlQueryObject.addSelectField("servizi.nome_servizio");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("servizi.tipo_servizio");
            sqlQueryObject.addOrderBy("servizi.nome_servizio");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setServizio(new Servizio());
                serv.setId(risultato.getLong("id"));
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                lista.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> serviziWithIdAccordoList(long idAccordo) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziWithIdAccordoList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziWithIdAccordoList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(risultato.getLong("id"));
                lista.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int getIdServizioFruitore(int idServizio, int idSoggetto) throws DriverRegistroServiziException {
        Connection connection;
        int idFru = 0;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("getIdServizioFruitore");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdServizioFruitore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setInt(1, idServizio);
            stm.setInt(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getInt("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return idFru;
    }

    public List<Fruitore> getServiziFruitoriWithServizio(int idServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziFruitoriWithServizio";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServiziFruitoriWithServizio");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> getServiziByIdErogatore(long idErogatore) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, null);
    }

    public List<AccordoServizioParteSpecifica> getServiziByIdErogatore(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        return this.getServiziByIdErogatoreAndFilters(idErogatore, filters);
    }

    private List<AccordoServizioParteSpecifica> getServiziByIdErogatoreAndFilters(long idErogatore, ISearch filters) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByIdErogatoreAndFilters";
        int idLista = 42;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServiziByIdErogatoreAndFilters");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                filters.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_servizio", search, true, true);
            }
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idErogatore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> getServiziByFruitore(Fruitore fruitore) throws DriverRegistroServiziException {
        String nomeMetodo = "getServiziByFruitore";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getServiziByFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            long idFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruitore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Fruitore> getSoggettiWithServizioNotFruitori(int idServizio, boolean escludiSoggettiEsterni, CredenzialeTipo credenzialeTipo) throws DriverRegistroServiziException {
        String nomeMetodo = "getSoggettiWithServizioNotFruitori";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getSoggettiWithServizioNotFruitori");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectWhere = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectWhere.addFromTable("servizi_fruitori");
            sqlQueryObjectWhere.addSelectField("*");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObjectWhere.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, "pdd.tipo = ?", "pdd.tipo = ?");
            }
            if (credenzialeTipo != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
            }
            sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectWhere);
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (escludiSoggettiEsterni) {
                stmt.setString(index++, PddTipologia.OPERATIVO.toString());
                stmt.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            if (credenzialeTipo != null) {
                stmt.setString(index++, credenzialeTipo.getValue());
            }
            stmt.setInt(index++, idServizio);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            ArrayList<Fruitore> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortType> accordiPorttypeList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 33;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt");
                sqlQueryObject.addSelectField("soap_style");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt");
                sqlQueryObject.addSelectField("soap_style");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortType> accordiPorttypeList(int idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeList";
        int idLista = 33;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("port_type", "id_accordo");
            sqlQueryObject.addSelectField("port_type", "nome");
            sqlQueryObject.addSelectField("port_type", "descrizione");
            sqlQueryObject.addSelectField("port_type", "profilo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "filtro_duplicati");
            sqlQueryObject.addSelectField("port_type", "conferma_ricezione");
            sqlQueryObject.addSelectField("port_type", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "consegna_in_ordine");
            sqlQueryObject.addSelectField("port_type", "scadenza");
            sqlQueryObject.addSelectField("port_type", "profilo_pt");
            sqlQueryObject.addSelectField("port_type", "soap_style");
            sqlQueryObject.addSelectField("port_type", "id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Documento> accordiAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiAllegatiList";
        int idLista = 37;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteComuneServizioCompostoServizioComponente> accordiComponentiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiComponentiList";
        int idLista = 41;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> lista = new ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiComponentiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addFromTable("acc_serv_componenti");
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("acc_serv_componenti.id_servizio_componente", "cont");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
                sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
                sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addFromTable("acc_serv_componenti");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("acc_serv_componenti", "id_servizio_componente");
            sqlQueryObject.addSelectField("acc_serv_componenti", "azione");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectField("servizi", "tipo_servizio");
            sqlQueryObject.addSelectField("servizi", "nome_servizio");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo = ?");
            sqlQueryObject.addWhereCondition("acc_serv_composti.id = acc_serv_componenti.id_servizio_composto");
            sqlQueryObject.addWhereCondition("servizi.id = acc_serv_componenti.id_servizio_componente");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi.id_soggetto");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true));
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioComponente = risultato.getLong("id_servizio_componente");
                String azione = risultato.getString("azione");
                AccordoServizioParteComuneServizioCompostoServizioComponente asComponente = new AccordoServizioParteComuneServizioCompostoServizioComponente();
                asComponente.setAzione(azione);
                asComponente.setIdServizioComponente(idServizioComponente);
                asComponente.setTipo(risultato.getString("tipo_servizio"));
                asComponente.setNome(risultato.getString("nome_servizio"));
                asComponente.setTipoSoggetto(risultato.getString("tipo_soggetto"));
                asComponente.setNomeSoggetto(risultato.getString("nome_soggetto"));
                lista.add(asComponente);
            }
            ArrayList<AccordoServizioParteComuneServizioCompostoServizioComponente> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Documento> accordiCoopAllegatiList(int idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCoopAllegatiList";
        int idLista = 40;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiCoopAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoCooperazione.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Operation> accordiPorttypeOperationList(int idPortType, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 34;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeOperationList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("port_type_azioni.id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("port_type_azioni", "id_port_type");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "profilo_collaborazione", "profCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "filtro_duplicati", "filtro_duplicatiPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "conferma_ricezione", "conferma_ricezionePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "identificativo_collaborazione", "idCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "consegna_in_ordine", "consegna_in_ordinePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "scadenza", "scadenzaPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata", "correlataPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata_servizio", "correlataServizioPTAz");
            sqlQueryObject.addSelectField("port_type_azioni", "profilo_pt_azione");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "id", "idPTAz");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, "accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type_azioni.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            this.log.debug("Query: " + queryString);
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nomePTAz");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profCollPTAz");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicatiPTAz");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezionePTAz");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("idCollPTAz");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordinePTAz");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenzaPTAz");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataPTAz");
                op.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataServizioPTAz");
                op.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("idPTAz");
                op.setId(idOperation);
                lista.add(op);
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Operation> accordiPorttypeOperationList(int idPortType, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = 34;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeOperationList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nome");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("id");
                op.setId(idOperation);
                lista.add(op);
            }
            ArrayList<Operation> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<MessagePart> accordiPorttypeOperationMessagePartList(int idOperation, boolean isInput, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeOperationMessagePartList";
        int idLista = 35;
        if (!isInput) {
            idLista = 36;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessagePart> lista = new ArrayList<MessagePart>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeOperationMessagePartList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("name", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idOperation);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idOperation);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessagePart mp = new MessagePart();
                String tmp = risultato.getString("name");
                mp.setName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_name");
                mp.setElementName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_namespace");
                mp.setElementNamespace(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_name");
                mp.setTypeName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_namespace");
                mp.setTypeNamespace(tmp == null || tmp.equals("") ? null : tmp);
                long idMessage = risultato.getLong("id");
                mp.setId(idMessage);
                lista.add(mp);
            }
            ArrayList<MessagePart> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isCorrelata(int idAccordo, String nomeAzione, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isCorrelata");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            boolean bl = tot > 0;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isOperationCorrelata(int idPortType, String nomeCorrelata, String owner) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isOperationCorrelata");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPortType);
            stmt.setString(2, nomeCorrelata);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            boolean bl = tot > 0;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isOperationCorrelataDaAltraAzione(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, false, true);
    }

    public boolean isOperationCorrelataRichiesta(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, false);
    }

    public boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, true);
    }

    private boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare, boolean checkCorrelazioneARichiesta, boolean checkCorrelazioneDaAltraAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isOperationCorrelata(nomePortType,id,azione,idAzione,check)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            boolean correlataAdUnaRichiesta = false;
            if (checkCorrelazioneARichiesta) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = ?");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.addWhereCondition(false, "port_type_azioni.correlata is not null", "port_type_azioni.correlata_servizio is not null");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                this.log.debug("VERIFICO CORRELAZIONE AD UNA RICHIESTA [" + idPortType + "] [" + azioneDaVerificare + "]: " + queryString);
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idPortType);
                stmt.setString(2, azioneDaVerificare);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataAdUnaRichiesta = tot > 0;
                this.log.debug("VERIFICO CORRELAZIONE AD UNA RICHIESTA, risultato [" + tot + "]: " + correlataAdUnaRichiesta);
            }
            boolean correlataDaUnAltraAzione = false;
            if (checkCorrelazioneDaAltraAzione) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                sqlQueryObject.addWhereCondition(true, "port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio =?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                this.log.debug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "]: " + queryString);
                stmt.setLong(1, idAzioneDaVerificare);
                stmt.setString(2, azioneDaVerificare);
                stmt.setString(3, nomePortType);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataDaUnAltraAzione = tot > 0;
                this.log.debug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso), risultato [" + tot + "]: " + correlataDaUnAltraAzione);
                if (!correlataDaUnAltraAzione) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectCountField("id", "tot");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                    sqlQueryObject.addWhereCondition(true, "port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio is null", "port_type_azioni.id_port_type = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    this.log.debug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "] [" + azioneDaVerificare + "] [" + idPortType + "]: " + queryString);
                    stmt.setLong(1, idAzioneDaVerificare);
                    stmt.setString(2, azioneDaVerificare);
                    stmt.setLong(3, idPortType);
                    risultato = stmt.executeQuery();
                    tot = 0;
                    if (risultato.next()) {
                        tot = risultato.getInt("tot");
                    }
                    risultato.close();
                    stmt.close();
                    correlataDaUnAltraAzione = tot > 0;
                    this.log.debug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type), risultato [" + tot + "]: " + correlataDaUnAltraAzione);
                }
            }
            if (correlataAdUnaRichiesta) {
                boolean bl = true;
                return bl;
            }
            if (correlataDaUnAltraAzione) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        if (this.atomica) {
            Connection con = null;
            Statement stmtTest = null;
            try {
                con = this.getConnectionFromDatasource("isAlive");
                if (con == null) {
                    throw new Exception("Connessione is null");
                }
                stmtTest = con.createStatement();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("db_info");
                sqlQueryObject.addSelectField("*");
                String sqlQuery = sqlQueryObject.createSQLQuery();
                stmtTest.execute(sqlQuery);
            }
            catch (Exception e) {
                throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (stmtTest != null) {
                        stmtTest.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        Statement stmtTest = null;
        try {
            if (this.globalConnection == null) {
                throw new Exception("Connessione is null");
            }
            stmtTest = this.globalConnection.createStatement();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("db_info");
            sqlQueryObject.addSelectField("*");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stmtTest.execute(sqlQuery);
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
        finally {
            try {
                if (stmtTest != null) {
                    stmtTest.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(long idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiServizioList";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> serviziList = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiServizioList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addOrderBy("tipo_servizio");
            sqlQueryObject.addOrderBy("nome_servizio");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica asps = new AccordoServizioParteSpecifica();
                asps.setServizio(new Servizio());
                asps.setId(risultato.getLong("id"));
                asps.getServizio().setTipo(risultato.getString("tipo_servizio"));
                asps.getServizio().setNome(risultato.getString("nome_servizio"));
                serviziList.add(asps);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = serviziList;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(String superuser, ISearch ricerca, boolean[] permessiUtente) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettiServizioList";
        int idLista = 42;
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        boolean error = false;
        ArrayList<AccordoServizioParteSpecifica> serviziList = new ArrayList<AccordoServizioParteSpecifica>();
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("soggettiServizioList");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            ISQLQueryObject sqlQueryObjectAccordiComposti = null;
            if (permessiUtente != null) {
                sqlQueryObjectAccordiComposti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectAccordiComposti.addFromTable("accordi");
                sqlQueryObjectAccordiComposti.addFromTable("acc_serv_composti");
                sqlQueryObjectAccordiComposti.addSelectField("acc_serv_composti", "id");
                sqlQueryObjectAccordiComposti.setANDLogicOperator(true);
                sqlQueryObjectAccordiComposti.addWhereCondition("servizi.id_accordo=accordi.id");
                sqlQueryObjectAccordiComposti.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "tipo_soggetto");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.setANDLogicOperator(true);
                sqlQueryObjectSoggetti.addWhereCondition("servizi.id_soggetto=soggetti.id");
                sqlQueryObjectSoggetti.addWhereCondition(false, sqlQueryObjectSoggetti.getWhereLikeCondition("tipo_soggetto", search, true, true), sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true));
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("aps_nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectField("aps_versione");
                sqlQueryObject.addSelectField("aps_nome");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("tipo_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("nome_servizio", search, true, true), sqlQueryObject.getWhereLikeCondition("aps_nome", search, true, true), sqlQueryObject.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("servizi.id");
                sqlQueryObject.addSelectField("nome_servizio");
                sqlQueryObject.addSelectField("tipo_servizio");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addSelectField("servizio_correlato");
                sqlQueryObject.addSelectField("stato");
                sqlQueryObject.addSelectAliasField("servizi", "descrizione", "descrizioneServizio");
                sqlQueryObject.addSelectField("aps_versione");
                sqlQueryObject.addSelectField("aps_nome");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (permessiUtente != null) {
                    if (permessiUtente[0] && !permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAccordiComposti);
                    }
                    if (!permessiUtente[0] && permessiUtente[1]) {
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAccordiComposti);
                    }
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_servizio");
                sqlQueryObject.addOrderBy("nome_servizio");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            this.log.debug("query : " + queryString);
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                AccordoServizioParteSpecifica serv = new AccordoServizioParteSpecifica();
                serv.setServizio(new Servizio());
                serv.setId(risultato.getLong("id"));
                serv.getServizio().setId(risultato.getLong("id"));
                serv.getServizio().setNome(risultato.getString("nome_servizio"));
                serv.getServizio().setTipo(risultato.getString("tipo_servizio"));
                serv.setIdSoggetto(risultato.getLong("id_soggetto"));
                serv.setIdAccordo(risultato.getLong("id_accordo"));
                String servizio_correlato = risultato.getString("servizio_correlato");
                if (servizio_correlato != null && (servizio_correlato.equalsIgnoreCase(CostantiRegistroServizi.ABILITATO.toString()) || TipologiaServizio.CORRELATO.toString().equals(servizio_correlato))) {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.CORRELATO);
                } else {
                    serv.getServizio().setTipologiaServizio(TipologiaServizio.NORMALE);
                }
                serv.setDescrizione(risultato.getString("descrizioneServizio"));
                Soggetto sog = this.getSoggetto(serv.getIdSoggetto(), con);
                String nomeErogatore = sog.getNome();
                String tipoErogatore = sog.getTipo();
                serv.getServizio().setNomeSoggettoErogatore(nomeErogatore);
                serv.getServizio().setTipoSoggettoErogatore(tipoErogatore);
                AccordoServizioParteComune as = this.getAccordoServizioParteComune((long)serv.getIdAccordo(), con);
                serv.setAccordoServizioParteComune(this.idAccordoFactory.getUriFromAccordo(as));
                serv.setStatoPackage(risultato.getString("stato"));
                serv.setNome(risultato.getString("aps_nome"));
                serv.setVersione(risultato.getString("aps_versione"));
                serviziList.add(serv);
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = serviziList;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void createConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("createConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 1");
            DriverRegistroServiziDB_LIB.CRUDConnettore(1, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createConnettore] Errore durante la creazione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void updateConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("updateConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 2");
            DriverRegistroServiziDB_LIB.CRUDConnettore(2, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateConnettore] Errore durante l'aggiornamento del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteConnettore(Connettore connettore) throws DriverRegistroServiziException {
        if (connettore == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("deleteConnettore");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            this.log.debug("CRUDConnettore type = 3");
            DriverRegistroServiziDB_LIB.CRUDConnettore(3, connettore, con);
        }
        catch (DriverRegistroServiziException qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteConnettore] Errore durante la rimozione del connettore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDominio> porteDominioList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        return this.porteDominioList(superuser, null, ricerca);
    }

    public List<PortaDominio> porteDominioList(String superuser, String tipo, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioList";
        int idLista = 0;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDominioList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject;
            String queryString;
            ISQLQueryObject sqlQueryObject2;
            if (!search.equals("")) {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("pdd");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject2.addWhereCondition("tipo = ?");
                }
                sqlQueryObject2.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            } else {
                sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject2.addFromTable("pdd");
                sqlQueryObject2.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject2.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject2.addWhereCondition("tipo = ?");
                }
                sqlQueryObject2.setANDLogicOperator(true);
                queryString = sqlQueryObject2.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (tipo != null && !tipo.equals("")) {
                stmt.setString(index++, tipo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (tipo != null && !tipo.equals("")) {
                    sqlQueryObject.addWhereCondition("tipo = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (tipo != null && !tipo.equals("")) {
                stmt.setString(index++, tipo);
            }
            risultato = stmt.executeQuery();
            lista = new ArrayList<PortaDominio>();
            while (risultato.next()) {
                String nome = risultato.getString("nome");
                PortaDominio pdd = this.getPortaDominio(nome);
                lista.add(pdd);
            }
            ArrayList<PortaDominio> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isPddInUso(PortaDominio pdd, List<String> whereIsInUso) throws DriverRegistroServiziException {
        String nomeMetodo = "pddInUso";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isPddInUso");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("server = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, pdd.getNome());
            risultato = stmt.executeQuery();
            boolean isInUso = false;
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipo_soggetto");
                String nome_soggetto = risultato.getString("nome_soggetto");
                whereIsInUso.add(tipo_soggetto + "/" + nome_soggetto);
                isInUso = true;
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Soggetto> pddSoggettiList(int idPdd, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "pddSoggettiList";
        int idLista = 1;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("pddSoggettiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        ArrayList<Soggetto> lista = null;
        try {
            String nomePdd = "";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idPdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                nomePdd = risultato.getString("nome");
            }
            risultato.close();
            stmt.close();
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Soggetto>();
            Soggetto sog = null;
            while (risultato.next()) {
                long ids = risultato.getLong("id");
                sog = this.getSoggetto(ids, con);
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<IDSoggetto> getAllIdSoggettiErogatori(String tipoServizio, String nomeServizio, String uriAccordo, String nomePortType, String tipoSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getAllIdSoggettiErogatori";
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getAllIdSoggettiErogatori");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoSoggetto");
            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeSoggetto");
            sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio= ?");
            sqlQueryObject.addWhereCondition("servizi.id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.port_type = ?");
            if (tipoSoggetto != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, tipoServizio);
            stmt.setString(2, nomeServizio);
            stmt.setLong(3, idAccordoLong);
            stmt.setString(4, nomePortType);
            if (tipoSoggetto != null) {
                stmt.setString(5, tipoSoggetto);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String tipo_soggetto = risultato.getString("tipoSoggetto");
                String nome_soggetto = risultato.getString("nomeSoggetto");
                lista.add(new IDSoggetto(tipo_soggetto, nome_soggetto));
            }
            ArrayList<IDSoggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public PortType getPortType(IDPortType idPT) throws DriverRegistroServiziException {
        String nomeMetodo = "getPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getPortType");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo=?");
            sqlQueryObject.addWhereCondition("port_type.nome=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setString(2, idPT.getNome());
            rs = stmt.executeQuery();
            PortType pt = null;
            if (rs.next()) {
                pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(idAccordoLong);
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
            }
            PortType portType = pt;
            return portType;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Vector<IDServizio> getIdServiziWithPortType(IDPortType idPT) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIdServiziWithPortType");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        try {
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.port_type=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setString(2, idPT.getNome());
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano il servizio " + idPT.getNome() + " dell'accordo di servizio " + idPT.getIdAccordo().toString());
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            throw dNot;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Vector<IDServizio> getIdServiziWithAccordo(IDAccordo idAccordo, boolean checkPTisNull) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getIdServiziWithAccordo");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        Vector<IDServizio> idServizi = new Vector<IDServizio>();
        try {
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            if (checkPTisNull) {
                sqlQueryObject.addWhereCondition("servizi.port_type is null");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDServizio idServizio = new IDServizio(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"), rs.getString("tipo_servizio"), rs.getString("nome_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano l'accordo di servizio " + idAccordo.toString());
            }
            Vector<IDServizio> vector = idServizi;
            return vector;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            throw dNot;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isUnicaAzioneInAccordi(String azione) throws DriverRegistroServiziException {
        String nomeMetodo = "isUnicaAzioneInAccordi";
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("isUnicaAzioneInAccordi");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("accordi_azioni.nome=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            int count = 0;
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita)");
            }
            count = rs.getInt("countAzioni");
            rs.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("port_type_azioni.nome=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita pt)");
            }
            if ((count += rs.getInt("countAzioni")) <= 0) {
                throw new Exception("Azione [" + azione + "] non trovata");
            }
            boolean bl = count == 1;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsDocumento(String nome, String tipo, String ruolo, long idProprietario, ProprietariDocumento proprietarioDocumento) throws DriverRegistroServiziException {
        Connection connection;
        boolean exist = false;
        Statement stm = null;
        ResultSet rs = null;
        if (this.atomica) {
            try {
                connection = this.getConnectionFromDatasource("existsDocumento");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::existsDocumento] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.globalConnection;
        }
        this.log.debug("operazione atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("tipo = ?");
            sqlQueryObject.addWhereCondition("ruolo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idProprietario);
            stm.setString(2, proprietarioDocumento.toString());
            stm.setString(3, nome);
            stm.setString(4, tipo);
            stm.setString(5, ruolo);
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            exist = false;
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stm != null) {
                    stm.close();
                }
            }
            catch (Exception exception) {}
            if (this.atomica) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return exist;
    }

    public Documento getDocumento(String nome, String tipo, String ruolo, long idProprietario, boolean readBytes, ProprietariDocumento tipoProprietario) throws DriverRegistroServiziException {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getDocumento");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String tipoProprietarioAsString = null;
            if (tipoProprietario != null) {
                tipoProprietarioAsString = tipoProprietario.toString();
            }
            long idDoc = DBUtils.getIdDocumento(nome, tipo, ruolo, idProprietario, con, this.tipoDB, tipoProprietarioAsString);
            Documento documento = DriverRegistroServiziDB_LIB.getDocumento(idDoc, readBytes, con, this.tipoDB);
            return documento;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Documento getDocumento(long idDocumento, boolean readBytes) throws DriverRegistroServiziException {
        String nomeMetodo = "getDocumento";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("getDocumento");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            Documento e = DriverRegistroServiziDB_LIB.getDocumento(idDocumento, readBytes, con, this.tipoDB);
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Documento> serviziAllegatiList(int idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziAllegatiList";
        int idLista = 45;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("serviziAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, sqlQueryObject.getWhereLikeCondition("roulo", search, true, true), sqlQueryObject.getWhereLikeCondition("nome", search, true, true));
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idServizio);
            stmt.setString(2, ProprietariDocumento.servizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_LIB.getDocumento(risultato.getLong("id"), false, con, this.tipoDB);
                lista.add(doc);
            }
            ArrayList<Documento> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void validaStatoAccordoServizio(AccordoServizioParteComune as, boolean utilizzoAzioniDiretteInAccordoAbilitato) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block47: {
            erroreValidazione = new ValidazioneStatoPackageException("AccordoServizio", as.getStatoPackage(), null);
            try {
                if (!(as.getPrivato() != null && as.getPrivato().booleanValue() || as.getSoggettoReferente() == null)) {
                    IDSoggetto idS = new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome());
                    try {
                        Soggetto s = this.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound s) {
                        // empty catch block
                    }
                }
                if (as.getServizioComposto() != null) {
                    if (as.getServizioComposto().getIdAccordoCooperazione() > 0L) {
                        try {
                            AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                            if ((as.getPrivato() == null || !as.getPrivato().booleanValue()) && ac.getPrivato() != null && ac.getPrivato().booleanValue()) {
                                erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                            }
                        }
                        catch (DriverRegistroServiziNotFound ac) {
                            // empty catch block
                        }
                    }
                    if (as.getServizioComposto().sizeServizioComponenteList() >= 2) {
                        for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                            if (as.getServizioComposto().getServizioComponente(i).getId() <= 0L) continue;
                            try {
                                AccordoServizioParteSpecifica sc = this.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getId());
                                if (as.getPrivato() != null && as.getPrivato().booleanValue() || sc.getPrivato() == null || !sc.getPrivato().booleanValue()) continue;
                                erroreValidazione.addErroreValidazione("servizio componente [" + sc.getServizio().getTipo() + "/" + sc.getServizio().getNome() + "_" + sc.getServizio().getTipoSoggettoErogatore() + "/" + sc.getServizio().getNomeSoggettoErogatore() + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound sc) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) break block47;
                if (!utilizzoAzioniDiretteInAccordoAbilitato) {
                    if (as.sizePortTypeList() == 0) {
                        erroreValidazione.addErroreValidazione("non sono definiti Servizi");
                    }
                    for (int j = 0; j < as.sizePortTypeList(); ++j) {
                        if (as.getPortType(j).sizeAzioneList() != 0) continue;
                        erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                    }
                } else {
                    if (as.sizePortTypeList() == 0 && as.sizeAzioneList() == 0 && !as.getUtilizzoSenzaAzione()) {
                        erroreValidazione.addErroreValidazione("non sono definite ne Azioni (utilizzoSenzaAzione=false) ne Servizi");
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            if (as.getPortType(j).sizeAzioneList() != 0) continue;
                            erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                        }
                    }
                    if (as.sizePortTypeList() != 0) {
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            PortType pt = as.getPortType(j);
                            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                                Operation op = pt.getAzione(k);
                                ProfiloCollaborazione profiloCollaborazioneOP = op.getProfiloCollaborazione();
                                if ("default".equals(op.getProfAzione())) {
                                    profiloCollaborazioneOP = pt.getProfiloCollaborazione();
                                    if ("default".equals(pt.getProfiloPT())) {
                                        profiloCollaborazioneOP = as.getProfiloCollaborazione();
                                    }
                                }
                                if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) && !CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals(profiloCollaborazioneOP) || op.getCorrelata() != null) continue;
                                boolean trovataCorrelazione = false;
                                block17: for (int verificaPTIndex = 0; verificaPTIndex < as.sizePortTypeList(); ++verificaPTIndex) {
                                    PortType ptVerifica = as.getPortType(verificaPTIndex);
                                    for (int verificaOPIndex = 0; verificaOPIndex < ptVerifica.sizeAzioneList(); ++verificaOPIndex) {
                                        Operation opVerifica = ptVerifica.getAzione(verificaOPIndex);
                                        if (opVerifica.getCorrelata() == null || !opVerifica.getCorrelata().equals(op.getNome())) continue;
                                        if (opVerifica.getCorrelataServizio() == null) {
                                            if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) || !ptVerifica.getNome().equals(pt.getNome())) continue;
                                            trovataCorrelazione = true;
                                            continue block17;
                                        }
                                        if (!opVerifica.getCorrelataServizio().equals(pt.getNome())) continue;
                                        trovataCorrelazione = true;
                                        continue block17;
                                    }
                                }
                                if (trovataCorrelazione) continue;
                                erroreValidazione.addErroreValidazione("L'azione [" + op.getNome() + "] del servizio[" + as.getPortType(j).getNome() + "] non risulta correlata da altre azioni");
                            }
                        }
                    }
                }
                if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) break block47;
                String wsdlConcettuale = as.getByteWsdlConcettuale() != null ? new String(as.getByteWsdlConcettuale()) : null;
                String wsdlLogicoErogatore = as.getByteWsdlLogicoErogatore() != null ? new String(as.getByteWsdlLogicoErogatore()) : null;
                wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
                String string = wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
                if (wsdlConcettuale == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL Concettuale non definita");
                }
                if (wsdlLogicoErogatore == null) {
                    erroreValidazione.addErroreValidazione("interfaccia WSDL LogicoErogatore non definita");
                }
                if (as.getServizioComposto() == null) break block47;
                if (as.getServizioComposto().getIdAccordoCooperazione() <= 0L) {
                    erroreValidazione.addErroreValidazione("accordo di cooperazione (id) non definito");
                } else {
                    try {
                        AccordoCooperazione ac = this.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                        if (!StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] in uno stato non finale [" + ac.getStatoPackage() + "]");
                        }
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di cooperazione non definito");
                    }
                }
                if (as.getServizioComposto().sizeSpecificaCoordinamentoList() <= 0) {
                    erroreValidazione.addErroreValidazione("specifica di coordinamento non definita");
                }
                if (as.getServizioComposto().sizeServizioComponenteList() <= 0) {
                    erroreValidazione.addErroreValidazione("servizi componenti non definiti");
                } else if (as.getServizioComposto().sizeServizioComponenteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 servizi componenti sono necessari per realizzare un servizio composto");
                } else {
                    for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                        if (as.getServizioComposto().getServizioComponente(i).getIdServizioComponente() <= 0L) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] (id) non definito");
                            continue;
                        }
                        try {
                            AccordoServizioParteSpecifica sc = this.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getIdServizioComponente());
                            if (StatiAccordo.finale.toString().equals(sc.getStatoPackage())) continue;
                            erroreValidazione.addErroreValidazione("servizio componente [" + sc.getServizio().getTipo() + "/" + sc.getServizio().getNome() + "_" + sc.getServizio().getTipoSoggettoErogatore() + "/" + sc.getServizio().getNomeSoggettoErogatore() + "] in uno stato non finale [" + sc.getStatoPackage() + "]");
                            continue;
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            erroreValidazione.addErroreValidazione("servizio componente [" + i + "] non definito");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoAccordoCooperazione(AccordoCooperazione ac) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("AccordoCooperazione", ac.getStatoPackage(), null);
        try {
            AccordoCooperazionePartecipanti partecipanti;
            if (!(ac.getPrivato() != null && ac.getPrivato().booleanValue() || ac.getSoggettoReferente() == null)) {
                IDSoggetto idS = new IDSoggetto(ac.getSoggettoReferente().getTipo(), ac.getSoggettoReferente().getNome());
                try {
                    Soggetto s = this.getSoggetto(idS);
                    if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                        erroreValidazione.addErroreValidazione("soggetto referente [" + idS + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                    }
                }
                catch (DriverRegistroServiziNotFound s) {
                    // empty catch block
                }
            }
            if (ac.getElencoPartecipanti() != null && (partecipanti = ac.getElencoPartecipanti()).sizeSoggettoPartecipanteList() >= 2) {
                for (int i = 0; i < partecipanti.sizeSoggettoPartecipanteList(); ++i) {
                    Soggetto s2;
                    IdSoggetto idSoggettoPartecipante = partecipanti.getSoggettoPartecipante(i);
                    if (idSoggettoPartecipante.getIdSoggetto() != null && idSoggettoPartecipante.getIdSoggetto() > 0L) {
                        try {
                            s2 = this.getSoggetto(partecipanti.getSoggettoPartecipante(i).getIdSoggetto());
                            if (s2.getPrivato() == null || !s2.getPrivato().booleanValue()) continue;
                            erroreValidazione.addErroreValidazione("soggetto partecipante [" + s2.getTipo() + "/" + s2.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        }
                        catch (DriverRegistroServiziNotFound s2) {}
                        continue;
                    }
                    if (idSoggettoPartecipante.getTipo() == null || idSoggettoPartecipante.getNome() == null) continue;
                    try {
                        s2 = this.getSoggetto(new IDSoggetto(idSoggettoPartecipante.getTipo(), idSoggettoPartecipante.getNome()));
                        if (s2.getPrivato() == null || !s2.getPrivato().booleanValue()) continue;
                        erroreValidazione.addErroreValidazione("soggetto partecipante [" + s2.getTipo() + "/" + s2.getNome() + "] con visibilita' privata, in un accordo di cooperazione con visibilita' pubblica");
                        continue;
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                }
            }
            if (!StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                if (ac.getElencoPartecipanti() == null) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() <= 0) {
                    erroreValidazione.addErroreValidazione("soggetti partecipanti non definiti");
                } else if (ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() < 2) {
                    erroreValidazione.addErroreValidazione("almeno 2 soggetti partecipanti devono essere definiti");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoAccordoServizioParteSpecifica(AccordoServizioParteSpecifica servizio) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block22: {
            erroreValidazione = new ValidazioneStatoPackageException("Servizio", servizio.getStatoPackage(), null);
            try {
                Soggetto soggettoErogatore;
                AccordoServizioParteComune as;
                if (servizio.getPrivato() == null || !servizio.getPrivato().booleanValue()) {
                    IDSoggetto idS = new IDSoggetto(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore());
                    try {
                        Soggetto s = this.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto erogatore [" + idS + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound s) {
                        // empty catch block
                    }
                    try {
                        AccordoServizioParteComune as2 = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (as2.getPrivato() != null && as2.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("accordo di servizio [" + servizio.getAccordoServizioParteComune() + "] con visibilita' privata, in un servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                }
                if (StatiAccordo.bozza.toString().equals(servizio.getStatoPackage())) break block22;
                if (StatiAccordo.operativo.toString().equals(servizio.getStatoPackage())) {
                    try {
                        as = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                        if (!StatiAccordo.finale.toString().equals(as.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(as.getStatoPackage())) {
                            erroreValidazione.addErroreValidazione("accordo di servizio riferito [" + this.idAccordoFactory.getUriFromAccordo(as) + "] possiede lo stato [" + as.getStatoPackage() + "]");
                        }
                        break block22;
                    }
                    catch (DriverRegistroServiziNotFound dNot) {
                        erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                    }
                    break block22;
                }
                if (!StatiAccordo.finale.toString().equals(servizio.getStatoPackage())) break block22;
                try {
                    as = this.getAccordoServizioParteComune(this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune()));
                    if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("accordo di servizio [" + this.idAccordoFactory.getUriFromAccordo(as) + "] in uno stato non finale [" + as.getStatoPackage() + "]");
                    }
                }
                catch (DriverRegistroServiziNotFound dNot) {
                    erroreValidazione.addErroreValidazione("accordo di servizio non definito");
                }
                if (TipologiaServizio.CORRELATO.equals(servizio.getServizio().getTipologiaServizio())) {
                    String wsdlImplementativoFruitore = servizio.getByteWsdlImplementativoFruitore() != null ? new String(servizio.getByteWsdlImplementativoFruitore()) : null;
                    String string = wsdlImplementativoFruitore = wsdlImplementativoFruitore != null && !"".equals(wsdlImplementativoFruitore.trim().replaceAll("\n", "")) ? wsdlImplementativoFruitore : null;
                    if (wsdlImplementativoFruitore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo fruitore non definito");
                    }
                } else {
                    String wsdlImplementativoErogatore = servizio.getByteWsdlImplementativoErogatore() != null ? new String(servizio.getByteWsdlImplementativoErogatore()) : null;
                    String string = wsdlImplementativoErogatore = wsdlImplementativoErogatore != null && !"".equals(wsdlImplementativoErogatore.trim().replaceAll("\n", "")) ? wsdlImplementativoErogatore : null;
                    if (wsdlImplementativoErogatore == null) {
                        erroreValidazione.addErroreValidazione("WSDL Implementativo erogatore non definito");
                    }
                }
                if ((servizio.getServizio().getConnettore() == null || CostantiDB.CONNETTORE_TIPO_DISABILITATO.equals(servizio.getServizio().getConnettore().getTipo())) && ((soggettoErogatore = this.getSoggetto(new IDSoggetto(servizio.getServizio().getTipoSoggettoErogatore(), servizio.getServizio().getNomeSoggettoErogatore()))).getConnettore() == null || CostantiDB.CONNETTORE_TIPO_DISABILITATO.equals(soggettoErogatore.getConnettore().getTipo()))) {
                    erroreValidazione.addErroreValidazione("Sia l'Accordo di servizio parte specifica che il soggetto erogatore non possiedono un connettore");
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void validaStatoFruitoreServizio(Fruitore fruitore, AccordoServizioParteSpecifica serv) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("FruitoreServizio", fruitore.getStatoPackage(), null);
        try {
            if (!StatiAccordo.bozza.toString().equals(fruitore.getStatoPackage())) {
                if (StatiAccordo.operativo.toString().equals(fruitore.getStatoPackage())) {
                    if (!StatiAccordo.finale.toString().equals(serv.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(serv.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("servizio riferito [" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] erogato dal soggetto [" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] possiede lo stato [" + serv.getStatoPackage() + "]");
                    }
                } else if (StatiAccordo.finale.toString().equals(fruitore.getStatoPackage()) && !StatiAccordo.finale.toString().equals(serv.getStatoPackage())) {
                    erroreValidazione.addErroreValidazione("servizio [" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome() + "] erogato dal soggetto [" + serv.getServizio().getTipoSoggettoErogatore() + "/" + serv.getServizio().getNomeSoggettoErogatore() + "] in uno stato non finale [" + serv.getStatoPackage() + "]");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    public void controlloUnicitaImplementazioneAccordoPerSoggetto(String portType, IDSoggetto idSoggettoErogatore, long idSoggettoErogatoreLong, IDAccordo idAccordoServizioParteComune, long idAccordoServizioParteComuneLong, IDServizio idAccordoServizioParteSpecifica, long idAccordoServizioParteSpecificaLong, boolean isUpdate, boolean isServizioCorrelato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) throws DriverRegistroServiziException {
        String tmpServCorr = CostantiRegistroServizi.DISABILITATO.toString();
        if (isServizioCorrelato) {
            tmpServCorr = CostantiRegistroServizi.ABILITATO.toString();
        }
        String s = "servizio";
        if (isServizioCorrelato) {
            s = "servizio correlato";
        }
        if (portType == null || "-".equals(portType)) {
            if (isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto) {
                int idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorr(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, tmpServCorr);
                boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0;
                boolean changeError = false;
                if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0) {
                    boolean bl = changeError = idAccordoServizioParteSpecificaLong != (long)idAccordoServizioParteSpecificaAlreadyExists;
                }
                if (addError || changeError) {
                    throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa l'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
                }
            }
        } else if (isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) {
            int idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorrPt(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, tmpServCorr, portType);
            boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0;
            boolean changeError = false;
            if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0) {
                boolean bl = changeError = idAccordoServizioParteSpecificaLong != (long)idAccordoServizioParteSpecificaAlreadyExists;
            }
            if (addError || changeError) {
                throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa il servizio " + portType + " dell'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
            }
        }
    }

    public List<AccordoServizioParteComune> accordiCompatibiliList(ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCompatibiliList";
        int idLista = 30;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.log.debug("search : " + search);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> lista = new ArrayList<AccordoServizioParteComune>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiCompatibiliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true), "accordi.id_referente=soggetti.id");
            }
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereCondition(false, sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addWhereCondition(false, sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti));
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            this.log.debug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            AccordoServizioParteComune accordo = null;
            while (risultato.next()) {
                accordo = new AccordoServizioParteComune();
                accordo.setId(risultato.getLong("id"));
                accordo.setNome(risultato.getString("nome"));
                accordo.setDescrizione(risultato.getString("descrizione"));
                accordo.setStatoPackage(risultato.getString("stato"));
                accordo.setVersione(risultato.getString("versione"));
                if (risultato.getInt("id_referente") > 0) {
                    Soggetto soggRef = this.getSoggetto(risultato.getInt("id_referente"), con);
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggRef.getTipo());
                    assr.setNome(soggRef.getNome());
                    accordo.setSoggettoReferente(assr);
                }
                lista.add(accordo);
                this.readAccordoServizioComposto(accordo, con);
            }
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
        return lista;
    }

    public List<PortType> accordiPorttypeCompatibiliList(int idAccordo, boolean isErogazione, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiPorttypeCompatibiliList";
        int idLista = 33;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("accordiPorttypeCompatibiliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_LIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setInt(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                lista.add(pt);
            }
            ArrayList<PortType> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.atomica) {
                    this.log.debug("rilascio connessioni al db...");
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<PortaDominio> porteDominioWithSubject(String subject) throws DriverRegistroServiziException {
        String nomeMetodo = "porteDominioWithSubject";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDominio> lista = new ArrayList<PortaDominio>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("porteDominioWithSubject");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            Hashtable<String, String> hashSubject = Utilities.getSubjectIntoHashtable(subject);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("subject");
            Enumeration<String> keys = hashSubject.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = hashSubject.get(key);
                sqlQueryObject.addWhereLikeCondition("subject", "/" + Utilities.formatKeySubject(key) + "=" + Utilities.formatValueSubject(value) + "/", true, false);
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String subjectPotenziale = risultato.getString("subject");
                if (!Utilities.sslVerify(subjectPotenziale, subject, this.log)) continue;
                PortaDominio pdd = this.getPortaDominio(risultato.getString("nome"));
                lista.add(pdd);
            }
            ArrayList<PortaDominio> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<String> fruzioniWithClientAuthAbilitato(String nomePdD) throws DriverRegistroServiziException {
        String nomeMetodo = "fruzioniWithClientAuthAbilitato";
        Connection con = null;
        boolean error = false;
        Statement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.atomica) {
            try {
                con = this.getConnectionFromDatasource("fruzioniWithClientAuthAbilitato");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.globalConnection;
        }
        this.log.debug("operazione this.atomica = " + this.atomica);
        try {
            ISQLQueryObject sqlQueryObjectInner = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObjectInner.addFromTable(this.tabellaSoggetti);
            sqlQueryObjectInner.addSelectField("id");
            sqlQueryObjectInner.addWhereCondition("server=?");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(this.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("client_auth=?");
            sqlQueryObject.addWhereINSelectSQLCondition(false, "id_soggetto", sqlQueryObjectInner);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            this.log.debug("QUERY [" + queryString + "] 1[" + CostantiRegistroServizi.ABILITATO + "] 2[" + nomePdD + "]");
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.ABILITATO));
            stmt.setString(2, nomePdD);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto fruitore = this.getSoggetto(risultato.getLong("id_soggetto"));
                AccordoServizioParteSpecifica servizio = this.getAccordoServizioParteSpecifica(risultato.getLong("id_servizio"));
                lista.add("Fruizione da parte del soggetto " + fruitore.getTipo() + "/" + fruitore.getNome() + " verso l'accordo di servizio parte specifica " + this.idAccordoFactory.getUriFromAccordo(servizio) + ", servizio " + servizio.getServizio().getTipo() + "/" + servizio.getServizio().getNome());
            }
            ArrayList<String> arrayList = lista;
            return arrayList;
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (error && this.atomica) {
                    this.log.debug("eseguo rollback a causa di errori e rilascio connessioni...");
                    con.rollback();
                    con.setAutoCommit(true);
                    con.close();
                } else if (!error && this.atomica) {
                    this.log.debug("eseguo commit e rilascio connessioni...");
                    con.commit();
                    con.setAutoCommit(true);
                    con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

