/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipiConnettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazionePartecipanti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Azione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.CredenzialiSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.MessagePart;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzioneFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingStyle;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.BindingUse;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoliDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoCoordinamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoLivelloServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSemiformale;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSicurezza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionEngine;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    private RegistroServizi registro = null;
    private List<String> errori = new ArrayList<String>();
    private Logger log = null;
    private boolean checkEsistenzaFileDefinitoTramiteURI = false;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
    private List<String> tipoConnettori = new ArrayList<String>();
    private List<String> tipoSoggetti = new ArrayList<String>();
    private List<String> tipoServizi = new ArrayList<String>();

    private String getTipoConnettori() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoConnettori.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoConnettori.get(i));
        }
        return bf.toString();
    }

    private String getTipoSoggetti() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoSoggetti.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoSoggetti.get(i));
        }
        return bf.toString();
    }

    private String getTipoServizi() {
        StringBuffer bf = new StringBuffer();
        for (int i = 0; i < this.tipoServizi.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.tipoServizi.get(i));
        }
        return bf.toString();
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi, Logger log) throws DriverRegistroServiziException {
        int i;
        this.registro = registro;
        this.checkEsistenzaFileDefinitoTramiteURI = checkEsistenzaFileDefinitoTramiteURI;
        this.log = log;
        if (tipoConnettori != null && tipoConnettori.length > 0) {
            for (i = 0; i < tipoConnettori.length; ++i) {
                this.tipoConnettori.add(tipoConnettori[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di connettori ammissibili non definiti");
        }
        if (tipoSoggetti != null && tipoSoggetti.length > 0) {
            for (i = 0; i < tipoSoggetti.length; ++i) {
                this.tipoSoggetti.add(tipoSoggetti[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di soggetti ammissibili non definiti");
        }
        if (tipoServizi != null && tipoServizi.length > 0) {
            for (i = 0; i < tipoServizi.length; ++i) {
                this.tipoServizi.add(tipoServizi[i]);
            }
        } else {
            throw new DriverRegistroServiziException("Tipo di servizi ammissibili non definiti");
        }
    }

    public ValidazioneSemantica(RegistroServizi registro, boolean checkEsistenzaFileDefinitoTramiteURI, String[] tipoConnettori, String[] tipoSoggetti, String[] tipoServizi) throws DriverRegistroServiziException {
        this(registro, checkEsistenzaFileDefinitoTramiteURI, tipoConnettori, tipoSoggetti, tipoServizi, null);
    }

    private void printMsg(String msg) {
        if (this.log == null) {
            System.out.println(msg);
        } else {
            this.log.debug(msg);
        }
    }

    public void validazioneSemantica(boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        int i;
        if (showIDOggettiAnalizzati) {
            this.printMsg("---------------------------------------AccordiCooperazione(" + this.registro.sizeAccordoCooperazioneList() + ")--------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di cooperazione: " + this.idAccordoCooperazioneFactory.getUriFromAccordo(ac));
            }
            this.validaAccordoCooperazione(ac);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------AccordiServizioParteComune(" + this.registro.sizeAccordoServizioParteComuneList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeAccordoServizioParteComuneList(); ++i) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Accordo di servizio parte comune: " + this.idAccordoFactory.getUriFromAccordo(as));
            }
            this.validaAccordoServizioParteComune(as);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Soggetti(" + this.registro.sizeSoggettoList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeSoggettoList(); ++i) {
            Soggetto sogg = this.registro.getSoggetto(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Soggetto: " + sogg.getTipo() + "/" + sogg.getNome());
            }
            this.validaSoggetto(sogg, showIDOggettiAnalizzati);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Porte di Dominio(" + this.registro.sizePortaDominioList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Porta di dominio: " + pd.getNome());
            }
            this.validaPortaDominio(pd);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Ruoli(" + this.registro.sizeRuoloList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeRuoloList(); ++i) {
            Ruolo ruolo = this.registro.getRuolo(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Ruolo: " + ruolo.getNome());
            }
            this.validaRuolo(ruolo);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n------------------------------------Connettori(" + this.registro.sizeConnettoreList() + ")-----------------------------------------------------");
        }
        for (i = 0; i < this.registro.sizeConnettoreList(); ++i) {
            Connettore con = this.registro.getConnettore(i);
            if (showIDOggettiAnalizzati) {
                this.printMsg("Connettore: " + con.getNome());
            }
            this.validaConnettore(con, null, null);
        }
        if (showIDOggettiAnalizzati) {
            this.printMsg("\n\n-----------------------------------------------------------------------------------------");
        }
        if (!this.errori.isEmpty()) {
            StringBuffer stringB = new StringBuffer().append("\n");
            Iterator<String> itE = this.errori.iterator();
            while (itE.hasNext()) {
                stringB.append(itE.next()).append("\n");
            }
            throw new DriverRegistroServiziException(stringB.toString());
        }
    }

    private void validaAccordoCooperazione(AccordoCooperazione ac) throws DriverRegistroServiziException {
        int i;
        if (ac.getNome() == null) {
            this.errori.add("Esiste un accordo di cooperazione senza nome");
            return;
        }
        IDAccordoCooperazione idAccordoCooperazione = this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(ac);
        String uriAC = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordoCooperazione);
        IdSoggetto acsr = ac.getSoggettoReferente();
        if (acsr != null) {
            if (acsr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (acsr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente dell'accordo cooperazione " + uriAC + " non definito");
            } else if (!this.existsSoggetto(acsr.getTipo(), acsr.getNome())) {
                this.errori.add("Il soggetto referente [" + acsr.getTipo() + "/" + acsr.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        if (ac.getElencoPartecipanti() != null) {
            AccordoCooperazionePartecipanti partecipanti = ac.getElencoPartecipanti();
            for (int i2 = 0; i2 < partecipanti.sizeSoggettoPartecipanteList(); ++i2) {
                IdSoggetto partecipante = partecipanti.getSoggettoPartecipante(i2);
                if (partecipante.getTipo() == null) {
                    this.errori.add("Tipo di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                    continue;
                }
                if (partecipante.getNome() == null) {
                    this.errori.add("Nome di un soggetto partecipante dell'accordo cooperazione " + uriAC + " non definito");
                    continue;
                }
                if (this.existsSoggetto(partecipante.getTipo(), partecipante.getNome())) continue;
                this.errori.add("Il soggetto partecipante [" + partecipante.getTipo() + "/" + partecipante.getNome() + "] dell'accordo cooperazione " + uriAC + " non corrisponde a nessuno dei soggetti registrati");
            }
            if (partecipanti.sizeSoggettoPartecipanteList() < 2) {
                this.errori.add("L'accordo di cooperazione [" + uriAC + "] non possiede il numero minimo di soggetti partecipanti (2)");
            }
        } else {
            this.errori.add("L'accordo di cooperazione [" + uriAC + "] non possiede soggetti partecipanti (attesi almeno 2)");
        }
        for (i = 0; i < ac.sizeAllegatoList(); ++i) {
            Documento allegato = ac.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "accordoCooperazione[" + uriAC + "]");
        }
        for (i = 0; i < ac.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = ac.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "accordoCooperazione[" + uriAC + "]");
        }
        try {
            if (!RegularExpressionEngine.isMatch(ac.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome dell'accordo di cooperazione [" + uriAC + "] dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'accordo di cooperazione [" + uriAC + "]: " + e.getMessage(), e);
        }
        if (ac.getVersione() != null) {
            try {
                if (!RegularExpressionEngine.isMatch(ac.getVersione(), "^[1-9]+[0-9]*$")) {
                    this.errori.add("La versione dell'accordo di cooperazione [" + uriAC + "] dev'essere rappresentata da un numero intero");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione dell'accordo di cooperazione [" + uriAC + "]: " + e.getMessage(), e);
            }
        }
        int numAc = 0;
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione tmpAc = this.registro.getAccordoCooperazione(j);
            if (!this.idAccordoCooperazioneFactory.getUriFromAccordo(ac).equals(this.idAccordoCooperazioneFactory.getUriFromAccordo(tmpAc))) continue;
            ++numAc;
        }
        if (numAc > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di cooperazione con uri " + uriAC);
        }
    }

    private void validaAccordoServizioParteComune(AccordoServizioParteComune as) throws DriverRegistroServiziException {
        StatoFunzionalita consOrd;
        StatoFunzionalita idColl;
        StatoFunzionalita confRic;
        StatoFunzionalita consOrd2;
        StatoFunzionalita idColl2;
        StatoFunzionalita confRic2;
        StatoFunzionalita filtroDup;
        ProfiloCollaborazione profColl;
        int i;
        int j;
        if (as.getNome() == null) {
            this.errori.add("Esiste un accordo di servizio senza nome");
            return;
        }
        IDAccordo idAccordoServizio = this.idAccordoFactory.getIDAccordoFromAccordo(as);
        Object uriAS = this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizio);
        AccordoServizioParteComuneServizioComposto assc = as.getServizioComposto();
        uriAS = assc != null ? "servizio composto [" + (String)uriAS + "]" : "accordo di servizio [" + (String)uriAS + "]";
        IdSoggetto assr = as.getSoggettoReferente();
        if (assr != null) {
            if (assr.getTipo() == null) {
                this.errori.add("Tipo di un soggetto referente nel " + (String)uriAS + " non definito");
            } else if (assr.getNome() == null) {
                this.errori.add("Nome di un soggetto referente nel " + (String)uriAS + " non definito");
            } else if (!this.existsSoggetto(assr.getTipo(), assr.getNome())) {
                this.errori.add("Il soggetto referente [" + assr.getTipo() + "/" + assr.getNome() + "] nel " + (String)uriAS + " non corrisponde a nessuno dei soggetti registrati");
            }
        }
        if (assc != null) {
            for (j = 0; j < assc.sizeServizioComponenteList(); ++j) {
                AccordoServizioParteComuneServizioCompostoServizioComponente asscsc = assc.getServizioComponente(j);
                if (asscsc.getTipo() == null) {
                    this.errori.add("Tipo di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getNome() == null) {
                    this.errori.add("Nome di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getTipoSoggetto() == null) {
                    this.errori.add("Tipo dell'erogatore di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (asscsc.getNomeSoggetto() == null) {
                    this.errori.add("Nome dell'erogatore di un servizio componente nel " + (String)uriAS + " non definito");
                } else if (!this.existsAccordoServizioParteSpecifica(asscsc.getTipo(), asscsc.getNome(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto())) {
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", non corrisponde a nessun servizio registrato");
                }
                if (asscsc.getAzione() == null) continue;
                AccordoServizioParteSpecifica serv = this.getAccordoServizioParteSpecifica(asscsc.getTipo(), asscsc.getNome(), asscsc.getTipoSoggetto(), asscsc.getNomeSoggetto());
                if (this.existsAccordoServizioParteComune(serv.getAccordoServizioParteComune())) {
                    AccordoServizioParteComune asServizioComposto = this.getAccordoServizioParteComune(serv.getAccordoServizioParteComune());
                    if (serv.getPortType() != null) {
                        if (this.existsPortType_AccordoServizioParteComune(asServizioComposto, serv.getPortType())) {
                            PortType pt = this.getPortType_AccordoServizioParteComune(asServizioComposto, serv.getPortType());
                            if (this.existsAzione_PortType_AccordoServizio(pt, asscsc.getAzione())) continue;
                            this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizioParteComune() + "] implementato dal servizio componente (istanziato per il servizio [" + serv.getPortType() + "])");
                            continue;
                        }
                        this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizioParteComune() + "] che e' istanziato per uno specifico servizio [" + serv.getPortType() + "] che non risulta registrato");
                        continue;
                    }
                    if (this.existsAzione_AccordoServizioParteComune(asServizioComposto, asscsc.getAzione())) continue;
                    this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", utilizza un'azione [" + asscsc.getAzione() + "] che non risulta definita nell'accordo di servizio [" + serv.getAccordoServizioParteComune() + "] implementato dal servizio componente");
                    continue;
                }
                this.errori.add("Il servizio componente [" + asscsc.getTipo() + "/" + asscsc.getNome() + "] erogato dal soggetto [" + asscsc.getTipoSoggetto() + "/" + asscsc.getNomeSoggetto() + "], referenziato nel " + (String)uriAS + ", implementa un accordo di servizio [" + serv.getAccordoServizioParteComune() + "] che non risulta registrato");
            }
            for (i = 0; i < assc.sizeSpecificaCoordinamentoList(); ++i) {
                Documento specificaCoordinamento = assc.getSpecificaCoordinamento(i);
                this.validateDocumento(specificaCoordinamento, RuoliDocumento.specificaCoordinamento, (String)uriAS);
            }
            if (assc.getAccordoCooperazione() == null) {
                this.errori.add("Nome dell'accordo di cooperazione implementato nel " + (String)uriAS + " non definito");
            } else if (!this.existsAccordoCooperazione(assc.getAccordoCooperazione())) {
                this.errori.add("L'accordo di cooperazione [" + assc.getAccordoCooperazione() + "] referenziato nel " + (String)uriAS + " non corrisponde a nessuno degli accordi di cooperazione registrati");
            }
        }
        for (j = 0; j < as.sizeAzioneList(); ++j) {
            String correlata;
            Azione az = as.getAzione(j);
            if (az.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un'azione nel " + (String)uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch(az.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome dell'azione [" + az.getNome() + "] nel " + (String)uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione [" + az.getNome() + "] nel " + (String)uriAS + " :" + e.getMessage(), e);
            }
            int numAz = 0;
            for (int k = 0; k < as.sizeAzioneList(); ++k) {
                Azione tmpAz = as.getAzione(k);
                if (!az.getNome().equals(tmpAz.getNome())) continue;
                ++numAz;
            }
            if (numAz > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + az.getNome() + " nel " + (String)uriAS);
            }
            if ((correlata = az.getCorrelata()) != null && !this.existsAzione_AccordoServizioParteComune(as, correlata)) {
                this.errori.add("L'azione [" + correlata + "] correlata all'azione " + az.getNome() + " nel " + (String)uriAS + " non corrisponde a nessuna delle azioni registrate");
            }
            if (!((profColl = az.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                this.errori.add("Il profilo di collaborazione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + CostantiRegistroServizi.ONEWAY + ", " + CostantiRegistroServizi.SINCRONO + ", " + CostantiRegistroServizi.ASINCRONO_SIMMETRICO + " o " + CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
            }
            if ((filtroDup = az.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("Il filtro duplicati dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((confRic2 = az.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La conferma ricezione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((idColl2 = az.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("L'id collaborazione dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((consOrd2 = az.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La consegna in ordine dell'azione " + az.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if (az.getScadenza() == null) continue;
            try {
                Integer.parseInt(az.getScadenza());
                continue;
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza dell'azione " + az.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
            }
        }
        for (j = 0; j < as.sizePortTypeList(); ++j) {
            BindingStyle style;
            PortType pt = as.getPortType(j);
            if (pt.getNome() == null) {
                this.errori.add("Non \u00e8 stato definito il nome di un servizio nel " + (String)uriAS);
                continue;
            }
            try {
                if (!RegularExpressionEngine.isMatch(pt.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                    this.errori.add("Il nome del servizio [" + pt.getNome() + "] nel " + (String)uriAS + " non e' valido; puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del servizio [" + pt.getNome() + "] nel " + (String)uriAS + " :" + e.getMessage(), e);
            }
            int numPt = 0;
            for (int k = 0; k < as.sizePortTypeList(); ++k) {
                PortType tmpPt = as.getPortType(k);
                if (!pt.getNome().equals(tmpPt.getNome())) continue;
                ++numPt;
            }
            if (numPt > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un port-type con nome " + pt.getNome() + " nel " + (String)uriAS);
            }
            if ((style = pt.getStyle()) != null && !style.equals(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) && !style.equals(CostantiRegistroServizi.WSDL_STYLE_RPC)) {
                this.errori.add("Lo style del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.WSDL_STYLE_DOCUMENT + " o " + CostantiRegistroServizi.WSDL_STYLE_RPC);
            }
            if (!((profColl = pt.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                this.errori.add("Il profilo di collaborazione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + CostantiRegistroServizi.ONEWAY + ", " + CostantiRegistroServizi.SINCRONO + ", " + CostantiRegistroServizi.ASINCRONO_SIMMETRICO + " o " + CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
            }
            if ((filtroDup = pt.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("Il filtro duplicati del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((confRic2 = pt.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La conferma ricezione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((idColl2 = pt.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("L'id collaborazione del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((consOrd2 = pt.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La consegna in ordine del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if (pt.getScadenza() != null) {
                try {
                    Integer.parseInt(pt.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
                }
            }
            for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                Message mo;
                Message mi;
                Operation op = pt.getAzione(k);
                if (op.getNome() == null) {
                    this.errori.add("Non \u00e8 stato definito il nome di un'azione del servizio " + pt.getNome() + " nel " + (String)uriAS);
                    continue;
                }
                try {
                    if (!RegularExpressionEngine.isMatch(op.getNome(), "^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                        this.errori.add("Il nome dell'azione " + op.getNome() + " nel " + (String)uriAS + " puo' iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome dell'azione " + op.getNome() + " nel " + (String)uriAS + " :" + e.getMessage(), e);
                }
                int numOp = 0;
                for (int h = 0; h < pt.sizeAzioneList(); ++h) {
                    Operation tmpOp = pt.getAzione(h);
                    if (!op.getNome().equals(tmpOp.getNome())) continue;
                    ++numOp;
                }
                if (numOp > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + op.getNome() + " nel " + (String)uriAS);
                }
                String correlata = op.getCorrelata();
                String correlataServizio = op.getCorrelataServizio();
                if (correlata != null && correlataServizio != null) {
                    PortType ptCorrelata;
                    if (!this.existsPortType_AccordoServizioParteComune(as, correlataServizio)) {
                        this.errori.add("Il servizio [" + correlataServizio + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuno dei servizi registrati nel " + (String)uriAS);
                    }
                    if (!this.existsAzione_PortType_AccordoServizio(ptCorrelata = this.getPortType_AccordoServizioParteComune(as, correlataServizio), correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel servizio correlato [" + correlataServizio + "] nel " + (String)uriAS);
                    }
                } else if (correlata != null) {
                    if (!this.existsAzione_PortType_AccordoServizio(pt, correlata)) {
                        this.errori.add("L'azione [" + correlata + "] correlata all'azione " + op.getNome() + " nel servizio " + pt.getNome() + " non corrisponde a nessuna delle azioni registrate nel " + (String)uriAS);
                    }
                } else if (correlataServizio != null) {
                    this.errori.add("L'azione " + op.getNome() + " nel servizio " + pt.getNome() + " del " + (String)uriAS + " contiene una correlazione verso un altro servizio [" + correlataServizio + "] senza pero' aver definito l'azione correlata");
                }
                style = op.getStyle();
                if (style != null && !style.equals(CostantiRegistroServizi.WSDL_STYLE_DOCUMENT) && !style.equals(CostantiRegistroServizi.WSDL_STYLE_RPC)) {
                    this.errori.add("Lo style dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.WSDL_STYLE_DOCUMENT + " o " + CostantiRegistroServizi.WSDL_STYLE_RPC);
                }
                if (!((profColl = op.getProfiloCollaborazione()) == null || profColl.equals(CostantiRegistroServizi.ONEWAY) || profColl.equals(CostantiRegistroServizi.SINCRONO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
                    this.errori.add("Il profilo di collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere un profilo " + CostantiRegistroServizi.ONEWAY + ", " + CostantiRegistroServizi.SINCRONO + ", " + CostantiRegistroServizi.ASINCRONO_SIMMETRICO + " o " + CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
                }
                if ((filtroDup = op.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("Il filtro duplicati dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
                }
                if ((confRic2 = op.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("La conferma ricezione del dell'azione " + op.getNome() + " servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
                }
                if ((idColl2 = op.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("L'id collaborazione dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
                }
                if ((consOrd2 = op.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                    this.errori.add("La consegna in ordine ddell'azione " + op.getNome() + " el servizio " + pt.getNome() + " nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
                }
                if (op.getScadenza() != null) {
                    try {
                        Integer.parseInt(op.getScadenza());
                    }
                    catch (Exception e) {
                        this.errori.add("Il valore associato alla scadenza dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere un numero intero");
                    }
                }
                if ((mi = op.getMessageInput()) != null) {
                    BindingUse useI = mi.getUse();
                    if (useI != null && !useI.equals(CostantiRegistroServizi.WSDL_USE_LITERAL) && !useI.equals(CostantiRegistroServizi.WSDL_USE_ENCODED)) {
                        this.errori.add("L'uso del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere " + CostantiRegistroServizi.WSDL_USE_ENCODED + " o " + CostantiRegistroServizi.WSDL_USE_LITERAL);
                    }
                    for (int l = 0; l < mi.sizePartList(); ++l) {
                        MessagePart part = mi.getPart(l);
                        if (part.getName() == null) {
                            this.errori.add("Non \u00e8 stato definito il name del message-input dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS);
                        }
                        if (part.getElementName() != null && part.getTypeName() != null) {
                            this.errori.add("Nella definizione del message-input sono stati definiti sia parametri di tipologia 'element' che parametri di tipologia 'type', solo una delle due tipologie \u00e8 ammessa (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                            continue;
                        }
                        if (part.getElementName() == null && part.getTypeName() == null) {
                            this.errori.add("Nella definizione del message-input non sono stati definiti ne parametri di tipologia 'element' che parametri di tipologia 'type' (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                            continue;
                        }
                        if (part.getElementName() != null && part.getElementNamespace() == null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'element' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getElementName() == null && part.getElementNamespace() != null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'element' che non presenta la definizione dell'element name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getTypeName() != null && part.getTypeNamespace() == null) {
                            this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'type' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        }
                        if (part.getTypeName() != null || part.getTypeNamespace() == null) continue;
                        this.errori.add("Nella definizione del message-input \u00e8 stata definita una tipologia 'type' che non presenta la definizione del type name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                }
                if ((mo = op.getMessageOutput()) == null) continue;
                BindingUse useO = mo.getUse();
                if (useO != null && !useO.equals(CostantiRegistroServizi.WSDL_USE_LITERAL) && !useO.equals(CostantiRegistroServizi.WSDL_USE_ENCODED)) {
                    this.errori.add("L'uso del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + " dev'essere " + CostantiRegistroServizi.WSDL_USE_ENCODED + " o " + CostantiRegistroServizi.WSDL_USE_LITERAL);
                }
                for (int l = 0; l < mo.sizePartList(); ++l) {
                    MessagePart part = mo.getPart(l);
                    if (part.getName() == null) {
                        this.errori.add("Non \u00e8 stato definito il name del message-output dell'azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS);
                    }
                    if (part.getElementName() != null && part.getTypeName() != null) {
                        this.errori.add("Nella definizione del message-output sono stati definiti sia parametri di tipologia 'element' che parametri di tipologia 'type', solo una delle due tipologie \u00e8 ammessa (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        continue;
                    }
                    if (part.getElementName() == null && part.getTypeName() == null) {
                        this.errori.add("Nella definizione del message-output non sono stati definiti ne parametri di tipologia 'element' che parametri di tipologia 'type' (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                        continue;
                    }
                    if (part.getElementName() != null && part.getElementNamespace() == null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'element' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getElementName() == null && part.getElementNamespace() != null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'element' che non presenta la definizione dell'element name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getTypeName() != null && part.getTypeNamespace() == null) {
                        this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'type' che non presenta la definizione del namespace (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                    }
                    if (part.getTypeName() != null || part.getTypeNamespace() == null) continue;
                    this.errori.add("Nella definizione del message-output \u00e8 stata definita una tipologia 'type' che non presenta la definizione del type name (azione " + op.getNome() + " del servizio " + pt.getNome() + " nel " + (String)uriAS + ")");
                }
            }
        }
        for (i = 0; i < as.sizeAllegatoList(); ++i) {
            Documento allegato = as.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, (String)uriAS);
        }
        for (i = 0; i < as.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = as.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, (String)uriAS);
        }
        try {
            if (!RegularExpressionEngine.isMatch(as.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome nel " + (String)uriAS + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome nel " + (String)uriAS + " :" + e.getMessage(), e);
        }
        ProfiloCollaborazione profColl2 = as.getProfiloCollaborazione();
        if (profColl2 == null) {
            this.errori.add("Il profilo di collaborazione nel " + (String)uriAS + " non \u00e8 definito; deve possedere un profilo " + CostantiRegistroServizi.ONEWAY + ", " + CostantiRegistroServizi.SINCRONO + ", " + CostantiRegistroServizi.ASINCRONO_SIMMETRICO + " o " + CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
        } else if (!(profColl2.equals(CostantiRegistroServizi.ONEWAY) || profColl2.equals(CostantiRegistroServizi.SINCRONO) || profColl2.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO) || profColl2.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO))) {
            this.errori.add("Il profilo di collaborazione nel " + (String)uriAS + " deve possedere un profilo " + CostantiRegistroServizi.ONEWAY + ", " + CostantiRegistroServizi.SINCRONO + ", " + CostantiRegistroServizi.ASINCRONO_SIMMETRICO + " o " + CostantiRegistroServizi.ASINCRONO_ASIMMETRICO);
        }
        StatoFunzionalita filtroDup2 = as.getFiltroDuplicati();
        if (filtroDup2 != null && !filtroDup2.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup2.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("Il filtro duplicati nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((confRic = as.getConfermaRicezione()) != null && !confRic.equals(CostantiRegistroServizi.ABILITATO) && !confRic.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La conferma ricezione nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((idColl = as.getIdCollaborazione()) != null && idColl != null && !idColl.equals(CostantiRegistroServizi.ABILITATO) && !idColl.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("L'id collaborazione nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((consOrd = as.getConsegnaInOrdine()) != null && consOrd != null && !consOrd.equals(CostantiRegistroServizi.ABILITATO) && !consOrd.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La consegna in ordine nel " + (String)uriAS + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if (as.getScadenza() != null) {
            try {
                Integer.parseInt(as.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza nel " + (String)uriAS + " dev'essere un numero intero");
            }
        }
        if (as.getWsdlConcettuale() != null) {
            try {
                RegExpUtilities.validateUri(as.getWsdlConcettuale(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl concettuale nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlDefinitorio() != null) {
            try {
                RegExpUtilities.validateUri(as.getWsdlDefinitorio(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl definitorio nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoErogatore() != null) {
            try {
                RegExpUtilities.validateUri(as.getWsdlLogicoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico erogatore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getWsdlLogicoFruitore() != null) {
            try {
                RegExpUtilities.validateUri(as.getWsdlLogicoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico fruitore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneConcettuale() != null) {
            try {
                RegExpUtilities.validateUri(as.getSpecificaConversazioneConcettuale(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl concettuale nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneErogatore() != null) {
            try {
                RegExpUtilities.validateUri(as.getSpecificaConversazioneErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl definitorio nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (as.getSpecificaConversazioneFruitore() != null) {
            try {
                RegExpUtilities.validateUri(as.getSpecificaConversazioneFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl logico erogatore nel " + (String)uriAS + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (!as.getUtilizzoSenzaAzione() && as.sizeAzioneList() == 0 && as.sizePortTypeList() == 0) {
            this.errori.add("Il " + (String)uriAS + " non prevede l'utilizzo senza azioni, quindi dev'essere definita almeno un'azione o almeno un servizio (con relative azioni)");
        }
        if (as.getVersione() != null) {
            try {
                if (!RegularExpressionEngine.isMatch(as.getVersione(), "^[1-9]+[0-9]*$")) {
                    this.errori.add("La versione nel " + (String)uriAS + " dev'essere rappresentata da un numero intero");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione nel " + (String)uriAS + " :" + e.getMessage(), e);
            }
        }
        int numAs = 0;
        for (int j2 = 0; j2 < this.registro.sizeAccordoServizioParteComuneList(); ++j2) {
            AccordoServizioParteComune tmpAs = this.registro.getAccordoServizioParteComune(j2);
            if (!this.idAccordoFactory.getUriFromAccordo(tmpAs).equals(this.idAccordoFactory.getUriFromAccordo(as))) continue;
            ++numAs;
        }
        if (numAs > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un accordo di servizio (o servizio composto) con nome " + this.idAccordoFactory.getUriFromAccordo(as));
        }
    }

    private void validaSoggetto(Soggetto sogg, boolean showIDOggettiAnalizzati) throws DriverRegistroServiziException {
        if (sogg.getNome() == null) {
            this.errori.add("Esiste un soggetto senza nome");
            return;
        }
        if (sogg.getTipo() == null) {
            this.errori.add("Esiste un soggetto senza tipo");
            return;
        }
        Connettore conn = sogg.getConnettore();
        if (conn != null) {
            this.validaConnettore(conn, "soggetto", sogg.getTipo() + "/" + sogg.getNome());
        }
        for (int j = 0; j < sogg.sizeAccordoServizioParteSpecificaList(); ++j) {
            AccordoServizioParteSpecifica serv = sogg.getAccordoServizioParteSpecifica(j);
            if (showIDOggettiAnalizzati) {
                this.printMsg("\tServizio: " + sogg.getTipo() + "/" + sogg.getNome() + "_" + serv.getServizio().getTipo() + "/" + serv.getServizio().getNome());
            }
            this.validaAccordoServizioParteSpecifica(serv, sogg);
        }
        if (!this.tipoSoggetti.contains(sogg.getTipo())) {
            this.errori.add("Il tipo del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non \u00e8 valido (Tipi utilizzabili: " + this.getTipoSoggetti() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(sogg.getNome(), "^[0-9A-Za-z]+$")) {
                this.errori.add("Il nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo caratteri e cifre");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " :" + e.getMessage(), e);
        }
        int numS = 0;
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto tmpSogg = this.registro.getSoggetto(j);
            if (!sogg.getNome().equals(tmpSogg.getNome()) || !sogg.getTipo().equals(tmpSogg.getTipo())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un soggetto con nome " + sogg.getNome() + " e tipo " + sogg.getTipo());
        }
        if (sogg.getPortaDominio() != null && !this.existsPortaDominio(sogg.getPortaDominio())) {
            this.errori.add("La porta di dominio [" + sogg.getPortaDominio() + "] del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " non corrisponde a nessuna delle porte di dominio registrate");
        }
        if (sogg.getCredenziali() != null) {
            this.validaCredenziale(sogg.getCredenziali(), "soggetto " + sogg.getTipo() + "/" + sogg.getNome());
        }
        if (sogg.getRuoli() != null) {
            int i;
            for (i = 0; i < sogg.getRuoli().sizeRuoloList(); ++i) {
                String nomeRuolo = sogg.getRuoli().getRuolo(i).getNome();
                try {
                    if (RegularExpressionEngine.isMatch(nomeRuolo, "^[0-9A-Za-z_]+$")) continue;
                    this.errori.add("Il ruolo [" + nomeRuolo + "] del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " dev'essere formato solo da caratteri, cifre e '_'");
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del ruolo " + nomeRuolo + " del soggetto " + sogg.getTipo() + "/" + sogg.getNome() + " :" + e.getMessage(), e);
                }
            }
            for (i = 0; i < sogg.getRuoli().sizeRuoloList(); ++i) {
                int numRuolo = 0;
                String tmpRuolo = sogg.getRuoli().getRuolo(i).getNome();
                for (int j = 0; j < sogg.getRuoli().sizeRuoloList(); ++j) {
                    String checkRuolo = sogg.getRuoli().getRuolo(j).getNome();
                    if (!checkRuolo.equals(tmpRuolo)) continue;
                    ++numRuolo;
                }
                if (numRuolo <= true) continue;
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + tmpRuolo + ". Trovate " + numRuolo + " occorrenze nel soggetto " + sogg.getTipo() + "/" + sogg.getNome());
            }
        }
    }

    private void validaCredenziale(CredenzialiSoggetto c, String oggetto) throws DriverRegistroServiziException {
        CredenzialeTipo tipo = CredenzialeTipo.SSL;
        if (c.getTipo() != null) {
            tipo = c.getTipo();
        }
        if (!(tipo.equals(CredenzialeTipo.BASIC) || tipo.equals(CredenzialeTipo.SSL) || tipo.equals(CredenzialeTipo.PRINCIPAL))) {
            this.errori.add("Il tipo delle credenziali del " + oggetto + " deve possedere i valori: " + CredenzialeTipo.BASIC.toString() + " o " + CredenzialeTipo.SSL.toString() + " o " + CredenzialeTipo.PRINCIPAL.toString());
        }
        if (c.getTipo().equals(CredenzialeTipo.BASIC) && (c.getUser() == null || c.getUser().equals("") || c.getPassword() == null || c.getPassword().equals(""))) {
            this.errori.add("Le credenziali di tipo basic del " + oggetto + " devono avere username e password valorizzati");
        }
        if (c.getTipo().equals(CredenzialeTipo.SSL)) {
            if (c.getSubject() == null || c.getSubject().equals("")) {
                this.errori.add("Le credenziali di tipo ssl del " + oggetto + " devono avere subject valorizzato");
            } else {
                try {
                    Utilities.validaSubject(c.getSubject());
                }
                catch (Exception e) {
                    this.errori.add("Le credenziali di tipo ssl del " + oggetto + " possiedono un subject non valido: " + e.getMessage());
                }
            }
        }
        if (c.getTipo().equals(CredenzialeTipo.PRINCIPAL) && (c.getUser() == null || c.getUser().equals(""))) {
            this.errori.add("Le credenziali di tipo principal del " + oggetto + " devono avere user valorizzato");
        }
    }

    private void validaAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps, Soggetto sogg) throws DriverRegistroServiziException {
        StatoFunzionalita consOrd;
        StatoFunzionalita idColl;
        StatoFunzionalita confRic;
        StatoFunzionalita filtroDup;
        int i;
        int k;
        if (asps.getNome() == null) {
            this.errori.add("Non e' stato fornito un nome per l'accordo di servizio parte specifica");
            return;
        }
        if (asps.getVersione() != null) {
            try {
                if (!RegularExpressionEngine.isMatch(asps.getVersione(), "^[1-9]+[0-9]*$")) {
                    this.errori.add("La versione nell'accordo di servizio parte specifica [" + asps.getNome() + "] dev'essere rappresentata da un numero intero");
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare della versione nell'accordo di servizio parte specifica [" + asps.getNome() + "] :" + e.getMessage(), e);
            }
        }
        if (asps.getServizio() == null) {
            this.errori.add("Esiste un accordo di servizio parte specifica senza servizio");
            return;
        }
        if (asps.getServizio().getNome() == null) {
            this.errori.add("Esiste un servizio senza nome");
            return;
        }
        if (asps.getServizio().getTipo() == null) {
            this.errori.add("Esiste un servizio senza tipo");
            return;
        }
        Servizio serv = asps.getServizio();
        String idServizio = sogg.getTipo() + "/" + sogg.getNome() + "_" + serv.getTipo() + "/" + serv.getNome();
        Connettore conn = serv.getConnettore();
        if (conn != null) {
            this.validaConnettore(conn, "servizio", serv.getTipo() + "/" + serv.getNome());
        } else if (sogg.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(sogg.getConnettore().getTipo())) {
            this.errori.add("Il servizio [" + idServizio + "] deve obbligatoriamente definire un connettore, poiche' il soggetto erogatore non ne possiede uno");
        }
        for (k = 0; k < serv.sizeParametriAzioneList(); ++k) {
            ServizioAzione az = serv.getParametriAzione(k);
            if (az.getNome() == null) {
                this.errori.add("Esiste un'azione del servizio " + idServizio + " per cui non \u00e8 definito il nome");
                continue;
            }
            int numA = 0;
            for (int h = 0; h < serv.sizeParametriAzioneList(); ++h) {
                ServizioAzione tmpSsa = serv.getParametriAzione(h);
                if (!az.getNome().equals(tmpSsa.getNome())) continue;
                ++numA;
            }
            if (numA > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un'azione con nome " + az.getNome() + " nel servizio " + idServizio);
            }
            if (this.existsAccordoServizioParteComune(asps.getAccordoServizioParteComune())) {
                AccordoServizioParteComune as = this.getAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                if (asps.getPortType() != null) {
                    PortType pt;
                    if (this.existsPortType_AccordoServizioParteComune(as, asps.getPortType()) && !this.existsAzione_PortType_AccordoServizio(pt = this.getPortType_AccordoServizioParteComune(as, asps.getPortType()), az.getNome())) {
                        this.errori.add("Il servizio [" + idServizio + "], utilizza un'azione [" + az.getNome() + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio (istanziato per il servizio [" + asps.getPortType() + "])");
                    }
                } else if (!this.existsAzione_AccordoServizioParteComune(as, az.getNome())) {
                    this.errori.add("Il servizio [" + idServizio + "], utilizza un'azione [" + az.getNome() + "] che non risulta definita nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "] implementato dal servizio");
                }
            }
            if ((az.getConnettore() == null || CostantiRegistroServizi.DISABILITATO.equals(az.getConnettore().getTipo())) && az.sizeParametriFruitoreList() == 0) {
                this.errori.add("Non pu\u00f2 esistere un'azione con nome " + az.getNome() + " nel servizio " + idServizio + " che non definisce ne al suo interno un connettore, ne una lista di fruitori");
            }
            if ((conn = az.getConnettore()) != null) {
                this.validaConnettore(conn, "Azione [" + az.getNome() + "] ridefinita nel Servizio", idServizio);
            }
            for (int w = 0; w < az.sizeParametriFruitoreList(); ++w) {
                ServizioAzioneFruitore ssaf = az.getParametriFruitore(w);
                String tipoSsaf = ssaf.getTipo();
                String nomeSsaf = ssaf.getNome();
                if (tipoSsaf == null) {
                    this.errori.add("Esiste un fruitore dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " per cui non \u00e8 definito il tipo");
                    continue;
                }
                if (nomeSsaf == null) {
                    this.errori.add("Esiste un fruitore dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " per cui non \u00e8 definito il nome");
                    continue;
                }
                if (!this.existsSoggetto(tipoSsaf, nomeSsaf)) {
                    this.errori.add("Il fruitore " + tipoSsaf + "/" + nomeSsaf + " dell'azione " + az.getNome() + " del servizio " + serv.getTipo() + "/" + serv.getNome() + " non corrisponde a nessuno dei soggetti registrati");
                }
                if ((conn = ssaf.getConnettore()) != null) {
                    this.validaConnettore(conn, "", idServizio);
                    continue;
                }
                this.errori.add("Non e' stato definito il connettore per il Fruitore [" + tipoSsaf + "/" + nomeSsaf + "] dell'azione [" + az.getNome() + "] ridefinita nel Servizio " + idServizio);
            }
        }
        for (k = 0; k < asps.sizeFruitoreList(); ++k) {
            StatoFunzionalita clA;
            StatoFunzionalita consOrd2;
            StatoFunzionalita idColl2;
            StatoFunzionalita confRic2;
            StatoFunzionalita filtroDup2;
            Fruitore fru = asps.getFruitore(k);
            if (fru.getTipo() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + idServizio + "] per cui non \u00e8 definito il tipo");
                continue;
            }
            if (fru.getNome() == null) {
                this.errori.add("Esiste un fruitore del servizio [" + idServizio + "] per cui non \u00e8 definito il nome");
                continue;
            }
            if (!this.existsSoggetto(fru.getTipo(), fru.getNome())) {
                this.errori.add("Il fruitore " + fru.getTipo() + "/" + fru.getNome() + " del servizio " + idServizio + " non corrisponde a nessuno dei soggetti registrati");
            }
            int numF = 0;
            for (int h = 0; h < asps.sizeFruitoreList(); ++h) {
                Fruitore tmpF = asps.getFruitore(h);
                if (!fru.getNome().equals(tmpF.getNome()) || !fru.getTipo().equals(tmpF.getTipo())) continue;
                ++numF;
            }
            if (numF > 1) {
                this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un fruitore con nome " + fru.getNome() + " e tipo " + fru.getTipo() + " per il servizio " + idServizio);
            }
            if ((conn = fru.getConnettore()) != null) {
                this.validaConnettore(conn, "fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio", idServizio);
            }
            if (fru.getWsdlImplementativoErogatore() != null) {
                try {
                    RegExpUtilities.validateUri(fru.getWsdlImplementativoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
                }
                catch (Exception e) {
                    this.errori.add("Il wsdl implementativo erogatore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
                }
            }
            if (fru.getWsdlImplementativoFruitore() != null) {
                try {
                    RegExpUtilities.validateUri(fru.getWsdlImplementativoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
                }
                catch (Exception e) {
                    this.errori.add("Il wsdl implementativo fruitore del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
                }
            }
            if ((filtroDup2 = fru.getFiltroDuplicati()) != null && !filtroDup2.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("Il filtro duplicati del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((confRic2 = fru.getConfermaRicezione()) != null && !confRic2.equals(CostantiRegistroServizi.ABILITATO) && !confRic2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La conferma ricezione del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((idColl2 = fru.getIdCollaborazione()) != null && !idColl2.equals(CostantiRegistroServizi.ABILITATO) && !idColl2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("L'id collaborazione del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if ((consOrd2 = fru.getConsegnaInOrdine()) != null && !consOrd2.equals(CostantiRegistroServizi.ABILITATO) && !consOrd2.equals(CostantiRegistroServizi.DISABILITATO)) {
                this.errori.add("La consegna in ordine del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
            }
            if (fru.getScadenza() != null) {
                try {
                    Integer.parseInt(fru.getScadenza());
                }
                catch (Exception e) {
                    this.errori.add("Il valore associato alla scadenza del fruitore [" + fru.getTipo() + "/" + fru.getNome() + "] nel servizio " + idServizio + " dev'essere un numero intero");
                }
            }
            if ((clA = fru.getClientAuth()) == null || clA.equals(CostantiRegistroServizi.ABILITATO) || clA.equals(CostantiRegistroServizi.DISABILITATO) || clA.equals("default")) continue;
            this.errori.add("Il client-auth del fruitore " + fru.getTipo() + "/" + fru.getNome() + " nel servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + "," + CostantiRegistroServizi.DISABILITATO + " o default");
        }
        for (i = 0; i < asps.sizeAllegatoList(); ++i) {
            Documento allegato = asps.getAllegato(i);
            this.validateDocumento(allegato, RuoliDocumento.allegato, "Servizio[" + idServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
            Documento specificaSemiformale = asps.getSpecificaSemiformale(i);
            this.validateDocumento(specificaSemiformale, RuoliDocumento.specificaSemiformale, "Servizio[" + idServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
            Documento specificaLivelloServizio = asps.getSpecificaLivelloServizio(i);
            this.validateDocumento(specificaLivelloServizio, RuoliDocumento.specificaLivelloServizio, "Servizio[" + idServizio + "]");
        }
        for (i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
            Documento specificaSicurezza = asps.getSpecificaSicurezza(i);
            this.validateDocumento(specificaSicurezza, RuoliDocumento.specificaSicurezza, "Servizio[" + idServizio + "]");
        }
        if (!this.tipoServizi.contains(serv.getTipo())) {
            this.errori.add("Il tipo del servizio " + serv.getTipo() + "/" + serv.getNome() + " non \u00e8 valido (tipi utilizzabili: " + this.getTipoServizi() + ")");
        }
        try {
            if (!RegularExpressionEngine.isMatch(serv.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome del servizio " + serv.getTipo() + "/" + serv.getNome() + " dev'essere formato solo caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del servizio " + serv.getTipo() + "/" + serv.getNome() + " :" + e.getMessage(), e);
        }
        if (asps.getAccordoServizioParteComune() == null) {
            this.errori.add("Il Servizio " + idServizio + " non implementa un accordo di servizio");
        } else if (!this.existsAccordoServizioParteComune(asps.getAccordoServizioParteComune())) {
            this.errori.add("L'accordo servizio " + asps.getAccordoServizioParteComune() + " del servizio " + idServizio + " non corrisponde a nessuno degli accordi servizio registrati");
        } else {
            AccordoServizioParteComune as;
            String nomePT = asps.getPortType();
            if (nomePT != null && !this.existsPortType_AccordoServizioParteComune(as = this.getAccordoServizioParteComune(asps.getAccordoServizioParteComune()), nomePT)) {
                this.errori.add("Il servizio " + nomePT + " del servizio " + idServizio + " non corrisponde a nessuno dei servizi dell'accordo servizio implementato [" + asps.getAccordoServizioParteComune() + "]");
            }
        }
        int numS = 0;
        for (int j = 0; j < sogg.sizeAccordoServizioParteSpecificaList(); ++j) {
            AccordoServizioParteSpecifica tmpS = sogg.getAccordoServizioParteSpecifica(j);
            if (!serv.getNome().equals(tmpS.getServizio().getNome()) || !serv.getTipo().equals(tmpS.getServizio().getTipo()) || (serv.getNomeSoggettoErogatore() != null || tmpS.getServizio().getNomeSoggettoErogatore() != null) && !serv.getNomeSoggettoErogatore().equals(tmpS.getServizio().getNomeSoggettoErogatore()) || (serv.getTipoSoggettoErogatore() != null || tmpS.getServizio().getTipoSoggettoErogatore() != null) && !serv.getTipoSoggettoErogatore().equals(tmpS.getServizio().getTipoSoggettoErogatore())) continue;
            ++numS;
        }
        if (numS > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un servizio con nome " + serv.getNome() + " e tipo " + serv.getTipo() + " e nome soggetto erogatore " + serv.getNomeSoggettoErogatore() + " e tipo soggetto erogatore " + serv.getTipoSoggettoErogatore());
        }
        if (asps.getWsdlImplementativoErogatore() != null) {
            try {
                RegExpUtilities.validateUri(asps.getWsdlImplementativoErogatore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo erogatore del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if (asps.getWsdlImplementativoFruitore() != null) {
            try {
                RegExpUtilities.validateUri(asps.getWsdlImplementativoFruitore(), this.checkEsistenzaFileDefinitoTramiteURI);
            }
            catch (Exception e) {
                this.errori.add("Il wsdl implementativo fruitore del servizio " + idServizio + " non \u00e8 valido: " + e.getMessage());
            }
        }
        if ((filtroDup = asps.getFiltroDuplicati()) != null && !filtroDup.equals(CostantiRegistroServizi.ABILITATO) && !filtroDup.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("Il filtro duplicati del servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((confRic = asps.getConfermaRicezione()) != null && !confRic.equals(CostantiRegistroServizi.ABILITATO) && !confRic.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La conferma ricezione del servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((idColl = asps.getIdCollaborazione()) != null && !idColl.equals(CostantiRegistroServizi.ABILITATO) && !idColl.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("L'id collaborazione del servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if ((consOrd = asps.getConsegnaInOrdine()) != null && !consOrd.equals(CostantiRegistroServizi.ABILITATO) && !consOrd.equals(CostantiRegistroServizi.DISABILITATO)) {
            this.errori.add("La consegna in ordine del servizio " + idServizio + " deve possedere il valore " + CostantiRegistroServizi.ABILITATO + " o " + CostantiRegistroServizi.DISABILITATO);
        }
        if (asps.getScadenza() != null) {
            try {
                Integer.parseInt(asps.getScadenza());
            }
            catch (Exception e) {
                this.errori.add("Il valore associato alla scadenza del servizio " + idServizio + " dev'essere un numero intero");
            }
        }
    }

    private void validaPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd.getNome() == null) {
            this.errori.add("Esiste una porta di dominio senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch(pdd.getNome(), "^[0-9A-Za-z_\\-\\.]+$")) {
                this.errori.add("Il nome della porta di dominio dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome della porta di dominio :" + e.getMessage(), e);
        }
        StatoFunzionalita clA = pdd.getClientAuth();
        if (clA != null && !clA.equals("abilitato") && !clA.equals("disabilitato")) {
            this.errori.add("Il client-auth della porta di dominio " + pdd.getNome() + " dev'essere abilitato o disabilitato");
        }
        if (pdd.getClientAuth() != null && pdd.getClientAuth().equals("abilitato") && (pdd.getSubject() == null || pdd.getSubject().equals(""))) {
            this.errori.add("Il subject della porta di dominio " + pdd.getNome() + " dev'essere fornito quando client-auth \u00e8 abilitato");
        }
        int numPd = 0;
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio tmpPd = this.registro.getPortaDominio(j);
            if (!pdd.getNome().equals(tmpPd.getNome())) continue;
            ++numPd;
        }
        if (numPd > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di una porta di dominio con nome " + pdd.getNome());
        }
    }

    private void validaRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo.getNome() == null) {
            this.errori.add("Esiste un ruolo senza nome");
            return;
        }
        try {
            if (!RegularExpressionEngine.isMatch(ruolo.getNome(), "^[0-9A-Za-z_]+$")) {
                this.errori.add("Il nome del ruolo dev'essere formato solo da caratteri, cifre e '_'");
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante l'analisi tramite espressione regolare del nome del ruolo :" + e.getMessage(), e);
        }
        int numRuolo = 0;
        for (int j = 0; j < this.registro.sizeRuoloList(); ++j) {
            Ruolo tmpRuolo = this.registro.getRuolo(j);
            if (!ruolo.getNome().equals(tmpRuolo.getNome())) continue;
            ++numRuolo;
        }
        if (numRuolo > 1) {
            this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un ruolo con nome " + ruolo.getNome());
        }
    }

    private void validaConnettore(Connettore conn, String oggetto, String tipoEnomeOggetto) throws DriverRegistroServiziException {
        block116: {
            int j;
            int j2;
            String nomeConn = conn.getNome();
            String tipoConn = conn.getTipo();
            if (nomeConn == null) {
                if (oggetto == null) {
                    this.errori.add("Esiste un connettore nella radice del registro per cui non \u00e8 definito il nome");
                } else {
                    this.errori.add("Esiste un connettore del " + oggetto + " " + tipoEnomeOggetto + " per cui non \u00e8 definito il nome");
                }
                return;
            }
            if (oggetto == null) {
                int numC = 0;
                for (j2 = 0; j2 < this.registro.sizeConnettoreList(); ++j2) {
                    Connettore tmpC = this.registro.getConnettore(j2);
                    if (!nomeConn.equals(tmpC.getNome())) continue;
                    ++numC;
                }
                if (numC > 1) {
                    this.errori.add("Non pu\u00f2 esistere pi\u00f9 di un connettore con nome " + nomeConn + " definito come elemento radice del registro servizi");
                }
            } else {
                if (tipoConn == null) {
                    conn = null;
                    for (j = 0; j < this.registro.sizeConnettoreList(); ++j) {
                        Connettore connettore = this.registro.getConnettore(j);
                        if (!nomeConn.equals(connettore.getNome())) continue;
                        conn = connettore;
                        break;
                    }
                }
                if (conn == null) {
                    this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non corrisponde a nessuno dei connettori registrati");
                } else {
                    tipoConn = conn.getTipo();
                }
            }
            if (!this.tipoConnettori.contains(tipoConn)) {
                if (oggetto == null) {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + ", definito nella radice del registro, non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                } else {
                    this.errori.add("Il tipo [" + tipoConn + "] del connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " non \u00e8 valido (Tipi conosciuti: " + this.getTipoConnettori() + ")");
                }
            } else {
                for (j = 0; j < conn.sizePropertyList(); ++j) {
                    Property cp = conn.getProperty(j);
                    if (cp.getNome() == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il nome");
                        }
                        return;
                    }
                    if (cp.getValore() != null) continue;
                    if (oggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " possiede una propriet\u00e0 per cui non \u00e8 definito il valore");
                    }
                    return;
                }
                if (tipoConn.equals(TipiConnettore.HTTP.getNome())) {
                    String urlConn = null;
                    for (j2 = 0; j2 < conn.sizePropertyList(); ++j2) {
                        Property cp = conn.getProperty(j2);
                        if (!cp.getNome().equals("location")) continue;
                        urlConn = cp.getValore();
                        break;
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                                break block116;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.JMS.getNome())) {
                    String jmsNome = null;
                    String jmsTipo = null;
                    String jmsConnFact = null;
                    String jmsSendAs = null;
                    for (int j3 = 0; j3 < conn.sizePropertyList(); ++j3) {
                        Property cp = conn.getProperty(j3);
                        if (cp.getNome().equals("location")) {
                            jmsNome = cp.getValore();
                        }
                        if (cp.getNome().equals("tipo")) {
                            jmsTipo = cp.getValore();
                        }
                        if (cp.getNome().equals("connection-factory")) {
                            jmsConnFact = cp.getValore();
                        }
                        if (!cp.getNome().equals("send-as")) continue;
                        jmsSendAs = cp.getValore();
                    }
                    if (jmsNome == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un nome coda/topic definito");
                        }
                    }
                    if (jmsTipo == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic definito");
                        }
                    } else if (!jmsTipo.equals("queue") && !jmsTipo.equals("topic")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo coda/topic valido (valori assumibili sono topic/queue)");
                        }
                    }
                    if (jmsConnFact == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha una connection factory definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha una connection factory definita");
                        }
                    }
                    if (jmsSendAs == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) definito");
                        }
                    } else if (!jmsSendAs.equals("TextMessage") && !jmsSendAs.equals("BytesMessage")) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo jms, ma non ha un tipo di messaggio (sendAs) (valori assumibili sono TextMessage/BytesMessage)");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.HTTPS.getNome())) {
                    String urlConn = null;
                    String trustStoreLocation = null;
                    String trustStorePassword = null;
                    String keyStoreLocation = null;
                    String keyStorePassword = null;
                    String keyPassword = null;
                    String hostNameVerifier = null;
                    for (int j4 = 0; j4 < conn.sizePropertyList(); ++j4) {
                        Property cp = conn.getProperty(j4);
                        if (cp.getNome().equals("location")) {
                            urlConn = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStoreLocation")) {
                            trustStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("trustStorePassword")) {
                            trustStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStoreLocation")) {
                            keyStoreLocation = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyStorePassword")) {
                            keyStorePassword = cp.getValore();
                            continue;
                        }
                        if (cp.getNome().equals("keyPassword")) {
                            keyPassword = cp.getValore();
                            continue;
                        }
                        if (!cp.getNome().equals("hostnameVerifier")) continue;
                        hostNameVerifier = cp.getValore();
                    }
                    if (urlConn == null) {
                        if (oggetto == null) {
                            this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url definita");
                        } else {
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url definita");
                        }
                    } else {
                        try {
                            this.validaUrl(urlConn);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo http, ma non ha una url valida: " + e.getMessage());
                        }
                    }
                    if (trustStoreLocation != null) {
                        File f = new File(trustStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (trustStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un truststore " + trustStoreLocation + " per cui non e' stata specificata una password");
                            }
                        }
                    }
                    if (keyStoreLocation != null) {
                        File f = new File(keyStoreLocation);
                        if (!f.exists()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non esiste");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non esiste");
                            }
                        } else if (!f.isFile()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' un file");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' un file");
                            }
                        } else if (!f.canRead()) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " che non e' accessibile (permessi in lettura non forniti)");
                            }
                        } else if (keyStorePassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password");
                            }
                        } else if (keyPassword == null) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            } else {
                                this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " definisce un keystore " + keyStoreLocation + " per cui non e' stata specificata una password per la chiave privata");
                            }
                        }
                    }
                    if (hostNameVerifier != null) {
                        try {
                            Boolean.parseBoolean(hostNameVerifier);
                        }
                        catch (Exception e) {
                            if (oggetto == null) {
                                this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                                break block116;
                            }
                            this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " associa un valore non valido  alla proprieta' 'hostNameVerifier'; valori utilizzabili: true e false");
                        }
                    }
                } else if (tipoConn.equals(TipiConnettore.DISABILITATO.getNome()) && conn.sizePropertyList() > 0) {
                    if (oggetto == null) {
                        this.errori.add("Il connettore " + nomeConn + ", definito nella radice del registro, \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    } else {
                        this.errori.add("Il connettore " + nomeConn + " del " + oggetto + " " + tipoEnomeOggetto + " \u00e8 di tipo disabilitato, ma ha delle properties definite");
                    }
                }
            }
        }
    }

    private void validateDocumento(Documento doc, RuoliDocumento ruolo, String oggetto) {
        if (doc.getTipo() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il tipo");
            return;
        }
        if (doc.getFile() == null) {
            this.errori.add("Esiste un documento con ruolo (" + ruolo.toString() + ") per l'oggetto " + oggetto + " per cui non \u00e8 definito il file");
            return;
        }
        String idDocumento = "(" + ruolo.toString() + ")(" + doc.getTipo() + ")(" + doc.getFile() + ") ";
        if (!RuoliDocumento.allegato.toString().equals(ruolo.toString())) {
            String[] tipi;
            if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSemiformale.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSemiformale.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica semiformale (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo.toString())) {
                if (TipiDocumentoCoordinamento.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoCoordinamento.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di coordinamento (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo.toString())) {
                if (TipiDocumentoLivelloServizio.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoLivelloServizio.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica dei livelli di servizio (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo.toString())) {
                if (TipiDocumentoSicurezza.toEnumConstant(doc.getTipo()) == null) {
                    tipi = TipiDocumentoSicurezza.toStringArray();
                    StringBuffer bf = new StringBuffer();
                    for (int i = 0; i < tipi.length; ++i) {
                        if (i > 0) {
                            bf.append(",");
                        }
                        bf.append(tipi[i]);
                    }
                    this.errori.add(idDocumento + " tipo non utilizzabile in una specifica di sicurezza (oggetto: " + oggetto + "), valori ammessi: ");
                }
            } else {
                this.errori.add(idDocumento + " ruolo non conosciuto (oggetto: " + oggetto + "): " + ruolo.toString());
            }
        }
        try {
            RegExpUtilities.validateUri(doc.getFile(), this.checkEsistenzaFileDefinitoTramiteURI);
        }
        catch (Exception e) {
            this.errori.add(idDocumento + " file non valido (oggetto: " + oggetto + "): " + e.getMessage());
        }
    }

    private void validaUrl(String url) throws MalformedURLException {
        URL testUrl = new URL(url);
        testUrl.toString();
    }

    private boolean existsAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoCooperazione(uriAccordo) != null;
    }

    private AccordoCooperazione getAccordoCooperazione(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoCooperazioneList(); ++j) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(j);
            if (!this.idAccordoCooperazioneFactory.getUriFromAccordo(ac).equals(uriAccordo)) continue;
            return ac;
        }
        return null;
    }

    private boolean existsAccordoServizioParteComune(String uriAccordo) throws DriverRegistroServiziException {
        return this.getAccordoServizioParteComune(uriAccordo) != null;
    }

    private AccordoServizioParteComune getAccordoServizioParteComune(String uriAccordo) throws DriverRegistroServiziException {
        for (int j = 0; j < this.registro.sizeAccordoServizioParteComuneList(); ++j) {
            AccordoServizioParteComune as = this.registro.getAccordoServizioParteComune(j);
            if (!this.idAccordoFactory.getUriFromAccordo(as).equals(uriAccordo)) continue;
            return as;
        }
        return null;
    }

    private boolean existsAzione_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        return this.getAzione_AccordoServizioParteComune(as, azione) != null;
    }

    private Azione getAzione_AccordoServizioParteComune(AccordoServizioParteComune as, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizeAzioneList(); ++j) {
            Azione az = as.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortType_AccordoServizioParteComune(AccordoServizioParteComune as, String porttype) throws DriverRegistroServiziException {
        return this.getPortType_AccordoServizioParteComune(as, porttype) != null;
    }

    private PortType getPortType_AccordoServizioParteComune(AccordoServizioParteComune as, String porttype) throws DriverRegistroServiziException {
        for (int j = 0; j < as.sizePortTypeList(); ++j) {
            PortType pt = as.getPortType(j);
            if (!pt.getNome().equals(porttype)) continue;
            return pt;
        }
        return null;
    }

    private boolean existsAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        return this.getAzione_PortType_AccordoServizio(pt, azione) != null;
    }

    private Operation getAzione_PortType_AccordoServizio(PortType pt, String azione) throws DriverRegistroServiziException {
        for (int j = 0; j < pt.sizeAzioneList(); ++j) {
            Operation az = pt.getAzione(j);
            if (!az.getNome().equals(azione)) continue;
            return az;
        }
        return null;
    }

    private boolean existsPortaDominio(String nome) {
        return this.getPortaDominio(nome) != null;
    }

    private PortaDominio getPortaDominio(String nome) {
        for (int j = 0; j < this.registro.sizePortaDominioList(); ++j) {
            PortaDominio pdd = this.registro.getPortaDominio(j);
            if (!nome.equals(pdd.getNome())) continue;
            return pdd;
        }
        return null;
    }

    private boolean existsSoggetto(String tipo, String nome) {
        return this.getSoggetto(tipo, nome) != null;
    }

    private Soggetto getSoggetto(String tipo, String nome) {
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto ss = this.registro.getSoggetto(j);
            if (!tipo.equals(ss.getTipo()) || !nome.equals(ss.getNome())) continue;
            return ss;
        }
        return null;
    }

    private boolean existsAccordoServizioParteSpecifica(String tipo, String nome, String tipoSoggetto, String nomeSoggetto) {
        return this.getAccordoServizioParteSpecifica(tipo, nome, tipoSoggetto, nomeSoggetto) != null;
    }

    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(String tipo, String nome, String tipoSoggetto, String nomeSoggetto) {
        for (int j = 0; j < this.registro.sizeSoggettoList(); ++j) {
            Soggetto ss = this.registro.getSoggetto(j);
            if (!tipoSoggetto.equals(ss.getTipo()) || !nomeSoggetto.equals(ss.getNome())) continue;
            for (int h = 0; h < ss.sizeAccordoServizioParteSpecificaList(); ++h) {
                AccordoServizioParteSpecifica serv = ss.getAccordoServizioParteSpecifica(h);
                if (!tipo.equals(serv.getServizio().getTipo()) || !nome.equals(serv.getServizio().getNome())) continue;
                return serv;
            }
        }
        return null;
    }
}

