/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.AccordiUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;

public class IDAccordoCooperazioneFactory {
    private static IDAccordoCooperazioneFactory factory = null;

    private static synchronized void init() {
        if (factory == null) {
            factory = new IDAccordoCooperazioneFactory();
        }
    }

    public static IDAccordoCooperazioneFactory getInstance() {
        if (factory == null) {
            IDAccordoCooperazioneFactory.init();
        }
        return factory;
    }

    private IDAccordoCooperazione build(String nome, String versione) {
        IDAccordoCooperazione idAccordoCooperazione = new IDAccordoCooperazione();
        idAccordoCooperazione.setNome(nome);
        String v = null;
        if (versione != null && !"".equals(versione)) {
            v = versione;
        }
        idAccordoCooperazione.setVersione(v);
        return idAccordoCooperazione;
    }

    public String getUriFromIDAccordo(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("IDAccordo non fornito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("Nome accordo non fornito");
        }
        if (idAccordo.getVersione() != null) {
            return idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        return idAccordo.getNome();
    }

    public String getUriFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = this.build(accordo.getNome(), accordo.getVersione());
        return this.getUriFromIDAccordo(idAccordo);
    }

    public String getUriFromValues(String nomeAS, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = this.build(nomeAS, ver);
        return this.getUriFromIDAccordo(idAccordo);
    }

    public IDAccordoCooperazione getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new Exception("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0 && (secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1)) > 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  nomeAccordo:versione");
            }
            if (primoMarcatore < 0) {
                IDAccordoCooperazione idAccordo = this.build(uriAccordo, null);
                return idAccordo;
            }
            String tmp1 = uriAccordo.substring(0, primoMarcatore);
            String tmp2 = uriAccordo.substring(primoMarcatore + 1, uriAccordo.length());
            IDAccordoCooperazione idAccordo = this.build(tmp1, tmp2);
            return idAccordo;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public IDAccordoCooperazione getIDAccordoFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = this.build(accordo.getNome(), accordo.getVersione());
        return idAccordo;
    }

    public IDAccordoCooperazione getIDAccordoFromValues(String nomeAS, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = this.build(nomeAS, ver);
        return idAccordo;
    }

    public boolean versioneNonDefinita(String value) {
        return AccordiUtils.versioneNonDefinita(value);
    }
}

