/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.RuoliDocumento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoCoordinamento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoLivelloServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSemiformale;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipiDocumentoSicurezza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class BeanUtilities
implements IDriverRegistroServiziGet {
    private static final String DRIVER_REGISTRO_SERVIZI_DB = "it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB";

    @Override
    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        return this.verificaAccordoCooperazione(idAccordo, accordoCooperazione, true);
    }

    @Override
    public boolean verificaAccordoCooperazione(IDAccordoCooperazione idAccordo, AccordoCooperazione accordoCooperazione, boolean checkID) throws DriverRegistroServiziException {
        AccordoCooperazione beanRegistro = null;
        try {
            if (this.getClass().getName().equals(DRIVER_REGISTRO_SERVIZI_DB)) {
                Method m = this.getClass().getMethod("getAccordoCooperazione", IDAccordoCooperazione.class, Boolean.TYPE);
                beanRegistro = (AccordoCooperazione)m.invoke((Object)this, idAccordo, true);
            } else {
                beanRegistro = this.getAccordoCooperazione(idAccordo);
            }
        }
        catch (DriverRegistroServiziNotFound m) {
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        if (beanRegistro == null) {
            return accordoCooperazione == null;
        }
        if (accordoCooperazione == null) {
            return false;
        }
        return beanRegistro.equals((Object)accordoCooperazione, checkID);
    }

    @Override
    public boolean verificaAccordoServizioParteComune(IDAccordo idAccordo, AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        return this.verificaAccordoServizioParteComune(idAccordo, accordoServizioParteComune, true);
    }

    @Override
    public boolean verificaAccordoServizioParteComune(IDAccordo idAccordo, AccordoServizioParteComune accordoServizioParteComune, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizioParteComune beanRegistro = null;
        try {
            if (this.getClass().getName().equals(DRIVER_REGISTRO_SERVIZI_DB)) {
                Method m = this.getClass().getMethod("getAccordoServizioParteComune", IDAccordo.class, Boolean.TYPE);
                beanRegistro = (AccordoServizioParteComune)m.invoke((Object)this, idAccordo, true);
            } else {
                beanRegistro = this.getAccordoServizioParteComune(idAccordo);
            }
        }
        catch (DriverRegistroServiziNotFound m) {
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        if (beanRegistro == null) {
            return accordoServizioParteComune == null;
        }
        if (accordoServizioParteComune == null) {
            return false;
        }
        return beanRegistro.equals((Object)accordoServizioParteComune, checkID);
    }

    @Override
    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd) throws DriverRegistroServiziException {
        return this.verificaPortaDominio(nomePdd, pdd, true);
    }

    @Override
    public boolean verificaPortaDominio(String nomePdd, PortaDominio pdd, boolean checkID) throws DriverRegistroServiziException {
        PortaDominio beanRegistro = null;
        try {
            beanRegistro = this.getPortaDominio(nomePdd);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return pdd == null;
        }
        if (pdd == null) {
            return false;
        }
        return beanRegistro.equals((Object)pdd, checkID);
    }

    @Override
    public boolean verificaSoggetto(IDSoggetto idSoggetto, Soggetto soggetto) throws DriverRegistroServiziException {
        return this.verificaSoggetto(idSoggetto, soggetto, true);
    }

    @Override
    public boolean verificaSoggetto(IDSoggetto idSoggetto, Soggetto soggetto, boolean checkID) throws DriverRegistroServiziException {
        Soggetto beanRegistro = null;
        try {
            beanRegistro = this.getSoggetto(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (beanRegistro == null) {
            return soggetto == null;
        }
        if (soggetto == null) {
            return false;
        }
        return beanRegistro.equals((Object)soggetto, checkID);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica(IDServizio idServizio, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        return this.verificaAccordoServizioParteSpecifica(idServizio, accordoServizioParteSpecifica, true);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica(IDServizio idServizio, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizioParteSpecifica beanRegistro = null;
        try {
            if (this.getClass().getName().equals(DRIVER_REGISTRO_SERVIZI_DB)) {
                Method m = this.getClass().getMethod("getAccordoServizioParteSpecifica", IDServizio.class, Boolean.TYPE);
                beanRegistro = (AccordoServizioParteSpecifica)m.invoke((Object)this, idServizio, true);
            } else {
                beanRegistro = this.getAccordoServizioParteSpecifica(idServizio);
            }
        }
        catch (DriverRegistroServiziNotFound m) {
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        if (beanRegistro == null) {
            return accordoServizioParteSpecifica == null;
        }
        if (accordoServizioParteSpecifica == null) {
            return false;
        }
        return beanRegistro.equals((Object)accordoServizioParteSpecifica, checkID);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica(IDAccordo idAccordo, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        return this.verificaAccordoServizioParteSpecifica(idAccordo, accordoServizioParteSpecifica, true);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica(IDAccordo idAccordo, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizioParteSpecifica beanRegistro = null;
        try {
            if (this.getClass().getName().equals(DRIVER_REGISTRO_SERVIZI_DB)) {
                Method m = this.getClass().getMethod("getAccordoServizioParteSpecifica", IDAccordo.class, Boolean.TYPE);
                beanRegistro = (AccordoServizioParteSpecifica)m.invoke((Object)this, idAccordo, true);
            } else {
                beanRegistro = this.getAccordoServizioParteSpecifica(idAccordo);
            }
        }
        catch (DriverRegistroServiziNotFound m) {
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        if (beanRegistro == null) {
            return accordoServizioParteSpecifica == null;
        }
        if (accordoServizioParteSpecifica == null) {
            return false;
        }
        return beanRegistro.equals((Object)accordoServizioParteSpecifica, checkID);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        return this.verificaAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune, accordoServizioParteSpecifica, true);
    }

    @Override
    public boolean verificaAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordoServizioParteComune, AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean checkID) throws DriverRegistroServiziException {
        AccordoServizioParteSpecifica beanRegistro = null;
        try {
            if (this.getClass().getName().equals(DRIVER_REGISTRO_SERVIZI_DB)) {
                Method m = this.getClass().getMethod("getAccordoServizioParteSpecifica_ServizioCorrelato", IDSoggetto.class, IDAccordo.class, Boolean.TYPE);
                beanRegistro = (AccordoServizioParteSpecifica)m.invoke((Object)this, idSoggetto, idAccordoServizioParteComune, true);
            } else {
                beanRegistro = this.getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordoServizioParteComune);
            }
        }
        catch (DriverRegistroServiziNotFound m) {
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        if (beanRegistro == null) {
            return accordoServizioParteSpecifica == null;
        }
        if (accordoServizioParteSpecifica == null) {
            return false;
        }
        return beanRegistro.equals((Object)accordoServizioParteSpecifica, checkID);
    }

    public static IDSoggetto getSoggettoReferenteID(IdSoggetto ass) {
        if (ass != null && ass.getTipo() != null && ass.getNome() != null) {
            return new IDSoggetto(ass.getTipo(), ass.getNome());
        }
        return null;
    }

    public static IDSoggetto getSoggettoErogatore(Servizio asps) {
        if (asps != null && asps.getTipoSoggettoErogatore() != null && asps.getNomeSoggettoErogatore() != null) {
            return new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
        }
        return null;
    }

    public static void validateTipoRuolo(String tipo, String ruolo) throws DriverRegistroServiziException {
        if (RuoliDocumento.allegato.toString().equals(ruolo)) {
            return;
        }
        if (RuoliDocumento.specificaSemiformale.toString().equals(ruolo)) {
            if (!(TipiDocumentoSemiformale.HTML.toString().equals(tipo) || TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString().equals(tipo) || TipiDocumentoSemiformale.UML.toString().equals(tipo) || TipiDocumentoSemiformale.XML.toString().equals(tipo))) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSemiformale.HTML.toString() + "," + TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSemiformale.UML.toString() + "," + TipiDocumentoSemiformale.XML.toString());
            }
        } else if (RuoliDocumento.specificaLivelloServizio.toString().equals(ruolo)) {
            if (!TipiDocumentoLivelloServizio.WSAGREEMENT.toString().equals(tipo) && !TipiDocumentoLivelloServizio.WSLA.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoLivelloServizio.WSAGREEMENT.toString() + "," + TipiDocumentoLivelloServizio.WSLA.toString());
            }
        } else if (RuoliDocumento.specificaSicurezza.toString().equals(ruolo)) {
            if (!(TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString().equals(tipo) || TipiDocumentoSicurezza.WSPOLICY.toString().equals(tipo) || TipiDocumentoSicurezza.XACML_POLICY.toString().equals(tipo))) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString() + "," + TipiDocumentoSicurezza.WSPOLICY.toString() + "," + TipiDocumentoSicurezza.XACML_POLICY.toString());
            }
        } else if (RuoliDocumento.specificaCoordinamento.toString().equals(ruolo)) {
            if (!TipiDocumentoCoordinamento.BPEL.toString().equals(tipo) && !TipiDocumentoCoordinamento.WSCDL.toString().equals(tipo)) {
                throw new DriverRegistroServiziException("Tipo[" + tipo + "] non accettato per il Ruolo[" + ruolo + "], valori ammessi sono: " + TipiDocumentoCoordinamento.BPEL.toString() + "," + TipiDocumentoCoordinamento.WSCDL.toString());
            }
        } else {
            throw new DriverRegistroServiziException("Ruolo non conosciuto");
        }
    }

    public static <T> ArrayList<Documento> getAllDocumenti(T o) {
        ArrayList<Documento> lista;
        block16: {
            block17: {
                block15: {
                    lista = new ArrayList<Documento>();
                    if (!(o instanceof AccordoServizioParteComune)) break block15;
                    AccordoServizioParteComune b = (AccordoServizioParteComune)o;
                    if (b.sizeAllegatoList() > 0) {
                        for (Documento documento : b.getAllegatoList()) {
                            lista.add(documento);
                        }
                    }
                    if (b.sizeSpecificaSemiformaleList() <= 0) break block16;
                    for (Documento documento : b.getSpecificaSemiformaleList()) {
                        lista.add(documento);
                    }
                    break block16;
                }
                if (!(o instanceof AccordoCooperazione)) break block17;
                AccordoCooperazione b = (AccordoCooperazione)o;
                if (b.sizeAllegatoList() > 0) {
                    for (Documento documento : b.getAllegatoList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSemiformaleList() <= 0) break block16;
                for (Documento documento : b.getSpecificaSemiformaleList()) {
                    lista.add(documento);
                }
                break block16;
            }
            if (o instanceof AccordoServizioParteSpecifica) {
                AccordoServizioParteSpecifica b = (AccordoServizioParteSpecifica)o;
                if (b.sizeAllegatoList() > 0) {
                    for (Documento documento : b.getAllegatoList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSemiformaleList() > 0) {
                    for (Documento documento : b.getSpecificaSemiformaleList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaLivelloServizioList() > 0) {
                    for (Documento documento : b.getSpecificaLivelloServizioList()) {
                        lista.add(documento);
                    }
                }
                if (b.sizeSpecificaSicurezzaList() > 0) {
                    for (Documento documento : b.getSpecificaSicurezzaList()) {
                        lista.add(documento);
                    }
                }
            }
        }
        return lista;
    }

    public RegistroServizi getImmagineCompletaRegistroServizi() throws DriverRegistroServiziException {
        RegistroServizi registroServizi = new RegistroServizi();
        List<String> idPdd = null;
        try {
            idPdd = this.getAllIdPorteDominio(new FiltroRicerca());
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (idPdd != null) {
            for (int i = 0; i < idPdd.size(); ++i) {
                try {
                    registroServizi.addPortaDominio(this.getPortaDominio(idPdd.get(i)));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Porta di Dominio [" + idPdd.get(i) + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        List<IDAccordoCooperazione> idAccordiCooperazione = null;
        try {
            idAccordiCooperazione = this.getAllIdAccordiCooperazione(new FiltroRicercaAccordi());
        }
        catch (DriverRegistroServiziNotFound dNotfound) {
            // empty catch block
        }
        if (idAccordiCooperazione != null) {
            for (int i = 0; i < idAccordiCooperazione.size(); ++i) {
                try {
                    registroServizi.addAccordoCooperazione(this.getAccordoCooperazione(idAccordiCooperazione.get(i)));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Accordo di cooperazione [" + idAccordiCooperazione.get(i) + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        List<IDAccordo> idAccordiServizio = null;
        try {
            idAccordiServizio = this.getAllIdAccordiServizioParteComune(new FiltroRicercaAccordi());
        }
        catch (DriverRegistroServiziNotFound dNotfound) {
            // empty catch block
        }
        if (idAccordiServizio != null) {
            for (int i = 0; i < idAccordiServizio.size(); ++i) {
                try {
                    registroServizi.addAccordoServizioParteComune(this.getAccordoServizioParteComune(idAccordiServizio.get(i)));
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Accordo di servizio parte comune [" + idAccordiServizio.get(i) + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        List<IDSoggetto> idSoggetti = null;
        try {
            idSoggetti = this.getAllIdSoggetti(new FiltroRicercaSoggetti());
        }
        catch (DriverRegistroServiziNotFound dNotfound) {
            // empty catch block
        }
        if (idSoggetti != null) {
            for (int i = 0; i < idSoggetti.size(); ++i) {
                try {
                    Soggetto soggetto = this.getSoggetto(idSoggetti.get(i));
                    while (soggetto.sizeAccordoServizioParteSpecificaList() > 0) {
                        soggetto.removeAccordoServizioParteSpecifica(0);
                    }
                    FiltroRicercaServizi filtro = new FiltroRicercaServizi();
                    filtro.setTipoSoggettoErogatore(soggetto.getTipo());
                    filtro.setNomeSoggettoErogatore(soggetto.getNome());
                    List<IDServizio> idServizi = null;
                    try {
                        idServizi = this.getAllIdServizi(filtro);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (idServizi != null) {
                        for (int j = 0; j < idServizi.size(); ++j) {
                            try {
                                AccordoServizioParteSpecifica s = this.getAccordoServizioParteSpecifica(idServizi.get(j));
                                soggetto.addAccordoServizioParteSpecifica(s);
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNotfound) {
                                throw new DriverRegistroServiziException("Accordo Servizio Parte Specifica [" + idServizi.get(j) + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                            }
                        }
                    }
                    registroServizi.addSoggetto(soggetto);
                    continue;
                }
                catch (DriverRegistroServiziNotFound dNotfound) {
                    throw new DriverRegistroServiziException("Soggetto [" + idSoggetti.get(i) + "] trovato tramite getAllId ma poi non recuperabile: " + dNotfound.getMessage(), dNotfound);
                }
            }
        }
        return registroServizi;
    }
}

