/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Documento;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.HttpUtilities;
import it.link.pdd.tools.migrazione_govway.utils.wsdl.WSDLUtilities;
import it.link.pdd.tools.migrazione_govway.utils.xml.AbstractXMLUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDSchemaCollection;
import it.link.pdd.tools.migrazione_govway.utils.xml.XSDUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AccordoServizioUtils {
    private Logger logger = null;
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;

    public AccordoServizioUtils(Logger log) {
        this.logger = log != null ? log : LoggerWrapperFactory.getLogger(AccordoServizioUtils.class);
        this.xmlUtils = XMLUtils.getInstance();
        this.xsdUtils = new XSDUtils(this.xmlUtils);
    }

    public Schema buildSchema(AccordoServizioParteComune as, boolean fromBytes) throws DriverRegistroServiziException {
        XSDSchemaCollection schemaCollections = this.buildSchemaCollection(as, fromBytes);
        try {
            return schemaCollections.buildSchema(this.logger);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public XSDSchemaCollection buildSchemaCollection(AccordoServizioParteComune as, boolean fromBytes) throws DriverRegistroServiziException {
        File f;
        URL url;
        String location;
        String systemId;
        byte[] resource;
        String systemId2;
        byte[] resource2;
        Node schema;
        int i;
        Hashtable<String, String> declarationNamespacesWSDL;
        boolean schemaWithOnlyImport;
        List<Node> schemi;
        Iterator<Node> f2;
        URL url2;
        String location2;
        boolean definitorioPresente = false;
        definitorioPresente = fromBytes ? as.getByteWsdlDefinitorio() != null : as.getWsdlDefinitorio() != null;
        ArrayList<Node> schemiInWsdl = new ArrayList<Node>();
        ArrayList<Node> schemiInWsdlFruitore = new ArrayList<Node>();
        WSDLUtilities wsdlUtilities = null;
        Document dWsdl = null;
        Document dWsdlFruitore = null;
        byte[] wsdl = null;
        byte[] wsdlFruitore = null;
        if (fromBytes) {
            if (as.getByteWsdlConcettuale() != null) {
                wsdl = as.getByteWsdlConcettuale();
            } else {
                if (as.getByteWsdlLogicoErogatore() != null) {
                    wsdl = as.getByteWsdlLogicoErogatore();
                }
                if (as.getByteWsdlLogicoFruitore() != null) {
                    wsdlFruitore = as.getByteWsdlLogicoFruitore();
                }
            }
        } else if (as.getWsdlConcettuale() != null) {
            try {
                location2 = as.getWsdlConcettuale();
                if (location2.startsWith("http://") || location2.startsWith("file://")) {
                    url2 = new URL(location2);
                    wsdl = HttpUtilities.requestHTTPFile(url2.toString());
                }
                f2 = new File(location2);
                wsdl = FileSystemUtilities.readBytesFromFile((File)((Object)f2));
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl concettuale corrotto: " + e.getMessage(), e);
            }
        } else {
            if (as.getWsdlLogicoErogatore() != null) {
                try {
                    location2 = as.getWsdlLogicoErogatore();
                    if (location2.startsWith("http://") || location2.startsWith("file://")) {
                        url2 = new URL(location2);
                        wsdl = HttpUtilities.requestHTTPFile(url2.toString());
                    } else {
                        f2 = new File(location2);
                        wsdl = FileSystemUtilities.readBytesFromFile((File)((Object)f2));
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl logico erogatore corrotto: " + e.getMessage(), e);
                }
            }
            if (as.getWsdlLogicoFruitore() != null) {
                try {
                    location2 = as.getWsdlLogicoFruitore();
                    if (location2.startsWith("http://") || location2.startsWith("file://")) {
                        url2 = new URL(location2);
                        wsdlFruitore = HttpUtilities.requestHTTPFile(url2.toString());
                    } else {
                        f2 = new File(location2);
                        wsdlFruitore = FileSystemUtilities.readBytesFromFile((File)((Object)f2));
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl logico fruitore corrotto: " + e.getMessage(), e);
                }
            }
        }
        if (wsdl != null) {
            try {
                wsdlUtilities = new WSDLUtilities(this.xmlUtils);
                dWsdl = this.xmlUtils.newDocument(wsdl);
                schemi = wsdlUtilities.getSchemiXSD(dWsdl);
                if (schemi != null && schemi.size() > 0) {
                    for (Node schema2 : schemi) {
                        schemaWithOnlyImport = this.xsdUtils.isSchemaWithOnlyImports(schema2);
                        if (schemaWithOnlyImport) continue;
                        schemiInWsdl.add(schema2);
                    }
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl corrotto: " + e.getMessage(), e);
            }
        }
        if (wsdlFruitore != null) {
            try {
                wsdlUtilities = new WSDLUtilities(this.xmlUtils);
                dWsdlFruitore = this.xmlUtils.newDocument(wsdlFruitore);
                schemi = wsdlUtilities.getSchemiXSD(dWsdlFruitore);
                if (schemi != null && schemi.size() > 0) {
                    for (Node schema2 : schemi) {
                        schemaWithOnlyImport = this.xsdUtils.isSchemaWithOnlyImports(schema2);
                        if (schemaWithOnlyImport) continue;
                        schemiInWsdlFruitore.add(schema2);
                    }
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl fruitore corrotto: " + e.getMessage(), e);
            }
        }
        if (schemiInWsdl.size() <= 0 && schemiInWsdlFruitore.size() <= 0 && !definitorioPresente && as.sizeAllegatoList() == 0 && as.sizeSpecificaSemiformaleList() == 0) {
            throw new DriverRegistroServiziException("L'accordo di servizio parte comune non contiene schemi XSD");
        }
        Hashtable<String, byte[]> resources = new Hashtable<String, byte[]>();
        Hashtable<String, String> mappingNamespaceLocations = new Hashtable<String, String>();
        if (schemiInWsdl.size() > 0) {
            declarationNamespacesWSDL = null;
            try {
                declarationNamespacesWSDL = this.xmlUtils.getNamespaceDeclaration(dWsdl.getDocumentElement());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl corrotto (Analisi namespace declarations): " + e.getMessage(), e);
            }
            for (i = 0; i < schemiInWsdl.size(); ++i) {
                schema = (Node)schemiInWsdl.get(i);
                try {
                    if (declarationNamespacesWSDL != null && declarationNamespacesWSDL.size() > 0) {
                        this.xmlUtils.addNamespaceDeclaration(declarationNamespacesWSDL, (Element)schema);
                    }
                    resource2 = this.xmlUtils.toByteArray(schema);
                    systemId2 = "internalWsdlTypes_" + (i + 1) + ".xsd";
                    resources.put(systemId2, resource2);
                    this.xsdUtils.registraMappingNamespaceLocations(resource2, systemId2, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl corrotto (Estrazione schema): " + e.getMessage(), e);
                }
            }
        }
        if (schemiInWsdlFruitore.size() > 0) {
            declarationNamespacesWSDL = null;
            try {
                declarationNamespacesWSDL = this.xmlUtils.getNamespaceDeclaration(dWsdlFruitore.getDocumentElement());
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl corrotto (Analisi namespace declarations): " + e.getMessage(), e);
            }
            for (i = 0; i < schemiInWsdlFruitore.size(); ++i) {
                schema = (Node)schemiInWsdlFruitore.get(i);
                try {
                    if (declarationNamespacesWSDL != null && declarationNamespacesWSDL.size() > 0) {
                        this.xmlUtils.addNamespaceDeclaration(declarationNamespacesWSDL, (Element)schema);
                    }
                    resource2 = this.xmlUtils.toByteArray(schema);
                    systemId2 = "internalWsdlFruitoreTypes_" + (i + 1) + ".xsd";
                    resources.put(systemId2, resource2);
                    this.xsdUtils.registraMappingNamespaceLocations(resource2, systemId2, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'accordo di servizio parte comune contiene un wsdl corrotto (Estrazione schema): " + e.getMessage(), e);
                }
            }
        }
        if (fromBytes && as.getByteWsdlDefinitorio() != null || !fromBytes && as.getWsdlDefinitorio() != null) {
            byte[] resource3 = null;
            String systemId3 = null;
            if (fromBytes) {
                systemId3 = "InterfacciaDefinitoria.xsd";
                resource3 = as.getByteWsdlDefinitorio();
            } else {
                String location3 = as.getWsdlDefinitorio();
                try {
                    if (location3.startsWith("http://") || location3.startsWith("file://")) {
                        URL url3 = new URL(location3);
                        resource3 = HttpUtilities.requestHTTPFile(url3.toString());
                        systemId3 = new File(url3.getFile()).getName();
                    } else {
                        File f3 = new File(location3);
                        resource3 = FileSystemUtilities.readBytesFromFile(f3);
                        systemId3 = f3.getName();
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("L'accordo di servizio parte comune indirizza un wsdl definitorio [" + location3 + "] non esistente");
                }
            }
            try {
                if (this.xsdUtils.isXSDSchema(resource3)) {
                    resources.put(systemId3, resource3);
                    this.xsdUtils.registraMappingNamespaceLocations(resource3, systemId3, mappingNamespaceLocations);
                }
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("La lettura del wsdl definitorio ha causato un errore: " + e.getMessage(), e);
            }
        }
        if (as.sizeAllegatoList() > 0) {
            for (int i2 = 0; i2 < as.sizeAllegatoList(); ++i2) {
                Documento allegato = as.getAllegato(i2);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = allegato.getFile();
                    resource = allegato.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Allegato [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = allegato.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile(url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile(f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Allegato [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!this.xsdUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura dell'allegato [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        if (as.sizeSpecificaSemiformaleList() > 0) {
            for (int i3 = 0; i3 < as.sizeSpecificaSemiformaleList(); ++i3) {
                Documento specificaSemiformale = as.getSpecificaSemiformale(i3);
                resource = null;
                systemId = null;
                if (fromBytes) {
                    systemId = specificaSemiformale.getFile();
                    resource = specificaSemiformale.getByteContenuto();
                    if (resource == null) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + systemId + "] non contiene i bytes che ne definiscono il contenuto");
                    }
                } else {
                    location = specificaSemiformale.getFile();
                    try {
                        if (location.startsWith("http://") || location.startsWith("file://")) {
                            url = new URL(location);
                            resource = HttpUtilities.requestHTTPFile(url.toString());
                            systemId = new File(url.getFile()).getName();
                        } else {
                            f = new File(location);
                            resource = FileSystemUtilities.readBytesFromFile(f);
                            systemId = f.getName();
                        }
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("Specifica Semiformale [" + location + "] indirizza un documento non esistente");
                    }
                }
                try {
                    if (!this.xsdUtils.isXSDSchema(resource)) continue;
                    if (resources.containsKey(systemId)) {
                        throw new Exception("Esiste pi\u00f9 di un documento xsd, registrato tra allegati e specifiche semiformali, con nome [" + systemId + "] (La validazione xsd di OpenSPCoop richiede l'utilizzo di nomi diversi)");
                    }
                    resources.put(systemId, resource);
                    this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, mappingNamespaceLocations);
                    continue;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("La lettura della specifica semiformale [" + systemId + "] ha causato un errore: " + e.getMessage(), e);
                }
            }
        }
        try {
            return this.xsdUtils.buildSchemaCollection(resources, mappingNamespaceLocations, this.logger);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }
}

