/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.StateMessage;
import it.link.pdd.tools.migrazione_govway.utils.TipiDatabase;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorParameter;
import it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGeneratorType;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class IDSerialGenerator {
    private static DataSource datasourcePdD = null;
    private IState state;
    private Logger log;
    private TipiDatabase tipoDatabase;

    public static synchronized void init(DataSource ds) {
        if (datasourcePdD == null) {
            datasourcePdD = ds;
        }
    }

    private static Connection getConnectionPdD() throws SQLException, ProtocolException {
        if (datasourcePdD == null) {
            throw new ProtocolException("IDSerialGenerator non inizializzato");
        }
        return datasourcePdD.getConnection();
    }

    private static void releaseConnectionPdD(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    public IDSerialGenerator(Logger log, IState state, TipiDatabase tipoDatabase) {
        this.log = log;
        this.state = state;
        this.tipoDatabase = tipoDatabase;
    }

    public long buildIDAsNumber(IDSerialGeneratorParameter param) throws ProtocolException {
        try {
            if (IDSerialGeneratorType.ALFANUMERICO.equals(param)) {
                throw new ProtocolException("IDSerialGeneratorType[" + param.getTipo() + "] prevede anche caratteri alfanumerici");
            }
            return Long.parseLong(this.buildID(param));
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public String buildID(IDSerialGeneratorParameter param) throws ProtocolException {
        Connection conDB = null;
        boolean conDBFromDatasource = false;
        try {
            StateMessage state;
            if (this.state != null && this.state instanceof StateMessage && (state = (StateMessage)this.state).getConnectionDB() != null && !state.getConnectionDB().isClosed()) {
                conDB = state.getConnectionDB();
            }
            if (conDB == null) {
                conDB = IDSerialGenerator.getConnectionPdD();
                conDBFromDatasource = true;
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Connessione non disponibile: " + e.getMessage(), e);
        }
        if (conDB == null) {
            throw new ProtocolException("Connessione non disponibile");
        }
        String identificativoUnivoco = null;
        try {
            it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator generator = new it.link.pdd.tools.migrazione_govway.utils.id.serial.IDSerialGenerator();
            String string = identificativoUnivoco = generator.buildID(param, conDB, this.tipoDatabase, this.log);
            return string;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        finally {
            try {
                if (conDBFromDatasource) {
                    IDSerialGenerator.releaseConnectionPdD(conDB);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("Rilascio connessione non riuscito: " + e.getMessage(), e);
            }
        }
    }
}

