/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoTransportContextIdentificationMode;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpException;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegExpNotFoundException;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionEngine;
import it.link.pdd.tools.migrazione_govway.utils.regexp.RegularExpressionPatternCompileMode;
import java.util.Enumeration;
import java.util.Properties;

public class EsitoTransportContextIdentification {
    private String name;
    private EsitoTransportContextIdentificationMode mode;
    private String regularExpr;
    private String value;
    private String type;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EsitoTransportContextIdentificationMode getMode() {
        return this.mode;
    }

    public void setMode(EsitoTransportContextIdentificationMode mode) {
        this.mode = mode;
    }

    public String getRegularExpr() {
        return this.regularExpr;
    }

    public void setRegularExpr(String regularExpr) {
        this.regularExpr = regularExpr;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean match(Properties p) throws ProtocolException {
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String valueKey = p.getProperty(key);
            if (valueKey == null) {
                valueKey = p.getProperty(key.toLowerCase());
            }
            if (valueKey == null) {
                valueKey = p.getProperty(key.toUpperCase());
            }
            if (key.equalsIgnoreCase(this.name)) {
                switch (this.mode) {
                    case EXISTS: {
                        return true;
                    }
                    case MATCH: {
                        try {
                            if (RegularExpressionEngine.isMatch(valueKey, this.regularExpr, RegularExpressionPatternCompileMode.CASE_INSENSITIVE)) {
                                return true;
                            }
                            break;
                        }
                        catch (RegExpNotFoundException notFound) {
                            break;
                        }
                        catch (RegExpException exp) {
                            throw new ProtocolException(exp.getMessage(), exp);
                        }
                    }
                    case CONTAINS: {
                        if (this.regularExpr == null) {
                            if (this.value == null || valueKey == null || !valueKey.toLowerCase().contains(this.value.toLowerCase())) break;
                            return true;
                        }
                        String valueRexExp = null;
                        try {
                            valueRexExp = RegularExpressionEngine.getStringMatchPattern(valueKey, this.regularExpr, RegularExpressionPatternCompileMode.CASE_INSENSITIVE);
                        }
                        catch (RegExpNotFoundException notFound) {
                            break;
                        }
                        catch (RegExpException exp) {
                            throw new ProtocolException(exp.getMessage(), exp);
                        }
                        if (this.value == null || valueRexExp == null || !valueRexExp.toLowerCase().contains(this.value.toLowerCase())) break;
                        return true;
                    }
                    case EQUALS: {
                        if (this.regularExpr == null) {
                            if (!(this.value == null ? valueKey == null : this.value.equalsIgnoreCase(valueKey))) break;
                            return true;
                        }
                        String valueRexExp = null;
                        try {
                            valueRexExp = RegularExpressionEngine.getStringMatchPattern(valueKey, this.regularExpr, RegularExpressionPatternCompileMode.CASE_INSENSITIVE);
                        }
                        catch (RegExpNotFoundException notFound) {
                            break;
                        }
                        catch (RegExpException exp) {
                            throw new ProtocolException(exp.getMessage(), exp);
                        }
                        if (!(this.value == null ? valueRexExp == null : this.value.equalsIgnoreCase(valueRexExp))) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

