/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.EsitoTransazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.EsitoTransazioneName;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitiInstanceProperties;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoIdentificationMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoIdentificationModeContextProperty;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoIdentificationModeSoapFault;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoTransportContextIdentification;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitoTransportContextIdentificationMode;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public class EsitiProperties {
    private Logger log = null;
    private static EsitiProperties esitiProperties = null;
    private EsitiInstanceProperties reader;
    private static List<Integer> esitiCode = null;
    private static List<Integer> esitiCodeOk = null;
    private static List<Integer> esitiCodeOk_senzaFaultApplicativo = null;
    private static List<Integer> esitiCodeKo = null;
    private static List<Integer> esitiCodeKo_senzaFaultApplicativo = null;
    private static List<Integer> esitiCodeFaultApplicativo = null;
    private static List<Integer> esitiCodeForSoapFaultIdentificationMode = null;
    private static List<Integer> esitiCodeForContextPropertyIdentificationMode = null;
    private static List<Integer> esitiCodeOrderLabel = null;
    private static List<String> esitiOrderLabel = null;
    private static Hashtable<String, String> esitoName = null;
    private static Hashtable<String, String> esitoDescription = null;
    private static Hashtable<String, String> esitoLabel = null;
    private static Hashtable<String, EsitoIdentificationMode> esitoIdentificationMode = null;
    private static Hashtable<String, List<EsitoIdentificationModeSoapFault>> esitoIdentificationModeSoapFaultList = null;
    private static Hashtable<String, List<EsitoIdentificationModeContextProperty>> esitoIdentificationModeContextPropertyList = null;
    private static List<String> esitiTransactionContextCode = null;
    private static List<String> esitiTransactionContextCodeOrderLabel = null;
    private static List<String> esitiTransactionContextOrderLabel = null;
    private static Hashtable<String, String> esitoTransactionContextLabel = null;
    private static String esitoTransactionContextDefault = null;
    private static Boolean esitoTransactionContextDefault_read = null;
    private static String esitoTransactionContextHeaderTrasportoName = null;
    private static String esitoTransactionContextFormBasedPropertyName = null;
    private static List<EsitoTransportContextIdentification> esitoTransactionContextHeaderTrasportoDynamicIdentification = null;
    private static List<EsitoTransportContextIdentification> esitoTransactionContextHeaderFormBasedDynamicIdentification = null;

    public EsitiProperties(String confDir, Logger log) throws ProtocolException {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(EsitiProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = EsitiProperties.class.getResourceAsStream("/it/link/pdd/tools/migrazione_govway/openspcoop2_core/protocol/utils/esiti.properties");
            if (properties == null) {
                throw new Exception("File '/it/link/pdd/tools/migrazione_govway/openspcoop2_core/protocol/utils/esiti.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file '/it/link/pdd/tools/migrazione_govway/openspcoop2_core/protocol/utils/esiti.properties': " + e.getMessage());
            throw new ProtocolException("EsitiProperties initialize error: " + e.getMessage(), e);
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.reader = new EsitiInstanceProperties(confDir, propertiesReader, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public static synchronized void initialize(String confDir, Logger log, Loader loader) throws ProtocolException {
        if (esitiProperties == null) {
            esitiProperties = new EsitiProperties(confDir, log);
            esitiProperties.validaConfigurazione(loader);
        }
    }

    public static EsitiProperties getInstance(Logger log) throws ProtocolException {
        if (esitiProperties == null) {
            throw new ProtocolException("EsitiProperties not initialized (use init method in factory)");
        }
        return esitiProperties;
    }

    public void validaConfigurazione(Loader loader) throws ProtocolException {
        try {
            List<Integer> codes = this.getEsitiCode();
            this.getEsitiCodeOrderLabel();
            ArrayList<String> labelCheck = new ArrayList<String>();
            ArrayList<String> nameCheck = new ArrayList<String>();
            for (Integer n : codes) {
                String string = this.getEsitoName(n);
                if (nameCheck.contains(string)) {
                    throw new ProtocolException("Esito name [" + string + "] already defined");
                }
                nameCheck.add(string);
                this.getEsitoDescription(n);
                String esitoLabel = this.getEsitoLabel(n);
                if (labelCheck.contains(esitoLabel)) {
                    throw new ProtocolException("Esito label [" + esitoLabel + "] already defined");
                }
                labelCheck.add(esitoLabel);
                Object mode = this.getEsitoIdentificationMode(n);
                if (EsitoIdentificationMode.SOAP_FAULT.equals((EsitoIdentificationMode)((Object)mode))) {
                    this.getEsitoIdentificationModeSoapFaultList(n);
                    continue;
                }
                if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals((EsitoIdentificationMode)((Object)mode))) continue;
                this.getEsitoIdentificationModeContextPropertyList(n);
            }
            List<Integer> codesOk = this.getEsitiCodeOk();
            this.getEsitiCodeKo();
            for (Integer n : codesOk) {
                boolean found = false;
                for (Integer codeEsito : codes) {
                    if (n != codeEsito) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new ProtocolException("Code 'ok' [" + n + "] not defined in codes");
            }
            List<String> list = this.getEsitiTransactionContextCode();
            this.getEsitiTransactionContextCodeOrderLabel();
            labelCheck = new ArrayList();
            for (String tipo : list) {
                String tipoLabel = this.getEsitoTransactionContextLabel(tipo);
                if (labelCheck.contains(tipoLabel)) {
                    throw new ProtocolException("Transaction Context Label [" + tipoLabel + "] already defined");
                }
                labelCheck.add(tipoLabel);
            }
            EsitoTransazioneName[] esitoTransazioneNameArray = EsitoTransazioneName.values();
            for (int i = 0; i < esitoTransazioneNameArray.length; ++i) {
                if (EsitoTransazioneName.CUSTOM.equals(esitoTransazioneNameArray[i])) continue;
                this.convertoToCode(esitoTransazioneNameArray[i]);
            }
            if (!this.getEsitiTransactionContextCode().contains("standard")) {
                throw new ProtocolException("Required TipoContext [standard] undefined");
            }
            this.getEsitiOrderLabel();
            this.getEsitiTransactionContextOrderLabel();
            this.getEsitoTransactionContextDefault();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la validazione della proprieta' degli esiti, " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    private EsitoTransazioneName getEsitoTransazioneName(Integer cod) throws ProtocolException {
        return EsitoTransazioneName.convertoTo(this.getEsitoName(cod));
    }

    public List<EsitoTransazione> getListEsitoTransazioneFromFilter(Integer codeParam, String tipoContextParam) throws ProtocolException {
        ArrayList<EsitoTransazione> list = new ArrayList<EsitoTransazione>();
        if (codeParam == null) {
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (tipoContextParam == null) {
                    List<String> tipiContext = this.getEsitiTransactionContextCode();
                    for (String tipo : tipiContext) {
                        list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeEsito), codeEsito, tipo));
                    }
                    continue;
                }
                list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeEsito), codeEsito, tipoContextParam));
            }
        } else if (tipoContextParam == null) {
            List<String> tipiContext = this.getEsitiTransactionContextCode();
            for (String tipo : tipiContext) {
                list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeParam), codeParam, tipo));
            }
        } else {
            list.add(new EsitoTransazione(this.getEsitoTransazioneName(codeParam), codeParam, tipoContextParam));
        }
        return list;
    }

    public EsitoTransazione convertToEsitoTransazione(Integer code, String tipoContext) throws ProtocolException {
        if (code == null) {
            throw new ProtocolException("Code [" + code + "] undefined");
        }
        if (!this.existsEsitoCode(code)) {
            throw new ProtocolException("Code [" + tipoContext + "] unsupported");
        }
        String name = this.getEsitoName(code);
        if (name == null) {
            throw new ProtocolException("Name for esito code [" + code + "] undefined");
        }
        EsitoTransazioneName nameEnum = EsitoTransazioneName.convertoTo(name);
        return this.convertToEsitoTransazione(nameEnum, code, tipoContext);
    }

    public EsitoTransazione convertToEsitoTransazione(EsitoTransazioneName esito, String tipoContext) throws ProtocolException {
        return this.convertToEsitoTransazione(esito, this.convertoToCode(esito), tipoContext);
    }

    public EsitoTransazione convertToEsitoTransazione(EsitoTransazioneName esito, Integer code, String tipoContext) throws ProtocolException {
        if (esito == null) {
            throw new ProtocolException("EsitoTransazioneName [" + code + "] undefined");
        }
        if (code == null) {
            throw new ProtocolException("Code [" + code + "] undefined");
        }
        if (!this.existsEsitoCode(code)) {
            throw new ProtocolException("Code [" + tipoContext + "] unsupported");
        }
        if (tipoContext == null) {
            throw new ProtocolException("TipoContext [" + code + "] undefined");
        }
        if (!this.getEsitiTransactionContextCode().contains(tipoContext)) {
            throw new ProtocolException("TipoContext [" + tipoContext + "] unsupported");
        }
        return new EsitoTransazione(esito, code, tipoContext);
    }

    public Integer convertoToCode(EsitoTransazioneName esito) throws ProtocolException {
        Integer code = null;
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            String name = this.getEsitoName(codeEsito);
            if (!name.equals(esito.name())) continue;
            code = codeEsito;
            break;
        }
        if (code == null) {
            throw new ProtocolException("Code [" + code + "] undefined");
        }
        return code;
    }

    public Integer convertLabelToCode(String label) throws ProtocolException {
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            String labelCheck = this.getEsitoLabel(codeEsito);
            if (!labelCheck.equals(label)) continue;
            return codeEsito;
        }
        throw new ProtocolException("Not exists esito code with label [" + label + "]");
    }

    public Integer convertNameToCode(String name) throws ProtocolException {
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            String nameCheck = this.getEsitoName(codeEsito);
            if (!nameCheck.equals(name)) continue;
            return codeEsito;
        }
        throw new ProtocolException("Not exists esito code with name [" + name + "]");
    }

    public boolean existsEsitoCode(Integer code) throws ProtocolException {
        List<Integer> codes = this.getEsitiCode();
        for (Integer codeEsito : codes) {
            if (codeEsito != code) continue;
            return true;
        }
        return false;
    }

    public String convertLabelToContextTypeCode(String label) throws ProtocolException {
        List<String> codes = this.getEsitiTransactionContextCode();
        for (String codeTransactionContext : codes) {
            String labelCheck = this.getEsitoTransactionContextLabel(codeTransactionContext);
            if (!labelCheck.equals(label)) continue;
            return codeTransactionContext;
        }
        throw new ProtocolException("Not exists context type with label [" + label + "]");
    }

    public List<Integer> getEsitiCode() throws ProtocolException {
        if (esitiCode == null) {
            this.initEsitiCode();
        }
        return esitiCode;
    }

    private synchronized void initEsitiCode() throws ProtocolException {
        if (esitiCode == null) {
            esitiCode = this.getListaInteger("esiti.codes");
        }
    }

    public List<Integer> getEsitiCodeOk() throws ProtocolException {
        if (esitiCodeOk == null) {
            this.initEsitiCodeOk();
        }
        return esitiCodeOk;
    }

    private synchronized void initEsitiCodeOk() throws ProtocolException {
        if (esitiCodeOk == null) {
            esitiCodeOk = this.getListaInteger("esiti.codes.ok");
        }
    }

    public List<Integer> getEsitiCodeOk_senzaFaultApplicativo() throws ProtocolException {
        if (esitiCodeOk_senzaFaultApplicativo == null) {
            this.initEsitiCodeOk_senzaFaultApplicativo();
        }
        return esitiCodeOk_senzaFaultApplicativo;
    }

    private synchronized void initEsitiCodeOk_senzaFaultApplicativo() throws ProtocolException {
        if (esitiCodeOk_senzaFaultApplicativo == null) {
            List<Integer> tmp = this.getEsitiCodeOk();
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            ArrayList<Integer> esitiOk = new ArrayList<Integer>();
            for (Integer e : tmp) {
                if (e == codeFaultApplicativo) continue;
                esitiOk.add(e);
            }
            esitiCodeOk_senzaFaultApplicativo = esitiOk;
        }
    }

    public List<Integer> getEsitiCodeKo() throws ProtocolException {
        if (esitiCodeKo == null) {
            this.initEsitiCodeKo();
        }
        return esitiCodeKo;
    }

    private synchronized void initEsitiCodeKo() throws ProtocolException {
        if (esitiCodeKo == null) {
            esitiCodeKo = new ArrayList<Integer>();
            List<Integer> esiti = this.getEsitiCode();
            for (Integer esito : esiti) {
                boolean found = false;
                List<Integer> oks = this.getEsitiCodeOk();
                for (Integer ok : oks) {
                    if (ok != esito) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                esitiCodeKo.add(esito);
            }
        }
    }

    public List<Integer> getEsitiCodeKo_senzaFaultApplicativo() throws ProtocolException {
        if (esitiCodeKo_senzaFaultApplicativo == null) {
            this.initEsitiCodeKo_senzaFaultApplicativo();
        }
        return esitiCodeKo_senzaFaultApplicativo;
    }

    private synchronized void initEsitiCodeKo_senzaFaultApplicativo() throws ProtocolException {
        if (esitiCodeKo_senzaFaultApplicativo == null) {
            List<Integer> tmp = this.getEsitiCodeKo();
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            ArrayList<Integer> esitiKo = new ArrayList<Integer>();
            for (Integer e : tmp) {
                if (e == codeFaultApplicativo) continue;
                esitiKo.add(e);
            }
            esitiCodeKo_senzaFaultApplicativo = esitiKo;
        }
    }

    public List<Integer> getEsitiCodeFaultApplicativo() throws ProtocolException {
        if (esitiCodeFaultApplicativo == null) {
            this.initEsitiCodeFaultApplicativo();
        }
        return esitiCodeFaultApplicativo;
    }

    private synchronized void initEsitiCodeFaultApplicativo() throws ProtocolException {
        if (esitiCodeFaultApplicativo == null) {
            int codeFaultApplicativo = this.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
            esitiCodeFaultApplicativo = new ArrayList<Integer>();
            esitiCodeFaultApplicativo.add(codeFaultApplicativo);
        }
    }

    public List<Integer> getEsitiCodeForSoapFaultIdentificationMode() throws ProtocolException {
        if (esitiCodeForSoapFaultIdentificationMode == null) {
            this.initEsitiCodeForSoapFaultIdentificationMode();
        }
        return esitiCodeForSoapFaultIdentificationMode;
    }

    private synchronized void initEsitiCodeForSoapFaultIdentificationMode() throws ProtocolException {
        if (esitiCodeForSoapFaultIdentificationMode == null) {
            esitiCodeForSoapFaultIdentificationMode = new ArrayList<Integer>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (!EsitoIdentificationMode.SOAP_FAULT.equals(this.getEsitoIdentificationMode(codeEsito))) continue;
                esitiCodeForSoapFaultIdentificationMode.add(codeEsito);
            }
        }
    }

    public List<Integer> getEsitiCodeForContextPropertyIdentificationMode() throws ProtocolException {
        if (esitiCodeForContextPropertyIdentificationMode == null) {
            this.initEsitiCodeForContextPropertyIdentificationMode();
        }
        return esitiCodeForContextPropertyIdentificationMode;
    }

    private synchronized void initEsitiCodeForContextPropertyIdentificationMode() throws ProtocolException {
        if (esitiCodeForContextPropertyIdentificationMode == null) {
            esitiCodeForContextPropertyIdentificationMode = new ArrayList<Integer>();
            List<Integer> codes = this.getEsitiCode();
            for (Integer codeEsito : codes) {
                if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals(this.getEsitoIdentificationMode(codeEsito))) continue;
                esitiCodeForContextPropertyIdentificationMode.add(codeEsito);
            }
        }
    }

    public List<Integer> getEsitiCodeOrderLabel() throws ProtocolException {
        if (esitiCodeOrderLabel == null) {
            this.initEsitiCodeOrderLabel();
        }
        return esitiCodeOrderLabel;
    }

    private synchronized void initEsitiCodeOrderLabel() throws ProtocolException {
        if (esitiCodeOrderLabel == null) {
            esitiCodeOrderLabel = this.getListaInteger("esiti.codes.labelOrder");
        }
    }

    public List<String> getEsitiOrderLabel() throws ProtocolException {
        if (esitiOrderLabel == null) {
            this.initEsitiOrderLabel();
        }
        return esitiOrderLabel;
    }

    private synchronized void initEsitiOrderLabel() throws ProtocolException {
        if (esitiOrderLabel == null) {
            List<Integer> codes = this.getEsitiCode();
            esitiOrderLabel = new ArrayList<String>();
            for (Integer codeEsito : codes) {
                esitiOrderLabel.add(this.getEsitoLabel(codeEsito));
            }
        }
    }

    public String getEsitoName(Integer codeEsito) throws ProtocolException {
        if (esitoName == null) {
            this.initEsitoName();
        }
        if (!esitoName.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoName for code [" + codeEsito + "] not found");
        }
        return esitoName.get("" + codeEsito);
    }

    private synchronized void initEsitoName() throws ProtocolException {
        if (esitoName == null) {
            esitoName = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                esitoName.put("" + code, this.getProperty("esito." + code + ".name"));
            }
        }
    }

    public String getEsitoDescription(Integer codeEsito) throws ProtocolException {
        if (esitoDescription == null) {
            this.initEsitoDescription();
        }
        if (!esitoDescription.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoDescription for code [" + codeEsito + "] not found");
        }
        return esitoDescription.get("" + codeEsito);
    }

    private synchronized void initEsitoDescription() throws ProtocolException {
        if (esitoDescription == null) {
            esitoDescription = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                esitoDescription.put("" + code, this.getProperty("esito." + code + ".description"));
            }
        }
    }

    public String getEsitoLabel(Integer codeEsito) throws ProtocolException {
        if (esitoLabel == null) {
            this.initEsitoLabel();
        }
        if (!esitoLabel.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoLabel for code [" + codeEsito + "] not found");
        }
        return esitoLabel.get("" + codeEsito);
    }

    private synchronized void initEsitoLabel() throws ProtocolException {
        if (esitoLabel == null) {
            esitoLabel = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                esitoLabel.put("" + code, this.getProperty("esito." + code + ".label"));
            }
        }
    }

    public EsitoIdentificationMode getEsitoIdentificationMode(Integer codeEsito) throws ProtocolException {
        if (esitoIdentificationMode == null) {
            this.initEsitoIdentificationMode();
        }
        if (!esitoIdentificationMode.containsKey("" + codeEsito)) {
            throw new ProtocolException("EsitoIdentificationMode for code [" + codeEsito + "] not found");
        }
        return esitoIdentificationMode.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationMode() throws ProtocolException {
        if (esitoIdentificationMode == null) {
            esitoIdentificationMode = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                String prop = "esito." + code + ".mode";
                String tmp = this.getProperty(prop);
                try {
                    EsitoIdentificationMode e = EsitoIdentificationMode.toEnumConstant(tmp);
                    if (e == null) {
                        throw new Exception("proprieta con valore non supportato");
                    }
                    esitoIdentificationMode.put("" + code, e);
                }
                catch (Exception e) {
                    String msg = "Riscontrato errore durante la lettura della proprieta' '" + prop + "': " + e.getMessage();
                    this.log.error(msg, (Throwable)e);
                    throw new ProtocolException(msg, e);
                }
            }
        }
    }

    public List<EsitoIdentificationModeSoapFault> getEsitoIdentificationModeSoapFaultList(Integer codeEsito) throws ProtocolException {
        if (esitoIdentificationModeSoapFaultList == null) {
            this.initEsitoIdentificationModeSoapFaultList();
        }
        return esitoIdentificationModeSoapFaultList.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationModeSoapFaultList() throws ProtocolException {
        if (esitoIdentificationModeSoapFaultList == null) {
            esitoIdentificationModeSoapFaultList = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                try {
                    EsitoIdentificationMode mode = this.getEsitoIdentificationMode(code);
                    if (!EsitoIdentificationMode.SOAP_FAULT.equals(mode)) continue;
                    esitoIdentificationModeSoapFaultList.put("" + code, this._getEsitoIdentificationModeSoapFaultList(code));
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + code + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    private List<EsitoIdentificationModeSoapFault> _getEsitoIdentificationModeSoapFaultList(Integer codeEsito) throws ProtocolException {
        ArrayList<EsitoIdentificationModeSoapFault> l = null;
        String prefix = "esito." + codeEsito + ".mode.soapFault.";
        for (int index = 0; index < 1000; ++index) {
            EsitoIdentificationModeSoapFault esito = new EsitoIdentificationModeSoapFault();
            esito.setFaultCode(this.getOptionalProperty(prefix + index + ".code"));
            esito.setFaultNamespaceCode(this.getOptionalProperty(prefix + index + ".namespaceCode"));
            esito.setFaultReason(this.getOptionalProperty(prefix + index + ".reason"));
            esito.setFaultReasonContains(this.getOptionalBooleanProperty(prefix + index + ".reason.contains"));
            esito.setFaultActor(this.getOptionalProperty(prefix + index + ".actor"));
            esito.setFaultActorNotDefined(this.getOptionalBooleanProperty(prefix + index + ".actorNotDefined"));
            if (esito.getFaultReasonContains() != null && esito.getFaultReason() == null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] esiste un mapping rispetto alla modalit\u00e0 soapFault in cui \u00e8 stato definita la propriet\u00e0 '*.reason.contains' senza la propriet\u00e0 '*.reason'");
            }
            if (esito.getFaultActor() != null && esito.getFaultActorNotDefined() != null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] esiste un mapping rispetto alla modalit\u00e0 soapFault in cui sono state definite entrambe le modalit\u00e0 di indenficazione dell'actor");
            }
            if (esito.getFaultActor() == null && esito.getFaultActorNotDefined() == null && esito.getFaultCode() == null && esito.getFaultNamespaceCode() == null && esito.getFaultReason() == null) {
                if (index != 0) break;
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste alcun mapping rispetto alla modalit\u00e0 soapFault");
            }
            if (l == null) {
                l = new ArrayList<EsitoIdentificationModeSoapFault>();
            }
            l.add(esito);
        }
        return l;
    }

    public List<EsitoIdentificationModeContextProperty> getEsitoIdentificationModeContextPropertyList(Integer codeEsito) throws ProtocolException {
        if (esitoIdentificationModeContextPropertyList == null) {
            this.initEsitoIdentificationModeContextPropertyList();
        }
        return esitoIdentificationModeContextPropertyList.get("" + codeEsito);
    }

    private synchronized void initEsitoIdentificationModeContextPropertyList() throws ProtocolException {
        if (esitoIdentificationModeContextPropertyList == null) {
            esitoIdentificationModeContextPropertyList = new Hashtable();
            List<Integer> codes = this.getEsitiCode();
            for (Integer code : codes) {
                try {
                    EsitoIdentificationMode mode = this.getEsitoIdentificationMode(code);
                    if (!EsitoIdentificationMode.CONTEXT_PROPERTY.equals(mode)) continue;
                    esitoIdentificationModeContextPropertyList.put("" + code, this._getEsitoIdentificationModeContextPropertyList(code));
                }
                catch (Exception e) {
                    throw new ProtocolException("Errore durante la gestione del codice [" + code + "]: " + e.getMessage(), e);
                }
            }
        }
    }

    private List<EsitoIdentificationModeContextProperty> _getEsitoIdentificationModeContextPropertyList(Integer codeEsito) throws ProtocolException {
        ArrayList<EsitoIdentificationModeContextProperty> l = null;
        String prefix = "esito." + codeEsito + ".mode.contextProperty.";
        for (int index = 0; index < 1000; ++index) {
            EsitoIdentificationModeContextProperty esito = new EsitoIdentificationModeContextProperty();
            esito.setName(this.getOptionalProperty(prefix + index + ".name"));
            esito.setValue(this.getOptionalProperty(prefix + index + ".value"));
            if (esito.getName() == null && esito.getValue() == null) {
                if (index != 0) break;
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste alcun mapping rispetto alla modalit\u00e0 contextProperty");
            }
            if (esito.getName() == null) {
                throw new ProtocolException("Per il codice [" + codeEsito + "] non esiste il mapping rispetto al nome, obbligtorio per la modalit\u00e0 contextProperty");
            }
            if (l == null) {
                l = new ArrayList<EsitoIdentificationModeContextProperty>();
            }
            l.add(esito);
        }
        return l;
    }

    public List<String> getEsitiTransactionContextCode() throws ProtocolException {
        if (esitiTransactionContextCode == null) {
            this.initEsitiTransactionContextCode();
        }
        return esitiTransactionContextCode;
    }

    private synchronized void initEsitiTransactionContextCode() throws ProtocolException {
        if (esitiTransactionContextCode == null) {
            esitiTransactionContextCode = this.getLista("esiti.transactionContext");
            for (String context : esitiTransactionContextCode) {
                if (context.length() <= 255) continue;
                throw new ProtocolException("Context id [" + context + "] length must be less then 255 characters");
            }
        }
    }

    public List<String> getEsitiTransactionContextCodeOrderLabel() throws ProtocolException {
        if (esitiTransactionContextCodeOrderLabel == null) {
            this.initEsitiTransactionContextCodeOrderLabel();
        }
        return esitiTransactionContextCode;
    }

    private synchronized void initEsitiTransactionContextCodeOrderLabel() throws ProtocolException {
        if (esitiTransactionContextCodeOrderLabel == null) {
            esitiTransactionContextCodeOrderLabel = this.getLista("esiti.transactionContext.labelOrder");
        }
    }

    public List<String> getEsitiTransactionContextOrderLabel() throws ProtocolException {
        if (esitiTransactionContextOrderLabel == null) {
            this.initEsitiTransactionContextOrderLabel();
        }
        return esitiTransactionContextOrderLabel;
    }

    private synchronized void initEsitiTransactionContextOrderLabel() throws ProtocolException {
        if (esitiTransactionContextOrderLabel == null) {
            List<String> codes = this.getEsitiTransactionContextCode();
            esitiTransactionContextOrderLabel = new ArrayList<String>();
            for (String codeTransactionContext : codes) {
                esitiTransactionContextOrderLabel.add(this.getEsitoTransactionContextLabel(codeTransactionContext));
            }
        }
    }

    public String getEsitoTransactionContextLabel(String tipo) throws ProtocolException {
        if (esitoTransactionContextLabel == null) {
            this.initEsitoTransactionContextLabel();
        }
        if (!esitoTransactionContextLabel.containsKey(tipo)) {
            throw new ProtocolException("EsitoTransactionContextLabel for code [" + tipo + "] not found");
        }
        return esitoTransactionContextLabel.get(tipo);
    }

    private synchronized void initEsitoTransactionContextLabel() throws ProtocolException {
        if (esitoTransactionContextLabel == null) {
            esitoTransactionContextLabel = new Hashtable();
            List<String> codes = this.getEsitiTransactionContextCode();
            for (String code : codes) {
                esitoTransactionContextLabel.put(code, this.getProperty("esiti.transactionContext." + code + ".label"));
            }
        }
    }

    public String getEsitoTransactionContextDefault() throws ProtocolException {
        if (esitoTransactionContextDefault_read == null) {
            this.initEsitoTransactionContextDefault();
        }
        return esitoTransactionContextDefault;
    }

    private synchronized void initEsitoTransactionContextDefault() throws ProtocolException {
        if (esitoTransactionContextDefault_read == null) {
            esitoTransactionContextDefault = this.getOptionalProperty("esiti.transactionContext.default");
            esitoTransactionContextDefault_read = true;
            if (esitoTransactionContextDefault != null && !this.getEsitiTransactionContextCode().contains(esitoTransactionContextDefault)) {
                throw new ProtocolException("Indicato nella propriet\u00e0 'esiti.transactionContext.default' un codice di contesto non registrato");
            }
        }
    }

    public String getEsitoTransactionContextHeaderTrasportoName() throws ProtocolException {
        if (esitoTransactionContextHeaderTrasportoName == null) {
            this.initEsitoTransactionContextHeaderTrasportoName();
        }
        return esitoTransactionContextHeaderTrasportoName;
    }

    private synchronized void initEsitoTransactionContextHeaderTrasportoName() throws ProtocolException {
        if (esitoTransactionContextHeaderTrasportoName == null) {
            esitoTransactionContextHeaderTrasportoName = this.getProperty("esiti.transactionContext.trasporto.headerName");
        }
    }

    public String getEsitoTransactionContextFormBasedPropertyName() throws ProtocolException {
        if (esitoTransactionContextFormBasedPropertyName == null) {
            this.initEsitoTransactionContextFormBasedPropertyName();
        }
        return esitoTransactionContextFormBasedPropertyName;
    }

    private synchronized void initEsitoTransactionContextFormBasedPropertyName() throws ProtocolException {
        if (esitoTransactionContextFormBasedPropertyName == null) {
            esitoTransactionContextFormBasedPropertyName = this.getProperty("esiti.transactionContext.urlFormBased.propertyName");
        }
    }

    public List<EsitoTransportContextIdentification> getEsitoTransactionContextHeaderTrasportoDynamicIdentification() throws ProtocolException {
        if (esitoTransactionContextHeaderTrasportoDynamicIdentification == null) {
            this.initEsitoTransactionContextHeaderTrasportoDynamicIdentification();
        }
        return esitoTransactionContextHeaderTrasportoDynamicIdentification;
    }

    private synchronized void initEsitoTransactionContextHeaderTrasportoDynamicIdentification() throws ProtocolException {
        if (esitoTransactionContextHeaderTrasportoDynamicIdentification == null) {
            esitoTransactionContextHeaderTrasportoDynamicIdentification = this.readEsitoTransportContextIdentification("esiti.transactionContext.trasporto.dynamic.");
        }
    }

    public List<EsitoTransportContextIdentification> getEsitoTransactionContextHeaderFormBasedDynamicIdentification() throws ProtocolException {
        if (esitoTransactionContextHeaderFormBasedDynamicIdentification == null) {
            this.initEsitoTransactionContextHeaderFormBasedDynamicIdentification();
        }
        return esitoTransactionContextHeaderFormBasedDynamicIdentification;
    }

    private synchronized void initEsitoTransactionContextHeaderFormBasedDynamicIdentification() throws ProtocolException {
        if (esitoTransactionContextHeaderFormBasedDynamicIdentification == null) {
            esitoTransactionContextHeaderFormBasedDynamicIdentification = this.readEsitoTransportContextIdentification("esiti.transactionContext.urlFormBased.dynamic.");
        }
    }

    private List<EsitoTransportContextIdentification> readEsitoTransportContextIdentification(String pName) throws ProtocolException {
        try {
            ArrayList<EsitoTransportContextIdentification> l = new ArrayList<EsitoTransportContextIdentification>();
            Properties p = this.reader.readProperties_convertEnvProperties(pName);
            if (p.size() > 0) {
                ArrayList<String> keys = new ArrayList<String>();
                Enumeration<Object> enKeys = p.keys();
                while (enKeys.hasMoreElements()) {
                    String key = (String)enKeys.nextElement();
                    if (!key.endsWith(".headerName")) continue;
                    keys.add(key.substring(0, key.length() - ".headerName".length()));
                }
                for (String key : keys) {
                    EsitoTransportContextIdentification etci = new EsitoTransportContextIdentification();
                    etci.setName(p.getProperty(key + ".headerName"));
                    etci.setValue(p.getProperty(key + ".value"));
                    String mode = p.getProperty(key + ".mode");
                    etci.setMode(EsitoTransportContextIdentificationMode.toEnumConstant(mode));
                    if (etci.getMode() == null) {
                        throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per chiave [" + key + "] sconosciuta");
                    }
                    etci.setRegularExpr(p.getProperty(key + ".regularExpr"));
                    if (EsitoTransportContextIdentificationMode.MATCH.equals(etci.getMode())) {
                        if (etci.getRegularExpr() == null) {
                            throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per la chiave [" + key + "] richiede obbligatoriamente la definizione di una espressione regolare");
                        }
                    } else if ((EsitoTransportContextIdentificationMode.EQUALS.equals(etci.getMode()) || EsitoTransportContextIdentificationMode.CONTAINS.equals(etci.getMode())) && etci.getValue() == null) {
                        throw new ProtocolException("Modalit\u00e0 indicata [" + mode + "] per la chiave [" + key + "] richiede obbligatoriamente la definizione di un valore su cui basare il confronto");
                    }
                    etci.setType(p.getProperty(key + ".type"));
                    if (!this.getEsitiTransactionContextCode().contains(etci.getType())) {
                        throw new ProtocolException("Tipo di contesto indicato [" + etci.getType() + "] per la chiave [" + key + "] non risulta tra le tipologie di contesto supportate: " + this.getEsitiTransactionContextCode());
                    }
                    l.add(etci);
                }
            }
            return l;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public String getProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValue_convertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public String getOptionalProperty(String property) throws ProtocolException {
        try {
            String name = null;
            name = this.reader.getValue_convertEnvProperties(property);
            if (name == null) {
                return null;
            }
            return name.trim();
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
    }

    public Boolean getOptionalBooleanProperty(String property) throws ProtocolException {
        String p = this.getOptionalProperty(property);
        if (p != null) {
            try {
                return Boolean.parseBoolean(p);
            }
            catch (Exception e) {
                String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
                this.log.error(msg, (Throwable)e);
                throw new ProtocolException(msg, e);
            }
        }
        return null;
    }

    private List<String> getLista(String property) throws ProtocolException {
        ArrayList<String> lista = null;
        try {
            String name = null;
            name = this.reader.getValue_convertEnvProperties(property);
            if (name == null) {
                throw new Exception("proprieta non definita");
            }
            name = name.trim();
            lista = new ArrayList<String>();
            String[] split = name.split(",");
            if (split == null || split.length <= 0) {
                throw new Exception("proprieta non definita (dopo split?)");
            }
            for (int i = 0; i < split.length; ++i) {
                String p = split[i];
                if (p == null) {
                    throw new Exception("valore " + (i + 1) + " della proprieta non definita");
                }
                if ((p = p.trim()).equals("")) {
                    throw new Exception("valore " + (i + 1) + " della proprieta \u00e8 vuoto");
                }
                if (lista.contains(p)) {
                    throw new Exception("valore " + (i + 1) + " della proprieta \u00e8 definito pi\u00f9 di una volta");
                }
                lista.add(p);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante la lettura della proprieta' '" + property + "': " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            throw new ProtocolException(msg, e);
        }
        return lista;
    }

    private List<Integer> getListaInteger(String property) throws ProtocolException {
        List<String> lista = this.getLista(property);
        ArrayList<Integer> listaInteger = null;
        if (lista != null && lista.size() > 0) {
            listaInteger = new ArrayList<Integer>();
            for (String s : lista) {
                try {
                    listaInteger.add(Integer.parseInt(s));
                }
                catch (Exception e) {
                    throw new ProtocolException("Property [" + property + "] with wrong value (not integer) [" + s + "]");
                }
            }
        }
        return listaInteger;
    }
}

