/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Allegato;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.EsitoElaborazioneMessaggioTracciatura;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.EsitoElaborazioneMessaggioTracciato;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Allegati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Dominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.DominioSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Proprieta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Protocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.TracciaEsitoElaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoEsitoElaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoTraccia;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.xml.soap.SOAPElement;

public class Traccia
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Busta busta;
    private byte[] bustaInByte;
    private SOAPElement bustaInDom;
    protected Hashtable<String, String> properties = new Hashtable();
    private String protocollo;
    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia traccia;
    private List<Allegato> allegati = new ArrayList<Allegato>();

    public Traccia() {
        this.traccia = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia();
    }

    public Traccia(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia traccia) {
        this.traccia = traccia;
        if (traccia.getBusta() != null && traccia.getBusta().getProtocollo() != null) {
            this.protocollo = traccia.getBusta().getProtocollo().getIdentificativo();
        }
        if (traccia.getBusta() != null) {
            this.busta = new Busta(traccia.getBusta());
        }
        if (traccia.getAllegati() != null && traccia.getAllegati().sizeAllegatoList() > 0) {
            for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Allegato allegato : traccia.getAllegati().getAllegatoList()) {
                this.addAllegato(new Allegato(allegato), false);
            }
        }
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia getTraccia() {
        return this.traccia;
    }

    public void setTraccia(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Traccia traccia) {
        this.traccia = traccia;
        if (traccia.getBusta() != null && traccia.getBusta().getProtocollo() != null) {
            this.protocollo = traccia.getBusta().getProtocollo().getIdentificativo();
        }
        if (traccia.getAllegati() != null && traccia.getAllegati().sizeAllegatoList() > 0) {
            for (it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Allegato allegato : traccia.getAllegati().getAllegatoList()) {
                this.addAllegato(new Allegato(allegato), false);
            }
        }
    }

    public Long getId() {
        return this.traccia.getId();
    }

    public void setId(Long id) {
        this.traccia.setId(id);
    }

    public Date getGdo() {
        return this.traccia.getOraRegistrazione();
    }

    public void setGdo(Date value) {
        this.traccia.setOraRegistrazione(value);
    }

    public IDSoggetto getIdSoggetto() {
        IDSoggetto idSoggetto = null;
        if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getSoggetto() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setTipo(this.traccia.getDominio().getSoggetto().getTipo());
                idSoggetto.setNome(this.traccia.getDominio().getSoggetto().getBase());
            }
            if (this.traccia.getDominio().getIdentificativoPorta() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setCodicePorta(this.traccia.getDominio().getIdentificativoPorta());
            }
        }
        return idSoggetto;
    }

    public void setIdSoggetto(IDSoggetto value) {
        if (value != null && (value.getTipo() != null || value.getNome() != null || value.getCodicePorta() != null)) {
            if (value.getTipo() != null || value.getNome() != null) {
                if (this.traccia.getDominio() == null) {
                    this.traccia.setDominio(new Dominio());
                }
                if (this.traccia.getDominio().getSoggetto() == null) {
                    this.traccia.getDominio().setSoggetto(new DominioSoggetto());
                }
                this.traccia.getDominio().getSoggetto().setTipo(value.getTipo());
                this.traccia.getDominio().getSoggetto().setBase(value.getNome());
            } else if (this.traccia.getDominio() != null) {
                this.traccia.getDominio().setSoggetto(null);
            }
            if (value.getCodicePorta() != null) {
                if (this.traccia.getDominio() == null) {
                    this.traccia.setDominio(new Dominio());
                }
                this.traccia.getDominio().setIdentificativoPorta(value.getCodicePorta());
            } else if (this.traccia.getDominio() != null) {
                this.traccia.getDominio().setIdentificativoPorta(null);
            }
        } else if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getFunzione() == null) {
                this.traccia.setDominio(null);
            } else {
                this.traccia.getDominio().setIdentificativoPorta(null);
                this.traccia.getDominio().setSoggetto(null);
            }
        }
    }

    public TipoPdD getTipoPdD() {
        if (this.traccia.getDominio() != null && this.traccia.getDominio().getFunzione() != null) {
            switch (this.traccia.getDominio().getFunzione()) {
                case PORTA_DELEGATA: {
                    return TipoPdD.DELEGATA;
                }
                case PORTA_APPLICATIVA: {
                    return TipoPdD.APPLICATIVA;
                }
                case INTEGRATION_MANAGER: {
                    return TipoPdD.INTEGRATION_MANAGER;
                }
                case ROUTER: {
                    return TipoPdD.ROUTER;
                }
            }
        }
        return null;
    }

    public void setTipoPdD(TipoPdD tipoPdD) {
        if (tipoPdD != null) {
            if (this.traccia.getDominio() == null) {
                this.traccia.setDominio(new Dominio());
            }
            switch (tipoPdD) {
                case DELEGATA: {
                    this.traccia.getDominio().setFunzione(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoPdD.PORTA_DELEGATA);
                    break;
                }
                case APPLICATIVA: {
                    this.traccia.getDominio().setFunzione(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoPdD.PORTA_APPLICATIVA);
                    break;
                }
                case INTEGRATION_MANAGER: {
                    this.traccia.getDominio().setFunzione(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoPdD.INTEGRATION_MANAGER);
                    break;
                }
                case ROUTER: {
                    this.traccia.getDominio().setFunzione(it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.constants.TipoPdD.ROUTER);
                }
            }
        } else if (this.traccia.getDominio() != null) {
            if (this.traccia.getDominio().getIdentificativoPorta() == null && this.traccia.getDominio().getSoggetto() == null) {
                this.traccia.setDominio(null);
            } else {
                this.traccia.getDominio().setFunzione(null);
            }
        }
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia getTipoMessaggio() {
        if (this.traccia.getTipo() != null) {
            switch (this.traccia.getTipo()) {
                case RICHIESTA: {
                    return it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia.RICHIESTA;
                }
                case RISPOSTA: {
                    return it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia.RISPOSTA;
                }
            }
        }
        return null;
    }

    public void setTipoMessaggio(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia value) {
        if (value != null) {
            switch (value) {
                case RICHIESTA: {
                    this.traccia.setTipo(TipoTraccia.RICHIESTA);
                    break;
                }
                case RISPOSTA: {
                    this.traccia.setTipo(TipoTraccia.RISPOSTA);
                }
            }
        }
    }

    public Busta getBusta() {
        return this.busta;
    }

    public void setBusta(Busta value) {
        this.busta = value;
        if (value != null) {
            this.traccia.setBusta(value.getBusta());
        } else {
            this.traccia.setBusta(null);
        }
    }

    public byte[] getBustaAsByteArray() {
        return this.bustaInByte;
    }

    public void setBustaAsByteArray(byte[] bustaInByte) {
        this.bustaInByte = bustaInByte;
    }

    public SOAPElement getBustaAsElement() {
        return this.bustaInDom;
    }

    public void setBustaAsElement(SOAPElement bustaInDom) {
        this.bustaInDom = bustaInDom;
    }

    public String getBustaAsString() {
        return this.traccia.getBustaXml();
    }

    public void setBustaAsString(String bustaAsString) {
        this.traccia.setBustaXml(bustaAsString);
    }

    public String getCorrelazioneApplicativa() {
        return this.traccia.getIdentificativoCorrelazioneRichiesta();
    }

    public void setCorrelazioneApplicativa(String value) {
        this.traccia.setIdentificativoCorrelazioneRichiesta(value);
    }

    public String getCorrelazioneApplicativaRisposta() {
        return this.traccia.getIdentificativoCorrelazioneRisposta();
    }

    public void setCorrelazioneApplicativaRisposta(String value) {
        this.traccia.setIdentificativoCorrelazioneRisposta(value);
    }

    public String getLocation() {
        return this.traccia.getLocation();
    }

    public void setLocation(String value) {
        this.traccia.setLocation(value);
    }

    public void addPropertyInBusta(String key, String value) {
        if (this.traccia.getBusta() == null) {
            this.traccia.setBusta(new it.link.pdd.tools.migrazione_govway.openspcoop2_core.tracciamento.Busta());
        }
        if (this.traccia.getBusta().getProtocollo() == null) {
            this.traccia.getBusta().setProtocollo(new Protocollo());
        }
        if (this.traccia.getBusta().getProtocollo().getProprietaList() == null) {
            this.traccia.getBusta().getProtocollo().setProprietaList(new ArrayList<Proprieta>());
        }
        boolean exists = false;
        for (int i = 0; i < this.traccia.getBusta().getProtocollo().sizeProprietaList(); ++i) {
            Proprieta p = this.traccia.getBusta().getProtocollo().getProprieta(i);
            if (!key.equals(p.getNome())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Proprieta proprieta = new Proprieta();
            proprieta.setNome(key);
            proprieta.setValore(value);
            this.traccia.getBusta().getProtocollo().addProprieta(proprieta);
        }
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public int sizeProperties() {
        return this.properties.size();
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if ((value == null || "".equals(value)) && "ID".equals(key) && this.traccia.getBusta() != null && this.traccia.getBusta().getProtocollo() != null && this.traccia.getBusta().getProtocollo().getProprietaList() != null) {
            for (int i = 0; i < this.traccia.getBusta().getProtocollo().sizeProprietaList(); ++i) {
                Proprieta p = this.traccia.getBusta().getProtocollo().getProprieta(i);
                if (!"ID".equals(p.getNome())) continue;
                return p.getValore();
            }
        }
        return value;
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public String[] getPropertiesValues() {
        return this.properties.values().toArray(new String[this.properties.size()]);
    }

    public String[] getPropertiesNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public void setProperties(Hashtable<String, String> params) {
        this.properties = params;
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public EsitoElaborazioneMessaggioTracciato getEsitoElaborazioneMessaggioTracciato() {
        if (this.traccia.getEsitoElaborazione() != null) {
            EsitoElaborazioneMessaggioTracciato esito = new EsitoElaborazioneMessaggioTracciato();
            esito.setDettaglio(this.traccia.getEsitoElaborazione().getDettaglio());
            if (this.traccia.getEsitoElaborazione().getTipo() != null) {
                switch (this.traccia.getEsitoElaborazione().getTipo()) {
                    case INVIATO: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.INVIATO);
                        break;
                    }
                    case RICEVUTO: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.RICEVUTO);
                        break;
                    }
                    case ERRORE: {
                        esito.setEsito(EsitoElaborazioneMessaggioTracciatura.ERRORE);
                    }
                }
            }
            return esito;
        }
        return null;
    }

    public void setEsitoElaborazioneMessaggioTracciato(EsitoElaborazioneMessaggioTracciato esitoElaborazioneMessaggioTracciato) {
        if (esitoElaborazioneMessaggioTracciato == null) {
            return;
        }
        if (this.traccia.getEsitoElaborazione() == null) {
            this.traccia.setEsitoElaborazione(new TracciaEsitoElaborazione());
        }
        this.traccia.getEsitoElaborazione().setDettaglio(esitoElaborazioneMessaggioTracciato.getDettaglio());
        if (esitoElaborazioneMessaggioTracciato.getEsito() != null) {
            switch (esitoElaborazioneMessaggioTracciato.getEsito()) {
                case INVIATO: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.INVIATO);
                    break;
                }
                case RICEVUTO: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.RICEVUTO);
                    break;
                }
                case ERRORE: {
                    this.traccia.getEsitoElaborazione().setTipo(TipoEsitoElaborazione.ERRORE);
                }
            }
        }
    }

    public List<Allegato> getListaAllegati() {
        return this.allegati;
    }

    public int sizeListaAllegati() {
        return this.allegati.size();
    }

    public void addAllegato(Allegato a) {
        this.addAllegato(a, true);
    }

    private void addAllegato(Allegato a, boolean addCore) {
        this.allegati.add(a);
        if (addCore) {
            if (this.traccia.getAllegati() == null) {
                this.traccia.setAllegati(new Allegati());
            }
            this.traccia.getAllegati().addAllegato(a.getAllegato());
        }
    }

    public Allegato getAllegato(int index) {
        return this.allegati.get(index);
    }

    public Allegato removeAllegato(int index) {
        this.traccia.getAllegati().removeAllegato(index);
        return this.allegati.remove(index);
    }

    protected void setListaAllegati(List<Allegato> listaAllegati) {
        this.allegati = listaAllegati;
    }

    public Traccia clone() {
        Traccia clone = new Traccia();
        clone.setId(this.getId() != null ? Long.valueOf(this.getId()) : null);
        clone.setGdo(this.getGdo() != null ? new Date(this.getGdo().getTime()) : null);
        clone.setIdSoggetto(this.getIdSoggetto() != null ? this.getIdSoggetto().clone() : null);
        clone.setTipoPdD(this.getTipoPdD());
        clone.setTipoMessaggio(this.getTipoMessaggio());
        clone.setBusta(this.getBusta() != null ? this.getBusta().clone() : null);
        ByteArrayOutputStream bout = null;
        if (this.getBustaAsByteArray() != null) {
            bout = new ByteArrayOutputStream();
            try {
                bout.write(this.getBustaAsByteArray());
                bout.flush();
                bout.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            clone.setBustaAsByteArray(bout.toByteArray());
        }
        clone.setBustaAsElement(this.getBustaAsElement());
        clone.setBustaAsString(this.getBustaAsString() != null ? new String(this.getBustaAsString()) : null);
        clone.setCorrelazioneApplicativa(this.getCorrelazioneApplicativa() != null ? new String(this.getCorrelazioneApplicativa()) : null);
        clone.setCorrelazioneApplicativaRisposta(this.getCorrelazioneApplicativaRisposta() != null ? new String(this.getCorrelazioneApplicativaRisposta()) : null);
        clone.setLocation(this.getLocation() != null ? new String(this.getLocation()) : null);
        clone.setEsitoElaborazioneMessaggioTracciato(this.getEsitoElaborazioneMessaggioTracciato() != null ? this.getEsitoElaborazioneMessaggioTracciato().clone() : null);
        if (this.properties != null && this.properties.size() > 0) {
            Enumeration<String> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = this.properties.get(key);
                if (key == null || value == null) continue;
                clone.addProperty(new String(key), new String(value));
            }
        }
        clone.setProtocollo(this.protocollo != null ? new String(this.protocollo) : null);
        for (int i = 0; i < this.sizeListaAllegati(); ++i) {
            clone.addAllegato(this.getAllegato(i).clone());
        }
        return clone;
    }
}

