/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoTraccia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.InformazioniProtocollo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

public class FiltroRicercaTracce
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Date maxDate;
    protected Date minDate;
    protected TipoTraccia tipoTraccia;
    protected TipoPdD tipoPdD;
    protected IDSoggetto dominio;
    protected String idBusta;
    protected String idBustaRichiesta;
    protected String idBustaRisposta;
    protected String riferimentoMessaggio;
    protected boolean ricercaSoloBusteErrore;
    protected InformazioniProtocollo informazioniProtocollo;
    protected String servizioApplicativoFruitore;
    protected String servizioApplicativoErogatore;
    protected String idCorrelazioneApplicativa;
    protected String idCorrelazioneApplicativaRisposta;
    protected boolean idCorrelazioneApplicativaOrMatch = false;
    protected String protocollo;
    protected Hashtable<String, String> properties = new Hashtable();
    protected List<IDSoggetto> filtroSoggetti = new ArrayList<IDSoggetto>();

    public void addFiltroSoggetto(IDSoggetto soggetto) {
        this.filtroSoggetti.add(soggetto);
    }

    public int sizeFiltroSoggetti() {
        return this.filtroSoggetti.size();
    }

    public IDSoggetto getFiltroSoggetto(int i) {
        return this.filtroSoggetti.get(i);
    }

    public IDSoggetto removeFiltroSoggetto(int i) {
        return this.filtroSoggetti.remove(i);
    }

    public List<IDSoggetto> getFiltroSoggetti() {
        return this.filtroSoggetti;
    }

    public void setFiltroSoggetti(List<IDSoggetto> list) {
        this.filtroSoggetti = list;
    }

    public String getIdCorrelazioneApplicativa() {
        return this.idCorrelazioneApplicativa;
    }

    public void setIdCorrelazioneApplicativa(String value) {
        this.idCorrelazioneApplicativa = value;
    }

    public String getIdBusta() {
        return this.idBusta;
    }

    public void setIdBusta(String value) {
        this.idBusta = value;
    }

    public String getIdBustaRichiesta() {
        return this.idBustaRichiesta;
    }

    public void setIdBustaRichiesta(String value) {
        this.idBustaRichiesta = value;
    }

    public String getIdBustaRisposta() {
        return this.idBustaRisposta;
    }

    public void setIdBustaRisposta(String value) {
        this.idBustaRisposta = value;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(Date value) {
        this.maxDate = value;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public void setMinDate(Date value) {
        this.minDate = value;
    }

    public Hashtable<String, String> getProperty() {
        return this.properties;
    }

    public TipoTraccia getTipoTraccia() {
        return this.tipoTraccia;
    }

    public void setTipoTraccia(TipoTraccia value) {
        this.tipoTraccia = value;
    }

    public String getIdCorrelazioneApplicativaRisposta() {
        return this.idCorrelazioneApplicativaRisposta;
    }

    public void setIdCorrelazioneApplicativaRisposta(String idCorrelazioneApplicativaRisposta) {
        this.idCorrelazioneApplicativaRisposta = idCorrelazioneApplicativaRisposta;
    }

    public boolean isIdCorrelazioneApplicativaOrMatch() {
        return this.idCorrelazioneApplicativaOrMatch;
    }

    public void setIdCorrelazioneApplicativaOrMatch(boolean correlazioneApplicativaOrMatch) {
        this.idCorrelazioneApplicativaOrMatch = correlazioneApplicativaOrMatch;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public int sizeProperties() {
        return this.properties.size();
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public String[] getPropertiesValues() {
        return this.properties.values().toArray(new String[this.properties.size()]);
    }

    public String[] getPropertiesNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public void setProperties(Hashtable<String, String> params) {
        this.properties = params;
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public String getProtocollo() {
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public String getServizioApplicativoFruitore() {
        return this.servizioApplicativoFruitore;
    }

    public void setServizioApplicativoFruitore(String servizioApplicativoFruitore) {
        this.servizioApplicativoFruitore = servizioApplicativoFruitore;
    }

    public String getServizioApplicativoErogatore() {
        return this.servizioApplicativoErogatore;
    }

    public void setServizioApplicativoErogatore(String servizioApplicativoErogatore) {
        this.servizioApplicativoErogatore = servizioApplicativoErogatore;
    }

    public TipoPdD getTipoPdD() {
        return this.tipoPdD;
    }

    public void setTipoPdD(TipoPdD tipoPdD) {
        this.tipoPdD = tipoPdD;
    }

    public IDSoggetto getDominio() {
        return this.dominio;
    }

    public void setDominio(IDSoggetto dominio) {
        this.dominio = dominio;
    }

    public String getRiferimentoMessaggio() {
        return this.riferimentoMessaggio;
    }

    public void setRiferimentoMessaggio(String riferimentoMessaggio) {
        this.riferimentoMessaggio = riferimentoMessaggio;
    }

    public boolean isRicercaSoloBusteErrore() {
        return this.ricercaSoloBusteErrore;
    }

    public void setRicercaSoloBusteErrore(boolean ricercaSoloBusteErrore) {
        this.ricercaSoloBusteErrore = ricercaSoloBusteErrore;
    }

    public InformazioniProtocollo getInformazioniProtocollo() {
        return this.informazioniProtocollo;
    }

    public void setInformazioniProtocollo(InformazioniProtocollo informazioniProtocollo) {
        this.informazioniProtocollo = informazioniProtocollo;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append("Filtro Ricerca traccia:");
        if (this.minDate != null) {
            bf.append(" [intervallo-inferiore-data:" + this.minDate + "]");
        }
        if (this.maxDate != null) {
            bf.append(" [intervallo-superiore-data:" + this.maxDate + "]");
        }
        if (this.tipoTraccia != null) {
            bf.append(" [tipo-traccia:" + this.tipoTraccia + "]");
        }
        if (this.tipoPdD != null) {
            bf.append(" [tipo-porta-dominio:" + this.tipoPdD.getTipo() + "]");
        }
        if (this.dominio != null) {
            if (this.dominio.getCodicePorta() != null) {
                bf.append(" [identificativo-porta.codice-porta:" + this.dominio.getCodicePorta() + "]");
            }
            if (this.dominio.getTipo() != null) {
                bf.append(" [identificativo-porta.tipo:" + this.dominio.getTipo() + "]");
            }
            if (this.dominio.getNome() != null) {
                bf.append(" [identificativo-porta.nome:" + this.dominio.getNome() + "]");
            }
        }
        if (this.idBusta != null) {
            bf.append(" [id-busta:" + this.idBusta + "]");
        }
        if (this.idBustaRichiesta != null) {
            bf.append(" [id-busta-richiesta:" + this.idBustaRichiesta + "]");
        }
        if (this.idBustaRisposta != null) {
            bf.append(" [id-busta-risposta:" + this.idBustaRisposta + "]");
        }
        if (this.riferimentoMessaggio != null) {
            bf.append(" [riferimento-messaggio:" + this.riferimentoMessaggio + "]");
        }
        if (this.ricercaSoloBusteErrore) {
            bf.append(" [ricerca-solo-buste-errore]");
        }
        if (this.informazioniProtocollo != null) {
            bf.append(this.informazioniProtocollo.toString());
        }
        if (this.servizioApplicativoFruitore != null) {
            bf.append(" [saFruitore:" + this.servizioApplicativoFruitore + "]");
        }
        if (this.servizioApplicativoErogatore != null) {
            bf.append(" [saErogatore:" + this.servizioApplicativoErogatore + "]");
        }
        if (this.idCorrelazioneApplicativa != null) {
            bf.append(" [id-correlazione-applicativa:" + this.idCorrelazioneApplicativa + "]");
        }
        if (this.idCorrelazioneApplicativaRisposta != null) {
            bf.append(" [id-correlazione-applicativa-risposta:" + this.idCorrelazioneApplicativaRisposta + "]");
        }
        if (this.idCorrelazioneApplicativa != null && this.idCorrelazioneApplicativaRisposta != null) {
            bf.append(" [id-correlazione-applicativa-or-match:" + this.idCorrelazioneApplicativaOrMatch + "]");
        }
        if (this.protocollo != null) {
            bf.append(" [protocollo:" + this.protocollo + "]");
        }
        if (this.properties != null) {
            bf.append(" [properties:" + this.properties.size() + "]");
        }
        if (bf.length() == "Filtro Ricerca traccia:".length()) {
            bf.append(" nessun filtro presente");
        }
        return bf.toString();
    }
}

