/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.DominioSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.DominioTransazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.InformazioniProtocolloTransazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.Proprieta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.Protocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.SoggettoIdentificativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.diagnostica.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.InformazioniProtocollo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class MsgDiagnosticoCorrelazione
implements Serializable {
    private static final long serialVersionUID = 7616051015989365464L;
    private InformazioniProtocolloTransazione infoProtocolloTransazione;

    public MsgDiagnosticoCorrelazione() {
        this.infoProtocolloTransazione = new InformazioniProtocolloTransazione();
    }

    public MsgDiagnosticoCorrelazione(InformazioniProtocolloTransazione infoProtocolloTransazione) {
        this.infoProtocolloTransazione = infoProtocolloTransazione;
    }

    public InformazioniProtocolloTransazione getInformazioniProtocolloTransazione() {
        return this.infoProtocolloTransazione;
    }

    public void setInformazioniProtocolloTransazione(InformazioniProtocolloTransazione infoProtocolloTransazione) {
        this.infoProtocolloTransazione = infoProtocolloTransazione;
    }

    public Long getId() {
        return this.infoProtocolloTransazione.getId();
    }

    public void setId(Long id) {
        this.infoProtocolloTransazione.setId(id);
    }

    public boolean isDelegata() {
        switch (this.infoProtocolloTransazione.getTipoPdD()) {
            case PORTA_DELEGATA: {
                return true;
            }
            case PORTA_APPLICATIVA: {
                return false;
            }
        }
        return false;
    }

    public void setDelegata(boolean isDelegata) {
        if (isDelegata) {
            this.infoProtocolloTransazione.setTipoPdD(TipoPdD.PORTA_DELEGATA);
        } else {
            this.infoProtocolloTransazione.setTipoPdD(TipoPdD.PORTA_APPLICATIVA);
        }
    }

    public String getIdBusta() {
        return this.infoProtocolloTransazione.getIdentificativoRichiesta();
    }

    public void setIdBusta(String idBusta) {
        this.infoProtocolloTransazione.setIdentificativoRichiesta(idBusta);
    }

    public IDSoggetto getIdSoggetto() {
        if (this.infoProtocolloTransazione.getDominio() != null) {
            IDSoggetto idSoggetto = null;
            if (this.infoProtocolloTransazione.getDominio().getIdentificativoPorta() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setCodicePorta(this.infoProtocolloTransazione.getDominio().getIdentificativoPorta());
            }
            if (this.infoProtocolloTransazione.getDominio().getSoggetto() != null) {
                if (idSoggetto == null) {
                    idSoggetto = new IDSoggetto();
                }
                idSoggetto.setTipo(this.infoProtocolloTransazione.getDominio().getSoggetto().getTipo());
                idSoggetto.setNome(this.infoProtocolloTransazione.getDominio().getSoggetto().getBase());
            }
            return idSoggetto;
        }
        return null;
    }

    public void setIdSoggetto(IDSoggetto idPorta) {
        if (idPorta != null) {
            if (this.infoProtocolloTransazione.getDominio() == null) {
                this.infoProtocolloTransazione.setDominio(new DominioTransazione());
            }
            this.infoProtocolloTransazione.getDominio().setIdentificativoPorta(idPorta.getCodicePorta());
            if (this.infoProtocolloTransazione.getDominio().getSoggetto() == null) {
                this.infoProtocolloTransazione.getDominio().setSoggetto(new DominioSoggetto());
            }
            this.infoProtocolloTransazione.getDominio().getSoggetto().setBase(idPorta.getNome());
            this.infoProtocolloTransazione.getDominio().getSoggetto().setTipo(idPorta.getTipo());
        } else {
            this.infoProtocolloTransazione.setDominio(null);
        }
    }

    public InformazioniProtocollo getInformazioniProtocollo() {
        IDSoggetto fruitore = null;
        if (this.infoProtocolloTransazione.getFruitore() != null) {
            if (this.infoProtocolloTransazione.getFruitore().getIdentificativoPorta() != null) {
                if (fruitore == null) {
                    fruitore = new IDSoggetto();
                }
                fruitore.setCodicePorta(this.infoProtocolloTransazione.getFruitore().getIdentificativoPorta());
            }
            if (this.infoProtocolloTransazione.getFruitore().getIdentificativo() != null) {
                if (this.infoProtocolloTransazione.getFruitore().getIdentificativo().getBase() != null) {
                    if (fruitore == null) {
                        fruitore = new IDSoggetto();
                    }
                    fruitore.setNome(this.infoProtocolloTransazione.getFruitore().getIdentificativo().getBase());
                }
                if (this.infoProtocolloTransazione.getFruitore().getIdentificativo().getTipo() != null) {
                    if (fruitore == null) {
                        fruitore = new IDSoggetto();
                    }
                    fruitore.setTipo(this.infoProtocolloTransazione.getFruitore().getIdentificativo().getTipo());
                }
            }
        }
        IDSoggetto erogatore = null;
        if (this.infoProtocolloTransazione.getErogatore() != null) {
            if (this.infoProtocolloTransazione.getErogatore().getIdentificativoPorta() != null) {
                if (erogatore == null) {
                    erogatore = new IDSoggetto();
                }
                erogatore.setCodicePorta(this.infoProtocolloTransazione.getErogatore().getIdentificativoPorta());
            }
            if (this.infoProtocolloTransazione.getErogatore().getIdentificativo() != null) {
                if (this.infoProtocolloTransazione.getErogatore().getIdentificativo().getBase() != null) {
                    if (erogatore == null) {
                        erogatore = new IDSoggetto();
                    }
                    erogatore.setNome(this.infoProtocolloTransazione.getErogatore().getIdentificativo().getBase());
                }
                if (this.infoProtocolloTransazione.getErogatore().getIdentificativo().getTipo() != null) {
                    if (erogatore == null) {
                        erogatore = new IDSoggetto();
                    }
                    erogatore.setTipo(this.infoProtocolloTransazione.getErogatore().getIdentificativo().getTipo());
                }
            }
        }
        String nomeServizio = null;
        String tipoServizio = null;
        Integer versioneServizio = null;
        boolean existsDatiServizio = false;
        if (this.infoProtocolloTransazione.getServizio() != null) {
            nomeServizio = this.infoProtocolloTransazione.getServizio().getBase();
            tipoServizio = this.infoProtocolloTransazione.getServizio().getTipo();
            versioneServizio = this.infoProtocolloTransazione.getServizio().getVersione();
            existsDatiServizio = true;
        }
        String azione = this.infoProtocolloTransazione.getAzione();
        InformazioniProtocollo info = null;
        if (fruitore != null || erogatore != null || existsDatiServizio || azione != null) {
            info = new InformazioniProtocollo();
            info.setFruitore(fruitore);
            info.setErogatore(erogatore);
            info.setTipoServizio(tipoServizio);
            info.setServizio(nomeServizio);
            info.setVersioneServizio(versioneServizio);
            info.setAzione(azione);
        }
        return info;
    }

    public void setInformazioniProtocollo(InformazioniProtocollo informazioniBusta) {
        if (informazioniBusta != null) {
            if (informazioniBusta.getFruitore() != null && (informazioniBusta.getFruitore().getCodicePorta() != null || informazioniBusta.getFruitore().getTipo() != null || informazioniBusta.getFruitore().getNome() != null)) {
                if (this.infoProtocolloTransazione.getFruitore() == null) {
                    this.infoProtocolloTransazione.setFruitore(new Soggetto());
                }
                this.infoProtocolloTransazione.getFruitore().setIdentificativoPorta(informazioniBusta.getFruitore().getCodicePorta());
                if (informazioniBusta.getFruitore().getTipo() != null || informazioniBusta.getFruitore().getNome() != null) {
                    if (this.infoProtocolloTransazione.getFruitore().getIdentificativo() == null) {
                        this.infoProtocolloTransazione.getFruitore().setIdentificativo(new SoggettoIdentificativo());
                    }
                    this.infoProtocolloTransazione.getFruitore().getIdentificativo().setBase(informazioniBusta.getFruitore().getNome());
                    this.infoProtocolloTransazione.getFruitore().getIdentificativo().setTipo(informazioniBusta.getFruitore().getTipo());
                } else {
                    this.infoProtocolloTransazione.getFruitore().setIdentificativo(null);
                }
            } else {
                this.infoProtocolloTransazione.setFruitore(null);
            }
            if (informazioniBusta.getErogatore() != null && (informazioniBusta.getErogatore().getCodicePorta() != null || informazioniBusta.getErogatore().getTipo() != null || informazioniBusta.getErogatore().getNome() != null)) {
                if (this.infoProtocolloTransazione.getErogatore() == null) {
                    this.infoProtocolloTransazione.setErogatore(new Soggetto());
                }
                this.infoProtocolloTransazione.getErogatore().setIdentificativoPorta(informazioniBusta.getErogatore().getCodicePorta());
                if (informazioniBusta.getErogatore().getTipo() != null || informazioniBusta.getErogatore().getNome() != null) {
                    if (this.infoProtocolloTransazione.getErogatore().getIdentificativo() == null) {
                        this.infoProtocolloTransazione.getErogatore().setIdentificativo(new SoggettoIdentificativo());
                    }
                    this.infoProtocolloTransazione.getErogatore().getIdentificativo().setBase(informazioniBusta.getErogatore().getNome());
                    this.infoProtocolloTransazione.getErogatore().getIdentificativo().setTipo(informazioniBusta.getErogatore().getTipo());
                } else {
                    this.infoProtocolloTransazione.getErogatore().setIdentificativo(null);
                }
            } else {
                this.infoProtocolloTransazione.setErogatore(null);
            }
            if (informazioniBusta.getServizio() != null || informazioniBusta.getTipoServizio() != null || informazioniBusta.getVersioneServizio() != null) {
                if (this.infoProtocolloTransazione.getServizio() == null) {
                    this.infoProtocolloTransazione.setServizio(new Servizio());
                }
                this.infoProtocolloTransazione.getServizio().setBase(informazioniBusta.getServizio());
                this.infoProtocolloTransazione.getServizio().setTipo(informazioniBusta.getTipoServizio());
                this.infoProtocolloTransazione.getServizio().setVersione(informazioniBusta.getVersioneServizio());
            } else {
                this.infoProtocolloTransazione.setServizio(null);
            }
            this.infoProtocolloTransazione.setAzione(informazioniBusta.getAzione());
        } else {
            this.infoProtocolloTransazione.setFruitore(null);
            this.infoProtocolloTransazione.setErogatore(null);
            this.infoProtocolloTransazione.setServizio(null);
            this.infoProtocolloTransazione.setAzione(null);
        }
    }

    public Date getGdo() {
        return this.infoProtocolloTransazione.getOraRegistrazione();
    }

    public void setGdo(Date gdo) {
        this.infoProtocolloTransazione.setOraRegistrazione(gdo);
    }

    public String getNomePorta() {
        return this.infoProtocolloTransazione.getNomePorta();
    }

    public void setNomePorta(String nomePorta) {
        this.infoProtocolloTransazione.setNomePorta(nomePorta);
    }

    public List<String> getServiziApplicativiList() {
        return this.infoProtocolloTransazione.getServizioApplicativoList();
    }

    public void setServiziApplicativiList(List<String> serviziApplicativiList) {
        this.infoProtocolloTransazione.setServizioApplicativoList(serviziApplicativiList);
    }

    public int sizeServiziApplicativiList() {
        return this.infoProtocolloTransazione.sizeServizioApplicativoList();
    }

    public String getCorrelazioneApplicativa() {
        return this.infoProtocolloTransazione.getIdentificativoCorrelazioneRichiesta();
    }

    public void setCorrelazioneApplicativa(String correlazioneApplicativa) {
        this.infoProtocolloTransazione.setIdentificativoCorrelazioneRichiesta(correlazioneApplicativa);
    }

    public String getCorrelazioneApplicativaRisposta() {
        return this.infoProtocolloTransazione.getIdentificativoCorrelazioneRisposta();
    }

    public void setCorrelazioneApplicativaRisposta(String correlazioneApplicativaRisposta) {
        this.infoProtocolloTransazione.setIdentificativoCorrelazioneRisposta(correlazioneApplicativaRisposta);
    }

    public String getProtocollo() {
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            return this.infoProtocolloTransazione.getProtocollo().getIdentificativo();
        }
        return null;
    }

    public void setProtocollo(String protocollo) {
        if (protocollo != null) {
            if (this.infoProtocolloTransazione.getProtocollo() == null) {
                this.infoProtocolloTransazione.setProtocollo(new Protocollo());
            }
            this.infoProtocolloTransazione.getProtocollo().setIdentificativo(protocollo);
        } else if (this.infoProtocolloTransazione.getProtocollo() != null) {
            if (this.infoProtocolloTransazione.getProtocollo().sizeProprietaList() <= 0) {
                this.infoProtocolloTransazione.setProtocollo(null);
            } else {
                this.infoProtocolloTransazione.getProtocollo().setIdentificativo(null);
            }
        }
    }

    public void addProperty(String key, String value) {
        if (value != null && !"".equals(value)) {
            if (this.infoProtocolloTransazione.getProtocollo() == null) {
                this.infoProtocolloTransazione.setProtocollo(new Protocollo());
            }
            Proprieta proprieta = new Proprieta();
            proprieta.setNome(key);
            proprieta.setValore(value);
            this.infoProtocolloTransazione.getProtocollo().addProprieta(proprieta);
        }
    }

    public int sizeProperties() {
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            return this.infoProtocolloTransazione.getProtocollo().sizeProprietaList();
        }
        return 0;
    }

    public String getProperty(String key) {
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            for (int i = 0; i < this.infoProtocolloTransazione.getProtocollo().sizeProprietaList(); ++i) {
                Proprieta proprieta = this.infoProtocolloTransazione.getProtocollo().getProprieta(i);
                if (!proprieta.getNome().equals(key)) continue;
                return proprieta.getValore();
            }
        }
        return null;
    }

    public String removeProperty(String key) {
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            for (int i = 0; i < this.infoProtocolloTransazione.getProtocollo().sizeProprietaList(); ++i) {
                Proprieta proprieta = this.infoProtocolloTransazione.getProtocollo().getProprieta(i);
                if (!proprieta.getNome().equals(key)) continue;
                this.infoProtocolloTransazione.getProtocollo().removeProprieta(i);
                return proprieta.getValore();
            }
        }
        return null;
    }

    public String[] getPropertiesValues() {
        ArrayList<String> propertiesValues = new ArrayList<String>();
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            for (int i = 0; i < this.infoProtocolloTransazione.getProtocollo().sizeProprietaList(); ++i) {
                Proprieta proprieta = this.infoProtocolloTransazione.getProtocollo().getProprieta(i);
                propertiesValues.add(proprieta.getValore());
            }
        }
        if (propertiesValues.size() > 0) {
            return propertiesValues.toArray(new String[1]);
        }
        return null;
    }

    public String[] getPropertiesNames() {
        ArrayList<String> propertiesValues = new ArrayList<String>();
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            for (int i = 0; i < this.infoProtocolloTransazione.getProtocollo().sizeProprietaList(); ++i) {
                Proprieta proprieta = this.infoProtocolloTransazione.getProtocollo().getProprieta(i);
                propertiesValues.add(proprieta.getNome());
            }
        }
        if (propertiesValues.size() > 0) {
            return propertiesValues.toArray(new String[1]);
        }
        return null;
    }

    public void setProperties(Hashtable<String, String> params) {
        Enumeration<String> keys = params.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.addProperty(key, params.get(key));
        }
    }

    public Hashtable<String, String> getProperties() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        if (this.infoProtocolloTransazione.getProtocollo() != null) {
            for (int i = 0; i < this.infoProtocolloTransazione.getProtocollo().sizeProprietaList(); ++i) {
                Proprieta proprieta = this.infoProtocolloTransazione.getProtocollo().getProprieta(i);
                map.put(proprieta.getNome(), proprieta.getValore());
            }
        }
        return map;
    }
}

