/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPFaultCode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.KeyValueObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ErroreIntegrazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String descrizione;
    private CodiceErroreIntegrazione codiceErrore;
    private List<KeyValueObject> keyValueObjects = new ArrayList<KeyValueObject>();
    private final SOAPFaultCode soapFaultCode;
    private String codiceCustom;

    public String getCodiceCustom() {
        return this.codiceCustom;
    }

    public void setCodiceCustom(String codiceCustom) {
        this.codiceCustom = codiceCustom;
    }

    public ErroreIntegrazione(String descrizione, CodiceErroreIntegrazione codiceErrore, KeyValueObject ... keyValueObjects) {
        this.descrizione = descrizione;
        this.codiceErrore = codiceErrore;
        if (keyValueObjects != null) {
            for (int i = 0; i < keyValueObjects.length; ++i) {
                this.keyValueObjects.add(keyValueObjects[i]);
            }
        }
        this.soapFaultCode = null;
    }

    public ErroreIntegrazione(String descrizione, CodiceErroreIntegrazione codiceErrore, SOAPFaultCode soapFaultCode, KeyValueObject ... keyValueObjects) {
        this.descrizione = descrizione;
        this.codiceErrore = codiceErrore;
        if (keyValueObjects != null) {
            for (int i = 0; i < keyValueObjects.length; ++i) {
                this.keyValueObjects.add(keyValueObjects[i]);
            }
        }
        this.soapFaultCode = soapFaultCode;
    }

    public String getDescrizioneRawValue() {
        return this.replaceAll(this.descrizione);
    }

    public String getDescrizione(IProtocolFactory protocolFactory) throws ProtocolException {
        return this.replaceAll(protocolFactory.createTraduttore().toString(this));
    }

    protected void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public CodiceErroreIntegrazione getCodiceErrore() {
        return this.codiceErrore;
    }

    protected void setCodiceErrore(CodiceErroreIntegrazione codiceErrore) {
        this.codiceErrore = codiceErrore;
    }

    public SOAPFaultCode getSoapFaultCode() {
        return this.soapFaultCode;
    }

    public List<KeyValueObject> getKeyValueObjects() {
        return this.keyValueObjects;
    }

    protected void addKeyValueObject(KeyValueObject o) {
        this.keyValueObjects.add(o);
    }

    private String replaceAll(String v) {
        if (v == null) {
            return null;
        }
        String tmp = new String(v);
        for (int i = 0; i < this.keyValueObjects.size(); ++i) {
            KeyValueObject keyValue = this.keyValueObjects.get(i);
            String key = keyValue.getKey();
            int limite = 100;
            for (int index = 0; tmp.contains(key) && index < limite; ++index) {
                tmp = tmp.replace(key, keyValue.getValue());
            }
        }
        return tmp;
    }

    public String toString() {
        try {
            return this.toString(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString(IProtocolFactory protocolFactory) throws ProtocolException {
        StringBuffer bf = new StringBuffer();
        if (this.descrizione != null) {
            bf.append(" descrizione errore: ");
            if (protocolFactory == null) {
                bf.append(this.getDescrizioneRawValue());
            } else {
                bf.append(this.getDescrizione(protocolFactory));
            }
        }
        if (this.codiceErrore != null) {
            bf.append(" codice errore: ");
            if (protocolFactory == null) {
                bf.append(this.codiceErrore.toString());
            } else {
                bf.append(protocolFactory.createTraduttore().toString(this.codiceErrore, null, false));
            }
        }
        if (bf.length() > 0) {
            return bf.toString().substring(1);
        }
        return null;
    }
}

