/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErrore;
import java.io.Serializable;

public enum CodiceErroreCooperazione implements CodiceErrore,
Serializable
{
    UNKNOWN(0),
    FORMATO_NON_CORRETTO(1),
    FORMATO_INTESTAZIONE_NON_PRESENTE(2),
    FORMATO_INTESTAZIONE_NON_CORRETTO(3),
    FORMATO_CORPO_NON_PRESENTE(4),
    FORMATO_CORPO_NON_CORRETTO(5),
    ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO(6),
    INTESTAZIONE_NON_CORRETTA(51),
    INTESTAZIONE_PRESENTE_PIU_VOLTE(52),
    INTESTAZIONE_ACTOR_NON_PRESENTE(53),
    INTESTAZIONE_ACTOR_NON_VALORIZZATO(54),
    INTESTAZIONE_ACTOR_NON_VALIDO(55),
    INTESTAZIONE_ACTOR_SCONOSCIUTO(56),
    INTESTAZIONE_MUST_UNDERSTAND_NON_PRESENTE(57),
    INTESTAZIONE_MUST_UNDERSTAND_NON_VALORIZZATO(58),
    INTESTAZIONE_MUST_UNDERSTAND_NON_VALIDO(59),
    INTESTAZIONE_MUST_UNDERSTAND_SCONOSCIUTO(60),
    MITTENTE(100),
    MITTENTE_NON_PRESENTE(101),
    TIPO_MITTENTE_NON_PRESENTE(102),
    IDPORTA_MITTENTE_NON_PRESENTE(103),
    INDIRIZZO_MITTENTE_NON_PRESENTE(104),
    MITTENTE_PRESENTE_PIU_VOLTE(105),
    TIPO_MITTENTE_PRESENTE_PIU_VOLTE(106),
    IDPORTA_MITTENTE_PRESENTE_PIU_VOLTE(107),
    INDIRIZZO_MITTENTE_PRESENTE_PIU_VOLTE(108),
    MITTENTE_NON_VALORIZZATO(109),
    TIPO_MITTENTE_NON_VALORIZZATO(110),
    IDPORTA_MITTENTE_NON_VALORIZZATO(111),
    INDIRIZZO_MITTENTE_NON_VALORIZZATO(112),
    MITTENTE_NON_VALIDO(113),
    TIPO_MITTENTE_NON_VALIDO(114),
    IDPORTA_MITTENTE_NON_VALIDO(115),
    INDIRIZZO_MITTENTE_NON_VALIDO(116),
    MITTENTE_SCONOSCIUTO(117),
    TIPO_MITTENTE_SCONOSCIUTO(118),
    IDPORTA_MITTENTE_SCONOSCIUTO(119),
    INDIRIZZO_MITTENTE_SCONOSCIUTO(120),
    DESTINATARIO(150),
    DESTINATARIO_NON_PRESENTE(151),
    TIPO_DESTINATARIO_NON_PRESENTE(152),
    IDPORTA_DESTINATARIO_NON_PRESENTE(153),
    INDIRIZZO_DESTINATARIO_NON_PRESENTE(154),
    DESTINATARIO_PRESENTE_PIU_VOLTE(155),
    TIPO_DESTINATARIO_PRESENTE_PIU_VOLTE(156),
    IDPORTA_DESTINATARIO_PRESENTE_PIU_VOLTE(157),
    INDIRIZZO_DESTINATARIO_PRESENTE_PIU_VOLTE(158),
    DESTINATARIO_NON_VALORIZZATO(159),
    TIPO_DESTINATARIO_NON_VALORIZZATO(160),
    IDPORTA_DESTINATARIO_NON_VALORIZZATO(161),
    INDIRIZZO_DESTINATARIO_NON_VALORIZZATO(162),
    DESTINATARIO_NON_VALIDO(163),
    TIPO_DESTINATARIO_NON_VALIDO(164),
    IDPORTA_DESTINATARIO_NON_VALIDO(165),
    INDIRIZZO_DESTINATARIO_NON_VALIDO(166),
    DESTINATARIO_SCONOSCIUTO(167),
    TIPO_DESTINATARIO_SCONOSCIUTO(168),
    IDPORTA_DESTINATARIO_SCONOSCIUTO(169),
    INDIRIZZO_DESTINATARIO_SCONOSCIUTO(170),
    PROFILO_COLLABORAZIONE(200),
    PROFILO_COLLABORAZIONE_NON_PRESENTE(201),
    PROFILO_COLLABORAZIONE_PRESENTE_PIU_VOLTE(202),
    PROFILO_COLLABORAZIONE_NON_VALORIZZATO(203),
    PROFILO_COLLABORAZIONE_NON_VALIDO(204),
    PROFILO_COLLABORAZIONE_SCONOSCIUTO(205),
    SERVIZIO(250),
    SERVIZIO_NON_PRESENTE(251),
    TIPO_SERVIZIO_NON_PRESENTE(252),
    VERSIONE_SERVIZIO_NON_PRESENTE(253),
    SERVIZIO_PRESENTE_PIU_VOLTE(254),
    TIPO_SERVIZIO_PRESENTE_PIU_VOLTE(255),
    VERSIONE_SERVIZIO_PRESENTE_PIU_VOLTE(256),
    SERVIZIO_NON_VALORIZZATO(257),
    TIPO_SERVIZIO_NON_VALORIZZATO(258),
    VERSIONE_SERVIZIO_NON_VALORIZZATO(259),
    SERVIZIO_NON_VALIDO(260),
    TIPO_SERVIZIO_NON_VALIDO(261),
    VERSIONE_SERVIZIO_NON_VALIDO(262),
    SERVIZIO_SCONOSCIUTO(263),
    TIPO_SERVIZIO_SCONOSCIUTO(264),
    VERSIONE_SERVIZIO_SCONOSCIUTO(265),
    SERVIZIO_CORRELATO(300),
    SERVIZIO_CORRELATO_NON_PRESENTE(301),
    TIPO_SERVIZIO_CORRELATO_NON_PRESENTE(302),
    VERSIONE_SERVIZIO_CORRELATO_NON_PRESENTE(303),
    SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE(304),
    TIPO_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE(305),
    VERSIONE_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE(306),
    SERVIZIO_CORRELATO_NON_VALORIZZATO(307),
    TIPO_SERVIZIO_CORRELATO_NON_VALORIZZATO(308),
    VERSIONE_SERVIZIO_CORRELATO_NON_VALORIZZATO(309),
    SERVIZIO_CORRELATO_NON_VALIDO(310),
    TIPO_SERVIZIO_CORRELATO_NON_VALIDO(311),
    VERSIONE_SERVIZIO_CORRELATO_NON_VALIDO(312),
    SERVIZIO_CORRELATO_SCONOSCIUTO(313),
    TIPO_SERVIZIO_CORRELATO_SCONOSCIUTO(314),
    VERSIONE_SERVIZIO_CORRELATO_SCONOSCIUTO(315),
    COLLABORAZIONE(350),
    COLLABORAZIONE_NON_PRESENTE(351),
    COLLABORAZIONE_PRESENTE_PIU_VOLTE(352),
    COLLABORAZIONE_NON_VALORIZZATA(353),
    COLLABORAZIONE_NON_VALIDA(354),
    COLLABORAZIONE_SCONOSCIUTA(355),
    AZIONE(400),
    AZIONE_NON_PRESENTE(401),
    AZIONE_PRESENTE_PIU_VOLTE(402),
    AZIONE_NON_VALORIZZATA(403),
    AZIONE_NON_VALIDA(404),
    AZIONE_SCONOSCIUTA(405),
    INVOCAZIONE_SENZA_AZIONE_NON_PERMESSA(406),
    AZIONE_CORRELATA(450),
    AZIONE_CORRELATA_NON_PRESENTE(451),
    AZIONE_CORRELATA_PRESENTE_PIU_VOLTE(452),
    AZIONE_CORRELATA_NON_VALORIZZATA(453),
    AZIONE_CORRELATA_NON_VALIDA(454),
    AZIONE_CORRELATA_SCONOSCIUTA(455),
    IDENTIFICATIVO_MESSAGGIO(500),
    IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE(501),
    IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE(502),
    IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO(503),
    IDENTIFICATIVO_MESSAGGIO_NON_VALIDO(504),
    IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO(505),
    IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO(506),
    RIFERIMENTO_MESSAGGIO(550),
    RIFERIMENTO_MESSAGGIO_NON_PRESENTE(551),
    RIFERIMENTO_MESSAGGIO_PRESENTE_PIU_VOLTE(552),
    RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO(553),
    RIFERIMENTO_MESSAGGIO_NON_VALIDO(554),
    RIFERIMENTO_MESSAGGIO_SCONOSCIUTO(555),
    RIFERIMENTO_MESSAGGIO_GIA_PROCESSATO(556),
    ORA_REGISTRAZIONE(600),
    ORA_REGISTRAZIONE_NON_PRESENTE(601),
    TIPO_ORA_REGISTRAZIONE_NON_PRESENTE(602),
    ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(603),
    TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(604),
    ORA_REGISTRAZIONE_NON_VALORIZZATA(605),
    TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA(606),
    ORA_REGISTRAZIONE_NON_VALIDA(607),
    TIPO_ORA_REGISTRAZIONE_NON_VALIDA(608),
    ORA_REGISTRAZIONE_SCONOSCIUTA(609),
    TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA(610),
    SCADENZA(650),
    SCADENZA_NON_PRESENTE(651),
    TIPO_SCADENZA_NON_PRESENTE(652),
    SCADENZA_PRESENTE_PIU_VOLTE(653),
    TIPO_SCADENZA_PRESENTE_PIU_VOLTE(654),
    SCADENZA_NON_VALORIZZATA(655),
    TIPO_SCADENZA_NON_VALORIZZATA(656),
    SCADENZA_NON_VALIDA(657),
    TIPO_SCADENZA_NON_VALIDA(658),
    SCADENZA_SCONOSCIUTA(659),
    TIPO_SCADENZA_SCONOSCIUTA(660),
    MESSAGGIO_SCADUTO(661),
    PROFILO_TRASMISSIONE(700),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI(701),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE(702),
    PROFILO_TRASMISSIONE_NON_PRESENTE(703),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_PRESENTE(704),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE(705),
    PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE(706),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_PRESENTE_PIU_VOLTE(707),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_PRESENTE_PIU_VOLTE(708),
    PROFILO_TRASMISSIONE_NON_VALORIZZATO(709),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALORIZZATO(710),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALORIZZATO(711),
    PROFILO_TRASMISSIONE_NON_VALIDO(712),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO(713),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO(714),
    PROFILO_TRASMISSIONE_SCONOSCIUTO(715),
    PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO(716),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO(717),
    CONSEGNA_IN_ORDINE(750),
    CONSEGNA_IN_ORDINE_NON_PRESENTE(751),
    CONSEGNA_IN_ORDINE_PRESENTE_PIU_VOLTE(752),
    CONSEGNA_IN_ORDINE_NON_VALORIZZATA(753),
    CONSEGNA_IN_ORDINE_NON_VALIDA(754),
    CONSEGNA_IN_ORDINE_SCONOSCIUTA(755),
    CONSEGNA_IN_ORDINE_FUORI_SEQUENZA(756),
    CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO(757),
    CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO(758),
    CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO(759),
    CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO(760),
    CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO(761),
    CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO(762),
    CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA(763),
    CONSEGNA_IN_ORDINE_NON_SUPPORTATA(764),
    CONSEGNA_IN_ORDINE_NON_GESTIBILE(765),
    CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA(766),
    SERVIZIO_APPLICATIVO(800),
    SERVIZIO_APPLICATIVO_FRUITORE(801),
    SERVIZIO_APPLICATIVO_EROGATORE(802),
    SERVIZIO_APPLICATIVO_NON_PRESENTE(803),
    SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE(804),
    SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE(805),
    SERVIZIO_APPLICATIVO_PRESENTE_PIU_VOLTE(806),
    SERVIZIO_APPLICATIVO_FRUITORE_PRESENTE_PIU_VOLTE(807),
    SERVIZIO_APPLICATIVO_EROGATORE_PRESENTE_PIU_VOLTE(808),
    SERVIZIO_APPLICATIVO_NON_VALORIZZATO(809),
    SERVIZIO_APPLICATIVO_FRUITORE_NON_VALORIZZATO(810),
    SERVIZIO_APPLICATIVO_EROGATORE_NON_VALORIZZATO(811),
    SERVIZIO_APPLICATIVO_NON_VALIDO(812),
    SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO(813),
    SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO(814),
    SERVIZIO_APPLICATIVO_SCONOSCIUTO(815),
    SERVIZIO_APPLICATIVO_FRUITORE_SCONOSCIUTO(816),
    SERVIZIO_APPLICATIVO_EROGATORE_SCONOSCIUTO(817),
    LISTA_RISCONTRI(850),
    LISTA_RISCONTRI_NON_PRESENTE(851),
    LISTA_RISCONTRI_PRESENTE_PIU_VOLTE(852),
    LISTA_RISCONTRI_NON_VALORIZZATA(853),
    LISTA_RISCONTRI_NON_VALIDA(854),
    LISTA_RISCONTRI_SCONOSCIUTA(855),
    RISCONTRO(856),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO(857),
    RISCONTRO_ORA_REGISTRAZIONE(858),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE(859),
    RISCONTRO_NON_PRESENTE(860),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE(861),
    RISCONTRO_ORA_REGISTRAZIONE_NON_PRESENTE(862),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE(863),
    RISCONTRO_PRESENTE_PIU_VOLTE(864),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE(865),
    RISCONTRO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(866),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(867),
    RISCONTRO_NON_VALORIZZATO(868),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO(869),
    RISCONTRO_ORA_REGISTRAZIONE_NON_VALORIZZATA(870),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATO(871),
    RISCONTRO_NON_VALIDO(872),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO(873),
    RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA(874),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO(875),
    RISCONTRO_SCONOSCIUTO(876),
    RISCONTRO_IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO(877),
    RISCONTRO_ORA_REGISTRAZIONE_SCONOSCIUTA(878),
    RISCONTRO_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTO(879),
    LISTA_TRASMISSIONI(900),
    LISTA_TRASMISSIONI_NON_PRESENTE(901),
    LISTA_TRASMISSIONI_PRESENTE_PIU_VOLTE(902),
    LISTA_TRASMISSIONI_NON_VALORIZZATA(903),
    LISTA_TRASMISSIONI_NON_VALIDA(904),
    LISTA_TRASMISSIONI_SCONOSCIUTA(905),
    TRASMISSIONE(906),
    TRASMISSIONE_TIPO_ORIGINE(907),
    TRASMISSIONE_ORIGINE(908),
    TRASMISSIONE_INDIRIZZO_ORIGINE(909),
    TRASMISSIONE_IDPORTA_ORIGINE(910),
    TRASMISSIONE_TIPO_DESTINAZIONE(911),
    TRASMISSIONE_DESTINAZIONE(912),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE(913),
    TRASMISSIONE_IDPORTA_DESTINAZIONE(914),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE(915),
    TRASMISSIONE_ORA_REGISTRAZIONE(916),
    TRASMISSIONE_NON_PRESENTE(917),
    TRASMISSIONE_TIPO_ORIGINE_NON_PRESENTE(918),
    TRASMISSIONE_ORIGINE_NON_PRESENTE(919),
    TRASMISSIONE_INDIRIZZO_ORIGINE_NON_PRESENTE(920),
    TRASMISSIONE_IDPORTA_ORIGINE_NON_PRESENTE(921),
    TRASMISSIONE_TIPO_DESTINAZIONE_NON_PRESENTE(922),
    TRASMISSIONE_DESTINAZIONE_NON_PRESENTE(923),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_PRESENTE(924),
    TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_PRESENTE(925),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE(926),
    TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE(927),
    TRASMISSIONE_PRESENTE_PIU_VOLTE(928),
    TRASMISSIONE_TIPO_ORIGINE_PRESENTE_PIU_VOLTE(929),
    TRASMISSIONE_ORIGINE_PRESENTE_PIU_VOLTE(930),
    TRASMISSIONE_INDIRIZZO_ORIGINE_PRESENTE_PIU_VOLTE(931),
    TRASMISSIONE_IDPORTA_ORIGINE_PRESENTE_PIU_VOLTE(932),
    TRASMISSIONE_TIPO_DESTINAZIONE_PRESENTE_PIU_VOLTE(933),
    TRASMISSIONE_DESTINAZIONE_PRESENTE_PIU_VOLTE(934),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE_PRESENTE_PIU_VOLTE(935),
    TRASMISSIONE_IDPORTA_DESTINAZIONE_PRESENTE_PIU_VOLTE(936),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(937),
    TRASMISSIONE_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE(938),
    TRASMISSIONE_NON_VALORIZZATA(939),
    TRASMISSIONE_TIPO_ORIGINE_NON_VALORIZZATA(940),
    TRASMISSIONE_ORIGINE_NON_VALORIZZATA(941),
    TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALORIZZATA(942),
    TRASMISSIONE_IDPORTA_ORIGINE_NON_VALORIZZATA(943),
    TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALORIZZATA(944),
    TRASMISSIONE_DESTINAZIONE_NON_VALORIZZATA(945),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALORIZZATA(946),
    TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALORIZZATA(947),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA(948),
    TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALORIZZATA(949),
    TRASMISSIONE_NON_VALIDA(950),
    TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA(951),
    TRASMISSIONE_ORIGINE_NON_VALIDA(952),
    TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA(953),
    TRASMISSIONE_IDPORTA_ORIGINE_NON_VALIDA(954),
    TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA(955),
    TRASMISSIONE_DESTINAZIONE_NON_VALIDA(956),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA(957),
    TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALIDA(958),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA(959),
    TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA(960),
    TRASMISSIONE_SCONOSCIUTA(961),
    TRASMISSIONE_TIPO_ORIGINE_SCONOSCIUTA(962),
    TRASMISSIONE_ORIGINE_SCONOSCIUTA(963),
    TRASMISSIONE_INDIRIZZO_ORIGINE_SCONOSCIUTA(964),
    TRASMISSIONE_IDPORTA_ORIGINE_SCONOSCIUTA(965),
    TRASMISSIONE_TIPO_DESTINAZIONE_SCONOSCIUTA(966),
    TRASMISSIONE_DESTINAZIONE_SCONOSCIUTA(967),
    TRASMISSIONE_INDIRIZZO_DESTINAZIONE_SCONOSCIUTA(968),
    TRASMISSIONE_IDPORTA_DESTINAZIONE_SCONOSCIUTA(969),
    TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA(970),
    TRASMISSIONE_ORA_REGISTRAZIONE_SCONOSCIUTA(971),
    LISTA_ECCEZIONI(1000),
    LISTA_ECCEZIONI_NON_PRESENTE(1001),
    LISTA_ECCEZIONI_PRESENTE_PIU_VOLTE(1002),
    LISTA_ECCEZIONI_NON_VALORIZZATA(1003),
    LISTA_ECCEZIONI_NON_VALIDA(1004),
    LISTA_ECCEZIONI_SCONOSCIUTA(1005),
    ECCEZIONE(1006),
    ECCEZIONE_CODICE(1007),
    ECCEZIONE_CONTESTO(1008),
    ECCEZIONE_POSIZIONE(1009),
    ECCEZIONE_RILEVANZA(1010),
    ECCEZIONE_NON_PRESENTE(1011),
    ECCEZIONE_CODICE_NON_PRESENTE(1012),
    ECCEZIONE_CONTESTO_NON_PRESENTE(1013),
    ECCEZIONE_POSIZIONE_NON_PRESENTE(1014),
    ECCEZIONE_RILEVANZA_NON_PRESENTE(1015),
    ECCEZIONE_PRESENTE_PIU_VOLTE(1016),
    ECCEZIONE_CODICE_PRESENTE_PIU_VOLTE(1017),
    ECCEZIONE_CONTESTO_PRESENTE_PIU_VOLTE(1018),
    ECCEZIONE_POSIZIONE_PRESENTE_PIU_VOLTE(1019),
    ECCEZIONE_RILEVANZA_PRESENTE_PIU_VOLTE(1020),
    ECCEZIONE_NON_VALORIZZATA(1021),
    ECCEZIONE_CODICE_NON_VALORIZZATA(1022),
    ECCEZIONE_CONTESTO_NON_VALORIZZATA(1023),
    ECCEZIONE_POSIZIONE_NON_VALORIZZATA(1024),
    ECCEZIONE_RILEVANZA_NON_VALORIZZATA(1025),
    ECCEZIONE_NON_VALIDA(1026),
    ECCEZIONE_CODICE_NON_VALIDA(1027),
    ECCEZIONE_CONTESTO_NON_VALIDA(1028),
    ECCEZIONE_POSIZIONE_NON_VALIDA(1029),
    ECCEZIONE_RILEVANZA_NON_VALIDA(1030),
    ECCEZIONE_SCONOSCIUTA(1031),
    ECCEZIONE_CODICE_SCONOSCIUTA(1032),
    ECCEZIONE_CONTESTO_SCONOSCIUTA(1033),
    ECCEZIONE_POSIZIONE_SCONOSCIUTA(1034),
    ECCEZIONE_RILEVANZA_SCONOSCIUTA(1035),
    SOAPFAULT(1300),
    SOAPFAULT_CODE(1301),
    SOAPFAULT_STRING(1302),
    SOAPFAULT_ACTOR(1303),
    SOAPFAULT_DETAIL(1304),
    SOAPFAULT_NON_PRESENTE(1305),
    SOAPFAULT_CODE_NON_PRESENTE(1306),
    SOAPFAULT_STRING_NON_PRESENTE(1307),
    SOAPFAULT_ACTOR_NON_PRESENTE(1308),
    SOAPFAULT_DETAIL_NON_PRESENTE(1309),
    SOAPFAULT_PRESENTE_PIU_VOLTE(1310),
    SOAPFAULT_CODE_PRESENTE_PIU_VOLTE(1311),
    SOAPFAULT_STRING_PRESENTE_PIU_VOLTE(1312),
    SOAPFAULT_ACTOR_PRESENTE_PIU_VOLTE(1313),
    SOAPFAULT_DETAIL_PRESENTE_PIU_VOLTE(1314),
    SOAPFAULT_NON_VALORIZZATO(1315),
    SOAPFAULT_CODE_NON_VALORIZZATO(1316),
    SOAPFAULT_STRING_NON_VALORIZZATO(1317),
    SOAPFAULT_ACTOR_NON_VALORIZZATO(1318),
    SOAPFAULT_DETAIL_NON_VALORIZZATO(1319),
    SOAPFAULT_NON_VALIDO(1320),
    SOAPFAULT_CODE_NON_VALIDO(1321),
    SOAPFAULT_STRING_NON_VALIDO(1322),
    SOAPFAULT_ACTOR_NON_VALIDO(1323),
    SOAPFAULT_DETAIL_NON_VALIDO(1324),
    SOAPFAULT_SCONOSCIUTO(1325),
    SOAPFAULT_CODE_SCONOSCIUTO(1326),
    SOAPFAULT_STRING_SCONOSCIUTO(1327),
    SOAPFAULT_ACTOR_SCONOSCIUTO(1328),
    SOAPFAULT_DETAIL_SCONOSCIUTO(1329),
    SICUREZZA(1350),
    SICUREZZA_FALSIFICAZIONE_MITTENTE(1351),
    SICUREZZA_AUTORIZZAZIONE_FALLITA(1352),
    SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA(1353),
    SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE(1354),
    SICUREZZA_FIRMA_NON_VALIDA(1355),
    SICUREZZA_FIRMA_NON_PRESENTE(1356),
    SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA(1357),
    SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE(1358),
    SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA(1359),
    SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE(1360),
    SICUREZZA_CIFRATURA_NON_VALIDA(1361),
    SICUREZZA_CIFRATURA_NON_PRESENTE(1362),
    SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA(1363),
    SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE(1364),
    SICUREZZA_NON_PRESENTE(1365),
    ALLEGATI(1400),
    ALLEGATI_RIFERIMENTO_NON_PRESENTE(1401),
    ALLEGATI_RIFERIMENTO_NON_VALIDO(1402),
    ALLEGATO_NON_PRESENTE(1403),
    ALLEGATO_NON_DEFINITO_MANIFEST(1404),
    ECCEZIONE_GENERICA(2000);

    private final int codice;

    private CodiceErroreCooperazione(int codice) {
        this.codice = codice;
    }

    @Override
    public int getCodice() {
        return this.codice;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(CodiceErroreCooperazione codice) {
        if (codice == null) {
            return false;
        }
        return this.getCodice() == codice.getCodice();
    }

    public static CodiceErroreCooperazione toCodiceErroreCooperazione(IProtocolFactory protocolFactory, String protocolString) throws ProtocolException {
        return protocolFactory.createTraduttore().toCodiceErroreCooperazione(protocolString);
    }

    public static boolean isEccezioneMittente(CodiceErroreCooperazione codice) {
        return MITTENTE.equals(codice) || MITTENTE_NON_PRESENTE.equals(codice) || MITTENTE_PRESENTE_PIU_VOLTE.equals(codice) || MITTENTE_NON_VALIDO.equals(codice) || MITTENTE_NON_VALORIZZATO.equals(codice) || MITTENTE_SCONOSCIUTO.equals(codice) || TIPO_MITTENTE_NON_PRESENTE.equals(codice) || TIPO_MITTENTE_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_MITTENTE_NON_VALIDO.equals(codice) || TIPO_MITTENTE_NON_VALORIZZATO.equals(codice) || TIPO_MITTENTE_SCONOSCIUTO.equals(codice) || IDPORTA_MITTENTE_NON_PRESENTE.equals(codice) || IDPORTA_MITTENTE_PRESENTE_PIU_VOLTE.equals(codice) || IDPORTA_MITTENTE_NON_VALIDO.equals(codice) || IDPORTA_MITTENTE_NON_VALORIZZATO.equals(codice) || IDPORTA_MITTENTE_SCONOSCIUTO.equals(codice) || INDIRIZZO_MITTENTE_NON_PRESENTE.equals(codice) || INDIRIZZO_MITTENTE_PRESENTE_PIU_VOLTE.equals(codice) || INDIRIZZO_MITTENTE_NON_VALIDO.equals(codice) || INDIRIZZO_MITTENTE_NON_VALORIZZATO.equals(codice) || INDIRIZZO_MITTENTE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneDestinatario(CodiceErroreCooperazione codice) {
        return DESTINATARIO.equals(codice) || DESTINATARIO_NON_PRESENTE.equals(codice) || DESTINATARIO_PRESENTE_PIU_VOLTE.equals(codice) || DESTINATARIO_NON_VALIDO.equals(codice) || DESTINATARIO_NON_VALORIZZATO.equals(codice) || DESTINATARIO_SCONOSCIUTO.equals(codice) || TIPO_DESTINATARIO_NON_PRESENTE.equals(codice) || TIPO_DESTINATARIO_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_DESTINATARIO_NON_VALIDO.equals(codice) || TIPO_DESTINATARIO_NON_VALORIZZATO.equals(codice) || TIPO_DESTINATARIO_SCONOSCIUTO.equals(codice) || IDPORTA_DESTINATARIO_NON_PRESENTE.equals(codice) || IDPORTA_DESTINATARIO_PRESENTE_PIU_VOLTE.equals(codice) || IDPORTA_DESTINATARIO_NON_VALIDO.equals(codice) || IDPORTA_DESTINATARIO_NON_VALORIZZATO.equals(codice) || IDPORTA_DESTINATARIO_SCONOSCIUTO.equals(codice) || INDIRIZZO_DESTINATARIO_NON_PRESENTE.equals(codice) || INDIRIZZO_DESTINATARIO_PRESENTE_PIU_VOLTE.equals(codice) || INDIRIZZO_DESTINATARIO_NON_VALIDO.equals(codice) || INDIRIZZO_DESTINATARIO_NON_VALORIZZATO.equals(codice) || INDIRIZZO_DESTINATARIO_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneProfiloCollaborazione(CodiceErroreCooperazione codice) {
        return PROFILO_COLLABORAZIONE.equals(codice) || PROFILO_COLLABORAZIONE_NON_PRESENTE.equals(codice) || PROFILO_COLLABORAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_COLLABORAZIONE_NON_VALIDO.equals(codice) || PROFILO_COLLABORAZIONE_NON_VALORIZZATO.equals(codice) || PROFILO_COLLABORAZIONE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneServizio(CodiceErroreCooperazione codice) {
        return SERVIZIO.equals(codice) || SERVIZIO_NON_PRESENTE.equals(codice) || SERVIZIO_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_NON_VALIDO.equals(codice) || SERVIZIO_NON_VALORIZZATO.equals(codice) || SERVIZIO_SCONOSCIUTO.equals(codice) || TIPO_SERVIZIO_NON_PRESENTE.equals(codice) || TIPO_SERVIZIO_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_SERVIZIO_NON_VALIDO.equals(codice) || TIPO_SERVIZIO_NON_VALORIZZATO.equals(codice) || TIPO_SERVIZIO_SCONOSCIUTO.equals(codice) || VERSIONE_SERVIZIO_NON_PRESENTE.equals(codice) || VERSIONE_SERVIZIO_PRESENTE_PIU_VOLTE.equals(codice) || VERSIONE_SERVIZIO_NON_VALIDO.equals(codice) || VERSIONE_SERVIZIO_NON_VALORIZZATO.equals(codice) || VERSIONE_SERVIZIO_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneServizioCorrelato(CodiceErroreCooperazione codice) {
        return SERVIZIO_CORRELATO.equals(codice) || SERVIZIO_CORRELATO_NON_PRESENTE.equals(codice) || SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_CORRELATO_NON_VALIDO.equals(codice) || SERVIZIO_CORRELATO_NON_VALORIZZATO.equals(codice) || SERVIZIO_CORRELATO_SCONOSCIUTO.equals(codice) || TIPO_SERVIZIO_CORRELATO_NON_PRESENTE.equals(codice) || TIPO_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_SERVIZIO_CORRELATO_NON_VALIDO.equals(codice) || TIPO_SERVIZIO_CORRELATO_NON_VALORIZZATO.equals(codice) || TIPO_SERVIZIO_CORRELATO_SCONOSCIUTO.equals(codice) || VERSIONE_SERVIZIO_CORRELATO_NON_PRESENTE.equals(codice) || VERSIONE_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE.equals(codice) || VERSIONE_SERVIZIO_CORRELATO_NON_VALIDO.equals(codice) || VERSIONE_SERVIZIO_CORRELATO_NON_VALORIZZATO.equals(codice) || VERSIONE_SERVIZIO_CORRELATO_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneCollaborazione(CodiceErroreCooperazione codice) {
        return COLLABORAZIONE.equals(codice) || COLLABORAZIONE_NON_PRESENTE.equals(codice) || COLLABORAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || COLLABORAZIONE_NON_VALIDA.equals(codice) || COLLABORAZIONE_NON_VALORIZZATA.equals(codice) || COLLABORAZIONE_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneAzione(CodiceErroreCooperazione codice) {
        return AZIONE.equals(codice) || AZIONE_NON_PRESENTE.equals(codice) || AZIONE_PRESENTE_PIU_VOLTE.equals(codice) || AZIONE_NON_VALIDA.equals(codice) || AZIONE_NON_VALORIZZATA.equals(codice) || AZIONE_SCONOSCIUTA.equals(codice) || INVOCAZIONE_SENZA_AZIONE_NON_PERMESSA.equals(codice);
    }

    public static boolean isEccezioneAzioneCorrelata(CodiceErroreCooperazione codice) {
        return AZIONE_CORRELATA.equals(codice) || AZIONE_CORRELATA_NON_PRESENTE.equals(codice) || AZIONE_CORRELATA_PRESENTE_PIU_VOLTE.equals(codice) || AZIONE_CORRELATA_NON_VALIDA.equals(codice) || AZIONE_CORRELATA_NON_VALORIZZATA.equals(codice) || AZIONE_CORRELATA_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneIdentificativoMessaggio(CodiceErroreCooperazione codice) {
        return IDENTIFICATIVO_MESSAGGIO.equals(codice) || IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE.equals(codice) || IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE.equals(codice) || IDENTIFICATIVO_MESSAGGIO_NON_VALIDO.equals(codice) || IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO.equals(codice) || IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO.equals(codice) || IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO.equals(codice);
    }

    public static boolean isEccezionRiferimentoMessaggio(CodiceErroreCooperazione codice) {
        return RIFERIMENTO_MESSAGGIO.equals(codice) || RIFERIMENTO_MESSAGGIO_NON_PRESENTE.equals(codice) || RIFERIMENTO_MESSAGGIO_PRESENTE_PIU_VOLTE.equals(codice) || RIFERIMENTO_MESSAGGIO_NON_VALIDO.equals(codice) || RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO.equals(codice) || RIFERIMENTO_MESSAGGIO_SCONOSCIUTO.equals(codice) || RIFERIMENTO_MESSAGGIO_GIA_PROCESSATO.equals(codice);
    }

    public static boolean isEccezioneOraRegistrazione(CodiceErroreCooperazione codice) {
        return ORA_REGISTRAZIONE.equals(codice) || ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || ORA_REGISTRAZIONE_NON_VALIDA.equals(codice) || ORA_REGISTRAZIONE_NON_VALORIZZATA.equals(codice) || ORA_REGISTRAZIONE_SCONOSCIUTA.equals(codice) || TIPO_ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_ORA_REGISTRAZIONE_NON_VALIDA.equals(codice) || TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA.equals(codice) || TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneScadenza(CodiceErroreCooperazione codice) {
        return SCADENZA.equals(codice) || SCADENZA_NON_PRESENTE.equals(codice) || SCADENZA_PRESENTE_PIU_VOLTE.equals(codice) || SCADENZA_NON_VALIDA.equals(codice) || SCADENZA_NON_VALORIZZATA.equals(codice) || SCADENZA_SCONOSCIUTA.equals(codice) || TIPO_SCADENZA_NON_PRESENTE.equals(codice) || TIPO_SCADENZA_PRESENTE_PIU_VOLTE.equals(codice) || TIPO_SCADENZA_NON_VALIDA.equals(codice) || TIPO_SCADENZA_NON_VALORIZZATA.equals(codice) || TIPO_SCADENZA_SCONOSCIUTA.equals(codice) || MESSAGGIO_SCADUTO.equals(codice);
    }

    public static boolean isEccezioneProfiloTrasmissione(CodiceErroreCooperazione codice) {
        return PROFILO_TRASMISSIONE.equals(codice) || PROFILO_TRASMISSIONE_NON_PRESENTE.equals(codice) || PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_TRASMISSIONE_NON_VALIDO.equals(codice) || PROFILO_TRASMISSIONE_NON_VALORIZZATO.equals(codice) || PROFILO_TRASMISSIONE_SCONOSCIUTO.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_PRESENTE.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALORIZZATO.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALORIZZATO.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneProfiloTrasmissioneFiltroDuplicati(CodiceErroreCooperazione codice) {
        return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_PRESENTE.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALORIZZATO.equals(codice) || PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneProfiloTrasmissioneConfermaRicezione(CodiceErroreCooperazione codice) {
        return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_PRESENTE_PIU_VOLTE.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALORIZZATO.equals(codice) || PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneConsegnaInOrdine(CodiceErroreCooperazione codice) {
        return CONSEGNA_IN_ORDINE.equals(codice) || CONSEGNA_IN_ORDINE_NON_PRESENTE.equals(codice) || CONSEGNA_IN_ORDINE_PRESENTE_PIU_VOLTE.equals(codice) || CONSEGNA_IN_ORDINE_NON_VALIDA.equals(codice) || CONSEGNA_IN_ORDINE_NON_VALORIZZATA.equals(codice) || CONSEGNA_IN_ORDINE_SCONOSCIUTA.equals(codice) || CONSEGNA_IN_ORDINE_FUORI_SEQUENZA.equals(codice) || CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO.equals(codice) || CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA.equals(codice) || CONSEGNA_IN_ORDINE_NON_SUPPORTATA.equals(codice) || CONSEGNA_IN_ORDINE_NON_GESTIBILE.equals(codice) || CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneServizioApplicativo(CodiceErroreCooperazione codice) {
        return SERVIZIO_APPLICATIVO.equals(codice) || SERVIZIO_APPLICATIVO_NON_PRESENTE.equals(codice) || SERVIZIO_APPLICATIVO_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_APPLICATIVO_NON_VALIDO.equals(codice) || SERVIZIO_APPLICATIVO_NON_VALORIZZATO.equals(codice) || SERVIZIO_APPLICATIVO_SCONOSCIUTO.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_VALORIZZATO.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_SCONOSCIUTO.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_VALORIZZATO.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneServizioApplicativoFruitore(CodiceErroreCooperazione codice) {
        return SERVIZIO_APPLICATIVO_FRUITORE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_NON_VALORIZZATO.equals(codice) || SERVIZIO_APPLICATIVO_FRUITORE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneServizioApplicativoErogatore(CodiceErroreCooperazione codice) {
        return SERVIZIO_APPLICATIVO_EROGATORE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_PRESENTE_PIU_VOLTE.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_NON_VALORIZZATO.equals(codice) || SERVIZIO_APPLICATIVO_EROGATORE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneListaRiscontri(CodiceErroreCooperazione codice) {
        return LISTA_RISCONTRI.equals(codice) || LISTA_RISCONTRI_NON_PRESENTE.equals(codice) || LISTA_RISCONTRI_PRESENTE_PIU_VOLTE.equals(codice) || LISTA_RISCONTRI_NON_VALIDA.equals(codice) || LISTA_RISCONTRI_NON_VALORIZZATA.equals(codice) || LISTA_RISCONTRI_SCONOSCIUTA.equals(codice) || RISCONTRO.equals(codice) || RISCONTRO_NON_PRESENTE.equals(codice) || RISCONTRO_PRESENTE_PIU_VOLTE.equals(codice) || RISCONTRO_NON_VALIDO.equals(codice) || RISCONTRO_NON_VALORIZZATO.equals(codice) || RISCONTRO_SCONOSCIUTO.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO.equals(codice) || RISCONTRO_IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE_NON_VALORIZZATA.equals(codice) || RISCONTRO_ORA_REGISTRAZIONE_SCONOSCIUTA.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATO.equals(codice) || RISCONTRO_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneListaTrasmissioni(CodiceErroreCooperazione codice) {
        return LISTA_TRASMISSIONI.equals(codice) || LISTA_TRASMISSIONI_NON_PRESENTE.equals(codice) || LISTA_TRASMISSIONI_PRESENTE_PIU_VOLTE.equals(codice) || LISTA_TRASMISSIONI_NON_VALIDA.equals(codice) || LISTA_TRASMISSIONI_NON_VALORIZZATA.equals(codice) || LISTA_TRASMISSIONI_SCONOSCIUTA.equals(codice) || TRASMISSIONE.equals(codice) || TRASMISSIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_TIPO_ORIGINE.equals(codice) || TRASMISSIONE_TIPO_ORIGINE_NON_PRESENTE.equals(codice) || TRASMISSIONE_TIPO_ORIGINE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA.equals(codice) || TRASMISSIONE_TIPO_ORIGINE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_TIPO_ORIGINE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_ORIGINE.equals(codice) || TRASMISSIONE_ORIGINE_NON_PRESENTE.equals(codice) || TRASMISSIONE_ORIGINE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_ORIGINE_NON_VALIDA.equals(codice) || TRASMISSIONE_ORIGINE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_ORIGINE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE_NON_PRESENTE.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_INDIRIZZO_ORIGINE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE_NON_PRESENTE.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE_NON_VALIDA.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_IDPORTA_ORIGINE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_TIPO_DESTINAZIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_DESTINAZIONE.equals(codice) || TRASMISSIONE_DESTINAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_DESTINAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_DESTINAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_DESTINAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_DESTINAZIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_INDIRIZZO_DESTINAZIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_IDPORTA_DESTINAZIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALORIZZATA.equals(codice) || TRASMISSIONE_ORA_REGISTRAZIONE_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneListaEccezioni(CodiceErroreCooperazione codice) {
        return LISTA_ECCEZIONI.equals(codice) || LISTA_ECCEZIONI_NON_PRESENTE.equals(codice) || LISTA_ECCEZIONI_PRESENTE_PIU_VOLTE.equals(codice) || LISTA_ECCEZIONI_NON_VALIDA.equals(codice) || LISTA_ECCEZIONI_NON_VALORIZZATA.equals(codice) || LISTA_ECCEZIONI_SCONOSCIUTA.equals(codice) || ECCEZIONE.equals(codice) || ECCEZIONE_NON_PRESENTE.equals(codice) || ECCEZIONE_PRESENTE_PIU_VOLTE.equals(codice) || ECCEZIONE_NON_VALIDA.equals(codice) || ECCEZIONE_NON_VALORIZZATA.equals(codice) || ECCEZIONE_SCONOSCIUTA.equals(codice) || ECCEZIONE_CODICE.equals(codice) || ECCEZIONE_CODICE_NON_PRESENTE.equals(codice) || ECCEZIONE_CODICE_PRESENTE_PIU_VOLTE.equals(codice) || ECCEZIONE_CODICE_NON_VALIDA.equals(codice) || ECCEZIONE_CODICE_NON_VALORIZZATA.equals(codice) || ECCEZIONE_CODICE_SCONOSCIUTA.equals(codice) || ECCEZIONE_CONTESTO.equals(codice) || ECCEZIONE_CONTESTO_NON_PRESENTE.equals(codice) || ECCEZIONE_CONTESTO_PRESENTE_PIU_VOLTE.equals(codice) || ECCEZIONE_CONTESTO_NON_VALIDA.equals(codice) || ECCEZIONE_CONTESTO_NON_VALORIZZATA.equals(codice) || ECCEZIONE_CONTESTO_SCONOSCIUTA.equals(codice) || ECCEZIONE_RILEVANZA.equals(codice) || ECCEZIONE_RILEVANZA_NON_PRESENTE.equals(codice) || ECCEZIONE_RILEVANZA_PRESENTE_PIU_VOLTE.equals(codice) || ECCEZIONE_RILEVANZA_NON_VALIDA.equals(codice) || ECCEZIONE_RILEVANZA_NON_VALORIZZATA.equals(codice) || ECCEZIONE_RILEVANZA_SCONOSCIUTA.equals(codice) || ECCEZIONE_POSIZIONE.equals(codice) || ECCEZIONE_POSIZIONE_NON_PRESENTE.equals(codice) || ECCEZIONE_POSIZIONE_PRESENTE_PIU_VOLTE.equals(codice) || ECCEZIONE_POSIZIONE_NON_VALIDA.equals(codice) || ECCEZIONE_POSIZIONE_NON_VALORIZZATA.equals(codice) || ECCEZIONE_POSIZIONE_SCONOSCIUTA.equals(codice);
    }

    public static boolean isEccezioneSOAPFault(CodiceErroreCooperazione codice) {
        return SOAPFAULT.equals(codice) || SOAPFAULT_NON_PRESENTE.equals(codice) || SOAPFAULT_PRESENTE_PIU_VOLTE.equals(codice) || SOAPFAULT_NON_VALIDO.equals(codice) || SOAPFAULT_NON_VALORIZZATO.equals(codice) || SOAPFAULT_SCONOSCIUTO.equals(codice) || SOAPFAULT_CODE.equals(codice) || SOAPFAULT_CODE_NON_PRESENTE.equals(codice) || SOAPFAULT_CODE_PRESENTE_PIU_VOLTE.equals(codice) || SOAPFAULT_CODE_NON_VALIDO.equals(codice) || SOAPFAULT_CODE_NON_VALORIZZATO.equals(codice) || SOAPFAULT_CODE_SCONOSCIUTO.equals(codice) || SOAPFAULT_STRING.equals(codice) || SOAPFAULT_STRING_NON_PRESENTE.equals(codice) || SOAPFAULT_STRING_PRESENTE_PIU_VOLTE.equals(codice) || SOAPFAULT_STRING_NON_VALIDO.equals(codice) || SOAPFAULT_STRING_NON_VALORIZZATO.equals(codice) || SOAPFAULT_STRING_SCONOSCIUTO.equals(codice) || SOAPFAULT_ACTOR.equals(codice) || SOAPFAULT_ACTOR_NON_PRESENTE.equals(codice) || SOAPFAULT_ACTOR_PRESENTE_PIU_VOLTE.equals(codice) || SOAPFAULT_ACTOR_NON_VALIDO.equals(codice) || SOAPFAULT_ACTOR_NON_VALORIZZATO.equals(codice) || SOAPFAULT_ACTOR_SCONOSCIUTO.equals(codice) || SOAPFAULT_DETAIL.equals(codice) || SOAPFAULT_DETAIL_NON_PRESENTE.equals(codice) || SOAPFAULT_DETAIL_PRESENTE_PIU_VOLTE.equals(codice) || SOAPFAULT_DETAIL_NON_VALIDO.equals(codice) || SOAPFAULT_DETAIL_NON_VALORIZZATO.equals(codice) || SOAPFAULT_DETAIL_SCONOSCIUTO.equals(codice);
    }

    public static boolean isEccezioneSicurezza(CodiceErroreCooperazione codice) {
        return SICUREZZA.equals(codice) || SICUREZZA_FALSIFICAZIONE_MITTENTE.equals(codice) || SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(codice) || SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_CIFRATURA_NON_VALIDA.equals(codice) || SICUREZZA_CIFRATURA_NON_PRESENTE.equals(codice) || SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_NON_PRESENTE.equals(codice);
    }

    public static boolean isEccezioneMessageSecurity(CodiceErroreCooperazione codice) {
        return SICUREZZA.equals(codice) || SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_CIFRATURA_NON_VALIDA.equals(codice) || SICUREZZA_CIFRATURA_NON_PRESENTE.equals(codice) || SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA.equals(codice) || SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE.equals(codice) || SICUREZZA_NON_PRESENTE.equals(codice);
    }

    public static boolean isEccezioneSicurezzaAutorizzazione(CodiceErroreCooperazione codice) {
        return SICUREZZA.equals(codice) || SICUREZZA_FALSIFICAZIONE_MITTENTE.equals(codice) || SICUREZZA_AUTORIZZAZIONE_FALLITA.equals(codice);
    }

    public static boolean isEccezioneAllegati(CodiceErroreCooperazione codice) {
        return ALLEGATI.equals(codice) || ALLEGATI_RIFERIMENTO_NON_PRESENTE.equals(codice) || ALLEGATI_RIFERIMENTO_NON_VALIDO.equals(codice) || ALLEGATO_NON_PRESENTE.equals(codice) || ALLEGATO_NON_DEFINITO_MANIFEST.equals(codice);
    }

    public static CodiceErroreCooperazione toCodiceErroreCooperazione(int i) {
        switch (i) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return FORMATO_NON_CORRETTO;
            }
            case 2: {
                return FORMATO_INTESTAZIONE_NON_PRESENTE;
            }
            case 3: {
                return FORMATO_INTESTAZIONE_NON_CORRETTO;
            }
            case 4: {
                return FORMATO_CORPO_NON_PRESENTE;
            }
            case 5: {
                return FORMATO_CORPO_NON_CORRETTO;
            }
            case 6: {
                return ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO;
            }
            case 51: {
                return INTESTAZIONE_NON_CORRETTA;
            }
            case 52: {
                return INTESTAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 53: {
                return INTESTAZIONE_ACTOR_NON_PRESENTE;
            }
            case 54: {
                return INTESTAZIONE_ACTOR_NON_VALORIZZATO;
            }
            case 55: {
                return INTESTAZIONE_ACTOR_NON_VALIDO;
            }
            case 56: {
                return INTESTAZIONE_ACTOR_SCONOSCIUTO;
            }
            case 57: {
                return INTESTAZIONE_MUST_UNDERSTAND_NON_PRESENTE;
            }
            case 58: {
                return INTESTAZIONE_MUST_UNDERSTAND_NON_VALORIZZATO;
            }
            case 59: {
                return INTESTAZIONE_MUST_UNDERSTAND_NON_VALIDO;
            }
            case 60: {
                return INTESTAZIONE_MUST_UNDERSTAND_SCONOSCIUTO;
            }
            case 100: {
                return MITTENTE;
            }
            case 101: {
                return MITTENTE_NON_PRESENTE;
            }
            case 102: {
                return TIPO_MITTENTE_NON_PRESENTE;
            }
            case 103: {
                return IDPORTA_MITTENTE_NON_PRESENTE;
            }
            case 104: {
                return INDIRIZZO_MITTENTE_NON_PRESENTE;
            }
            case 105: {
                return MITTENTE_PRESENTE_PIU_VOLTE;
            }
            case 106: {
                return TIPO_MITTENTE_PRESENTE_PIU_VOLTE;
            }
            case 107: {
                return IDPORTA_MITTENTE_PRESENTE_PIU_VOLTE;
            }
            case 108: {
                return INDIRIZZO_MITTENTE_PRESENTE_PIU_VOLTE;
            }
            case 109: {
                return MITTENTE_NON_VALORIZZATO;
            }
            case 110: {
                return TIPO_MITTENTE_NON_VALORIZZATO;
            }
            case 111: {
                return IDPORTA_MITTENTE_NON_VALORIZZATO;
            }
            case 112: {
                return INDIRIZZO_MITTENTE_NON_VALORIZZATO;
            }
            case 113: {
                return MITTENTE_NON_VALIDO;
            }
            case 114: {
                return TIPO_MITTENTE_NON_VALIDO;
            }
            case 115: {
                return IDPORTA_MITTENTE_NON_VALIDO;
            }
            case 116: {
                return INDIRIZZO_MITTENTE_NON_VALIDO;
            }
            case 117: {
                return MITTENTE_SCONOSCIUTO;
            }
            case 118: {
                return TIPO_MITTENTE_SCONOSCIUTO;
            }
            case 119: {
                return IDPORTA_MITTENTE_SCONOSCIUTO;
            }
            case 120: {
                return INDIRIZZO_MITTENTE_SCONOSCIUTO;
            }
            case 150: {
                return DESTINATARIO;
            }
            case 151: {
                return DESTINATARIO_NON_PRESENTE;
            }
            case 152: {
                return TIPO_DESTINATARIO_NON_PRESENTE;
            }
            case 153: {
                return IDPORTA_DESTINATARIO_NON_PRESENTE;
            }
            case 154: {
                return INDIRIZZO_DESTINATARIO_NON_PRESENTE;
            }
            case 155: {
                return DESTINATARIO_PRESENTE_PIU_VOLTE;
            }
            case 156: {
                return TIPO_DESTINATARIO_PRESENTE_PIU_VOLTE;
            }
            case 157: {
                return IDPORTA_DESTINATARIO_PRESENTE_PIU_VOLTE;
            }
            case 158: {
                return INDIRIZZO_DESTINATARIO_PRESENTE_PIU_VOLTE;
            }
            case 159: {
                return DESTINATARIO_NON_VALORIZZATO;
            }
            case 160: {
                return TIPO_DESTINATARIO_NON_VALORIZZATO;
            }
            case 161: {
                return IDPORTA_DESTINATARIO_NON_VALORIZZATO;
            }
            case 162: {
                return INDIRIZZO_DESTINATARIO_NON_VALORIZZATO;
            }
            case 163: {
                return DESTINATARIO_NON_VALIDO;
            }
            case 164: {
                return TIPO_DESTINATARIO_NON_VALIDO;
            }
            case 165: {
                return IDPORTA_DESTINATARIO_NON_VALIDO;
            }
            case 166: {
                return INDIRIZZO_DESTINATARIO_NON_VALIDO;
            }
            case 167: {
                return DESTINATARIO_SCONOSCIUTO;
            }
            case 168: {
                return TIPO_DESTINATARIO_SCONOSCIUTO;
            }
            case 169: {
                return IDPORTA_DESTINATARIO_SCONOSCIUTO;
            }
            case 170: {
                return INDIRIZZO_DESTINATARIO_SCONOSCIUTO;
            }
            case 200: {
                return PROFILO_COLLABORAZIONE;
            }
            case 201: {
                return PROFILO_COLLABORAZIONE_NON_PRESENTE;
            }
            case 202: {
                return PROFILO_COLLABORAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 203: {
                return PROFILO_COLLABORAZIONE_NON_VALORIZZATO;
            }
            case 204: {
                return PROFILO_COLLABORAZIONE_NON_VALIDO;
            }
            case 205: {
                return PROFILO_COLLABORAZIONE_SCONOSCIUTO;
            }
            case 250: {
                return SERVIZIO;
            }
            case 251: {
                return SERVIZIO_NON_PRESENTE;
            }
            case 252: {
                return TIPO_SERVIZIO_NON_PRESENTE;
            }
            case 253: {
                return VERSIONE_SERVIZIO_NON_PRESENTE;
            }
            case 254: {
                return SERVIZIO_PRESENTE_PIU_VOLTE;
            }
            case 255: {
                return TIPO_SERVIZIO_PRESENTE_PIU_VOLTE;
            }
            case 256: {
                return VERSIONE_SERVIZIO_PRESENTE_PIU_VOLTE;
            }
            case 257: {
                return SERVIZIO_NON_VALORIZZATO;
            }
            case 258: {
                return TIPO_SERVIZIO_NON_VALORIZZATO;
            }
            case 259: {
                return VERSIONE_SERVIZIO_NON_VALORIZZATO;
            }
            case 260: {
                return SERVIZIO_NON_VALIDO;
            }
            case 261: {
                return TIPO_SERVIZIO_NON_VALIDO;
            }
            case 262: {
                return VERSIONE_SERVIZIO_NON_VALIDO;
            }
            case 263: {
                return SERVIZIO_SCONOSCIUTO;
            }
            case 264: {
                return TIPO_SERVIZIO_SCONOSCIUTO;
            }
            case 265: {
                return VERSIONE_SERVIZIO_SCONOSCIUTO;
            }
            case 300: {
                return SERVIZIO_CORRELATO;
            }
            case 301: {
                return SERVIZIO_CORRELATO_NON_PRESENTE;
            }
            case 302: {
                return TIPO_SERVIZIO_CORRELATO_NON_PRESENTE;
            }
            case 303: {
                return VERSIONE_SERVIZIO_CORRELATO_NON_PRESENTE;
            }
            case 304: {
                return SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE;
            }
            case 305: {
                return TIPO_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE;
            }
            case 306: {
                return VERSIONE_SERVIZIO_CORRELATO_PRESENTE_PIU_VOLTE;
            }
            case 307: {
                return SERVIZIO_CORRELATO_NON_VALORIZZATO;
            }
            case 308: {
                return TIPO_SERVIZIO_CORRELATO_NON_VALORIZZATO;
            }
            case 309: {
                return VERSIONE_SERVIZIO_CORRELATO_NON_VALORIZZATO;
            }
            case 310: {
                return SERVIZIO_CORRELATO_NON_VALIDO;
            }
            case 311: {
                return TIPO_SERVIZIO_CORRELATO_NON_VALIDO;
            }
            case 312: {
                return VERSIONE_SERVIZIO_CORRELATO_NON_VALIDO;
            }
            case 313: {
                return SERVIZIO_CORRELATO_SCONOSCIUTO;
            }
            case 314: {
                return TIPO_SERVIZIO_CORRELATO_SCONOSCIUTO;
            }
            case 315: {
                return VERSIONE_SERVIZIO_CORRELATO_SCONOSCIUTO;
            }
            case 350: {
                return COLLABORAZIONE;
            }
            case 351: {
                return COLLABORAZIONE_NON_PRESENTE;
            }
            case 352: {
                return COLLABORAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 353: {
                return COLLABORAZIONE_NON_VALORIZZATA;
            }
            case 354: {
                return COLLABORAZIONE_NON_VALIDA;
            }
            case 355: {
                return COLLABORAZIONE_SCONOSCIUTA;
            }
            case 400: {
                return AZIONE;
            }
            case 401: {
                return AZIONE_NON_PRESENTE;
            }
            case 402: {
                return AZIONE_PRESENTE_PIU_VOLTE;
            }
            case 403: {
                return AZIONE_NON_VALORIZZATA;
            }
            case 404: {
                return AZIONE_NON_VALIDA;
            }
            case 405: {
                return AZIONE_SCONOSCIUTA;
            }
            case 406: {
                return INVOCAZIONE_SENZA_AZIONE_NON_PERMESSA;
            }
            case 450: {
                return AZIONE_CORRELATA;
            }
            case 451: {
                return AZIONE_CORRELATA_NON_PRESENTE;
            }
            case 452: {
                return AZIONE_CORRELATA_PRESENTE_PIU_VOLTE;
            }
            case 453: {
                return AZIONE_CORRELATA_NON_VALORIZZATA;
            }
            case 454: {
                return AZIONE_CORRELATA_NON_VALIDA;
            }
            case 455: {
                return AZIONE_CORRELATA_SCONOSCIUTA;
            }
            case 500: {
                return IDENTIFICATIVO_MESSAGGIO;
            }
            case 501: {
                return IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE;
            }
            case 502: {
                return IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE;
            }
            case 503: {
                return IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO;
            }
            case 504: {
                return IDENTIFICATIVO_MESSAGGIO_NON_VALIDO;
            }
            case 505: {
                return IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO;
            }
            case 506: {
                return IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO;
            }
            case 550: {
                return RIFERIMENTO_MESSAGGIO;
            }
            case 551: {
                return RIFERIMENTO_MESSAGGIO_NON_PRESENTE;
            }
            case 552: {
                return RIFERIMENTO_MESSAGGIO_PRESENTE_PIU_VOLTE;
            }
            case 553: {
                return RIFERIMENTO_MESSAGGIO_NON_VALORIZZATO;
            }
            case 554: {
                return RIFERIMENTO_MESSAGGIO_NON_VALIDO;
            }
            case 555: {
                return RIFERIMENTO_MESSAGGIO_SCONOSCIUTO;
            }
            case 556: {
                return RIFERIMENTO_MESSAGGIO_GIA_PROCESSATO;
            }
            case 600: {
                return ORA_REGISTRAZIONE;
            }
            case 601: {
                return ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 602: {
                return TIPO_ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 603: {
                return ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 604: {
                return TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 605: {
                return ORA_REGISTRAZIONE_NON_VALORIZZATA;
            }
            case 606: {
                return TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA;
            }
            case 607: {
                return ORA_REGISTRAZIONE_NON_VALIDA;
            }
            case 608: {
                return TIPO_ORA_REGISTRAZIONE_NON_VALIDA;
            }
            case 609: {
                return ORA_REGISTRAZIONE_SCONOSCIUTA;
            }
            case 610: {
                return TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA;
            }
            case 650: {
                return SCADENZA;
            }
            case 651: {
                return SCADENZA_NON_PRESENTE;
            }
            case 652: {
                return TIPO_SCADENZA_NON_PRESENTE;
            }
            case 653: {
                return SCADENZA_PRESENTE_PIU_VOLTE;
            }
            case 654: {
                return TIPO_SCADENZA_PRESENTE_PIU_VOLTE;
            }
            case 655: {
                return SCADENZA_NON_VALORIZZATA;
            }
            case 656: {
                return TIPO_SCADENZA_NON_VALORIZZATA;
            }
            case 657: {
                return SCADENZA_NON_VALIDA;
            }
            case 658: {
                return TIPO_SCADENZA_NON_VALIDA;
            }
            case 659: {
                return SCADENZA_SCONOSCIUTA;
            }
            case 660: {
                return TIPO_SCADENZA_SCONOSCIUTA;
            }
            case 661: {
                return MESSAGGIO_SCADUTO;
            }
            case 700: {
                return PROFILO_TRASMISSIONE;
            }
            case 701: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI;
            }
            case 702: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE;
            }
            case 703: {
                return PROFILO_TRASMISSIONE_NON_PRESENTE;
            }
            case 704: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_PRESENTE;
            }
            case 705: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE;
            }
            case 706: {
                return PROFILO_TRASMISSIONE_PRESENTE_PIU_VOLTE;
            }
            case 707: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_PRESENTE_PIU_VOLTE;
            }
            case 708: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_PRESENTE_PIU_VOLTE;
            }
            case 709: {
                return PROFILO_TRASMISSIONE_NON_VALORIZZATO;
            }
            case 710: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALORIZZATO;
            }
            case 711: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALORIZZATO;
            }
            case 712: {
                return PROFILO_TRASMISSIONE_NON_VALIDO;
            }
            case 713: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_NON_VALIDO;
            }
            case 714: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_VALIDO;
            }
            case 715: {
                return PROFILO_TRASMISSIONE_SCONOSCIUTO;
            }
            case 716: {
                return PROFILO_TRASMISSIONE_FILTRO_DUPLICATI_SCONOSCIUTO;
            }
            case 717: {
                return PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_SCONOSCIUTO;
            }
            case 750: {
                return CONSEGNA_IN_ORDINE;
            }
            case 751: {
                return CONSEGNA_IN_ORDINE_NON_PRESENTE;
            }
            case 752: {
                return CONSEGNA_IN_ORDINE_PRESENTE_PIU_VOLTE;
            }
            case 753: {
                return CONSEGNA_IN_ORDINE_NON_VALORIZZATA;
            }
            case 754: {
                return CONSEGNA_IN_ORDINE_NON_VALIDA;
            }
            case 755: {
                return CONSEGNA_IN_ORDINE_SCONOSCIUTA;
            }
            case 756: {
                return CONSEGNA_IN_ORDINE_FUORI_SEQUENZA;
            }
            case 757: {
                return CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO;
            }
            case 758: {
                return CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO;
            }
            case 759: {
                return CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO;
            }
            case 760: {
                return CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO;
            }
            case 761: {
                return CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO;
            }
            case 762: {
                return CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO;
            }
            case 763: {
                return CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA;
            }
            case 764: {
                return CONSEGNA_IN_ORDINE_NON_SUPPORTATA;
            }
            case 765: {
                return CONSEGNA_IN_ORDINE_NON_GESTIBILE;
            }
            case 766: {
                return CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA;
            }
            case 800: {
                return SERVIZIO_APPLICATIVO;
            }
            case 801: {
                return SERVIZIO_APPLICATIVO_FRUITORE;
            }
            case 802: {
                return SERVIZIO_APPLICATIVO_EROGATORE;
            }
            case 803: {
                return SERVIZIO_APPLICATIVO_NON_PRESENTE;
            }
            case 804: {
                return SERVIZIO_APPLICATIVO_FRUITORE_NON_PRESENTE;
            }
            case 805: {
                return SERVIZIO_APPLICATIVO_EROGATORE_NON_PRESENTE;
            }
            case 806: {
                return SERVIZIO_APPLICATIVO_PRESENTE_PIU_VOLTE;
            }
            case 807: {
                return SERVIZIO_APPLICATIVO_FRUITORE_PRESENTE_PIU_VOLTE;
            }
            case 808: {
                return SERVIZIO_APPLICATIVO_EROGATORE_PRESENTE_PIU_VOLTE;
            }
            case 809: {
                return SERVIZIO_APPLICATIVO_NON_VALORIZZATO;
            }
            case 810: {
                return SERVIZIO_APPLICATIVO_FRUITORE_NON_VALORIZZATO;
            }
            case 811: {
                return SERVIZIO_APPLICATIVO_EROGATORE_NON_VALORIZZATO;
            }
            case 812: {
                return SERVIZIO_APPLICATIVO_NON_VALIDO;
            }
            case 813: {
                return SERVIZIO_APPLICATIVO_FRUITORE_NON_VALIDO;
            }
            case 814: {
                return SERVIZIO_APPLICATIVO_EROGATORE_NON_VALIDO;
            }
            case 815: {
                return SERVIZIO_APPLICATIVO_SCONOSCIUTO;
            }
            case 816: {
                return SERVIZIO_APPLICATIVO_FRUITORE_SCONOSCIUTO;
            }
            case 817: {
                return SERVIZIO_APPLICATIVO_EROGATORE_SCONOSCIUTO;
            }
            case 850: {
                return LISTA_RISCONTRI;
            }
            case 851: {
                return LISTA_RISCONTRI_NON_PRESENTE;
            }
            case 852: {
                return LISTA_RISCONTRI_PRESENTE_PIU_VOLTE;
            }
            case 853: {
                return LISTA_RISCONTRI_NON_VALORIZZATA;
            }
            case 854: {
                return LISTA_RISCONTRI_NON_VALIDA;
            }
            case 855: {
                return LISTA_RISCONTRI_SCONOSCIUTA;
            }
            case 856: {
                return RISCONTRO;
            }
            case 857: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO;
            }
            case 858: {
                return RISCONTRO_ORA_REGISTRAZIONE;
            }
            case 859: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE;
            }
            case 860: {
                return RISCONTRO_NON_PRESENTE;
            }
            case 861: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_PRESENTE;
            }
            case 862: {
                return RISCONTRO_ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 863: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 864: {
                return RISCONTRO_PRESENTE_PIU_VOLTE;
            }
            case 865: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO_PRESENTE_PIU_VOLTE;
            }
            case 866: {
                return RISCONTRO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 867: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 868: {
                return RISCONTRO_NON_VALORIZZATO;
            }
            case 869: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALORIZZATO;
            }
            case 870: {
                return RISCONTRO_ORA_REGISTRAZIONE_NON_VALORIZZATA;
            }
            case 871: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATO;
            }
            case 872: {
                return RISCONTRO_NON_VALIDO;
            }
            case 873: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO_NON_VALIDO;
            }
            case 874: {
                return RISCONTRO_ORA_REGISTRAZIONE_NON_VALIDA;
            }
            case 875: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE_NON_VALIDO;
            }
            case 876: {
                return RISCONTRO_SCONOSCIUTO;
            }
            case 877: {
                return RISCONTRO_IDENTIFICATIVO_MESSAGGIO_SCONOSCIUTO;
            }
            case 878: {
                return RISCONTRO_ORA_REGISTRAZIONE_SCONOSCIUTA;
            }
            case 879: {
                return RISCONTRO_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTO;
            }
            case 900: {
                return LISTA_TRASMISSIONI;
            }
            case 901: {
                return LISTA_TRASMISSIONI_NON_PRESENTE;
            }
            case 902: {
                return LISTA_TRASMISSIONI_PRESENTE_PIU_VOLTE;
            }
            case 903: {
                return LISTA_TRASMISSIONI_NON_VALORIZZATA;
            }
            case 904: {
                return LISTA_TRASMISSIONI_NON_VALIDA;
            }
            case 905: {
                return LISTA_TRASMISSIONI_SCONOSCIUTA;
            }
            case 906: {
                return TRASMISSIONE;
            }
            case 907: {
                return TRASMISSIONE_TIPO_ORIGINE;
            }
            case 908: {
                return TRASMISSIONE_ORIGINE;
            }
            case 909: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE;
            }
            case 910: {
                return TRASMISSIONE_IDPORTA_ORIGINE;
            }
            case 911: {
                return TRASMISSIONE_TIPO_DESTINAZIONE;
            }
            case 912: {
                return TRASMISSIONE_DESTINAZIONE;
            }
            case 913: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE;
            }
            case 914: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE;
            }
            case 915: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE;
            }
            case 916: {
                return TRASMISSIONE_ORA_REGISTRAZIONE;
            }
            case 917: {
                return TRASMISSIONE_NON_PRESENTE;
            }
            case 918: {
                return TRASMISSIONE_TIPO_ORIGINE_NON_PRESENTE;
            }
            case 919: {
                return TRASMISSIONE_ORIGINE_NON_PRESENTE;
            }
            case 920: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE_NON_PRESENTE;
            }
            case 921: {
                return TRASMISSIONE_IDPORTA_ORIGINE_NON_PRESENTE;
            }
            case 922: {
                return TRASMISSIONE_TIPO_DESTINAZIONE_NON_PRESENTE;
            }
            case 923: {
                return TRASMISSIONE_DESTINAZIONE_NON_PRESENTE;
            }
            case 924: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_PRESENTE;
            }
            case 925: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_PRESENTE;
            }
            case 926: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 927: {
                return TRASMISSIONE_ORA_REGISTRAZIONE_NON_PRESENTE;
            }
            case 928: {
                return TRASMISSIONE_PRESENTE_PIU_VOLTE;
            }
            case 929: {
                return TRASMISSIONE_TIPO_ORIGINE_PRESENTE_PIU_VOLTE;
            }
            case 930: {
                return TRASMISSIONE_ORIGINE_PRESENTE_PIU_VOLTE;
            }
            case 931: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE_PRESENTE_PIU_VOLTE;
            }
            case 932: {
                return TRASMISSIONE_IDPORTA_ORIGINE_PRESENTE_PIU_VOLTE;
            }
            case 933: {
                return TRASMISSIONE_TIPO_DESTINAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 934: {
                return TRASMISSIONE_DESTINAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 935: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 936: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 937: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 938: {
                return TRASMISSIONE_ORA_REGISTRAZIONE_PRESENTE_PIU_VOLTE;
            }
            case 939: {
                return TRASMISSIONE_NON_VALORIZZATA;
            }
            case 940: {
                return TRASMISSIONE_TIPO_ORIGINE_NON_VALORIZZATA;
            }
            case 941: {
                return TRASMISSIONE_ORIGINE_NON_VALORIZZATA;
            }
            case 942: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALORIZZATA;
            }
            case 943: {
                return TRASMISSIONE_IDPORTA_ORIGINE_NON_VALORIZZATA;
            }
            case 944: {
                return TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALORIZZATA;
            }
            case 945: {
                return TRASMISSIONE_DESTINAZIONE_NON_VALORIZZATA;
            }
            case 946: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALORIZZATA;
            }
            case 947: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALORIZZATA;
            }
            case 948: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALORIZZATA;
            }
            case 949: {
                return TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALORIZZATA;
            }
            case 950: {
                return TRASMISSIONE_NON_VALIDA;
            }
            case 951: {
                return TRASMISSIONE_TIPO_ORIGINE_NON_VALIDA;
            }
            case 952: {
                return TRASMISSIONE_ORIGINE_NON_VALIDA;
            }
            case 953: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE_NON_VALIDA;
            }
            case 954: {
                return TRASMISSIONE_IDPORTA_ORIGINE_NON_VALIDA;
            }
            case 955: {
                return TRASMISSIONE_TIPO_DESTINAZIONE_NON_VALIDA;
            }
            case 956: {
                return TRASMISSIONE_DESTINAZIONE_NON_VALIDA;
            }
            case 957: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE_NON_VALIDA;
            }
            case 958: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE_NON_VALIDA;
            }
            case 959: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_NON_VALIDA;
            }
            case 960: {
                return TRASMISSIONE_ORA_REGISTRAZIONE_NON_VALIDA;
            }
            case 961: {
                return TRASMISSIONE_SCONOSCIUTA;
            }
            case 962: {
                return TRASMISSIONE_TIPO_ORIGINE_SCONOSCIUTA;
            }
            case 963: {
                return TRASMISSIONE_ORIGINE_SCONOSCIUTA;
            }
            case 964: {
                return TRASMISSIONE_INDIRIZZO_ORIGINE_SCONOSCIUTA;
            }
            case 965: {
                return TRASMISSIONE_IDPORTA_ORIGINE_SCONOSCIUTA;
            }
            case 966: {
                return TRASMISSIONE_TIPO_DESTINAZIONE_SCONOSCIUTA;
            }
            case 967: {
                return TRASMISSIONE_DESTINAZIONE_SCONOSCIUTA;
            }
            case 968: {
                return TRASMISSIONE_INDIRIZZO_DESTINAZIONE_SCONOSCIUTA;
            }
            case 969: {
                return TRASMISSIONE_IDPORTA_DESTINAZIONE_SCONOSCIUTA;
            }
            case 970: {
                return TRASMISSIONE_TIPO_ORA_REGISTRAZIONE_SCONOSCIUTA;
            }
            case 971: {
                return TRASMISSIONE_ORA_REGISTRAZIONE_SCONOSCIUTA;
            }
            case 1000: {
                return LISTA_ECCEZIONI;
            }
            case 1001: {
                return LISTA_ECCEZIONI_NON_PRESENTE;
            }
            case 1002: {
                return LISTA_ECCEZIONI_PRESENTE_PIU_VOLTE;
            }
            case 1003: {
                return LISTA_ECCEZIONI_NON_VALORIZZATA;
            }
            case 1004: {
                return LISTA_ECCEZIONI_NON_VALIDA;
            }
            case 1005: {
                return LISTA_ECCEZIONI_SCONOSCIUTA;
            }
            case 1006: {
                return ECCEZIONE;
            }
            case 1007: {
                return ECCEZIONE_CODICE;
            }
            case 1008: {
                return ECCEZIONE_CONTESTO;
            }
            case 1009: {
                return ECCEZIONE_POSIZIONE;
            }
            case 1010: {
                return ECCEZIONE_RILEVANZA;
            }
            case 1011: {
                return ECCEZIONE_NON_PRESENTE;
            }
            case 1012: {
                return ECCEZIONE_CODICE_NON_PRESENTE;
            }
            case 1013: {
                return ECCEZIONE_CONTESTO_NON_PRESENTE;
            }
            case 1014: {
                return ECCEZIONE_POSIZIONE_NON_PRESENTE;
            }
            case 1015: {
                return ECCEZIONE_RILEVANZA_NON_PRESENTE;
            }
            case 1016: {
                return ECCEZIONE_PRESENTE_PIU_VOLTE;
            }
            case 1017: {
                return ECCEZIONE_CODICE_PRESENTE_PIU_VOLTE;
            }
            case 1018: {
                return ECCEZIONE_CONTESTO_PRESENTE_PIU_VOLTE;
            }
            case 1019: {
                return ECCEZIONE_POSIZIONE_PRESENTE_PIU_VOLTE;
            }
            case 1020: {
                return ECCEZIONE_RILEVANZA_PRESENTE_PIU_VOLTE;
            }
            case 1021: {
                return ECCEZIONE_NON_VALORIZZATA;
            }
            case 1022: {
                return ECCEZIONE_CODICE_NON_VALORIZZATA;
            }
            case 1023: {
                return ECCEZIONE_CONTESTO_NON_VALORIZZATA;
            }
            case 1024: {
                return ECCEZIONE_POSIZIONE_NON_VALORIZZATA;
            }
            case 1025: {
                return ECCEZIONE_RILEVANZA_NON_VALORIZZATA;
            }
            case 1026: {
                return ECCEZIONE_NON_VALIDA;
            }
            case 1027: {
                return ECCEZIONE_CODICE_NON_VALIDA;
            }
            case 1028: {
                return ECCEZIONE_CONTESTO_NON_VALIDA;
            }
            case 1029: {
                return ECCEZIONE_POSIZIONE_NON_VALIDA;
            }
            case 1030: {
                return ECCEZIONE_RILEVANZA_NON_VALIDA;
            }
            case 1031: {
                return ECCEZIONE_SCONOSCIUTA;
            }
            case 1032: {
                return ECCEZIONE_CODICE_SCONOSCIUTA;
            }
            case 1033: {
                return ECCEZIONE_CONTESTO_SCONOSCIUTA;
            }
            case 1034: {
                return ECCEZIONE_POSIZIONE_SCONOSCIUTA;
            }
            case 1035: {
                return ECCEZIONE_RILEVANZA_SCONOSCIUTA;
            }
            case 1300: {
                return SOAPFAULT;
            }
            case 1301: {
                return SOAPFAULT_CODE;
            }
            case 1302: {
                return SOAPFAULT_STRING;
            }
            case 1303: {
                return SOAPFAULT_ACTOR;
            }
            case 1304: {
                return SOAPFAULT_DETAIL;
            }
            case 1305: {
                return SOAPFAULT_NON_PRESENTE;
            }
            case 1306: {
                return SOAPFAULT_CODE_NON_PRESENTE;
            }
            case 1307: {
                return SOAPFAULT_STRING_NON_PRESENTE;
            }
            case 1308: {
                return SOAPFAULT_ACTOR_NON_PRESENTE;
            }
            case 1309: {
                return SOAPFAULT_DETAIL_NON_PRESENTE;
            }
            case 1310: {
                return SOAPFAULT_PRESENTE_PIU_VOLTE;
            }
            case 1311: {
                return SOAPFAULT_CODE_PRESENTE_PIU_VOLTE;
            }
            case 1312: {
                return SOAPFAULT_STRING_PRESENTE_PIU_VOLTE;
            }
            case 1313: {
                return SOAPFAULT_ACTOR_PRESENTE_PIU_VOLTE;
            }
            case 1314: {
                return SOAPFAULT_DETAIL_PRESENTE_PIU_VOLTE;
            }
            case 1315: {
                return SOAPFAULT_NON_VALORIZZATO;
            }
            case 1316: {
                return SOAPFAULT_CODE_NON_VALORIZZATO;
            }
            case 1317: {
                return SOAPFAULT_STRING_NON_VALORIZZATO;
            }
            case 1318: {
                return SOAPFAULT_ACTOR_NON_VALORIZZATO;
            }
            case 1319: {
                return SOAPFAULT_DETAIL_NON_VALORIZZATO;
            }
            case 1320: {
                return SOAPFAULT_NON_VALIDO;
            }
            case 1321: {
                return SOAPFAULT_CODE_NON_VALIDO;
            }
            case 1322: {
                return SOAPFAULT_STRING_NON_VALIDO;
            }
            case 1323: {
                return SOAPFAULT_ACTOR_NON_VALIDO;
            }
            case 1324: {
                return SOAPFAULT_DETAIL_NON_VALIDO;
            }
            case 1325: {
                return SOAPFAULT_SCONOSCIUTO;
            }
            case 1326: {
                return SOAPFAULT_CODE_SCONOSCIUTO;
            }
            case 1327: {
                return SOAPFAULT_STRING_SCONOSCIUTO;
            }
            case 1328: {
                return SOAPFAULT_ACTOR_SCONOSCIUTO;
            }
            case 1329: {
                return SOAPFAULT_DETAIL_SCONOSCIUTO;
            }
            case 1350: {
                return SICUREZZA;
            }
            case 1351: {
                return SICUREZZA_FALSIFICAZIONE_MITTENTE;
            }
            case 1352: {
                return SICUREZZA_AUTORIZZAZIONE_FALLITA;
            }
            case 1353: {
                return SICUREZZA_FIRMA_INTESTAZIONE_NON_VALIDA;
            }
            case 1354: {
                return SICUREZZA_FIRMA_INTESTAZIONE_NON_PRESENTE;
            }
            case 1355: {
                return SICUREZZA_FIRMA_NON_VALIDA;
            }
            case 1356: {
                return SICUREZZA_FIRMA_NON_PRESENTE;
            }
            case 1357: {
                return SICUREZZA_FIRMA_ALLEGATO_NON_VALIDA;
            }
            case 1358: {
                return SICUREZZA_FIRMA_ALLEGATO_NON_PRESENTE;
            }
            case 1359: {
                return SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_VALIDA;
            }
            case 1360: {
                return SICUREZZA_FIRMA_PKCS7_ALLEGATO_NON_PRESENTE;
            }
            case 1361: {
                return SICUREZZA_CIFRATURA_NON_VALIDA;
            }
            case 1362: {
                return SICUREZZA_CIFRATURA_NON_PRESENTE;
            }
            case 1363: {
                return SICUREZZA_CIFRATURA_ALLEGATO_NON_VALIDA;
            }
            case 1364: {
                return SICUREZZA_CIFRATURA_ALLEGATO_NON_PRESENTE;
            }
            case 1365: {
                return SICUREZZA_NON_PRESENTE;
            }
            case 1400: {
                return ALLEGATI;
            }
            case 1401: {
                return ALLEGATI_RIFERIMENTO_NON_PRESENTE;
            }
            case 1402: {
                return ALLEGATI_RIFERIMENTO_NON_VALIDO;
            }
            case 1403: {
                return ALLEGATO_NON_PRESENTE;
            }
            case 1404: {
                return ALLEGATO_NON_DEFINITO_MANIFEST;
            }
            case 2000: {
                return ECCEZIONE_GENERICA;
            }
        }
        return UNKNOWN;
    }
}

