/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants;

import java.io.BufferedReader;
import java.io.StringReader;

public enum ArchiveVersion {
    V_UNDEFINED,
    V_1,
    V_OTHER;

    public static final ArchiveVersion OPENSPCOOP2_ARCHIVE_ACTUAL_VERSION;

    public static ArchiveVersion toArchiveVersion(byte[] content) {
        return ArchiveVersion.toArchiveVersion(new String(content));
    }

    public static ArchiveVersion toArchiveVersion(String content) {
        if (content == null) {
            return V_UNDEFINED;
        }
        StringReader sr = new StringReader(content);
        BufferedReader br = new BufferedReader(sr);
        try {
            String v = br.readLine();
            if (V_1.name().equals(v)) {
                return V_1;
            }
            return V_OTHER;
        }
        catch (Exception e) {
            return V_UNDEFINED;
        }
    }

    public static String toProductVersion(byte[] content) {
        return ArchiveVersion.toProductVersion(new String(content));
    }

    public static String toProductVersion(String content) {
        if (content == null) {
            return null;
        }
        StringReader sr = new StringReader(content);
        BufferedReader br = new BufferedReader(sr);
        try {
            String v = br.readLine();
            StringBuffer bf = new StringBuffer();
            while ((v = br.readLine()) != null) {
                if (bf.length() > 0) {
                    bf.append("\n");
                }
                bf.append(v);
            }
            return bf.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getContentFileVersion(String pddVersion) {
        return OPENSPCOOP2_ARCHIVE_ACTUAL_VERSION.name() + "\n" + pddVersion;
    }

    static {
        OPENSPCOOP2_ARCHIVE_ACTUAL_VERSION = V_1;
    }
}

