/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveModeType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ArchiveType;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class MappingModeTypesExtensions {
    private Hashtable<String, List<ArchiveModeType>> mappingExtensionsTypes = new Hashtable();
    private Hashtable<String, ArchiveType> mappingExtensionsArchiveType = new Hashtable();
    private List<String> exts = new ArrayList<String>();

    public void add(String ext, ArchiveModeType type) throws ProtocolException {
        this.add(ext, (ArchiveType)null, type);
    }

    public void add(String ext, ArchiveType archiveType, ArchiveModeType type) throws ProtocolException {
        ArrayList<ArchiveModeType> l = new ArrayList<ArchiveModeType>();
        l.add(type);
        this.add(ext, archiveType, l);
    }

    public void add(String ext, ArchiveModeType ... types) throws ProtocolException {
        this.add(ext, (ArchiveType)null, types);
    }

    public void add(String ext, ArchiveType archiveType, ArchiveModeType ... types) throws ProtocolException {
        ArrayList<ArchiveModeType> l = new ArrayList<ArchiveModeType>();
        for (int i = 0; i < types.length; ++i) {
            l.add(types[i]);
        }
        this.add(ext, archiveType, l);
    }

    public void add(String ext, List<ArchiveModeType> listTypes) throws ProtocolException {
        this.add(ext, null, listTypes);
    }

    public void add(String ext, ArchiveType archiveType, List<ArchiveModeType> listTypes) throws ProtocolException {
        List<Object> l = null;
        l = this.mappingExtensionsTypes.containsKey(ext) ? this.mappingExtensionsTypes.remove(ext) : new ArrayList();
        for (ArchiveModeType type : listTypes) {
            if (l.contains(type)) {
                throw new ProtocolException("Type[" + type + "] already exists for extension [" + ext + "]");
            }
            l.add(type);
        }
        this.mappingExtensionsTypes.put(ext, l);
        if (archiveType != null) {
            this.mappingExtensionsArchiveType.put(ext, archiveType);
        }
        if (!this.exts.contains(ext)) {
            this.exts.add(ext);
        }
    }

    public String mappingTypeToFirstExt(ArchiveModeType type) {
        return this.mappingTypeToExt(type, 0);
    }

    public String mappingTypeToExt(ArchiveModeType type, int index) {
        List<String> l = this.mappingTypeToExts(type);
        if (l.size() >= index + 1) {
            return l.get(index);
        }
        return null;
    }

    public List<String> mappingTypeToExts(ArchiveModeType type) {
        ArrayList<String> exts = new ArrayList<String>();
        for (int i = 0; i < this.exts.size(); ++i) {
            String ext = this.exts.get(i);
            List<ArchiveModeType> types = this.mappingExtensionsTypes.get(ext);
            if (!types.contains(type)) continue;
            exts.add(ext);
        }
        return exts;
    }

    public ArchiveModeType mappingExtToFirstType(String ext) {
        return this.mappingExtToType(ext, 0);
    }

    public ArchiveModeType mappingExtToType(String ext, int index) {
        if (this.mappingExtensionsTypes.containsKey(ext)) {
            List<ArchiveModeType> l = this.mappingExtensionsTypes.get(ext);
            if (l.size() >= index + 1) {
                return l.get(index);
            }
            return null;
        }
        return null;
    }

    public List<ArchiveModeType> mappingExtToTypes(String ext) {
        if (this.mappingExtensionsTypes.containsKey(ext)) {
            return this.mappingExtensionsTypes.get(ext);
        }
        return null;
    }

    public List<String> getExtensions() {
        return this.exts;
    }

    public List<ArchiveModeType> getTypes(String ext) {
        return this.mappingExtensionsTypes.get(ext);
    }

    public List<ArchiveModeType> getAllTypes() {
        ArrayList<ArchiveModeType> typesAll = new ArrayList<ArchiveModeType>();
        List<String> exts = this.getExtensions();
        for (int i = 0; i < exts.size(); ++i) {
            List<ArchiveModeType> types = this.getTypes(exts.get(i));
            for (ArchiveModeType type : types) {
                if (typesAll.contains(type)) continue;
                typesAll.add(type);
            }
        }
        return typesAll;
    }

    public String mappingArchiveTypeToExt(ArchiveType type) {
        Enumeration<String> exts = this.mappingExtensionsArchiveType.keys();
        while (exts.hasMoreElements()) {
            String ext = exts.nextElement();
            ArchiveType check = this.mappingExtensionsArchiveType.get(ext);
            if (!check.equals((Object)type)) continue;
            return ext;
        }
        return null;
    }
}

