/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchiveObject;

public class ArchiveSoggetto
implements IArchiveObject {
    private IDSoggetto idSoggetto;
    private it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistro;
    private Soggetto soggettoConfigurazione;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Soggetto_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveSoggetto.buildKey(this.idSoggetto.getTipo(), this.idSoggetto.getNome());
    }

    public ArchiveSoggetto(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistro, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoRegistro == null) {
            throw new ProtocolException("SoggettoRegistro non fornito");
        }
        if (soggettoRegistro.getNome() == null) {
            throw new ProtocolException("SoggettoRegistro.nome non definito");
        }
        if (soggettoRegistro.getTipo() == null) {
            throw new ProtocolException("SoggettoRegistro.tipo non definito");
        }
        this.soggettoRegistro = soggettoRegistro;
        this.idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public ArchiveSoggetto(Soggetto soggettoConfigurazione, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoConfigurazione == null) {
            throw new ProtocolException("SoggettoConfigurazione non fornito");
        }
        if (soggettoConfigurazione.getNome() == null) {
            throw new ProtocolException("SoggettoConfigurazione.nome non definito");
        }
        if (soggettoConfigurazione.getTipo() == null) {
            throw new ProtocolException("SoggettoConfigurazione.tipo non definito");
        }
        this.soggettoConfigurazione = soggettoConfigurazione;
        this.idSoggetto = new IDSoggetto(soggettoConfigurazione.getTipo(), soggettoConfigurazione.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public ArchiveSoggetto(Soggetto soggettoConfigurazione, it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistro, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (soggettoRegistro == null) {
            throw new ProtocolException("SoggettoRegistro non fornito");
        }
        if (soggettoRegistro.getNome() == null) {
            throw new ProtocolException("SoggettoRegistro.nome non definito");
        }
        if (soggettoRegistro.getTipo() == null) {
            throw new ProtocolException("SoggettoRegistro.tipo non definito");
        }
        this.soggettoRegistro = soggettoRegistro;
        if (soggettoConfigurazione == null) {
            throw new ProtocolException("SoggettoConfigurazione non fornito");
        }
        if (soggettoConfigurazione.getNome() == null) {
            throw new ProtocolException("SoggettoConfigurazione.nome non definito");
        }
        if (!soggettoRegistro.getNome().equals(soggettoConfigurazione.getNome())) {
            throw new ProtocolException("SoggettoRegistro.nome e SoggettoConfigurazione.nome devono coincidere");
        }
        if (soggettoConfigurazione.getTipo() == null) {
            throw new ProtocolException("SoggettoConfigurazione.tipo non definito");
        }
        if (!soggettoRegistro.getTipo().equals(soggettoConfigurazione.getTipo())) {
            throw new ProtocolException("SoggettoRegistro.tipo e SoggettoConfigurazione.tipo devono coincidere");
        }
        this.soggettoConfigurazione = soggettoConfigurazione;
        this.idSoggetto = new IDSoggetto(soggettoRegistro.getTipo(), soggettoRegistro.getNome());
        this.idCorrelazione = idCorrelazione;
    }

    public IDSoggetto getIdSoggetto() {
        return this.idSoggetto;
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto getSoggettoRegistro() {
        return this.soggettoRegistro;
    }

    public Soggetto getSoggettoConfigurazione() {
        return this.soggettoConfigurazione;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

