/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchiveObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;

public class ArchiveRuolo
implements IArchiveObject {
    private IDRuolo idRuolo;
    private Ruolo ruolo;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String nomeRuolo) throws ProtocolException {
        if (nomeRuolo == null) {
            throw new ProtocolException("nomeRuolo non fornito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Ruolo_");
        bf.append(nomeRuolo);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveRuolo.buildKey(this.idRuolo.getNome());
    }

    public ArchiveRuolo(Ruolo ruolo, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (ruolo == null) {
            throw new ProtocolException("Ruolo non fornito");
        }
        if (ruolo.getNome() == null) {
            throw new ProtocolException("Ruolo.nome non definito");
        }
        this.idRuolo = new IDRuolo(ruolo.getNome());
        this.ruolo = ruolo;
        this.idCorrelazione = idCorrelazione;
    }

    public IDRuolo getIdRuolo() {
        return this.idRuolo;
    }

    public Ruolo getRuolo() {
        return this.ruolo;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

