/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchiveObject;

public class ArchivePortaDelegata
implements IArchiveObject {
    private IDSoggetto idSoggettoProprietario;
    private IDPortaDelegata idPortaDelegata;
    private PortaDelegata portaDelegata;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto, String nomePorta) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomePorta == null) {
            throw new ProtocolException("nomePorta non fornito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("PortaDelegata_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomePorta);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchivePortaDelegata.buildKey(this.idSoggettoProprietario.getTipo(), this.idSoggettoProprietario.getNome(), this.idPortaDelegata.getLocationPD());
    }

    public ArchivePortaDelegata(IDSoggetto idSoggettoProprietario, PortaDelegata portaDelegata, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(ArchivePortaDelegata.injectProprietario(idSoggettoProprietario, portaDelegata), idCorrelazione, false);
    }

    public ArchivePortaDelegata(IDSoggetto idSoggettoProprietario, PortaDelegata portaDelegata, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this(ArchivePortaDelegata.injectProprietario(idSoggettoProprietario, portaDelegata), idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchivePortaDelegata(PortaDelegata portaDelegata, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(portaDelegata, idCorrelazione, false);
    }

    public ArchivePortaDelegata(PortaDelegata portaDelegata, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(portaDelegata, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    private static PortaDelegata injectProprietario(IDSoggetto idSoggettoProprietario, PortaDelegata portaDelegata) throws ProtocolException {
        if (portaDelegata == null) {
            throw new ProtocolException("PortaDelegata non fornita");
        }
        if (idSoggettoProprietario == null) {
            throw new ProtocolException("idSoggettoProprietario non fornito");
        }
        if (idSoggettoProprietario.getTipo() == null) {
            throw new ProtocolException("idSoggettoProprietario.tipo non definito");
        }
        if (idSoggettoProprietario.getNome() == null) {
            throw new ProtocolException("idSoggettoProprietario.nome non definito");
        }
        portaDelegata.setTipoSoggettoProprietario(idSoggettoProprietario.getTipo());
        portaDelegata.setNomeSoggettoProprietario(idSoggettoProprietario.getNome());
        return portaDelegata;
    }

    public void update() throws ProtocolException {
        this.update(this.portaDelegata, false);
    }

    public void update(PortaDelegata portaDelegata) throws ProtocolException {
        this.update(portaDelegata, false);
    }

    public void update(PortaDelegata portaDelegata, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (portaDelegata == null) {
            throw new ProtocolException("PortaDelegata non fornita");
        }
        if (portaDelegata.getNome() == null) {
            throw new ProtocolException("PortaDelegata.nome non definito");
        }
        this.portaDelegata = portaDelegata;
        if (!informationMissingManagementEnabled) {
            if (this.portaDelegata.getTipoSoggettoProprietario() == null) {
                throw new ProtocolException("PortaDelegata.tipoSoggettoProprietario non definito");
            }
            if (this.portaDelegata.getNomeSoggettoProprietario() == null) {
                throw new ProtocolException("PortaDelegata.nomeSoggettoProprietario non definito");
            }
            this.idSoggettoProprietario = new IDSoggetto(this.portaDelegata.getTipoSoggettoProprietario(), this.portaDelegata.getNomeSoggettoProprietario());
            this.idPortaDelegata = new IDPortaDelegata();
            this.idPortaDelegata.setSoggettoFruitore(this.idSoggettoProprietario);
            this.idPortaDelegata.setLocationPD(this.portaDelegata.getNome());
            if (this.portaDelegata.getLocation() != null && !"".equals(this.portaDelegata.getLocation())) {
                this.idPortaDelegata.setLocationPD(this.portaDelegata.getLocation());
            }
        }
    }

    public IDSoggetto getIdSoggettoProprietario() {
        return this.idSoggettoProprietario;
    }

    public IDPortaDelegata getIdPortaDelegata() {
        return this.idPortaDelegata;
    }

    public PortaDelegata getPortaDelegata() {
        return this.portaDelegata;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

