/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchiveObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;

public class ArchiveFruitore
implements IArchiveObject {
    private IDSoggetto idSoggettoFruitore;
    private IDAccordo idAccordoServizioParteSpecifica;
    private Fruitore fruitore;
    private IDPortaDelegata idPortaDelegataAssociata;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggettoFruitore, String nomeSoggettoFruitore, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String nomeAccordo, String versione) throws ProtocolException {
        if (tipoSoggettoFruitore == null) {
            throw new ProtocolException("tipoSoggettoFruitore non fornito");
        }
        if (nomeSoggettoFruitore == null) {
            throw new ProtocolException("nomeSoggettoFruitore non fornito");
        }
        if (tipoSoggettoErogatore == null) {
            throw new ProtocolException("tipoSoggettoErogatore non fornito");
        }
        if (nomeSoggettoErogatore == null) {
            throw new ProtocolException("nomeSoggettoErogatore non fornito");
        }
        if (nomeAccordo == null) {
            throw new ProtocolException("nomeAccordo non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versione non fornito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("Fruitore_");
        bf.append(tipoSoggettoFruitore);
        bf.append("/");
        bf.append(nomeSoggettoFruitore);
        bf.append("_AccordoServizioParteSpecifica_");
        bf.append(tipoSoggettoErogatore);
        bf.append("/");
        bf.append(nomeSoggettoErogatore);
        bf.append("_");
        bf.append(nomeAccordo);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveFruitore.buildKey(this.idSoggettoFruitore.getTipo(), this.idSoggettoFruitore.getNome(), this.idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo(), this.idAccordoServizioParteSpecifica.getSoggettoReferente().getNome(), this.idAccordoServizioParteSpecifica.getNome(), this.idAccordoServizioParteSpecifica.getVersione());
    }

    public IDPortaDelegata getIdPortaDelegataAssociata() {
        return this.idPortaDelegataAssociata;
    }

    public void setIdPortaDelegataAssociata(IDPortaDelegata idPortaDelegataAssociata) {
        this.idPortaDelegataAssociata = idPortaDelegataAssociata;
    }

    public ArchiveFruitore(IDAccordo idAccordoServizioParteSpecifica, Fruitore fruitore, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(idAccordoServizioParteSpecifica, fruitore, idCorrelazione, false);
    }

    public ArchiveFruitore(IDAccordo idAccordoServizioParteSpecifica, Fruitore fruitore, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(idAccordoServizioParteSpecifica, fruitore, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    public void update() throws ProtocolException {
        this.update(this.idAccordoServizioParteSpecifica, this.fruitore, false);
    }

    public void update(IDAccordo idAccordoServizioParteSpecifica, Fruitore fruitore) throws ProtocolException {
        this.update(idAccordoServizioParteSpecifica, fruitore, false);
    }

    public void update(IDAccordo idAccordoServizioParteSpecifica, Fruitore fruitore, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (fruitore == null) {
            throw new ProtocolException("fruitore non definito");
        }
        if (fruitore.getTipo() == null) {
            throw new ProtocolException("fruitore.tipo non definito");
        }
        if (fruitore.getNome() == null) {
            throw new ProtocolException("fruitore.nome non definito");
        }
        this.idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
        this.fruitore = fruitore;
        if (idAccordoServizioParteSpecifica == null) {
            throw new ProtocolException("idAccordoServizioParteSpecifica non fornito");
        }
        if (idAccordoServizioParteSpecifica.getNome() == null) {
            throw new ProtocolException("idAccordoServizioParteSpecifica.nome non definito");
        }
        if (!informationMissingManagementEnabled) {
            if (idAccordoServizioParteSpecifica.getVersione() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.versione non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoReferente() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoReferente non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoReferente().getTipo() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoReferente.tipo non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoReferente().getNome() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoReferente.nome non definito");
            }
        }
        this.idAccordoServizioParteSpecifica = idAccordoServizioParteSpecifica;
    }

    public IDSoggetto getIdSoggettoFruitore() {
        return this.idSoggettoFruitore;
    }

    public IDAccordo getIdAccordoServizioParteSpecifica() {
        return this.idAccordoServizioParteSpecifica;
    }

    public Fruitore getFruitore() {
        return this.fruitore;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

