/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchiveObject;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;

public class ArchiveAccordoServizioParteSpecifica
implements IArchiveObject {
    private IDSoggetto idSoggettoErogatore;
    private IDAccordo idAccordoServizioParteSpecifica;
    private IDServizio idServizio;
    private IDAccordo idAccordoServizioParteComune;
    private AccordoServizioParteSpecifica accordoServizioParteSpecifica;
    private IDPortaApplicativaByNome idPortaApplicativaAssociata;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versione) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomeAccordo == null) {
            throw new ProtocolException("nomeAccordo non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("AccordoServizioParteSpecifica_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomeAccordo);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        String tipoSoggetto = "-";
        String nomeSoggetto = "-";
        String nomeAccordo = this.accordoServizioParteSpecifica.getNome();
        String versione = "-";
        if (this.accordoServizioParteSpecifica.getServizio() != null) {
            if (this.accordoServizioParteSpecifica.getServizio().getTipoSoggettoErogatore() != null) {
                tipoSoggetto = this.accordoServizioParteSpecifica.getServizio().getTipoSoggettoErogatore();
            }
            if (this.accordoServizioParteSpecifica.getServizio().getNomeSoggettoErogatore() != null) {
                nomeSoggetto = this.accordoServizioParteSpecifica.getServizio().getNomeSoggettoErogatore();
            }
        }
        if (this.accordoServizioParteSpecifica.getVersione() != null) {
            versione = this.accordoServizioParteSpecifica.getVersione();
        }
        return ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggetto, nomeSoggetto, nomeAccordo, versione);
    }

    public IDPortaApplicativaByNome getIdPortaApplicativaAssociata() {
        return this.idPortaApplicativaAssociata;
    }

    public void setIdPortaApplicativaAssociata(IDPortaApplicativaByNome idPortaApplicativaAssociata) {
        this.idPortaApplicativaAssociata = idPortaApplicativaAssociata;
    }

    public ArchiveAccordoServizioParteSpecifica(IDSoggetto idSoggettoProprietario, AccordoServizioParteSpecifica accordoServizioParteSpecifica, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(ArchiveAccordoServizioParteSpecifica.injectProprietario(idSoggettoProprietario, accordoServizioParteSpecifica), idCorrelazione, false);
    }

    public ArchiveAccordoServizioParteSpecifica(IDSoggetto idSoggettoProprietario, AccordoServizioParteSpecifica accordoServizioParteSpecifica, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this(ArchiveAccordoServizioParteSpecifica.injectProprietario(idSoggettoProprietario, accordoServizioParteSpecifica), idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchiveAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(accordoServizioParteSpecifica, idCorrelazione, false);
    }

    public ArchiveAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(accordoServizioParteSpecifica, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    private static AccordoServizioParteSpecifica injectProprietario(IDSoggetto idSoggettoProprietario, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws ProtocolException {
        if (accordoServizioParteSpecifica == null) {
            throw new ProtocolException("AccordoServizioParteSpecifica non fornito");
        }
        if (accordoServizioParteSpecifica.getServizio() == null) {
            throw new ProtocolException("AccordoServizioParteSpecifica.servizio non definito");
        }
        if (idSoggettoProprietario == null) {
            throw new ProtocolException("idSoggettoProprietario non fornito");
        }
        if (idSoggettoProprietario.getTipo() == null) {
            throw new ProtocolException("idSoggettoProprietario.tipo non definito");
        }
        if (idSoggettoProprietario.getNome() == null) {
            throw new ProtocolException("idSoggettoProprietario.nome non definito");
        }
        accordoServizioParteSpecifica.getServizio().setTipoSoggettoErogatore(idSoggettoProprietario.getTipo());
        accordoServizioParteSpecifica.getServizio().setNomeSoggettoErogatore(idSoggettoProprietario.getNome());
        return accordoServizioParteSpecifica;
    }

    public void update() throws ProtocolException {
        this.update(this.accordoServizioParteSpecifica, false);
    }

    public void update(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws ProtocolException {
        this.update(accordoServizioParteSpecifica, false);
    }

    public void update(AccordoServizioParteSpecifica accordoServizioParteSpecifica, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (accordoServizioParteSpecifica == null) {
            throw new ProtocolException("AccordoServizioParteComune non fornito");
        }
        if (accordoServizioParteSpecifica.getNome() == null) {
            throw new ProtocolException("AccordoServizioParteComune.nome non definito");
        }
        if (accordoServizioParteSpecifica.getServizio() == null) {
            throw new ProtocolException("AccordoServizioParteSpecifica.servizio non definito");
        }
        if (accordoServizioParteSpecifica.getServizio().getTipo() == null) {
            throw new ProtocolException("AccordoServizioParteComune.servizio.tipo non definito");
        }
        if (accordoServizioParteSpecifica.getServizio().getNome() == null) {
            throw new ProtocolException("AccordoServizioParteComune.servizio.nome non definito");
        }
        this.accordoServizioParteSpecifica = accordoServizioParteSpecifica;
        if (!informationMissingManagementEnabled) {
            if (accordoServizioParteSpecifica.getVersione() == null) {
                throw new ProtocolException("AccordoServizioParteComune.versione non definito");
            }
            if (accordoServizioParteSpecifica.getServizio().getTipoSoggettoErogatore() == null) {
                throw new ProtocolException("AccordoServizioParteComune.servizio.tipoSoggettoErogatore non definito");
            }
            if (accordoServizioParteSpecifica.getServizio().getNomeSoggettoErogatore() == null) {
                throw new ProtocolException("AccordoServizioParteComune.servizio.nomeSoggettoErogatore non definito");
            }
            this.idSoggettoErogatore = new IDSoggetto(accordoServizioParteSpecifica.getServizio().getTipoSoggettoErogatore(), accordoServizioParteSpecifica.getServizio().getNomeSoggettoErogatore());
            try {
                this.idAccordoServizioParteSpecifica = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(accordoServizioParteSpecifica);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            this.idServizio = new IDServizio(this.idSoggettoErogatore, accordoServizioParteSpecifica.getServizio().getTipo(), accordoServizioParteSpecifica.getServizio().getNome());
            if (accordoServizioParteSpecifica.getAccordoServizioParteComune() == null) {
                throw new ProtocolException("AccordoServizioParteSpecifica.accordoServizioParteComune non definito");
            }
            try {
                this.idAccordoServizioParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(accordoServizioParteSpecifica.getAccordoServizioParteComune());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
        }
    }

    public IDSoggetto getIdSoggettoErogatore() {
        return this.idSoggettoErogatore;
    }

    public IDAccordo getIdAccordoServizioParteSpecifica() {
        return this.idAccordoServizioParteSpecifica;
    }

    public IDServizio getIdServizio() {
        return this.idServizio;
    }

    public IDAccordo getIdAccordoServizioParteComune() {
        return this.idAccordoServizioParteComune;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica() {
        return this.accordoServizioParteSpecifica;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

