/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import java.util.ArrayList;
import java.util.List;

public class ArchiveAccordoServizioComposto
extends ArchiveAccordoServizioParteComune {
    private IDAccordoCooperazione idAccordoCooperazione;
    private List<IDServizio> idServiziComponenti = new ArrayList<IDServizio>();

    public static String buildKey(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, String versione) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomeAccordo == null) {
            throw new ProtocolException("nomeAccordo non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("AccordoServizioComposto_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomeAccordo);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        String tipoSoggetto = "-";
        String nomeSoggetto = "-";
        String nomeAccordo = this.accordoServizioParteComune.getNome();
        String versione = "-";
        if (this.accordoServizioParteComune.getSoggettoReferente() != null) {
            if (this.accordoServizioParteComune.getSoggettoReferente().getTipo() != null) {
                tipoSoggetto = this.accordoServizioParteComune.getSoggettoReferente().getTipo();
            }
            if (this.accordoServizioParteComune.getSoggettoReferente().getNome() != null) {
                nomeSoggetto = this.accordoServizioParteComune.getSoggettoReferente().getNome();
            }
        }
        if (this.accordoServizioParteComune.getVersione() != null) {
            versione = this.accordoServizioParteComune.getVersione();
        }
        return ArchiveAccordoServizioComposto.buildKey(tipoSoggetto, nomeSoggetto, nomeAccordo, versione);
    }

    public ArchiveAccordoServizioComposto(IDSoggetto idSoggettoProprietario, AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        super(idSoggettoProprietario, accordoServizioParteComune, idCorrelazione);
    }

    public ArchiveAccordoServizioComposto(IDSoggetto idSoggettoProprietario, AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        super(idSoggettoProprietario, accordoServizioParteComune, idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchiveAccordoServizioComposto(AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        super(accordoServizioParteComune, idCorrelazione);
    }

    public ArchiveAccordoServizioComposto(AccordoServizioParteComune accordoServizioParteComune, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        super(accordoServizioParteComune, idCorrelazione, informationMissingManagementEnabled);
    }

    @Override
    public void update(AccordoServizioParteComune accordoServizioComposto, boolean informationMissingManagementEnabled) throws ProtocolException {
        super.update(accordoServizioComposto, informationMissingManagementEnabled);
        if (accordoServizioComposto.getServizioComposto() == null) {
            throw new ProtocolException("AccordoServizioComposto.servizioComposto non definito");
        }
        if (accordoServizioComposto.getServizioComposto().getAccordoCooperazione() == null) {
            throw new ProtocolException("AccordoServizioComposto.servizioComposto.nomeAccordoCooperazione non definito");
        }
        try {
            this.idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(accordoServizioComposto.getServizioComposto().getAccordoCooperazione());
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
        for (int i = 0; i < accordoServizioComposto.getServizioComposto().getServizioComponenteList().size(); ++i) {
            AccordoServizioParteComuneServizioCompostoServizioComponente sComponente;
            if (this.idServiziComponenti == null) {
                this.idServiziComponenti = new ArrayList<IDServizio>();
            }
            if ((sComponente = accordoServizioComposto.getServizioComposto().getServizioComponenteList().get(i)) == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "] non definito");
            }
            if (sComponente.getTipo() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].tipo non definito");
            }
            if (sComponente.getNome() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].nome non definito");
            }
            if (sComponente.getTipoSoggetto() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].tipoSoggetto non definito");
            }
            if (sComponente.getNomeSoggetto() == null) {
                throw new ProtocolException("AccordoServizioComposto.servizioComposto.serviziComponente[" + i + "].nomeSoggetto non definito");
            }
            IDServizio idServizioComponente = new IDServizio(sComponente.getTipoSoggetto(), sComponente.getNomeSoggetto(), sComponente.getTipo(), sComponente.getNome(), sComponente.getAzione());
            this.idServiziComponenti.add(idServizioComponente);
        }
    }

    public IDAccordoCooperazione getIdAccordoCooperazione() {
        return this.idAccordoCooperazione;
    }

    public List<IDServizio> getIdServiziComponenti() {
        return this.idServiziComponenti;
    }
}

