/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import java.io.Serializable;
import java.util.Date;

public class Servizio
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IDServizio idServizio;
    private IDAccordo idAccordo;
    private ProfiloDiCollaborazione profiloDiCollaborazione;
    private boolean idCollaborazione;
    private boolean ordineConsegna;
    private Date scadenza;
    private long scadenzaMinuti = -1L;
    private Inoltro inoltro;
    private boolean confermaRicezione;
    private String tipoServizioCorrelato;
    private String servizioCorrelato;
    private boolean correlato;

    public Busta convertToBusta(String protocollo, IDSoggetto fruitore) {
        Busta busta = new Busta(protocollo);
        if (fruitore != null) {
            busta.setTipoMittente(fruitore.getTipo());
            busta.setMittente(fruitore.getNome());
            busta.setIdentificativoPortaMittente(fruitore.getCodicePorta());
        }
        if (this.idServizio != null) {
            if (this.idServizio.getSoggettoErogatore() != null) {
                busta.setTipoDestinatario(this.idServizio.getSoggettoErogatore().getTipo());
                busta.setDestinatario(this.idServizio.getSoggettoErogatore().getNome());
                busta.setIdentificativoPortaDestinatario(this.idServizio.getSoggettoErogatore().getCodicePorta());
            }
            busta.setTipoServizio(this.idServizio.getTipoServizio());
            busta.setServizio(this.idServizio.getServizio());
            busta.setVersioneServizio(this.idServizio.getVersioneServizio());
            busta.setAzione(this.idServizio.getAzione());
        }
        busta.setProfiloDiCollaborazione(this.profiloDiCollaborazione);
        busta.setInoltro(this.inoltro);
        busta.setConfermaRicezione(this.confermaRicezione);
        busta.setTipoServizioCorrelato(this.tipoServizioCorrelato);
        busta.setServizioCorrelato(this.servizioCorrelato);
        return busta;
    }

    public void setIDServizio(IDServizio idServizio) {
        this.idServizio = idServizio;
    }

    public void setProfiloDiCollaborazione(ProfiloDiCollaborazione p) {
        this.profiloDiCollaborazione = p;
    }

    public void setCollaborazione(boolean c) {
        this.idCollaborazione = c;
    }

    public void setOrdineConsegna(boolean s) {
        this.ordineConsegna = s;
    }

    public void setScadenza(Date s) {
        this.scadenza = s;
    }

    public void setInoltro(Inoltro i) {
        this.inoltro = i;
    }

    public void setConfermaRicezione(boolean cr) {
        this.confermaRicezione = cr;
    }

    public void setServizioCorrelato(String nome) {
        this.servizioCorrelato = nome;
    }

    public void setTipoServizioCorrelato(String tipoServizioCorrelato) {
        this.tipoServizioCorrelato = tipoServizioCorrelato;
    }

    public void setCorrelato(boolean correlato) {
        this.correlato = correlato;
    }

    public void setScadenzaMinuti(long scadenzaMinuti) {
        this.scadenzaMinuti = scadenzaMinuti;
    }

    public IDServizio getIDServizio() {
        return this.idServizio;
    }

    public ProfiloDiCollaborazione getProfiloDiCollaborazione() {
        return this.profiloDiCollaborazione;
    }

    public boolean getCollaborazione() {
        return this.idCollaborazione;
    }

    public boolean getOrdineConsegna() {
        return this.ordineConsegna;
    }

    public Date getScadenza() {
        return this.scadenza;
    }

    public Inoltro getInoltro() {
        return this.inoltro;
    }

    public boolean getConfermaRicezione() {
        return this.confermaRicezione;
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public boolean isCorrelato() {
        return this.correlato;
    }

    public long getScadenzaMinuti() {
        return this.scadenzaMinuti;
    }

    public IDAccordo getIdAccordo() {
        return this.idAccordo;
    }

    public void setIdAccordo(IDAccordo idAccordo) {
        this.idAccordo = idAccordo;
    }
}

