/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.IMonitoraggioRisorsa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.Allegati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.EsitoAutorizzazioneRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.InformationWsdlSource;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RisultatoValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Azione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.ServizioAzione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CostantiRegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatoFunzionalita;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziAzioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziServizioNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.ValidazioneSemantica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.xml.DriverRegistroServiziXML;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapper;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.beans.BaseBean;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;

public class RegistroServiziReader {
    private static RegistroServiziReader registroServiziReader;
    private static boolean initialize;
    private RegistroServizi registroServizi;
    private Logger log = null;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();

    public static void resetCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.resetCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Reset della cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static void prefillCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.prefillCache(null, registroServiziReader.log);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Prefill della cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static String printStatsCache(String separator) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.printStatsCache(separator);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione Statistiche riguardante la cache del registro dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.abilitaCache(dimensioneCache, algoritmoCacheLRU, itemIdleTime, itemLifeSecond);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Abilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                registroServiziReader.registroServizi.disabilitaCache();
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Disabilitazione cache di accesso ai registri dei servizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static String listKeysCache(String separator) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.listKeysCache(separator);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione chiavi presenti nella cache del RegistroServizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static String getObjectCache(String key) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader != null && registroServiziReader.registroServizi != null) {
                return registroServiziReader.registroServizi.getObjectCache(key);
            }
            throw new Exception("RegistroServizi Non disponibile");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Visualizzazione oggetto presente nella cache del RegistroServizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static void removeObjectCache(String key) throws DriverRegistroServiziException {
        try {
            RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
            if (registroServiziReader == null || registroServiziReader.registroServizi == null) {
                throw new Exception("RegistroServizi Non disponibile");
            }
            registroServiziReader.registroServizi.removeObjectCache(key);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Rimozione oggetto presente nella cache del RegistroServizi non riuscita: " + e.getMessage(), e);
        }
    }

    public static boolean initialize(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache) {
        try {
            registroServiziReader = new RegistroServiziReader(accessoRegistro, aLog, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza, jndiNameDatasourcePdD, useOp2UtilsDatasource, bindJMX, prefillCache);
            return initialize;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInitialize() {
        return initialize;
    }

    protected static RegistroServiziReader getInstance() {
        return registroServiziReader;
    }

    public RegistroServiziReader(AccessoRegistro accessoRegistro, Logger aLog, Logger aLogconsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache) throws DriverRegistroServiziException {
        try {
            this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(RegistroServiziReader.class);
            this.registroServizi = new RegistroServizi(accessoRegistro, this.log, aLogconsole, raggiungibilitaTotale, readObjectStatoBozza, jndiNameDatasourcePdD, useOp2UtilsDatasource, bindJMX, prefillCache);
            initialize = true;
        }
        catch (Exception e) {
            initialize = false;
        }
    }

    protected void isAlive(boolean controlloTotale) throws CoreException {
        if (controlloTotale) {
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)((Object)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista));
                    monitorDriver.isAlive();
                }
                catch (Exception e) {
                    throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), e);
                }
            }
        } else {
            boolean registroRaggiungibile = false;
            StringBuffer eccezioni = new StringBuffer();
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IMonitoraggioRisorsa monitorDriver = (IMonitoraggioRisorsa)((Object)this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista));
                    monitorDriver.isAlive();
                    registroRaggiungibile = true;
                    break;
                }
                catch (Exception e) {
                    this.log.debug("Registro non accessibile [Registro " + nomeRegInLista + "]", (Throwable)e);
                    eccezioni.append("\n[Registro " + nomeRegInLista + "] " + e.getMessage());
                }
            }
            if (!registroRaggiungibile) {
                throw new CoreException(eccezioni.toString());
            }
        }
    }

    protected void validazioneSemantica(boolean controlloTotale, boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziValidi, String[] tipiConnettoriValidi, boolean validazioneSemanticaAbilitataXML, boolean validazioneSemanticaAbilitataAltriRegistri, Logger logConsole) throws CoreException {
        if (controlloTotale) {
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    boolean validazione = false;
                    validazione = o instanceof DriverRegistroServiziXML ? validazioneSemanticaAbilitataXML : validazioneSemanticaAbilitataAltriRegistri;
                    if (!validazione) continue;
                    BeanUtilities driverRegistro = (BeanUtilities)o;
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi registroServizi = driverRegistro.getImmagineCompletaRegistroServizi();
                    ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(registroServizi, verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziValidi);
                    validazioneSemantica.validazioneSemantica(false);
                    if (logConsole == null) continue;
                    logConsole.info("Validazione semantica del registro dei servizi [" + nomeRegInLista + "] effettuata.");
                }
                catch (Exception e) {
                    throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), e);
                }
            }
        } else {
            boolean registroRaggiungibile = false;
            StringBuffer eccezioni = new StringBuffer();
            Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                try {
                    IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                    boolean validazione = false;
                    validazione = o instanceof DriverRegistroServiziXML ? validazioneSemanticaAbilitataXML : validazioneSemanticaAbilitataAltriRegistri;
                    if (!validazione) continue;
                    BeanUtilities driverRegistro = (BeanUtilities)o;
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi registroServizi = driverRegistro.getImmagineCompletaRegistroServizi();
                    ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(registroServizi, verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziValidi);
                    validazioneSemantica.validazioneSemantica(false);
                    if (logConsole != null) {
                        logConsole.info("Validazione semantica del registro dei servizi [" + nomeRegInLista + "] effettuata.");
                    }
                    registroRaggiungibile = true;
                    break;
                }
                catch (Exception e) {
                    this.log.debug("Registro non accessibile [Registro " + nomeRegInLista + "]", (Throwable)e);
                    eccezioni.append("\n[Registro " + nomeRegInLista + "] " + e.getMessage());
                }
            }
            if (!registroRaggiungibile) {
                throw new CoreException(eccezioni.toString());
            }
        }
    }

    protected void setValidazioneSemanticaModificaRegistroServiziXML(boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziValidi, String[] tipiConnettoriValidi) throws CoreException {
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            try {
                IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
                if (!(o instanceof DriverRegistroServiziXML)) continue;
                DriverRegistroServiziXML driver = (DriverRegistroServiziXML)o;
                driver.abilitazioneValidazioneSemanticaDuranteModificaXML(verificaURI, tipiConnettoriValidi, tipiSoggettiValidi, tipiServiziValidi);
            }
            catch (Exception e) {
                throw new CoreException("[Registro " + nomeRegInLista + "] " + e.getMessage(), e);
            }
        }
    }

    protected void verificaConsistenzaRegistroServizi() throws DriverRegistroServiziException {
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            IDriverRegistroServiziGet o = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            if (!(o instanceof DriverRegistroServiziXML)) continue;
            DriverRegistroServiziXML driver = (DriverRegistroServiziXML)o;
            driver.refreshRegistroServiziXML();
        }
    }

    public PortaDominio getPortaDominio_noCache(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        PortaDominio r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getPortaDominio(nome);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public Ruolo getRuolo_noCache(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Ruolo r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                IDRuolo idRuolo = new IDRuolo(nome);
                r = driver.getRuolo(idRuolo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public Soggetto getSoggetto_noCache(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver.getSoggetto(idSoggetto);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune_noCache(IDAccordo idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo, (boolean)readContenutiAllegati) : driver.getAccordoServizioParteComune(idAccordo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_noCache(IDServizio idServizio, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteSpecifica r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idServizio, (boolean)readContenutiAllegati) : driver.getAccordoServizioParteSpecifica(idServizio);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    public AccordoCooperazione getAccordoCooperazione_noCache(IDAccordoCooperazione idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoCooperazione r = null;
        Enumeration<String> en = this.registroServizi.getDriverRegistroServizi().keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            if (nomeRegistro != null && !nomeRegistro.equals(nomeRegInLista)) continue;
            IDriverRegistroServiziGet driver = this.registroServizi.getDriverRegistroServizi().get(nomeRegInLista);
            try {
                r = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoCooperazione(idAccordo, readContenutiAllegati) : driver.getAccordoCooperazione(idAccordo);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (r == null && nomeRegistro == null) continue;
            break;
        }
        if (r == null) {
            throw new DriverRegistroServiziNotFound();
        }
        return r;
    }

    protected String getProfiloGestioneFruizioneServizio(Connection connectionPdD, IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio != null) {
            profilo = servizio.getVersioneProtocollo();
        }
        if (profilo == null) {
            Soggetto soggettoErogatore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idServizio.getSoggettoErogatore());
            if (soggettoErogatore == null) {
                throw new DriverRegistroServiziNotFound("getProfiloGestioneFruizioneServizio, soggettoErogatore [" + idServizio.getSoggettoErogatore() + "] non definito (o non registrato)");
            }
            profilo = soggettoErogatore.getVersioneProtocollo();
        }
        return profilo;
    }

    protected String getProfiloGestioneErogazioneServizio(Connection connectionPdD, IDSoggetto idFruitore, IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio != null) {
            Fruitore fruitore = null;
            if (idFruitore == null || idFruitore.getTipo() == null || idFruitore.getNome() == null) {
                throw new DriverRegistroServiziException("getProfiloGestioneErogazioneServizio, soggetto fruitore non definito");
            }
            for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore tmp = servizio.getFruitore(i);
                if (!idFruitore.getTipo().equals(tmp.getTipo()) || !idFruitore.getNome().equals(tmp.getNome())) continue;
                fruitore = tmp;
                break;
            }
            if (fruitore != null) {
                profilo = fruitore.getVersioneProtocollo();
            }
        }
        if (profilo == null) {
            Soggetto soggettoFruitore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idFruitore);
            if (soggettoFruitore == null) {
                throw new DriverRegistroServiziNotFound("getProfiloGestioneErogazioneServizio, soggettoFruitore [" + idFruitore + "] non definito (o non registrato)");
            }
            profilo = soggettoFruitore.getVersioneProtocollo();
        }
        return profilo;
    }

    protected String getProfiloGestioneSoggetto(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String profilo = null;
        Soggetto soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("getProfiloGestioneSoggetto, Soggetto [" + idSoggetto + "] non definito (o non registrato)");
        }
        profilo = soggetto.getVersioneProtocollo();
        return profilo;
    }

    protected Servizio getInfoServizio(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, false, false, idSoggetto, idService, nomeRegistro, verificaEsistenzaServizioAzioneCorrelato);
    }

    protected Servizio getInfoServizioCorrelato(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, true, false, idSoggetto, idService, nomeRegistro, false);
    }

    protected Servizio getInfoServizioAzioneCorrelata(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.getInfoServizio(connectionPdD, false, true, idSoggetto, idService, nomeRegistro, false);
    }

    private Servizio getInfoServizio(Connection connectionPdD, boolean servizioCorrelato, boolean azioneCorrelata, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        Date nowDate;
        Servizio infoServizio = new Servizio();
        AccordoServizioParteSpecifica servizio = null;
        servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("getInfoServizio, servizio non definito");
        }
        TipologiaServizio tipologiaServizio = servizio.getServizio().getTipologiaServizio();
        if (servizioCorrelato) {
            if (!TipologiaServizio.CORRELATO.equals(tipologiaServizio)) {
                throw new DriverRegistroServiziNotFound("getInfoServizio, servizio [" + idService.toString() + "] (tipologiaServizio:" + tipologiaServizio + ") non e' di tipologia correlata");
            }
        } else if (!TipologiaServizio.NORMALE.equals(tipologiaServizio)) {
            throw new DriverRegistroServiziNotFound("getInfoServizio, servizio [" + idService.toString() + "] (tipologiaServizio:" + tipologiaServizio + ") e' di tipologia normale");
        }
        idService.setVersioneServizio(servizio.getVersione());
        String azione = idService.getAzione();
        if (azioneCorrelata && azione == null) {
            throw new DriverRegistroServiziException("getInfoServizio, azione e' obbligatoria in questa modalita' di ricerca");
        }
        String uriAccordo = servizio.getAccordoServizioParteComune();
        if (uriAccordo == null) {
            throw new DriverRegistroServiziException("URIAccordo del servizio is null");
        }
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
        AccordoServizioParteComune as = this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
        if (as == null) {
            throw new DriverRegistroServiziNotFound("getInfoServizio, accordo di servizio [" + uriAccordo + "] non definito (o non registrato)");
        }
        infoServizio.setIdAccordo(idAccordo);
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (int i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Port-Type [" + servizio.getPortType() + "] associato al servizio non definito nell'accordo di servizio " + uriAccordo);
            }
        }
        Azione az = null;
        Operation ptAz = null;
        if (azione == null) {
            if (pt != null) {
                throw new DriverRegistroServiziAzioneNotFound("invocazione senza la definizione di una azione non permessa per il port-type " + pt.getNome() + " dell'accordo di servizio " + uriAccordo);
            }
            if (!as.getUtilizzoSenzaAzione()) {
                throw new DriverRegistroServiziAzioneNotFound("invocazione senza la definizione di una azione non permessa per l'accordo di servizio " + uriAccordo);
            }
        } else {
            int i;
            boolean find = false;
            if (pt != null) {
                for (i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!azione.equals(pt.getAzione(i).getNome())) continue;
                    ptAz = pt.getAzione(i);
                    find = true;
                    break;
                }
                if (!find) {
                    throw new DriverRegistroServiziAzioneNotFound("azione [" + azione + "] non trovata nel port-type [" + pt.getNome() + "] dell'accordo di servizio " + uriAccordo);
                }
            } else {
                for (i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!azione.equals(as.getAzione(i).getNome())) continue;
                    az = as.getAzione(i);
                    find = true;
                    break;
                }
                if (!find) {
                    throw new DriverRegistroServiziAzioneNotFound("azione [" + azione + "] non trovata nell'accordo di servizio " + uriAccordo);
                }
            }
        }
        infoServizio.setIDServizio(idService);
        if (as.getProfiloCollaborazione() == null) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        } else if (as.getProfiloCollaborazione().equals(CostantiRegistroServizi.ONEWAY)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        } else if (as.getProfiloCollaborazione().equals(CostantiRegistroServizi.SINCRONO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
        } else if (as.getProfiloCollaborazione().equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
        } else if (as.getProfiloCollaborazione().equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
        } else {
            infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
        }
        if (as.getIdCollaborazione() == null) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals(CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setCollaborazione(false);
        } else if (as.getIdCollaborazione().equals(CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setCollaborazione(true);
        } else {
            infoServizio.setCollaborazione(false);
        }
        if (as.getConsegnaInOrdine() == null) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals(CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setOrdineConsegna(false);
        } else if (as.getConsegnaInOrdine().equals(CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setOrdineConsegna(true);
        } else {
            infoServizio.setOrdineConsegna(false);
        }
        if (as.getConfermaRicezione() == null) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals(CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setConfermaRicezione(false);
        } else if (as.getConfermaRicezione().equals(CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setConfermaRicezione(true);
        } else {
            infoServizio.setConfermaRicezione(false);
        }
        if (as.getFiltroDuplicati() == null) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals(CostantiRegistroServizi.DISABILITATO)) {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        } else if (as.getFiltroDuplicati().equals(CostantiRegistroServizi.ABILITATO)) {
            infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
        } else {
            infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
        }
        if (as.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(as.getScadenza());
                nowDate = DateManager.getDate();
                long now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
                infoServizio.setScadenzaMinuti(minuti);
            }
            catch (Exception minuti) {
                // empty catch block
            }
        }
        if (pt != null) {
            boolean ridefinisci = true;
            if ("default".equals(pt.getProfiloPT())) {
                ridefinisci = false;
            }
            if (ridefinisci) {
                if (pt.getProfiloCollaborazione() != null) {
                    if (pt.getProfiloCollaborazione().equals(CostantiRegistroServizi.ONEWAY)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                    } else if (pt.getProfiloCollaborazione().equals(CostantiRegistroServizi.SINCRONO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                    } else if (pt.getProfiloCollaborazione().equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                    } else if (pt.getProfiloCollaborazione().equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                    }
                }
                if (pt.getIdCollaborazione() != null) {
                    if (pt.getIdCollaborazione().equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setCollaborazione(false);
                    } else if (pt.getIdCollaborazione().equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setCollaborazione(true);
                    }
                }
                if (pt.getConsegnaInOrdine() != null) {
                    if (pt.getConsegnaInOrdine().equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setOrdineConsegna(false);
                    } else if (pt.getConsegnaInOrdine().equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setOrdineConsegna(true);
                    }
                }
                if (pt.getConfermaRicezione() != null) {
                    if (pt.getConfermaRicezione().equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setConfermaRicezione(false);
                    } else if (pt.getConfermaRicezione().equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setConfermaRicezione(true);
                    }
                }
                if (pt.getFiltroDuplicati() != null) {
                    if (pt.getFiltroDuplicati().equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                    } else if (pt.getFiltroDuplicati().equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                    }
                }
                if (pt.getScadenza() != null) {
                    try {
                        long minuti = Long.parseLong(pt.getScadenza());
                        Date nowDate2 = DateManager.getDate();
                        long now = nowDate2.getTime();
                        nowDate2.setTime(now += minuti * 60L * 1000L);
                        infoServizio.setScadenza(nowDate2);
                        infoServizio.setScadenzaMinuti(minuti);
                    }
                    catch (Exception minuti) {
                        // empty catch block
                    }
                }
            }
        }
        if (az != null || ptAz != null) {
            boolean ridefinisci = true;
            if (az != null) {
                if ("default".equals(az.getProfAzione())) {
                    ridefinisci = false;
                }
            } else if ("default".equals(ptAz.getProfAzione())) {
                ridefinisci = false;
            }
            if (ridefinisci) {
                ProfiloCollaborazione profilo = null;
                profilo = az != null ? az.getProfiloCollaborazione() : ptAz.getProfiloCollaborazione();
                if (profilo != null) {
                    if (profilo.equals(CostantiRegistroServizi.ONEWAY)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ONEWAY);
                    } else if (profilo.equals(CostantiRegistroServizi.SINCRONO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.SINCRONO);
                    } else if (profilo.equals(CostantiRegistroServizi.ASINCRONO_SIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                    } else if (profilo.equals(CostantiRegistroServizi.ASINCRONO_ASIMMETRICO)) {
                        infoServizio.setProfiloDiCollaborazione(ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO);
                    }
                }
                StatoFunzionalita idCollaborazione = null;
                idCollaborazione = az != null ? az.getIdCollaborazione() : ptAz.getIdCollaborazione();
                if (idCollaborazione != null) {
                    if (idCollaborazione.equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setCollaborazione(false);
                    } else if (idCollaborazione.equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setCollaborazione(true);
                    }
                }
                StatoFunzionalita consegnaInOrdine = null;
                consegnaInOrdine = az != null ? az.getConsegnaInOrdine() : ptAz.getConsegnaInOrdine();
                if (consegnaInOrdine != null) {
                    if (consegnaInOrdine.equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setOrdineConsegna(false);
                    } else if (consegnaInOrdine.equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setOrdineConsegna(true);
                    }
                }
                StatoFunzionalita confermaRicezione = null;
                confermaRicezione = az != null ? az.getConfermaRicezione() : ptAz.getConfermaRicezione();
                if (confermaRicezione != null) {
                    if (confermaRicezione.equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setConfermaRicezione(false);
                    } else if (confermaRicezione.equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setConfermaRicezione(true);
                    }
                }
                StatoFunzionalita filtroDuplicati = null;
                filtroDuplicati = az != null ? az.getFiltroDuplicati() : ptAz.getFiltroDuplicati();
                if (filtroDuplicati != null) {
                    if (filtroDuplicati.equals(CostantiRegistroServizi.DISABILITATO)) {
                        infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                    } else if (filtroDuplicati.equals(CostantiRegistroServizi.ABILITATO)) {
                        infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                    }
                }
                String scadenza = null;
                scadenza = az != null ? az.getScadenza() : ptAz.getScadenza();
                if (scadenza != null) {
                    try {
                        long minuti = Long.parseLong(scadenza);
                        Date nowDate3 = DateManager.getDate();
                        long now = nowDate3.getTime();
                        nowDate3.setTime(now += minuti * 60L * 1000L);
                        infoServizio.setScadenza(nowDate3);
                        infoServizio.setScadenzaMinuti(minuti);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (servizio.getIdCollaborazione() != null) {
            if (servizio.getIdCollaborazione().equals(CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setCollaborazione(false);
            } else if (servizio.getIdCollaborazione().equals(CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setCollaborazione(true);
            }
        }
        if (servizio.getConsegnaInOrdine() != null) {
            if (servizio.getConsegnaInOrdine().equals(CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setOrdineConsegna(false);
            } else if (servizio.getConsegnaInOrdine().equals(CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setOrdineConsegna(true);
            }
        }
        if (servizio.getConfermaRicezione() != null) {
            if (servizio.getConfermaRicezione().equals(CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setConfermaRicezione(false);
            } else if (servizio.getConfermaRicezione().equals(CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setConfermaRicezione(true);
            }
        }
        if (servizio.getFiltroDuplicati() != null) {
            if (servizio.getFiltroDuplicati().equals(CostantiRegistroServizi.DISABILITATO)) {
                infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
            } else if (servizio.getFiltroDuplicati().equals(CostantiRegistroServizi.ABILITATO)) {
                infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
            }
        }
        if (servizio.getScadenza() != null) {
            try {
                long minuti = Long.parseLong(servizio.getScadenza());
                nowDate = DateManager.getDate();
                long now = nowDate.getTime();
                nowDate.setTime(now += minuti * 60L * 1000L);
                infoServizio.setScadenza(nowDate);
                infoServizio.setScadenzaMinuti(minuti);
            }
            catch (Exception minuti) {
                // empty catch block
            }
        }
        Fruitore fruitore = null;
        if (idSoggetto != null) {
            String nomeFruitore = idSoggetto.getNome();
            String tipoFruitore = idSoggetto.getTipo();
            for (int i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore f = servizio.getFruitore(i);
                if (f.getTipo() == null || f.getNome() == null || !f.getTipo().equals(tipoFruitore) || !f.getNome().equals(nomeFruitore)) continue;
                fruitore = f;
                break;
            }
        }
        if (fruitore != null) {
            if (fruitore.getIdCollaborazione() != null) {
                if (fruitore.getIdCollaborazione().equals(CostantiRegistroServizi.DISABILITATO)) {
                    infoServizio.setCollaborazione(false);
                } else if (fruitore.getIdCollaborazione().equals(CostantiRegistroServizi.ABILITATO)) {
                    infoServizio.setCollaborazione(true);
                }
            }
            if (fruitore.getConsegnaInOrdine() != null) {
                if (fruitore.getConsegnaInOrdine().equals(CostantiRegistroServizi.DISABILITATO)) {
                    infoServizio.setOrdineConsegna(false);
                } else if (fruitore.getConsegnaInOrdine().equals(CostantiRegistroServizi.ABILITATO)) {
                    infoServizio.setOrdineConsegna(true);
                }
            }
            if (fruitore.getConfermaRicezione() != null) {
                if (fruitore.getConfermaRicezione().equals(CostantiRegistroServizi.DISABILITATO)) {
                    infoServizio.setConfermaRicezione(false);
                } else if (fruitore.getConfermaRicezione().equals(CostantiRegistroServizi.ABILITATO)) {
                    infoServizio.setConfermaRicezione(true);
                }
            }
            if (fruitore.getFiltroDuplicati() != null) {
                if (fruitore.getFiltroDuplicati().equals(CostantiRegistroServizi.DISABILITATO)) {
                    infoServizio.setInoltro(Inoltro.CON_DUPLICATI);
                } else if (fruitore.getFiltroDuplicati().equals(CostantiRegistroServizi.ABILITATO)) {
                    infoServizio.setInoltro(Inoltro.SENZA_DUPLICATI);
                }
            }
            if (fruitore.getScadenza() != null) {
                try {
                    long minuti = Long.parseLong(fruitore.getScadenza());
                    Date nowDate4 = DateManager.getDate();
                    long now = nowDate4.getTime();
                    nowDate4.setTime(now += minuti * 60L * 1000L);
                    infoServizio.setScadenza(nowDate4);
                    infoServizio.setScadenzaMinuti(minuti);
                }
                catch (Exception minuti) {
                    // empty catch block
                }
            }
        }
        if (verificaEsistenzaServizioAzioneCorrelato) {
            if (ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione())) {
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    if (idSoggetto == null || idSoggetto.getTipo() == null || idSoggetto.getNome() == null) {
                        throw new Exception("Identita soggetto fruitore non fornita");
                    }
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato: " + e.getMessage());
                }
                if (servizioC == null) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato da associare al servizio asincrono simmetrico non trovato");
                }
                if (servizioC.getServizio().getNome() == null || servizioC.getServizio().getTipo() == null) {
                    throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, servizio correlato al servizio asincrono simmetrico non configurato correttamente (tipo e/o nome is null?)");
                }
                infoServizio.setServizioCorrelato(servizioC.getServizio().getNome());
                infoServizio.setTipoServizioCorrelato(servizioC.getServizio().getTipo());
            }
            if (ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione())) {
                DriverRegistroServiziCorrelatoNotFound eFound = null;
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idService.getSoggettoErogatore(), idAccordo);
                }
                catch (Exception e) {
                    eFound = new DriverRegistroServiziCorrelatoNotFound("servizio correlato da associare al servizio asincrono asimmetrico non trovato: " + e.getMessage());
                }
                if (eFound == null) {
                    if (servizioC == null) {
                        eFound = new DriverRegistroServiziCorrelatoNotFound("servizio correlato da associare al servizio asincrono asimmetrico non trovato");
                    } else if (servizioC.getServizio().getNome() == null || servizioC.getServizio().getTipo() == null) {
                        throw new DriverRegistroServiziCorrelatoNotFound("servizio correlato al servizio asincrono asimmetrico non configurato correttamente (tipo e/o nome is null?)");
                    }
                }
                if (eFound != null) {
                    BaseBean azCheck;
                    if (az != null) {
                        boolean find = false;
                        for (int i = 0; i < as.sizeAzioneList(); ++i) {
                            azCheck = as.getAzione(i);
                            if (((Azione)azCheck).getNome().equals(az.getNome()) || ((Azione)azCheck).getCorrelata() == null || !((Azione)azCheck).getCorrelata().equals(az.getNome())) continue;
                            find = true;
                            break;
                        }
                        if (!find) {
                            throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, azione correlata o " + eFound.getMessage());
                        }
                    } else if (ptAz != null && pt != null) {
                        boolean find = false;
                        for (int i = 0; i < pt.sizeAzioneList(); ++i) {
                            azCheck = pt.getAzione(i);
                            if (((Operation)azCheck).getNome().equals(ptAz.getNome()) || ((Operation)azCheck).getCorrelata() == null || !((Operation)azCheck).getCorrelata().equals(ptAz.getNome()) || ((Operation)azCheck).getCorrelataServizio() != null && !"".equals(((Operation)azCheck).getCorrelataServizio()) && !((Operation)azCheck).getCorrelataServizio().equals(pt.getNome())) continue;
                            find = true;
                            break;
                        }
                        if (!find) {
                            throw new DriverRegistroServiziCorrelatoNotFound("getInfoServizio, azione correlata o " + eFound.getMessage());
                        }
                    } else {
                        throw eFound;
                    }
                }
            }
        }
        if (!servizioCorrelato && azioneCorrelata && ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(infoServizio.getProfiloDiCollaborazione())) {
            String azionePT = null;
            String correlazione = null;
            if (ptAz != null) {
                azionePT = ptAz.getNome();
                correlazione = ptAz.getCorrelata();
            } else {
                azionePT = az.getNome();
                correlazione = az.getCorrelata();
            }
            if (correlazione == null) {
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + azionePT + "] invocata con il servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non e' correlata ad un'altra azione dell'accordo");
            }
            boolean find = false;
            if (pt != null) {
                for (int i = 0; i < pt.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(pt.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            } else {
                for (int i = 0; i < as.sizeAzioneList(); ++i) {
                    if (!correlazione.equals(as.getAzione(i).getNome())) continue;
                    find = true;
                    break;
                }
            }
            if (!find) {
                if (pt != null) {
                    throw new DriverRegistroServiziNotFound("getInfoServizio, l'operation [" + correlazione + "] definita come correlata nell'operation [" + azionePT + "] non esiste ( port type[" + pt.getNome() + "], servizio[" + idService.getTipoServizio() + idService.getServizio() + "] accordo di servizio[" + uriAccordo + "]");
                }
                throw new DriverRegistroServiziNotFound("getInfoServizio, l'azione [" + correlazione + "] definita come correlata nell'azione [" + azionePT + "] non esiste ( servizio[" + idService.getTipoServizio() + idService.getServizio() + "] accordo di servizio[" + uriAccordo + "]");
            }
        }
        return infoServizio;
    }

    protected Allegati getAllegati(Connection connectionPdD, IDServizio idASPS) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Allegati allegati = new Allegati();
        AccordoServizioParteSpecifica asps = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, null, idASPS, true);
        allegati.setAllegatiASParteSpecifica(asps.getAllegatoList());
        allegati.setSpecificheSemiformaliASParteSpecifica(asps.getSpecificaSemiformaleList());
        allegati.setSpecificheSicurezzaASParteSpecifica(asps.getSpecificaSicurezzaList());
        allegati.setSpecificheLivelloServizioASParteSpecifica(asps.getSpecificaLivelloServizioList());
        AccordoServizioParteComune aspc = this.registroServizi.getAccordoServizioParteComune(connectionPdD, null, this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()), true);
        allegati.setAllegatiASParteComune(aspc.getAllegatoList());
        allegati.setSpecificheSemiformaliASParteComune(aspc.getSpecificaSemiformaleList());
        return allegati;
    }

    protected AccordoServizioWrapper getWsdlAccordoServizio(Connection connectionPdD, IDServizio idService, InformationWsdlSource infoWsdlSource, boolean buildSchemaXSD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getWsdlAccordoServizio(connectionPdD, null, idService, infoWsdlSource, buildSchemaXSD);
    }

    protected EsitoAutorizzazioneRegistro isFruitoreServizioAutorizzato(Connection connectionPdD, String pdd, String servizioApplicativo, IDSoggetto soggetto, IDServizio servizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziServizioNotFound {
        try {
            EsitoAutorizzazioneRegistro esitoAutorizzazione = new EsitoAutorizzazioneRegistro();
            AccordoServizioParteSpecifica servizioRicercato = null;
            try {
                servizioRicercato = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, null, servizio);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (servizioRicercato == null) {
                throw new DriverRegistroServiziServizioNotFound("isFruitoreServizioAutorizzato, servizio [" + servizio.toString() + "] non trovato nel registro dei servizi");
            }
            if (soggetto == null) {
                String error = "identita del chiamante non fornita (autenticazione non attiva?)";
                this.log.error("Identita del chiamante non fornita");
                esitoAutorizzazione.setServizioAutorizzato(false);
                esitoAutorizzazione.setDetails(error);
                return esitoAutorizzazione;
            }
            for (int i = 0; i < servizioRicercato.sizeFruitoreList(); ++i) {
                Fruitore fruitore = servizioRicercato.getFruitore(i);
                if (!fruitore.getTipo().equals(soggetto.getTipo()) || !fruitore.getNome().equals(soggetto.getNome())) continue;
                if (fruitore.getClientAuth() == null) {
                    Soggetto fruitoreSoggetto = this.registroServizi.getSoggetto(connectionPdD, null, soggetto);
                    if (fruitoreSoggetto.getPortaDominio() != null) {
                        PortaDominio portaDominio = this.registroServizi.getPortaDominio(connectionPdD, null, fruitoreSoggetto.getPortaDominio());
                        StatoFunzionalita authMode = portaDominio.getClientAuth();
                        if (authMode == null) {
                            authMode = CostantiRegistroServizi.DISABILITATO;
                        }
                        if (CostantiRegistroServizi.ABILITATO.equals(authMode)) {
                            if (pdd == null) {
                                String error = "subject della porta di dominio che ha inviato la busta non presente (https attivo?, client-auth attivo?)";
                                this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: " + error);
                                esitoAutorizzazione.setServizioAutorizzato(false);
                                esitoAutorizzazione.setDetails(error);
                                return esitoAutorizzazione;
                            }
                            if (!Utilities.sslVerify(portaDominio.getSubject(), pdd, this.log)) {
                                String error = "subject estratto dal certificato client [" + pdd + "] diverso da quello registrato per la porta di dominio " + portaDominio.getNome() + " del mittente [" + portaDominio.getSubject() + "]";
                                this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita: " + error);
                                esitoAutorizzazione.setServizioAutorizzato(false);
                                esitoAutorizzazione.setDetails(error);
                                return esitoAutorizzazione;
                            }
                            this.log.info("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: subject corrispondono");
                            esitoAutorizzazione.setServizioAutorizzato(true);
                            return esitoAutorizzazione;
                        }
                        if (CostantiRegistroServizi.DISABILITATO.equals(authMode)) {
                            this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth disabilitato nella porta di dominio " + portaDominio.getNome());
                            esitoAutorizzazione.setServizioAutorizzato(true);
                            esitoAutorizzazione.setDetails("client-auth disabilitato nella porta di dominio " + portaDominio.getNome());
                            return esitoAutorizzazione;
                        }
                        throw new Exception("Valore di client-auth presente nella porta di dominio " + portaDominio.getNome() + " non valido: " + authMode);
                    }
                    this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth non presente ne nella definizione del fruitore ne nel soggetto");
                    esitoAutorizzazione.setServizioAutorizzato(true);
                    esitoAutorizzazione.setDetails("client-auth disabilitato");
                    return esitoAutorizzazione;
                }
                if (CostantiRegistroServizi.DISABILITATO.equals(fruitore.getClientAuth())) {
                    this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata: client-auth disabilitato nella fruizione");
                    esitoAutorizzazione.setDetails("client-auth disabilitato nella fruizione");
                    esitoAutorizzazione.setServizioAutorizzato(true);
                    return esitoAutorizzazione;
                }
                if (CostantiRegistroServizi.ABILITATO.equals(fruitore.getClientAuth())) {
                    Soggetto fruitoreSoggetto = this.registroServizi.getSoggetto(connectionPdD, null, soggetto);
                    PortaDominio portaDominio = this.registroServizi.getPortaDominio(connectionPdD, null, fruitoreSoggetto.getPortaDominio());
                    if (pdd == null) {
                        String error = "subject della porta di dominio che ha inviato la busta non presente (https attivo?, client-auth attivo?)";
                        this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita (FR): " + error);
                        esitoAutorizzazione.setServizioAutorizzato(false);
                        esitoAutorizzazione.setDetails(error);
                        return esitoAutorizzazione;
                    }
                    if (!Utilities.sslVerify(portaDominio.getSubject(), pdd, this.log)) {
                        String error = "subject estratto dal certificato client [" + pdd + "] diverso da quello registrato per la porta di dominio " + portaDominio.getNome() + " del mittente [" + portaDominio.getSubject() + "]";
                        this.log.error("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") fallita (FR): " + error);
                        esitoAutorizzazione.setServizioAutorizzato(false);
                        esitoAutorizzazione.setDetails(error);
                        return esitoAutorizzazione;
                    }
                    this.log.debug("Autorizzazione (" + soggetto.toString() + " -> " + servizio.toString() + ") effettuata (FR): subject corrispondono");
                    esitoAutorizzazione.setServizioAutorizzato(true);
                    return esitoAutorizzazione;
                }
                throw new Exception("Valore di client-auth presente nel fruitore " + soggetto.toString() + " non valido: " + fruitore.getClientAuth());
            }
            esitoAutorizzazione.setServizioAutorizzato(false);
            return esitoAutorizzazione;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (DriverRegistroServiziServizioNotFound e) {
            throw e;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Errore durante il controllo della fruizione di un servizio: " + e.getMessage(), e);
        }
    }

    private Connettore getConnettore(IDSoggetto idSoggetto, String nomeConnettore, String nomeRegistro) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private Connettore getConnettore(IDServizio idService, String nomeConnettore, String nomeRegistro) {
        it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi[] registri = this.registroServizi.getRegistriServiziXML();
        if (registri != null) {
            for (int l = 0; l < registri.length; ++l) {
                for (int i = 0; i < registri[l].sizeConnettoreList(); ++i) {
                    if (!nomeConnettore.equals(registri[l].getConnettore(i).getNome())) continue;
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore conn = registri[l].getConnettore(i);
                    if (conn != null && !"none".equals(conn.getTipo())) {
                        return conn.mappingIntoConnettoreConfigurazione();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected Connettore getConnettore(Connection connectionPdD, IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggettoErogatore;
        int i;
        if (idService == null) {
            throw new DriverRegistroServiziException("getConnettore error: Servizio non definito");
        }
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio == null) {
            throw new DriverRegistroServiziNotFound("getConnettore, Servizio [" + idService.getTipoServizio() + idService.getServizio() + " erogato da " + idService.getSoggettoErogatore().getTipo() + idService.getSoggettoErogatore().getNome() + "] non definito nel registro");
        }
        Connettore connector = null;
        String azione = idService.getAzione();
        String nomeFruitore = idSoggetto.getNome();
        String tipoFruitore = idSoggetto.getTipo();
        if (azione != null) {
            for (i = 0; i < servizio.getServizio().sizeParametriAzioneList(); ++i) {
                if (!azione.equals(servizio.getServizio().getParametriAzione(i).getNome())) continue;
                ServizioAzione azSPC = servizio.getServizio().getParametriAzione(i);
                for (int j = 0; j < azSPC.sizeParametriFruitoreList(); ++j) {
                    if (azSPC.getParametriFruitore(i).getTipo() == null || azSPC.getParametriFruitore(i).getNome() == null || !azSPC.getParametriFruitore(i).getTipo().equals(tipoFruitore) || !azSPC.getParametriFruitore(i).getNome().equals(nomeFruitore)) continue;
                    if (azSPC.getParametriFruitore(i).getConnettore() == null) break;
                    if (azSPC.getParametriFruitore(i).getConnettore().getTipo() != null) {
                        connector = azSPC.getParametriFruitore(i).getConnettore().mappingIntoConnettoreConfigurazione();
                        break;
                    }
                    connector = this.getConnettore(idService, azSPC.getParametriFruitore(i).getConnettore().getNome(), nomeRegistro);
                    break;
                }
                if (connector != null && !CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo()) || azSPC.getConnettore() == null) break;
                if (azSPC.getConnettore().getTipo() != null) {
                    connector = azSPC.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, connector.getNome(), nomeRegistro);
                break;
            }
        }
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore f = servizio.getFruitore(i);
                if (f.getTipo() == null || f.getNome() == null || !f.getTipo().equals(tipoFruitore) || !f.getNome().equals(nomeFruitore)) continue;
                if (f.getConnettore() == null) break;
                if (f.getConnettore().getTipo() != null) {
                    connector = f.getConnettore().mappingIntoConnettoreConfigurazione();
                    break;
                }
                connector = this.getConnettore(idService, connector.getNome(), nomeRegistro);
                break;
            }
        }
        if ((connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) && servizio.getServizio().getConnettore() != null) {
            connector = servizio.getServizio().getConnettore().getTipo() != null ? servizio.getServizio().getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, connector.getNome(), nomeRegistro);
        }
        if ((connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) && (soggettoErogatore = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idService.getSoggettoErogatore())).getConnettore() != null) {
            connector = soggettoErogatore.getConnettore().getTipo() != null ? soggettoErogatore.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idService, soggettoErogatore.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Servizio [" + idService.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idService.getSoggettoErogatore().getTipo());
        return connector;
    }

    protected Connettore getConnettore(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getConnettore error: Soggetto destinatario non definito");
        }
        Connettore connector = null;
        Soggetto soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        if (soggetto.getConnettore() != null) {
            connector = soggetto.getConnettore().getTipo() != null ? soggetto.getConnettore().mappingIntoConnettoreConfigurazione() : this.getConnettore(idSoggetto, soggetto.getConnettore().getNome(), nomeRegistro);
        }
        if (connector == null || CostantiRegistroServizi.DISABILITATO.equals(connector.getTipo())) {
            throw new DriverRegistroServiziNotFound("Connettore non trovato per il Soggetto [" + idSoggetto.toString() + "]");
        }
        connector.setNomeDestinatarioTrasmissioneBusta(idSoggetto.getNome());
        connector.setTipoDestinatarioTrasmissioneBusta(idSoggetto.getTipo());
        return connector;
    }

    protected String getDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro, IProtocolFactory protocolFactory) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("getDominio error: soggetto non definito");
        }
        Soggetto soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziNotFound("getDominio, soggetto non definito nel registro");
        }
        if (soggetto.getIdentificativoPorta() != null) {
            return soggetto.getIdentificativoPorta();
        }
        try {
            return protocolFactory.createTraduttore().getIdentificativoPortaDefault(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    protected String getImplementazionePdD(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        try {
            PortaDominio pdd = this.getPortaDominio(connectionPdD, idSoggetto, nomeRegistro, "getImplementazionePdD");
            if (pdd != null) {
                if (pdd.getImplementazione() != null) {
                    return pdd.getImplementazione();
                }
                return "standard";
            }
            return "standard";
        }
        catch (DriverRegistroServiziNotFound e) {
            return "standard";
        }
    }

    protected String getIdPortaDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        try {
            PortaDominio pdd = this.getPortaDominio(connectionPdD, idSoggetto, nomeRegistro, "getImplementazionePdD");
            if (pdd != null) {
                return pdd.getNome();
            }
            return null;
        }
        catch (DriverRegistroServiziNotFound e) {
            return null;
        }
    }

    private PortaDominio getPortaDominio(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro, String nomeMetodo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException(nomeMetodo + " error: soggetto non definito");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
            if (soggetto == null) {
                throw new DriverRegistroServiziNotFound("Soggetto non esistente (null)");
            }
        }
        catch (DriverRegistroServiziNotFound e) {
            this.log.debug(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] non trovato: " + e.getMessage());
            throw e;
        }
        catch (DriverRegistroServiziException ex) {
            this.log.error(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.log.error(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
            throw new DriverRegistroServiziException(nomeMetodo + ", soggetto [" + idSoggetto.toString() + "] ricerca con errore generale: " + ex.getMessage(), ex);
        }
        if (soggetto.getPortaDominio() != null) {
            PortaDominio pdd = null;
            try {
                pdd = this.registroServizi.getPortaDominio(connectionPdD, nomeRegistro, soggetto.getPortaDominio());
                if (pdd == null) {
                    throw new DriverRegistroServiziNotFound("PdD non esistente (null)");
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "] non trovata: " + e.getMessage());
                throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto.toString() + "] \u00e8 associato ad una Porta di Dominio [" + soggetto.getPortaDominio() + "] non registrata", e);
            }
            catch (DriverRegistroServiziException ex) {
                this.log.error(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore: " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Exception ex) {
                this.log.error(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage(), (Throwable)ex);
                throw new DriverRegistroServiziException(nomeMetodo + ", porta di domino [" + soggetto.getPortaDominio() + "] associata al soggetto [" + idSoggetto.toString() + "]  ricerca con errore generale: " + ex.getMessage(), ex);
            }
            return pdd;
        }
        throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto.toString() + "] non \u00e8 associato a nessuna Porta di Dominio");
    }

    protected RisultatoValidazione validaServizio(Connection connectionPdD, IDSoggetto soggettoFruitore, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziPortTypeNotFound {
        int i;
        RisultatoValidazione risultato = new RisultatoValidazione();
        if (idService == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        boolean correlato = false;
        AccordoServizioParteSpecifica servizio = null;
        try {
            servizio = this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (servizio == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        correlato = TipologiaServizio.CORRELATO.equals(servizio.getServizio().getTipologiaServizio());
        risultato.setIsServizioCorrelato(correlato);
        String uriAccordo = servizio.getAccordoServizioParteComune();
        IDAccordo idAccordo = this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
        AccordoServizioParteComune as = null;
        try {
            as = this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
        }
        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            // empty catch block
        }
        if (as == null) {
            risultato.setServizioRegistrato(false);
            return risultato;
        }
        PortType pt = null;
        if (servizio.getPortType() != null) {
            for (i = 0; i < as.sizePortTypeList(); ++i) {
                if (!servizio.getPortType().equals(as.getPortType(i).getNome())) continue;
                pt = as.getPortType(i);
            }
            if (pt == null) {
                throw new DriverRegistroServiziPortTypeNotFound("Port-Type [" + servizio.getPortType() + "] associato al servizio non definito nell'accordo di servizio " + uriAccordo);
            }
        }
        if (pt != null) {
            risultato.setAccessoSenzaAzione(false);
        } else {
            risultato.setAccessoSenzaAzione(as.getUtilizzoSenzaAzione());
        }
        if (!correlato && soggettoFruitore != null) {
            ProfiloCollaborazione profiloCollaborazione = as.getProfiloCollaborazione();
            if (idService.getAzione() != null) {
                int k;
                if (pt != null) {
                    if (pt.getProfiloCollaborazione() != null) {
                        profiloCollaborazione = pt.getProfiloCollaborazione();
                    }
                    for (k = 0; k < pt.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(pt.getAzione(k).getNome())) continue;
                        if (pt.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = pt.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                } else {
                    for (k = 0; k < as.sizeAzioneList(); ++k) {
                        if (!idService.getAzione().equals(as.getAzione(k).getNome())) continue;
                        if (as.getAzione(k).getProfiloCollaborazione() == null) break;
                        profiloCollaborazione = as.getAzione(k).getProfiloCollaborazione();
                        break;
                    }
                }
            }
            if (CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                AccordoServizioParteSpecifica servizioC = null;
                try {
                    servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, soggettoFruitore, idAccordo);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (servizioC != null && servizioC.getServizio().getNome() != null && servizioC.getServizio().getTipo() != null) {
                    risultato.setTipoServizioCorrelato(servizioC.getServizio().getTipo());
                    risultato.setServizioCorrelato(servizioC.getServizio().getNome());
                }
            } else if (CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione)) {
                String azioneRichiesta = idService.getAzione();
                String azioneCorrelata = null;
                if (azioneRichiesta != null) {
                    int i2;
                    if (pt != null) {
                        for (i2 = 0; i2 < pt.sizeAzioneList(); ++i2) {
                            if (!azioneRichiesta.equals(pt.getAzione(i2).getCorrelata())) continue;
                            azioneCorrelata = pt.getAzione(i2).getCorrelata();
                            break;
                        }
                    } else {
                        for (i2 = 0; i2 < as.sizeAzioneList(); ++i2) {
                            if (!azioneRichiesta.equals(as.getAzione(i2).getCorrelata())) continue;
                            azioneCorrelata = as.getAzione(i2).getCorrelata();
                            break;
                        }
                    }
                }
                if (azioneCorrelata != null) {
                    risultato.setTipoServizioCorrelato(idService.getTipoServizio());
                    risultato.setServizioCorrelato(idService.getServizio());
                    risultato.setAzioneCorrelata(azioneCorrelata);
                } else {
                    AccordoServizioParteSpecifica servizioC = null;
                    try {
                        servizioC = this.registroServizi.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idService.getSoggettoErogatore(), idAccordo);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (servizioC != null && servizioC.getServizio().getNome() != null && servizioC.getServizio().getTipo() != null) {
                        risultato.setTipoServizioCorrelato(servizioC.getServizio().getTipo());
                        risultato.setServizioCorrelato(servizioC.getServizio().getNome());
                    }
                }
            }
        }
        if (pt != null) {
            for (i = 0; i < pt.sizeAzioneList(); ++i) {
                risultato.addAzione(pt.getAzione(i).getNome());
            }
        } else {
            for (i = 0; i < as.sizeAzioneList(); ++i) {
                risultato.addAzione(as.getAzione(i).getNome());
            }
        }
        risultato.setServizioRegistrato(true);
        return risultato;
    }

    public Soggetto getSoggettoAutenticatoBasic(Connection connectionPdD, String username, String password, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoAutenticatoBasic(connectionPdD, nomeRegistro, username, password);
    }

    public Soggetto getSoggettoAutenticatoSsl(Connection connectionPdD, String subject, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoAutenticatoSsl(connectionPdD, nomeRegistro, subject);
    }

    public Soggetto getSoggettoAutenticatoPrincipal(Connection connectionPdD, String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggettoAutenticatoPrincipal(connectionPdD, nomeRegistro, principal);
    }

    public IDSoggetto getIdSoggettoAutenticatoBasic(Connection connectionPdD, String username, String password, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoAutenticatoBasic(connectionPdD, nomeRegistro, username, password));
    }

    public IDSoggetto getIdSoggettoAutenticatoSsl(Connection connectionPdD, String subject, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoAutenticatoSsl(connectionPdD, nomeRegistro, subject));
    }

    public IDSoggetto getIdSoggettoAutenticatoPrincipal(Connection connectionPdD, String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.convertToId(this.registroServizi.getSoggettoAutenticatoPrincipal(connectionPdD, nomeRegistro, principal));
    }

    private IDSoggetto convertToId(Soggetto s) {
        IDSoggetto id = new IDSoggetto(s.getTipo(), s.getNome(), s.getIdentificativoPorta());
        return id;
    }

    public PortaDominio getPortaDominio(Connection connectionPdD, String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getPortaDominio(connectionPdD, nomeRegistro, nome);
    }

    public Ruolo getRuolo(Connection connectionPdD, String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getRuolo(connectionPdD, nomeRegistro, nome);
    }

    public Soggetto getSoggetto(Connection connectionPdD, IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, IDAccordo idAccordo, Boolean readContenutiAllegati, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, readContenutiAllegati);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, IDServizio idServizio, Boolean readContenutiAllegati, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, readContenutiAllegati);
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, IDAccordoCooperazione idAccordoCooperazione, Boolean readContenutiAllegati, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, readContenutiAllegati);
    }

    public List<String> getAllIdPorteDominio(Connection connectionPdD, FiltroRicerca filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdPorteDominio(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDRuolo> getAllIdRuoli(Connection connectionPdD, FiltroRicercaRuoli filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdRuoli(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDSoggetto> getAllIdSoggetti(Connection connectionPdD, FiltroRicercaSoggetti filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdSoggetti(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(Connection connectionPdD, FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAccordiCooperazione(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(Connection connectionPdD, FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdAccordiServizioParteComune(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public List<IDServizio> getAllIdServizi(Connection connectionPdD, FiltroRicercaServizi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getAllIdServizi(connectionPdD, nomeRegistro, filtroRicerca);
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.getGenericObject(keyObject);
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServizi.pushGenericObject(keyObject, object);
    }

    static {
        initialize = false;
    }
}

