/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.CoreException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.Allegati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.EsitoAutorizzazioneRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.InformationWsdlSource;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RegistroServiziReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RisultatoValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.StateMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziAzioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziServizioNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapper;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class RegistroServiziManager {
    private RegistroServiziReader registroServiziReader = null;
    private List<StateMessage> stati = new ArrayList<StateMessage>();

    public static RegistroServiziManager getInstance() {
        return new RegistroServiziManager(new IState[0]);
    }

    public static RegistroServiziManager getInstance(IState ... state) {
        return new RegistroServiziManager(state);
    }

    public RegistroServiziManager(IState ... state) {
        this.registroServiziReader = RegistroServiziReader.getInstance();
        if (state != null) {
            for (int i = 0; i < state.length; ++i) {
                if (!(state[i] instanceof StateMessage)) continue;
                this.stati.add((StateMessage)state[i]);
            }
        }
    }

    public void updateState(IState ... state) {
        this.stati.clear();
        if (state != null) {
            for (int i = 0; i < state.length; ++i) {
                if (!(state[i] instanceof StateMessage)) continue;
                this.stati.add((StateMessage)state[i]);
            }
        }
    }

    private Connection getConnection() {
        if (this.stati.size() > 0) {
            for (StateMessage state : this.stati) {
                boolean validConnection = false;
                try {
                    validConnection = !state.getConnectionDB().isClosed();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!validConnection) continue;
                return state.getConnectionDB();
            }
        }
        return null;
    }

    public RegistroServiziReader getRegistroServiziReader() {
        return this.registroServiziReader;
    }

    public void isAlive(boolean controlloTotale) throws CoreException {
        this.registroServiziReader.isAlive(controlloTotale);
    }

    public void validazioneSemantica(boolean controlloTotale, boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziValidi, String[] tipiConnettoriValidi, boolean validazioneSemanticaAbilitataXML, boolean validazioneSemanticaAbilitataAltriRegistri, Logger logConsole) throws CoreException {
        this.registroServiziReader.validazioneSemantica(controlloTotale, verificaURI, tipiSoggettiValidi, tipiServiziValidi, tipiConnettoriValidi, validazioneSemanticaAbilitataXML, validazioneSemanticaAbilitataAltriRegistri, logConsole);
    }

    public void setValidazioneSemanticaModificaRegistroServiziXML(boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziValidi, String[] tipiConnettoriValidi) throws CoreException {
        this.registroServiziReader.setValidazioneSemanticaModificaRegistroServiziXML(verificaURI, tipiSoggettiValidi, tipiServiziValidi, tipiConnettoriValidi);
    }

    public void verificaConsistenzaRegistroServizi() throws DriverRegistroServiziException {
        this.registroServiziReader.verificaConsistenzaRegistroServizi();
    }

    public String getProfiloGestioneFruizioneServizio(IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getProfiloGestioneFruizioneServizio(this.getConnection(), idServizio, nomeRegistro);
    }

    public String getProfiloGestioneErogazioneServizio(IDSoggetto idFruitore, IDServizio idServizio, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getProfiloGestioneErogazioneServizio(this.getConnection(), idFruitore, idServizio, nomeRegistro);
    }

    public String getProfiloGestioneSoggetto(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getProfiloGestioneSoggetto(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public Servizio getInfoServizio(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.registroServiziReader.getInfoServizio(this.getConnection(), idSoggetto, idService, nomeRegistro, verificaEsistenzaServizioAzioneCorrelato);
    }

    public Servizio getInfoServizioCorrelato(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.registroServiziReader.getInfoServizioCorrelato(this.getConnection(), idSoggetto, idService, nomeRegistro);
    }

    public Servizio getInfoServizioAzioneCorrelata(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        return this.registroServiziReader.getInfoServizioAzioneCorrelata(this.getConnection(), idSoggetto, idService, nomeRegistro);
    }

    public Allegati getAllegati(IDServizio idASPS) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllegati(this.getConnection(), idASPS);
    }

    public AccordoServizioWrapper getWsdlAccordoServizio(IDServizio idService, InformationWsdlSource infoWsdlSource, boolean buildSchemaXSD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getWsdlAccordoServizio(this.getConnection(), idService, infoWsdlSource, buildSchemaXSD);
    }

    public EsitoAutorizzazioneRegistro isFruitoreServizioAutorizzato(String pdd, String servizioApplicativo, IDSoggetto soggetto, IDServizio servizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziServizioNotFound {
        return this.registroServiziReader.isFruitoreServizioAutorizzato(this.getConnection(), pdd, servizioApplicativo, soggetto, servizio);
    }

    public Connettore getConnettore(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getConnettore(this.getConnection(), idSoggetto, idService, nomeRegistro);
    }

    public Connettore getConnettore(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getConnettore(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public String getDominio(IDSoggetto idSoggetto, String nomeRegistro, IProtocolFactory protocolFactory) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getDominio(this.getConnection(), idSoggetto, nomeRegistro, protocolFactory);
    }

    public String getImplementazionePdD(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        return this.registroServiziReader.getImplementazionePdD(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public String getIdPortaDominio(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException {
        return this.registroServiziReader.getIdPortaDominio(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public RisultatoValidazione validaServizio(IDSoggetto soggettoFruitore, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziPortTypeNotFound {
        return this.registroServiziReader.validaServizio(this.getConnection(), soggettoFruitore, idService, nomeRegistro);
    }

    public Soggetto getSoggettoAutenticatoBasic(String username, String password, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoAutenticatoBasic(this.getConnection(), username, password, nomeRegistro);
    }

    public Soggetto getSoggettoAutenticatoSsl(String subject, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoAutenticatoSsl(this.getConnection(), subject, nomeRegistro);
    }

    public Soggetto getSoggettoAutenticatoPrincipal(String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoAutenticatoPrincipal(this.getConnection(), principal, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoAutenticatoBasic(String username, String password, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoAutenticatoBasic(this.getConnection(), username, password, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoAutenticatoSsl(String subject, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoAutenticatoSsl(this.getConnection(), subject, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoAutenticatoPrincipal(String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoAutenticatoPrincipal(this.getConnection(), principal, nomeRegistro);
    }

    public PortaDominio getPortaDominio(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getPortaDominio(this.getConnection(), nome, nomeRegistro);
    }

    public Ruolo getRuolo(String nome, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getRuolo(this.getConnection(), nome, nomeRegistro);
    }

    public Soggetto getSoggetto(IDSoggetto idSoggetto, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggetto(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAccordoServizioParteComune(this.getConnection(), idAccordo, readContenutiAllegati, nomeRegistro);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAccordoServizioParteSpecifica(this.getConnection(), idServizio, readContenutiAllegati, nomeRegistro);
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAccordoCooperazione(this.getConnection(), idAccordo, readContenutiAllegati, nomeRegistro);
    }

    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdPorteDominio(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdRuoli(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdSoggetti(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAccordiCooperazione(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAccordiServizioParteComune(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdServizi(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getGenericObject(keyObject);
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.pushGenericObject(keyObject, object);
    }
}

