/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.AccessoRegistroRegistro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Cache;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.constants.CostantiConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.InformationWsdlSource;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Azione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Operation;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.CredenzialeTipo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.ProfiloCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.StatiAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.TipologiaServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.BeanUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDriverRegistroServiziGet;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.uddi.DriverRegistroServiziUDDI;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.utils.DriverRegistroServiziWSInitUtilities;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.web.DriverRegistroServiziWEB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.xml.DriverRegistroServiziXML;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapper;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.wsdl.AccordoServizioWrapperUtilities;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheAlgorithm;
import it.link.pdd.tools.migrazione_govway.utils.cache.CacheResponse;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import org.slf4j.Logger;

public class RegistroServizi {
    private it.link.pdd.tools.migrazione_govway.utils.cache.Cache cache = null;
    private Hashtable<String, IDriverRegistroServiziGet> driverRegistroServizi;
    private Hashtable<String, String> mappingNomeRegistroToTipiDatabase = new Hashtable();
    private Hashtable<String, Boolean> mappingNomeRegistroToUseConnectionPdD = new Hashtable();
    private Vector<DriverRegistroServiziXML> registriXML;
    private Logger log = null;
    private boolean raggiungibilitaTotale = false;
    private boolean readObjectStatoBozza = false;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();

    public void resetCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
    }

    public String printStatsCache(String separator) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                return this.cache.printStats(separator);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public void abilitaCache() throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            this.cache = new it.link.pdd.tools.migrazione_govway.utils.cache.Cache("registroServizi");
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws DriverRegistroServiziException {
        if (this.cache != null) {
            throw new DriverRegistroServiziException("Cache gia' abilitata");
        }
        try {
            Cache configurazioneCache = new Cache();
            if (dimensioneCache != null) {
                configurazioneCache.setDimensione("" + dimensioneCache);
            }
            if (algoritmoCacheLRU != null) {
                if (algoritmoCacheLRU.booleanValue()) {
                    configurazioneCache.setAlgoritmo(CostantiConfigurazione.CACHE_LRU);
                } else {
                    configurazioneCache.setAlgoritmo(CostantiConfigurazione.CACHE_MRU);
                }
            }
            if (itemIdleTime != null) {
                configurazioneCache.setItemIdleTime("" + itemIdleTime);
            }
            if (itemLifeSecond != null) {
                configurazioneCache.setItemLifeSecond("" + itemLifeSecond);
            }
            this.initCacheRegistriServizi(configurazioneCache, null, false);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public void disabilitaCache() throws DriverRegistroServiziException {
        if (this.cache == null) {
            throw new DriverRegistroServiziException("Cache gia' disabilitata");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public String listKeysCache(String separator) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                return this.cache.printKeys(separator);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public String getObjectCache(String key) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        }
        throw new DriverRegistroServiziException("Cache non abilitata");
    }

    public void removeObjectCache(String key) throws DriverRegistroServiziException {
        if (this.cache != null) {
            try {
                this.cache.remove(key);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
        } else {
            throw new DriverRegistroServiziException("Cache non abilitata");
        }
    }

    public RegistroServizi(AccessoRegistro accessoRegistro, Logger alog, Logger alogConsole, boolean raggiungibilitaTotale, boolean readObjectStatoBozza, String jndiNameDatasourcePdD, boolean useOp2UtilsDatasource, boolean bindJMX, boolean prefillCache) throws DriverRegistroServiziException {
        try {
            this.driverRegistroServizi = new Hashtable();
            this.registriXML = new Vector();
            this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(RegistroServizi.class);
            this.raggiungibilitaTotale = raggiungibilitaTotale;
            this.readObjectStatoBozza = readObjectStatoBozza;
            for (int i = 0; i < accessoRegistro.sizeRegistroList(); ++i) {
                BeanUtilities driver = null;
                AccessoRegistroRegistro registro = accessoRegistro.getRegistro(i);
                Object nomeRegistro = registro.getNome();
                if (nomeRegistro == null) {
                    nomeRegistro = "Registro" + i + registro.getTipo();
                }
                String path = registro.getLocation();
                if (CostantiConfigurazione.REGISTRO_XML.equals(registro.getTipo()) && path.indexOf("${") != -1) {
                    while (path.indexOf("${") != -1) {
                        int indexStart = path.indexOf("${");
                        int indexEnd = path.indexOf("}");
                        if (indexEnd == -1) {
                            this.log.error("errore durante l'interpretazione del path [" + path + "]: ${ utilizzato senza la rispettiva chiusura }");
                            continue;
                        }
                        String nameSystemProperty = path.substring(indexStart + "${".length(), indexEnd);
                        String valueSystemProperty = System.getProperty(nameSystemProperty);
                        if (valueSystemProperty == null) {
                            this.log.error("errore durante l'interpretazione del path [" + path + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente");
                            continue;
                        }
                        path = path.replace("${" + nameSystemProperty + "}", valueSystemProperty);
                    }
                }
                String msg = "carico registro " + (String)nomeRegistro + " di tipo[" + registro.getTipo() + "]   location[" + path + "]";
                this.log.info(msg);
                if (alogConsole != null) {
                    alogConsole.info(msg);
                }
                if (CostantiConfigurazione.REGISTRO_XML.equals(registro.getTipo())) {
                    driver = new DriverRegistroServiziXML(path, this.log);
                    if (driver.create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, driver);
                        this.registriXML.add((DriverRegistroServiziXML)driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_UDDI.equals(registro.getTipo())) {
                    driver = registro.getUser() != null && registro.getPassword() != null ? new DriverRegistroServiziUDDI(path, registro.getUser(), registro.getPassword(), this.log) : new DriverRegistroServiziUDDI(registro.getLocation(), this.log);
                    if (((DriverRegistroServiziUDDI)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_WEB.equals(registro.getTipo())) {
                    driver = new DriverRegistroServiziWEB(path, this.log);
                    if (((DriverRegistroServiziWEB)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_DB.equals(registro.getTipo())) {
                    driver = new DriverRegistroServiziDB(path, null, this.log, registro.getTipoDatabase(), useOp2UtilsDatasource, bindJMX);
                    this.mappingNomeRegistroToTipiDatabase.put((String)nomeRegistro, registro.getTipoDatabase());
                    this.mappingNomeRegistroToUseConnectionPdD.put((String)nomeRegistro, path.equals(jndiNameDatasourcePdD));
                    if (((DriverRegistroServiziDB)driver).create) {
                        this.driverRegistroServizi.put((String)nomeRegistro, driver);
                        continue;
                    }
                    msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                    this.log.error(msg);
                    if (alogConsole == null) continue;
                    alogConsole.info(msg);
                    continue;
                }
                if (CostantiConfigurazione.REGISTRO_WS.equals(registro.getTipo())) {
                    try {
                        driver = DriverRegistroServiziWSInitUtilities.newInstance(registro.getLocation(), registro.getUser(), registro.getPassword(), this.log);
                        this.driverRegistroServizi.put((String)nomeRegistro, driver);
                    }
                    catch (Throwable e) {
                        msg = "Riscontrato errore durante l'inizializzazione del registro di tipo " + registro.getTipo() + " con location: " + registro.getLocation();
                        this.log.error(msg);
                        if (alogConsole == null) continue;
                        alogConsole.info(msg);
                    }
                    continue;
                }
                msg = "Riscontrato errore durante l'inizializzazione del registro di tipo sconosciuto " + registro.getTipo() + " con location: " + registro.getLocation();
                this.log.error(msg);
                if (alogConsole == null) continue;
                alogConsole.info(msg);
            }
            if (accessoRegistro.getCache() != null) {
                this.initCacheRegistriServizi(accessoRegistro.getCache(), alogConsole, prefillCache);
            }
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage();
            this.log.error(msg);
            if (alogConsole != null) {
                alogConsole.info(msg);
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione del registro: " + e.getMessage());
        }
        if (this.driverRegistroServizi.size() == 0) {
            throw new DriverRegistroServiziException("Non e' stato possibile inizializzare nessuna sorgente di lettura per un Registro dei Servizi");
        }
    }

    private void initCacheRegistriServizi(Cache configurazioneCache, Logger alogConsole, boolean prefillCache) throws Exception {
        block45: {
            String msg;
            this.cache = new it.link.pdd.tools.migrazione_govway.utils.cache.Cache("registroServizi");
            if (configurazioneCache.getDimensione() != null || configurazioneCache.getAlgoritmo() != null) {
                block43: {
                    try {
                        int dimensione;
                        if (configurazioneCache.getDimensione() != null) {
                            dimensione = -1;
                            dimensione = prefillCache ? Integer.MAX_VALUE : Integer.parseInt(configurazioneCache.getDimensione());
                            msg = "Dimensione della cache (RegistroServizi) impostata al valore: " + dimensione;
                            if (prefillCache) {
                                msg = "[Prefill Enabled] " + (String)msg;
                            }
                            if (prefillCache) {
                                this.log.warn(msg);
                            } else {
                                this.log.info(msg);
                            }
                            if (alogConsole != null) {
                                if (prefillCache) {
                                    alogConsole.warn(msg);
                                } else {
                                    alogConsole.info(msg);
                                }
                            }
                            this.cache.setCacheSize(dimensione);
                        } else if (prefillCache) {
                            dimensione = Integer.MAX_VALUE;
                            msg = "[Prefill Enabled] Dimensione della cache (RegistroServizi) impostata al valore: " + dimensione;
                            this.log.warn(msg);
                            if (alogConsole != null) {
                                alogConsole.warn(msg);
                            }
                            this.cache.setCacheSize(dimensione);
                        }
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per la dimensione della cache (RegistroServizi): " + error.getMessage();
                        this.log.error(msg);
                        if (alogConsole == null) break block43;
                        alogConsole.info(msg);
                    }
                }
                if (configurazioneCache.getAlgoritmo() != null) {
                    String msg2 = "Algoritmo di cache (RegistroServizi) impostato al valore: " + configurazioneCache.getAlgoritmo();
                    this.log.info(msg2);
                    if (alogConsole != null) {
                        alogConsole.info(msg2);
                    }
                    if (CostantiConfigurazione.CACHE_MRU.equals(configurazioneCache.getAlgoritmo())) {
                        this.cache.setCacheAlgoritm(CacheAlgorithm.MRU);
                    } else {
                        this.cache.setCacheAlgoritm(CacheAlgorithm.LRU);
                    }
                }
            }
            if (configurazioneCache.getItemIdleTime() != null || configurazioneCache.getItemLifeSecond() != null) {
                block44: {
                    try {
                        if (configurazioneCache.getItemIdleTime() != null) {
                            int itemIdleTime = -1;
                            itemIdleTime = prefillCache ? -1 : Integer.parseInt(configurazioneCache.getItemIdleTime());
                            msg = "Attributo 'IdleTime' (RegistroServizi) impostato al valore: " + itemIdleTime;
                            if (prefillCache) {
                                msg = "[Prefill Enabled] " + msg;
                            }
                            if (prefillCache) {
                                this.log.warn(msg);
                            } else {
                                this.log.info(msg);
                            }
                            if (alogConsole != null) {
                                if (prefillCache) {
                                    alogConsole.warn(msg);
                                } else {
                                    alogConsole.info(msg);
                                }
                            }
                            this.cache.setItemIdleTime(itemIdleTime);
                        } else if (prefillCache) {
                            int itemIdleTime = -1;
                            msg = "[Prefill Enabled] Attributo 'IdleTime' (RegistroServizi) impostato al valore: " + itemIdleTime;
                            this.log.warn(msg);
                            if (alogConsole != null) {
                                alogConsole.warn(msg);
                            }
                            this.cache.setItemIdleTime(itemIdleTime);
                        }
                    }
                    catch (Exception error) {
                        msg = "Parametro errato per l'attributo 'IdleTime' (RegistroServizi): " + error.getMessage();
                        this.log.error(msg);
                        if (alogConsole == null) break block44;
                        alogConsole.info(msg);
                    }
                }
                try {
                    if (configurazioneCache.getItemLifeSecond() != null) {
                        int itemLifeSecond = -1;
                        itemLifeSecond = prefillCache ? -1 : Integer.parseInt(configurazioneCache.getItemLifeSecond());
                        msg = "Attributo 'MaxLifeSecond' (RegistroServizi) impostato al valore: " + itemLifeSecond;
                        if (prefillCache) {
                            msg = "[Prefill Enabled] " + msg;
                        }
                        if (prefillCache) {
                            this.log.warn(msg);
                        } else {
                            this.log.info(msg);
                        }
                        if (alogConsole != null) {
                            if (prefillCache) {
                                alogConsole.warn(msg);
                            } else {
                                alogConsole.info(msg);
                            }
                        }
                        this.cache.setItemLifeTime(itemLifeSecond);
                    } else if (prefillCache) {
                        int itemLifeSecond = -1;
                        msg = "Attributo 'MaxLifeSecond' (RegistroServizi) impostato al valore: " + itemLifeSecond;
                        this.log.warn(msg);
                        if (alogConsole != null) {
                            alogConsole.warn(msg);
                        }
                        this.cache.setItemLifeTime(itemLifeSecond);
                    }
                }
                catch (Exception error) {
                    msg = "Parametro errato per l'attributo 'MaxLifeSecond' (RegistroServizi): " + error.getMessage();
                    this.log.error(msg);
                    if (alogConsole == null) break block45;
                    alogConsole.info(msg);
                }
            }
        }
        if (prefillCache) {
            this.prefillCache(null, alogConsole);
        }
    }

    protected Hashtable<String, IDriverRegistroServiziGet> getDriverRegistroServizi() {
        return this.driverRegistroServizi;
    }

    public void prefillCache(Connection connectionPdD, Logger alogConsole) {
        Object msg = "[Prefill] Inizializzazione cache (RegistroServizi) in corso ...";
        this.log.info((String)msg);
        if (alogConsole != null) {
            alogConsole.info((String)msg);
        }
        Set<String> registri = this.driverRegistroServizi.keySet();
        for (String nomeRegistro : registri) {
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "]";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero accordi di servizio parte comune ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaAccordi filtroAccordi = new FiltroRicercaAccordi();
            List<IDAccordo> listAccordi = null;
            try {
                listAccordi = this.driverRegistroServizi.get(nomeRegistro).getAllIdAccordiServizioParteComune(filtroAccordi);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listAccordi != null ? listAccordi.size() : 0) + " accordi di servizio parte comune";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listAccordi != null && listAccordi.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordi.size() + " accordi di servizio parte comune ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDAccordo idAccordo : listAccordi) {
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte comune [" + idAccordo + "] ...";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    try {
                        this.cache.remove(this._getKey_getAccordoServizioParteComune(idAccordo, null));
                        this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    try {
                        this.cache.remove(this._getKey_getAccordoServizioParteComune(idAccordo, false));
                        this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, false);
                    }
                    catch (DriverRegistroServiziNotFound e) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    AccordoServizioParteComune as = null;
                    try {
                        this.cache.remove(this._getKey_getAccordoServizioParteComune(idAccordo, true));
                        as = this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, true);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    boolean serviziCorrelati = false;
                    if (as != null) {
                        ProfiloCollaborazione profiloAS = as.getProfiloCollaborazione();
                        for (Azione az : as.getAzioneList()) {
                            ProfiloCollaborazione profiloAZ = profiloAS;
                            if ("ridefinito".equals(az.getProfAzione())) {
                                profiloAZ = az.getProfiloCollaborazione();
                            }
                            if (!ProfiloCollaborazione.ASINCRONO_ASIMMETRICO.equals(profiloAZ) && !ProfiloCollaborazione.ASINCRONO_SIMMETRICO.equals(profiloAZ)) continue;
                            serviziCorrelati = true;
                            break;
                        }
                        if (!serviziCorrelati) {
                            for (PortType pt : as.getPortTypeList()) {
                                ProfiloCollaborazione profiloPT = profiloAS;
                                if ("ridefinito".equals(pt.getProfiloPT())) {
                                    profiloPT = pt.getProfiloCollaborazione();
                                }
                                for (Operation az : pt.getAzioneList()) {
                                    ProfiloCollaborazione profiloAZ = profiloPT;
                                    if ("ridefinito".equals(az.getProfAzione())) {
                                        profiloAZ = az.getProfiloCollaborazione();
                                    }
                                    if (!ProfiloCollaborazione.ASINCRONO_ASIMMETRICO.equals(profiloAZ) && !ProfiloCollaborazione.ASINCRONO_SIMMETRICO.equals(profiloAZ)) continue;
                                    serviziCorrelati = true;
                                    break;
                                }
                                if (!serviziCorrelati) continue;
                                break;
                            }
                        }
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte comune [" + idAccordo + "] completato";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    if (!serviziCorrelati) continue;
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], (analisi profilo asincrono) recupero servizi che implementano l'accordo di servizio parte comune [" + idAccordo + "] ...";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    FiltroRicercaServizi filtroServizi = new FiltroRicercaServizi();
                    filtroServizi.setIdAccordo(idAccordo);
                    List<IDServizio> listServizi = null;
                    try {
                        listServizi = this.driverRegistroServizi.get(nomeRegistro).getAllIdServizi(filtroServizi);
                    }
                    catch (DriverRegistroServiziNotFound pt) {
                    }
                    catch (DriverRegistroServiziException e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], (analisi profilo asincrono) recuperati " + (listServizi != null ? listServizi.size() : 0) + " servizi che implementano l'accordo di servizio parte comune [" + idAccordo + "]";
                    this.log.debug((String)msg);
                    if (alogConsole != null) {
                        alogConsole.debug((String)msg);
                    }
                    if (listServizi == null || listServizi.size() <= 0) continue;
                    for (IDServizio idServizio : listServizi) {
                        IDSoggetto idSoggetto2 = idServizio.getSoggettoErogatore();
                        if (TipologiaServizio.CORRELATO.equals(idServizio.getTipologiaServizio())) {
                            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto2 + "] ...";
                            this.log.debug((String)msg);
                            if (alogConsole != null) {
                                alogConsole.debug((String)msg);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto2, idAccordo, null));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto2, idAccordo);
                            }
                            catch (DriverRegistroServiziNotFound az) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto2, idAccordo, false));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto2, idAccordo, false);
                            }
                            catch (DriverRegistroServiziNotFound e) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            try {
                                this.cache.remove(this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto2, idAccordo, true));
                                this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto2, idAccordo, true);
                            }
                            catch (DriverRegistroServiziNotFound e) {
                            }
                            catch (Exception e) {
                                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                            }
                            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto2 + "] completato";
                            this.log.debug((String)msg);
                            if (alogConsole == null) continue;
                            alogConsole.debug((String)msg);
                            continue;
                        }
                        msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati asincroni per l'accordo di servizio parte comune [" + idAccordo + "] e soggetto [" + idSoggetto2 + "] non effettuata essendo il servizio non di tipologia correlata";
                        this.log.debug((String)msg);
                        if (alogConsole == null) continue;
                        alogConsole.debug((String)msg);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordi.size() + " accordi di servizio parte comune completato";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero porte di dominio ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicerca filtroPdd = new FiltroRicerca();
            List<String> listPdd = null;
            try {
                listPdd = this.driverRegistroServizi.get(nomeRegistro).getAllIdPorteDominio(filtroPdd);
            }
            catch (DriverRegistroServiziNotFound as) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperate " + (listPdd != null ? listPdd.size() : 0) + " porte di dominio";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listPdd != null && listPdd.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listPdd.size() + " porte di dominio ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (String idPdd : listPdd) {
                    try {
                        this.cache.remove(this._getKey_getPortaDominio(idPdd));
                        this.getPortaDominio(connectionPdD, nomeRegistro, idPdd);
                    }
                    catch (DriverRegistroServiziNotFound filtroServizi) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listPdd.size() + " porte di dominio completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero ruoli ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            List<IDRuolo> listRuoli = null;
            try {
                listRuoli = this.driverRegistroServizi.get(nomeRegistro).getAllIdRuoli(filtroRuoli);
            }
            catch (DriverRegistroServiziNotFound e) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listRuoli != null ? listRuoli.size() : 0) + " ruoli";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listRuoli != null && listRuoli.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listRuoli.size() + " ruoli ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDRuolo idRuolo : listRuoli) {
                    try {
                        this.cache.remove(this._getKey_getRuolo(idRuolo.getNome()));
                        this.getRuolo(connectionPdD, nomeRegistro, idRuolo.getNome());
                    }
                    catch (DriverRegistroServiziNotFound e) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listRuoli.size() + " ruoli completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero soggetti ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            List<IDSoggetto> listSoggetti = null;
            try {
                listSoggetti = this.driverRegistroServizi.get(nomeRegistro).getAllIdSoggetti(filtroSoggetti);
            }
            catch (DriverRegistroServiziNotFound e) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listSoggetti != null ? listSoggetti.size() : 0) + " soggetti";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listSoggetti != null && listSoggetti.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listSoggetti.size() + " soggetti ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDSoggetto idSoggetto : listSoggetti) {
                    try {
                        this.cache.remove(this._getKey_getSoggetto(idSoggetto));
                        this.getSoggetto(connectionPdD, nomeRegistro, idSoggetto);
                    }
                    catch (DriverRegistroServiziNotFound idSoggetto2) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    Soggetto soggetto = null;
                    try {
                        soggetto = this.driverRegistroServizi.get(nomeRegistro).getSoggetto(idSoggetto);
                    }
                    catch (DriverRegistroServiziNotFound e) {
                    }
                    catch (DriverRegistroServiziException e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                    if (soggetto == null || soggetto.getCredenziali() == null || soggetto.getCredenziali().getTipo() == null) continue;
                    if (CredenzialeTipo.BASIC.equals(soggetto.getCredenziali().getTipo())) {
                        try {
                            this.cache.remove(this._getKey_getSoggettoAutenticatoBasic(soggetto.getCredenziali().getUser(), soggetto.getCredenziali().getPassword()));
                            this.getSoggettoAutenticatoBasic(connectionPdD, nomeRegistro, soggetto.getCredenziali().getUser(), soggetto.getCredenziali().getPassword());
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (CredenzialeTipo.SSL.equals(soggetto.getCredenziali().getTipo())) {
                        try {
                            this.cache.remove(this._getKey_getSoggettoAutenticatoSsl(soggetto.getCredenziali().getSubject()));
                            this.getSoggettoAutenticatoSsl(connectionPdD, nomeRegistro, soggetto.getCredenziali().getSubject());
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (!CredenzialeTipo.PRINCIPAL.equals(soggetto.getCredenziali().getTipo())) continue;
                    try {
                        this.cache.remove(this._getKey_getSoggettoAutenticatoPrincipal(soggetto.getCredenziali().getUser()));
                        this.getSoggettoAutenticatoPrincipal(connectionPdD, nomeRegistro, soggetto.getCredenziali().getUser());
                    }
                    catch (DriverRegistroServiziNotFound e) {
                    }
                    catch (Exception e) {
                        this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                    }
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listSoggetti.size() + " soggetti completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero servizi ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaServizi filtroServizi = new FiltroRicercaServizi();
            List<IDServizio> listServizi = null;
            try {
                listServizi = this.driverRegistroServizi.get(nomeRegistro).getAllIdServizi(filtroServizi);
            }
            catch (DriverRegistroServiziNotFound soggetto) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listServizi != null ? listServizi.size() : 0) + " servizi";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listServizi != null && listServizi.size() > 0) {
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listServizi.size() + " servizi ...";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
                for (IDServizio idServizio : listServizi) {
                    block162: {
                        msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte specifica [" + idServizio + "] ...";
                        this.log.debug((String)msg);
                        if (alogConsole != null) {
                            alogConsole.debug((String)msg);
                        }
                        try {
                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                        }
                        catch (DriverRegistroServiziNotFound profiloAZ) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                        }
                        catch (DriverRegistroServiziNotFound e) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        AccordoServizioParteSpecifica asps = null;
                        try {
                            asps = this.driverRegistroServizi.get(nomeRegistro).getAccordoServizioParteSpecifica(idServizio);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        }
                        catch (DriverRegistroServiziException e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                        try {
                            IDAccordo idAPC;
                            AccordoServizioParteComune apc;
                            if (asps == null || asps.getAccordoServizioParteComune() == null || (apc = this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAPC = this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()))) == null) break block162;
                            if (asps.getPortType() != null && !"".equals(asps.getPortType())) {
                                if (apc.sizePortTypeList() <= 0) break block162;
                                for (PortType pt : apc.getPortTypeList()) {
                                    if (!pt.getNome().equals(asps.getPortType()) || pt.sizeAzioneList() <= 0) continue;
                                    for (Operation azione : pt.getAzioneList()) {
                                        idServizio.setAzione(azione.getNome());
                                        try {
                                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                                        }
                                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                        try {
                                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                                        }
                                        catch (DriverRegistroServiziNotFound e) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                        try {
                                            this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                                            this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                                        }
                                        catch (DriverRegistroServiziNotFound e) {
                                        }
                                        catch (Exception e) {
                                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                                break block162;
                            }
                            if (apc.sizeAzioneList() <= 0) break block162;
                            for (Azione azione : apc.getAzioneList()) {
                                idServizio.setAzione(azione.getNome());
                                try {
                                    this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, null));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio);
                                }
                                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                                try {
                                    this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, false));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, false);
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                                try {
                                    this.cache.remove(this._getKey_getAccordoServizioParteSpecifica(idServizio, true));
                                    this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idServizio, true);
                                }
                                catch (DriverRegistroServiziNotFound e) {
                                }
                                catch (Exception e) {
                                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        catch (DriverRegistroServiziNotFound idAPC) {
                        }
                        catch (Exception e) {
                            this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                        }
                    }
                    msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero dati per l'accordo di servizio parte specifica [" + idServizio + "] completata";
                    this.log.debug((String)msg);
                    if (alogConsole == null) continue;
                    alogConsole.debug((String)msg);
                }
                msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listServizi.size() + " servizi completata";
                this.log.debug((String)msg);
                if (alogConsole != null) {
                    alogConsole.debug((String)msg);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recupero accordi di cooperazione ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            FiltroRicercaAccordi filtroAccordiCooperazione = new FiltroRicercaAccordi();
            List<IDAccordoCooperazione> listAccordiCooperazione = null;
            try {
                listAccordiCooperazione = this.driverRegistroServizi.get(nomeRegistro).getAllIdAccordiCooperazione(filtroAccordiCooperazione);
            }
            catch (DriverRegistroServiziNotFound asps) {
            }
            catch (DriverRegistroServiziException e) {
                this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], recuperati " + (listAccordiCooperazione != null ? listAccordiCooperazione.size() : 0) + " accordi di cooperazione";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            if (listAccordiCooperazione == null || listAccordiCooperazione.size() <= 0) continue;
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordiCooperazione.size() + " accordi di cooperazione ...";
            this.log.debug((String)msg);
            if (alogConsole != null) {
                alogConsole.debug((String)msg);
            }
            for (IDAccordoCooperazione idAccordoCooperazione : listAccordiCooperazione) {
                try {
                    this.cache.remove(this._getKey_getAccordoCooperazione(idAccordoCooperazione, null));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione);
                }
                catch (DriverRegistroServiziNotFound apc) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
                try {
                    this.cache.remove(this._getKey_getAccordoCooperazione(idAccordoCooperazione, false));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, false);
                }
                catch (DriverRegistroServiziNotFound e) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
                try {
                    this.cache.remove(this._getKey_getAccordoCooperazione(idAccordoCooperazione, true));
                    this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordoCooperazione, true);
                }
                catch (DriverRegistroServiziNotFound e) {
                }
                catch (Exception e) {
                    this.log.error("[prefill] errore" + e.getMessage(), (Throwable)e);
                }
            }
            msg = "[Prefill] Inizializzazione cache (RegistroServizi) per il registro [" + nomeRegistro + "], lettura di " + listAccordiCooperazione.size() + " accordi di cooperazione completata";
            this.log.debug((String)msg);
            if (alogConsole == null) continue;
            alogConsole.debug((String)msg);
        }
        msg = "[Prefill] Inizializzazione cache (RegistroServizi) completata";
        this.log.info((String)msg);
        if (alogConsole != null) {
            alogConsole.info((String)msg);
        }
    }

    public synchronized Object getObjectCache(String keyCache, String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Object ... arguments) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DriverRegistroServiziNotFound dNotFound = null;
        Object obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[" + methodName + "]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] in cache.");
                    return response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (methodo:" + methodName + ") nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getObject(methodName, nomeRegistro, readContenutoAllegati, connectionPdD, arguments);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                } else if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    throw new Exception("Metodo (" + methodName + ") nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException(dNotFound);
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverRegistroServiziNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    public Object getObject(String methodName, String nomeRegistro, Boolean readContenutoAllegati, Connection connectionPdD, Object ... arguments) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Object obj = null;
        if (nomeRegistro != null) {
            this.log.debug("Cerco nel registro [" + nomeRegistro + "]");
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegistro);
                this.log.debug("invocazione metodo [" + methodName + "]...");
                if (arguments.length == 0) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, Boolean.TYPE);
                        obj = method.invoke((Object)driver, (boolean)readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, new Class[0]);
                        obj = method.invoke((Object)driver, new Object[0]);
                    }
                } else if (arguments.length == 1) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), Boolean.TYPE);
                        obj = method.invoke((Object)driver, arguments[0], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                        obj = method.invoke((Object)driver, arguments[0]);
                    }
                } else if (arguments.length == 2) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), Boolean.TYPE);
                        obj = method.invoke((Object)driver, arguments[0], arguments[1], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                        obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                    }
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteComune) {
                        AccordoServizioParteComune as = (AccordoServizioParteComune)obj;
                        if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteSpecifica) {
                        AccordoServizioParteSpecifica s = (AccordoServizioParteSpecifica)obj;
                        if (StatiAccordo.bozza.toString().equals(s.getStatoPackage())) {
                            obj = null;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                        Vector<Fruitore> fruitoriConStatoNonBozza = new Vector<Fruitore>();
                        while (s.sizeFruitoreList() > 0) {
                            Fruitore tmpF = s.removeFruitore(0);
                            if (StatiAccordo.bozza.toString().equals(tmpF.getStatoPackage())) continue;
                            fruitoriConStatoNonBozza.add(tmpF);
                        }
                        while (fruitoriConStatoNonBozza.size() > 0) {
                            s.addFruitore((Fruitore)fruitoriConStatoNonBozza.remove(0));
                        }
                    }
                }
            }
            catch (DriverRegistroServiziNotFound e) {
                this.log.debug("Ricerca nel registro non riuscita (metodo [" + methodName + "]): " + e.getMessage());
                throw e;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage());
                        throw new DriverRegistroServiziNotFound(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    if (DriverRegistroServiziException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage(), e.getTargetException());
                        throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage(), e.getTargetException());
                    throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                }
                this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage(), (Throwable)e);
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            this.log.debug("invocazione metodo [" + methodName + "] completata.");
            return obj;
        }
        this.log.debug("Cerco nella mia gerarchia di registri");
        StringBuffer notFoundProblem = new StringBuffer();
        StringBuffer exceptionProblem = new StringBuffer();
        boolean find = false;
        Enumeration<String> en = this.driverRegistroServizi.keys();
        while (en.hasMoreElements()) {
            String nomeRegInLista = en.nextElement();
            this.log.debug("Cerco nel registro con nome[" + nomeRegInLista + "]");
            try {
                Method method;
                IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegInLista);
                this.log.debug("invocazione metodo [" + methodName + "] nel registro[" + nomeRegInLista + "]...");
                if (arguments.length == 0) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, Boolean.TYPE);
                        obj = method.invoke((Object)driver, (boolean)readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, new Class[0]);
                        obj = method.invoke((Object)driver, new Object[0]);
                    }
                    find = true;
                } else if (arguments.length == 1) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), Boolean.TYPE);
                        obj = method.invoke((Object)driver, arguments[0], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                        obj = method.invoke((Object)driver, arguments[0]);
                    }
                    find = true;
                } else if (arguments.length == 2) {
                    method = null;
                    if (driver instanceof DriverRegistroServiziDB && readContenutoAllegati != null) {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), Boolean.TYPE);
                        obj = method.invoke((Object)driver, arguments[0], arguments[1], readContenutoAllegati);
                    } else {
                        method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                        obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                    }
                    find = true;
                } else {
                    throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
                }
                if (!this.readObjectStatoBozza && driver instanceof DriverRegistroServiziDB) {
                    if (obj instanceof AccordoCooperazione) {
                        AccordoCooperazione ac = (AccordoCooperazione)obj;
                        if (StatiAccordo.bozza.toString().equals(ac.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteComune) {
                        AccordoServizioParteComune as = (AccordoServizioParteComune)obj;
                        if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                    } else if (obj instanceof AccordoServizioParteSpecifica) {
                        AccordoServizioParteSpecifica s = (AccordoServizioParteSpecifica)obj;
                        if (StatiAccordo.bozza.toString().equals(s.getStatoPackage())) {
                            obj = null;
                            find = false;
                            throw new DriverRegistroServiziNotFound("Accordo presente in uno stato bozza");
                        }
                        Vector<Fruitore> fruitoriConStatoNonBozza = new Vector<Fruitore>();
                        while (s.sizeFruitoreList() > 0) {
                            Fruitore tmpF = s.removeFruitore(0);
                            if (StatiAccordo.bozza.toString().equals(tmpF.getStatoPackage())) continue;
                            fruitoriConStatoNonBozza.add(tmpF);
                        }
                        while (fruitoriConStatoNonBozza.size() > 0) {
                            s.addFruitore((Fruitore)fruitoriConStatoNonBozza.remove(0));
                        }
                    }
                }
            }
            catch (DriverRegistroServiziNotFound ed) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo [" + methodName + "]): " + ed.getMessage());
                notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverRegistroServiziNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage());
                        notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + e.getTargetException().getMessage());
                    } else if (DriverRegistroServiziException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage(), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    } else {
                        this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage(), e.getTargetException());
                        if (this.raggiungibilitaTotale) {
                            throw new DriverRegistroServiziException(e.getTargetException().getMessage(), e.getTargetException());
                        }
                        exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getTargetException().getMessage());
                    }
                } else {
                    this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage(), (Throwable)e);
                    if (this.raggiungibilitaTotale) {
                        throw new DriverRegistroServiziException(e.getMessage(), e);
                    }
                    exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage(), (Throwable)e);
                if (this.raggiungibilitaTotale) {
                    throw new DriverRegistroServiziException(e.getMessage(), e);
                }
                exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
            }
            if (!find) continue;
            break;
        }
        this.log.debug("invocazione metodo [" + methodName + "] completata.");
        if (find) {
            return obj;
        }
        if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString() + notFoundProblem.toString());
        }
        if (exceptionProblem.length() > 0) {
            throw new DriverRegistroServiziException("[" + methodName + "]:" + exceptionProblem.toString());
        }
        if (notFoundProblem.length() > 0) {
            throw new DriverRegistroServiziNotFound("[" + methodName + "]:" + notFoundProblem.toString());
        }
        throw new DriverRegistroServiziException("[" + methodName + "]: ricerca non riuscita in tutti i registri");
    }

    private IDriverRegistroServiziGet getDriver(Connection connectionPdD, String nomeRegistro) throws DriverRegistroServiziException {
        IDriverRegistroServiziGet driver = this.driverRegistroServizi.get(nomeRegistro);
        if (driver instanceof DriverRegistroServiziDB) {
            Boolean useConnectionPdD = this.mappingNomeRegistroToUseConnectionPdD.get(nomeRegistro);
            if (connectionPdD != null && useConnectionPdD.booleanValue()) {
                driver = new DriverRegistroServiziDB(connectionPdD, this.log, this.mappingNomeRegistroToTipiDatabase.get(nomeRegistro));
                if (!((DriverRegistroServiziDB)driver).create) {
                    throw new DriverRegistroServiziException("Inizializzazione DriverRegistroServizi(" + nomeRegistro + ") con connessione PdD non riuscita");
                }
            }
        }
        return driver;
    }

    private String _getKey_getAccordoServizioParteComune(IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String uriAccordoServizio = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        String key = "getAccordoServizio_" + uriAccordoServizio;
        if (readContenutiAllegati != null) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(connectionPdD, nomeRegistro, idAccordo, null);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(Connection connectionPdD, String nomeRegistro, IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune]: Parametro non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune]: Nome accordo di servizio non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getAccordoServizioParteComune(idAccordo, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (AccordoServizioParteComune)response.getObject();
        }
        AccordoServizioParteComune as = null;
        as = this.cache != null ? (AccordoServizioParteComune)this.getObjectCache(key, "getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo) : (AccordoServizioParteComune)this.getObject("getAccordoServizioParteComune", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo);
        if (as != null) {
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio [" + idAccordo + "] non Trovato");
    }

    private String _getKey_getPortaDominio(String nomePdD) throws DriverRegistroServiziException {
        return "getPortaDominio_" + nomePdD;
    }

    public PortaDominio getPortaDominio(Connection connectionPdD, String nomeRegistro, String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getPortaDominio(nomePdD))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (PortaDominio)response.getObject();
        }
        PortaDominio pd = null;
        pd = this.cache != null ? (PortaDominio)this.getObjectCache(key, "getPortaDominio", nomeRegistro, null, connectionPdD, nomePdD) : (PortaDominio)this.getObject("getPortaDominio", nomeRegistro, null, connectionPdD, nomePdD);
        if (pd != null) {
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non Trovata");
    }

    private String _getKey_getRuolo(String nomeRuolo) throws DriverRegistroServiziException {
        return "getRuolo_" + nomeRuolo;
    }

    public Ruolo getRuolo(Connection connectionPdD, String nomeRegistro, String nomeRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (nomeRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo]: Parametro non definito");
        }
        IDRuolo idRuolo = new IDRuolo(nomeRuolo);
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getRuolo(nomeRuolo))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (Ruolo)response.getObject();
        }
        Ruolo ruolo = null;
        ruolo = this.cache != null ? (Ruolo)this.getObjectCache(key, "getRuolo", nomeRegistro, null, connectionPdD, idRuolo) : (Ruolo)this.getObject("getRuolo", nomeRegistro, null, connectionPdD, idRuolo);
        if (ruolo != null) {
            return ruolo;
        }
        throw new DriverRegistroServiziNotFound("[getRuolo] Ruolo [" + nomeRuolo + "] non trovato");
    }

    private String _getKey_getSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        return "getSoggetto_" + idSoggetto.getTipo() + "/" + idSoggetto.getNome();
    }

    public Soggetto getSoggetto(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggetto(idSoggetto))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggetto", nomeRegistro, null, connectionPdD, idSoggetto) : (Soggetto)this.getObject("getSoggetto", nomeRegistro, null, connectionPdD, idSoggetto);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non Trovato");
    }

    private String _getKey_getSoggettoAutenticatoBasic(String user, String password) throws DriverRegistroServiziException {
        return "getSoggettoAutenticatoBasic_" + user + "_" + password;
    }

    public Soggetto getSoggettoAutenticatoBasic(Connection connectionPdD, String nomeRegistro, String user, String password) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (user == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticatoBasic] Parametro user Non Valido");
        }
        if (password == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticatoBasic] Parametro password Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoAutenticatoBasic(user, password))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoAutenticatoBasic", nomeRegistro, null, connectionPdD, user, password) : (Soggetto)this.getObject("getSoggettoAutenticatoBasic", nomeRegistro, null, connectionPdD, user, password);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoAutenticatoBasic] Soggetto non Trovato");
    }

    private String _getKey_getSoggettoAutenticatoSsl(String subject) throws DriverRegistroServiziException {
        return "getSoggettoAutenticatoSsl_" + subject;
    }

    public Soggetto getSoggettoAutenticatoSsl(Connection connectionPdD, String nomeRegistro, String subject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (subject == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticatoSsl] Parametro subject Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoAutenticatoSsl(subject))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoAutenticatoSsl", nomeRegistro, null, connectionPdD, subject) : (Soggetto)this.getObject("getSoggettoAutenticatoSsl", nomeRegistro, null, connectionPdD, subject);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoAutenticatoSsl] Soggetto non Trovato");
    }

    private String _getKey_getSoggettoAutenticatoPrincipal(String principal) throws DriverRegistroServiziException {
        return "getSoggettoAutenticatoPrincipal_" + principal;
    }

    public Soggetto getSoggettoAutenticatoPrincipal(Connection connectionPdD, String nomeRegistro, String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (principal == null) {
            throw new DriverRegistroServiziException("[getSoggettoAutenticatoPrincipal] Parametro principal Non Valido");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getSoggettoAutenticatoPrincipal(principal))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (Soggetto)response.getObject();
        }
        Soggetto soggetto = null;
        soggetto = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggettoAutenticatoPrincipal", nomeRegistro, null, connectionPdD, principal) : (Soggetto)this.getObject("getSoggettoAutenticatoPrincipal", nomeRegistro, null, connectionPdD, principal);
        if (soggetto != null) {
            return soggetto;
        }
        throw new DriverRegistroServiziNotFound("[getSoggettoAutenticatoPrincipal] Soggetto non Trovato");
    }

    private String _getKey_getAccordoServizioParteSpecifica(IDServizio idService, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        String azione = idService.getAzione();
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        String key = "getServizio_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio;
        if (azione != null) {
            key = key + "_" + azione;
        }
        if (readContenutiAllegati != null) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica(connectionPdD, nomeRegistro, idService, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(Connection connectionPdD, String nomeRegistro, IDServizio idService, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getAccordoServizioParteSpecifica(idService, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (AccordoServizioParteSpecifica)response.getObject();
        }
        AccordoServizioParteSpecifica serv = null;
        serv = this.cache != null ? (AccordoServizioParteSpecifica)this.getObjectCache(key, "getAccordoServizioParteSpecifica", nomeRegistro, readContenutiAllegati, connectionPdD, idService) : (AccordoServizioParteSpecifica)this.getObject("getAccordoServizioParteSpecifica", nomeRegistro, readContenutiAllegati, connectionPdD, idService);
        if (serv != null) {
            return serv;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica] Servizio non Trovato");
    }

    private String _getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String uriAccordo = this.idAccordoFactory.getUriFromIDAccordo(idAccordo);
        String key = "getServizioCorrelato(RicercaPerAccordo)_" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "_" + uriAccordo;
        if (readContenutiAllegati != null) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteSpecifica_ServizioCorrelato(connectionPdD, nomeRegistro, idSoggetto, idAccordo, null);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica_ServizioCorrelato(Connection connectionPdD, String nomeRegistro, IDSoggetto idSoggetto, IDAccordo idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametro Non Valido");
        }
        String nome = idSoggetto.getNome();
        String tipo = idSoggetto.getTipo();
        if (tipo == null || nome == null || idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteSpecifica_ServizioCorrelato] Parametri Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (AccordoServizioParteSpecifica)response.getObject();
        }
        AccordoServizioParteSpecifica servCorrelato = null;
        servCorrelato = this.cache != null ? (AccordoServizioParteSpecifica)this.getObjectCache(key, "getAccordoServizioParteSpecifica_ServizioCorrelato", nomeRegistro, readContenutiAllegati, connectionPdD, idSoggetto, idAccordo) : (AccordoServizioParteSpecifica)this.getObject("getAccordoServizioParteSpecifica_ServizioCorrelato", nomeRegistro, readContenutiAllegati, connectionPdD, idSoggetto, idAccordo);
        if (servCorrelato != null) {
            return servCorrelato;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizioParteSpecifica_ServizioCorrelato] ServizioCorrelato non Trovato");
    }

    private String _getKey_getAccordoCooperazione(IDAccordoCooperazione idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException {
        String uriAccordoCooperazione = this.idAccordoCooperazioneFactory.getUriFromIDAccordo(idAccordo);
        String key = "getAccordoCooperazione_" + uriAccordoCooperazione;
        if (readContenutiAllegati != null) {
            key = key + "_READ-ALLEGATI(" + readContenutiAllegati + ")";
        }
        return key;
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, String nomeRegistro, IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoCooperazione(connectionPdD, nomeRegistro, idAccordo, null);
    }

    public AccordoCooperazione getAccordoCooperazione(Connection connectionPdD, String nomeRegistro, IDAccordoCooperazione idAccordo, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione]: Parametro non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione]: Nome accordo di servizio non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = this._getKey_getAccordoCooperazione(idAccordo, readContenutiAllegati))) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (AccordoCooperazione)response.getObject();
        }
        AccordoCooperazione ac = null;
        ac = this.cache != null ? (AccordoCooperazione)this.getObjectCache(key, "getAccordoCooperazione", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo) : (AccordoCooperazione)this.getObject("getAccordoCooperazione", nomeRegistro, readContenutiAllegati, connectionPdD, idAccordo);
        if (ac != null) {
            return ac;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Servizio non Trovato");
    }

    public List<String> getAllIdPorteDominio(Connection connectionPdD, String nomeRegistro, FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdPorteDominio");
    }

    public List<IDRuolo> getAllIdRuoli(Connection connectionPdD, String nomeRegistro, FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdRuoli");
    }

    public List<IDSoggetto> getAllIdSoggetti(Connection connectionPdD, String nomeRegistro, FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdSoggetti");
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(Connection connectionPdD, String nomeRegistro, FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdAccordiCooperazione");
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(Connection connectionPdD, String nomeRegistro, FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdAccordiServizioParteComune");
    }

    public List<IDServizio> getAllIdServizi(Connection connectionPdD, String nomeRegistro, FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this._getAllIdEngine(connectionPdD, nomeRegistro, filtroRicerca, "getAllIdServizi");
    }

    private List<?> _getAllIdEngine(Connection connectionPdD, String nomeRegistro, Object filtroRicerca, String nomeMetodo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (filtroRicerca == null) {
            throw new DriverRegistroServiziException("[" + nomeMetodo + "]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = nomeMetodo + "_" + filtroRicerca.toString())) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (List)((Object)response.getObject());
        }
        List list = null;
        list = this.cache != null ? (List)this.getObjectCache(key, nomeMetodo, nomeRegistro, null, connectionPdD, filtroRicerca) : (List)this.getObject(nomeMetodo, nomeRegistro, null, connectionPdD, filtroRicerca);
        if (list != null) {
            return list;
        }
        throw new DriverRegistroServiziNotFound("[" + nomeMetodo + "] Elementi non trovati");
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi[] getRegistriServiziXML() {
        if (this.registriXML.size() > 0) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi[] r = new it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RegistroServizi[this.registriXML.size()];
            for (int i = 0; i < this.registriXML.size(); ++i) {
                r[i] = this.registriXML.get(i).getRegistroXML();
            }
            return r;
        }
        return null;
    }

    public AccordoServizioWrapper getWsdlAccordoServizio(Connection connectionPdD, String nomeRegistro, IDServizio idService, InformationWsdlSource infoWsdlSource, boolean buildSchemaXSD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (idService == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getWsdlAccordoServizio] Parametri (Soggetto) Non Validi");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getWsdlAccordoServizio_" + infoWsdlSource.name() + "_" + tipoSogg + "/" + nomeSogg + "_" + tipoServizio + "/" + servizio + "_schema_" + buildSchemaXSD)) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return (AccordoServizioWrapper)response.getObject();
        }
        AccordoServizioWrapper wsdlAS = null;
        wsdlAS = this.cache != null ? this.getAccordoServizioCache(key, idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD) : this.getAccordoServizioEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD);
        if (wsdlAS != null) {
            return wsdlAS;
        }
        throw new DriverRegistroServiziNotFound("[getWsdlAccordoServizio] WSDLAccordoServizio non Trovato");
    }

    private synchronized AccordoServizioWrapper getAccordoServizioCache(String keyCache, IDServizio idService, InformationWsdlSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemaXSD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DriverRegistroServiziNotFound dNotFound = null;
        AccordoServizioWrapper obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverRegistroServiziException("[getWSDLAccordoServizio]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    return (AccordoServizioWrapper)response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:getWSDLAccordoServizio) nel registro[" + nomeRegistro + "] in cache.");
                    throw (Exception)response.getException();
                }
                this.log.error("In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug("oggetto con chiave [" + keyCache + "] (methodo:WSDLAccordoServizio) nel registro[" + nomeRegistro + "] non in cache, ricerco nel registro...");
            try {
                obj = this.getAccordoServizioEngine(idService, infoWsdlSource, nomeRegistro, connectionPdD, buildSchemaXSD);
            }
            catch (DriverRegistroServiziNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info("Aggiungo eccezione [" + keyCache + "] in cache");
                } else if (obj != null) {
                    this.log.info("Aggiungo oggetto [" + keyCache + "] in cache");
                } else {
                    throw new Exception("Metodo (WSDLAccordoServizio) nel registro[" + nomeRegistro + "] ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException(dNotFound);
                    } else {
                        responseCache.setObject(obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage());
                }
            }
        }
        catch (DriverRegistroServiziException e) {
            throw e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverRegistroServiziNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("RegistroServizi, Algoritmo di Cache fallito: " + e.getMessage(), e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    private AccordoServizioWrapper getAccordoServizioEngine(IDServizio idService, InformationWsdlSource infoWsdlSource, String nomeRegistro, Connection connectionPdD, boolean buildSchemaXSD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioWrapper accordoServizioWrapper;
        block44: {
            IDAccordo idAccordo;
            AccordoServizioParteSpecifica servizio = null;
            AccordoServizioParteComune as = null;
            boolean registroServiziDB = false;
            if (nomeRegistro != null) {
                this.log.debug("Cerco wsdl nel registro [" + nomeRegistro + "]");
                try {
                    IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegistro);
                    this.log.debug("invocazione metodo getWSDLAccordoServizio (search servizio)...");
                    try {
                        servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idService, true) : driver.getAccordoServizioParteSpecifica(idService);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (servizio == null) {
                        throw new DriverRegistroServiziNotFound("Servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non definito");
                    }
                    idAccordo = this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune());
                    this.log.debug("invocazione metodo getWSDLAccordoServizio (search accordo)...");
                    as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo, true) : driver.getAccordoServizioParteComune(idAccordo);
                    if (as == null) {
                        throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nel registro");
                    }
                    if (servizio.getPortType() != null && !"".equals(servizio.getPortType())) {
                        boolean findPortType = false;
                        for (int l = 0; l < as.sizePortTypeList(); ++l) {
                            if (!servizio.getPortType().equals(as.getPortType(l).getNome())) continue;
                            findPortType = true;
                            break;
                        }
                        if (!findPortType) {
                            throw new DriverRegistroServiziNotFound("PortType[" + servizio.getPortType() + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nell'Accordo di servizio [" + idAccordo + "]");
                        }
                    }
                    registroServiziDB = driver instanceof DriverRegistroServiziDB;
                }
                catch (DriverRegistroServiziNotFound e) {
                    this.log.debug("Ricerca nel registro non riuscita (metodo getWSDLAccordoServizio): " + e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    this.log.debug("Ricerca nel registro [" + nomeRegistro + "] non riuscita, " + e.getMessage(), (Throwable)e);
                    throw new DriverRegistroServiziException(e.getMessage(), e);
                }
            }
            this.log.debug("Cerco nella mia gerarchia di registri");
            StringBuffer notFoundProblem = new StringBuffer();
            StringBuffer exceptionProblem = new StringBuffer();
            boolean find = false;
            Enumeration<String> en = this.driverRegistroServizi.keys();
            while (en.hasMoreElements()) {
                String nomeRegInLista = en.nextElement();
                this.log.debug("Cerco nel registro con nome[" + nomeRegInLista + "]");
                try {
                    IDriverRegistroServiziGet driver = this.getDriver(connectionPdD, nomeRegInLista);
                    this.log.debug("invocazione metodo getWSDLAccordoServizio (search servizio) nel registro[" + nomeRegInLista + "]...");
                    try {
                        servizio = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteSpecifica(idService, true) : driver.getAccordoServizioParteSpecifica(idService);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (servizio == null) {
                        throw new DriverRegistroServiziNotFound("Servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non definito");
                    }
                    IDAccordo idAccordo2 = this.idAccordoFactory.getIDAccordoFromUri(servizio.getAccordoServizioParteComune());
                    this.log.debug("invocazione metodo getWSDLAccordoServizio (search accordo) nel registro[" + nomeRegInLista + "]...");
                    as = driver instanceof DriverRegistroServiziDB ? ((DriverRegistroServiziDB)driver).getAccordoServizioParteComune(idAccordo2, true) : driver.getAccordoServizioParteComune(idAccordo2);
                    if (as == null) {
                        throw new DriverRegistroServiziNotFound("Accordo di servizio [" + idAccordo2 + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nel registro");
                    }
                    if (servizio.getPortType() != null && !"".equals(servizio.getPortType())) {
                        boolean findPortType = false;
                        for (int l = 0; l < as.sizePortTypeList(); ++l) {
                            if (!servizio.getPortType().equals(as.getPortType(l).getNome())) continue;
                            findPortType = true;
                            break;
                        }
                        if (!findPortType) {
                            throw new DriverRegistroServiziNotFound("PortType[" + servizio.getPortType() + "] associato al servizio [" + idService.getTipoServizio() + idService.getServizio() + "] non presente nell'Accordo di servizio [" + idAccordo2 + "]");
                        }
                    }
                    registroServiziDB = driver instanceof DriverRegistroServiziDB;
                    find = true;
                }
                catch (DriverRegistroServiziNotFound ed) {
                    this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita (metodo getWSDLAccordoServizio): " + ed.getMessage());
                    notFoundProblem.append("\nRegistro[" + nomeRegInLista + "], ricerca fallita: " + ed.getMessage());
                }
                catch (Exception e) {
                    this.log.debug("Ricerca nel registro [" + nomeRegInLista + "] non riuscita, " + e.getMessage(), (Throwable)e);
                    if (this.raggiungibilitaTotale) {
                        throw new DriverRegistroServiziException(e.getMessage(), e);
                    }
                    exceptionProblem.append("\nRegistro[" + nomeRegInLista + "], accesso non riuscito: " + e.getMessage());
                }
                if (!find) continue;
                break;
            }
            this.log.debug("invocazione metodo getWSDLAccordoServizio completata.");
            if (!find) {
                if (exceptionProblem.length() > 0 && notFoundProblem.length() > 0) {
                    throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString() + notFoundProblem.toString());
                }
                if (exceptionProblem.length() > 0) {
                    throw new DriverRegistroServiziException("getWSDLAccordoServizio:" + exceptionProblem.toString());
                }
                if (notFoundProblem.length() > 0) {
                    throw new DriverRegistroServiziNotFound("getWSDLAccordoServizio:" + notFoundProblem.toString());
                }
                throw new DriverRegistroServiziException("getWSDLAccordoServizio: ricerca non riuscita in tutti i registri");
            }
            accordoServizioWrapper = new AccordoServizioWrapper();
            idAccordo = this.idAccordoFactory.getIDAccordoFromAccordo(as);
            accordoServizioWrapper.setIdAccordoServizio(idAccordo);
            accordoServizioWrapper.setNomePortType(servizio.getPortType());
            accordoServizioWrapper.setTipologiaServizio(servizio.getServizio().getTipologiaServizio());
            accordoServizioWrapper.setAccordoServizio(as);
            accordoServizioWrapper.setLocationWsdlImplementativoErogatore(servizio.getWsdlImplementativoErogatore());
            accordoServizioWrapper.setLocationWsdlImplementativoFruitore(servizio.getWsdlImplementativoFruitore());
            accordoServizioWrapper.setBytesWsdlImplementativoErogatore(servizio.getByteWsdlImplementativoErogatore());
            accordoServizioWrapper.setBytesWsdlImplementativoFruitore(servizio.getByteWsdlImplementativoFruitore());
            AccordoServizioWrapperUtilities wsdlWrapperUtilities = new AccordoServizioWrapperUtilities(this.log);
            wsdlWrapperUtilities.setAccordoServizio(accordoServizioWrapper);
            if (buildSchemaXSD) {
                try {
                    boolean buildFromBytes = registroServiziDB;
                    wsdlWrapperUtilities.buildSchema(buildFromBytes);
                }
                catch (DriverRegistroServiziException e) {
                    throw new DriverRegistroServiziException("[SchemaXSD] " + e.getMessage(), e);
                }
            }
            try {
                AccordoServizioWrapper accordoServizioWrapperStep2;
                block48: {
                    block47: {
                        if (InformationWsdlSource.WSDL.equals((Object)infoWsdlSource)) {
                            this.log.debug("Costruisco WSDLAccordoServizio from WSDL...");
                            this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilities);
                            break block44;
                        }
                        if (InformationWsdlSource.REGISTRY.equals((Object)infoWsdlSource)) {
                            this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio...");
                            wsdlWrapperUtilities.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                            break block44;
                        }
                        if (InformationWsdlSource.WSDL_REGISTRY.equals((Object)infoWsdlSource) || InformationWsdlSource.SAFE_WSDL_REGISTRY.equals((Object)infoWsdlSource)) {
                            block46: {
                                block45: {
                                    this.log.debug("Costruisco WSDLAccordoServizio from WSDL (Step1)...");
                                    try {
                                        this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilities);
                                    }
                                    catch (DriverRegistroServiziException e) {
                                        if (!InformationWsdlSource.WSDL_REGISTRY.equals((Object)infoWsdlSource)) break block45;
                                        throw e;
                                    }
                                }
                                this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio (Step2)...");
                                AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new AccordoServizioWrapperUtilities(this.log);
                                accordoServizioWrapperStep2 = accordoServizioWrapper.clone(false);
                                wsdlWrapperUtilitiesStep2.setAccordoServizio(accordoServizioWrapperStep2);
                                try {
                                    wsdlWrapperUtilitiesStep2.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                                }
                                catch (DriverRegistroServiziException e) {
                                    if (!InformationWsdlSource.WSDL_REGISTRY.equals((Object)infoWsdlSource)) break block46;
                                    throw e;
                                }
                            }
                            this.log.debug("Costruisco WSDLAccordoServizio merge WSDL e AccordoServizio (Step3)...");
                            this._merge(accordoServizioWrapper, accordoServizioWrapperStep2);
                            break block44;
                        }
                        if (!InformationWsdlSource.REGISTRY_WSDL.equals((Object)infoWsdlSource) && !InformationWsdlSource.SAFE_REGISTRY_WSDL.equals((Object)infoWsdlSource)) break block44;
                        this.log.debug("Costruisco WSDLAccordoServizio from AccordoServizio (Step1)...");
                        try {
                            wsdlWrapperUtilities.buildAccordoServizioWrapperFromOpenSPCoopAS(as);
                        }
                        catch (DriverRegistroServiziException e) {
                            if (!InformationWsdlSource.REGISTRY_WSDL.equals((Object)infoWsdlSource)) break block47;
                            throw e;
                        }
                    }
                    this.log.debug("Costruisco WSDLAccordoServizio from WSDL (Step2)...");
                    AccordoServizioWrapperUtilities wsdlWrapperUtilitiesStep2 = new AccordoServizioWrapperUtilities(this.log);
                    accordoServizioWrapperStep2 = accordoServizioWrapper.clone(false);
                    wsdlWrapperUtilitiesStep2.setAccordoServizio(accordoServizioWrapperStep2);
                    try {
                        this._loadFromWsdl(servizio, registroServiziDB, wsdlWrapperUtilitiesStep2);
                    }
                    catch (DriverRegistroServiziException e) {
                        if (!InformationWsdlSource.REGISTRY_WSDL.equals((Object)infoWsdlSource)) break block48;
                        throw e;
                    }
                }
                this.log.debug("Costruisco WSDLAccordoServizio merge  AccordoServizio e WSDL (Step3)...");
                this._merge(accordoServizioWrapper, accordoServizioWrapperStep2);
            }
            catch (DriverRegistroServiziException e) {
                if (TipologiaServizio.CORRELATO.equals(servizio.getServizio().getTipologiaServizio())) {
                    throw new DriverRegistroServiziException("[WSDL-FRUITORE] " + e.getMessage(), e);
                }
                throw new DriverRegistroServiziException("[WSDL-EROGATORE] " + e.getMessage(), e);
            }
        }
        this.log.debug("invocazione metodo getWSDLAccordoServizio completata.");
        return accordoServizioWrapper;
    }

    private void _loadFromWsdl(AccordoServizioParteSpecifica servizio, boolean registroServiziDB, AccordoServizioWrapperUtilities wsdlWrapperUtilities) throws DriverRegistroServiziException {
        if (TipologiaServizio.CORRELATO.equals(servizio.getServizio().getTipologiaServizio())) {
            Definition wsdlFruitore = null;
            wsdlFruitore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlFruitoreFromBytes() : wsdlWrapperUtilities.buildWsdlFruitore();
            boolean readParteImplementativa = servizio.getWsdlImplementativoFruitore() != null && !"".equals(servizio.getWsdlImplementativoFruitore()) || servizio.getByteWsdlImplementativoFruitore() != null || wsdlFruitore.getAllBindings() != null && wsdlFruitore.getAllBindings().size() > 0;
            wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlFruitore, readParteImplementativa);
        } else {
            Definition wsdlErogatore = null;
            wsdlErogatore = registroServiziDB ? wsdlWrapperUtilities.buildWsdlErogatoreFromBytes() : wsdlWrapperUtilities.buildWsdlErogatore();
            boolean readParteImplementativa = servizio.getWsdlImplementativoErogatore() != null && !"".equals(servizio.getWsdlImplementativoErogatore()) || servizio.getByteWsdlImplementativoErogatore() != null || wsdlErogatore.getAllBindings() != null && wsdlErogatore.getAllBindings().size() > 0;
            wsdlWrapperUtilities.buildAccordoServizioWrapperFromWsdl(wsdlErogatore, readParteImplementativa);
        }
    }

    private void _merge(AccordoServizioWrapper ptA, AccordoServizioWrapper ptB) {
        for (int i = 0; i < ptB.sizePortTypeList(); ++i) {
            PortType portTypeB = ptB.getPortType(i);
            boolean exists = false;
            for (int j = 0; j < ptA.sizePortTypeList(); ++j) {
                PortType portTypeA = ptA.getPortType(j);
                if (!portTypeB.getNome().equals(portTypeA.getNome())) continue;
                for (Operation opB : portTypeB.getAzioneList()) {
                    boolean existsOperation = false;
                    for (Operation opA : portTypeA.getAzioneList()) {
                        if (!opB.getNome().equals(opA.getNome())) continue;
                        existsOperation = true;
                        break;
                    }
                    if (existsOperation) continue;
                    portTypeA.addAzione(opB);
                }
                exists = true;
                break;
            }
            if (exists) continue;
            ptA.addPortType(portTypeB);
        }
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (this.cache != null) {
            return this._pushGenericObject(keyObject, object);
        }
        return object;
    }

    private synchronized Serializable _pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (keyObject == null) {
            throw new DriverRegistroServiziException("[getGenericObject]: Parametro non definito");
        }
        String key = null;
        key = "getGenericObject_" + keyObject;
        CacheResponse response = (CacheResponse)this.cache.get(key);
        if (response != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return response.getObject();
        }
        try {
            CacheResponse responseCache = new CacheResponse();
            responseCache.setObject(object);
            this.cache.put(key, responseCache);
        }
        catch (UtilsException e) {
            this.log.error("Errore durante l'inserimento in cache [" + key + "]: " + e.getMessage());
        }
        return object;
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        CacheResponse response;
        if (keyObject == null) {
            throw new DriverRegistroServiziException("[getGenericObject]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getGenericObject_" + keyObject)) != null) {
            if (response.getException() != null) {
                if (DriverRegistroServiziNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverRegistroServiziNotFound)response.getException();
                }
                throw (DriverRegistroServiziException)response.getException();
            }
            return response.getObject();
        }
        throw new DriverRegistroServiziNotFound("GenericObject with key [" + keyObject + "] not found");
    }
}

