/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.utils;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ValidatoreXSD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.RegistroServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.Web;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.utils.XMLUtilsException;
import it.link.pdd.tools.migrazione_govway.utils.xml.JaxbUtils;
import it.link.pdd.tools.migrazione_govway.utils.xml.JiBXUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    public static synchronized ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(log, XMLUtils.class.getResourceAsStream("/protocolManifestMigrazione.xsd"));
        }
        return validatoreXSD;
    }

    public static boolean validate(Openspcoop2 openspcoop2, StringBuffer motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (openspcoop2.getFactory() == null) {
            motivoErroreValidazione.append("Factory non definita\n");
        }
        if (openspcoop2.getWeb() == null) {
            motivoErroreValidazione.append("Web non definito\n");
        } else if (!(openspcoop2.getWeb().sizeContextList() > 0 || openspcoop2.getWeb().getEmptyContext() != null && openspcoop2.getWeb().getEmptyContext().getEnabled())) {
            motivoErroreValidazione.append("WebContext non definito ne tramite un context ne tramite un empty context\n");
        }
        if (openspcoop2.getRegistroServizi() == null) {
            motivoErroreValidazione.append("Registro non definito\n");
        } else {
            RegistroServizi reg = openspcoop2.getRegistroServizi();
            if (reg.getServizi() == null) {
                motivoErroreValidazione.append("Registro.Servizi non definito\n");
            } else if (reg.getServizi().getTipi() == null || reg.getServizi().getTipi().sizeTipoList() <= 0) {
                motivoErroreValidazione.append("Registro.Servizi.tipi non definito\n");
            }
            if (reg.getSoggetti() == null) {
                motivoErroreValidazione.append("Registro.Soggetti non definito\n");
            } else if (reg.getSoggetti().getTipi() == null || reg.getSoggetti().getTipi().sizeTipoList() <= 0) {
                motivoErroreValidazione.append("Registro.Soggetti.tipi non definito\n");
            }
            if (reg.getVersioni() == null) {
                motivoErroreValidazione.append("Registro.Versioni non definito\n");
            } else if (reg.getVersioni().sizeVersioneList() <= 0) {
                motivoErroreValidazione.append("Registro.Versioni.versione non definito\n");
            }
        }
        return motivoErroreValidazione.length() == size;
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            Openspcoop2 openspcoop2 = XMLUtils.getOpenspcoop2Manifest(log, bin);
            return openspcoop2;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            Openspcoop2 openspcoop2 = XMLUtils.getOpenspcoop2Manifest(log, fin);
            return openspcoop2;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getOpenspcoop2Manifest(log, m.getBytes());
    }

    public static Openspcoop2 getOpenspcoop2Manifest(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida(binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (Openspcoop2)JaxbUtils.xmlToObj(binTrasformazione, Openspcoop2.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, File out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(out.getName(), XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, String fileName) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JiBXUtils.objToXml(fileName, XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateOpenspcoop2Manifest(Openspcoop2 manifest) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateOpenspcoop2Manifest_engine(manifest);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateOpenspcoop2Manifest(Openspcoop2 manifest, OutputStream out) throws XMLUtilsException {
        try {
            StringBuffer risultatoValidazione = new StringBuffer();
            if (!XMLUtils.validate(manifest, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateOpenspcoop2Manifest_engine(manifest));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateOpenspcoop2Manifest_engine(Openspcoop2 manifest) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JiBXUtils.objToXml(bout, Openspcoop2.class, (Object)manifest);
            byte[] dichiarazione = bout.toByteArray();
            return dichiarazione;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isOpenspcoop2Manifest(byte[] doc) {
        try {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils xmlUtils = it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils.getInstance();
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isOpenspcoop2Manifest(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOpenspcoop2Manifest(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isOpenspcoop2Manifest(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isOpenspcoop2Manifest(Element elemXML) {
        try {
            return "openspcoop2".equals(elemXML.getLocalName()) && "http://www.openspcoop2.org/protocol/manifest".equals(elemXML.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String toString(Openspcoop2 manifest) {
        int i;
        StringBuffer bf = new StringBuffer();
        bf.append(" Protocollo " + manifest.getProtocolName() + " \n");
        bf.append("Factory[" + manifest.getFactory() + "]\n");
        Web web = manifest.getWeb();
        for (int i2 = 0; i2 < web.sizeContextList(); ++i2) {
            bf.append("Context[" + i2 + "]=[" + web.getContext(i2) + "]\n");
        }
        if (web.getEmptyContext() != null) {
            bf.append("EmptyContext=[" + web.getEmptyContext().getEnabled() + "]\n");
        } else {
            bf.append("EmptyContext not defined\n");
        }
        RegistroServizi reg = manifest.getRegistroServizi();
        if (reg.getServizi() != null && reg.getServizi().getTipi() != null) {
            for (i = 0; i < reg.getServizi().getTipi().sizeTipoList(); ++i) {
                bf.append("Servizi.tipoSupportato[" + i + "]=[" + reg.getServizi().getTipi().getTipo(i) + "]\n");
            }
        }
        if (reg.getSoggetti() != null && reg.getSoggetti().getTipi() != null) {
            for (i = 0; i < reg.getSoggetti().getTipi().sizeTipoList(); ++i) {
                bf.append("Soggetti.tipoSupportato[" + i + "]=[" + reg.getSoggetti().getTipi().getTipo(i) + "]\n");
            }
        }
        if (reg.getVersioni() != null) {
            for (i = 0; i < reg.getVersioni().sizeVersioneList(); ++i) {
                bf.append("Versione[" + i + "]=[" + reg.getVersioni().getVersione(i) + "]\n");
            }
        }
        return bf.toString();
    }
}

