/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.ConsegnaInOrdine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.registry.RegistroServiziManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolVersionManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroriCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.RuoloBusta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.StatefulMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.StatelessMessage;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ValidazioneSemanticaResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.util.Vector;
import org.slf4j.Logger;

public class ValidazioneSemantica {
    protected IState state;
    protected Vector<Eccezione> erroriValidazione;
    protected Vector<Eccezione> erroriProcessamento;
    protected Busta busta;
    protected boolean validazioneIdentificativiCompleta = false;
    protected String servizioCorrelato;
    protected String tipoServizioCorrelato;
    protected String azioneCorrelata;
    protected RegistroServiziManager registroServiziReader;
    protected Servizio infoServizio = null;
    protected Logger log = null;
    private IProtocolFactory protocolFactory;

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public ValidazioneSemantica(Busta aBusta, IState state, boolean validazioneIdentificativiCompleta, IProtocolFactory protocolFactory) {
        this(aBusta, state, validazioneIdentificativiCompleta, Configurazione.getLibraryLog(), protocolFactory);
    }

    public ValidazioneSemantica(Busta aBusta, IState state, boolean validazioneIdentificativiCompleta, Logger alog, IProtocolFactory protocolFactory) {
        this.busta = aBusta;
        this.state = state;
        this.registroServiziReader = RegistroServiziManager.getInstance(state);
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(ValidazioneSemantica.class);
        this.validazioneIdentificativiCompleta = validazioneIdentificativiCompleta;
        this.protocolFactory = protocolFactory;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        return this.erroriValidazione;
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        return this.erroriProcessamento;
    }

    public void valida(OpenSPCoop2Message msg, ProprietaValidazione proprietaValidazione, RuoloBusta tipoBusta, String versioneProtocollo) {
        try {
            IProtocolVersionManager protocolVersioneManager;
            StatoFunzionalitaProtocollo modalitaGestioneCollaborazione;
            proprietaValidazione.setValidazioneIDCompleta(this.validazioneIdentificativiCompleta);
            proprietaValidazione.setVersioneProtocollo(versioneProtocollo);
            ValidazioneSemanticaResult result = this.protocolFactory.createValidazioneSemantica().valida(msg, this.busta, this.state, proprietaValidazione, tipoBusta);
            this.infoServizio = result.getInfoServizio();
            this.servizioCorrelato = result.getServizioCorrelato();
            this.tipoServizioCorrelato = result.getTipoServizioCorrelato();
            this.erroriProcessamento = result.getErroriProcessamento();
            if (this.erroriProcessamento == null) {
                this.erroriProcessamento = new Vector();
            }
            this.erroriValidazione = result.getErroriValidazione();
            if (this.erroriValidazione == null) {
                this.erroriValidazione = new Vector();
            }
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && !RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString()) && !RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
                this.validazioneCorrelazione(tipoBusta);
            }
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && this.busta.getRiferimentoMessaggio() != null) {
                this.validazioneRiferimentoMessaggio(tipoBusta);
            }
            if (this.erroriValidazione.size() == 0 && this.erroriProcessamento.size() == 0 && this.busta != null && this.busta.getProfiloDiCollaborazione() != null && !RuoloBusta.BUSTA_DI_SERVIZIO.equals(tipoBusta.toString()) && (StatoFunzionalitaProtocollo.ABILITATA.equals((Object)(modalitaGestioneCollaborazione = (protocolVersioneManager = this.protocolFactory.createProtocolVersionManager(versioneProtocollo)).getCollaborazione(this.busta.getProfiloDiCollaborazione()))) || StatoFunzionalitaProtocollo.REGISTRO.equals((Object)modalitaGestioneCollaborazione) && this.infoServizio != null && this.infoServizio.getCollaborazione())) {
                this.riconoscimentoCollaborazione(tipoBusta);
            }
        }
        catch (ProtocolException e) {
            this.log.error("ProtocolException error", (Throwable)e);
        }
    }

    public static String riconoscimentoVersioneProtocolloServizioErogato(Busta busta, ITraduttore costanti, RuoloBusta tipoBusta, IState state) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto idSoggettoFruitoreProfiloGestito = null;
        if (busta.getTipoServizio() != null && busta.getServizio() != null) {
            IDServizio idServizioProfiloGestito = new IDServizio();
            idServizioProfiloGestito.setTipoServizio(busta.getTipoServizio());
            idServizioProfiloGestito.setServizio(busta.getServizio());
            idServizioProfiloGestito.setAzione(busta.getAzione());
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(busta.getProfiloDiCollaborazione()) && RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) && !RuoloBusta.RICHIESTA.equals(tipoBusta.toString())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoDestinatario(), busta.getDestinatario());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
                } else {
                    idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                    idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
                }
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione()) && (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString()))) {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoMittente(), busta.getMittente());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoDestinatario(), busta.getDestinatario());
            } else {
                idServizioProfiloGestito.setSoggettoErogatore(busta.getTipoDestinatario(), busta.getDestinatario());
                idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
            }
            return RegistroServiziManager.getInstance(state).getProfiloGestioneErogazioneServizio(idSoggettoFruitoreProfiloGestito, idServizioProfiloGestito, null);
        }
        idSoggettoFruitoreProfiloGestito = new IDSoggetto(busta.getTipoMittente(), busta.getMittente());
        return RegistroServiziManager.getInstance(state).getProfiloGestioneSoggetto(idSoggettoFruitoreProfiloGestito, null);
    }

    public static RuoloBusta getTipoBustaDaValidare(Busta busta, IProtocolFactory protocolFactory, boolean validazioneRispostaHttpReply, IState state, Logger log) throws ProtocolException {
        RuoloBusta tipo = RuoloBusta.BUSTA_DI_SERVIZIO;
        if (busta.getProfiloDiCollaborazione() == null || busta.getServizio() == null || busta.getTipoServizio() == null) {
            tipo = RuoloBusta.BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY) && busta.getRiferimentoMessaggio() != null) {
            tipo = RuoloBusta.BUSTA_DI_SERVIZIO;
        } else if (busta.getProfiloDiCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY)) {
            tipo = RuoloBusta.RICHIESTA;
        } else if (busta.getProfiloDiCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO)) {
            tipo = busta.getRiferimentoMessaggio() == null ? RuoloBusta.RICHIESTA : RuoloBusta.RISPOSTA;
        } else if (busta.getProfiloDiCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO) || busta.getProfiloDiCollaborazione().equals(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO)) {
            ProfiloDiCollaborazione profilo;
            tipo = busta.getRiferimentoMessaggio() == null && busta.getCollaborazione() == null ? RuoloBusta.RICHIESTA : ((profilo = new ProfiloDiCollaborazione(state, log, protocolFactory)).asincrono_isRicevutaRichiesta(busta.getRiferimentoMessaggio()) ? RuoloBusta.RICEVUTA_RICHIESTA : (profilo.asincrono_isRicevutaRisposta(busta.getRiferimentoMessaggio()) ? RuoloBusta.RICEVUTA_RISPOSTA : (!validazioneRispostaHttpReply && profilo.asincrono_isRisposta(busta) ? RuoloBusta.RISPOSTA : RuoloBusta.RICHIESTA)));
        }
        return tipo;
    }

    public boolean validazioneID(String id) throws ProtocolException {
        return this.validazioneID(id, null, null, null);
    }

    private boolean validazioneID(String id, String tipoCodAmm, String codAmm, String codDominio) throws ProtocolException {
        ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
        proprietaValidazione.setValidazioneIDCompleta(this.validazioneIdentificativiCompleta);
        IDSoggetto dominio = new IDSoggetto(tipoCodAmm, codAmm, codDominio);
        return this.protocolFactory.createValidazioneSemantica().validazioneID(id, dominio, proprietaValidazione);
    }

    private void validazioneRiferimentoMessaggio(RuoloBusta tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log, this.protocolFactory);
            boolean error = false;
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(this.busta.getProfiloDiCollaborazione())) {
                if (!profiloDiCollaborazione.sincrono_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneRiferimentoMessaggio(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_richiestaStato(this.busta.getRiferimentoMessaggio())) {
                        error = true;
                    }
                } else if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneRiferimentoMessaggio_ricevuta(this.busta.getRiferimentoMessaggio())) {
                    error = true;
                }
            }
            if (error) {
                Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ecc);
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null && this.busta.getRiferimentoMessaggio() != null && !this.busta.getRiferimentoMessaggio().equals(bustaCorrelata.getID())) {
                Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ecc);
            }
        } else {
            throw new ProtocolException("Metodo invocato con IState non valido");
        }
    }

    private void riconoscimentoCollaborazione(RuoloBusta tipoBusta) throws ProtocolException {
        IDSoggetto soggMitt = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
        String dominioMittente = null;
        try {
            dominioMittente = this.registroServiziReader.getDominio(soggMitt, null, this.protocolFactory);
            if (dominioMittente == null) {
                throw new Exception("Dominio non definito");
            }
        }
        catch (DriverRegistroServiziNotFound es) {
            Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.MITTENTE_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
            this.log.debug("Identificazione mittente fallita:" + es.getMessage());
            this.erroriValidazione.add(ecc);
            return;
        }
        catch (Exception es) {
            Eccezione ecc = Eccezione.getEccezioneProcessamento(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Identificazione mittente non riuscita: errore di processamento"), this.protocolFactory);
            this.log.error("Identificazione mittente non riuscita", (Throwable)es);
            this.erroriProcessamento.add(ecc);
            return;
        }
        IDSoggetto soggDest = new IDSoggetto(this.busta.getTipoDestinatario(), this.busta.getDestinatario());
        String dominioDestinatario = null;
        try {
            dominioDestinatario = this.registroServiziReader.getDominio(soggDest, null, this.protocolFactory);
            if (dominioDestinatario == null) {
                throw new Exception("Dominio non definito");
            }
        }
        catch (DriverRegistroServiziNotFound es) {
            Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.DESTINATARIO_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
            this.log.debug("Identificazione destinatario fallita: " + es.getMessage());
            this.erroriValidazione.add(ecc);
            return;
        }
        catch (Exception es) {
            Eccezione ecc = Eccezione.getEccezioneProcessamento(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Identificazione destinatario non riuscita: errore di processamento"), this.protocolFactory);
            this.log.error("Identificazione destinatario non riuscita", (Throwable)es);
            this.erroriProcessamento.add(ecc);
            return;
        }
        if (this.busta.getCollaborazione() != null && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getTipoMittente(), this.busta.getMittente(), dominioMittente) && !this.validazioneID(this.busta.getCollaborazione(), this.busta.getTipoDestinatario(), this.busta.getDestinatario(), dominioDestinatario)) {
            Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.COLLABORAZIONE_NON_VALIDA.getErroreCooperazione(), this.protocolFactory);
            this.erroriValidazione.add(ecc);
            return;
        }
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            if (this.busta.getCollaborazione() != null) {
                ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log, this.protocolFactory);
                boolean error = false;
                if (!it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(this.busta.getProfiloDiCollaborazione())) {
                    if (!tipoBusta.equals("Richiesta")) {
                        if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString()) && !profiloDiCollaborazione.sincrono_validazioneCollaborazione(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                                if (!profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_risposta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) && !profiloDiCollaborazione.asincronoSimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                            if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                                if (!profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_richiestaStato(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                    error = true;
                                }
                            } else if ((RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString()) || RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) && !profiloDiCollaborazione.asincronoAsimmetrico_validazioneCollaborazione_ricevuta(this.busta.getRiferimentoMessaggio(), this.busta.getCollaborazione())) {
                                error = true;
                            }
                        }
                    }
                } else {
                    ConsegnaInOrdine consegna = new ConsegnaInOrdine(stateful, this.log, this.protocolFactory);
                    Eccezione ecc = consegna.validazioneDatiConsegnaInOrdine(this.busta, this.protocolFactory);
                    if (ecc != null) {
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                }
                if (error) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.COLLABORAZIONE_SCONOSCIUTA.getErroreCooperazione(), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
            }
            return;
        }
        if (this.state instanceof StatelessMessage) {
            ConsegnaInOrdine consegna;
            Eccezione ecc;
            StatelessMessage stateless = (StatelessMessage)this.state;
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ONEWAY.equals(this.busta.getProfiloDiCollaborazione()) && (ecc = (consegna = new ConsegnaInOrdine(stateless, this.log, this.protocolFactory)).validazioneDatiConsegnaInOrdine(this.busta, this.protocolFactory)) != null) {
                this.erroriValidazione.add(ecc);
                return;
            }
            return;
        }
        throw new ProtocolException("Metodo invocato con IState non valido");
    }

    private void validazioneCorrelazione(RuoloBusta tipoBusta) throws ProtocolException {
        if (this.state instanceof StatefulMessage) {
            StatefulMessage stateful = (StatefulMessage)this.state;
            ProfiloDiCollaborazione profiloDiCollaborazione = new ProfiloDiCollaborazione(stateful, this.log, this.protocolFactory);
            Eccezione ecc = null;
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(this.busta.getProfiloDiCollaborazione())) {
                ecc = profiloDiCollaborazione.sincrono_validazioneCorrelazione(this.busta, this.protocolFactory);
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_risposta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoSimmetrico_validazioneCorrelazione_ricevutaRisposta(this.busta, this.protocolFactory);
                }
            } else if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(this.busta.getProfiloDiCollaborazione())) {
                if (RuoloBusta.RICEVUTA_RICHIESTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiesta(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_richiestaStato(this.busta, this.protocolFactory);
                } else if (RuoloBusta.RICEVUTA_RISPOSTA.equals(tipoBusta.toString())) {
                    ecc = profiloDiCollaborazione.asincronoAsimmetrico_validazioneCorrelazione_ricevutaRichiestaStato(this.busta, this.protocolFactory);
                }
            }
            if (ecc != null) {
                this.erroriValidazione.add(ecc);
                return;
            }
        } else if (this.state instanceof StatelessMessage) {
            StatelessMessage stateless;
            Busta bustaCorrelata;
            if (it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione.SINCRONO.equals(this.busta.getProfiloDiCollaborazione()) && (bustaCorrelata = (stateless = (StatelessMessage)this.state).getBustaCorrelata()) != null) {
                if (!this.busta.getTipoDestinatario().equals(bustaCorrelata.getTipoMittente())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.TIPO_MITTENTE_NON_VALIDO.getErroreCooperazione("Tipo del mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getDestinatario().equals(bustaCorrelata.getMittente())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.MITTENTE_NON_VALIDO.getErroreCooperazione("Mittente diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getTipoMittente().equals(bustaCorrelata.getTipoDestinatario())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.TIPO_DESTINATARIO_NON_VALIDO.getErroreCooperazione("Tipo del destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (!this.busta.getMittente().equals(bustaCorrelata.getDestinatario())) {
                    Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.DESTINATARIO_NON_VALIDO.getErroreCooperazione("Destinatario diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                    this.erroriValidazione.add(ecc);
                    return;
                }
                if (this.busta.getServizio() != null && bustaCorrelata.getTipoServizio() != null) {
                    if (!this.busta.getTipoServizio().equals(bustaCorrelata.getTipoServizio())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.TIPO_SERVIZIO_NON_VALIDO.getErroreCooperazione("Tipo di servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                    if (!this.busta.getServizio().equals(bustaCorrelata.getServizio())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.SERVIZIO_NON_VALIDO.getErroreCooperazione("Servizio diverso da quello atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                    if (this.busta.getAzione() != null && !this.busta.getAzione().equals(bustaCorrelata.getAzione())) {
                        Eccezione ecc = Eccezione.getEccezioneValidazione(ErroriCooperazione.AZIONE_NON_VALIDA.getErroreCooperazione("Azione diversa da quella atteso nella gestione del profilo di collaborazione Sincrono"), this.protocolFactory);
                        this.erroriValidazione.add(ecc);
                        return;
                    }
                }
            }
        } else {
            throw new ProtocolException("Metodo invocato con IState non valido");
        }
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public Servizio getInfoServizio() {
        return this.infoServizio;
    }

    public String getAzioneCorrelata() {
        return this.azioneCorrelata;
    }

    public void setAzioneCorrelata(String azioneCorrelata) {
        this.azioneCorrelata = azioneCorrelata;
    }

    public void setValidazioneIdentificativiCompleta(boolean v) {
        this.validazioneIdentificativiCompleta = v;
    }
}

