/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.validator.ValidazioneConSchema;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.validator.ValidazioneSemantica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.validator.ValidazioneSintattica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.SecurityInfo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroriCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.RuoloBusta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidatoreErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazioneErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.SubErrorCodeSecurity;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;

public class Validatore {
    private IState state;
    private OpenSPCoop2Message msg;
    private ProprietaValidazione proprietaValidazione;
    ErroreCooperazione errore;
    private Vector<Eccezione> erroriValidazione = new Vector();
    private Vector<Eccezione> erroriProcessamento = new Vector();
    private boolean isMessaggioErrore;
    private boolean isMessaggioErroreIntestazione;
    private boolean isMessaggioErroreProcessamento;
    private boolean isBustaDiServizio;
    private Busta busta;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private ValidazioneSintattica validatoreSintattico;
    private String servizioCorrelato;
    private String tipoServizioCorrelato;
    private Servizio infoServizio = null;
    private String versioneProtocollo = null;
    private RuoloBusta ruoloBustaRicevuta = null;
    private SecurityInfo securityInfo = null;
    private boolean readQualifiedAttribute;
    private Logger log = null;
    private IProtocolFactory protocolFactory;
    private IProtocolManager protocolManager;
    private Busta bustaErroreHeaderIntestazione = null;
    private Exception eccezioneProcessamentoValidazioneSintattica = null;
    private boolean rilevatiErroriDuranteValidazioneSemantica = false;
    private Exception eccezioneProcessamentoValidazioneSemantica = null;

    public ValidazioneSintattica getValidatoreSintattico() {
        return this.validatoreSintattico;
    }

    public void setValidatoreSintattico(ValidazioneSintattica validator) {
        this.validatoreSintattico = validator;
    }

    public Busta getBustaErroreHeaderIntestazione() {
        return this.bustaErroreHeaderIntestazione;
    }

    public Validatore(OpenSPCoop2Message aMsg, ProprietaValidazione aValidazione, IState state, boolean readQualifiedAttribute, IProtocolFactory protocolFactory) throws ProtocolException {
        this(aMsg, aValidazione, state, Configurazione.getLibraryLog(), readQualifiedAttribute, protocolFactory);
    }

    public Validatore(OpenSPCoop2Message aMsg, ProprietaValidazione aValidazione, IState state, Logger alog, boolean readQualifiedAttribute, IProtocolFactory protocolFactory) throws ProtocolException {
        this.msg = aMsg;
        this.proprietaValidazione = aValidazione == null ? new ProprietaValidazione() : aValidazione;
        this.state = state;
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(Validatore.class);
        this.readQualifiedAttribute = readQualifiedAttribute;
        this.protocolFactory = protocolFactory;
        this.protocolManager = this.protocolFactory.createProtocolManager();
    }

    public Validatore(OpenSPCoop2Message aMsg, IState state, Logger alog, IProtocolFactory protocolFactory) throws ProtocolException {
        this(aMsg, null, state, alog, false, protocolFactory);
    }

    public boolean validazioneSintattica() {
        return this.validazioneSintattica(null, null);
    }

    public boolean validazioneSintattica(Busta busta, Boolean isRichiesta) {
        try {
            this.validatoreSintattico = new ValidazioneSintattica(this.state, this.msg, busta, isRichiesta, this.log, this.readQualifiedAttribute, this.protocolFactory);
            if (!this.validatoreSintattico.valida()) {
                this.errore = this.validatoreSintattico.getErrore();
                this.bustaErroreHeaderIntestazione = this.validatoreSintattico.getBustaErroreHeaderIntestazione();
                return false;
            }
            this.busta = this.validatoreSintattico.getBusta();
            IValidatoreErrori validatoreErrori = this.protocolFactory.createValidatoreErrori();
            ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
            pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
            this.isMessaggioErrore = validatoreErrori.isBustaErrore(this.busta, this.msg, pValidazioneErrori);
            this.isMessaggioErroreIntestazione = validatoreErrori.isBustaErroreIntestazione(this.busta, this.msg, pValidazioneErrori);
            this.isMessaggioErroreProcessamento = validatoreErrori.isBustaErroreProcessamento(this.busta, this.msg, pValidazioneErrori);
            this.isBustaDiServizio = this.protocolFactory.createProtocolManager().isBustaServizio(this.busta);
            if (this.isMessaggioErrore) {
                this.addListaEccezioni(this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni(), this.erroriValidazione);
            } else {
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniValidazione(), this.erroriValidazione);
            }
            this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
            if (this.isBustaDiServizio && this.busta.sizeListaEccezioni() <= 0 && this.busta.sizeListaRiscontri() <= 0) {
                Eccezione ec = Eccezione.getEccezioneValidazione(ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione(), this.protocolFactory);
                this.erroriValidazione.add(ec);
                this.isBustaDiServizio = false;
            }
            if (this.busta.getTipoMittente() != null && this.busta.getMittente() != null) {
                this.mittente = new IDSoggetto(this.busta.getTipoMittente(), this.busta.getMittente());
                this.mittente.setCodicePorta(this.busta.getIdentificativoPortaMittente());
            }
            this.servizio = new IDServizio(this.busta.getTipoDestinatario(), this.busta.getDestinatario(), this.busta.getTipoServizio(), this.busta.getServizio(), this.busta.getAzione());
            this.servizio.getSoggettoErogatore().setCodicePorta(this.busta.getIdentificativoPortaDestinatario());
            if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("validazioneSintattica", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSintattica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Errore di processamento: " + e.getMessage());
            return false;
        }
    }

    public Exception getEccezioneProcessamentoValidazioneSintattica() {
        return this.eccezioneProcessamentoValidazioneSintattica;
    }

    public boolean isRilevatiErroriDuranteValidazioneSemantica() {
        return this.rilevatiErroriDuranteValidazioneSemantica;
    }

    public boolean validazioneSemantica_beforeMessageSecurity(boolean rispostaConnectionReply, String profiloGestione) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            if (this.validatoreSintattico == null) {
                this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Errore di processamento: Analisi sintattica richiesta e validatoreSintattico non risulta inizializzato");
                return false;
            }
            if (this.ruoloBustaRicevuta == null) {
                this.ruoloBustaRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(this.busta, this.protocolFactory, rispostaConnectionReply, this.state, this.log);
            }
            try {
                this.versioneProtocollo = rispostaConnectionReply ? profiloGestione : (this.busta != null && this.busta.getMittente() != null && this.busta.getTipoMittente() != null ? ValidazioneSemantica.riconoscimentoVersioneProtocolloServizioErogato(this.busta, this.protocolFactory.createTraduttore(), this.ruoloBustaRicevuta, this.state) : profiloGestione);
            }
            catch (Exception e) {
                this.log.error("Riconoscimento profilo di gestione non riuscito", (Throwable)e);
            }
            if (this.protocolFactory.createProtocolVersionManager(this.versioneProtocollo).isEccezioniLivelloInfoAbilitato() && this.isMessaggioErrore) {
                IValidatoreErrori validatoreErrori = this.protocolFactory.createValidatoreErrori();
                ProprietaValidazioneErrori pValidazioneErrori = new ProprietaValidazioneErrori();
                pValidazioneErrori.setIgnoraEccezioniNonGravi(this.protocolManager.isIgnoraEccezioniNonGravi());
                pValidazioneErrori.setVersioneProtocollo(this.versioneProtocollo);
                this.isMessaggioErrore = validatoreErrori.isBustaErrore(this.busta, this.msg, pValidazioneErrori);
                this.isMessaggioErroreIntestazione = validatoreErrori.isBustaErroreIntestazione(this.busta, this.msg, pValidazioneErrori);
                this.isMessaggioErroreProcessamento = validatoreErrori.isBustaErroreProcessamento(this.busta, this.msg, pValidazioneErrori);
            }
            boolean ignoraEccezioniLivelloNonGravi = this.protocolFactory.createProtocolVersionManager(this.versioneProtocollo).isIgnoraEccezioniLivelloNonGrave();
            int sizeErroriValidazione = this.countErrori(ignoraEccezioniLivelloNonGravi, this.erroriValidazione);
            int sizeErroriProcessamento = this.countErrori(ignoraEccezioniLivelloNonGravi, this.erroriProcessamento);
            if (sizeErroriValidazione > 0 || sizeErroriProcessamento > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_beforeMessageSecurity)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_messageSecurity_readSecurityInfo(MessageSecurityContext messageSecurityContext) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            if (messageSecurityContext != null && messageSecurityContext.getDigestReader() != null) {
                this.securityInfo = this.protocolFactory.createValidazioneSemantica().readSecurityInformation(messageSecurityContext.getDigestReader(), this.msg, this.msg.getSOAPPart().getEnvelope(), this.validatoreSintattico.getProtocolHeader());
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_messageSecurity_readSecurityInfo)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_messageSecurity_process(MessageSecurityContext messageSecurityContext, StringBuffer errore) {
        block14: {
            try {
                this.rilevatiErroriDuranteValidazioneSemantica = true;
                if (messageSecurityContext == null || messageSecurityContext.getIncomingProperties() == null || messageSecurityContext.getIncomingProperties().size() <= 0) break block14;
                boolean existsHeaderMessageSecurity = messageSecurityContext.existsSecurityHeader(this.msg, messageSecurityContext.getActor());
                if (messageSecurityContext.processIncoming(this.msg, this.busta)) break block14;
                ArrayList<Eccezione> eccezioniSicurezza = new ArrayList<Eccezione>();
                if (messageSecurityContext.getListaSubCodiceErrore() != null && messageSecurityContext.getListaSubCodiceErrore().size() > 0) {
                    List<SubErrorCodeSecurity> subCodiciErrore = messageSecurityContext.getListaSubCodiceErrore();
                    for (SubErrorCodeSecurity subCodiceErrore : subCodiciErrore) {
                        Eccezione ecc = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(subCodiceErrore.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.protocolFactory);
                        ecc.setSubCodiceEccezione(subCodiceErrore);
                        eccezioniSicurezza.add(ecc);
                    }
                } else {
                    Eccezione ecc = new Eccezione(ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), true, null, this.protocolFactory);
                    eccezioniSicurezza.add(ecc);
                }
                if (this.isMessaggioErrore) {
                    if (existsHeaderMessageSecurity) {
                        for (Eccezione ecc : eccezioniSicurezza) {
                            this.erroriValidazione.add(ecc);
                            if (errore.length() > 0) {
                                errore.append("\n");
                            }
                            errore.append(ecc.getDescrizione(this.protocolFactory));
                        }
                        return true;
                    }
                    StringBuffer bf = new StringBuffer();
                    for (Eccezione ecc : eccezioniSicurezza) {
                        if (bf.length() > 0) {
                            bf.append(" ; ");
                        }
                        bf.append(ecc.toString(this.protocolFactory));
                    }
                    this.log.debug("MessageSecurityHeader not exists: " + bf.toString());
                    break block14;
                }
                for (Eccezione ecc : eccezioniSicurezza) {
                    this.erroriValidazione.add(ecc);
                    if (errore.length() > 0) {
                        errore.append("\n");
                    }
                    errore.append(ecc.getDescrizione(this.protocolFactory));
                }
                return true;
            }
            catch (Exception e) {
                if (errore.length() > 0) {
                    errore.append("\n");
                }
                errore.append(e.getMessage());
                this.log.error("validazioneSemantica (validazioneSemantica_messageSecurity_process)", (Throwable)e);
                this.eccezioneProcessamentoValidazioneSemantica = e;
                this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
                return false;
            }
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public boolean validazioneSemantica_afterMessageSecurity(ProprietaManifestAttachments proprietaManifestAttachments, boolean validazioneIdentificativiCompleta) {
        try {
            this.rilevatiErroriDuranteValidazioneSemantica = true;
            if (this.isMessaggioErrore) {
                this.validatoreSintattico.validazioneFault(this.msg.getSOAPBody());
                this.addListaEccezioni(this.validatoreSintattico.getErroriTrovatiSullaListaEccezioni(), this.erroriValidazione);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (!this.isMessaggioErrore && this.proprietaValidazione.isValidazioneManifestAttachments() && this.msg.countAttachments() > 0) {
                this.validatoreSintattico.validazioneManifestAttachments(this.msg, proprietaManifestAttachments);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(this.validatoreSintattico.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (!this.isMessaggioErrore) {
                ValidazioneSemantica registryValidator = new ValidazioneSemantica(this.busta, this.state, validazioneIdentificativiCompleta, this.log, this.protocolFactory);
                registryValidator.valida(this.msg, this.proprietaValidazione, this.ruoloBustaRicevuta, this.versioneProtocollo);
                this.addListaEccezioni(registryValidator.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(registryValidator.getEccezioniProcessamento(), this.erroriProcessamento);
                this.servizioCorrelato = registryValidator.getServizioCorrelato();
                this.tipoServizioCorrelato = registryValidator.getTipoServizioCorrelato();
                this.infoServizio = registryValidator.getInfoServizio();
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
            if (this.proprietaValidazione.isValidazioneConSchema()) {
                SOAPBody body = this.msg.getSOAPBody();
                ValidazioneConSchema schemaValidator = new ValidazioneConSchema(this.msg, this.validatoreSintattico.getProtocolHeader(), body, this.isMessaggioErroreProcessamento, this.isMessaggioErroreIntestazione, this.proprietaValidazione.isValidazioneManifestAttachments(), this.log, this.protocolFactory);
                schemaValidator.valida(this.msg.countAttachments() > 0);
                this.addListaEccezioni(schemaValidator.getEccezioniValidazione(), this.erroriValidazione);
                this.addListaEccezioni(schemaValidator.getEccezioniProcessamento(), this.erroriProcessamento);
                if (this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("validazioneSemantica (validazioneSemantica_afterMessageSecurity)", (Throwable)e);
            this.eccezioneProcessamentoValidazioneSemantica = e;
            this.errore = ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreCooperazione();
            return false;
        }
        this.rilevatiErroriDuranteValidazioneSemantica = false;
        return true;
    }

    public Exception getEccezioneProcessamentoValidazioneSemantica() {
        return this.eccezioneProcessamentoValidazioneSemantica;
    }

    public ErroreCooperazione getErrore() {
        return this.errore;
    }

    public boolean validazioneConEccezioni() {
        return this.erroriValidazione != null && this.erroriValidazione.size() > 0 || this.erroriProcessamento != null && this.erroriProcessamento.size() > 0;
    }

    public Vector<Eccezione> getEccezioniValidazione() {
        if (this.erroriValidazione != null) {
            return this.erroriValidazione;
        }
        return new Vector<Eccezione>();
    }

    public Vector<Eccezione> getEccezioniProcessamento() {
        if (this.erroriProcessamento != null) {
            return this.erroriProcessamento;
        }
        return new Vector<Eccezione>();
    }

    public boolean isErroreProtocollo() {
        return this.isMessaggioErrore;
    }

    public boolean isMessaggioErroreIntestazione() {
        return this.isMessaggioErroreIntestazione;
    }

    public boolean isMessaggioErroreProcessamento() {
        return this.isMessaggioErroreProcessamento;
    }

    public boolean isBustaDiServizio() {
        return this.isBustaDiServizio;
    }

    public Busta getBusta() {
        return this.busta;
    }

    public IDSoggetto getSoggettoMittente() {
        return this.mittente;
    }

    public void setMittente(IDSoggetto mittente) {
        this.mittente = mittente;
    }

    public IDServizio getIDServizio() {
        return this.servizio;
    }

    public String getServizioCorrelato() {
        return this.servizioCorrelato;
    }

    public String getTipoServizioCorrelato() {
        return this.tipoServizioCorrelato;
    }

    public Servizio getInfoServizio() {
        return this.infoServizio;
    }

    public String getProfiloGestione() {
        return this.versioneProtocollo;
    }

    public void setProfiloGestione(String profiloGestione) {
        this.versioneProtocollo = profiloGestione;
    }

    public RuoloBusta getRuoloBustaRicevuta(boolean rispostaConnectionReply) throws ProtocolException {
        if (this.ruoloBustaRicevuta == null) {
            this.ruoloBustaRicevuta = ValidazioneSemantica.getTipoBustaDaValidare(this.busta, this.protocolFactory, rispostaConnectionReply, this.state, this.log);
        }
        return this.ruoloBustaRicevuta;
    }

    public void setProprietaValidazione(ProprietaValidazione proprietaValidazione) {
        this.proprietaValidazione = proprietaValidazione;
    }

    public SOAPElement getHeaderProtocollo() {
        return this.validatoreSintattico.getProtocolHeader();
    }

    public SOAPElement getHeaderProtocollo_senzaControlli() throws ProtocolException {
        this.validatoreSintattico = new ValidazioneSintattica(this.state, this.msg, this.log, this.protocolFactory);
        return this.validatoreSintattico.getHeaderProtocollo_senzaControlli();
    }

    private void addListaEccezioni(Vector<Eccezione> from, Vector<Eccezione> to) {
        if (from != null) {
            to.addAll(from);
        }
    }

    public SecurityInfo getSecurityInfo() {
        return this.securityInfo;
    }

    private int countErrori(boolean ignoraEccezioniNonGravi, List<Eccezione> list) {
        int size = 0;
        if (list != null) {
            for (Eccezione eccezione : list) {
                if (eccezione.getRilevanza() != null && ignoraEccezioniNonGravi) {
                    if (!LivelloRilevanza.isEccezioneLivelloGrave(eccezione.getRilevanza())) continue;
                    ++size;
                    continue;
                }
                ++size;
            }
        }
        return size;
    }

    public void updateMsg(OpenSPCoop2Message msg) throws ProtocolException {
        boolean update;
        boolean bl = update = !msg.getClass().getName().equals(this.msg.getClass().getName());
        if (update) {
            this.msg = msg;
            if (this.validatoreSintattico != null) {
                this.validatoreSintattico.updateMsg(msg);
            }
        }
    }
}

