/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.BustaNonRiscontrata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.History;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.StateMessage;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import it.link.pdd.tools.migrazione_govway.utils.jdbc.JDBCUtilities;
import it.link.pdd.tools.migrazione_govway.utils.sql.ISQLQueryObject;
import it.link.pdd.tools.migrazione_govway.utils.sql.SQLObjectFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import org.slf4j.Logger;

public class Riscontri {
    private Logger log = null;
    private IState state;

    public Riscontri(IState state) {
        this(state, Configurazione.getLibraryLog());
    }

    public Riscontri(IState state, Logger alog) {
        this.state = state;
        this.log = alog != null ? alog : LoggerWrapperFactory.getLogger(Riscontri.class.getName());
    }

    public void registraRiscontroDaRicevere(String id, Date timestamp) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        try {
            Timestamp oraInvio = new Timestamp(timestamp.getTime());
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO  ");
            query.append("RISCONTRI_DA_RICEVERE");
            query.append(" VALUES ( ? , ? )");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, id);
            pstmt.setTimestamp(2, oraInvio);
            stateMSG.getPreparedStatement().put("UPDATE saveRiscontroDaRicevere_" + id, (PreparedStatement)pstmt);
            History historyBuste = new History(this.state);
            historyBuste.registraBustaInviata(id);
        }
        catch (Exception e) {
            String errorMsg = "RISCONTRI, Errore di registrazione " + id + ": " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProtocolException(errorMsg, e);
        }
    }

    public Vector<BustaNonRiscontrata> getBustePerUlterioreInoltro(long timeout, int limit, int offset, boolean logQuery) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmt = null;
        ResultSet rs = null;
        Vector<String> IDBuste = new Vector<String>();
        String queryString = null;
        try {
            long nowTime = DateManager.getTimeMillis() - timeout * 60L * 1000L;
            Timestamp scadenzaRiscontro = new Timestamp(nowTime);
            if (Configurazione.getSqlQueryObjectType() == null) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT ID_MESSAGGIO FROM ");
                query.append("RISCONTRI_DA_RICEVERE");
                query.append(" WHERE DATA_INVIO < ? ");
                queryString = query.toString();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject(Configurazione.getSqlQueryObjectType());
                sqlQueryObject.addSelectField("ID_MESSAGGIO");
                sqlQueryObject.addSelectField("DATA_INVIO");
                sqlQueryObject.addFromTable("RISCONTRI_DA_RICEVERE");
                sqlQueryObject.addWhereCondition("DATA_INVIO < ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("DATA_INVIO");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            pstmt = connectionDB.prepareStatement(queryString);
            pstmt.setTimestamp(1, scadenzaRiscontro);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                this.log.debug("[QUERY] (Riscontri) [" + queryString + "] 1[" + scadenzaRiscontro + "]...");
            }
            rs = pstmt.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                this.log.debug("[QUERY] (Riscontri) [" + queryString + "] 1[" + scadenzaRiscontro + "] effettuata in " + secondSQLCommand + " secondi");
            }
            if (rs == null) {
                pstmt.close();
                throw new ProtocolException("RS NULL?");
            }
            int countLimit = 0;
            int countOffset = 0;
            while (rs.next()) {
                String id;
                if (Configurazione.getSqlQueryObjectType() == null) {
                    if (countOffset >= offset) {
                        id = rs.getString("ID_MESSAGGIO");
                        IDBuste.add(id);
                        if (++countLimit != limit) continue;
                        break;
                    }
                    ++countOffset;
                    continue;
                }
                id = rs.getString("ID_MESSAGGIO");
                IDBuste.add(id);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String errorMsg = "[Riscontri.getBustePerUlterioreInoltro] errore, queryString[" + queryString + "]: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, e);
        }
        Vector<BustaNonRiscontrata> listaBustaNonRiscontrata = new Vector<BustaNonRiscontrata>();
        for (int i = 0; i < IDBuste.size(); ++i) {
            BustaNonRiscontrata bustaNonRiscontrata = new BustaNonRiscontrata();
            bustaNonRiscontrata.setIdentificativo((String)IDBuste.get(i));
            bustaNonRiscontrata.setProfiloCollaborazione(ProfiloDiCollaborazione.ONEWAY);
            listaBustaNonRiscontrata.add(bustaNonRiscontrata);
        }
        return listaBustaNonRiscontrata;
    }

    @Deprecated
    public void validazioneRiscontroRicevuto_serializable(String idRiscontro) throws ProtocolException {
        this.validazioneRiscontroRicevuto_serializable(idRiscontro, 60L, 100);
    }

    @Deprecated
    public void validazioneRiscontroRicevuto_serializable(String idRiscontro, long attesaAttiva, int checkInterval) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        int oldTransactionIsolation = -1;
        try {
            oldTransactionIsolation = connectionDB.getTransactionIsolation();
            connectionDB.setAutoCommit(false);
            JDBCUtilities.setTransactionIsolationSerializable(Configurazione.getSqlQueryObjectType(), connectionDB);
        }
        catch (Exception er) {
            String errorMsg = "RISCONTRI, Errore durante la validazioneRiscontroRicevuto(setIsolation): " + er.getMessage();
            this.log.error(errorMsg, (Throwable)er);
            throw new ProtocolException(errorMsg, er);
        }
        boolean deleteRiscontroOK = false;
        long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
        while (!deleteRiscontroOK && DateManager.getTimeMillis() < scadenzaWhile) {
            Statement pstmtDelete = null;
            try {
                StringBuffer query = new StringBuffer();
                query.delete(0, query.capacity());
                query.append("DELETE FROM ");
                query.append("RISCONTRI_DA_RICEVERE");
                query.append(" WHERE ID_MESSAGGIO = ?");
                pstmtDelete = connectionDB.prepareStatement(query.toString());
                pstmtDelete.setString(1, idRiscontro);
                pstmtDelete.execute();
                pstmtDelete.close();
                History historyBuste = new History(this.state, this.log);
                historyBuste.eliminaBustaInviata(idRiscontro);
                stateMSG.executePreparedStatement();
                connectionDB.commit();
                deleteRiscontroOK = true;
            }
            catch (Exception e) {
                try {
                    if (pstmtDelete != null) {
                        pstmtDelete.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    connectionDB.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (deleteRiscontroOK) continue;
            try {
                Utilities.sleep(new Random().nextInt(checkInterval));
            }
            catch (Exception e) {}
        }
        try {
            connectionDB.setTransactionIsolation(oldTransactionIsolation);
            connectionDB.setAutoCommit(true);
        }
        catch (Exception er) {
            String errorMsg = "RISCONTRI, Errore durante la validazioneRiscontroRicevuto(ripristinoIsolation): " + er.getMessage();
            this.log.error(errorMsg, (Throwable)er);
            throw new ProtocolException(errorMsg, er);
        }
    }

    public void validazioneRiscontroRicevuto(String idRiscontro) throws ProtocolException {
        StateMessage stateMSG = (StateMessage)this.state;
        Connection connectionDB = stateMSG.getConnectionDB();
        Statement pstmtDelete = null;
        try {
            StringBuffer query = new StringBuffer();
            query.delete(0, query.capacity());
            query.append("DELETE FROM ");
            query.append("RISCONTRI_DA_RICEVERE");
            query.append(" WHERE ID_MESSAGGIO = ?");
            pstmtDelete = connectionDB.prepareStatement(query.toString());
            pstmtDelete.setString(1, idRiscontro);
            stateMSG.getPreparedStatement().put("UPDATE validazioneRiscontroRicevuto_" + idRiscontro, (PreparedStatement)pstmtDelete);
            History historyBuste = new History(stateMSG, this.log);
            historyBuste.eliminaBustaInviataPerRiscontri(idRiscontro);
        }
        catch (Exception e) {
            try {
                if (pstmtDelete != null) {
                    pstmtDelete.close();
                }
            }
            catch (Exception historyBuste) {
                // empty catch block
            }
            String errorMsg = "RISCONTRI, Errore durante la validazioneRiscontroRicevuto: " + e.getMessage();
            this.log.error(errorMsg, (Throwable)e);
            throw new ProtocolException(errorMsg, e);
        }
    }
}

