/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.History;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.IFiltroDuplicati;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.driver.RepositoryBuste;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;

public class FiltroDuplicati
implements IFiltroDuplicati {
    private History historyBuste;
    private RepositoryBuste repositoryBuste;
    private boolean gestioneStateless;
    private long repositoryIntervalloScadenzaMessaggi;

    @Override
    public void init(Object context) throws ProtocolException {
    }

    @Override
    public boolean isDuplicata(IProtocolFactory protocolFactory, String id) throws ProtocolException {
        return this.historyBuste.bustaRicevutaPrecedentemente(id);
    }

    @Override
    public void incrementaNumeroDuplicati(IProtocolFactory protocolFactory, String id) throws ProtocolException {
        this.repositoryBuste.aggiornaDuplicatiIntoInBox(id);
    }

    @Override
    public void registraBusta(IProtocolFactory protocolFactory, Busta busta) throws ProtocolException {
        if (this.gestioneStateless) {
            if (!this.repositoryBuste.isRegistrataIntoInBox(busta.getID())) {
                this.repositoryBuste.registraBustaIntoInboxForHistory(busta, this.repositoryIntervalloScadenzaMessaggi);
            }
        } else {
            this.historyBuste.registraBustaRicevuta(busta.getID());
        }
    }

    public void setHistoryBuste(History historyBuste) {
        this.historyBuste = historyBuste;
    }

    public void setRepositoryBuste(RepositoryBuste repository) {
        this.repositoryBuste = repository;
    }

    public void setGestioneStateless(boolean stateless) {
        this.gestioneStateless = stateless;
    }

    public void setRepositoryIntervalloScadenzaMessaggi(long repositoryIntervalloScadenzaMessaggi) {
        this.repositoryIntervalloScadenzaMessaggi = repositoryIntervalloScadenzaMessaggi;
    }
}

