/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.IXMLTracciaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.tracciamento.Traccia;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;

public class TracciaBuilder {
    protected Logger log = null;
    private IProtocolFactory protocolFactory;
    private IXMLTracciaBuilder tracciaProtocolBuilder;

    public TracciaBuilder(IProtocolFactory protocolFactory) {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public TracciaBuilder(Logger aLog, IProtocolFactory protocolFactory) {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(TracciaBuilder.class);
        this.protocolFactory = protocolFactory;
        try {
            this.tracciaProtocolBuilder = this.protocolFactory.createXMLTracciaBuilder();
        }
        catch (Exception e) {
            this.log.error("Errore durante la creazione dell'XMLTracciaBuilder: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public SOAPElement toElement(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toElement(traccia);
    }

    public byte[] toByteArray(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toByteArray(traccia);
    }

    public String toString(Traccia traccia) throws ProtocolException {
        return this.tracciaProtocolBuilder.toString(traccia);
    }
}

