/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.DettaglioEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageParseResult;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPFaultCode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SoapUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Integrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroriCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.security.message.MessageSecurityContext;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class Imbustamento {
    private Logger log = null;
    private IProtocolFactory protocolFactory;
    private XMLUtils xmlUtils;
    private IProtocolManager protocolManager;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioEccezioneOpenSPCoop2Builder;
    public static int prefixLenght = 0;

    public Imbustamento(IProtocolFactory protocolFactory) throws ProtocolException {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public Imbustamento(Logger aLog, IProtocolFactory protocolFactory) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(Imbustamento.class);
        this.protocolFactory = protocolFactory;
        this.xmlUtils = XMLUtils.getInstance();
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.dettaglioEccezioneOpenSPCoop2Builder = new DettaglioEccezioneOpenSPCoop2Builder(aLog, protocolFactory);
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public String buildID(IState state, IDSoggetto idSoggetto, String idTransazione, long attesaAttiva, int checkInterval, Boolean isRichiesta) throws ProtocolException {
        try {
            return this.protocolFactory.createBustaBuilder().newID(state, idSoggetto, idTransazione, isRichiesta);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public void imbustamento(IState state, OpenSPCoop2Message msg, Busta busta, Integrazione integrazione, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        this.imbustamento(state, msg, busta, integrazione, false, false, false, proprietaManifestAttachments);
    }

    public SOAPElement imbustamento(IState state, OpenSPCoop2Message msg, Busta busta, Integrazione integrazione, boolean gestioneManifest, boolean isRichiesta, boolean scartaBody, ProprietaManifestAttachments proprietaManifestAttachments) throws ProtocolException {
        if (proprietaManifestAttachments == null) {
            proprietaManifestAttachments = new ProprietaManifestAttachments();
        }
        proprietaManifestAttachments.setGestioneManifest(gestioneManifest);
        proprietaManifestAttachments.setScartaBody(scartaBody);
        return this.protocolFactory.createBustaBuilder().imbustamento(state, msg, busta, isRichiesta, proprietaManifestAttachments);
    }

    public SOAPElement addTrasmissione(OpenSPCoop2Message message, Trasmissione trasmissione, boolean readQualifiedAttribute) throws ProtocolException {
        return this.protocolFactory.createBustaBuilder().addTrasmissione(message, trasmissione);
    }

    public Busta buildMessaggioErroreProtocollo_Validazione(List<Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        return this.buildMessaggioErroreProtocollo(eccezioni, busta, id_busta, tipoTempo);
    }

    public Busta buildMessaggioErroreProtocollo_Processamento(List<Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        return this.buildMessaggioErroreProtocollo(eccezioni, busta, id_busta, tipoTempo);
    }

    public Busta buildMessaggioErroreProtocollo_Processamento(Eccezione ecc, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        Vector<Eccezione> eccs = new Vector<Eccezione>();
        eccs.add(ecc);
        return this.buildMessaggioErroreProtocollo(eccs, busta, id_busta, tipoTempo);
    }

    private Busta buildMessaggioErroreProtocollo(List<Eccezione> eccezioni, Busta busta, String id_busta, TipoOraRegistrazione tipoTempo) throws ProtocolException {
        String tipoDest = busta.getTipoMittente();
        String dest = busta.getMittente();
        String indTdest = busta.getIndirizzoMittente();
        String codicePorta = busta.getIdentificativoPortaMittente();
        busta.setTipoMittente(busta.getTipoDestinatario());
        busta.setMittente(busta.getDestinatario());
        busta.setIndirizzoMittente(busta.getIndirizzoDestinatario());
        busta.setIdentificativoPortaMittente(busta.getIdentificativoPortaDestinatario());
        busta.setTipoDestinatario(tipoDest);
        busta.setDestinatario(dest);
        busta.setIndirizzoDestinatario(indTdest);
        busta.setIdentificativoPortaDestinatario(codicePorta);
        busta.setRiferimentoMessaggio(busta.getID());
        busta.setID(id_busta);
        busta.setOraRegistrazione(DateManager.getDate());
        busta.setTipoOraRegistrazione(tipoTempo, this.protocolFactory.createTraduttore().toString(tipoTempo));
        while (busta.sizeListaTrasmissioni() != 0) {
            busta.removeTrasmissione(0);
        }
        while (busta.sizeListaEccezioni() != 0) {
            busta.removeEccezione(0);
        }
        while (busta.sizeListaRiscontri() != 0) {
            busta.removeRiscontro(0);
        }
        while (eccezioni.size() > 0) {
            Eccezione e = eccezioni.remove(0);
            busta.addEccezione(e);
        }
        if (!this.protocolFactory.createProtocolManager().isGenerazioneElementiNonValidabiliRispettoXSD()) {
            if (busta.getProfiloDiCollaborazione() != null) {
                if (!(ProfiloDiCollaborazione.ONEWAY.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.SINCRONO.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO.equals(busta.getProfiloDiCollaborazione()) || ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO.equals(busta.getProfiloDiCollaborazione()))) {
                    busta.setProfiloDiCollaborazione(null);
                    busta.setTipoServizioCorrelato(null);
                    busta.setServizioCorrelato(null);
                } else if (busta.getTipoServizioCorrelato() != null && !this.protocolFactory.createProtocolConfiguration().getTipiServizi().contains(busta.getTipoServizioCorrelato())) {
                    busta.setTipoServizioCorrelato(null);
                }
            }
            if (busta.getRiferimentoMessaggio() != null) {
                ProprietaValidazione proprietaValidazione = new ProprietaValidazione();
                proprietaValidazione.setValidazioneIDCompleta(false);
                if (!this.protocolFactory.createValidazioneSemantica().validazioneID(busta.getRiferimentoMessaggio(), null, proprietaValidazione)) {
                    busta.setRiferimentoMessaggio(null);
                }
            }
            if (busta.getInoltro() != null && !Inoltro.CON_DUPLICATI.equals(busta.getInoltro()) && !Inoltro.SENZA_DUPLICATI.equals(busta.getInoltro())) {
                busta.setInoltro(null, null);
            }
        }
        return busta;
    }

    private String getFaultCodePrefix(SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        if (setSoapPrefixBackwardCompatibilityOpenSPCoop1 && this.protocolFactory != null && this.protocolFactory.getProtocol() != null && this.protocolFactory.getProtocol().equals("spcoop") && SOAPVersion.SOAP11.equals((Object)versioneSoap)) {
            return "soap";
        }
        return null;
    }

    public OpenSPCoop2Message buildSoapMsgErroreProtocollo_Validazione(SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.buildSoapMsgProtocolloErrore(true, null, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message buildSoapMsgErroreProtocollo_Processamento(DettaglioEccezione dettaglioEccezione, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.buildSoapMsgProtocolloErrore(false, dettaglioEccezione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message buildSoapMsgProtocolloErrore(boolean erroreValidazione, DettaglioEccezione dettaglioEccezione, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            OpenSPCoop2MessageFactory mf = OpenSPCoop2MessageFactory.getMessageFactory();
            OpenSPCoop2Message msg = mf.createMessage(versioneSoap);
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            env.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            SOAPBody bdy = env.getBody();
            SOAPFault fault = bdy.addFault();
            String soapFaultCodePrefix = this.getFaultCodePrefix(versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            if (erroreValidazione) {
                fault.setFaultString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE.toString(this.protocolFactory));
                fault.setFaultCode(SOAPFaultCode.Sender.toQName(versioneSoap, soapFaultCodePrefix));
            } else {
                fault.setFaultString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO.toString(this.protocolFactory));
                fault.setFaultCode(SOAPFaultCode.Receiver.toQName(versioneSoap, soapFaultCodePrefix));
            }
            if (!erroreValidazione && dettaglioEccezione != null) {
                Detail d = fault.addDetail();
                Element e = this.xmlUtils.newElement(it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtils.generateDettaglioEccezione(dettaglioEccezione));
                d.appendChild(d.getOwnerDocument().importNode(e, true));
            }
            return msg;
        }
        catch (Exception e) {
            this.log.error("Build msgErrore non riuscito: " + e.getMessage());
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "ErroreProcessamento");
        }
    }

    public OpenSPCoop2Message buildSoapFaultProtocollo_processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, Throwable eProcessamento, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            DettaglioEccezione dettaglioEccezione = null;
            if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, errore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(errore));
                this.dettaglioEccezioneOpenSPCoop2Builder.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
            }
            String soapFaultCodePrefix = this.getFaultCodePrefix(versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            QName faultCode = SOAPFaultCode.Receiver.toQName(versioneSoap, soapFaultCodePrefix);
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(versioneSoap, SoapUtils.build_Soap_Fault(versioneSoap, this.protocolFactory.createTraduttore().toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO), null, faultCode, this.xmlUtils.newElement(it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtils.generateDettaglioEccezione(dettaglioEccezione)), this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()));
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "Errore buildSoapFaultProtocollo_processamento(exception): " + e.getMessage());
        }
    }

    public OpenSPCoop2Message buildSoapFaultProtocollo_processamento(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            DettaglioEccezione dettaglioEccezione = null;
            if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, errore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(errore));
            }
            String soapFaultCodePrefix = this.getFaultCodePrefix(versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            QName faultCode = SOAPFaultCode.Receiver.toQName(versioneSoap, soapFaultCodePrefix);
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(versioneSoap, SoapUtils.build_Soap_Fault(versioneSoap, this.protocolFactory.createTraduttore().toString(MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO), null, faultCode, this.xmlUtils.newElement(it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtils.generateDettaglioEccezione(dettaglioEccezione)), this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()));
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("Errore buildSoapFault_processamento: " + e.getMessage(), (Throwable)e);
            }
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "Errore buildSoapFaultProtocollo_processamento: " + e.getMessage());
        }
    }

    public OpenSPCoop2Message buildSoapFaultProtocollo_intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, CodiceErroreCooperazione codiceErrore, String msgErrore, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) throws ProtocolException {
        DettaglioEccezione dettaglioEccezione = null;
        if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneValidazione()) {
            dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, codiceErrore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(codiceErrore, msgErrore));
        }
        return this.buildSoapFaultProtocollo_intestazione(dettaglioEccezione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message buildSoapFaultProtocollo_intestazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) throws ProtocolException {
        DettaglioEccezione dettaglioEccezione = null;
        if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneValidazione()) {
            dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(identitaPdD, tipoPdD, modulo, errore, this.dettaglioEccezioneOpenSPCoop2Builder.transformFaultMsg(errore));
        }
        return this.buildSoapFaultProtocollo_intestazione(dettaglioEccezione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message buildSoapFaultProtocollo_intestazione(DettaglioEccezione dettaglioEccezione, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            String soapFaultCodePrefix = this.getFaultCodePrefix(versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            QName faultCode = SOAPFaultCode.Sender.toQName(versioneSoap, soapFaultCodePrefix);
            Element elementDetail = null;
            if (dettaglioEccezione != null) {
                byte[] bytesElement = it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.utils.XMLUtils.generateDettaglioEccezione(dettaglioEccezione);
                elementDetail = this.xmlUtils.newElement(bytesElement);
            }
            OpenSPCoop2MessageParseResult pr = OpenSPCoop2MessageFactory.getMessageFactory().createMessage(versioneSoap, SoapUtils.build_Soap_Fault(versioneSoap, this.protocolFactory.createTraduttore().toString(MessaggiFaultErroreCooperazione.FAULT_STRING_VALIDAZIONE), null, faultCode, elementDetail, this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneValidazione()));
            return pr.getMessage_throwParseException();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.error("Errore buildSoapFaultProtocollo_intestazione: " + e.getMessage(), (Throwable)e);
            }
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "Errore buildSoapFaultProtocollo_intestazione: " + e.getMessage());
        }
    }

    public void gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(Busta busta) {
        if (!this.protocolManager.isGenerazioneListaEccezioniErroreProcessamento()) {
            while (busta.sizeListaEccezioni() > 0) {
                Eccezione eccezione = busta.removeEccezione(0);
            }
        }
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IState state, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, List<Eccezione> errori, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.msgErroreProtocollo_Processamento(state, identitaPdD, tipoPdD, modulo, busta, integrazione, idTransazione, null, errori, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IState state, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.msgErroreProtocollo_Processamento(state, identitaPdD, tipoPdD, modulo, busta, integrazione, idTransazione, erroreCooperazione, null, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Processamento(IState state, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreIntegrazione erroreIntegrazione, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.msgErroreProtocollo_Processamento(state, identitaPdD, tipoPdD, modulo, busta, integrazione, idTransazione, null, null, erroreIntegrazione, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, eProcessamento, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    private OpenSPCoop2Message msgErroreProtocollo_Processamento(IState state, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, List<Eccezione> errori, ErroreIntegrazione erroreIntegrazione, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, Exception eProcessamento, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            Eccezione ecc;
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_bustaErrore = this.buildID(state, identitaPdD, idTransazione, attesaAttiva, checkInterval, Boolean.FALSE);
            if (errori == null) {
                errori = new Vector<Eccezione>();
            }
            if (erroreCooperazione != null) {
                ecc = Eccezione.getEccezioneProcessamento(erroreCooperazione, this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            if (erroreIntegrazione != null) {
                ecc = Eccezione.getEccezioneProcessamento(ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento(erroreIntegrazione.getDescrizione(this.protocolFactory)), this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            busta = this.buildMessaggioErroreProtocollo_Processamento(errori, busta, id_bustaErrore, tipoTempo);
            DettaglioEccezione dettaglioEccezione = null;
            if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocollo_EccezioneProcessamento()) {
                dettaglioEccezione = erroreIntegrazione != null ? this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezioneProcessamentoBusta(identitaPdD, tipoPdD, modulo, erroreIntegrazione, erroreIntegrazione.getDescrizione(this.protocolFactory), eProcessamento) : this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezioneFromBusta(identitaPdD, tipoPdD, modulo, null, busta, eProcessamento);
            }
            this.gestioneListaEccezioniMessaggioErroreProtocolloProcessamento(busta);
            OpenSPCoop2Message responseMessage = this.buildSoapMsgErroreProtocollo_Processamento(dettaglioEccezione, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    tras.setIdentificativoPortaDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getIdentificativoPortaOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            this.imbustamento(state, responseMessage, busta, integrazione, null);
            if (messageSecurityPropertiesResponse != null && messageSecurityPropertiesResponse.size() > 0) {
                messageSecurityContext.setOutgoingProperties(messageSecurityPropertiesResponse);
                if (!messageSecurityContext.processOutgoing(responseMessage)) {
                    return this.msgErroreProtocollo_Validazione(state, identitaPdD, modulo, busta, integrazione, idTransazione, ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
                }
            }
            return responseMessage;
        }
        catch (Exception e) {
            this.log.error("Build msgErroreProcessamento non riuscito: " + e.getMessage());
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "ErroreProcessamento");
        }
    }

    public OpenSPCoop2Message msgErroreProtocollo_Validazione(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, List<Eccezione> errori, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.msgErroreProtocollo_Validazione(state, identitaPdD, modulo, busta, integrazione, idTransazione, null, errori, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Validazione(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        return this.msgErroreProtocollo_Validazione(state, identitaPdD, modulo, busta, integrazione, idTransazione, erroreCooperazione, null, messageSecurityPropertiesResponse, messageSecurityContext, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
    }

    public OpenSPCoop2Message msgErroreProtocollo_Validazione(IState state, IDSoggetto identitaPdD, String modulo, Busta busta, Integrazione integrazione, String idTransazione, ErroreCooperazione erroreCooperazione, List<Eccezione> errori, Hashtable<String, Object> messageSecurityPropertiesResponse, MessageSecurityContext messageSecurityContext, long attesaAttiva, int checkInterval, String profiloGestione, TipoOraRegistrazione tipoTempo, boolean generazioneListaTrasmissioni, SOAPVersion versioneSoap, boolean setSoapPrefixBackwardCompatibilityOpenSPCoop1) {
        try {
            ArrayList<Trasmissione> listaTrasmissioniBustaRichiesta = new ArrayList<Trasmissione>();
            for (int i = 0; i < busta.sizeListaTrasmissioni(); ++i) {
                listaTrasmissioniBustaRichiesta.add(busta.getTrasmissione(i));
            }
            String id_bustaErrore = this.buildID(state, identitaPdD, idTransazione, attesaAttiva, checkInterval, Boolean.FALSE);
            if (errori == null) {
                errori = new Vector<Eccezione>();
            }
            if (erroreCooperazione != null) {
                Eccezione ecc = Eccezione.getEccezioneValidazione(erroreCooperazione, this.protocolFactory);
                ecc.setModulo(modulo);
                errori.add(ecc);
            }
            busta = this.buildMessaggioErroreProtocollo_Validazione(errori, busta, id_bustaErrore, tipoTempo);
            OpenSPCoop2Message responseMessage = this.buildSoapMsgErroreProtocollo_Validazione(versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
            if (generazioneListaTrasmissioni) {
                Trasmissione tras = new Trasmissione();
                tras.setOrigine(identitaPdD.getNome());
                tras.setTipoOrigine(identitaPdD.getTipo());
                tras.setIdentificativoPortaOrigine(identitaPdD.getCodicePorta());
                for (int i = 0; i < listaTrasmissioniBustaRichiesta.size(); ++i) {
                    if (!identitaPdD.getTipo().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoDestinazione()) || !identitaPdD.getNome().equals(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getDestinazione())) continue;
                    tras.setDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getOrigine());
                    tras.setTipoDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getTipoOrigine());
                    tras.setIdentificativoPortaDestinazione(((Trasmissione)listaTrasmissioniBustaRichiesta.get(i)).getIdentificativoPortaOrigine());
                }
                tras.setOraRegistrazione(busta.getOraRegistrazione());
                tras.setTempo(busta.getTipoOraRegistrazione());
                busta.addTrasmissione(tras);
            }
            this.imbustamento(state, responseMessage, busta, integrazione, null);
            if (messageSecurityPropertiesResponse != null && messageSecurityPropertiesResponse.size() > 0) {
                messageSecurityContext.setOutgoingProperties(messageSecurityPropertiesResponse);
                if (!messageSecurityContext.processOutgoing(responseMessage)) {
                    return this.msgErroreProtocollo_Validazione(state, identitaPdD, modulo, busta, integrazione, idTransazione, ErroriCooperazione.MESSAGE_SECURITY.getErroreMessageSecurity(messageSecurityContext.getMsgErrore(), messageSecurityContext.getCodiceErrore()), null, null, attesaAttiva, checkInterval, profiloGestione, tipoTempo, generazioneListaTrasmissioni, versioneSoap, setSoapPrefixBackwardCompatibilityOpenSPCoop1);
                }
            }
            return responseMessage;
        }
        catch (Exception e) {
            this.log.error("Build msgErroreProtocollo_Validazione non riuscito: " + e.getMessage(), (Throwable)e);
            return OpenSPCoop2MessageFactory.getMessageFactory().createFaultMessage(versioneSoap, "ErroreProcessamento");
        }
    }

    @Deprecated
    public String eraserType(String patch, String firmaRootElementHeader) throws ProtocolException {
        try {
            StringBuffer soapEnvelopePatch = new StringBuffer();
            int start = patch.indexOf("<" + firmaRootElementHeader);
            int end = patch.indexOf("</" + firmaRootElementHeader + "></" + firmaRootElementHeader + ">".length());
            soapEnvelopePatch.append(patch.substring(0, start));
            String header = patch.substring(start, end);
            header = header.replaceAll("xsi:type", "");
            header = header.replaceAll("=\"xsd", "");
            header = header.replaceAll(":string\"", "");
            header = header.replaceAll(":dateTime\"", "");
            soapEnvelopePatch.append(header);
            soapEnvelopePatch.append(patch.substring(end));
            return soapEnvelopePatch.toString();
        }
        catch (Exception e) {
            this.log.error("Imbustamento.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Imbustamento.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public byte[] eraserType(byte[] xml, String firmaRootElementHeader) throws ProtocolException {
        ByteArrayOutputStream cleanBusta = null;
        try {
            int i;
            String header = new String(xml);
            int start = header.indexOf("<" + firmaRootElementHeader);
            int end = header.indexOf("</" + firmaRootElementHeader + "></" + firmaRootElementHeader + ">".length());
            if (start == -1) {
                return null;
            }
            if (end == -1) {
                return null;
            }
            if (end <= start) {
                return null;
            }
            String eraserString = " xsi:type=\"xsd:string\"";
            String eraserDate = " xsi:type=\"xsd:dateTime\"";
            cleanBusta = new ByteArrayOutputStream();
            for (i = 0; i < start; ++i) {
                cleanBusta.write(xml[i]);
            }
            i = start;
            while (i < end) {
                if (xml[i] == 32) {
                    int k;
                    StringBuffer test;
                    if (i + eraserDate.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserDate.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserDate)) {
                            i += eraserDate.length();
                            continue;
                        }
                    }
                    if (i + eraserString.length() < end) {
                        test = new StringBuffer();
                        for (k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanBusta.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanBusta.write(xml[i]);
                ++i;
            }
            for (i = end; i < xml.length; ++i) {
                cleanBusta.write(xml[i]);
            }
            byte[] cleanBytes = cleanBusta.toByteArray();
            cleanBusta.close();
            return cleanBytes;
        }
        catch (Exception e) {
            try {
                if (cleanBusta != null) {
                    cleanBusta.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.error("Imbustamento.eraserType_byte non riuscito: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Imbustamento.eraserType_byte non riuscito: " + e.getMessage(), e);
        }
    }
}

