/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.DettaglioEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2MessageFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.ParseException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.SOAPVersion;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.AbstractEccezioneBuilderParameter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.EccezioneProtocolloBuilderParameters;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IErroreApplicativoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ErroreApplicativoBuilder {
    protected Logger log = null;
    protected OpenSPCoop2MessageFactory fac = OpenSPCoop2MessageFactory.getMessageFactory();
    private IProtocolFactory protocolFactory;
    private IProtocolManager protocolManager;
    private IErroreApplicativoBuilder erroreApplicativoBuilder;
    private XMLUtils xmlUtils;
    private IDSoggetto dominio;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private String idFunzione;
    private ProprietaErroreApplicativo proprietaErroreApplicato;
    private SOAPVersion soapVersion;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioEccezioneOpenSPCoop2Builder;
    private String servizioApplicativo;
    private TipoPdD tipoPdD = null;

    public void setDominio(IDSoggetto dominio) {
        this.dominio = dominio;
    }

    public void setMittente(IDSoggetto mittente) {
        this.mittente = mittente;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setProprietaErroreApplicato(ProprietaErroreApplicativo proprietaErroreApplicato) {
        this.proprietaErroreApplicato = proprietaErroreApplicato;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setTipoPdD(TipoPdD tipoPdD) {
        this.tipoPdD = tipoPdD;
    }

    public ErroreApplicativoBuilder(Logger aLog, IProtocolFactory protocolFactory, IDSoggetto dominio, IDSoggetto mittente, IDServizio servizio, String idFunzione, ProprietaErroreApplicativo proprietaErroreApplicativo, SOAPVersion soapVersion, TipoPdD tipoPdD, String servizioApplicativo) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(ErroreApplicativoBuilder.class);
        this.protocolFactory = protocolFactory;
        this.xmlUtils = XMLUtils.getInstance();
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
        this.dominio = dominio;
        this.mittente = mittente;
        this.servizio = servizio;
        this.idFunzione = idFunzione;
        this.proprietaErroreApplicato = proprietaErroreApplicativo;
        this.soapVersion = soapVersion;
        this.dettaglioEccezioneOpenSPCoop2Builder = new DettaglioEccezioneOpenSPCoop2Builder(aLog, protocolFactory);
        this.tipoPdD = tipoPdD;
        this.servizioApplicativo = servizioApplicativo;
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    private void setEccezioneBuilderParameter(AbstractEccezioneBuilderParameter parameters, DettaglioEccezione dettaglio, ParseException parseException) {
        parameters.setDettaglioEccezionePdD(dettaglio);
        parameters.setDominioPorta(this.dominio);
        parameters.setMittente(this.mittente);
        parameters.setServizio(this.servizio);
        parameters.setIdFunzione(this.idFunzione);
        parameters.setProprieta(this.proprietaErroreApplicato);
        parameters.setVersioneSoap(this.soapVersion);
        parameters.setTipoPorta(this.tipoPdD);
        parameters.setServizioApplicativo(this.servizioApplicativo);
        parameters.setParseException(parseException);
    }

    private EccezioneProtocolloBuilderParameters getEccezioneProtocolloBuilderParameters(Eccezione eccezioneProtocollo, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglio, ParseException parseException) {
        EccezioneProtocolloBuilderParameters parameters = new EccezioneProtocolloBuilderParameters();
        this.setEccezioneBuilderParameter(parameters, dettaglio, parseException);
        parameters.setEccezioneProtocollo(eccezioneProtocollo);
        parameters.setSoggettoProduceEccezione(soggettoProduceEccezione);
        return parameters;
    }

    private EccezioneIntegrazioneBuilderParameters getEccezioneIntegrazioneBuilderParameters(ErroreIntegrazione erroreIntegrazione, DettaglioEccezione dettaglio, ParseException parseException) {
        EccezioneIntegrazioneBuilderParameters parameters = new EccezioneIntegrazioneBuilderParameters();
        this.setEccezioneBuilderParameter(parameters, dettaglio, parseException);
        parameters.setErroreIntegrazione(erroreIntegrazione);
        return parameters;
    }

    public Element toElement(ErroreIntegrazione errore) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        return this.erroreApplicativoBuilder.toElement(parameters);
    }

    public byte[] toByteArray(ErroreIntegrazione errore) throws ProtocolException {
        Element eccezione = this.toElement(errore);
        if (eccezione == null) {
            throw new ProtocolException("Elemento non generato");
        }
        try {
            return this.xmlUtils.toByteArray(eccezione, true);
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("toByte failed: " + e.getMessage(), e);
        }
    }

    public void insertInSOAPFault(ErroreIntegrazione errore, OpenSPCoop2Message msg) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        this.erroreApplicativoBuilder.insertInSOAPFault(parameters, msg);
    }

    public void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg) throws ProtocolException {
        this.erroreApplicativoBuilder.insertRoutingErrorInSOAPFault(identitaRouter, idFunzione, msgErrore, msg);
    }

    public OpenSPCoop2Message toMessage(ErroreIntegrazione errore, Throwable eProcessamento, ParseException parseException) {
        try {
            boolean produciDettaglioEccezione = false;
            produciDettaglioEccezione = errore.getCodiceErrore().getCodice() < 500 && CodiceErroreIntegrazione.CODICE_5XX_CUSTOM.getCodice() != errore.getCodiceErrore().getCodice() ? this.protocolManager.isGenerazioneDetailsSOAPFaultIntegratione_erroreClient() : this.protocolManager.isGenerazioneDetailsSOAPFaultIntegratione_erroreServer();
            String msgErroreTrasformato = this.proprietaErroreApplicato.transformFaultMsg(errore, this.protocolFactory);
            String codErroreTrasformato = this.protocolFactory.createTraduttore().toCodiceErroreIntegrazioneAsString(errore, this.proprietaErroreApplicato.getFaultPrefixCode(), this.proprietaErroreApplicato.isFaultAsGenericCode());
            DettaglioEccezione dettaglioEccezione = null;
            if (produciDettaglioEccezione) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(this.dominio, this.tipoPdD, this.idFunzione, codErroreTrasformato, msgErroreTrasformato, false);
                if (eProcessamento != null) {
                    boolean informazioniGeneriche = this.proprietaErroreApplicato.isInformazioniGenericheDetailsOpenSPCoop();
                    this.dettaglioEccezioneOpenSPCoop2Builder.gestioneDettaglioEccezioneIntegrazione(eProcessamento, dettaglioEccezione, informazioniGeneriche);
                }
            }
            EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, dettaglioEccezione, parseException);
            OpenSPCoop2Message msg = this.erroreApplicativoBuilder.toMessage(parameters);
            return msg;
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di eccezione integrazione", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, ParseException parseException) {
        EccezioneProtocolloBuilderParameters parameters = this.getEccezioneProtocolloBuilderParameters(eccezione, soggettoProduceEccezione, null, parseException);
        try {
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di eccezione busta", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglioEccezione, ParseException parseException) {
        try {
            EccezioneProtocolloBuilderParameters parameters = this.getEccezioneProtocolloBuilderParameters(eccezione, soggettoProduceEccezione, dettaglioEccezione, parseException);
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di eccezione busta", (Throwable)e);
            return this.fac.createFaultMessage(this.soapVersion, "ErroreDiProcessamento");
        }
    }
}

