/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.IXMLDiagnosticoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.diagnostica.MsgDiagnostico;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class DiagnosticoBuilder {
    protected Logger log = null;
    private IProtocolFactory protocolFactory;
    private IXMLDiagnosticoBuilder diagnosticoProtocolBuilder;

    public DiagnosticoBuilder(IProtocolFactory protocolFactory) {
        this(Configurazione.getLibraryLog(), protocolFactory);
    }

    public DiagnosticoBuilder(Logger aLog, IProtocolFactory protocolFactory) {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(DiagnosticoBuilder.class);
        this.protocolFactory = protocolFactory;
        try {
            this.diagnosticoProtocolBuilder = this.protocolFactory.createXMLDiagnosticoBuilder();
        }
        catch (Exception e) {
            this.log.error("Errore durante la creazione dell'XMLDiagnosticoBuilder: " + e.getMessage(), (Throwable)e);
        }
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public Element toElement(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toElement(msgDiag);
    }

    public byte[] toByteArray(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toByteArray(msgDiag);
    }

    public String toString(MsgDiagnostico msgDiag) throws ProtocolException {
        return this.diagnosticoProtocolBuilder.toString(msgDiag);
    }
}

