/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Dettagli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Dettaglio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.DettaglioEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Eccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.eccezione.details.Eccezioni;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.builder.DaoBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaErroreApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.IProtocolManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroreIntegrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.MessaggiFaultErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import org.slf4j.Logger;

public class DettaglioEccezioneOpenSPCoop2Builder {
    private Logger log = null;
    private IProtocolFactory protocolFactory;
    private ITraduttore traduttore;
    private IProtocolManager protocolManager;

    public DettaglioEccezioneOpenSPCoop2Builder(Logger aLog, IProtocolFactory protocolFactory) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(DettaglioEccezioneOpenSPCoop2Builder.class);
        this.protocolFactory = protocolFactory;
        this.traduttore = this.protocolFactory.createTraduttore();
        this.protocolManager = this.protocolFactory.createProtocolManager();
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public DettaglioEccezione buildDettaglioEccezione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, String msgErrore) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.traduttore.toCodiceErroreIntegrazioneAsString(errore, null, this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche()), false, msgErrore, null, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneProcessamentoBusta(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, String msgErrore, Exception eProcessamento) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.traduttore.toCodiceErroreIntegrazioneAsString(errore, null, this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche()), false, msgErrore, eProcessamento, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneIntegrazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, ErroreIntegrazione errore, String msgErrore, Exception eProcessamento, boolean generaInformazioniGeneriche) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.traduttore.toCodiceErroreIntegrazioneAsString(errore, null, this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche()), false, msgErrore, eProcessamento, true, generaInformazioniGeneriche);
    }

    public DettaglioEccezione buildDettaglioEccezione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, CodiceErroreCooperazione codErrore, String msgErrore) throws ProtocolException {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.protocolFactory.createTraduttore().toString(codErrore), true, msgErrore, null, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneProcessamentoBusta(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, CodiceErroreCooperazione codErrore, String msgErrore, Exception eProcessamento) throws ProtocolException {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.protocolFactory.createTraduttore().toString(codErrore), true, msgErrore, eProcessamento, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneIntegrazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, CodiceErroreCooperazione codErrore, String msgErrore, Exception eProcessamento, boolean generaInformazioniGeneriche) throws ProtocolException {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, this.protocolFactory.createTraduttore().toString(codErrore), true, msgErrore, eProcessamento, true, generaInformazioniGeneriche);
    }

    public DettaglioEccezione buildDettaglioEccezione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, String codErrore, String msgErrore, boolean isErroreProtocollo) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, codErrore, isErroreProtocollo, msgErrore, null, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneProcessamentoBusta(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, String codErrore, String msgErrore, boolean isErroreProtocollo, Exception eProcessamento) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, codErrore, isErroreProtocollo, msgErrore, eProcessamento, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneIntegrazione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, String codErrore, String msgErrore, boolean isErroreProtocollo, Exception eProcessamento, boolean generaInformazioniGeneriche) {
        return this.buildDettaglioEccezione_engineBuildEccezione(identitaPdD, tipoPdD, modulo, codErrore, isErroreProtocollo, msgErrore, eProcessamento, true, generaInformazioniGeneriche);
    }

    private DettaglioEccezione buildDettaglioEccezione_engineBuildEccezione(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, String codErrore, boolean isErroreProtocollo, String msgErrore, Exception eProcessamento, boolean isIntegrazione, boolean generaInformazioniGeneriche) {
        Eccezione eccezione = new Eccezione();
        if (isErroreProtocollo) {
            eccezione.setTipo("EccezioneProtocollo");
        } else {
            eccezione.setTipo("EccezioneIntegrazione");
        }
        eccezione.setCodice(codErrore);
        eccezione.setDescrizione(msgErrore);
        return this.buildDettaglioEccezione_engine(DateManager.getDate(), identitaPdD, tipoPdD, modulo, eccezione, null, eProcessamento, isIntegrazione, generaInformazioniGeneriche);
    }

    public DettaglioEccezione buildDettaglioEccezione(Date oraRegistrazione, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Eccezione eccezione, Dettaglio dettaglio) {
        return this.buildDettaglioEccezione_engine(oraRegistrazione, identitaPdD, tipoPdD, modulo, eccezione, dettaglio, null, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneProcessamentoBusta(Date oraRegistrazione, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Eccezione eccezione, Dettaglio dettaglio, Exception eProcessamento) {
        return this.buildDettaglioEccezione_engine(oraRegistrazione, identitaPdD, tipoPdD, modulo, eccezione, dettaglio, eProcessamento, false, false);
    }

    public DettaglioEccezione buildDettaglioEccezioneIntegrazione(Date oraRegistrazione, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Eccezione eccezione, Dettaglio dettaglio, Exception eProcessamento, boolean generaInformazioniGeneriche) {
        return this.buildDettaglioEccezione_engine(oraRegistrazione, identitaPdD, tipoPdD, modulo, eccezione, dettaglio, eProcessamento, true, generaInformazioniGeneriche);
    }

    private DettaglioEccezione buildDettaglioEccezione_engine(Date oraRegistrazione, IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, Eccezione eccezione, Dettaglio dettaglio, Exception eProcessamento, boolean isIntegrazione, boolean generaInformazioniGeneriche) {
        DettaglioEccezione dettaglioEccezione = DaoBuilder.buildDettaglioEccezione(oraRegistrazione, identitaPdD, tipoPdD, modulo, eccezione, dettaglio);
        if (eProcessamento != null) {
            if (isIntegrazione) {
                this.gestioneDettaglioEccezioneIntegrazione(eProcessamento, dettaglioEccezione, generaInformazioniGeneriche);
            } else {
                this.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
            }
        }
        return dettaglioEccezione;
    }

    public DettaglioEccezione buildDettaglioEccezioneFromBusta(IDSoggetto identitaPdD, TipoPdD tipoPdD, String modulo, String servizioApplicativoErogatore, Busta busta, Throwable eProcessamento) throws ProtocolException {
        DettaglioEccezione dettaglioEccezione = new DettaglioEccezione();
        dettaglioEccezione.setOraRegistrazione(DateManager.getDate());
        dettaglioEccezione.setDominio(DaoBuilder.buildDominio(identitaPdD, tipoPdD, modulo));
        for (int i = 0; i < busta.sizeListaEccezioni(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Eccezione e = busta.getEccezione(i);
            Eccezione eccezione = new Eccezione();
            if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche()) {
                eccezione.setTipo("EccezioneProtocollo");
                eccezione.setCodice(e.getCodiceEccezioneValue(this.protocolFactory));
                eccezione.setDescrizione(this.transformFaultMsg(e.getCodiceEccezione(), e.getDescrizione(this.protocolFactory)));
                eccezione.setRilevanza(e.getRilevanzaValue(this.protocolFactory));
                eccezione.setContestoCodifica(this.protocolFactory.createTraduttore().toString(ContestoCodificaEccezione.PROCESSAMENTO));
            } else {
                eccezione.setTipo("EccezioneProtocollo");
                eccezione.setCodice(e.getCodiceEccezioneValue(this.protocolFactory));
                eccezione.setDescrizione(e.getDescrizione(this.protocolFactory));
                eccezione.setRilevanza(e.getRilevanzaValue(this.protocolFactory));
                eccezione.setContestoCodifica(this.protocolFactory.createTraduttore().toString(e.getContestoCodifica()));
            }
            if (dettaglioEccezione.getEccezioni() == null) {
                dettaglioEccezione.setEccezioni(new Eccezioni());
            }
            dettaglioEccezione.getEccezioni().addEccezione(eccezione);
        }
        if (!this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche() && servizioApplicativoErogatore != null) {
            Dettaglio detail = new Dettaglio();
            detail.setTipo("servizioApplicativo");
            detail.setBase(servizioApplicativoErogatore);
            if (dettaglioEccezione.getDettagli() == null) {
                dettaglioEccezione.setDettagli(new Dettagli());
            }
            dettaglioEccezione.getDettagli().addDettaglio(detail);
        }
        this.gestioneDettaglioEccezioneProcessamento(eProcessamento, dettaglioEccezione);
        return dettaglioEccezione;
    }

    public void gestioneDettaglioEccezioneIntegrazione(Throwable eProcessamento, DettaglioEccezione dettaglioEccezione, boolean generaInformazioniGeneriche) {
        this.gestioneDettaglioEccezioneProcessamento_engine(eProcessamento, dettaglioEccezione, this.protocolManager.isGenerazioneDetailsSOAPFaultIntegrationeConStackTrace(), generaInformazioniGeneriche);
    }

    public void gestioneDettaglioEccezioneProcessamento(Throwable eProcessamento, DettaglioEccezione dettaglioEccezione) {
        this.gestioneDettaglioEccezioneProcessamento_engine(eProcessamento, dettaglioEccezione, this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConStackTrace(), this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche());
    }

    private void gestioneDettaglioEccezioneProcessamento_engine(Throwable eProcessamento, DettaglioEccezione dettaglioEccezione, boolean generaStackTrace, boolean generaInformazioniGeneriche) {
        if (eProcessamento != null) {
            if (generaInformazioniGeneriche) {
                Dettaglio detail = new Dettaglio();
                detail.setTipo("causa");
                String msg = null;
                msg = eProcessamento.getMessage() != null ? eProcessamento.getMessage() : eProcessamento.toString();
                if ("Connection refused".equals(msg)) {
                    msg = "Connection refused";
                    detail.setBase(msg);
                    if (dettaglioEccezione.getDettagli() == null) {
                        dettaglioEccezione.setDettagli(new Dettagli());
                    }
                    dettaglioEccezione.getDettagli().addDettaglio(detail);
                } else if ("Read timed out".equals(msg)) {
                    msg = "Read timed out";
                    detail.setBase(msg);
                    if (dettaglioEccezione.getDettagli() == null) {
                        dettaglioEccezione.setDettagli(new Dettagli());
                    }
                    dettaglioEccezione.getDettagli().addDettaglio(detail);
                } else if ("connect timed out".equals(msg)) {
                    msg = "Connect timed out";
                    detail.setBase(msg);
                    if (dettaglioEccezione.getDettagli() == null) {
                        dettaglioEccezione.setDettagli(new Dettagli());
                    }
                    dettaglioEccezione.getDettagli().addDettaglio(detail);
                }
            } else {
                Dettaglio detail = new Dettaglio();
                detail.setTipo("causa");
                if (eProcessamento.getMessage() != null) {
                    detail.setBase(eProcessamento.getMessage());
                } else {
                    detail.setBase(eProcessamento.toString());
                }
                if (dettaglioEccezione.getDettagli() == null) {
                    dettaglioEccezione.setDettagli(new Dettagli());
                }
                dettaglioEccezione.getDettagli().addDettaglio(detail);
                if (eProcessamento.getCause() != null) {
                    this.gestioneDettaglioEccezioneProcessamento_engine_InnerException(eProcessamento.getCause(), dettaglioEccezione);
                }
                if (generaStackTrace) {
                    Dettaglio detailStackTrace = new Dettaglio();
                    detailStackTrace.setTipo("stackTrace");
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    PrintWriter pWriter = new PrintWriter(bout);
                    eProcessamento.printStackTrace(pWriter);
                    try {
                        bout.flush();
                        pWriter.flush();
                        pWriter.close();
                        bout.close();
                    }
                    catch (Exception eClose) {
                        System.err.println("ERRORE buildEccezioneProcessamentoFromBusta: " + eClose.getMessage());
                    }
                    detailStackTrace.setBase(bout.toString());
                    if (dettaglioEccezione.getDettagli() == null) {
                        dettaglioEccezione.setDettagli(new Dettagli());
                    }
                    dettaglioEccezione.getDettagli().addDettaglio(detailStackTrace);
                }
            }
        }
    }

    private void gestioneDettaglioEccezioneProcessamento_engine_InnerException(Throwable e, DettaglioEccezione dettaglioEccezione) {
        if (e != null) {
            Dettaglio detail = new Dettaglio();
            detail.setTipo("causato da");
            if (e.getMessage() != null) {
                detail.setBase(e.getMessage());
            } else {
                detail.setBase(e.toString());
            }
            if (dettaglioEccezione.getDettagli() == null) {
                dettaglioEccezione.setDettagli(new Dettagli());
            }
            dettaglioEccezione.getDettagli().addDettaglio(detail);
            if (e.getCause() != null) {
                this.gestioneDettaglioEccezioneProcessamento_engine_InnerException(e.getCause(), dettaglioEccezione);
            }
        }
    }

    public Eccezione buildEccezione(String codice, String descrizione, String rilevanza, String contesto, boolean isErroreProtocollo) {
        return DaoBuilder.buildEccezione(codice, descrizione, rilevanza, contesto, isErroreProtocollo);
    }

    public Dettaglio buildDettagio(String tipo, String base) {
        Dettaglio dettaglio = new Dettaglio();
        dettaglio.setTipo(tipo);
        dettaglio.setBase(base);
        return dettaglio;
    }

    public String transformFaultMsg(CodiceErroreCooperazione code, String msg) throws ProtocolException {
        if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche() && code.equals(CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO) && !"Servizio Applicativo non disponibile".equals(msg)) {
            return MessaggiFaultErroreCooperazione.FAULT_STRING_PROCESSAMENTO_SENZA_CODICE.toString(this.protocolFactory);
        }
        return msg;
    }

    public String transformFaultMsg(ErroreIntegrazione errore) throws ProtocolException {
        if (this.protocolManager.isGenerazioneDetailsSOAPFaultProtocolloConInformazioniGeneriche()) {
            ProprietaErroreApplicativo pErroreApplicativo = new ProprietaErroreApplicativo();
            pErroreApplicativo.setFaultAsGenericCode(true);
            return pErroreApplicativo.transformFaultMsg(errore, this.protocolFactory);
        }
        return errore.getDescrizione(this.protocolFactory);
    }
}

