/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBMappingUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.PddTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class UtilitiesMappingFruizioneErogazione {
    private DriverConfigurazioneDB driverConfigurazione;
    private DriverRegistroServiziDB driverRegistroServizi;
    private Logger log;

    public UtilitiesMappingFruizioneErogazione(DriverConfigurazioneDB driverConfigurazione, DriverRegistroServiziDB driverRegistroServizi, Logger log) {
        this.driverConfigurazione = driverConfigurazione;
        this.driverRegistroServizi = driverRegistroServizi;
        this.log = log;
    }

    public void initMappingFruizione() throws ProtocolException {
        this._initMapping(false);
    }

    public void initMappingErogazione() throws ProtocolException {
        this._initMapping(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initMapping(boolean erogazione) throws ProtocolException {
        try {
            ArrayList<String> tipiPdd = new ArrayList<String>();
            tipiPdd.add(PddTipologia.OPERATIVO.toString());
            tipiPdd.add(PddTipologia.NONOPERATIVO.toString());
            for (String tipoPdd : tipiPdd) {
                this.log.debug("Pdd (tipo:" + tipoPdd + ") ricerca in corso...");
                FiltroRicerca filtroPdd = new FiltroRicerca();
                filtroPdd.setTipo(tipoPdd);
                List<String> listPdD = null;
                try {
                    listPdD = this.driverRegistroServizi.getAllIdPorteDominio(filtroPdd);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (listPdD == null) {
                    listPdD = new ArrayList<String>();
                }
                this.log.debug("Pdd (tipo:" + tipoPdd + ") trovate: " + listPdD.size());
                if (listPdD.size() <= 0) continue;
                for (String nomePdd : listPdD) {
                    this.log.debug("Soggetti (pdd:" + nomePdd + ") ricerca in corso...");
                    FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                    filtroSoggetti.setNomePdd(nomePdd);
                    List<IDSoggetto> listSoggetti = null;
                    try {
                        listSoggetti = this.driverRegistroServizi.getAllIdSoggetti(filtroSoggetti);
                    }
                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                        // empty catch block
                    }
                    if (listSoggetti == null) {
                        listSoggetti = new ArrayList<IDSoggetto>();
                    }
                    this.log.debug("Soggetti (pdd:" + nomePdd + ") trovati: " + listSoggetti.size());
                    if (listSoggetti.size() <= 0) continue;
                    for (IDSoggetto idSoggetto : listSoggetti) {
                        Connection con;
                        List<IDServizio> listServizi;
                        FiltroRicercaServizi filtroServizi;
                        if (erogazione) {
                            this.log.debug("Servizi (soggetto:" + idSoggetto + ") ricerca in corso...");
                            filtroServizi = new FiltroRicercaServizi();
                            filtroServizi.setTipoSoggettoErogatore(idSoggetto.getTipo());
                            filtroServizi.setNomeSoggettoErogatore(idSoggetto.getNome());
                            listServizi = null;
                            try {
                                listServizi = this.driverRegistroServizi.getAllIdServizi(filtroServizi);
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                            if (listServizi == null) {
                                listServizi = new ArrayList<IDServizio>();
                            }
                            this.log.debug("Servizi (soggetto:" + idSoggetto + ") trovati: " + listServizi.size());
                            if (listServizi.size() <= 0) continue;
                            for (IDServizio idServizio : listServizi) {
                                IDPortaApplicativaByNome idPA;
                                con = null;
                                try {
                                    con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.existsIDPortaApplicativaAssociata");
                                    if (DBMappingUtils.existsIDPortaApplicativaAssociata(idServizio, con, this.driverRegistroServizi.getTipoDB())) {
                                        this.log.debug("PortaApplicativa (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") mapping gi\u00e0 esistente");
                                        continue;
                                    }
                                }
                                finally {
                                    try {
                                        this.driverRegistroServizi.releaseConnection(con);
                                    }
                                    catch (Throwable throwable) {}
                                    continue;
                                }
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") ricerca in corso...");
                                FiltroRicercaPorteApplicative filtroPA = new FiltroRicercaPorteApplicative();
                                filtroPA.setTipoServizio(idServizio.getTipoServizio());
                                filtroPA.setNomeServizio(idServizio.getServizio());
                                filtroPA.setTipoSoggetto(idSoggetto.getTipo());
                                filtroPA.setNomeSoggetto(idSoggetto.getNome());
                                List<IDPortaApplicativaByNome> listPA = null;
                                try {
                                    listPA = this.driverConfigurazione.getAllIdPorteApplicative(filtroPA);
                                }
                                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                    // empty catch block
                                }
                                if (listPA == null) {
                                    listPA = new ArrayList<IDPortaApplicativaByNome>();
                                }
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") trovate: " + listPA.size());
                                if (listPA.size() == 1) {
                                    idPA = listPA.get(0);
                                    this.log.debug("Creazione Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pa:" + idPA.getNome() + " in corso...");
                                    con = null;
                                    try {
                                        con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingErogazione");
                                        DBMappingUtils.createMappingErogazione(idServizio, idPA, con, this.driverRegistroServizi.getTipoDB());
                                    }
                                    finally {
                                        try {
                                            this.driverRegistroServizi.releaseConnection(con);
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    this.log.debug("Creazione Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pa:" + idPA.getNome() + " effettuata con successo");
                                    continue;
                                }
                                if (listPA.size() <= 1) continue;
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") search PA con azione * ...");
                                idPA = null;
                                for (IDPortaApplicativaByNome idPACheck : listPA) {
                                    PortaApplicativa pa = this.driverConfigurazione.getPortaApplicativa(idPACheck);
                                    if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) continue;
                                    idPA = idPACheck;
                                    break;
                                }
                                this.log.debug("PorteApplicative (soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") search PA con azione search completato (trovato:" + (idPA != null) + ")");
                                if (idPA == null) continue;
                                this.log.debug("Creazione Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pa:" + idPA.getNome() + " in corso...");
                                con = null;
                                try {
                                    con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingErogazione.sizeMoreThenOne");
                                    DBMappingUtils.createMappingErogazione(idServizio, idPA, con, this.driverRegistroServizi.getTipoDB());
                                }
                                finally {
                                    try {
                                        this.driverRegistroServizi.releaseConnection(con);
                                    }
                                    catch (Throwable throwable) {}
                                }
                                this.log.debug("Creazione Mapping Erogazione soggetto:" + idSoggetto + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pa:" + idPA.getNome() + " effettuata con successo");
                            }
                            continue;
                        }
                        this.log.debug("Servizi (fruitore:" + idSoggetto + ") ricerca in corso...");
                        filtroServizi = new FiltroRicercaServizi();
                        filtroServizi.setTipoSoggettoFruitore(idSoggetto.getTipo());
                        filtroServizi.setNomeSoggettoFruitore(idSoggetto.getNome());
                        listServizi = null;
                        try {
                            listServizi = this.driverRegistroServizi.getAllIdServizi(filtroServizi);
                        }
                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                            // empty catch block
                        }
                        if (listServizi == null) {
                            listServizi = new ArrayList<IDServizio>();
                        }
                        this.log.debug("Servizi (fruitore:" + idSoggetto + ") trovati: " + listServizi.size());
                        if (listServizi.size() <= 0) continue;
                        for (IDServizio idServizio : listServizi) {
                            IDPortaDelegata idPD;
                            con = null;
                            try {
                                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.existsIDPortaDelegataAssociata");
                                if (DBMappingUtils.existsIDPortaDelegataAssociata(idServizio, idSoggetto, con, this.driverRegistroServizi.getTipoDB())) {
                                    this.log.debug("PortaDelegata (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") mapping gi\u00e0 esistente");
                                    continue;
                                }
                            }
                            finally {
                                try {
                                    this.driverRegistroServizi.releaseConnection(con);
                                }
                                catch (Throwable filtroPA) {}
                                continue;
                            }
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") ricerca in corso...");
                            FiltroRicercaPorteDelegate filtroPD = new FiltroRicercaPorteDelegate();
                            filtroPD.setTipoSoggetto(idSoggetto.getTipo());
                            filtroPD.setNomeSoggetto(idSoggetto.getNome());
                            filtroPD.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
                            filtroPD.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                            filtroPD.setTipoServizio(idServizio.getTipoServizio());
                            filtroPD.setNomeServizio(idServizio.getServizio());
                            List<IDPortaDelegata> listPD = null;
                            try {
                                listPD = this.driverConfigurazione.getAllIdPorteDelegate(filtroPD);
                            }
                            catch (DriverConfigurazioneNotFound idPA) {
                                // empty catch block
                            }
                            if (listPD == null) {
                                listPD = new ArrayList<IDPortaDelegata>();
                            }
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") trovate: " + listPD.size());
                            if (listPD.size() == 1) {
                                idPD = listPD.get(0);
                                this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pd:" + idPD.getLocationPD() + " in corso...");
                                con = null;
                                try {
                                    con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingFruizione");
                                    DBMappingUtils.createMappingFruizione(idServizio, idSoggetto, idPD, con, this.driverRegistroServizi.getTipoDB());
                                }
                                finally {
                                    try {
                                        this.driverRegistroServizi.releaseConnection(con);
                                    }
                                    catch (Throwable throwable) {}
                                }
                                this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pd:" + idPD.getLocationPD() + " effettuata con successo");
                                continue;
                            }
                            if (listPD.size() <= 1) continue;
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") search PD con azione * ...");
                            idPD = null;
                            for (IDPortaDelegata idPDCheck : listPD) {
                                PortaDelegata pd = this.driverConfigurazione.getPortaDelegata(idPDCheck);
                                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) continue;
                                idPD = idPDCheck;
                                break;
                            }
                            this.log.debug("PorteDelegate (soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + ") search PD con azione search completato (trovato:" + (idPD != null) + ")");
                            if (idPD == null) continue;
                            this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pd:" + idPD.getLocationPD() + " in corso...");
                            con = null;
                            try {
                                con = this.driverRegistroServizi.getConnection("UtilitiesMappingFruizioneErogazione.createMappingFruizione.sizeMoreThenOne");
                                DBMappingUtils.createMappingFruizione(idServizio, idSoggetto, idPD, con, this.driverRegistroServizi.getTipoDB());
                            }
                            finally {
                                try {
                                    this.driverRegistroServizi.releaseConnection(con);
                                }
                                catch (Throwable throwable) {}
                            }
                            this.log.debug("Creazione Mapping Fruizione soggetto-fruitore:" + idSoggetto + " soggetto-erogatore:" + idServizio.getSoggettoErogatore() + " servizio:" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + " con pd:" + idPD.getLocationPD() + " effettuata con successo");
                        }
                    }
                }
            }
        }
        catch (Throwable se) {
            throw new ProtocolException(se.getMessage(), se);
        }
    }
}

