/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Credenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneCredenziali;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazionePorta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.InvocazioneServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.ReplaceMatchFieldType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.ReplaceMatchType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.constants.ReplaceKeywordType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Connettore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Property;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Servizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.utils.beans.BaseBean;
import java.util.ArrayList;

public class ImporterInformationMissingSetter {
    public static void setInformationMissingSoggetto(Archive archive, Soggetto soggetto, IDSoggetto idSoggetto, Connettore connettore) throws ProtocolException {
        switch (soggetto.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissing_RiferimentoSoggetto(archive, soggetto, idSoggetto);
                break;
            }
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissing_ConnettoreSoggetto(archive, soggetto, connettore);
            }
        }
    }

    public static void setInformationMissingServizioApplicativo(Archive archive, ServizioApplicativo sa, InvocazioneServizio invocazioneServizio, Credenziali credenziali) throws ProtocolException {
        switch (sa.getTipo()) {
            case RIFERIMENTO: {
                break;
            }
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissing_ConnettoreSA(archive, sa, invocazioneServizio, credenziali);
                break;
            }
            case CREDENZIALI_ACCESSO_PDD: {
                ImporterInformationMissingSetter.setInformationMissing_CredenzialiSA(archive, sa, credenziali);
                break;
            }
            case ALLINEA_CREDENZIALI_PD: {
                ImporterInformationMissingSetter.setInformationMissing_AllineaCredenzialiPD(archive, sa);
            }
        }
    }

    public static void setInformationMissingAccordoCooperazione(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoCooperazione ac, IDAccordoCooperazione idAccordo) throws ProtocolException {
        switch (ac.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissing_RiferimentoAccordoCooperazione(archive, ac, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (ac.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + ac.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissing_StatoAccordoCooperazione(archive, ac);
            }
        }
    }

    public static void setInformationMissingAccordoServizioParteComune(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        switch (as.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissing_RiferimentoAccordoServizioParteComune(archive, as, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (as.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + as.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissing_StatoAccordoServizioParteComune(archive, as);
            }
        }
    }

    public static void setInformationMissingAccordoServizioParteSpecifica(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteSpecifica asps, Connettore connettore) throws ProtocolException {
        switch (asps.getTipo()) {
            case CONNETTORE: {
                ImporterInformationMissingSetter.setInformationMissing_ConnettoreASPS(archive, asps, connettore);
                break;
            }
            case STATO_ARCHIVIO: {
                if (asps.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + asps.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissing_StatoAccordoServizioParteSpecifica(archive, asps);
            }
        }
    }

    public static void setInformationMissingAccordoServizioComposto(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        switch (as.getTipo()) {
            case RIFERIMENTO: {
                ImporterInformationMissingSetter.setInformationMissing_RiferimentoAccordoServizioComposto(archive, as, idAccordo);
                break;
            }
            case STATO_ARCHIVIO: {
                if (as.getStato() == null) {
                    throw new ProtocolException("Stato non fornito, \u00e8 richiesto con tipo di operazione [" + as.getTipo().name() + "]");
                }
                ImporterInformationMissingSetter.setInformationMissing_StatoAccordoServizioComposto(archive, as);
            }
        }
    }

    public static void setInformationMissingFruitore(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.Fruitore fruitore) throws ProtocolException {
        switch (fruitore.getTipo()) {
            case STATO_ARCHIVIO: {
                ImporterInformationMissingSetter.setInformationMissing_StatoFruitore(archive, fruitore);
            }
        }
    }

    private static boolean match(ReplaceMatchFieldType fieldType, String value) {
        return ReplaceKeywordType.EMPTY.equals(fieldType.getTipo()) ? value == null || "".equals(value) : (ReplaceKeywordType.EQUALS.equals(fieldType.getTipo()) ? value != null && value.equals(fieldType.getValore()) : (ReplaceKeywordType.CONTAINS.equals(fieldType.getTipo()) ? value != null && value.contains(fieldType.getValore()) : (ReplaceKeywordType.STARTS_WITH.equals(fieldType.getTipo()) ? value != null && value.startsWith(fieldType.getValore()) : (ReplaceKeywordType.ENDS_WITH.equals(fieldType.getTipo()) ? value != null && value.endsWith(fieldType.getValore()) : ReplaceKeywordType.ALL.equals(fieldType.getTipo())))));
    }

    private static boolean matchSoggetto(ReplaceMatchType replaceMatch, String tipoSoggetto, String nomeSoggetto) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        ReplaceMatchFieldType tipo = replaceMatch.getTipo();
        if (nome == null && tipo == null) {
            return false;
        }
        if (nome != null && !ImporterInformationMissingSetter.match(nome, nomeSoggetto)) {
            return false;
        }
        return tipo == null || ImporterInformationMissingSetter.match(tipo, tipoSoggetto);
    }

    private static boolean matchServizio(ReplaceMatchType replaceMatch, String tipoServizio, String nomeServizio) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        ReplaceMatchFieldType tipo = replaceMatch.getTipo();
        if (nome == null && tipo == null) {
            return false;
        }
        if (nome != null && !ImporterInformationMissingSetter.match(nome, nomeServizio)) {
            return false;
        }
        return tipo == null || ImporterInformationMissingSetter.match(tipo, tipoServizio);
    }

    private static boolean matchServizioApplicativo(ReplaceMatchType replaceMatch, String nomeServizio) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        if (nome == null) {
            return false;
        }
        return nome == null || ImporterInformationMissingSetter.match(nome, nomeServizio);
    }

    private static boolean matchAccordo(ReplaceMatchType replaceMatch, String nomeAccordo) {
        ReplaceMatchFieldType nome = replaceMatch.getNome();
        if (nome == null) {
            return false;
        }
        return nome == null || ImporterInformationMissingSetter.match(nome, nomeAccordo);
    }

    private static void setInformationMissing_RiferimentoSoggetto(Archive archive, Soggetto soggetto, IDSoggetto idSoggetto) throws ProtocolException {
        BaseBean as;
        String nomeSoggettoReferente;
        String tipoSoggettoReferente;
        IdSoggetto soggettoReferente;
        int i;
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario())) continue;
            sa.setTipoSoggettoProprietario(idSoggetto.getTipo());
            sa.setNomeSoggettoProprietario(idSoggetto.getNome());
            ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).update(sa, false);
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getPortaDelegata();
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario())) {
                pd.setTipoSoggettoProprietario(idSoggetto.getTipo());
                pd.setNomeSoggettoProprietario(idSoggetto.getNome());
                ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).update(pd, false);
            }
            if (pd.getSoggettoErogatore() == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome())) continue;
            pd.getSoggettoErogatore().setTipo(idSoggetto.getTipo());
            pd.getSoggettoErogatore().setNome(idSoggetto.getNome());
            ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).update(pd, false);
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            PortaApplicativa pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario())) {
                pa.setTipoSoggettoProprietario(idSoggetto.getTipo());
                pa.setNomeSoggettoProprietario(idSoggetto.getNome());
                ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).update(pa, false);
            }
            if (pa.getSoggettoVirtuale() == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome())) continue;
            pa.getSoggettoVirtuale().setTipo(idSoggetto.getTipo());
            pa.getSoggettoVirtuale().setNome(idSoggetto.getNome());
            ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).update(pa, false);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            AccordoCooperazione ac = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getAccordoCooperazione();
            soggettoReferente = ac.getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                ac.setSoggettoReferente(new IdSoggetto());
            }
            ac.getSoggettoReferente().setTipo(idSoggetto.getTipo());
            ac.getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).update(ac, false);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            as = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune();
            soggettoReferente = ((AccordoServizioParteComune)as).getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                ((AccordoServizioParteComune)as).setSoggettoReferente(new IdSoggetto());
            }
            ((AccordoServizioParteComune)as).getSoggettoReferente().setTipo(idSoggetto.getTipo());
            ((AccordoServizioParteComune)as).getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).update((AccordoServizioParteComune)as, false);
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            as = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            Servizio servizio = ((AccordoServizioParteSpecifica)as).getServizio();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (servizio != null) {
                tipoSoggettoReferente = servizio.getTipoSoggettoErogatore();
                nomeSoggettoReferente = servizio.getNomeSoggettoErogatore();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (servizio == null) {
                ((AccordoServizioParteSpecifica)as).setServizio(new Servizio());
            }
            ((AccordoServizioParteSpecifica)as).getServizio().setTipoSoggettoErogatore(idSoggetto.getTipo());
            ((AccordoServizioParteSpecifica)as).getServizio().setNomeSoggettoErogatore(idSoggetto.getNome());
            ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).update((AccordoServizioParteSpecifica)as, false);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
            soggettoReferente = ((AccordoServizioParteComune)as).getSoggettoReferente();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (soggettoReferente != null) {
                tipoSoggettoReferente = soggettoReferente.getTipo();
                nomeSoggettoReferente = soggettoReferente.getNome();
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            if (soggettoReferente == null) {
                ((AccordoServizioParteComune)as).setSoggettoReferente(new IdSoggetto());
            }
            ((AccordoServizioParteComune)as).getSoggettoReferente().setTipo(idSoggetto.getTipo());
            ((AccordoServizioParteComune)as).getSoggettoReferente().setNome(idSoggetto.getNome());
            ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).update((AccordoServizioParteComune)as, false);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            Fruitore fruitore = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getFruitore();
            IDAccordo idAps = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdAccordoServizioParteSpecifica();
            tipoSoggettoReferente = null;
            nomeSoggettoReferente = null;
            if (idAps.getSoggettoReferente() != null) {
                tipoSoggettoReferente = idAps.getSoggettoReferente().getTipo();
                nomeSoggettoReferente = idAps.getSoggettoReferente().getNome();
            }
            if (ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), fruitore.getTipo(), fruitore.getNome())) {
                fruitore.setTipo(idSoggetto.getTipo());
                fruitore.setNome(idSoggetto.getNome());
                ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).update(idAps, fruitore, false);
                continue;
            }
            if (!ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), tipoSoggettoReferente, nomeSoggettoReferente)) continue;
            try {
                idAps = IDAccordoFactory.getInstance().getIDAccordoFromValuesWithoutCheck(idAps.getNome(), idSoggetto.getTipo(), idSoggetto.getNome(), idAps.getVersione());
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).update(idAps, fruitore, false);
        }
    }

    private static void setInformationMissing_ConnettoreSoggetto(Archive archive, Soggetto soggetto, Connettore connettore) throws ProtocolException {
        for (int i = 0; i < archive.getSoggetti().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistro = ((ArchiveSoggetto)archive.getSoggetti().get(i)).getSoggettoRegistro();
            if (soggettoRegistro == null || !ImporterInformationMissingSetter.matchSoggetto(soggetto.getReplaceMatch(), soggettoRegistro.getTipo(), soggettoRegistro.getNome())) continue;
            if (soggettoRegistro.getConnettore() == null) {
                soggettoRegistro.setConnettore(connettore);
                continue;
            }
            soggettoRegistro.getConnettore().setCustom(connettore.getCustom());
            soggettoRegistro.getConnettore().setTipo(connettore.getTipo());
            while (soggettoRegistro.getConnettore().sizePropertyList() > 0) {
                soggettoRegistro.getConnettore().removeProperty(0);
            }
            if (connettore.sizePropertyList() <= 0) continue;
            soggettoRegistro.getConnettore().getPropertyList().addAll(connettore.getPropertyList());
        }
    }

    private static void setInformationMissing_ConnettoreSA(Archive archive, ServizioApplicativo saMissingInfo, InvocazioneServizio invocazioneServizio, Credenziali credenziali) throws ProtocolException {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (credenziali != null) {
                if (sa.getInvocazionePorta() == null) {
                    sa.setInvocazionePorta(new InvocazionePorta());
                }
                while (sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                    sa.getInvocazionePorta().removeCredenziali(0);
                }
                sa.getInvocazionePorta().addCredenziali(credenziali);
            }
            if (sa.getInvocazioneServizio() == null) {
                sa.setInvocazioneServizio(invocazioneServizio);
                continue;
            }
            sa.getInvocazioneServizio().setSbustamentoInformazioniProtocollo(invocazioneServizio.getSbustamentoInformazioniProtocollo());
            sa.getInvocazioneServizio().setSbustamentoSoap(invocazioneServizio.getSbustamentoSoap());
            sa.getInvocazioneServizio().setGetMessage(invocazioneServizio.getGetMessage());
            sa.getInvocazioneServizio().setInvioPerRiferimento(invocazioneServizio.getInvioPerRiferimento());
            sa.getInvocazioneServizio().setRispostaPerRiferimento(invocazioneServizio.getRispostaPerRiferimento());
            if (sa.getInvocazioneServizio().getCredenziali() == null) {
                sa.getInvocazioneServizio().setCredenziali(invocazioneServizio.getCredenziali());
            } else {
                sa.getInvocazioneServizio().getCredenziali().setUser(invocazioneServizio.getCredenziali().getUser());
                sa.getInvocazioneServizio().getCredenziali().setPassword(invocazioneServizio.getCredenziali().getPassword());
            }
            if (sa.getInvocazioneServizio().getConnettore() == null) {
                sa.getInvocazioneServizio().setConnettore(invocazioneServizio.getConnettore());
                continue;
            }
            sa.getInvocazioneServizio().getConnettore().setCustom(invocazioneServizio.getConnettore().getCustom());
            sa.getInvocazioneServizio().getConnettore().setTipo(invocazioneServizio.getConnettore().getTipo());
            while (sa.getInvocazioneServizio().getConnettore().sizePropertyList() > 0) {
                sa.getInvocazioneServizio().getConnettore().removeProperty(0);
            }
            if (invocazioneServizio.getConnettore().sizePropertyList() <= 0) continue;
            sa.getInvocazioneServizio().getConnettore().getPropertyList().addAll(invocazioneServizio.getConnettore().getPropertyList());
        }
    }

    private static void setInformationMissing_CredenzialiSA(Archive archive, ServizioApplicativo saMissingInfo, Credenziali credenziali) throws ProtocolException {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (sa.getInvocazionePorta() == null) {
                sa.setInvocazionePorta(new InvocazionePorta());
            }
            while (sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                sa.getInvocazionePorta().removeCredenziali(0);
            }
            sa.getInvocazionePorta().addCredenziali(credenziali);
        }
    }

    private static void setInformationMissing_AllineaCredenzialiPD(Archive archive, ServizioApplicativo saMissingInfo) throws ProtocolException {
        for (int i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            if (!ImporterInformationMissingSetter.matchServizioApplicativo(saMissingInfo.getReplaceMatch(), sa.getNome())) continue;
            if (sa.getInvocazionePorta() == null || sa.getInvocazionePorta().sizeCredenzialiList() <= 0) {
                throw new ProtocolException("Credenziali di accesso non presenti nel servizio applicativo [" + sa.getNome() + "]. Le credenziali sono richieste dalla modalit\u00e0 di gestione delle informazioni mancanti impostata");
            }
            Credenziali credenziali = sa.getInvocazionePorta().getCredenziali(0);
            if (credenziali.getTipo() == null) {
                throw new ProtocolException("Credenziali di accesso non presenti nel servizio applicativo [" + sa.getNome() + "] (tipo non definito). Le credenziali sono richieste dalla modalit\u00e0 di gestione delle informazioni mancanti impostata");
            }
            block1: for (int j = 0; j < archive.getPorteDelegate().size(); ++j) {
                PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(j)).getPortaDelegata();
                if (pd == null || pd.sizeServizioApplicativoList() <= 0) continue;
                for (int k = 0; k < pd.sizeServizioApplicativoList(); ++k) {
                    if (!sa.getNome().equals(pd.getServizioApplicativo(k).getNome())) continue;
                    pd.setAutenticazione(credenziali.getTipo().getValue());
                    continue block1;
                }
            }
        }
    }

    private static void setInformationMissing_RiferimentoAccordoCooperazione(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoCooperazione ac, IDAccordoCooperazione idAccordo) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            AccordoServizioParteComune as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
            String uriAccordoCooperazione = null;
            if (as.getServizioComposto() != null) {
                uriAccordoCooperazione = as.getServizioComposto().getAccordoCooperazione();
            }
            if (!ImporterInformationMissingSetter.matchAccordo(ac.getReplaceMatch(), uriAccordoCooperazione)) continue;
            if (as.getServizioComposto() == null) {
                as.setServizioComposto(new AccordoServizioParteComuneServizioComposto());
            }
            try {
                as.getServizioComposto().setAccordoCooperazione(IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo(idAccordo));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).update(as, false);
        }
    }

    private static void setInformationMissing_StatoAccordoCooperazione(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoCooperazione ac) throws ProtocolException {
        if (ac.getStato() != null) {
            for (int i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
                AccordoCooperazione acObject = ((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i)).getAccordoCooperazione();
                String uriAccordoCooperazione = null;
                try {
                    uriAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getUriFromAccordo(acObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(ac.getReplaceMatch(), uriAccordoCooperazione)) continue;
                acObject.setStatoPackage(ac.getStato().getValue());
            }
        }
    }

    private static void setInformationMissing_RiferimentoAccordoServizioParteComune(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            AccordoServizioParteSpecifica asObject = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            String uriAccordo = null;
            if (asObject.getAccordoServizioParteComune() != null) {
                uriAccordo = asObject.getAccordoServizioParteComune();
            }
            if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
            try {
                asObject.setAccordoServizioParteComune(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).update(asObject, false);
        }
    }

    private static void setInformationMissing_StatoAccordoServizioParteComune(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as) throws ProtocolException {
        if (as.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
                AccordoServizioParteComune asObject = ((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i)).getAccordoServizioParteComune();
                String uriAccordo = null;
                try {
                    uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
                asObject.setStatoPackage(as.getStato().getValue());
            }
        }
    }

    private static void setInformationMissing_ConnettoreASPS(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteSpecifica aspsMissingInfo, Connettore connettore) throws ProtocolException {
        for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            if (asps.getServizio() == null) continue;
            boolean matchTipoNome = ImporterInformationMissingSetter.matchServizio(aspsMissingInfo.getReplaceMatch(), asps.getServizio().getTipo(), asps.getServizio().getNome());
            String uriAccordo = null;
            try {
                uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asps);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            boolean matchAccordo = ImporterInformationMissingSetter.matchAccordo(aspsMissingInfo.getReplaceMatch(), uriAccordo);
            if (!matchTipoNome && !matchAccordo) continue;
            if (asps.getServizio().getConnettore() == null) {
                asps.getServizio().setConnettore(connettore);
                continue;
            }
            asps.getServizio().getConnettore().setCustom(connettore.getCustom());
            asps.getServizio().getConnettore().setTipo(connettore.getTipo());
            while (asps.getServizio().getConnettore().sizePropertyList() > 0) {
                asps.getServizio().getConnettore().removeProperty(0);
            }
            if (connettore.sizePropertyList() <= 0) continue;
            asps.getServizio().getConnettore().getPropertyList().addAll(connettore.getPropertyList());
        }
    }

    private static void setInformationMissing_StatoAccordoServizioParteSpecifica(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteSpecifica aspsMissingInfo) throws ProtocolException {
        if (aspsMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
                AccordoServizioParteSpecifica asps = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
                if (asps.getServizio() == null) continue;
                boolean matchTipoNome = ImporterInformationMissingSetter.matchServizio(aspsMissingInfo.getReplaceMatch(), asps.getServizio().getTipo(), asps.getServizio().getNome());
                String uriAccordo = null;
                try {
                    uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asps);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), e);
                }
                boolean matchAccordo = ImporterInformationMissingSetter.matchAccordo(aspsMissingInfo.getReplaceMatch(), uriAccordo);
                if (!matchTipoNome && !matchAccordo) continue;
                asps.setStatoPackage(aspsMissingInfo.getStato().getValue());
            }
        }
    }

    private static void setInformationMissing_RiferimentoAccordoServizioComposto(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as, IDAccordo idAccordo) throws ProtocolException {
        ImporterInformationMissingSetter.setInformationMissing_RiferimentoAccordoServizioParteComune(archive, as, idAccordo);
    }

    private static void setInformationMissing_StatoAccordoServizioComposto(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.AccordoServizioParteComune as) throws ProtocolException {
        if (as.getStato() != null) {
            for (int i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
                AccordoServizioParteComune asObject = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i)).getAccordoServizioParteComune();
                String uriAccordo = null;
                try {
                    uriAccordo = IDAccordoFactory.getInstance().getUriFromAccordo(asObject);
                }
                catch (Exception e) {
                    throw new ProtocolException(e.getMessage(), e);
                }
                if (!ImporterInformationMissingSetter.matchAccordo(as.getReplaceMatch(), uriAccordo)) continue;
                asObject.setStatoPackage(as.getStato().getValue());
            }
        }
    }

    private static void setInformationMissing_StatoFruitore(Archive archive, it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.information_missing.Fruitore fruitoreMissingInfo) throws ProtocolException {
        if (fruitoreMissingInfo.getStato() != null) {
            for (int i = 0; i < archive.getAccordiFruitori().size(); ++i) {
                Fruitore fruitore = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getFruitore();
                if (!ImporterInformationMissingSetter.matchSoggetto(fruitoreMissingInfo.getReplaceMatch(), fruitore.getTipo(), fruitore.getNome())) continue;
                fruitore.setStatoPackage(fruitoreMissingInfo.getStato().getValue());
            }
        }
    }

    private static String replaceSoggettoProprietario(String original, String tipoSoggetto, String nomeSoggetto) {
        if (original == null) {
            return null;
        }
        String returnValue = new String(original);
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_TIPO_SOGGETTO@", tipoSoggetto);
            returnValue = returnValue.replace("@OPENSPCOOP2_TIPO_SOGGETTO_PROPRIETARIO@", tipoSoggetto);
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_NOME_SOGGETTO@", nomeSoggetto);
            returnValue = returnValue.replace("@OPENSPCOOP2_NOME_SOGGETTO_PROPRIETARIO@", nomeSoggetto);
        }
        return returnValue;
    }

    private static String replaceSoggettoErogatore(String original, String tipoSoggetto, String nomeSoggetto) {
        if (original == null) {
            return null;
        }
        String returnValue = new String(original);
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_TIPO_SOGGETTO_EROGATORE@", tipoSoggetto);
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_NOME_SOGGETTO_EROGATORE@", nomeSoggetto);
        }
        return returnValue;
    }

    private static String replaceServizio(String original, String tipoServizio, String nomeServizio) {
        if (original == null) {
            return null;
        }
        String returnValue = new String(original);
        if (tipoServizio != null && !"".equals(tipoServizio)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_TIPO_SERVIZIO@", tipoServizio);
        }
        if (nomeServizio != null && !"".equals(nomeServizio)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_NOME_SERVIZIO@", nomeServizio);
        }
        return returnValue;
    }

    private static String replaceAzione(String original, String nome) {
        if (original == null) {
            return null;
        }
        String returnValue = new String(original);
        if (nome != null && !"".equals(nome)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_AZIONE@", nome);
        }
        return returnValue;
    }

    private static String replaceFruitore(String original, String tipoSoggetto, String nomeSoggetto) {
        if (original == null) {
            return null;
        }
        String returnValue = new String(original);
        if (tipoSoggetto != null && !"".equals(tipoSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_TIPO_FRUITORE@", tipoSoggetto);
        }
        if (nomeSoggetto != null && !"".equals(nomeSoggetto)) {
            returnValue = returnValue.replace("@OPENSPCOOP2_NOME_FRUITORE@", nomeSoggetto);
        }
        return returnValue;
    }

    public static void replaceTemplatesNames(Archive archive) throws ProtocolException {
        BaseBean p;
        int i;
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto = ((ArchiveSoggetto)archive.getSoggetti().get(i)).getSoggettoRegistro();
            if (soggetto == null || soggetto.getConnettore() == null || soggetto.getConnettore().sizePropertyList() <= 0) continue;
            for (int j = 0; j < soggetto.getConnettore().sizePropertyList(); ++j) {
                p = soggetto.getConnettore().getProperty(j);
                ((Property)p).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(((Property)p).getNome(), soggetto.getTipo(), soggetto.getNome()));
                ((Property)p).setValore(ImporterInformationMissingSetter.replaceSoggettoProprietario(((Property)p).getValore(), soggetto.getTipo(), soggetto.getNome()));
            }
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo sa = ((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i)).getServizioApplicativo();
            sa.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(sa.getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                for (int j = 0; j < sa.getInvocazionePorta().sizeCredenzialiList(); ++j) {
                    Credenziali c = sa.getInvocazionePorta().getCredenziali(j);
                    c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setSubject(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getSubject(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
            }
            if (sa.getInvocazioneServizio() != null) {
                if (sa.getInvocazioneServizio().getCredenziali() != null) {
                    InvocazioneCredenziali c = sa.getInvocazioneServizio().getCredenziali();
                    c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                }
                if (sa.getInvocazioneServizio().getConnettore() != null && sa.getInvocazioneServizio().getConnettore().sizePropertyList() > 0) {
                    for (int j = 0; j < sa.getInvocazioneServizio().getConnettore().sizePropertyList(); ++j) {
                        p = sa.getInvocazioneServizio().getConnettore().getProperty(j);
                        ((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        ((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).setValore(ImporterInformationMissingSetter.replaceSoggettoProprietario(((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).getValore(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    }
                }
            }
            if (sa.getRispostaAsincrona() == null) continue;
            if (sa.getRispostaAsincrona().getCredenziali() != null) {
                InvocazioneCredenziali c = sa.getRispostaAsincrona().getCredenziali();
                c.setUser(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getUser(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                c.setPassword(ImporterInformationMissingSetter.replaceSoggettoProprietario(c.getPassword(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            }
            if (sa.getRispostaAsincrona().getConnettore() == null || sa.getRispostaAsincrona().getConnettore().sizePropertyList() <= 0) continue;
            for (int j = 0; j < sa.getRispostaAsincrona().getConnettore().sizePropertyList(); ++j) {
                p = sa.getRispostaAsincrona().getConnettore().getProperty(j);
                ((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).getNome(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                ((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).setValore(ImporterInformationMissingSetter.replaceSoggettoProprietario(((it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Property)p).getValore(), sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            }
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            PortaDelegata pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(i)).getPortaDelegata();
            pd.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
            if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
            }
            if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceServizio(pd.getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
            }
            if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                pd.setNome(ImporterInformationMissingSetter.replaceAzione(pd.getNome(), pd.getAzione().getNome()));
            }
            if (pd.getDescrizione() != null && !"".equals(pd.getDescrizione())) {
                pd.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getDescrizione(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getDescrizione(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceServizio(pd.getDescrizione(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                    pd.setDescrizione(ImporterInformationMissingSetter.replaceAzione(pd.getDescrizione(), pd.getAzione().getNome()));
                }
            }
            if (pd.getLocation() != null && !"".equals(pd.getLocation())) {
                pd.setLocation(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getLocation(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.setLocation(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getLocation(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.setLocation(ImporterInformationMissingSetter.replaceServizio(pd.getLocation(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                    pd.setLocation(ImporterInformationMissingSetter.replaceAzione(pd.getLocation(), pd.getAzione().getNome()));
                }
            }
            if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getPattern() != null && !"".equals(pd.getSoggettoErogatore().getPattern())) {
                pd.getSoggettoErogatore().setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getSoggettoErogatore().getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.getSoggettoErogatore().setPattern(ImporterInformationMissingSetter.replaceServizio(pd.getSoggettoErogatore().getPattern(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                    pd.getSoggettoErogatore().setPattern(ImporterInformationMissingSetter.replaceAzione(pd.getSoggettoErogatore().getPattern(), pd.getAzione().getNome()));
                }
            }
            if (pd.getServizio() != null && pd.getServizio().getPattern() != null && !"".equals(pd.getServizio().getPattern())) {
                pd.getServizio().setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getServizio().getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.getServizio().setPattern(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getServizio().getPattern(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                    pd.getServizio().setPattern(ImporterInformationMissingSetter.replaceAzione(pd.getServizio().getPattern(), pd.getAzione().getNome()));
                }
            }
            if (pd.getAzione() != null && pd.getAzione().getPattern() != null && !"".equals(pd.getAzione().getPattern())) {
                pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getAzione().getPattern(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getAzione().getPattern(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.getAzione().setPattern(ImporterInformationMissingSetter.replaceServizio(pd.getAzione().getPattern(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
            }
            for (int j = 0; j < pd.sizeServizioApplicativoList(); ++j) {
                pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(pd.getServizioApplicativo(j).getNome(), pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario()));
                if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && !"".equals(pd.getSoggettoErogatore().getNome())) {
                    pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(pd.getServizioApplicativo(j).getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()));
                }
                if (pd.getServizio() != null && pd.getServizio().getNome() != null && !"".equals(pd.getServizio().getNome())) {
                    pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceServizio(pd.getServizioApplicativo(j).getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome()));
                }
                if (pd.getAzione() == null || pd.getAzione().getNome() == null || "".equals(pd.getAzione().getNome())) continue;
                pd.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceAzione(pd.getServizioApplicativo(j).getNome(), pd.getAzione().getNome()));
            }
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            PortaApplicativa pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(i)).getPortaApplicativa();
            if (pa.getDescrizione() != null && !"".equals(pa.getDescrizione())) {
                pa.setDescrizione(ImporterInformationMissingSetter.replaceSoggettoProprietario(pa.getDescrizione(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                    pa.setDescrizione(ImporterInformationMissingSetter.replaceServizio(pa.getDescrizione(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                }
                if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                    pa.setDescrizione(ImporterInformationMissingSetter.replaceAzione(pa.getDescrizione(), pa.getAzione().getNome()));
                }
            }
            pa.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(pa.getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
            if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                pa.setNome(ImporterInformationMissingSetter.replaceServizio(pa.getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
            }
            if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                pa.setNome(ImporterInformationMissingSetter.replaceAzione(pa.getNome(), pa.getAzione().getNome()));
            }
            for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(pa.getServizioApplicativo(j).getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                if (pa.getServizio() != null && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                    pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceServizio(pa.getServizioApplicativo(j).getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome()));
                }
                if (pa.getAzione() == null || pa.getAzione().getNome() == null || "".equals(pa.getAzione().getNome())) continue;
                pa.getServizioApplicativo(j).setNome(ImporterInformationMissingSetter.replaceAzione(pa.getServizioApplicativo(j).getNome(), pa.getAzione().getNome()));
            }
        }
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            int j;
            AccordoServizioParteSpecifica as = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i)).getAccordoServizioParteSpecifica();
            if (as.getServizio() != null && as.getServizio().getConnettore() != null) {
                for (int j2 = 0; j2 < as.getServizio().getConnettore().sizePropertyList(); ++j2) {
                    p = as.getServizio().getConnettore().getProperty(j2);
                    ((Property)p).setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(((Property)p).getNome(), as.getServizio().getTipoSoggettoErogatore(), as.getServizio().getNomeSoggettoErogatore()));
                    ((Property)p).setValore(ImporterInformationMissingSetter.replaceSoggettoProprietario(((Property)p).getValore(), as.getServizio().getTipoSoggettoErogatore(), as.getServizio().getNomeSoggettoErogatore()));
                }
            }
            if (as.getServizio() != null && as.getServizio().getConnettore() != null) {
                for (int j3 = 0; j3 < as.getServizio().getConnettore().sizePropertyList(); ++j3) {
                    p = as.getServizio().getConnettore().getProperty(j3);
                    ((Property)p).setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(((Property)p).getNome(), as.getServizio().getTipoSoggettoErogatore(), as.getServizio().getNomeSoggettoErogatore()));
                    ((Property)p).setValore(ImporterInformationMissingSetter.replaceSoggettoErogatore(((Property)p).getValore(), as.getServizio().getTipoSoggettoErogatore(), as.getServizio().getNomeSoggettoErogatore()));
                }
            }
            if (as.sizeFruitoreList() == 1) {
                if (as.getServizio() == null || as.getServizio().getConnettore() == null) continue;
                for (int j4 = 0; j4 < as.getServizio().getConnettore().sizePropertyList(); ++j4) {
                    p = as.getServizio().getConnettore().getProperty(j4);
                    ((Property)p).setNome(ImporterInformationMissingSetter.replaceFruitore(((Property)p).getNome(), as.getFruitore(0).getTipo(), as.getFruitore(0).getNome()));
                    ((Property)p).setValore(ImporterInformationMissingSetter.replaceFruitore(((Property)p).getValore(), as.getFruitore(0).getTipo(), as.getFruitore(0).getNome()));
                }
                continue;
            }
            if (as.sizeFruitoreList() != 0) continue;
            IDAccordo idAccordoAttuale = null;
            try {
                idAccordoAttuale = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            ArrayList<Fruitore> listFruitori = new ArrayList<Fruitore>();
            for (j = 0; j < archive.getAccordiFruitori().size(); ++j) {
                Fruitore fr = ((ArchiveFruitore)archive.getAccordiFruitori().get(j)).getFruitore();
                IDAccordo idAccordo = ((ArchiveFruitore)archive.getAccordiFruitori().get(j)).getIdAccordoServizioParteSpecifica();
                if (!idAccordo.equals(idAccordoAttuale)) continue;
                listFruitori.add(fr);
            }
            if (listFruitori.size() != 1 || as.getServizio() == null || as.getServizio().getConnettore() == null) continue;
            for (j = 0; j < as.getServizio().getConnettore().sizePropertyList(); ++j) {
                Property p2 = as.getServizio().getConnettore().getProperty(j);
                p2.setNome(ImporterInformationMissingSetter.replaceFruitore(p2.getNome(), ((Fruitore)listFruitori.get(0)).getTipo(), ((Fruitore)listFruitori.get(0)).getNome()));
                p2.setValore(ImporterInformationMissingSetter.replaceFruitore(p2.getValore(), ((Fruitore)listFruitori.get(0)).getTipo(), ((Fruitore)listFruitori.get(0)).getNome()));
            }
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            Property p3;
            int j;
            Fruitore fr = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getFruitore();
            IDAccordo idAccordo = ((ArchiveFruitore)archive.getAccordiFruitori().get(i)).getIdAccordoServizioParteSpecifica();
            String tipoSoggettoErogatore = null;
            String nomeSoggettoErogatore = null;
            if (idAccordo != null && idAccordo.getSoggettoReferente() != null) {
                tipoSoggettoErogatore = idAccordo.getSoggettoReferente().getTipo();
                nomeSoggettoErogatore = idAccordo.getSoggettoReferente().getNome();
            }
            if (fr.getConnettore() == null) continue;
            for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                p3 = fr.getConnettore().getProperty(j);
                p3.setNome(ImporterInformationMissingSetter.replaceFruitore(p3.getNome(), fr.getTipo(), fr.getNome()));
                p3.setValore(ImporterInformationMissingSetter.replaceFruitore(p3.getValore(), fr.getTipo(), fr.getNome()));
            }
            for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                p3 = fr.getConnettore().getProperty(j);
                p3.setNome(ImporterInformationMissingSetter.replaceSoggettoProprietario(p3.getNome(), fr.getTipo(), fr.getNome()));
                p3.setValore(ImporterInformationMissingSetter.replaceSoggettoProprietario(p3.getValore(), fr.getTipo(), fr.getNome()));
            }
            if (tipoSoggettoErogatore == null || nomeSoggettoErogatore == null) continue;
            for (j = 0; j < fr.getConnettore().sizePropertyList(); ++j) {
                p3 = fr.getConnettore().getProperty(j);
                p3.setNome(ImporterInformationMissingSetter.replaceSoggettoErogatore(p3.getNome(), tipoSoggettoErogatore, nomeSoggettoErogatore));
                p3.setValore(ImporterInformationMissingSetter.replaceSoggettoErogatore(p3.getValore(), tipoSoggettoErogatore, nomeSoggettoErogatore));
            }
        }
    }
}

