/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ArchiveEngine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ArchiveRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ArchiveValidator;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImportInformationMissingCollection;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImporterArchiveUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ConfigurazionePdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImport;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveModeType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import it.link.pdd.tools.migrazione_govway.utils.LoggerWrapperFactory;
import it.link.pdd.tools.migrazione_govway.utils.resources.FileSystemUtilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.Loader;
import org.slf4j.Logger;

public class Importer {
    public static void main(String[] args) throws Exception {
        Logger log = LoggerWrapperFactory.getLogger(Importer.class);
        String archiveFile = args[0];
        byte[] archiveBytes = FileSystemUtilities.readBytesFromFile(archiveFile);
        String protocollo = args[1];
        String mode = args[2];
        ArchiveMode archiveMode = new ArchiveMode(mode);
        String type = args[3];
        ArchiveModeType archiveModeType = new ArchiveModeType(type);
        boolean validateDocuments = Boolean.parseBoolean(args[4]);
        String userLogin = args[5];
        String nomePddOperativa = args[6];
        String tipoPddDefault = args[7];
        boolean updateAbilitato = Boolean.parseBoolean(args[8]);
        boolean isShowCorrelazioneAsincronaInAccordi = true;
        boolean isShowGestioneWorkflowStatoDocumenti = true;
        boolean isShowAccordiColonnaAzioni = true;
        boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto = false;
        boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto = false;
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setLoader(new Loader());
        configPdD.setLog(log);
        ProtocolFactoryManager.initializeSingleProtocol(log, configPdD, protocollo);
        DriverRegistroServiziDB driverRegistroServizi = null;
        DriverConfigurazioneDB driverConfigurazione = null;
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(driverRegistroServizi, driverConfigurazione);
        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        IArchive archiveEngine = pf.createArchive();
        Archive archive = archiveEngine.importArchive(archiveBytes, archiveMode, archiveModeType, (IRegistryReader)archiveRegistryReader, validateDocuments, null);
        ArchiveValidator validator = new ArchiveValidator(archiveRegistryReader);
        ImportInformationMissingCollection importInformationMissingCollection = new ImportInformationMissingCollection();
        validator.validateArchive(archive, protocollo, validateDocuments, importInformationMissingCollection, userLogin, isShowCorrelazioneAsincronaInAccordi, false);
        ArchiveEngine importerEngine = new ArchiveEngine(driverRegistroServizi, driverConfigurazione);
        ImporterArchiveUtils importerArchiveUtils = new ImporterArchiveUtils(importerEngine, log, userLogin, nomePddOperativa, tipoPddDefault, isShowGestioneWorkflowStatoDocumenti, updateAbilitato);
        ArchiveEsitoImport result = importerArchiveUtils.importArchive(archive, userLogin, isShowAccordiColonnaAzioni, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto);
        String resultAsString = archiveEngine.toString(result, archiveMode);
        log.info(resultAsString);
    }
}

