/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaServiziApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazioneWithSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.AbstractArchiveEngine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ArchiveRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveCascadeConfiguration;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveIdCorrelazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveMode;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IArchive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ArchiveType;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.IdSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.RuoloSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoCooperazioneFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ExporterArchiveUtils {
    private AbstractArchiveEngine archiveEngine;
    private Logger log;
    private ProtocolFactoryManager protocolFactoryManager;
    private ArchiveIdCorrelazione idCorrelazione = null;

    public ExporterArchiveUtils(AbstractArchiveEngine archiveEngine, Logger log) throws Exception {
        this.archiveEngine = archiveEngine;
        this.log = log;
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        this.idCorrelazione = new ArchiveIdCorrelazione("export");
    }

    public void export(String protocol, Archive archive, OutputStream out, ArchiveMode mode) throws Exception {
        IProtocolFactory protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(this.archiveEngine.getDriverRegistroServizi(), this.archiveEngine.getDriverConfigurazione());
        archiveEngine.exportArchive(archive, out, mode, archiveRegistryReader);
    }

    public byte[] export(String protocol, Archive archive, ArchiveMode mode) throws Exception {
        IProtocolFactory protocolFactory = this.protocolFactoryManager.getProtocolFactoryByName(protocol);
        IArchive archiveEngine = protocolFactory.createArchive();
        ArchiveRegistryReader archiveRegistryReader = new ArchiveRegistryReader(this.archiveEngine.getDriverRegistroServizi(), this.archiveEngine.getDriverConfigurazione());
        return archiveEngine.exportArchive(archive, mode, archiveRegistryReader);
    }

    public void fillArchive(Archive archive, ArchiveType exportSourceArchiveType, List<?> listObject, ArchiveCascadeConfiguration cascadeConfig) throws Exception {
        switch (exportSourceArchiveType) {
            case PDD: {
                for (Object object : listObject) {
                    this.readPdd(archive, (String)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case RUOLO: {
                for (Object object : listObject) {
                    this.readRuolo(archive, (IDRuolo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SOGGETTO: {
                for (Object object : listObject) {
                    this.readSoggetto(archive, (IDSoggetto)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case SERVIZIO_APPLICATIVO: {
                for (Object object : listObject) {
                    this.readServizioApplicativo(archive, (IDServizioApplicativo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_DELEGATA: {
                for (Object object : listObject) {
                    this.readPortaDelegata(archive, (IDPortaDelegata)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case PORTA_APPLICATIVA: {
                for (Object object : listObject) {
                    this.readPortaApplicativa(archive, (IDPortaApplicativaByNome)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_COOPERAZIONE: {
                for (Object object : listObject) {
                    this.readAccordoCooperazione(archive, (IDAccordoCooperazioneWithSoggetto)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteComune(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_COMPOSTO: {
                for (Object object : listObject) {
                    this.readAccordoServizioComposto(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                for (Object object : listObject) {
                    this.readAccordoServizioParteSpecifica(archive, (IDAccordo)object, cascadeConfig, exportSourceArchiveType);
                }
                break;
            }
            case CONFIGURAZIONE: {
                archive.setConfigurazionePdD(this.archiveEngine.getConfigurazione());
                break;
            }
            case ALL: 
            case ALL_WITHOUT_CONFIGURAZIONE: {
                FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                try {
                    ArchiveCascadeConfiguration cascadeAll = new ArchiveCascadeConfiguration(true);
                    List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                    if (idsSoggetti != null && idsSoggetti.size() > 0) {
                        for (IDSoggetto idSoggetto : idsSoggetti) {
                            this.readSoggetto(archive, idSoggetto, cascadeAll, exportSourceArchiveType);
                        }
                    }
                }
                catch (DriverConfigurazioneNotFound cascadeAll) {
                    // empty catch block
                }
                if (exportSourceArchiveType.equals((Object)ArchiveType.ALL)) {
                    archive.setConfigurazionePdD(this.archiveEngine.getConfigurazione());
                }
                FiltroRicerca filtroRicercaPdd = new FiltroRicerca();
                List<String> idPdds = null;
                try {
                    idPdds = this.archiveEngine.getAllIdPorteDominio(filtroRicercaPdd);
                    for (String idPdd : idPdds) {
                        boolean found = false;
                        if (archive.getPdd() != null && archive.getPdd().size() > 0) {
                            for (String idArchivePdd : archive.getPdd().keys()) {
                                ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(idArchivePdd);
                                if (!archivePdd.getNomePdd().equals(idPdd)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        this.readPdd(archive, idPdd, cascadeConfig, false, ArchiveType.PDD);
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                FiltroRicercaRuoli filtroRicercaRuoli = new FiltroRicercaRuoli();
                List<IDRuolo> idRuoli = null;
                try {
                    idRuoli = this.archiveEngine.getAllIdRuoli(filtroRicercaRuoli);
                    for (IDRuolo idRuolo : idRuoli) {
                        boolean found = false;
                        if (archive.getRuoli() != null && archive.getRuoli().size() > 0) {
                            for (String idArchiveRuolo : archive.getRuoli().keys()) {
                                ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(idArchiveRuolo);
                                if (!archiveRuolo.getIdRuolo().equals(idRuolo)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.RUOLO);
                    }
                    break;
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    break;
                }
            }
        }
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPdd(archive, nomePdd, cascadeConfig, true, provenienza);
    }

    private void readPdd(Archive archive, String nomePdd, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePdd.buildKey(nomePdd);
        if (!archive.getPdd().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadePdd() || ArchiveType.PDD.equals((Object)provenienza)) {
                    PortaDominio pdd = this.archiveEngine.getPortaDominio(nomePdd);
                    ArchivePdd archivePdd = new ArchivePdd(pdd, this.idCorrelazione);
                    archive.getPdd().add(archivePdd);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PdD " + nomePdd + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            filtroSoggetti.setNomePdd(nomePdd);
            try {
                List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                if (idsSoggetti != null && idsSoggetti.size() > 0) {
                    for (IDSoggetto idSoggetto : idsSoggetti) {
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, ArchiveType.PDD);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readRuolo(Archive archive, IDRuolo idRuolo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readRuolo(archive, idRuolo, cascadeConfig, true, provenienza);
    }

    private void readRuolo(Archive archive, IDRuolo idRuolo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveRuolo.buildKey(idRuolo.getNome());
        if (!archive.getRuoli().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeRuoli() || ArchiveType.RUOLO.equals((Object)provenienza)) {
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo ruolo = this.archiveEngine.getRuolo(idRuolo);
                    ArchiveRuolo archiveRuolo = new ArchiveRuolo(ruolo, this.idCorrelazione);
                    archive.getRuoli().add(archiveRuolo);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Ruolo " + idRuolo.getNome() + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
            filtroSoggetti.setIdRuolo(idRuolo);
            try {
                List<IDSoggetto> idsSoggetti = this.archiveEngine.getAllIdSoggettiRegistro(filtroSoggetti);
                if (idsSoggetti != null && idsSoggetti.size() > 0) {
                    for (IDSoggetto iDSoggetto : idsSoggetti) {
                        this.readSoggetto(archive, iDSoggetto, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsSoggetti) {
                // empty catch block
            }
            FiltroRicercaPorteDelegate filtroPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroPorteDelegate.setIdRuolo(idRuolo);
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata iDPortaDelegata : idsPD) {
                        this.readPortaDelegata(archive, iDPortaDelegata, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsPD) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroPorteApplicative.setIdRuolo(idRuolo);
            try {
                List<IDPortaApplicativaByNome> list = this.archiveEngine.getAllIdPorteApplicative(filtroPorteApplicative);
                if (list != null && list.size() > 0) {
                    for (IDPortaApplicativaByNome idPA : list) {
                        this.readPortaApplicativa(archive, idPA, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            FiltroRicercaServiziApplicativi filtroRicercaServiziApplicativi = new FiltroRicercaServiziApplicativi();
            filtroRicercaServiziApplicativi.setIdRuolo(idRuolo);
            try {
                List<IDServizioApplicativo> list = this.archiveEngine.getAllIdServiziApplicativi(filtroRicercaServiziApplicativi);
                if (list != null && list.size() > 0) {
                    for (IDServizioApplicativo idSA : list) {
                        this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.RUOLO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readSoggetto(archive, idSoggetto, cascadeConfig, true, provenienza);
    }

    private void readSoggetto(Archive archive, IDSoggetto idSoggetto, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        block41: {
            String key = ArchiveSoggetto.buildKey(idSoggetto.getTipo(), idSoggetto.getNome());
            if (!archive.getSoggetti().containsKey(key)) {
                try {
                    if (!cascadeConfig.isCascadeSoggetti() && !ArchiveType.SOGGETTO.equals((Object)provenienza)) break block41;
                    it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggettoRegistro = this.archiveEngine.getSoggettoRegistro(idSoggetto);
                    Soggetto soggettoConfigurazione = this.archiveEngine.getSoggettoConfigurazione(idSoggetto);
                    ArchiveSoggetto archiveSoggetto = new ArchiveSoggetto(soggettoConfigurazione, soggettoRegistro, this.idCorrelazione);
                    archive.getSoggetti().add(archiveSoggetto);
                    FiltroRicerca filtroRicerca = new FiltroRicerca();
                    filtroRicerca.setNome(soggettoRegistro.getPortaDominio());
                    try {
                        List<String> idsPdD = this.archiveEngine.getAllIdPorteDominio(filtroRicerca);
                        if (idsPdD != null && idsPdD.size() > 0) {
                            for (String string : idsPdD) {
                                this.readPdd(archive, string, cascadeConfig, false, ArchiveType.SOGGETTO);
                            }
                        }
                    }
                    catch (DriverRegistroServiziNotFound idsPdD) {
                        // empty catch block
                    }
                    if (soggettoRegistro.getRuoli() != null && soggettoRegistro.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < soggettoRegistro.getRuoli().sizeRuoloList(); ++i) {
                            RuoloSoggetto ruoloSoggetto = soggettoRegistro.getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRicercaRuoli = new FiltroRicercaRuoli();
                            filtroRicercaRuoli.setNome(ruoloSoggetto.getNome());
                            try {
                                List<IDRuolo> list = this.archiveEngine.getAllIdRuoli(filtroRicercaRuoli);
                                if (list == null || list.size() <= 0) continue;
                                for (IDRuolo idRuolo : list) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.SOGGETTO);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new ProtocolException("(Soggetto " + idSoggetto + ") " + e.getMessage(), e);
                }
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServiziApplicativi filtroServiziApplicativi = new FiltroRicercaServiziApplicativi();
            filtroServiziApplicativi.setTipoSoggetto(idSoggetto.getTipo());
            filtroServiziApplicativi.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDServizioApplicativo> idsSA = this.archiveEngine.getAllIdServiziApplicativi(filtroServiziApplicativi);
                if (idsSA != null && idsSA.size() > 0) {
                    for (IDServizioApplicativo iDServizioApplicativo : idsSA) {
                        this.readServizioApplicativo(archive, iDServizioApplicativo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsSA) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiCooperazione = new FiltroRicercaAccordi();
            filtroAccordiCooperazione.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiCooperazione.setNomeSoggettoReferente(idSoggetto.getNome());
            try {
                List<IDAccordoCooperazione> idsAC = this.archiveEngine.getAllIdAccordiCooperazione(filtroAccordiCooperazione);
                if (idsAC != null && idsAC.size() > 0) {
                    for (IDAccordoCooperazione idAccordoCooperazione : idsAC) {
                        IDAccordoCooperazioneWithSoggetto iDAccordoCooperazioneWithSoggetto = new IDAccordoCooperazioneWithSoggetto(idAccordoCooperazione);
                        iDAccordoCooperazioneWithSoggetto.setSoggettoReferente(idSoggetto);
                        this.readAccordoCooperazione(archive, iDAccordoCooperazioneWithSoggetto, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAC) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroAccordiServizioParteComune = new FiltroRicercaAccordi();
            filtroAccordiServizioParteComune.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroAccordiServizioParteComune.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroAccordiServizioParteComune.setServizioComposto(false);
            try {
                List<IDAccordo> list = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroAccordiServizioParteComune);
                if (list != null && list.size() > 0) {
                    for (IDAccordo iDAccordo : list) {
                        this.readAccordoServizioParteComune(archive, iDAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroRicercaAccordi.setNomeSoggettoReferente(idSoggetto.getNome());
            filtroRicercaAccordi.setServizioComposto(true);
            try {
                List<IDAccordo> idsAccordi = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroRicercaAccordi);
                if (idsAccordi != null && idsAccordi.size() > 0) {
                    for (IDAccordo iDAccordo : idsAccordi) {
                        this.readAccordoServizioComposto(archive, iDAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound idsAccordi) {
                // empty catch block
            }
            FiltroRicercaServizi filtroAccordiServizioParteSpecifica = new FiltroRicercaServizi();
            filtroAccordiServizioParteSpecifica.setTipoSoggettoErogatore(idSoggetto.getTipo());
            filtroAccordiServizioParteSpecifica.setNomeSoggettoErogatore(idSoggetto.getNome());
            try {
                List<IDAccordo> list = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroAccordiServizioParteSpecifica);
                if (list != null && list.size() > 0) {
                    for (IDAccordo iDAccordo : list) {
                        this.readAccordoServizioParteSpecifica(archive, iDAccordo, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            FiltroRicercaPorteDelegate filtroRicercaPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroRicercaPorteDelegate.setTipoSoggetto(idSoggetto.getTipo());
            filtroRicercaPorteDelegate.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaDelegata> list = this.archiveEngine.getAllIdPorteDelegate(filtroRicercaPorteDelegate);
                if (list != null && list.size() > 0) {
                    for (IDPortaDelegata idPortaDelegata : list) {
                        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            FiltroRicercaPorteApplicative filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggetto(idSoggetto.getTipo());
            filtroRicercaPorteApplicative.setNomeSoggetto(idSoggetto.getNome());
            try {
                List<IDPortaApplicativaByNome> list = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (list != null && list.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : list) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.SOGGETTO);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readServizioApplicativo(archive, idServizioApplicativo, cascadeConfig, true, provenienza);
    }

    private void readServizioApplicativo(Archive archive, IDServizioApplicativo idServizioApplicativo, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchiveServizioApplicativo.buildKey(idServizioApplicativo.getIdSoggettoProprietario().getTipo(), idServizioApplicativo.getIdSoggettoProprietario().getNome(), idServizioApplicativo.getNome());
        if (!archive.getServiziApplicativi().containsKey(key)) {
            try {
                boolean enabled = cascadeConfig.isCascadeServiziApplicativi();
                switch (provenienza) {
                    case SOGGETTO: {
                        break;
                    }
                    case SERVIZIO_APPLICATIVO: {
                        enabled = enabled || ArchiveType.SERVIZIO_APPLICATIVO.equals((Object)provenienza);
                        break;
                    }
                    case PORTA_DELEGATA: {
                        enabled = enabled && cascadeConfig.isCascadePorteDelegate();
                        break;
                    }
                    case PORTA_APPLICATIVA: {
                        enabled = enabled && cascadeConfig.isCascadePorteApplicative();
                        break;
                    }
                    case FRUITORE: {
                        enabled = enabled && cascadeConfig.isCascadeFruizioni();
                        break;
                    }
                }
                if (enabled) {
                    ServizioApplicativo sa = this.archiveEngine.getServizioApplicativo(idServizioApplicativo);
                    if (sa.getTipoSoggettoProprietario() == null) {
                        sa.setTipoSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                    }
                    if (sa.getNomeSoggettoProprietario() == null) {
                        sa.setNomeSoggettoProprietario(idServizioApplicativo.getIdSoggettoProprietario().getNome());
                    }
                    ArchiveServizioApplicativo archiveSa = new ArchiveServizioApplicativo(sa, this.idCorrelazione);
                    archive.getServiziApplicativi().add(archiveSa);
                    this.readSoggetto(archive, idServizioApplicativo.getIdSoggettoProprietario(), cascadeConfig, false, ArchiveType.SERVIZIO_APPLICATIVO);
                    if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().getRuoli() != null && sa.getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < sa.getInvocazionePorta().getRuoli().sizeRuoloList(); ++i) {
                            Ruolo ruolo = sa.getInvocazionePorta().getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                List<IDRuolo> idsRuoli = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli == null || idsRuoli.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.SERVIZIO_APPLICATIVO);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(ServizioApplicativo " + idServizioApplicativo + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            // empty if block
        }
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazioneWithSoggetto idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoCooperazione(archive, idAccordoCooperazione, cascadeConfig, true, provenienza);
    }

    private void readAccordoCooperazione(Archive archive, IDAccordoCooperazioneWithSoggetto idAccordoCooperazione, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoCooperazione.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoCooperazione.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoCooperazione.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoCooperazione.buildKey(tipoSoggetto, nomeSoggetto, idAccordoCooperazione.getNome(), idAccordoCooperazione.getVersione());
        if (!archive.getAccordiCooperazione().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoCooperazione() || ArchiveType.ACCORDO_COOPERAZIONE.equals((Object)provenienza)) {
                    AccordoCooperazione ac = this.archiveEngine.getAccordoCooperazione(idAccordoCooperazione, true);
                    ArchiveAccordoCooperazione archiveAc = new ArchiveAccordoCooperazione(ac, this.idCorrelazione);
                    archive.getAccordiCooperazione().add(archiveAc);
                    this.readSoggetto(archive, idAccordoCooperazione.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                    if (ac.getElencoPartecipanti() != null && ac.getElencoPartecipanti().sizeSoggettoPartecipanteList() > 0) {
                        for (IdSoggetto partecipante : ac.getElencoPartecipanti().getSoggettoPartecipanteList()) {
                            IDSoggetto idPartecipante = new IDSoggetto(partecipante.getTipo(), partecipante.getNome());
                            this.readSoggetto(archive, idPartecipante, cascadeConfig, false, ArchiveType.ACCORDO_COOPERAZIONE);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoCooperazione " + IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo(idAccordoCooperazione) + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
            filtroRicercaAccordi.setIdAccordoCooperazione(idAccordoCooperazione);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteComune(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioComposto(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_COOPERAZIONE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteComune(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteComune(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioParteComune.buildKey(tipoSoggetto, nomeSoggetto, idAccordoServizio.getNome(), idAccordoServizio.getVersione());
        if (!archive.getAccordiServizioParteComune().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeAccordoServizioParteComune() || ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)provenienza)) {
                    AccordoServizioParteComune as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true);
                    ArchiveAccordoServizioParteComune archiveAs = new ArchiveAccordoServizioParteComune(as, this.idCorrelazione);
                    archive.getAccordiServizioParteComune().add(archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioParteComune " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordo(idAccordoServizio);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioComposto(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioComposto(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioComposto.buildKey(tipoSoggetto, nomeSoggetto, idAccordoServizio.getNome(), idAccordoServizio.getVersione());
        AccordoServizioParteComune as = null;
        if (archive.getAccordiServizioComposto().containsKey(key)) {
            as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(key)).getAccordoServizioParteComune();
        } else {
            try {
                if (cascadeConfig.isCascadeAccordoServizioComposto() || ArchiveType.ACCORDO_SERVIZIO_COMPOSTO.equals((Object)provenienza)) {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, true);
                    ArchiveAccordoServizioComposto archiveAs = new ArchiveAccordoServizioComposto(as, this.idCorrelazione);
                    archive.getAccordiServizioComposto().add(archiveAs);
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                } else {
                    as = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizio, false);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioComposto " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            FiltroRicercaServizi filtroRicercaAccordi = new FiltroRicercaServizi();
            filtroRicercaAccordi.setIdAccordo(idAccordoServizio);
            try {
                List<IDAccordo> idsAS = this.archiveEngine.getAllIdAccordiServizioParteSpecifica(filtroRicercaAccordi);
                if (idsAS != null && idsAS.size() > 0) {
                    for (IDAccordo idAccordo : idsAS) {
                        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            for (AccordoServizioParteComuneServizioCompostoServizioComponente servizioComponente : as.getServizioComposto().getServizioComponenteList()) {
                IDServizio idServizio = new IDServizio(servizioComponente.getTipoSoggetto(), servizioComponente.getNomeSoggetto(), servizioComponente.getTipo(), servizioComponente.getNome());
                this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_COMPOSTO);
            }
        }
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDAccordo idAccordoServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveAccordoServizioParteSpecifica.buildKey(tipoSoggetto, nomeSoggetto, idAccordoServizio.getNome(), idAccordoServizio.getVersione());
        ArrayList<Fruitore> fruitoriList = null;
        AccordoServizioParteSpecifica as = null;
        if (archive.getAccordiServizioParteSpecifica().containsKey(key)) {
            as = ((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(key)).getAccordoServizioParteSpecifica();
        } else {
            try {
                if (cascadeConfig.isCascadeAccordoServizioParteSpecifica() || ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA.equals((Object)provenienza)) {
                    fruitoriList = new ArrayList<Fruitore>();
                    as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                    if (as.getServizio().getTipoSoggettoErogatore() == null) {
                        as.getServizio().setTipoSoggettoErogatore(tipoSoggetto);
                    }
                    if (as.getServizio().getNomeSoggettoErogatore() == null) {
                        as.getServizio().setNomeSoggettoErogatore(nomeSoggetto);
                    }
                    ArchiveAccordoServizioParteSpecifica archiveAs = new ArchiveAccordoServizioParteSpecifica(as, this.idCorrelazione);
                    while (as.sizeFruitoreList() > 0) {
                        fruitoriList.add(as.removeFruitore(0));
                    }
                    archive.getAccordiServizioParteSpecifica().add(archiveAs);
                    IDPortaApplicativaByNome idPA = this.archiveEngine.getIDPortaApplicativaAssociataErogazione(idAccordoServizio);
                    if (idPA != null) {
                        archiveAs.setIdPortaApplicativaAssociata(idPA);
                    }
                    this.readSoggetto(archive, idAccordoServizio.getSoggettoReferente(), cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    IDAccordo idAccordoServizioParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(as.getAccordoServizioParteComune());
                    AccordoServizioParteComune aspc = this.archiveEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                    if (aspc.getServizioComposto() == null) {
                        this.readAccordoServizioParteComune(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    } else {
                        this.readAccordoServizioComposto(archive, idAccordoServizioParteComune, cascadeConfig, false, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(AccordoServizioParteSpecifica " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti) {
            List<IDPortaApplicativaByNome> idsPA2;
            IDPortaApplicativaByNome idPA_associata;
            if (fruitoriList == null) {
                fruitoriList = new ArrayList();
                as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                while (as.sizeFruitoreList() > 0) {
                    fruitoriList.add(as.removeFruitore(0));
                }
            }
            for (Fruitore fruitore : fruitoriList) {
                IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            }
            FiltroRicercaPorteDelegate filtroRicercaPorteDelegate = new FiltroRicercaPorteDelegate();
            filtroRicercaPorteDelegate.setTipoSoggettoErogatore(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteDelegate.setNomeSoggettoErogatore(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteDelegate.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteDelegate.setNomeServizio(as.getServizio().getNome());
            try {
                List<IDPortaDelegata> idsPD = this.archiveEngine.getAllIdPorteDelegate(filtroRicercaPorteDelegate);
                if (idsPD != null && idsPD.size() > 0) {
                    for (IDPortaDelegata idPortaDelegata : idsPD) {
                        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsPD) {
                // empty catch block
            }
            if ((idPA_associata = this.archiveEngine.getIDPortaApplicativaAssociataErogazione(idAccordoServizio)) != null) {
                this.readPortaApplicativa(archive, idPA_associata, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
            }
            FiltroRicercaPorteApplicative filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggetto(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggetto(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getServizio().getNome());
            try {
                idsPA2 = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (idsPA2 != null && idsPA2.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : idsPA2) {
                        if (idPA_associata != null && idPA_associata.equals(idPortaApplicativa)) continue;
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound idsPA2) {
                // empty catch block
            }
            filtroRicercaPorteApplicative = new FiltroRicercaPorteApplicative();
            filtroRicercaPorteApplicative.setTipoSoggettoVirtuale(idAccordoServizio.getSoggettoReferente().getTipo());
            filtroRicercaPorteApplicative.setNomeSoggettoVirtuale(idAccordoServizio.getSoggettoReferente().getNome());
            filtroRicercaPorteApplicative.setTipoServizio(as.getServizio().getTipo());
            filtroRicercaPorteApplicative.setNomeServizio(as.getServizio().getNome());
            try {
                idsPA2 = this.archiveEngine.getAllIdPorteApplicative(filtroRicercaPorteApplicative);
                if (idsPA2 != null && idsPA2.size() > 0) {
                    for (IDPortaApplicativaByNome idPortaApplicativa : idsPA2) {
                        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
        }
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idServizio, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, true, provenienza);
    }

    private void readAccordoServizioParteSpecifica(Archive archive, IDServizio idServizio, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        AccordoServizioParteSpecifica as = this.archiveEngine.getAccordoServizioParteSpecifica(idServizio, false);
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        this.readAccordoServizioParteSpecifica(archive, idAccordo, cascadeConfig, cascadeAvanti, provenienza);
    }

    private void readFruitore(Archive archive, IDAccordo idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readFruitore(archive, idAccordoServizio, idFruitore, fruitore, cascadeConfig, true, provenienza);
    }

    private void readFruitore(Archive archive, IDAccordo idAccordoServizio, IDSoggetto idFruitore, Fruitore fruitore, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        IDPortaDelegata idPD;
        String tipoSoggetto = null;
        String nomeSoggetto = null;
        if (idAccordoServizio.getSoggettoReferente() != null) {
            tipoSoggetto = idAccordoServizio.getSoggettoReferente().getTipo();
            nomeSoggetto = idAccordoServizio.getSoggettoReferente().getNome();
        }
        String key = ArchiveFruitore.buildKey(idFruitore.getTipo(), idFruitore.getNome(), tipoSoggetto, nomeSoggetto, idAccordoServizio.getNome(), idAccordoServizio.getVersione());
        if (!archive.getAccordiFruitori().containsKey(key)) {
            try {
                if (cascadeConfig.isCascadeFruizioni() || ArchiveType.FRUITORE.equals((Object)provenienza)) {
                    if (fruitore == null) {
                        AccordoServizioParteSpecifica as = this.archiveEngine.getAccordoServizioParteSpecifica(idAccordoServizio, true);
                        for (Fruitore fruitoreCheck : as.getFruitoreList()) {
                            if (!fruitoreCheck.getTipo().equals(idFruitore.getTipo()) || !fruitoreCheck.getNome().equals(idFruitore.getNome())) continue;
                            fruitore = fruitoreCheck;
                            break;
                        }
                    }
                    ArchiveFruitore archiveFruitore = new ArchiveFruitore(idAccordoServizio, fruitore, this.idCorrelazione);
                    archive.getAccordiFruitori().add(archiveFruitore);
                    IDPortaDelegata idPD2 = this.archiveEngine.getIDPortaDelegataAssociataFruizione(idAccordoServizio, idFruitore);
                    if (idPD2 != null) {
                        archiveFruitore.setIdPortaDelegataAssociata(idPD2);
                    }
                    this.readSoggetto(archive, idFruitore, cascadeConfig, false, ArchiveType.FRUITORE);
                    this.readAccordoServizioParteSpecifica(archive, idAccordoServizio, cascadeConfig, false, ArchiveType.FRUITORE);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(Fruitore " + idFruitore + " dell'accordo " + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizio) + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti && (idPD = this.archiveEngine.getIDPortaDelegataAssociataFruizione(idAccordoServizio, idFruitore)) != null) {
            this.readPortaDelegata(archive, idPD, cascadeConfig, ArchiveType.FRUITORE);
        }
    }

    private void readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPortaDelegata(archive, idPortaDelegata, cascadeConfig, true, provenienza);
    }

    private void readPortaDelegata(Archive archive, IDPortaDelegata idPortaDelegata, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePortaDelegata.buildKey(idPortaDelegata.getSoggettoFruitore().getTipo(), idPortaDelegata.getSoggettoFruitore().getNome(), idPortaDelegata.getLocationPD());
        PortaDelegata pd = null;
        if (archive.getPorteDelegate().containsKey(key)) {
            pd = ((ArchivePortaDelegata)archive.getPorteDelegate().get(key)).getPortaDelegata();
        } else {
            try {
                pd = this.archiveEngine.getPortaDelegata(idPortaDelegata);
                if (cascadeConfig.isCascadePorteDelegate() || ArchiveType.PORTA_DELEGATA.equals((Object)provenienza)) {
                    if (pd.getTipoSoggettoProprietario() == null) {
                        pd.setTipoSoggettoProprietario(idPortaDelegata.getSoggettoFruitore().getTipo());
                    }
                    if (pd.getNomeSoggettoProprietario() == null) {
                        pd.setNomeSoggettoProprietario(idPortaDelegata.getSoggettoFruitore().getNome());
                    }
                    ArchivePortaDelegata archivePd = new ArchivePortaDelegata(pd, this.idCorrelazione);
                    archive.getPorteDelegate().add(archivePd);
                    this.readSoggetto(archive, idPortaDelegata.getSoggettoFruitore(), cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    if (!(pd.getSoggettoErogatore() == null || pd.getSoggettoErogatore().getTipo() == null || "".equals(pd.getSoggettoErogatore().getTipo()) || pd.getSoggettoErogatore().getNome() == null || "".equals(pd.getSoggettoErogatore().getNome()) || pd.getServizio() == null || pd.getServizio().getTipo() == null || "".equals(pd.getServizio().getTipo()) || pd.getServizio().getNome() == null || "".equals(pd.getServizio().getNome()))) {
                        IDServizio idServizio = new IDServizio(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome());
                        this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                    }
                    if (pd != null && pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pd.getRuoli().sizeRuoloList(); ++i) {
                            Ruolo ruolo = pd.getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                List<IDRuolo> idsRuoli = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli == null || idsRuoli.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PortaDelegata " + idPortaDelegata + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti && pd.sizeServizioApplicativoList() > 0) {
            for (ServizioApplicativo sa : pd.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idPortaDelegata.getSoggettoFruitore());
                idSA.setNome(sa.getNome());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_DELEGATA);
            }
        }
    }

    private void readPortaApplicativa(Archive archive, IDPortaApplicativaByNome idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, ArchiveType provenienza) throws Exception {
        this.readPortaApplicativa(archive, idPortaApplicativa, cascadeConfig, true, provenienza);
    }

    private void readPortaApplicativa(Archive archive, IDPortaApplicativaByNome idPortaApplicativa, ArchiveCascadeConfiguration cascadeConfig, boolean cascadeAvanti, ArchiveType provenienza) throws Exception {
        String key = ArchivePortaApplicativa.buildKey(idPortaApplicativa.getSoggetto().getTipo(), idPortaApplicativa.getSoggetto().getNome(), idPortaApplicativa.getNome());
        PortaApplicativa pa = null;
        if (archive.getPorteApplicative().containsKey(key)) {
            pa = ((ArchivePortaApplicativa)archive.getPorteApplicative().get(key)).getPortaApplicativa();
        } else {
            try {
                pa = this.archiveEngine.getPortaApplicativa(idPortaApplicativa);
                if (cascadeConfig.isCascadePorteApplicative() || ArchiveType.PORTA_APPLICATIVA.equals((Object)provenienza)) {
                    if (pa.getTipoSoggettoProprietario() == null) {
                        pa.setTipoSoggettoProprietario(idPortaApplicativa.getSoggetto().getTipo());
                    }
                    if (pa.getNomeSoggettoProprietario() == null) {
                        pa.setNomeSoggettoProprietario(idPortaApplicativa.getSoggetto().getNome());
                    }
                    ArchivePortaApplicativa archivePa = new ArchivePortaApplicativa(pa, this.idCorrelazione);
                    archive.getPorteApplicative().add(archivePa);
                    this.readSoggetto(archive, idPortaApplicativa.getSoggetto(), cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                        IDSoggetto idSoggetto = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
                        this.readSoggetto(archive, idSoggetto, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                    }
                    if (pa.getServizio() != null && pa.getServizio().getTipo() != null && !"".equals(pa.getServizio().getTipo()) && pa.getServizio().getNome() != null && !"".equals(pa.getServizio().getNome())) {
                        IDServizio idServizio;
                        if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && !"".equals(pa.getSoggettoVirtuale().getTipo()) && pa.getSoggettoVirtuale().getNome() != null && !"".equals(pa.getSoggettoVirtuale().getNome())) {
                            idServizio = new IDServizio(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome(), pa.getServizio().getTipo(), pa.getServizio().getNome());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        } else {
                            idServizio = new IDServizio(idPortaApplicativa.getSoggetto(), pa.getServizio().getTipo(), pa.getServizio().getNome());
                            this.readAccordoServizioParteSpecifica(archive, idServizio, cascadeConfig, false, ArchiveType.PORTA_APPLICATIVA);
                        }
                    }
                    if (pa != null && pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                        for (int i = 0; i < pa.getRuoli().sizeRuoloList(); ++i) {
                            Ruolo ruolo = pa.getRuoli().getRuolo(i);
                            FiltroRicercaRuoli filtroRuolo = new FiltroRicercaRuoli();
                            filtroRuolo.setNome(ruolo.getNome());
                            try {
                                List<IDRuolo> idsRuoli = this.archiveEngine.getAllIdRuoli(filtroRuolo);
                                if (idsRuoli == null || idsRuoli.size() <= 0) continue;
                                for (IDRuolo idRuolo : idsRuoli) {
                                    this.readRuolo(archive, idRuolo, cascadeConfig, false, ArchiveType.PORTA_DELEGATA);
                                }
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ProtocolException("(PortaApplicativa " + idPortaApplicativa + ") " + e.getMessage(), e);
            }
        }
        if (cascadeAvanti && pa.sizeServizioApplicativoList() > 0) {
            for (ServizioApplicativo sa : pa.getServizioApplicativoList()) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idPortaApplicativa.getSoggetto());
                idSA.setNome(sa.getNome());
                this.readServizioApplicativo(archive, idSA, cascadeConfig, ArchiveType.PORTA_APPLICATIVA);
            }
        }
    }
}

