/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBOggettiInUsoUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ErrorsHandlerCostant;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.MappingErogazionePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.MappingFruizionePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.AbstractArchiveEngine;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImportInformationMissingException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoDelete;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImportDetail;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePdd;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ArchiveStatoImport;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.PddTipologia;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class DeleterArchiveUtils {
    private AbstractArchiveEngine importerEngine;
    private Logger log;
    private String userLogin;
    private static String NEW_LINE = "\n\t\t";

    public DeleterArchiveUtils(AbstractArchiveEngine importerEngine, Logger log, String userLogin) throws Exception {
        this.importerEngine = importerEngine;
        this.log = log;
        this.userLogin = userLogin;
    }

    public ArchiveEsitoDelete deleteArchive(Archive archive, String userLogin) throws Exception, ImportInformationMissingException {
        ArchiveEsitoImportDetail detail;
        ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica;
        int i;
        ArchiveEsitoImportDetail detail2;
        Serializable mapping;
        ArchiveFruitore archiveFruitore;
        Serializable mapping2;
        int i2;
        ArchiveEsitoDelete esito = new ArchiveEsitoDelete();
        ArrayList<Serializable> listMappingErogazionePA = new ArrayList<Serializable>();
        ArrayList<Serializable> listMappingFruizionePD = new ArrayList<Serializable>();
        for (i2 = 0; i2 < archive.getAccordiServizioParteSpecifica().size(); ++i2) {
            IDPortaApplicativaByNome idPACheck;
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica2 = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i2);
            archiveAccordoServizioParteSpecifica2.update();
            if (archiveAccordoServizioParteSpecifica2.getIdPortaApplicativaAssociata() == null || (idPACheck = this.importerEngine.getIDPortaApplicativaAssociataErogazione(archiveAccordoServizioParteSpecifica2.getIdAccordoServizioParteSpecifica())) == null) continue;
            mapping2 = new MappingErogazionePortaApplicativa();
            ((MappingErogazionePortaApplicativa)mapping2).setIdServizio(archiveAccordoServizioParteSpecifica2.getIdServizio());
            ((MappingErogazionePortaApplicativa)mapping2).setIdPortaApplicativa(archiveAccordoServizioParteSpecifica2.getIdPortaApplicativaAssociata());
            listMappingErogazionePA.add(mapping2);
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            IDPortaDelegata idPDCheck;
            archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i2);
            archiveFruitore.update();
            if (archiveFruitore.getIdPortaDelegataAssociata() == null || (idPDCheck = this.importerEngine.getIDPortaDelegataAssociataFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore())) == null) continue;
            mapping2 = new MappingFruizionePortaDelegata();
            ((MappingFruizionePortaDelegata)mapping2).setIdAccordoServizioParteSpecifica(archiveFruitore.getIdAccordoServizioParteSpecifica());
            ((MappingFruizionePortaDelegata)mapping2).setIdFruitore(archiveFruitore.getIdSoggettoFruitore());
            ((MappingFruizionePortaDelegata)mapping2).setIdPortaDelegata(archiveFruitore.getIdPortaDelegataAssociata());
            listMappingFruizionePD.add(mapping2);
        }
        if (listMappingErogazionePA.size() > 0) {
            for (i2 = 0; i2 < listMappingErogazionePA.size(); ++i2) {
                mapping = (MappingErogazionePortaApplicativa)listMappingErogazionePA.get(i2);
                try {
                    this.importerEngine.deleteMappingErogazione(((MappingErogazionePortaApplicativa)mapping).getIdServizio(), ((MappingErogazionePortaApplicativa)mapping).getIdPortaApplicativa());
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'eliminazione del mapping di erogazione del servizio [" + ((MappingErogazionePortaApplicativa)mapping).getIdServizio() + "] verso la porta applicativa [" + ((MappingErogazionePortaApplicativa)mapping).getIdPortaApplicativa().getNome() + "]: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (listMappingFruizionePD.size() > 0) {
            for (i2 = 0; i2 < listMappingFruizionePD.size(); ++i2) {
                mapping = (MappingFruizionePortaDelegata)listMappingFruizionePD.get(i2);
                try {
                    this.importerEngine.deleteMappingFruizione(((MappingFruizionePortaDelegata)mapping).getIdAccordoServizioParteSpecifica(), ((MappingFruizionePortaDelegata)mapping).getIdFruitore(), ((MappingFruizionePortaDelegata)mapping).getIdPortaDelegata());
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Errore durante l'eliminazione del mapping di fruizione del servizio [" + ((MappingFruizionePortaDelegata)mapping).getIdServizio() + "] verso la porta delegata [" + ((MappingFruizionePortaDelegata)mapping).getIdPortaDelegata().getLocationPD() + "] da parte del soggetto [" + ((MappingFruizionePortaDelegata)mapping).getIdFruitore() + "]: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i2);
            detail2 = new ArchiveEsitoImportDetail(archivePortaApplicativa);
            try {
                archivePortaApplicativa.update();
                if (archivePortaApplicativa.getIdServizio() != null) {
                    try {
                        if (this.importerEngine.existsIDPortaApplicativaAssociata(archivePortaApplicativa.getIdServizio())) {
                            this.importerEngine.deleteMappingErogazione(archivePortaApplicativa.getIdServizio(), archivePortaApplicativa.getIdPortaApplicativaByNome());
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Errore durante l'eliminazione del mapping di erogazione del servizio [" + archivePortaApplicativa.getIdServizio() + "] verso la porta applicativa [" + archivePortaApplicativa.getIdPortaApplicativaByNome() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.deletePortaApplicativa(archivePortaApplicativa, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException(e);
            }
            esito.getPorteApplicative().add(detail2);
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i2);
            detail2 = new ArchiveEsitoImportDetail(archivePortaDelegata);
            try {
                PortaDelegata pd;
                archivePortaDelegata.update();
                if (archivePortaDelegata.getIdSoggettoProprietario() != null && (pd = archivePortaDelegata.getPortaDelegata()).getSoggettoErogatore() != null && pd.getSoggettoErogatore().getNome() != null && pd.getServizio() != null && pd.getServizio().getNome() != null) {
                    IDServizio idServizio = new IDServizio(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getTipo(), pd.getServizio().getNome());
                    try {
                        if (this.importerEngine.existsIDPortaDelegataAssociata(idServizio, archivePortaDelegata.getIdSoggettoProprietario())) {
                            this.importerEngine.deleteMappingFruizione(idServizio, archivePortaDelegata.getIdSoggettoProprietario(), archivePortaDelegata.getIdPortaDelegata());
                        }
                    }
                    catch (Exception e) {
                        this.log.debug("Errore durante l'eliminazione del mapping di fruizione del servizio [" + idServizio + "] verso la porta delegata [" + archivePortaDelegata.getIdPortaDelegata() + "] da parte del soggetto [" + archivePortaDelegata.getIdSoggettoProprietario() + "]: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.deletePortaDelegata(archivePortaDelegata, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException(e);
            }
            esito.getPorteDelegate().add(detail2);
        }
        for (i2 = 0; i2 < archive.getAccordiFruitori().size(); ++i2) {
            archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i2);
            detail2 = new ArchiveEsitoImportDetail(archiveFruitore);
            try {
                if (archiveFruitore.getIdAccordoServizioParteSpecifica() != null && this.importerEngine.existsIDPortaDelegataAssociata(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore())) {
                    this.importerEngine.deleteMappingFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                }
                this.deleteFruitore(archiveFruitore, detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException(e);
            }
            esito.getAccordiFruitori().add(detail2);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica_serviziComposti = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            IDAccordo idAccordo = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordo)) {
                AccordoServizioParteComune aspc = this.importerEngine.getAccordoServizioParteComune(idAccordo);
                if (aspc.getServizioComposto() != null) {
                    listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
                    continue;
                }
                listAccordiServizioParteSpecifica.add(archiveAccordoServizioParteSpecifica);
                continue;
            }
            listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica_serviziComposti.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica_serviziComposti.get(i);
            detail = new ArchiveEsitoImportDetail(archiveAccordoServizioParteSpecifica);
            try {
                if (archiveAccordoServizioParteSpecifica.getIdServizio() != null && this.importerEngine.existsIDPortaApplicativaAssociata(archiveAccordoServizioParteSpecifica.getIdServizio())) {
                    this.importerEngine.deleteMappingErogazione(archiveAccordoServizioParteSpecifica.getIdServizio());
                }
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, true, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getAccordiServizioParteSpecificaServiziComposti().add(detail);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveAccordoServizioComposto archiveAccordoServizioComposto = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
            detail = new ArchiveEsitoImportDetail(archiveAccordoServizioComposto);
            try {
                archiveAccordoServizioComposto.update();
                this.deleteAccordoServizioComposto(archiveAccordoServizioComposto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getAccordiServizioComposto().add(detail);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica.get(i);
            detail = new ArchiveEsitoImportDetail(archiveAccordoServizioParteSpecifica);
            try {
                if (archiveAccordoServizioParteSpecifica.getIdServizio() != null && this.importerEngine.existsIDPortaApplicativaAssociata(archiveAccordoServizioParteSpecifica.getIdServizio())) {
                    this.importerEngine.deleteMappingErogazione(archiveAccordoServizioParteSpecifica.getIdServizio());
                }
                this.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, false, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getAccordiServizioParteSpecifica().add(detail);
        }
        for (i = 0; i < archive.getAccordiServizioParteComune().size(); ++i) {
            ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i);
            detail = new ArchiveEsitoImportDetail(archiveAccordoServizioParteComune);
            try {
                archiveAccordoServizioParteComune.update();
                this.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getAccordiServizioParteComune().add(detail);
        }
        for (i = 0; i < archive.getAccordiCooperazione().size(); ++i) {
            ArchiveAccordoCooperazione archiveAccordoCooperazione = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i);
            detail = new ArchiveEsitoImportDetail(archiveAccordoCooperazione);
            try {
                archiveAccordoCooperazione.update();
                this.deleteAccordoCooperazione(archiveAccordoCooperazione, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getAccordiCooperazione().add(detail);
        }
        for (i = 0; i < archive.getServiziApplicativi().size(); ++i) {
            ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i);
            detail = new ArchiveEsitoImportDetail(archiveServizioApplicativo);
            try {
                archiveServizioApplicativo.update();
                this.deleteServizioApplicativo(archiveServizioApplicativo, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getServiziApplicativi().add(detail);
        }
        for (i = 0; i < archive.getSoggetti().size(); ++i) {
            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i);
            detail = new ArchiveEsitoImportDetail(archiveSoggetto);
            try {
                this.deleteSoggetto(archiveSoggetto, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getSoggetti().add(detail);
        }
        for (i = 0; i < archive.getRuoli().size(); ++i) {
            ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(i);
            detail = new ArchiveEsitoImportDetail(archiveRuolo);
            try {
                this.deleteRuolo(archiveRuolo, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getRuoli().add(detail);
        }
        for (i = 0; i < archive.getPdd().size(); ++i) {
            ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i);
            detail = new ArchiveEsitoImportDetail(archivePdd);
            try {
                this.deletePdd(archivePdd, detail);
            }
            catch (Exception e) {
                detail.setState(ArchiveStatoImport.ERROR);
                detail.setException(e);
            }
            esito.getPdd().add(detail);
        }
        if (archive.getConfigurazionePdD() != null && archive.getConfigurazionePdD().sizeExtendedInfoList() > 0) {
            Configurazione newConfig = new Configurazione();
            newConfig.getExtendedInfoList().addAll(archive.getConfigurazionePdD().getExtendedInfoList());
            ArchiveEsitoImportDetailConfigurazione detail3 = new ArchiveEsitoImportDetailConfigurazione(newConfig);
            try {
                this.deleteConfigurazione(newConfig, detail3);
            }
            catch (Exception e) {
                detail3.setState(ArchiveStatoImport.ERROR);
                detail3.setException(e);
            }
            esito.setConfigurazionePdD(detail3);
        }
        return esito;
    }

    public void deleteConfigurazione(Configurazione config, ArchiveEsitoImportDetailConfigurazione detail) {
        try {
            this.importerEngine.deleteConfigurazione(config);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della configurazione: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deletePdd(ArchivePdd archivePdd, ArchiveEsitoImportDetail detail) {
        String nomePdd = archivePdd.getNomePdd();
        try {
            if (!this.importerEngine.existsPortaDominio(nomePdd)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            PortaDominio pddReadFromDb = this.importerEngine.getPortaDominio(nomePdd);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(pddReadFromDb.getSuperUser())) {
                throw new Exception("La Porta di Dominio [" + nomePdd + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (PddTipologia.OPERATIVO.toString().equals(this.importerEngine.getTipoPortaDominio(nomePdd))) {
                throw new Exception("La Porta di Dominio [" + nomePdd + "] non \u00e8 eliminabile essendo di tipo '" + PddTipologia.OPERATIVO.toString() + "'");
            }
            ArrayList<String> whereIsInUso = new ArrayList<String>();
            if (this.importerEngine.isPddInUso(nomePdd, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(nomePdd, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deletePortaDominio(archivePdd.getPortaDominio());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta di dominio [" + nomePdd + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteRuolo(ArchiveRuolo archiveRuolo, ArchiveEsitoImportDetail detail) {
        IDRuolo idRuolo = archiveRuolo.getIdRuolo();
        try {
            if (!this.importerEngine.existsRuolo(idRuolo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Ruolo ruoloReadFromDb = this.importerEngine.getRuolo(idRuolo);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(ruoloReadFromDb.getSuperUser())) {
                throw new Exception("Il Ruolo [" + idRuolo + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isRuoloInUso(idRuolo, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idRuolo, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteRuolo(archiveRuolo.getRuolo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del ruolo [" + idRuolo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteSoggetto(ArchiveSoggetto archiveSoggetto, ArchiveEsitoImportDetail detail) {
        IDSoggetto idSoggetto = archiveSoggetto.getIdSoggetto();
        try {
            boolean delete = false;
            if (archiveSoggetto.getSoggettoRegistro() != null && this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto old = this.importerEngine.getSoggettoRegistro(idSoggetto);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Il soggetto non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
                }
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                if (this.importerEngine.isSoggettoRegistroInUso(idSoggetto, whereIsInUso)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idSoggetto, whereIsInUso, false, NEW_LINE));
                }
                this.importerEngine.deleteSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                delete = true;
            }
            if (archiveSoggetto.getSoggettoConfigurazione() != null && this.importerEngine.existsSoggettoConfigurazione(idSoggetto)) {
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                if (this.importerEngine.isSoggettoConfigurazioneInUso(idSoggetto, whereIsInUso)) {
                    throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idSoggetto, whereIsInUso, false, NEW_LINE));
                }
                this.importerEngine.deleteSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                delete = true;
            }
            if (delete) {
                detail.setState(ArchiveStatoImport.DELETED);
            } else {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del soggetto [" + idSoggetto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo, ArchiveEsitoImportDetail detail) {
        IDServizioApplicativo idServizioApplicativo = archiveServizioApplicativo.getIdServizioApplicativo();
        IDSoggetto idSoggettoProprietario = archiveServizioApplicativo.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isServizioApplicativoInUso(idServizioApplicativo, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idServizioApplicativo, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del servizio applicativo [" + idServizioApplicativo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione, ArchiveEsitoImportDetail detail) {
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoCooperazione.getIdAccordoCooperazione();
        try {
            if (!this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoCooperazione acReadFromDb = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(acReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di cooperazione [" + idAccordoCooperazione + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoCooperazioneInUso(idAccordoCooperazione, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoCooperazione, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di cooperazione [" + idAccordoCooperazione + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteComune.getIdAccordoServizioParteComune();
        try {
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune aspcReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspcReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte comune [" + idAccordoServizioParteComune + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioParteComune, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoServizioParteComune, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioParteComune + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteAccordoServizioComposto(ArchiveAccordoServizioComposto archiveAccordoServizioComposto, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioComposto = archiveAccordoServizioComposto.getIdAccordoServizioParteComune();
        try {
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteComune ascReadFromDb = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioComposto);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(ascReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio composto [" + idAccordoServizioComposto + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteComuneInUso(idAccordoServizioComposto, whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(idAccordoServizioComposto, whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte comune [" + idAccordoServizioComposto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica, boolean servizioComposto, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteSpecifica = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica();
        try {
            if (!this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            AccordoServizioParteSpecifica aspsReadFromDb = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(aspsReadFromDb.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
            if (this.importerEngine.isAccordoServizioParteSpecificaInUso(archiveAccordoServizioParteSpecifica.getIdServizio(), whereIsInUso)) {
                throw new Exception(NEW_LINE + DBOggettiInUsoUtils.toString(archiveAccordoServizioParteSpecifica.getIdServizio(), whereIsInUso, false, NEW_LINE));
            }
            this.importerEngine.deleteAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deleteFruitore(ArchiveFruitore archiveFruitore, ArchiveEsitoImportDetail detail) {
        IDAccordo idAccordoServizioParteSpecifica = archiveFruitore.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoFruitore = archiveFruitore.getIdSoggettoFruitore();
        try {
            AccordoServizioParteSpecifica oldAccordo = null;
            Fruitore old = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                oldAccordo = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                for (int i = 0; i < oldAccordo.sizeFruitoreList(); ++i) {
                    Fruitore check = oldAccordo.getFruitore(i);
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    old = oldAccordo.removeFruitore(i);
                    break;
                }
            }
            if (old == null) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoFruitore);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto fruitore [" + idSoggettoFruitore + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(oldAccordo.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            oldAccordo.getServizio().setOldTipoForUpdate(oldAccordo.getServizio().getTipo());
            oldAccordo.getServizio().setOldNomeForUpdate(oldAccordo.getServizio().getNome());
            oldAccordo.getServizio().setOldTipoSoggettoErogatoreForUpdate(oldAccordo.getServizio().getTipoSoggettoErogatore());
            oldAccordo.getServizio().setOldNomeSoggettoErogatoreForUpdate(oldAccordo.getServizio().getNomeSoggettoErogatore());
            this.importerEngine.updateAccordoServizioParteSpecifica(oldAccordo);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione del fruitore[" + idSoggettoFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deletePortaDelegata(ArchivePortaDelegata archivePortaDelegata, ArchiveEsitoImportDetail detail) {
        IDPortaDelegata idPortaDelegata = archivePortaDelegata.getIdPortaDelegata();
        IDSoggetto idSoggettoProprietario = archivePortaDelegata.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaDelegata portaDelegata = archivePortaDelegata.getPortaDelegata();
            this.importerEngine.deletePortaDelegata(portaDelegata);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta delegata [" + idPortaDelegata + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void deletePortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa, ArchiveEsitoImportDetail detail) {
        IDPortaApplicativa idPortaApplicativa = archivePortaApplicativa.getIdPortaApplicativa();
        IDPortaApplicativaByNome idPortaApplicativaByNome = archivePortaApplicativa.getIdPortaApplicativaByNome();
        IDSoggetto idSoggettoProprietario = archivePortaApplicativa.getIdSoggettoProprietario();
        try {
            if (!this.importerEngine.existsPortaApplicativa(idPortaApplicativaByNome.getNome(), idSoggettoProprietario)) {
                detail.setState(ArchiveStatoImport.DELETED_NOT_EXISTS);
                return;
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/eliminabile dall'utente collegato (" + this.userLogin + ")");
            }
            PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
            this.importerEngine.deletePortaApplicativa(pa);
            detail.setState(ArchiveStatoImport.DELETED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'eliminazione della porta applicativa [" + idPortaApplicativa + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }

    public void importConfigurazione(Configurazione configurazionePdD, ArchiveEsitoImportDetailConfigurazione detail) {
        try {
            this.importerEngine.updateConfigurazione(configurazionePdD);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException(e);
        }
    }
}

