/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.ProtocolFactoryManager;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImportInformationMissingCollection;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImportInformationMissingException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImporterInformationMissingSetter;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.ImporterInformationMissingUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.Archive;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveFruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchivePortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.ArchiveServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import java.util.ArrayList;

public class ArchiveValidator {
    private IRegistryReader registryReader;

    public ArchiveValidator(IRegistryReader registryReader) {
        this.registryReader = registryReader;
    }

    public void validateArchive(Archive archive, String protocolloEffettivo, boolean validazioneDocumenti, ImportInformationMissingCollection importInformationMissingCollection, String userLogin, boolean checkCorrelazioneAsincrona, boolean delete) throws Exception, ImportInformationMissingException {
        try {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolloEffettivo);
            this.validateAndFillImportInformationMissing(archive, protocolFactory, importInformationMissingCollection, validazioneDocumenti, userLogin, checkCorrelazioneAsincrona, delete);
        }
        catch (ImportInformationMissingException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    private void validateAndFillImportInformationMissing(Archive archive, IProtocolFactory protocolFactory, ImportInformationMissingCollection importInformationMissingCollection, boolean validazioneDocumenti, String userLogin, boolean checkCorrelazioneAsincrona, boolean delete) throws Exception, ImportInformationMissingException {
        int i;
        int i2;
        ImporterInformationMissingUtils importerInformationMissingUtils = new ImporterInformationMissingUtils(importInformationMissingCollection, this.registryReader, validazioneDocumenti, protocolFactory, userLogin, archive);
        if (archive.getInformationMissing() != null) {
            importerInformationMissingUtils.validateAndFillInformationMissing(archive.getInformationMissing(), delete);
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillServizioApplicativo((ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i2));
        }
        for (i2 = 0; i2 < archive.getPorteDelegate().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillPortaDelegata((ArchivePortaDelegata)archive.getPorteDelegate().get(i2));
        }
        for (i2 = 0; i2 < archive.getPorteApplicative().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillPortaApplicativa((ArchivePortaApplicativa)archive.getPorteApplicative().get(i2));
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillAccordoCooperazione((ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i2));
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i2), checkCorrelazioneAsincrona);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listServiziImplementanoAccordiServizioCompostoPresentiArchivio = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (i = 0; i < archive.getAccordiServizioParteSpecifica().size(); ++i) {
            ArchiveAccordoServizioParteSpecifica archiveServizio = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i);
            String uriAccordoServizioParteComune = archiveServizio.getAccordoServizioParteSpecifica().getAccordoServizioParteComune();
            boolean found = false;
            for (int j = 0; j < archive.getAccordiServizioComposto().size(); ++j) {
                AccordoServizioParteComune as = ((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(j)).getAccordoServizioParteComune();
                String uri = IDAccordoFactory.getInstance().getUriFromAccordo(as);
                if (!uriAccordoServizioParteComune.equals(uri)) continue;
                found = true;
                listServiziImplementanoAccordiServizioCompostoPresentiArchivio.add(archiveServizio);
                break;
            }
            if (found) continue;
            importerInformationMissingUtils.validateAndFillAccordoServizioParteSpecifica((ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i));
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteComune((ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i), checkCorrelazioneAsincrona);
        }
        for (ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica : listServiziImplementanoAccordiServizioCompostoPresentiArchivio) {
            importerInformationMissingUtils.validateAndFillAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica);
        }
        for (int i3 = 0; i3 < archive.getAccordiFruitori().size(); ++i3) {
            importerInformationMissingUtils.validateAndFillFruitore((ArchiveFruitore)archive.getAccordiFruitori().get(i3));
        }
        ImporterInformationMissingSetter.replaceTemplatesNames(archive);
    }
}

