/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.IRegistryReader;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.RegistryNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.constants.PddTipologia;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.IDAccordoFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import java.util.List;

public class ArchiveRegistryReader
implements IRegistryReader {
    private DriverRegistroServiziDB driverRegistroServiziDB;
    private DriverConfigurazioneDB driverConfigurazioneDB;

    public ArchiveRegistryReader(DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) throws Exception {
        this.driverRegistroServiziDB = driverRegistroServiziDB;
        this.driverConfigurazioneDB = driverConfigurazioneDB;
    }

    @Override
    public boolean existsPortaDominio(String nome) {
        try {
            return this.driverRegistroServiziDB.existsPortaDominio(nome);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<String> findPorteDominio(boolean operativo) throws RegistryNotFound {
        try {
            FiltroRicerca filtroRicerca = new FiltroRicerca();
            if (operativo) {
                filtroRicerca.setTipo(PddTipologia.OPERATIVO.toString());
            } else {
                filtroRicerca.setTipo(PddTipologia.ESTERNO.toString());
            }
            return this.driverRegistroServiziDB.getAllIdPorteDominio(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean existsSoggettoByCodiceIPA(String codiceIPA) {
        try {
            return this.driverRegistroServiziDB.existsSoggetto(codiceIPA);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsSoggetto(IDSoggetto idSoggetto) {
        try {
            return this.driverRegistroServiziDB.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IDSoggetto getIdSoggettoByCodiceIPA(String codiceIPA) throws RegistryNotFound {
        try {
            Soggetto s = this.driverRegistroServiziDB.getSoggetto(codiceIPA);
            IDSoggetto idSoggetto = new IDSoggetto(s.getTipo(), s.getNome(), s.getIdentificativoPorta());
            return idSoggetto;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getCodiceIPA(IDSoggetto idSoggetto) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getCodiceIPA(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto idSoggetto) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getSoggetto(idSoggetto);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteComune(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteComune(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<IDAccordo> findAccordiServizioParteComune(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.FiltroRicercaAccordi filtro) throws RegistryNotFound {
        try {
            FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
            if (filtro.getNome() != null) {
                filtroRicerca.setNomeAccordo(filtro.getNome());
            }
            if (filtro.getVersione() != null) {
                filtroRicerca.setVersione("" + filtro.getVersione());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroRicerca.setTipoSoggettoReferente(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroRicerca.setNomeSoggettoReferente(filtro.getSoggetto().getNome());
                }
            }
            return this.driverRegistroServiziDB.getAllIdAccordiServizioParteComune(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<IDAccordo> findAccordiServizioParteSpecifica(it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.archive.FiltroRicercaServizi filtro) throws RegistryNotFound {
        try {
            FiltroRicercaServizi filtroRicerca = new FiltroRicercaServizi();
            if (filtro.getTipo() != null) {
                filtroRicerca.setTipo(filtro.getTipo());
            }
            if (filtro.getNome() != null) {
                filtroRicerca.setNome(filtro.getNome());
            }
            if (filtro.getSoggetto() != null) {
                if (filtro.getSoggetto().getTipo() != null) {
                    filtroRicerca.setTipoSoggettoErogatore(filtro.getSoggetto().getTipo());
                }
                if (filtro.getSoggetto().getNome() != null) {
                    filtroRicerca.setNomeSoggettoErogatore(filtro.getSoggetto().getNome());
                }
            }
            return this.driverRegistroServiziDB.getAllIdAccordiServizioParteSpecifica(filtroRicerca);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IDServizio convertToIDServizio(IDAccordo idAccordoServizioParteSpecifica) throws RegistryNotFound {
        try {
            AccordoServizioParteSpecifica as = this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
            IDServizio idServizio = new IDServizio(idAccordoServizioParteSpecifica.getSoggettoReferente(), as.getServizio().getTipo(), as.getServizio().getNome());
            return idServizio;
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IDAccordo convertToIDAccordo(IDServizio idServizio) throws RegistryNotFound {
        try {
            AccordoServizioParteSpecifica as = this.driverRegistroServiziDB.getAccordoServizioParteSpecifica(idServizio);
            return IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoCooperazione(idAccordo);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean readAllegati) throws RegistryNotFound {
        try {
            return this.driverRegistroServiziDB.getAccordoCooperazione(idAccordo, readAllegati);
        }
        catch (DriverRegistroServiziNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) {
        try {
            return this.driverConfigurazioneDB.existsServizioApplicativo(idServizioApplicativo);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsServizioApplicativoAutenticatoBasic(String username, String password) {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativoAutenticatoBasic(username, password) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsServizioApplicativoAutenticatoSsl(String subject) {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativoAutenticatoSsl(subject) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean existsServizioApplicativoAutenticatoPrincipal(String principal) {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativoAutenticatoPrincipal(principal) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws RegistryNotFound {
        try {
            return this.driverConfigurazioneDB.getServizioApplicativo(idServizioApplicativo);
        }
        catch (DriverConfigurazioneNotFound de) {
            throw new RegistryNotFound(de.getMessage(), de);
        }
        catch (Exception e) {
            return null;
        }
    }
}

