/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBMappingUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.DBOggettiInUsoUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.commons.ErrorsHandlerCostant;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Configurazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ConfigurazioneGestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.GestioneErrore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.PortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.ServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.Soggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.DriverConfigurazioneNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteApplicative;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaPorteDelegate;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaServiziApplicativi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.FiltroRicercaSoggetti;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.config.driver.db.DriverConfigurazioneDB;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDAccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativa;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaApplicativaByNome;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDPortaDelegata;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDRuolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDServizioApplicativo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.archive.UtilitiesMappingFruizioneErogazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteComune;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.AccordoServizioParteSpecifica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Fruitore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.PortaDominio;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Ruolo;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.DriverRegistroServiziNotFound;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicerca;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaAccordi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaRuoli;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaServizi;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.ValidazioneStatoPackageException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.db.DriverRegistroServiziDB;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractArchiveEngine {
    private DriverRegistroServiziDB driverRegistroServizi;
    private DriverConfigurazioneDB driverConfigurazione;

    public DriverRegistroServiziDB getDriverRegistroServizi() {
        return this.driverRegistroServizi;
    }

    public DriverConfigurazioneDB getDriverConfigurazione() {
        return this.driverConfigurazione;
    }

    public AbstractArchiveEngine(DriverRegistroServiziDB driverRegistroServizi, DriverConfigurazioneDB driverConfigurazione) {
        this.driverRegistroServizi = driverRegistroServizi;
        this.driverConfigurazione = driverConfigurazione;
    }

    public abstract boolean isVisioneOggettiGlobale(String var1);

    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdPorteDominio(filtroRicerca);
    }

    public PortaDominio getPortaDominio(String nomePortaDominio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getPortaDominio(nomePortaDominio);
    }

    public String getTipoPortaDominio(String nomePortaDominio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getTipoPortaDominio(nomePortaDominio);
    }

    public boolean existsPortaDominio(String nomePortaDominio) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsPortaDominio(nomePortaDominio);
    }

    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createPortaDominio(pdd);
    }

    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updatePortaDominio(pdd);
    }

    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deletePortaDominio(pdd);
    }

    public boolean isPddInUso(String nomePortaDominio, List<String> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isPddInUso");
            boolean bl = DBOggettiInUsoUtils.isPddInUso(con, this.driverRegistroServizi.getTipoDB(), nomePortaDominio, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdRuoli(filtroRicerca);
    }

    public Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getRuolo(idRuolo);
    }

    public boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsRuolo(idRuolo);
    }

    public void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createRuolo(ruolo);
    }

    public void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updateRuolo(ruolo);
    }

    public void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deleteRuolo(ruolo);
    }

    public boolean isRuoloInUso(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isRuoloInUso");
            boolean bl = DBOggettiInUsoUtils.isRuoloInUso(con, this.driverRegistroServizi.getTipoDB(), idRuolo, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDSoggetto> getAllIdSoggettiRegistro(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.driver.FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdSoggetti(filtroRicerca);
    }

    public it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getSoggetto(idSoggetto);
    }

    public boolean existsSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsSoggetto(idSoggetto);
    }

    public void createSoggettoRegistro(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createSoggetto(soggetto);
    }

    public void updateSoggettoRegistro(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updateSoggetto(soggetto);
    }

    public void deleteSoggettoRegistro(it.link.pdd.tools.migrazione_govway.openspcoop2_core.registry.Soggetto soggetto) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deleteSoggetto(soggetto);
    }

    public boolean isSoggettoRegistroInUso(IDSoggetto idSoggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isSoggettoRegistroInUso");
            boolean bl = DBOggettiInUsoUtils.isSoggettoRegistryInUso(con, this.driverRegistroServizi.getTipoDB(), idSoggetto, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDSoggetto> getAllIdSoggettiConfigurazione(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getAllIdSoggetti(filtroRicerca);
    }

    public Soggetto getSoggettoConfigurazione(IDSoggetto idSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getSoggetto(idSoggetto);
    }

    public boolean existsSoggettoConfigurazione(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsSoggetto(idSoggetto);
    }

    public void createSoggettoConfigurazione(Soggetto soggetto) throws DriverConfigurazioneException {
        this.driverConfigurazione.createSoggetto(soggetto);
    }

    public void updateSoggettoConfigurazione(Soggetto soggetto) throws DriverConfigurazioneException {
        this.driverConfigurazione.updateSoggetto(soggetto);
    }

    public void deleteSoggettoConfigurazione(Soggetto soggetto) throws DriverConfigurazioneException {
        this.driverConfigurazione.deleteSoggetto(soggetto);
    }

    public boolean isSoggettoConfigurazioneInUso(IDSoggetto idSoggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverConfigurazioneException {
        Connection con = null;
        try {
            con = this.driverConfigurazione.getConnection("archive.isSoggettoConfigurazioneInUso");
            boolean bl = DBOggettiInUsoUtils.isSoggettoConfigInUso(con, this.driverConfigurazione.getTipoDB(), idSoggetto, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverConfigurazione.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getAllIdServiziApplicativi(filtroRicerca);
    }

    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getServizioApplicativo(idServizioApplicativo);
    }

    public boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsServizioApplicativo(idServizioApplicativo);
    }

    public void createServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        this.driverConfigurazione.createServizioApplicativo(servizioApplicativo);
    }

    public void updateServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        this.driverConfigurazione.updateServizioApplicativo(servizioApplicativo);
    }

    public void deleteServizioApplicativo(ServizioApplicativo servizioApplicativo) throws DriverConfigurazioneException {
        this.driverConfigurazione.deleteServizioApplicativo(servizioApplicativo);
    }

    public boolean isServizioApplicativoInUso(IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverConfigurazioneException {
        Connection con = null;
        try {
            con = this.driverConfigurazione.getConnection("archive.isServizioApplicativoInUso");
            boolean bl = DBOggettiInUsoUtils.isServizioApplicativoInUso(con, this.driverConfigurazione.getTipoDB(), idServizioApplicativo, whereIsInUso, true);
            return bl;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverConfigurazione.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdAccordiCooperazione(filtroRicerca);
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoCooperazione(idAccordoCooperazione);
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoCooperazione(idAccordoCooperazione, readContenutoAllegati);
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsAccordoCooperazione(idAccordoCooperazione);
    }

    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createAccordoCooperazione(accordoCooperazione);
    }

    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updateAccordoCooperazione(accordoCooperazione);
    }

    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deleteAccordoCooperazione(accordoCooperazione);
    }

    public void validaStatoAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws ValidazioneStatoPackageException {
        this.driverRegistroServizi.validaStatoAccordoCooperazione(accordoCooperazione);
    }

    public boolean isAccordoCooperazioneInUso(IDAccordoCooperazione idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isAccordoCooperazioneInUso");
            boolean bl = DBOggettiInUsoUtils.isAccordoCooperazioneInUso(con, this.driverRegistroServizi.getTipoDB(), idAccordo, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdAccordiServizioParteComune(filtroRicerca);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteComune(idAccordoServizioParteComune);
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordoServizioParteComune, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteComune(idAccordoServizioParteComune, readContenutoAllegati);
    }

    public boolean existsAccordoServizioParteComune(IDAccordo idAccordoServizioParteComune) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsAccordoServizioParteComune(idAccordoServizioParteComune);
    }

    public void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createAccordoServizioParteComune(accordoServizioParteComune);
    }

    public void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updateAccordoServizioParteComune(accordoServizioParteComune);
    }

    public void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deleteAccordoServizioParteComune(accordoServizioParteComune);
    }

    public void validaStatoAccordoServizioParteComune(AccordoServizioParteComune accordoServizioParteComune, boolean utilizzoAzioniDiretteInAccordoAbilitato) throws ValidazioneStatoPackageException {
        this.driverRegistroServizi.validaStatoAccordoServizio(accordoServizioParteComune, utilizzoAzioniDiretteInAccordoAbilitato);
    }

    public boolean isAccordoServizioParteComuneInUso(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isAccordoServizioParteComuneInUso");
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso(con, this.driverRegistroServizi.getTipoDB(), idAccordo, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public List<IDAccordo> getAllIdAccordiServizioParteSpecifica(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAllIdAccordiServizioParteSpecifica(filtroRicerca);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica, readContenutoAllegati);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteSpecifica(idServizio);
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.driverRegistroServizi.getAccordoServizioParteSpecifica(idServizio, readContenutoAllegati);
    }

    public boolean existsAccordoServizioParteSpecifica(IDAccordo idAccordoServizioParteSpecifica) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
    }

    public boolean existsAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.driverRegistroServizi.existsAccordoServizioParteSpecifica(idServizio);
    }

    public void createAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        this.driverRegistroServizi.createAccordoServizioParteSpecifica(accordoServizioParteSpecifica);
    }

    public void updateAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        this.driverRegistroServizi.updateAccordoServizioParteSpecifica(accordoServizioParteSpecifica);
    }

    public void deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws DriverRegistroServiziException {
        this.driverRegistroServizi.deleteAccordoServizioParteSpecifica(accordoServizioParteSpecifica);
    }

    public void validaStatoAccordoServizioParteSpecifica(AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws ValidazioneStatoPackageException {
        this.driverRegistroServizi.validaStatoAccordoServizioParteSpecifica(accordoServizioParteSpecifica);
    }

    public void validaStatoFruitoreServizio(Fruitore fruitore, AccordoServizioParteSpecifica accordoServizioParteSpecifica) throws ValidazioneStatoPackageException {
        this.driverRegistroServizi.validaStatoFruitoreServizio(fruitore, accordoServizioParteSpecifica);
    }

    public void controlloUnicitaImplementazioneAccordoPerSoggetto(String portType, IDSoggetto idSoggettoErogatore, long idSoggettoErogatoreLong, IDAccordo idAccordoServizioParteComune, long idAccordoServizioParteComuneLong, IDServizio idAccordoServizioParteSpecifica, long idAccordoServizioParteSpecificaLong, boolean isUpdate, boolean isServizioCorrelato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) throws DriverRegistroServiziException {
        this.driverRegistroServizi.controlloUnicitaImplementazioneAccordoPerSoggetto(portType, idSoggettoErogatore, idSoggettoErogatoreLong, idAccordoServizioParteComune, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, idAccordoServizioParteSpecificaLong, isUpdate, isServizioCorrelato, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto);
    }

    public boolean isAccordoServizioParteSpecificaInUso(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isAccordoServizioParteSpecificaInUso");
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteSpecificaInUso(con, this.driverRegistroServizi.getTipoDB(), idAccordo, whereIsInUso, null);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public boolean isAccordoServizioParteSpecificaInUso(IDServizio idServizio, Map<ErrorsHandlerCostant, List<String>> whereIsInUso) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("archive.isAccordoServizioParteSpecificaInUso");
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteSpecificaInUso(con, this.driverRegistroServizi.getTipoDB(), idServizio, whereIsInUso, null);
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void createMappingErogazione(IDAccordo idAccordo, IDPortaApplicativaByNome idPortaApplicativaByNome) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("createMappingErogazione");
            DBMappingUtils.createMappingErogazione(idAccordo, idPortaApplicativaByNome, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void createMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("createMappingErogazione");
            DBMappingUtils.createMappingErogazione(idServizio, idPortaApplicativaByNome, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public IDPortaApplicativaByNome getIDPortaApplicativaAssociataErogazione(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("getIDPortaApplicativaAssociataErogazione");
            IDPortaApplicativaByNome iDPortaApplicativaByNome = DBMappingUtils.getIDPortaApplicativaAssociata(idAccordo, con, this.driverRegistroServizi.getTipoDB());
            return iDPortaApplicativaByNome;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public IDPortaApplicativaByNome getIDPortaApplicativaAssociataErogazione(IDServizio idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("getIDPortaApplicativaAssociataErogazione");
            IDPortaApplicativaByNome iDPortaApplicativaByNome = DBMappingUtils.getIDPortaApplicativaAssociata(idServizio, con, this.driverRegistroServizi.getTipoDB());
            return iDPortaApplicativaByNome;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingErogazione(IDAccordo idAccordo, IDPortaApplicativaByNome idPortaApplicativaByNome) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingErogazione");
            DBMappingUtils.deleteMappingErogazione(idAccordo, idPortaApplicativaByNome, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativaByNome idPortaApplicativaByNome) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingErogazione");
            DBMappingUtils.deleteMappingErogazione(idServizio, idPortaApplicativaByNome, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingErogazione(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingErogazione");
            DBMappingUtils.deleteMappingErogazione(idAccordo, null, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingErogazione(IDServizio idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingErogazione");
            DBMappingUtils.deleteMappingErogazione(idServizio, null, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    boolean existsIDPortaApplicativaAssociata(IDAccordo idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("existsIDPortaApplicativaAssociata");
            boolean bl = DBMappingUtils.existsIDPortaApplicativaAssociata(idAccordo, con, this.driverRegistroServizi.getTipoDB());
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    boolean existsIDPortaApplicativaAssociata(IDServizio idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("existsIDPortaApplicativaAssociata");
            boolean bl = DBMappingUtils.existsIDPortaApplicativaAssociata(idServizio, con, this.driverRegistroServizi.getTipoDB());
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void initMappingErogazione(Logger log) throws DriverRegistroServiziException {
        try {
            UtilitiesMappingFruizioneErogazione utilities = new UtilitiesMappingFruizioneErogazione(this.driverConfigurazione, this.driverRegistroServizi, log);
            utilities.initMappingErogazione();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public void createMappingFruizione(IDAccordo idAccordo, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("createMappingFruizione");
            DBMappingUtils.createMappingFruizione(idAccordo, idFruitore, idPortaDelegata, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void createMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("createMappingFruizione");
            DBMappingUtils.createMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataFruizione(IDAccordo idAccordo, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("getIDPortaDelegataAssociataFruizione");
            IDPortaDelegata iDPortaDelegata = DBMappingUtils.getIDPortaDelegataAssociata(idAccordo, idFruitore, con, this.driverRegistroServizi.getTipoDB());
            return iDPortaDelegata;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataFruizione(IDServizio idServizio, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("getIDPortaDelegataAssociataFruizione");
            IDPortaDelegata iDPortaDelegata = DBMappingUtils.getIDPortaDelegataAssociata(idServizio, idFruitore, con, this.driverRegistroServizi.getTipoDB());
            return iDPortaDelegata;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingFruizione(IDAccordo idAccordo, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingFruizione");
            DBMappingUtils.deleteMappingFruizione(idAccordo, idFruitore, idPortaDelegata, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingFruizione");
            DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, idPortaDelegata, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingFruizione(IDAccordo idAccordo, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingFruizione");
            DBMappingUtils.deleteMappingFruizione(idAccordo, idFruitore, null, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("deleteMappingFruizione");
            DBMappingUtils.deleteMappingFruizione(idServizio, idFruitore, null, con, this.driverRegistroServizi.getTipoDB());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsIDPortaDelegataAssociata(IDAccordo idAccordo, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("existsIDPortaDelegataAssociata");
            boolean bl = DBMappingUtils.existsIDPortaDelegataAssociata(idAccordo, idFruitore, con, this.driverRegistroServizi.getTipoDB());
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public boolean existsIDPortaDelegataAssociata(IDServizio idServizio, IDSoggetto idFruitore) throws DriverRegistroServiziException {
        Connection con = null;
        try {
            con = this.driverRegistroServizi.getConnection("existsIDPortaDelegataAssociata");
            boolean bl = DBMappingUtils.existsIDPortaDelegataAssociata(idServizio, idFruitore, con, this.driverRegistroServizi.getTipoDB());
            return bl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        finally {
            try {
                this.driverRegistroServizi.releaseConnection(con);
            }
            catch (Exception exception) {}
        }
    }

    public void initMappingFruizione(Logger log) throws DriverRegistroServiziException {
        try {
            UtilitiesMappingFruizioneErogazione utilities = new UtilitiesMappingFruizioneErogazione(this.driverConfigurazione, this.driverRegistroServizi, log);
            utilities.initMappingFruizione();
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
    }

    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getAllIdPorteDelegate(filtroRicerca);
    }

    public PortaDelegata getPortaDelegata(IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getPortaDelegata(idPortaDelegata);
    }

    public PortaDelegata getPortaDelegata(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getPortaDelegata(nomePorta, soggettoProprietario);
    }

    public boolean existsPortaDelegata(IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsPortaDelegata(idPortaDelegata);
    }

    public boolean existsPortaDelegata(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsPortaDelegata(nomePorta, soggettoProprietario);
    }

    public void createPortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        this.driverConfigurazione.createPortaDelegata(portaDelegata);
    }

    public void deletePortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        this.driverConfigurazione.deletePortaDelegata(portaDelegata);
    }

    public void updatePortaDelegata(PortaDelegata portaDelegata) throws DriverConfigurazioneException {
        this.driverConfigurazione.updatePortaDelegata(portaDelegata);
    }

    public List<IDPortaApplicativaByNome> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getAllIdPorteApplicative(filtroRicerca);
    }

    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPortaApplicativa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getPortaApplicativa(idPortaApplicativa, true);
    }

    public PortaApplicativa getPortaApplicativa(IDPortaApplicativaByNome idPortaApplicativa) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getPortaApplicativa(idPortaApplicativa.getNome(), idPortaApplicativa.getSoggetto());
    }

    public PortaApplicativa getPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazione.getPortaApplicativa(nomePorta, soggettoProprietario);
    }

    public boolean existsPortaApplicativa(IDPortaApplicativa idPortaApplicativa) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsPortaApplicativa(idPortaApplicativa);
    }

    public boolean existsPortaApplicativa(String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException {
        return this.driverConfigurazione.existsPortaApplicativa(nomePorta, soggettoProprietario);
    }

    public void createPortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        this.driverConfigurazione.createPortaApplicativa(portaApplicativa);
    }

    public void deletePortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        this.driverConfigurazione.deletePortaApplicativa(portaApplicativa);
    }

    public void updatePortaApplicativa(PortaApplicativa portaApplicativa) throws DriverConfigurazioneException {
        this.driverConfigurazione.updatePortaApplicativa(portaApplicativa);
    }

    public void updateConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        if (configurazione.getRoutingTable() != null) {
            this.driverConfigurazione.updateRoutingTable(configurazione.getRoutingTable());
        }
        if (configurazione.getAccessoRegistro() != null) {
            this.driverConfigurazione.updateAccessoRegistro(configurazione.getAccessoRegistro());
        }
        if (configurazione.getGestioneErrore() != null) {
            if (configurazione.getGestioneErrore().getComponenteCooperazione() != null) {
                this.driverConfigurazione.updateGestioneErroreComponenteCooperazione(configurazione.getGestioneErrore().getComponenteCooperazione());
            }
            if (configurazione.getGestioneErrore().getComponenteIntegrazione() != null) {
                this.driverConfigurazione.updateGestioneErroreComponenteIntegrazione(configurazione.getGestioneErrore().getComponenteIntegrazione());
            }
        }
        if (configurazione.getStatoServiziPdd() != null) {
            this.driverConfigurazione.updateStatoServiziPdD(configurazione.getStatoServiziPdd());
        }
        if (configurazione.getSystemProperties() != null) {
            this.driverConfigurazione.updateSystemPropertiesPdD(configurazione.getSystemProperties());
        }
        this.driverConfigurazione.updateConfigurazione(configurazione);
    }

    public void deleteConfigurazione(Configurazione configurazione) throws DriverConfigurazioneException {
        this.driverConfigurazione.deleteConfigurazione(configurazione);
    }

    public Configurazione getConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Configurazione configurazione = this.driverConfigurazione.getConfigurazioneGenerale();
        configurazione.setRoutingTable(this.driverConfigurazione.getRoutingTable());
        configurazione.setAccessoRegistro(this.driverConfigurazione.getAccessoRegistro());
        try {
            configurazione.setAccessoConfigurazione(this.driverConfigurazione.getAccessoConfigurazione());
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        try {
            configurazione.setAccessoDatiAutorizzazione(this.driverConfigurazione.getAccessoDatiAutorizzazione());
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        GestioneErrore gestioneErroreCooperazione = null;
        GestioneErrore gestioneErroreIntegrazione = null;
        try {
            gestioneErroreCooperazione = this.driverConfigurazione.getGestioneErroreComponenteCooperazione();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        try {
            gestioneErroreIntegrazione = this.driverConfigurazione.getGestioneErroreComponenteIntegrazione();
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        if (gestioneErroreCooperazione != null || gestioneErroreIntegrazione != null) {
            if (configurazione.getGestioneErrore() == null) {
                configurazione.setGestioneErrore(new ConfigurazioneGestioneErrore());
            }
            if (gestioneErroreCooperazione != null) {
                configurazione.getGestioneErrore().setComponenteCooperazione(gestioneErroreCooperazione);
            }
            if (gestioneErroreIntegrazione != null) {
                configurazione.getGestioneErrore().setComponenteIntegrazione(gestioneErroreIntegrazione);
            }
        }
        try {
            configurazione.setStatoServiziPdd(this.driverConfigurazione.getStatoServiziPdD());
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        try {
            configurazione.setSystemProperties(this.driverConfigurazione.getSystemPropertiesPdD());
        }
        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
            // empty catch block
        }
        return configurazione;
    }
}

