/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.FunctionContextsCustom;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.constants.IDService;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.utils.UtilsException;
import it.link.pdd.tools.migrazione_govway.utils.resources.TransportRequestContext;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class URLProtocolContext
extends TransportRequestContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PA_FUNCTION = "PA";
    public static final String PD_FUNCTION = "PD";
    public static final String PDtoSOAP_FUNCTION = "PDtoSOAP";
    public static final String IntegrationManager_FUNCTION = "IntegrationManager";
    public static final String IntegrationManager_ENGINE = "IntegrationManagerEngine";
    public static final String IntegrationManager_FUNCTION_PD = "IntegrationManager/PD";
    public static final String IntegrationManager_FUNCTION_MessageBox = "IntegrationManager/MessageBox";
    public static final String CheckPdD_FUNCTION = "checkPdD";
    private HttpServletRequest httpServletRequest;
    private IDService idServiceCustom;

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void updateHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public IDService getIdServiceCustom() {
        return this.idServiceCustom;
    }

    public URLProtocolContext() throws ProtocolException, UtilsException {
    }

    public URLProtocolContext(HttpServletRequest req, Logger logCore) throws ProtocolException, UtilsException {
        this(req, logCore, null);
    }

    public URLProtocolContext(HttpServletRequest req, Logger logCore, FunctionContextsCustom customContexts) throws ProtocolException, UtilsException {
        this.httpServletRequest = req;
        String servletContext = req.getContextPath();
        String urlInvocazione = req.getRequestURI();
        String servizioInvocato = null;
        if (logCore != null) {
            logCore.debug("SERVLET CONTEXT [" + servletContext + "] URL[" + urlInvocazione + "]");
        }
        try {
            this.parametersFormBased = new Properties();
            Enumeration en = req.getParameterNames();
            while (en.hasMoreElements()) {
                String nomeProperty = (String)en.nextElement();
                this.parametersFormBased.setProperty(nomeProperty, req.getParameter(nomeProperty));
            }
            this.parametersTrasporto = new Properties();
            Enumeration enTrasporto = req.getHeaderNames();
            while (enTrasporto.hasMoreElements()) {
                String nomeProperty = (String)enTrasporto.nextElement();
                this.parametersTrasporto.setProperty(nomeProperty, req.getHeader(nomeProperty));
            }
            if (!urlInvocazione.startsWith(servletContext + "/")) {
                throw new Exception("OpenSPCoop2 [protocol/]service to be used not supplied (context error)");
            }
            servizioInvocato = urlInvocazione.substring((servletContext + "/").length());
            if (logCore != null) {
                logCore.debug("SERVIZIO RICHIESTO: [" + servizioInvocato + "]");
            }
            if (servizioInvocato == null || "".equals(servizioInvocato.trim())) {
                throw new Exception("OpenSPCoop2 [protocol/]service to be used not supplied");
            }
            String protocollo = null;
            String function = null;
            String functionParameters = null;
            if (servizioInvocato.indexOf("/") >= 0) {
                protocollo = servizioInvocato.substring(0, servizioInvocato.indexOf("/"));
                function = servizioInvocato.substring(servizioInvocato.indexOf("/") + 1, servizioInvocato.length());
            } else {
                protocollo = servizioInvocato;
                function = servizioInvocato;
            }
            if (logCore != null) {
                logCore.debug("PROTOCOLLO[" + protocollo + "] FUNCTION[" + function + "]");
            }
            if (protocollo.equals(PA_FUNCTION) || protocollo.equals(PD_FUNCTION) || protocollo.equals(PDtoSOAP_FUNCTION) || protocollo.equals(IntegrationManager_FUNCTION) || protocollo.equals(CheckPdD_FUNCTION) || customContexts != null && customContexts.isMatch(protocollo, function)) {
                if (logCore != null) {
                    logCore.debug("SERVLET PATH EMPTY");
                }
                if (customContexts != null && customContexts.isMatch(protocollo, function)) {
                    this.idServiceCustom = customContexts.getServiceMatch(protocollo, function);
                    function = customContexts.getFunctionMatch(protocollo, function);
                    if (logCore != null) {
                        logCore.debug("CUSTOM FUNCTION [" + function + "] [" + this.idServiceCustom + "]");
                    }
                } else {
                    function = protocollo;
                }
                protocollo = "@EMPTY@";
                int sizePrefix = (req.getContextPath() + "/" + function + "/").length();
                if (req.getRequestURI().length() > sizePrefix) {
                    functionParameters = req.getRequestURI().substring(sizePrefix);
                }
            } else {
                if (function.indexOf("/") > 0) {
                    function = function.substring(0, function.indexOf("/"));
                } else if (function.indexOf("?") > 0) {
                    function = function.substring(0, function.indexOf("?"));
                }
                if (logCore != null) {
                    logCore.debug("FUNCTION [" + function + "]");
                }
                int sizePrefix = (req.getContextPath() + "/" + protocollo + "/" + function + "/").length();
                if (req.getRequestURI().length() > sizePrefix) {
                    functionParameters = req.getRequestURI().substring(sizePrefix);
                }
                if (customContexts != null && customContexts.isMatch(function, functionParameters)) {
                    this.idServiceCustom = customContexts.getServiceMatch(function, functionParameters);
                    function = customContexts.getFunctionMatch(function, functionParameters);
                    if (logCore != null) {
                        logCore.debug("CUSTOM FUNCTION [" + function + "] [" + this.idServiceCustom + "]");
                    }
                    sizePrefix = (req.getContextPath() + "/" + protocollo + "/" + function + "/").length();
                    if (req.getRequestURI().length() > sizePrefix) {
                        functionParameters = req.getRequestURI().substring(sizePrefix);
                    }
                }
            }
            if (logCore != null) {
                logCore.debug("Elaborazione finale Protocollo[" + protocollo + "] Function[" + function + "] FunctionParameters [" + functionParameters + "]");
            }
            this.webContext = req.getContextPath();
            this.requestURI = req.getRequestURI();
            this.protocol = protocollo;
            this.function = function;
            this.functionParameters = functionParameters;
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

