/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.FunctionContextsCustom;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.URLProtocolContext;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.engine.mapping.InformazioniServizioURLMapping;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.Openspcoop2;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.Web;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.manifest.utils.XMLUtils;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ConfigurazionePdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.config.ITraduttore;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.CodiceErroreCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ContestoCodificaEccezione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.Inoltro;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.LivelloRilevanza;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.utils.EsitiProperties;
import it.link.pdd.tools.migrazione_govway.utils.Utilities;
import it.link.pdd.tools.migrazione_govway.utils.resources.MapReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public class ProtocolFactoryManager {
    private static ProtocolFactoryManager protocolFactoryManager = null;
    private MapReader<String, Openspcoop2> manifests = null;
    private MapReader<String, URL> manifestURLs = null;
    private MapReader<String, IProtocolFactory> factories = null;
    private StringBuffer protocolLoaded = new StringBuffer();
    private String protocolDefault = null;
    private MapReader<String, List<String>> tipiSoggettiValidi = null;
    private MapReader<String, String> tipiSoggettiDefault = null;
    private MapReader<String, List<String>> tipiServiziValidi = null;
    private MapReader<String, String> tipiServiziDefault = null;
    private MapReader<String, List<String>> versioniValide = null;
    private MapReader<String, String> versioniDefault = null;
    private Logger log = null;

    public static synchronized void initialize(Logger log, ConfigurazionePdD configPdD, String protocolDefault) throws ProtocolException {
        if (protocolFactoryManager == null) {
            protocolFactoryManager = new ProtocolFactoryManager(log, configPdD, protocolDefault, false);
            EsitiProperties.initialize(configPdD.getConfigurationDir(), log, configPdD.getLoader());
        }
    }

    public static synchronized void initializeSingleProtocol(Logger log, ConfigurazionePdD configPdD, String protocol) throws ProtocolException {
        if (protocolFactoryManager == null) {
            protocolFactoryManager = new ProtocolFactoryManager(log, configPdD, protocol, true);
            EsitiProperties.initialize(configPdD.getConfigurationDir(), log, configPdD.getLoader());
        }
    }

    public static ProtocolFactoryManager getInstance() throws ProtocolException {
        if (protocolFactoryManager == null) {
            throw new ProtocolException("ProtocolFactoryManager not initialized");
        }
        return protocolFactoryManager;
    }

    public static void updateLogger(Logger log) {
        if (protocolFactoryManager != null) {
            ProtocolFactoryManager.protocolFactoryManager.log = log;
        }
    }

    public void initializeAllProtocols() throws ProtocolException {
        if (this.factories != null) {
            Enumeration<IProtocolFactory> factories = this.factories.elements();
            while (factories.hasMoreElements()) {
                IProtocolFactory iProtocolFactory = factories.nextElement();
                iProtocolFactory.getLogger();
                iProtocolFactory.getManifest();
                iProtocolFactory.getConfigurazionePdD();
                iProtocolFactory.createBustaBuilder();
                iProtocolFactory.createErroreApplicativoBuilder();
                iProtocolFactory.createEsitoBuilder();
                iProtocolFactory.createValidatoreErrori();
                iProtocolFactory.createValidazioneSintattica();
                iProtocolFactory.createValidazioneSemantica();
                iProtocolFactory.createValidazioneConSchema();
                iProtocolFactory.createValidazioneDocumenti();
                iProtocolFactory.createValidazioneAccordi();
                iProtocolFactory.createDriverMSGDiagnostici();
                iProtocolFactory.createMsgDiagnosticoOpenSPCoopAppender();
                iProtocolFactory.createXMLDiagnosticoBuilder();
                iProtocolFactory.createDriverTracciamento();
                iProtocolFactory.createTracciamentoOpenSPCoopAppender();
                iProtocolFactory.createXMLTracciaBuilder();
                iProtocolFactory.createArchive();
                List<String> versioni = iProtocolFactory.createProtocolConfiguration().getVersioni();
                for (String version : versioni) {
                    iProtocolFactory.createProtocolVersionManager(version);
                }
                iProtocolFactory.createProtocolManager();
                ITraduttore traduttore = iProtocolFactory.createTraduttore();
                traduttore.toString(CodiceErroreCooperazione.AZIONE);
                traduttore.toString(ContestoCodificaEccezione.INTESTAZIONE);
                traduttore.toString(Inoltro.CON_DUPLICATI);
                traduttore.toString(LivelloRilevanza.INFO);
                traduttore.toString(ProfiloDiCollaborazione.SINCRONO);
                traduttore.toString(TipoOraRegistrazione.LOCALE);
            }
        }
    }

    ProtocolFactoryManager(Logger log, ConfigurazionePdD configPdD, String protocolDefault, boolean searchSingleManifest) throws ProtocolException {
        try {
            Hashtable<String, Openspcoop2> tmp_manifests = new Hashtable<String, Openspcoop2>();
            Hashtable<String, URL> tmp_manifestURLs = new Hashtable<String, URL>();
            Hashtable<String, IProtocolFactory> tmp_factories = new Hashtable<String, IProtocolFactory>();
            Hashtable<String, List<String>> tmp_tipiSoggettiValidi = new Hashtable<String, List<String>>();
            Hashtable<String, String> tmp_tipiSoggettiDefault = new Hashtable<String, String>();
            Hashtable<String, List<String>> tmp_tipiServiziValidi = new Hashtable<String, List<String>>();
            Hashtable<String, String> tmp_tipiServiziDefault = new Hashtable<String, String>();
            Hashtable<String, List<String>> tmp_versioniValide = new Hashtable<String, List<String>>();
            Hashtable<String, String> tmp_versioniDefault = new Hashtable<String, String>();
            this.log = configPdD.getLog();
            this.protocolDefault = protocolDefault;
            configPdD.getLog().debug("Init ProtocolFactoryManager ...");
            if (searchSingleManifest) {
                URL pluginURL = ProtocolFactoryManager.class.getResource("/openspcoop2-manifest-migrazione.xml");
                this.loadManifest(configPdD, pluginURL, false, tmp_manifests, tmp_manifestURLs);
            } else {
                URL pluginURL;
                Enumeration<URL> en = ProtocolFactoryManager.class.getClassLoader().getResources("/openspcoop2-manifest-migrazione.xml");
                while (en.hasMoreElements()) {
                    pluginURL = en.nextElement();
                    this.loadManifest(configPdD, pluginURL, false, tmp_manifests, tmp_manifestURLs);
                }
                if (tmp_manifests.size() <= 0) {
                    en = ProtocolFactoryManager.class.getClassLoader().getResources("openspcoop2-manifest-migrazione.xml");
                    while (en.hasMoreElements()) {
                        pluginURL = en.nextElement();
                        this.loadManifest(configPdD, pluginURL, true, tmp_manifests, tmp_manifestURLs);
                    }
                }
            }
            if (tmp_manifests.size() <= 0) {
                throw new Exception("Protocol plugins not found");
            }
            configPdD.getLog().debug("Validate Manifests ...");
            this.validateProtocolFactoryLoaded(tmp_manifests, tmp_tipiSoggettiValidi, tmp_tipiSoggettiDefault, tmp_tipiServiziValidi, tmp_tipiServiziDefault, tmp_versioniValide, tmp_versioniDefault);
            configPdD.getLog().debug("Validate Manifests ok");
            Enumeration<String> protocolManifestEnum = tmp_manifests.keys();
            while (protocolManifestEnum.hasMoreElements()) {
                String protocolManifest = protocolManifestEnum.nextElement();
                configPdD.getLog().debug("Init ProtocolFactory for protocol [" + protocolManifest + "] ...");
                Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
                IProtocolFactory p = this.getProtocolFactoryEngine(manifestOpenspcoop2);
                p.init(configPdD.getLog(), protocolManifest, configPdD, manifestOpenspcoop2);
                if (!p.createValidazioneConSchema().initialize()) {
                    throw new Exception("[protocol:" + protocolManifest + "] Inizialize with error for ValidazioneConSchema");
                }
                tmp_factories.put(protocolManifest, p);
                if (this.protocolLoaded.length() > 0) {
                    this.protocolLoaded.append(",");
                }
                this.protocolLoaded.append(protocolManifest);
                InformazioniServizioURLMapping.initMappingProperties(p);
                StringBuffer context = new StringBuffer();
                if (manifestOpenspcoop2.getWeb().getEmptyContext() != null && manifestOpenspcoop2.getWeb().getEmptyContext().getEnabled()) {
                    context.append("@EMPTY-CONTEXT@");
                }
                for (int i = 0; i < manifestOpenspcoop2.getWeb().sizeContextList(); ++i) {
                    if (context.length() > 0) {
                        context.append(",");
                    }
                    context.append(manifestOpenspcoop2.getWeb().getContext(i));
                }
                log.info("Protocol loaded with id[" + protocolManifest + "] factory[" + manifestOpenspcoop2.getFactory() + "] contexts[" + context.toString() + "]");
                configPdD.getLog().debug("Init ProtocolFactory for protocol [" + protocolManifest + "] ok");
            }
            this.manifests = new MapReader<String, Openspcoop2>(tmp_manifests, true);
            this.manifestURLs = new MapReader<String, URL>(tmp_manifestURLs, true);
            this.factories = new MapReader(tmp_factories, true);
            this.tipiSoggettiValidi = new MapReader<String, List<String>>(tmp_tipiSoggettiValidi, true);
            this.tipiSoggettiDefault = new MapReader<String, String>(tmp_tipiSoggettiDefault, true);
            this.tipiServiziValidi = new MapReader<String, List<String>>(tmp_tipiServiziValidi, true);
            this.tipiServiziDefault = new MapReader<String, String>(tmp_tipiServiziDefault, true);
            this.versioniValide = new MapReader<String, List<String>>(tmp_versioniValide, true);
            this.versioniDefault = new MapReader<String, String>(tmp_versioniDefault, true);
        }
        catch (Exception e) {
            configPdD.getLog().error("Init ProtocolFactoryManager failed: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("Inizializzazione ProtocolFactoryManager fallita: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifest(ConfigurazionePdD configPdD, URL pluginURL, boolean filtraSenzaErroreProtocolloGiaCaricato, Hashtable<String, Openspcoop2> tmp_manifests, Hashtable<String, URL> tmp_manifestURLs) throws Exception {
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] ...");
        InputStream openStream = null;
        byte[] manifest = null;
        try {
            openStream = pluginURL.openStream();
            manifest = Utilities.getAsByteArray(openStream);
        }
        finally {
            try {
                openStream.close();
            }
            catch (Exception exception) {}
        }
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] convertToOpenSPCoop2Manifest...");
        Openspcoop2 manifestOpenspcoop2 = XMLUtils.getOpenspcoop2Manifest(configPdD.getLog(), manifest);
        String protocollo = manifestOpenspcoop2.getProtocolName();
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] with protocolName: [" + protocollo + "]");
        if (tmp_manifests.containsKey(protocollo)) {
            URL urlGiaPresente = tmp_manifestURLs.get(protocollo);
            if (filtraSenzaErroreProtocolloGiaCaricato) {
                configPdD.getLog().warn("ProtocolName [" + protocollo + "] is same for more plugin [" + pluginURL.toString() + "] and [" + urlGiaPresente.toURI() + "]");
            } else {
                throw new Exception("ProtocolName [" + protocollo + "] is same for more plugin [" + pluginURL.toString() + "] and [" + urlGiaPresente.toURI() + "]");
            }
        }
        tmp_manifests.put(protocollo, manifestOpenspcoop2);
        tmp_manifestURLs.put(protocollo, pluginURL);
        configPdD.getLog().debug("Analyze manifest [" + pluginURL.toString() + "] with success");
    }

    private void validateProtocolFactoryLoaded(Hashtable<String, Openspcoop2> tmp_manifests, Hashtable<String, List<String>> tmp_tipiSoggettiValidi, Hashtable<String, String> tmp_tipiSoggettiDefault, Hashtable<String, List<String>> tmp_tipiServiziValidi, Hashtable<String, String> tmp_tipiServiziDefault, Hashtable<String, List<String>> tmp_versioniValide, Hashtable<String, String> tmp_versioniDefault) throws Exception {
        Enumeration<String> protocolManifestEnum = tmp_manifests.keys();
        String protocolContextEmpty = null;
        while (protocolManifestEnum.hasMoreElements()) {
            String protocolManifest = protocolManifestEnum.nextElement();
            Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            if (manifestOpenspcoop2.getWeb().getEmptyContext() == null || !manifestOpenspcoop2.getWeb().getEmptyContext().getEnabled()) continue;
            if (protocolContextEmpty == null) {
                protocolContextEmpty = protocolManifest;
                continue;
            }
            throw new Exception("Protocols [" + protocolContextEmpty + "] and [" + protocolManifest + "] with empty context. Only one is permitted");
        }
        Hashtable<String, String> mappingContextToProtocol = new Hashtable<String, String>();
        protocolManifestEnum = tmp_manifests.keys();
        while (protocolManifestEnum.hasMoreElements()) {
            String protocolManifest = protocolManifestEnum.nextElement();
            Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            for (int i = 0; i < manifestOpenspcoop2.getWeb().sizeContextList(); ++i) {
                String context = manifestOpenspcoop2.getWeb().getContext(i);
                if (mappingContextToProtocol.containsKey(context)) {
                    throw new Exception("Protocols [" + (String)mappingContextToProtocol.get(context) + "] and [" + protocolManifest + "] with same context [" + context + "]");
                }
                mappingContextToProtocol.put(context, protocolManifest);
            }
        }
        Hashtable<String, String> mappingTipiSoggettiToProtocol = new Hashtable<String, String>();
        protocolManifestEnum = tmp_manifests.keys();
        while (protocolManifestEnum.hasMoreElements()) {
            String protocolManifest = protocolManifestEnum.nextElement();
            Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop2.getRegistroServizi().getSoggetti().getTipi().sizeTipoList();
            if (size <= 0) {
                throw new Exception("Subject type not defined for protocol [" + protocolManifest + "]");
            }
            for (int i = 0; i < size; ++i) {
                String tipo = manifestOpenspcoop2.getRegistroServizi().getSoggetti().getTipi().getTipo(i);
                if (mappingTipiSoggettiToProtocol.containsKey(tipo)) {
                    throw new Exception("Protocols [" + (String)mappingTipiSoggettiToProtocol.get(tipo) + "] and [" + protocolManifest + "] with same subject type [" + tipo + "]");
                }
                mappingTipiSoggettiToProtocol.put(tipo, protocolManifest);
                List<Object> tipiSoggettiPerProtocollo = null;
                tipiSoggettiPerProtocollo = tmp_tipiSoggettiValidi.containsKey(protocolManifest) ? tmp_tipiSoggettiValidi.remove(protocolManifest) : new ArrayList();
                tipiSoggettiPerProtocollo.add(tipo);
                tmp_tipiSoggettiValidi.put(protocolManifest, tipiSoggettiPerProtocollo);
            }
            String tipoDefault = manifestOpenspcoop2.getRegistroServizi().getSoggetti().getTipi().getDefault();
            if (tipoDefault != null) {
                if (!tmp_tipiSoggettiValidi.get(protocolManifest).contains(tipoDefault)) {
                    throw new Exception("Unknown default subject type [" + tipoDefault + "] defined in protocol [" + protocolManifest + "]");
                }
            } else {
                if (size > 1) {
                    throw new Exception("Default subject type not defined. It's required if more than one type is defined (found " + size + " subject types)");
                }
                tipoDefault = manifestOpenspcoop2.getRegistroServizi().getSoggetti().getTipi().getTipo(0);
            }
            tmp_tipiSoggettiDefault.put(protocolManifest, tipoDefault);
        }
        Hashtable<String, String> mappingTipiServiziToProtocol = new Hashtable<String, String>();
        protocolManifestEnum = tmp_manifests.keys();
        while (protocolManifestEnum.hasMoreElements()) {
            String protocolManifest = protocolManifestEnum.nextElement();
            Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop2.getRegistroServizi().getServizi().getTipi().sizeTipoList();
            if (size <= 0) {
                throw new Exception("Service type not defined for protocol [" + protocolManifest + "]");
            }
            for (int i = 0; i < size; ++i) {
                String tipo = manifestOpenspcoop2.getRegistroServizi().getServizi().getTipi().getTipo(i);
                if (mappingTipiServiziToProtocol.containsKey(tipo)) {
                    throw new Exception("Protocols [" + (String)mappingTipiServiziToProtocol.get(tipo) + "] and [" + protocolManifest + "] with same service type [" + tipo + "]");
                }
                mappingTipiServiziToProtocol.put(tipo, protocolManifest);
                List<Object> tipiServiziPerProtocollo = null;
                tipiServiziPerProtocollo = tmp_tipiServiziValidi.containsKey(protocolManifest) ? tmp_tipiServiziValidi.remove(protocolManifest) : new ArrayList();
                tipiServiziPerProtocollo.add(tipo);
                tmp_tipiServiziValidi.put(protocolManifest, tipiServiziPerProtocollo);
            }
            String tipoDefault = manifestOpenspcoop2.getRegistroServizi().getServizi().getTipi().getDefault();
            if (tipoDefault != null) {
                if (!tmp_tipiServiziValidi.get(protocolManifest).contains(tipoDefault)) {
                    throw new Exception("Unknown default service type [" + tipoDefault + "] defined in protocol [" + protocolManifest + "]");
                }
            } else {
                if (size > 1) {
                    throw new Exception("Default service type not defined. It's required if more than one type is defined (found " + size + " service types)");
                }
                tipoDefault = manifestOpenspcoop2.getRegistroServizi().getServizi().getTipi().getTipo(0);
            }
            tmp_tipiServiziDefault.put(protocolManifest, tipoDefault);
        }
        protocolManifestEnum = tmp_manifests.keys();
        while (protocolManifestEnum.hasMoreElements()) {
            String protocolManifest = protocolManifestEnum.nextElement();
            Openspcoop2 manifestOpenspcoop2 = tmp_manifests.get(protocolManifest);
            int size = manifestOpenspcoop2.getRegistroServizi().getVersioni().sizeVersioneList();
            if (size <= 0) {
                throw new Exception("Version not defined for protocol [" + protocolManifest + "]");
            }
            for (int i = 0; i < size; ++i) {
                String version = manifestOpenspcoop2.getRegistroServizi().getVersioni().getVersione(i);
                List<Object> versioniPerProtocollo = null;
                versioniPerProtocollo = tmp_versioniValide.containsKey(protocolManifest) ? tmp_versioniValide.remove(protocolManifest) : new ArrayList();
                versioniPerProtocollo.add(version);
                tmp_versioniValide.put(protocolManifest, versioniPerProtocollo);
            }
            String versioneDefault = manifestOpenspcoop2.getRegistroServizi().getVersioni().getDefault();
            if (versioneDefault != null) {
                if (!tmp_versioniValide.get(protocolManifest).contains(versioneDefault)) {
                    throw new Exception("Unknown default version [" + versioneDefault + "] defined in protocol [" + protocolManifest + "]");
                }
            } else {
                if (size > 1) {
                    throw new Exception("Default version not defined. It's required if more than one type is defined (found " + size + " version)");
                }
                versioneDefault = manifestOpenspcoop2.getRegistroServizi().getVersioni().getVersione(0);
            }
            tmp_versioniDefault.put(protocolManifest, versioneDefault);
        }
    }

    private IProtocolFactory getProtocolFactoryEngine(Openspcoop2 openspcoop2Manifest) throws ProtocolException {
        String factoryClass = null;
        try {
            factoryClass = openspcoop2Manifest.getFactory();
            Class<?> c = Class.forName(factoryClass);
            IProtocolFactory p = (IProtocolFactory)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            return p;
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile caricare la factory indicata [" + factoryClass + "] " + e, e);
        }
    }

    public Openspcoop2 getProtocolManifest(HttpServletRequest request, FunctionContextsCustom customContexts) throws ProtocolException {
        URLProtocolContext urlProtocolContext = null;
        try {
            urlProtocolContext = new URLProtocolContext(request, this.log, customContexts);
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile recuperare il nome del contesto dalla request: ServletContext[" + request.getContextPath() + "] RequestURI[" + request.getRequestURI() + "]", e);
        }
        return this.getProtocolManifest(urlProtocolContext.getProtocol());
    }

    public Openspcoop2 getProtocolManifest(String servletContextName) throws ProtocolException {
        try {
            for (Openspcoop2 openspcoop2Manifest : this.manifests.values()) {
                Web webContext = openspcoop2Manifest.getWeb();
                if ("@EMPTY@".equals(servletContextName)) {
                    if (webContext.getEmptyContext() == null || !webContext.getEmptyContext().getEnabled()) continue;
                    return openspcoop2Manifest;
                }
                for (int i = 0; i < webContext.sizeContextList(); ++i) {
                    if (!webContext.getContext(i).equals(servletContextName)) continue;
                    return openspcoop2Manifest;
                }
            }
            throw new ProtocolException("Contesto [" + servletContextName + "] non assegnato a nessun protocollo");
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile individuare il protocollo assegnato al contesto [" + servletContextName + "]: " + e, e);
        }
    }

    public IProtocolFactory getProtocolFactoryByServletContext(HttpServletRequest request, FunctionContextsCustom customContexts) throws ProtocolException {
        Openspcoop2 m = this.getProtocolManifest(request, customContexts);
        if (this.factories.containsKey(m.getProtocolName())) {
            return this.factories.get(m.getProtocolName());
        }
        throw new ProtocolException("ProtocolPlugin with name [" + m.getProtocolName() + "] not found");
    }

    public IProtocolFactory getProtocolFactoryByServletContext(String servletContext) throws ProtocolException {
        Openspcoop2 m = this.getProtocolManifest(servletContext);
        if (this.factories.containsKey(m.getProtocolName())) {
            return this.factories.get(m.getProtocolName());
        }
        throw new ProtocolException("ProtocolPlugin with name [" + m.getProtocolName() + "] not found");
    }

    public IProtocolFactory getProtocolFactoryByName(String protocol) throws ProtocolException {
        if (this.factories.containsKey(protocol)) {
            return this.factories.get(protocol);
        }
        throw new ProtocolException("ProtocolPlugin with name [" + protocol + "] not found");
    }

    public IProtocolFactory getProtocolFactoryBySubjectType(String subjectType) throws ProtocolException {
        String protocol = this.getProtocolBySubjectType(subjectType);
        return this.getProtocolFactoryByName(protocol);
    }

    public IProtocolFactory getProtocolFactoryByServiceType(String serviceType) throws ProtocolException {
        String protocol = this.getProtocolByServiceType(serviceType);
        return this.getProtocolFactoryByName(protocol);
    }

    public IProtocolFactory getDefaultProtocolFactory() throws ProtocolException {
        try {
            if (this.factories.size() == 1) {
                return this.factories.get(this.factories.keys().nextElement());
            }
            if (this.protocolDefault == null) {
                throw new Exception("Non e' stato definito un protocollo di default e sono stati riscontrati piu' protocolli disponibili (size:" + this.factories.size() + ")");
            }
            if (this.factories.containsKey(this.protocolDefault)) {
                return this.factories.get(this.protocolDefault);
            }
            throw new Exception("Il protocollo di default [" + this.protocolDefault + "] indicato non corrisponde a nessuno di quelli caricati");
        }
        catch (Exception e) {
            throw new ProtocolException("Impossibile individuare il protocollo assegnato al contesto: " + e, e);
        }
    }

    public MapReader<String, List<String>> getSubjectTypes() {
        return this.tipiSoggettiValidi;
    }

    public String[] getSubjectTypesAsArray() {
        Enumeration<List<String>> listeTipiSoggettiValidi = this.tipiSoggettiValidi.elements();
        ArrayList listaTipiSoggetti = new ArrayList();
        while (listeTipiSoggettiValidi.hasMoreElements()) {
            listaTipiSoggetti.addAll(listeTipiSoggettiValidi.nextElement());
        }
        return listaTipiSoggetti.toArray(new String[1]);
    }

    public List<String> getSubjectTypesAsList() {
        Enumeration<List<String>> listeTipiSoggettiValidi = this.tipiSoggettiValidi.elements();
        ArrayList<String> listaTipiSoggetti = new ArrayList<String>();
        while (listeTipiSoggettiValidi.hasMoreElements()) {
            listaTipiSoggetti.addAll((Collection<String>)listeTipiSoggettiValidi.nextElement());
        }
        return listaTipiSoggetti;
    }

    public MapReader<String, String> getDefaultSubjectTypes() {
        return this.tipiSoggettiDefault;
    }

    public MapReader<String, List<String>> getServiceTypes() {
        return this.tipiServiziValidi;
    }

    public String[] getServiceTypesAsArray() {
        Enumeration<List<String>> listeTipiServiziValidi = this.tipiServiziValidi.elements();
        ArrayList listaTipiServizi = new ArrayList();
        while (listeTipiServiziValidi.hasMoreElements()) {
            listaTipiServizi.addAll(listeTipiServiziValidi.nextElement());
        }
        return listaTipiServizi.toArray(new String[1]);
    }

    public List<String> getServiceTypesAsList() {
        Enumeration<List<String>> listeTipiServiziValidi = this.tipiServiziValidi.elements();
        ArrayList<String> listaTipiServizi = new ArrayList<String>();
        while (listeTipiServiziValidi.hasMoreElements()) {
            listaTipiServizi.addAll((Collection<String>)listeTipiServiziValidi.nextElement());
        }
        return listaTipiServizi;
    }

    public MapReader<String, String> getDefaultServiceTypes() {
        return this.tipiServiziDefault;
    }

    public MapReader<String, List<String>> getVersion() {
        return this.versioniValide;
    }

    public String[] getVersionAsArray() {
        Enumeration<List<String>> listeVersioniValidi = this.versioniValide.elements();
        ArrayList listaVersioni = new ArrayList();
        while (listeVersioniValidi.hasMoreElements()) {
            listaVersioni.addAll(listeVersioniValidi.nextElement());
        }
        return listaVersioni.toArray(new String[1]);
    }

    public List<String> getVersionAsList() {
        Enumeration<List<String>> listeVersioniValide = this.versioniValide.elements();
        ArrayList<String> listaVersioni = new ArrayList<String>();
        while (listeVersioniValide.hasMoreElements()) {
            listaVersioni.addAll((Collection<String>)listeVersioniValide.nextElement());
        }
        return listaVersioni;
    }

    public MapReader<String, String> getDefaultVersion() {
        return this.versioniDefault;
    }

    public MapReader<String, IProtocolFactory> getProtocolFactories() {
        return this.factories;
    }

    public Enumeration<String> getProtocolNames() {
        return this.factories.keys();
    }

    public String getProtocolBySubjectType(String subjectType) throws ProtocolException {
        Enumeration<String> protocolli = this.factories.keys();
        while (protocolli.hasMoreElements()) {
            String protocollo = protocolli.nextElement();
            IProtocolFactory protocolFactory = this.factories.get(protocollo);
            List<String> tipiP = protocolFactory.createProtocolConfiguration().getTipiSoggetti();
            if (!tipiP.contains(subjectType)) continue;
            return protocollo;
        }
        throw new ProtocolException("Non esiste un protocollo associato al tipo di soggetto [" + subjectType + "]");
    }

    public String getProtocolByServiceType(String serviceType) throws ProtocolException {
        Enumeration<String> protocolli = this.factories.keys();
        while (protocolli.hasMoreElements()) {
            String protocollo = protocolli.nextElement();
            IProtocolFactory protocolFactory = this.factories.get(protocollo);
            List<String> tipiP = protocolFactory.createProtocolConfiguration().getTipiServizi();
            if (!tipiP.contains(serviceType)) continue;
            return protocollo;
        }
        throw new ProtocolException("Non esiste un protocollo associato al tipo di servizio [" + serviceType + "]");
    }
}

