/*
 * Decompiled with CFR 0.152.
 */
package it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.validator;

import it.link.pdd.tools.migrazione_govway.openspcoop2_core.constants.TipoPdD;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.id.IDSoggetto;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.message.OpenSPCoop2Message;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.basic.validator.ValidatoreErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Busta;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.IProtocolFactory;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.ProtocolException;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.Trasmissione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.IBustaBuilder;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.builder.ProprietaManifestAttachments;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ErroriCooperazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.ProfiloDiCollaborazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.constants.TipoOraRegistrazione;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.state.IState;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.IValidazioneSintattica;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ProprietaValidazioneErrori;
import it.link.pdd.tools.migrazione_govway.openspcoop2_core.protocol.sdk.validator.ValidazioneSintatticaResult;
import it.link.pdd.tools.migrazione_govway.utils.date.DateManager;
import java.util.Date;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import org.slf4j.Logger;

public class ValidazioneSintattica
implements IValidazioneSintattica {
    protected IProtocolFactory protocolFactory;
    private IBustaBuilder bustaBuilder = null;
    protected Logger log;

    public ValidazioneSintattica(IProtocolFactory factory) throws ProtocolException {
        this.log = factory.getLogger();
        this.protocolFactory = factory;
        this.bustaBuilder = this.protocolFactory.createBustaBuilder();
    }

    @Override
    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public ValidazioneSintatticaResult validaRichiesta(IState state, OpenSPCoop2Message msg, Busta datiBustaLettiURLMappingProperties, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        Busta busta = null;
        busta = datiBustaLettiURLMappingProperties != null ? datiBustaLettiURLMappingProperties : new Busta(this.protocolFactory.getProtocol());
        Date oraRegistrazione = DateManager.getDate();
        busta.setOraRegistrazione(oraRegistrazione);
        if (busta.getTipoOraRegistrazione() == null) {
            busta.setTipoOraRegistrazione(TipoOraRegistrazione.LOCALE, this.protocolFactory.createTraduttore().toString(busta.getTipoOraRegistrazione()));
        }
        if (busta.sizeListaTrasmissioni() > 0) {
            for (Trasmissione trasmissione : busta.getListaTrasmissioni()) {
                if (trasmissione.getOraRegistrazione() == null) {
                    trasmissione.setOraRegistrazione(oraRegistrazione);
                }
                if (trasmissione.getTempo() != null) continue;
                trasmissione.setTempo(TipoOraRegistrazione.LOCALE, this.protocolFactory.createTraduttore().toString(busta.getTipoOraRegistrazione()));
            }
        }
        return new ValidazioneSintatticaResult(null, null, null, busta, null, null, null, true);
    }

    @Override
    public ValidazioneSintatticaResult validaRisposta(IState state, OpenSPCoop2Message msg, Busta bustaRichiesta, ProprietaValidazioneErrori proprietaValidazioneErrori) throws ProtocolException {
        Busta bustaRisposta = bustaRichiesta.invertiBusta(bustaRichiesta.getTipoOraRegistrazione(), bustaRichiesta.getTipoOraRegistrazioneValue());
        bustaRisposta.setRiferimentoMessaggio(bustaRichiesta.getID());
        bustaRisposta.setProfiloDiCollaborazione(bustaRichiesta.getProfiloDiCollaborazione(), bustaRichiesta.getProfiloDiCollaborazioneValue());
        bustaRisposta.setTipoServizio(bustaRichiesta.getTipoServizio());
        bustaRisposta.setServizio(bustaRichiesta.getServizio());
        bustaRisposta.setVersioneServizio(bustaRichiesta.getVersioneServizio());
        bustaRisposta.setAzione(bustaRichiesta.getAzione());
        String idSenzaData = null;
        try {
            Date d = this.bustaBuilder.extractDateFromID(bustaRichiesta.getID());
            if (d != null) {
                String[] split = bustaRichiesta.getID().split("-");
                idSenzaData = bustaRichiesta.getID().substring(split[0].length() + 1);
            } else {
                idSenzaData = bustaRichiesta.getID();
            }
        }
        catch (Exception e) {
            throw new ProtocolException("Identificativo di richiesta in un formato errato, estrazione della data non riuscita: " + e.getMessage(), e);
        }
        bustaRisposta.setID(this.bustaBuilder.newID(state, new IDSoggetto(bustaRisposta.getTipoMittente(), bustaRisposta.getMittente(), bustaRisposta.getIdentificativoPortaMittente()), idSenzaData, false));
        bustaRisposta.setInoltro(bustaRichiesta.getInoltro(), bustaRichiesta.getInoltroValue());
        if (bustaRichiesta.sizeListaTrasmissioni() == 1) {
            bustaRisposta.addTrasmissione(bustaRichiesta.getTrasmissione(0).invertiTrasmissione(bustaRichiesta.getTipoOraRegistrazione(), bustaRichiesta.getTipoOraRegistrazioneValue()));
        }
        boolean hasFault = false;
        try {
            hasFault = msg.getSOAPBody().hasFault();
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
        if (hasFault) {
            ValidatoreErrori validatoreErrori = new ValidatoreErrori(this.protocolFactory);
            if (bustaRisposta.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.ONEWAY)) {
                if (validatoreErrori.isBustaErrore(bustaRichiesta, msg, proprietaValidazioneErrori)) {
                    return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
                }
                return new ValidazioneSintatticaResult(null, null, null, null, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Analizzato un messaggio fault"), bustaRisposta, null, false);
            }
            if (bustaRisposta.getProfiloDiCollaborazione().equals(ProfiloDiCollaborazione.SINCRONO)) {
                if (validatoreErrori.isBustaErrore(bustaRichiesta, msg, proprietaValidazioneErrori)) {
                    return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, ErroriCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.getErroreProcessamento("Analizzato un messaggio fault"), bustaRisposta, null, true);
                }
                return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
            }
        }
        return new ValidazioneSintatticaResult(null, null, null, bustaRisposta, null, null, null, true);
    }

    @Override
    public boolean verifyProtocolPresence(TipoPdD tipoPdD, ProfiloDiCollaborazione profilo, boolean isRichiesta, OpenSPCoop2Message msg) throws ProtocolException {
        if (TipoPdD.DELEGATA.equals(tipoPdD)) {
            if (isRichiesta) {
                return false;
            }
            return !ProfiloDiCollaborazione.ONEWAY.equals(profilo);
        }
        if (TipoPdD.APPLICATIVA.equals(tipoPdD)) {
            return isRichiesta;
        }
        if (TipoPdD.ROUTER.equals(tipoPdD)) {
            if (isRichiesta) {
                return true;
            }
            return !ProfiloDiCollaborazione.ONEWAY.equals(profilo);
        }
        throw new ProtocolException("TipoPdD [" + tipoPdD + "] non gestito");
    }

    @Override
    public ValidazioneSintatticaResult validazioneFault(SOAPBody body) {
        return null;
    }

    @Override
    public ValidazioneSintatticaResult validazioneManifestAttachments(OpenSPCoop2Message msg, ProprietaManifestAttachments proprietaManifestAttachments) {
        return null;
    }

    @Override
    public SOAPElement getHeaderProtocollo_senzaControlli(OpenSPCoop2Message msg) throws ProtocolException {
        return null;
    }

    @Override
    public SOAPElement getHeaderProtocollo(Busta busta) {
        return null;
    }
}

